/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopenglshaderprogram_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QOpenGLShaderProgramWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QOpenGLShaderProgramWrapper::QOpenGLShaderProgramWrapper(::QObject * parent) : QOpenGLShaderProgram(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QOpenGLShaderProgramWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QOpenGLShaderProgramWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QOpenGLShaderProgramWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QOpenGLShaderProgramWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QOpenGLShaderProgramWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLShaderProgram.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QOpenGLShaderProgramWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLShaderProgram.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QOpenGLShaderProgramWrapper::link()
{
    if (m_PyMethodCache[6])
        return this->::QOpenGLShaderProgram::link();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "link";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QOpenGLShaderProgram::link();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLShaderProgram.link", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QOpenGLShaderProgramWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QOpenGLShaderProgramWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QOpenGLShaderProgram::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QOpenGLShaderProgramWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QOpenGLShaderProgram::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QOpenGLShaderProgramWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QOpenGLShaderProgramWrapper *>(this));
        return QOpenGLShaderProgram::qt_metacast(_clname);
}

QOpenGLShaderProgramWrapper::~QOpenGLShaderProgramWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLShaderProgram_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLShaderProgram >()))
        return -1;

    ::QOpenGLShaderProgramWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QOpenGLShaderProgram", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::QOpenGLShaderProgram(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QOpenGLShaderProgram(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QOpenGLShaderProgram(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgram_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLShaderProgram_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QOpenGLShaderProgram_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QOpenGLShaderProgram(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QOpenGLShaderProgramWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QOpenGLShaderProgramWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLShaderProgram >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOpenGLShaderProgram_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QOpenGLShaderProgram_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QOpenGLShaderProgram_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_addCacheableShaderFromSourceCode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.addCacheableShaderFromSourceCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addCacheableShaderFromSourceCode", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QByteArray)
    // 1: QOpenGLShaderProgram::addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
    // 2: QOpenGLShaderProgram::addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,const char*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 2; // addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,const char*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 0; // addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QByteArray)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_addCacheableShaderFromSourceCode_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit> type, const QByteArray & source)
        {
            ::QFlags<QOpenGLShader::ShaderTypeBit> cppArg0 = QFlags<QOpenGLShader::ShaderTypeBit>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QByteArray)
                bool cppResult = cppSelf->addCacheableShaderFromSourceCode(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit> type, const QString & source)
        {
            ::QFlags<QOpenGLShader::ShaderTypeBit> cppArg0 = QFlags<QOpenGLShader::ShaderTypeBit>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
                bool cppResult = cppSelf->addCacheableShaderFromSourceCode(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit> type, const char * source)
        {
            ::QFlags<QOpenGLShader::ShaderTypeBit> cppArg0 = QFlags<QOpenGLShader::ShaderTypeBit>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addCacheableShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,const char*)
                bool cppResult = cppSelf->addCacheableShaderFromSourceCode(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLShaderProgramFunc_addCacheableShaderFromSourceCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_addCacheableShaderFromSourceFile(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.addCacheableShaderFromSourceFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addCacheableShaderFromSourceFile", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::addCacheableShaderFromSourceFile(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // addCacheableShaderFromSourceFile(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_addCacheableShaderFromSourceFile_TypeError;

    // Call function/method
    {
        ::QFlags<QOpenGLShader::ShaderTypeBit> cppArg0 = QFlags<QOpenGLShader::ShaderTypeBit>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addCacheableShaderFromSourceFile(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
            bool cppResult = cppSelf->addCacheableShaderFromSourceFile(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLShaderProgramFunc_addCacheableShaderFromSourceFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_addShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.addShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::addShader(QOpenGLShader*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX]), (pyArg)))) {
        overloadId = 0; // addShader(QOpenGLShader*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_addShader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QOpenGLShader *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addShader(QOpenGLShader*)
            bool cppResult = cppSelf->addShader(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLShaderProgramFunc_addShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_addShaderFromSourceCode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.addShaderFromSourceCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addShaderFromSourceCode", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QByteArray)
    // 1: QOpenGLShaderProgram::addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
    // 2: QOpenGLShaderProgram::addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,const char*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 2; // addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,const char*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 0; // addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QByteArray)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_addShaderFromSourceCode_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit> type, const QByteArray & source)
        {
            ::QFlags<QOpenGLShader::ShaderTypeBit> cppArg0 = QFlags<QOpenGLShader::ShaderTypeBit>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QByteArray)
                bool cppResult = cppSelf->addShaderFromSourceCode(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit> type, const QString & source)
        {
            ::QFlags<QOpenGLShader::ShaderTypeBit> cppArg0 = QFlags<QOpenGLShader::ShaderTypeBit>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
                bool cppResult = cppSelf->addShaderFromSourceCode(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit> type, const char * source)
        {
            ::QFlags<QOpenGLShader::ShaderTypeBit> cppArg0 = QFlags<QOpenGLShader::ShaderTypeBit>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addShaderFromSourceCode(QFlags<QOpenGLShader::ShaderTypeBit>,const char*)
                bool cppResult = cppSelf->addShaderFromSourceCode(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLShaderProgramFunc_addShaderFromSourceCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_addShaderFromSourceFile(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.addShaderFromSourceFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addShaderFromSourceFile", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::addShaderFromSourceFile(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QOPENGLSHADER_SHADERTYPEBIT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // addShaderFromSourceFile(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_addShaderFromSourceFile_TypeError;

    // Call function/method
    {
        ::QFlags<QOpenGLShader::ShaderTypeBit> cppArg0 = QFlags<QOpenGLShader::ShaderTypeBit>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addShaderFromSourceFile(QFlags<QOpenGLShader::ShaderTypeBit>,QString)
            bool cppResult = cppSelf->addShaderFromSourceFile(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLShaderProgramFunc_addShaderFromSourceFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_attributeLocation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.attributeLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::attributeLocation(QByteArray)const
    // 1: QOpenGLShaderProgram::attributeLocation(QString)const
    // 2: QOpenGLShaderProgram::attributeLocation(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 2; // attributeLocation(const char*)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // attributeLocation(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // attributeLocation(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_attributeLocation_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // attributeLocation(const QByteArray & name) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // attributeLocation(QByteArray)const
                int cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->attributeLocation(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // attributeLocation(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // attributeLocation(QString)const
                int cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->attributeLocation(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 2: // attributeLocation(const char * name) const
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // attributeLocation(const char*)const
                int cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->attributeLocation(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLShaderProgramFunc_attributeLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_bind(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.bind";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bind()
            bool cppResult = cppSelf->bind();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_bindAttributeLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.bindAttributeLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "bindAttributeLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::bindAttributeLocation(QByteArray,int)
    // 1: QOpenGLShaderProgram::bindAttributeLocation(QString,int)
    // 2: QOpenGLShaderProgram::bindAttributeLocation(const char*,int)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 2; // bindAttributeLocation(const char*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // bindAttributeLocation(QString,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // bindAttributeLocation(QByteArray,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_bindAttributeLocation_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // bindAttributeLocation(const QByteArray & name, int location)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bindAttributeLocation(QByteArray,int)
                cppSelf->bindAttributeLocation(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // bindAttributeLocation(const QString & name, int location)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bindAttributeLocation(QString,int)
                cppSelf->bindAttributeLocation(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // bindAttributeLocation(const char * name, int location)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bindAttributeLocation(const char*,int)
                cppSelf->bindAttributeLocation(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_bindAttributeLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_create(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.create";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // create()
            bool cppResult = cppSelf->create();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_defaultInnerTessellationLevels(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.defaultInnerTessellationLevels";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultInnerTessellationLevels()const
            QVector<float > cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->defaultInnerTessellationLevels();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_FLOAT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_defaultOuterTessellationLevels(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.defaultOuterTessellationLevels";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultOuterTessellationLevels()const
            QVector<float > cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->defaultOuterTessellationLevels();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_FLOAT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_disableAttributeArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.disableAttributeArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::disableAttributeArray(const char*)
    // 1: QOpenGLShaderProgram::disableAttributeArray(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // disableAttributeArray(int)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // disableAttributeArray(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_disableAttributeArray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // disableAttributeArray(const char * name)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // disableAttributeArray(const char*)
                cppSelf->disableAttributeArray(cppArg0);
            }
            break;
        }
        case 1: // disableAttributeArray(int location)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // disableAttributeArray(int)
                cppSelf->disableAttributeArray(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_disableAttributeArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_enableAttributeArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.enableAttributeArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::enableAttributeArray(const char*)
    // 1: QOpenGLShaderProgram::enableAttributeArray(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // enableAttributeArray(int)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // enableAttributeArray(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_enableAttributeArray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // enableAttributeArray(const char * name)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // enableAttributeArray(const char*)
                cppSelf->enableAttributeArray(cppArg0);
            }
            break;
        }
        case 1: // enableAttributeArray(int location)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // enableAttributeArray(int)
                cppSelf->enableAttributeArray(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_enableAttributeArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_hasOpenGLShaderPrograms(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.hasOpenGLShaderPrograms";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:hasOpenGLShaderPrograms", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QOpenGLShaderProgram::hasOpenGLShaderPrograms(QOpenGLContext*)
    if (numArgs == 0) {
        overloadId = 0; // hasOpenGLShaderPrograms(QOpenGLContext*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // hasOpenGLShaderPrograms(QOpenGLContext*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_context = Shiboken::String::createStaticString("context");
            if (PyDict_Contains(kwds, key_context)) {
                value = PyDict_GetItem(kwds, key_context);
                if (value && pyArgs[0]) {
                    errInfo = key_context;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), (pyArgs[0]))))
                        goto Sbk_QOpenGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_context);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QOpenGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QOpenGLContext *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // hasOpenGLShaderPrograms(QOpenGLContext*)
            bool cppResult = ::QOpenGLShaderProgram::hasOpenGLShaderPrograms(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_isLinked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.isLinked";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLinked()const
            bool cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->isLinked();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_link(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.link";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // link()
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QOpenGLShaderProgram::link()
                : cppSelf->link();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_log(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.log";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // log()const
            QString cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->log();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_maxGeometryOutputVertices(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.maxGeometryOutputVertices";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxGeometryOutputVertices()const
            int cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->maxGeometryOutputVertices();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_patchVertexCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.patchVertexCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // patchVertexCount()const
            int cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->patchVertexCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_programId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.programId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // programId()const
            unsigned int cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->programId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_release(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.release";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // release()
            cppSelf->release();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_removeAllShaders(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.removeAllShaders";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeAllShaders()
            cppSelf->removeAllShaders();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_removeShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.removeShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::removeShader(QOpenGLShader*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX]), (pyArg)))) {
        overloadId = 0; // removeShader(QOpenGLShader*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_removeShader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QOpenGLShader *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeShader(QOpenGLShader*)
            cppSelf->removeShader(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_removeShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_setAttributeArray(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.setAttributeArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:setAttributeArray", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::setAttributeArray(const char*,const float*,int,int)
    // 1: QOpenGLShaderProgram::setAttributeArray(const char*,uint,const void*,int,int)
    // 2: QOpenGLShaderProgram::setAttributeArray(int,const float*,int,int)
    // 3: QOpenGLShaderProgram::setAttributeArray(int,uint,const void*,int,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs >= 4
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 3; // setAttributeArray(int,uint,const void*,int,int)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                overloadId = 3; // setAttributeArray(int,uint,const void*,int,int)
            }
        } else if (numArgs >= 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 2; // setAttributeArray(int,const float*,int,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                overloadId = 2; // setAttributeArray(int,const float*,int,int)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs >= 4
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 1; // setAttributeArray(const char*,uint,const void*,int,int)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                overloadId = 1; // setAttributeArray(const char*,uint,const void*,int,int)
            }
        } else if (numArgs >= 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // setAttributeArray(const char*,const float*,int,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                overloadId = 0; // setAttributeArray(const char*,const float*,int,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setAttributeArray(const char * name, const float * values, int tupleSize, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[3]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::ArrayHandle<float> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = 0;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setAttributeArray(const char*,const float*,int,int)
                cppSelf->setAttributeArray(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // setAttributeArray(const char * name, unsigned int type, const void * values, int tupleSize, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[4]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            unsigned int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            void* cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = 0;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setAttributeArray(const char*,uint,const void*,int,int)
                cppSelf->setAttributeArray(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 2: // setAttributeArray(int location, const float * values, int tupleSize, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[3]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::ArrayHandle<float> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = 0;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setAttributeArray(int,const float*,int,int)
                cppSelf->setAttributeArray(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 3: // setAttributeArray(int location, unsigned int type, const void * values, int tupleSize, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[4]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            unsigned int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            void* cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = 0;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setAttributeArray(int,uint,const void*,int,int)
                cppSelf->setAttributeArray(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_setAttributeArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.setAttributeBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer_TypeError;
    } else if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:setAttributeBuffer", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::setAttributeBuffer(const char*,uint,int,int,int)
    // 1: QOpenGLShaderProgram::setAttributeBuffer(int,uint,int,int,int)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 1; // setAttributeBuffer(int,uint,int,int,int)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
            overloadId = 1; // setAttributeBuffer(int,uint,int,int,int)
        }
    } else if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // setAttributeBuffer(const char*,uint,int,int,int)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
            overloadId = 0; // setAttributeBuffer(const char*,uint,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setAttributeBuffer(const char * name, unsigned int type, int offset, int tupleSize, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[4]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            unsigned int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = 0;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setAttributeBuffer(const char*,uint,int,int,int)
                cppSelf->setAttributeBuffer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 1: // setAttributeBuffer(int location, unsigned int type, int offset, int tupleSize, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[4]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            unsigned int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = 0;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setAttributeBuffer(int,uint,int,int,int)
                cppSelf->setAttributeBuffer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_setAttributeValue(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setAttributeValue", 2, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::setAttributeValue(const char*,QColor)
    // 1: QOpenGLShaderProgram::setAttributeValue(const char*,QVector2D)
    // 2: QOpenGLShaderProgram::setAttributeValue(const char*,QVector3D)
    // 3: QOpenGLShaderProgram::setAttributeValue(const char*,QVector4D)
    // 4: QOpenGLShaderProgram::setAttributeValue(const char*,const float*,int,int)
    // 5: QOpenGLShaderProgram::setAttributeValue(const char*,float)
    // 6: QOpenGLShaderProgram::setAttributeValue(const char*,float,float)
    // 7: QOpenGLShaderProgram::setAttributeValue(const char*,float,float,float)
    // 8: QOpenGLShaderProgram::setAttributeValue(const char*,float,float,float,float)
    // 9: QOpenGLShaderProgram::setAttributeValue(int,QColor)
    // 10: QOpenGLShaderProgram::setAttributeValue(int,QVector2D)
    // 11: QOpenGLShaderProgram::setAttributeValue(int,QVector3D)
    // 12: QOpenGLShaderProgram::setAttributeValue(int,QVector4D)
    // 13: QOpenGLShaderProgram::setAttributeValue(int,const float*,int,int)
    // 14: QOpenGLShaderProgram::setAttributeValue(int,float)
    // 15: QOpenGLShaderProgram::setAttributeValue(int,float,float)
    // 16: QOpenGLShaderProgram::setAttributeValue(int,float,float,float)
    // 17: QOpenGLShaderProgram::setAttributeValue(int,float,float,float,float)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 14; // setAttributeValue(int,float)
            } else if (numArgs >= 3
                && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 15; // setAttributeValue(int,float,float)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 16; // setAttributeValue(int,float,float,float)
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))) {
                        overloadId = 17; // setAttributeValue(int,float,float,float,float)
                    }
                }
            } else if (numArgs == 4
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                overloadId = 13; // setAttributeValue(int,const float*,int,int)
            }
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[1])))) {
            overloadId = 10; // setAttributeValue(int,QVector2D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[1])))) {
            overloadId = 11; // setAttributeValue(int,QVector3D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArgs[1])))) {
            overloadId = 12; // setAttributeValue(int,QVector4D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            overloadId = 9; // setAttributeValue(int,QColor)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 5; // setAttributeValue(const char*,float)
            } else if (numArgs >= 3
                && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 6; // setAttributeValue(const char*,float,float)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 7; // setAttributeValue(const char*,float,float,float)
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))) {
                        overloadId = 8; // setAttributeValue(const char*,float,float,float,float)
                    }
                }
            } else if (numArgs == 4
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                overloadId = 4; // setAttributeValue(const char*,const float*,int,int)
            }
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[1])))) {
            overloadId = 1; // setAttributeValue(const char*,QVector2D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[1])))) {
            overloadId = 2; // setAttributeValue(const char*,QVector3D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArgs[1])))) {
            overloadId = 3; // setAttributeValue(const char*,QVector4D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            overloadId = 0; // setAttributeValue(const char*,QColor)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_setAttributeValue_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setAttributeValue(const char * name, const QColor & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,QColor)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // setAttributeValue(const char * name, const QVector2D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector2D cppArg1_local;
            ::QVector2D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,QVector2D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // setAttributeValue(const char * name, const QVector3D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector3D cppArg1_local;
            ::QVector3D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,QVector3D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 3: // setAttributeValue(const char * name, const QVector4D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector4D cppArg1_local;
            ::QVector4D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,QVector4D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 4: // setAttributeValue(const char * name, const float * values, int columns, int rows)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::ArrayHandle<float> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,const float*,int,int)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 5: // setAttributeValue(const char * name, float value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,float)
                cppSelf->setAttributeValue(cppArg0, cppArg1);
            }
            break;
        }
        case 6: // setAttributeValue(const char * name, float x, float y)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,float,float)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 7: // setAttributeValue(const char * name, float x, float y, float z)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,float,float,float)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 8: // setAttributeValue(const char * name, float x, float y, float z, float w)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            float cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,float,float,float,float)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 9: // setAttributeValue(int location, const QColor & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(int,QColor)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 10: // setAttributeValue(int location, const QVector2D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector2D cppArg1_local;
            ::QVector2D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(int,QVector2D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 11: // setAttributeValue(int location, const QVector3D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector3D cppArg1_local;
            ::QVector3D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(int,QVector3D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 12: // setAttributeValue(int location, const QVector4D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector4D cppArg1_local;
            ::QVector4D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(int,QVector4D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 13: // setAttributeValue(int location, const float * values, int columns, int rows)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::ArrayHandle<float> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setAttributeValue(int,const float*,int,int)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 14: // setAttributeValue(int location, float value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setAttributeValue(int,float)
                cppSelf->setAttributeValue(cppArg0, cppArg1);
            }
            break;
        }
        case 15: // setAttributeValue(int location, float x, float y)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setAttributeValue(int,float,float)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 16: // setAttributeValue(int location, float x, float y, float z)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setAttributeValue(int,float,float,float)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 17: // setAttributeValue(int location, float x, float y, float z, float w)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            float cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setAttributeValue(int,float,float,float,float)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_setAttributeValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_setDefaultInnerTessellationLevels(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.setDefaultInnerTessellationLevels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::setDefaultInnerTessellationLevels(QVector<float>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_FLOAT_IDX], (pyArg)))) {
        overloadId = 0; // setDefaultInnerTessellationLevels(QVector<float>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_setDefaultInnerTessellationLevels_TypeError;

    // Call function/method
    {
        ::QVector<float > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultInnerTessellationLevels(QVector<float>)
            cppSelf->setDefaultInnerTessellationLevels(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_setDefaultInnerTessellationLevels_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_setDefaultOuterTessellationLevels(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.setDefaultOuterTessellationLevels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::setDefaultOuterTessellationLevels(QVector<float>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_FLOAT_IDX], (pyArg)))) {
        overloadId = 0; // setDefaultOuterTessellationLevels(QVector<float>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_setDefaultOuterTessellationLevels_TypeError;

    // Call function/method
    {
        ::QVector<float > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultOuterTessellationLevels(QVector<float>)
            cppSelf->setDefaultOuterTessellationLevels(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_setDefaultOuterTessellationLevels_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_setPatchVertexCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.setPatchVertexCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::setPatchVertexCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPatchVertexCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_setPatchVertexCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPatchVertexCount(int)
            cppSelf->setPatchVertexCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_setPatchVertexCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_setUniformValue(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.setUniformValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValue", 2, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::setUniformValue(const char*,QColor)
    // 1: QOpenGLShaderProgram::setUniformValue(const char*,QMatrix2x2)
    // 2: QOpenGLShaderProgram::setUniformValue(const char*,QMatrix2x3)
    // 3: QOpenGLShaderProgram::setUniformValue(const char*,QMatrix2x4)
    // 4: QOpenGLShaderProgram::setUniformValue(const char*,QMatrix3x2)
    // 5: QOpenGLShaderProgram::setUniformValue(const char*,QMatrix3x3)
    // 6: QOpenGLShaderProgram::setUniformValue(const char*,QMatrix3x4)
    // 7: QOpenGLShaderProgram::setUniformValue(const char*,QMatrix4x2)
    // 8: QOpenGLShaderProgram::setUniformValue(const char*,QMatrix4x3)
    // 9: QOpenGLShaderProgram::setUniformValue(const char*,QMatrix4x4)
    // 10: QOpenGLShaderProgram::setUniformValue(const char*,QPoint)
    // 11: QOpenGLShaderProgram::setUniformValue(const char*,QPointF)
    // 12: QOpenGLShaderProgram::setUniformValue(const char*,QSize)
    // 13: QOpenGLShaderProgram::setUniformValue(const char*,QSizeF)
    // 14: QOpenGLShaderProgram::setUniformValue(const char*,QTransform)
    // 15: QOpenGLShaderProgram::setUniformValue(const char*,QVector2D)
    // 16: QOpenGLShaderProgram::setUniformValue(const char*,QVector3D)
    // 17: QOpenGLShaderProgram::setUniformValue(const char*,QVector4D)
    // 18: QOpenGLShaderProgram::setUniformValue(const char*,const float[2][2])
    // 19: QOpenGLShaderProgram::setUniformValue(const char*,const float[3][3])
    // 20: QOpenGLShaderProgram::setUniformValue(const char*,const float[4][4])
    // 21: QOpenGLShaderProgram::setUniformValue(const char*,float,float)
    // 22: QOpenGLShaderProgram::setUniformValue(const char*,float,float,float)
    // 23: QOpenGLShaderProgram::setUniformValue(const char*,float,float,float,float)
    // 24: QOpenGLShaderProgram::setUniformValue(int,QColor)
    // 25: QOpenGLShaderProgram::setUniformValue(int,QMatrix2x2)
    // 26: QOpenGLShaderProgram::setUniformValue(int,QMatrix2x3)
    // 27: QOpenGLShaderProgram::setUniformValue(int,QMatrix2x4)
    // 28: QOpenGLShaderProgram::setUniformValue(int,QMatrix3x2)
    // 29: QOpenGLShaderProgram::setUniformValue(int,QMatrix3x3)
    // 30: QOpenGLShaderProgram::setUniformValue(int,QMatrix3x4)
    // 31: QOpenGLShaderProgram::setUniformValue(int,QMatrix4x2)
    // 32: QOpenGLShaderProgram::setUniformValue(int,QMatrix4x3)
    // 33: QOpenGLShaderProgram::setUniformValue(int,QMatrix4x4)
    // 34: QOpenGLShaderProgram::setUniformValue(int,QPoint)
    // 35: QOpenGLShaderProgram::setUniformValue(int,QPointF)
    // 36: QOpenGLShaderProgram::setUniformValue(int,QSize)
    // 37: QOpenGLShaderProgram::setUniformValue(int,QSizeF)
    // 38: QOpenGLShaderProgram::setUniformValue(int,QTransform)
    // 39: QOpenGLShaderProgram::setUniformValue(int,QVector2D)
    // 40: QOpenGLShaderProgram::setUniformValue(int,QVector3D)
    // 41: QOpenGLShaderProgram::setUniformValue(int,QVector4D)
    // 42: QOpenGLShaderProgram::setUniformValue(int,const float[2][2])
    // 43: QOpenGLShaderProgram::setUniformValue(int,const float[3][3])
    // 44: QOpenGLShaderProgram::setUniformValue(int,const float[4][4])
    // 45: QOpenGLShaderProgram::setUniformValue(int,float)
    // 46: QOpenGLShaderProgram::setUniformValue(int,float,float)
    // 47: QOpenGLShaderProgram::setUniformValue(int,float,float,float)
    // 48: QOpenGLShaderProgram::setUniformValue(int,float,float,float,float)
    // 49: QOpenGLShaderProgram::setUniformValue(int,int)
    // 50: QOpenGLShaderProgram::setUniformValue(int,uint)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
            overloadId = 50; // setUniformValue(int,uint)
        } else if (numArgs >= 2
            && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 45; // setUniformValue(int,float)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 46; // setUniformValue(int,float,float)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 47; // setUniformValue(int,float,float,float)
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))) {
                        overloadId = 48; // setUniformValue(int,float,float,float,float)
                    }
                }
            }
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 49; // setUniformValue(int,int)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<const float>(2), 4, 4, (pyArgs[1])))) {
            overloadId = 44; // setUniformValue(int,const float[4][4])
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<const float>(2), 3, 3, (pyArgs[1])))) {
            overloadId = 43; // setUniformValue(int,const float[3][3])
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<const float>(2), 2, 2, (pyArgs[1])))) {
            overloadId = 42; // setUniformValue(int,const float[2][2])
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[1])))) {
            overloadId = 39; // setUniformValue(int,QVector2D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[1])))) {
            overloadId = 40; // setUniformValue(int,QVector3D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArgs[1])))) {
            overloadId = 41; // setUniformValue(int,QVector4D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[1])))) {
            overloadId = 38; // setUniformValue(int,QTransform)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
            overloadId = 36; // setUniformValue(int,QSize)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[1])))) {
            overloadId = 37; // setUniformValue(int,QSizeF)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
            overloadId = 34; // setUniformValue(int,QPoint)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
            overloadId = 35; // setUniformValue(int,QPointF)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArgs[1])))) {
            overloadId = 33; // setUniformValue(int,QMatrix4x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X3_IDX]), (pyArgs[1])))) {
            overloadId = 32; // setUniformValue(int,QMatrix4x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), (pyArgs[1])))) {
            overloadId = 31; // setUniformValue(int,QMatrix4x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X4_IDX]), (pyArgs[1])))) {
            overloadId = 30; // setUniformValue(int,QMatrix3x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), (pyArgs[1])))) {
            overloadId = 29; // setUniformValue(int,QMatrix3x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X2_IDX]), (pyArgs[1])))) {
            overloadId = 28; // setUniformValue(int,QMatrix3x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X4_IDX]), (pyArgs[1])))) {
            overloadId = 27; // setUniformValue(int,QMatrix2x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X3_IDX]), (pyArgs[1])))) {
            overloadId = 26; // setUniformValue(int,QMatrix2x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X2_IDX]), (pyArgs[1])))) {
            overloadId = 25; // setUniformValue(int,QMatrix2x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            overloadId = 24; // setUniformValue(int,QColor)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs >= 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 21; // setUniformValue(const char*,float,float)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 22; // setUniformValue(const char*,float,float,float)
                } else if (numArgs == 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))) {
                    overloadId = 23; // setUniformValue(const char*,float,float,float,float)
                }
            }
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<const float>(2), 4, 4, (pyArgs[1])))) {
            overloadId = 20; // setUniformValue(const char*,const float[4][4])
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<const float>(2), 3, 3, (pyArgs[1])))) {
            overloadId = 19; // setUniformValue(const char*,const float[3][3])
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<const float>(2), 2, 2, (pyArgs[1])))) {
            overloadId = 18; // setUniformValue(const char*,const float[2][2])
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[1])))) {
            overloadId = 15; // setUniformValue(const char*,QVector2D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[1])))) {
            overloadId = 16; // setUniformValue(const char*,QVector3D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArgs[1])))) {
            overloadId = 17; // setUniformValue(const char*,QVector4D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[1])))) {
            overloadId = 14; // setUniformValue(const char*,QTransform)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
            overloadId = 12; // setUniformValue(const char*,QSize)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[1])))) {
            overloadId = 13; // setUniformValue(const char*,QSizeF)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
            overloadId = 10; // setUniformValue(const char*,QPoint)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
            overloadId = 11; // setUniformValue(const char*,QPointF)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArgs[1])))) {
            overloadId = 9; // setUniformValue(const char*,QMatrix4x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X3_IDX]), (pyArgs[1])))) {
            overloadId = 8; // setUniformValue(const char*,QMatrix4x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), (pyArgs[1])))) {
            overloadId = 7; // setUniformValue(const char*,QMatrix4x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X4_IDX]), (pyArgs[1])))) {
            overloadId = 6; // setUniformValue(const char*,QMatrix3x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), (pyArgs[1])))) {
            overloadId = 5; // setUniformValue(const char*,QMatrix3x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X2_IDX]), (pyArgs[1])))) {
            overloadId = 4; // setUniformValue(const char*,QMatrix3x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X4_IDX]), (pyArgs[1])))) {
            overloadId = 3; // setUniformValue(const char*,QMatrix2x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X3_IDX]), (pyArgs[1])))) {
            overloadId = 2; // setUniformValue(const char*,QMatrix2x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X2_IDX]), (pyArgs[1])))) {
            overloadId = 1; // setUniformValue(const char*,QMatrix2x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            overloadId = 0; // setUniformValue(const char*,QColor)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_setUniformValue_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValue(const char * name, const QColor & color)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QColor)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // setUniformValue(const char * name, const QMatrix2x2 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x2 cppArg1_local;
            ::QMatrix2x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix2x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // setUniformValue(const char * name, const QMatrix2x3 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x3 cppArg1_local;
            ::QMatrix2x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix2x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 3: // setUniformValue(const char * name, const QMatrix2x4 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x4 cppArg1_local;
            ::QMatrix2x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix2x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 4: // setUniformValue(const char * name, const QMatrix3x2 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x2 cppArg1_local;
            ::QMatrix3x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix3x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 5: // setUniformValue(const char * name, const QMatrix3x3 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x3 cppArg1_local;
            ::QMatrix3x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix3x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 6: // setUniformValue(const char * name, const QMatrix3x4 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x4 cppArg1_local;
            ::QMatrix3x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix3x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 7: // setUniformValue(const char * name, const QMatrix4x2 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x2 cppArg1_local;
            ::QMatrix4x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix4x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 8: // setUniformValue(const char * name, const QMatrix4x3 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x3 cppArg1_local;
            ::QMatrix4x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix4x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 9: // setUniformValue(const char * name, const QMatrix4x4 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x4 cppArg1_local;
            ::QMatrix4x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix4x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 10: // setUniformValue(const char * name, const QPoint & point)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPoint cppArg1_local;
            ::QPoint *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QPoint)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 11: // setUniformValue(const char * name, const QPointF & point)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QPointF)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 12: // setUniformValue(const char * name, const QSize & size)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSize cppArg1_local;
            ::QSize *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QSize)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 13: // setUniformValue(const char * name, const QSizeF & size)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSizeF cppArg1_local;
            ::QSizeF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QSizeF)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 14: // setUniformValue(const char * name, const QTransform & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTransform cppArg1_local;
            ::QTransform *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QTransform)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 15: // setUniformValue(const char * name, const QVector2D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector2D cppArg1_local;
            ::QVector2D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QVector2D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 16: // setUniformValue(const char * name, const QVector3D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector3D cppArg1_local;
            ::QVector3D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QVector3D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 17: // setUniformValue(const char * name, const QVector4D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector4D cppArg1_local;
            ::QVector4D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QVector4D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 18: // setUniformValue(const char * name, const float[2][2] value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::Array2Handle<const float, 2> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,const float[2][2])
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 19: // setUniformValue(const char * name, const float[3][3] value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::Array2Handle<const float, 3> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,const float[3][3])
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 20: // setUniformValue(const char * name, const float[4][4] value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::Array2Handle<const float, 4> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,const float[4][4])
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 21: // setUniformValue(const char * name, float x, float y)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,float,float)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 22: // setUniformValue(const char * name, float x, float y, float z)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,float,float,float)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 23: // setUniformValue(const char * name, float x, float y, float z, float w)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            float cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,float,float,float,float)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 24: // setUniformValue(int location, const QColor & color)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QColor)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 25: // setUniformValue(int location, const QMatrix2x2 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x2 cppArg1_local;
            ::QMatrix2x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix2x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 26: // setUniformValue(int location, const QMatrix2x3 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x3 cppArg1_local;
            ::QMatrix2x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix2x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 27: // setUniformValue(int location, const QMatrix2x4 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x4 cppArg1_local;
            ::QMatrix2x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix2x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 28: // setUniformValue(int location, const QMatrix3x2 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x2 cppArg1_local;
            ::QMatrix3x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix3x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 29: // setUniformValue(int location, const QMatrix3x3 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x3 cppArg1_local;
            ::QMatrix3x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix3x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 30: // setUniformValue(int location, const QMatrix3x4 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x4 cppArg1_local;
            ::QMatrix3x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix3x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 31: // setUniformValue(int location, const QMatrix4x2 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x2 cppArg1_local;
            ::QMatrix4x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix4x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 32: // setUniformValue(int location, const QMatrix4x3 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x3 cppArg1_local;
            ::QMatrix4x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix4x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 33: // setUniformValue(int location, const QMatrix4x4 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x4 cppArg1_local;
            ::QMatrix4x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix4x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 34: // setUniformValue(int location, const QPoint & point)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPoint cppArg1_local;
            ::QPoint *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QPoint)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 35: // setUniformValue(int location, const QPointF & point)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QPointF)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 36: // setUniformValue(int location, const QSize & size)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSize cppArg1_local;
            ::QSize *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QSize)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 37: // setUniformValue(int location, const QSizeF & size)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSizeF cppArg1_local;
            ::QSizeF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QSizeF)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 38: // setUniformValue(int location, const QTransform & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTransform cppArg1_local;
            ::QTransform *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QTransform)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 39: // setUniformValue(int location, const QVector2D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector2D cppArg1_local;
            ::QVector2D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QVector2D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 40: // setUniformValue(int location, const QVector3D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector3D cppArg1_local;
            ::QVector3D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QVector3D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 41: // setUniformValue(int location, const QVector4D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector4D cppArg1_local;
            ::QVector4D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QVector4D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 42: // setUniformValue(int location, const float[2][2] value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::Array2Handle<const float, 2> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,const float[2][2])
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 43: // setUniformValue(int location, const float[3][3] value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::Array2Handle<const float, 3> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,const float[3][3])
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 44: // setUniformValue(int location, const float[4][4] value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::Array2Handle<const float, 4> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,const float[4][4])
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 45: // setUniformValue(int location, float value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,float)
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 46: // setUniformValue(int location, float x, float y)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,float,float)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 47: // setUniformValue(int location, float x, float y, float z)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,float,float,float)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 48: // setUniformValue(int location, float x, float y, float z, float w)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            float cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            float cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,float,float,float,float)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 49: // setUniformValue(int location, int value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,int)
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 50: // setUniformValue(int location, unsigned int value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            unsigned int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,uint)
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_setUniformValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_setUniformValue1f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.setUniformValue1f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValue1f", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::setUniformValue1f(const char*,float)
    // 1: QOpenGLShaderProgram::setUniformValue1f(int,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 1; // setUniformValue1f(int,float)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // setUniformValue1f(const char*,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_setUniformValue1f_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValue1f(const char * arg__1, float arg__2)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // setUniformValue1f(const char*,float)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qopenglshaderprogram_setuniformvalue_float)]
                float value = cppArg1;
                cppSelf->setUniformValue(cppArg0, value);
                // END of custom code block [file: ../glue/qtgui.cpp (qopenglshaderprogram_setuniformvalue_float)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValue1f(int arg__1, float arg__2)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // setUniformValue1f(int,float)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qopenglshaderprogram_setuniformvalue_float)]
                float value = cppArg1;
                cppSelf->setUniformValue(cppArg0, value);
                // END of custom code block [file: ../glue/qtgui.cpp (qopenglshaderprogram_setuniformvalue_float)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_setUniformValue1f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_setUniformValue1i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.setUniformValue1i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValue1i", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::setUniformValue1i(const char*,int)
    // 1: QOpenGLShaderProgram::setUniformValue1i(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // setUniformValue1i(int,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setUniformValue1i(const char*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_setUniformValue1i_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValue1i(const char * arg__1, int arg__2)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // setUniformValue1i(const char*,int)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qopenglshaderprogram_setuniformvalue_int)]
                int value = cppArg1;
                cppSelf->setUniformValue(cppArg0, value);
                // END of custom code block [file: ../glue/qtgui.cpp (qopenglshaderprogram_setuniformvalue_int)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValue1i(int arg__1, int arg__2)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // setUniformValue1i(int,int)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qopenglshaderprogram_setuniformvalue_int)]
                int value = cppArg1;
                cppSelf->setUniformValue(cppArg0, value);
                // END of custom code block [file: ../glue/qtgui.cpp (qopenglshaderprogram_setuniformvalue_int)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_setUniformValue1i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_setUniformValueArray(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.setUniformValueArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray", 3, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::setUniformValueArray(const char*,const float*,int,int)
    // 1: QOpenGLShaderProgram::setUniformValueArray(const char*,const int*,int)
    // 2: QOpenGLShaderProgram::setUniformValueArray(const char*,const uint*,int)
    // 3: QOpenGLShaderProgram::setUniformValueArray(int,const float*,int,int)
    // 4: QOpenGLShaderProgram::setUniformValueArray(int,const int*,int)
    // 5: QOpenGLShaderProgram::setUniformValueArray(int,const uint*,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 5; // setUniformValueArray(int,const uint*,int)
        } else if (numArgs == 4
            && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 3; // setUniformValueArray(int,const float*,int,int)
        } else if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 4; // setUniformValueArray(int,const int*,int)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 2; // setUniformValueArray(const char*,const uint*,int)
        } else if (numArgs == 4
            && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // setUniformValueArray(const char*,const float*,int,int)
        } else if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 1; // setUniformValueArray(const char*,const int*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_setUniformValueArray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const float * values, int count, int tupleSize)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::ArrayHandle<float> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const float*,int,int)
                cppSelf->setUniformValueArray(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // setUniformValueArray(const char * name, const int * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::ArrayHandle<int> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const int*,int)
                cppSelf->setUniformValueArray(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // setUniformValueArray(const char * name, const unsigned int * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const uint*,int)
                cppSelf->setUniformValueArray(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 3: // setUniformValueArray(int location, const float * values, int count, int tupleSize)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::ArrayHandle<float> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const float*,int,int)
                cppSelf->setUniformValueArray(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 4: // setUniformValueArray(int location, const int * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::ArrayHandle<int> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const int*,int)
                cppSelf->setUniformValueArray(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 5: // setUniformValueArray(int location, const unsigned int * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const uint*,int)
                cppSelf->setUniformValueArray(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLShaderProgramFunc_setUniformValueArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_shaders(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.shaders";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shaders()const
            QList<QOpenGLShader* > cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->shaders();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOPENGLSHADERPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLShaderProgramFunc_uniformLocation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLShaderProgram.uniformLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLShaderProgram::uniformLocation(QByteArray)const
    // 1: QOpenGLShaderProgram::uniformLocation(QString)const
    // 2: QOpenGLShaderProgram::uniformLocation(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 2; // uniformLocation(const char*)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // uniformLocation(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // uniformLocation(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLShaderProgramFunc_uniformLocation_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // uniformLocation(const QByteArray & name) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // uniformLocation(QByteArray)const
                int cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->uniformLocation(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // uniformLocation(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // uniformLocation(QString)const
                int cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->uniformLocation(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 2: // uniformLocation(const char * name) const
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // uniformLocation(const char*)const
                int cppResult = const_cast<const ::QOpenGLShaderProgram *>(cppSelf)->uniformLocation(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLShaderProgramFunc_uniformLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QOpenGLShaderProgram_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLShaderProgram_methods[] = {
    {"addCacheableShaderFromSourceCode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_addCacheableShaderFromSourceCode), METH_VARARGS},
    {"addCacheableShaderFromSourceFile", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_addCacheableShaderFromSourceFile), METH_VARARGS},
    {"addShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_addShader), METH_O},
    {"addShaderFromSourceCode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_addShaderFromSourceCode), METH_VARARGS},
    {"addShaderFromSourceFile", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_addShaderFromSourceFile), METH_VARARGS},
    {"attributeLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_attributeLocation), METH_O},
    {"bind", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_bind), METH_NOARGS},
    {"bindAttributeLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_bindAttributeLocation), METH_VARARGS},
    {"create", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_create), METH_NOARGS},
    {"defaultInnerTessellationLevels", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_defaultInnerTessellationLevels), METH_NOARGS},
    {"defaultOuterTessellationLevels", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_defaultOuterTessellationLevels), METH_NOARGS},
    {"disableAttributeArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_disableAttributeArray), METH_O},
    {"enableAttributeArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_enableAttributeArray), METH_O},
    {"hasOpenGLShaderPrograms", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_hasOpenGLShaderPrograms), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isLinked", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_isLinked), METH_NOARGS},
    {"link", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_link), METH_NOARGS},
    {"log", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_log), METH_NOARGS},
    {"maxGeometryOutputVertices", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_maxGeometryOutputVertices), METH_NOARGS},
    {"patchVertexCount", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_patchVertexCount), METH_NOARGS},
    {"programId", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_programId), METH_NOARGS},
    {"release", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_release), METH_NOARGS},
    {"removeAllShaders", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_removeAllShaders), METH_NOARGS},
    {"removeShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_removeShader), METH_O},
    {"setAttributeArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_setAttributeArray), METH_VARARGS|METH_KEYWORDS},
    {"setAttributeBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_setAttributeBuffer), METH_VARARGS|METH_KEYWORDS},
    {"setAttributeValue", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_setAttributeValue), METH_VARARGS},
    {"setDefaultInnerTessellationLevels", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_setDefaultInnerTessellationLevels), METH_O},
    {"setDefaultOuterTessellationLevels", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_setDefaultOuterTessellationLevels), METH_O},
    {"setPatchVertexCount", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_setPatchVertexCount), METH_O},
    {"setUniformValue", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_setUniformValue), METH_VARARGS},
    {"setUniformValue1f", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_setUniformValue1f), METH_VARARGS},
    {"setUniformValue1i", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_setUniformValue1i), METH_VARARGS},
    {"setUniformValueArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_setUniformValueArray), METH_VARARGS},
    {"shaders", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_shaders), METH_NOARGS},
    {"uniformLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLShaderProgramFunc_uniformLocation), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QOpenGLShaderProgram_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QOpenGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QOpenGLShaderProgramWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QOpenGLShaderProgram_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLShaderProgram_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLShaderProgram_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLShaderProgram_TypeF(void)
{
    return _Sbk_QOpenGLShaderProgram_Type;
}

static PyType_Slot Sbk_QOpenGLShaderProgram_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QOpenGLShaderProgram_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLShaderProgram_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLShaderProgram_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLShaderProgram_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLShaderProgram_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLShaderProgram_spec = {
    "2:PySide2.QtGui.QOpenGLShaderProgram",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLShaderProgram_slots
};

} //extern "C"

static void *Sbk_QOpenGLShaderProgram_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QOpenGLShaderProgram *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLShaderProgram_PythonToCpp_QOpenGLShaderProgram_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLShaderProgram_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLShaderProgram_PythonToCpp_QOpenGLShaderProgram_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLShaderProgram_TypeF())))
        return QOpenGLShaderProgram_PythonToCpp_QOpenGLShaderProgram_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLShaderProgram_PTR_CppToPython_QOpenGLShaderProgram(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QOpenGLShaderProgram *>(const_cast<void *>(cppIn)), Sbk_QOpenGLShaderProgram_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLShaderProgram_SignatureStrings[] = {
    "PySide2.QtGui.QOpenGLShaderProgram(self,parent:PySide2.QtCore.QObject=nullptr)",
    "2:PySide2.QtGui.QOpenGLShaderProgram.addCacheableShaderFromSourceCode(self,type:PySide2.QtGui.QOpenGLShader.ShaderType,source:PySide2.QtCore.QByteArray)->bool",
    "1:PySide2.QtGui.QOpenGLShaderProgram.addCacheableShaderFromSourceCode(self,type:PySide2.QtGui.QOpenGLShader.ShaderType,source:QString)->bool",
    "0:PySide2.QtGui.QOpenGLShaderProgram.addCacheableShaderFromSourceCode(self,type:PySide2.QtGui.QOpenGLShader.ShaderType,source:char*)->bool",
    "PySide2.QtGui.QOpenGLShaderProgram.addCacheableShaderFromSourceFile(self,type:PySide2.QtGui.QOpenGLShader.ShaderType,fileName:QString)->bool",
    "PySide2.QtGui.QOpenGLShaderProgram.addShader(self,shader:PySide2.QtGui.QOpenGLShader)->bool",
    "2:PySide2.QtGui.QOpenGLShaderProgram.addShaderFromSourceCode(self,type:PySide2.QtGui.QOpenGLShader.ShaderType,source:PySide2.QtCore.QByteArray)->bool",
    "1:PySide2.QtGui.QOpenGLShaderProgram.addShaderFromSourceCode(self,type:PySide2.QtGui.QOpenGLShader.ShaderType,source:QString)->bool",
    "0:PySide2.QtGui.QOpenGLShaderProgram.addShaderFromSourceCode(self,type:PySide2.QtGui.QOpenGLShader.ShaderType,source:char*)->bool",
    "PySide2.QtGui.QOpenGLShaderProgram.addShaderFromSourceFile(self,type:PySide2.QtGui.QOpenGLShader.ShaderType,fileName:QString)->bool",
    "2:PySide2.QtGui.QOpenGLShaderProgram.attributeLocation(self,name:PySide2.QtCore.QByteArray)->int",
    "1:PySide2.QtGui.QOpenGLShaderProgram.attributeLocation(self,name:QString)->int",
    "0:PySide2.QtGui.QOpenGLShaderProgram.attributeLocation(self,name:char*)->int",
    "PySide2.QtGui.QOpenGLShaderProgram.bind(self)->bool",
    "2:PySide2.QtGui.QOpenGLShaderProgram.bindAttributeLocation(self,name:PySide2.QtCore.QByteArray,location:int)",
    "1:PySide2.QtGui.QOpenGLShaderProgram.bindAttributeLocation(self,name:QString,location:int)",
    "0:PySide2.QtGui.QOpenGLShaderProgram.bindAttributeLocation(self,name:char*,location:int)",
    "PySide2.QtGui.QOpenGLShaderProgram.create(self)->bool",
    "PySide2.QtGui.QOpenGLShaderProgram.defaultInnerTessellationLevels(self)->QVector[float]",
    "PySide2.QtGui.QOpenGLShaderProgram.defaultOuterTessellationLevels(self)->QVector[float]",
    "1:PySide2.QtGui.QOpenGLShaderProgram.disableAttributeArray(self,name:char*)",
    "0:PySide2.QtGui.QOpenGLShaderProgram.disableAttributeArray(self,location:int)",
    "1:PySide2.QtGui.QOpenGLShaderProgram.enableAttributeArray(self,name:char*)",
    "0:PySide2.QtGui.QOpenGLShaderProgram.enableAttributeArray(self,location:int)",
    "PySide2.QtGui.QOpenGLShaderProgram.hasOpenGLShaderPrograms(context:PySide2.QtGui.QOpenGLContext=nullptr)->bool",
    "PySide2.QtGui.QOpenGLShaderProgram.isLinked(self)->bool",
    "PySide2.QtGui.QOpenGLShaderProgram.link(self)->bool",
    "PySide2.QtGui.QOpenGLShaderProgram.log(self)->QString",
    "PySide2.QtGui.QOpenGLShaderProgram.maxGeometryOutputVertices(self)->int",
    "PySide2.QtGui.QOpenGLShaderProgram.patchVertexCount(self)->int",
    "PySide2.QtGui.QOpenGLShaderProgram.programId(self)->unsigned int",
    "PySide2.QtGui.QOpenGLShaderProgram.release(self)",
    "PySide2.QtGui.QOpenGLShaderProgram.removeAllShaders(self)",
    "PySide2.QtGui.QOpenGLShaderProgram.removeShader(self,shader:PySide2.QtGui.QOpenGLShader)",
    "3:PySide2.QtGui.QOpenGLShaderProgram.setAttributeArray(self,name:char*,values:array float*,tupleSize:int,stride:int=0)",
    "2:PySide2.QtGui.QOpenGLShaderProgram.setAttributeArray(self,name:char*,type:unsigned int,values:void,tupleSize:int,stride:int=0)",
    "1:PySide2.QtGui.QOpenGLShaderProgram.setAttributeArray(self,location:int,values:array float*,tupleSize:int,stride:int=0)",
    "0:PySide2.QtGui.QOpenGLShaderProgram.setAttributeArray(self,location:int,type:unsigned int,values:void,tupleSize:int,stride:int=0)",
    "1:PySide2.QtGui.QOpenGLShaderProgram.setAttributeBuffer(self,name:char*,type:unsigned int,offset:int,tupleSize:int,stride:int=0)",
    "0:PySide2.QtGui.QOpenGLShaderProgram.setAttributeBuffer(self,location:int,type:unsigned int,offset:int,tupleSize:int,stride:int=0)",
    "17:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,name:char*,value:PySide2.QtGui.QColor)",
    "16:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,name:char*,value:PySide2.QtGui.QVector2D)",
    "15:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,name:char*,value:PySide2.QtGui.QVector3D)",
    "14:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,name:char*,value:PySide2.QtGui.QVector4D)",
    "13:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,name:char*,values:array float*,columns:int,rows:int)",
    "12:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,name:char*,value:float)",
    "11:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,name:char*,x:float,y:float)",
    "10:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,name:char*,x:float,y:float,z:float)",
    "9:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,name:char*,x:float,y:float,z:float,w:float)",
    "8:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,location:int,value:PySide2.QtGui.QColor)",
    "7:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,location:int,value:PySide2.QtGui.QVector2D)",
    "6:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,location:int,value:PySide2.QtGui.QVector3D)",
    "5:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,location:int,value:PySide2.QtGui.QVector4D)",
    "4:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,location:int,values:array float*,columns:int,rows:int)",
    "3:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,location:int,value:float)",
    "2:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,location:int,x:float,y:float)",
    "1:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,location:int,x:float,y:float,z:float)",
    "0:PySide2.QtGui.QOpenGLShaderProgram.setAttributeValue(self,location:int,x:float,y:float,z:float,w:float)",
    "PySide2.QtGui.QOpenGLShaderProgram.setDefaultInnerTessellationLevels(self,levels:QVector[float])",
    "PySide2.QtGui.QOpenGLShaderProgram.setDefaultOuterTessellationLevels(self,levels:QVector[float])",
    "PySide2.QtGui.QOpenGLShaderProgram.setPatchVertexCount(self,count:int)",
    "50:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,color:PySide2.QtGui.QColor)",
    "49:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix2x2)",
    "48:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix2x3)",
    "47:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix2x4)",
    "46:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix3x2)",
    "45:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix3x3)",
    "44:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix3x4)",
    "43:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix4x2)",
    "42:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix4x3)",
    "41:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix4x4)",
    "40:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,point:PySide2.QtCore.QPoint)",
    "39:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,point:PySide2.QtCore.QPointF)",
    "38:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,size:PySide2.QtCore.QSize)",
    "37:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,size:PySide2.QtCore.QSizeF)",
    "36:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QTransform)",
    "35:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QVector2D)",
    "34:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QVector3D)",
    "33:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QVector4D)",
    "32:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:float[2][2])",
    "31:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:float[3][3])",
    "30:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,value:float[4][4])",
    "29:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,x:float,y:float)",
    "28:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,x:float,y:float,z:float)",
    "27:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,name:char*,x:float,y:float,z:float,w:float)",
    "26:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,color:PySide2.QtGui.QColor)",
    "25:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix2x2)",
    "24:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix2x3)",
    "23:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix2x4)",
    "22:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix3x2)",
    "21:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix3x3)",
    "20:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix3x4)",
    "19:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix4x2)",
    "18:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix4x3)",
    "17:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix4x4)",
    "16:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,point:PySide2.QtCore.QPoint)",
    "15:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,point:PySide2.QtCore.QPointF)",
    "14:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,size:PySide2.QtCore.QSize)",
    "13:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,size:PySide2.QtCore.QSizeF)",
    "12:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QTransform)",
    "11:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QVector2D)",
    "10:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QVector3D)",
    "9:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QVector4D)",
    "8:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:float[2][2])",
    "7:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:float[3][3])",
    "6:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:float[4][4])",
    "5:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:float)",
    "4:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,x:float,y:float)",
    "3:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,x:float,y:float,z:float)",
    "2:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,x:float,y:float,z:float,w:float)",
    "1:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:int)",
    "0:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue(self,location:int,value:unsigned int)",
    "1:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue1f(self,arg__1:char*,arg__2:float)",
    "0:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue1f(self,arg__1:int,arg__2:float)",
    "1:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue1i(self,arg__1:char*,arg__2:int)",
    "0:PySide2.QtGui.QOpenGLShaderProgram.setUniformValue1i(self,arg__1:int,arg__2:int)",
    "5:PySide2.QtGui.QOpenGLShaderProgram.setUniformValueArray(self,name:char*,values:array float*,count:int,tupleSize:int)",
    "4:PySide2.QtGui.QOpenGLShaderProgram.setUniformValueArray(self,name:char*,values:array int*,count:int)",
    "3:PySide2.QtGui.QOpenGLShaderProgram.setUniformValueArray(self,name:char*,values:array unsigned int*,count:int)",
    "2:PySide2.QtGui.QOpenGLShaderProgram.setUniformValueArray(self,location:int,values:array float*,count:int,tupleSize:int)",
    "1:PySide2.QtGui.QOpenGLShaderProgram.setUniformValueArray(self,location:int,values:array int*,count:int)",
    "0:PySide2.QtGui.QOpenGLShaderProgram.setUniformValueArray(self,location:int,values:array unsigned int*,count:int)",
    "PySide2.QtGui.QOpenGLShaderProgram.shaders(self)->QList[PySide2.QtGui.QOpenGLShader]",
    "2:PySide2.QtGui.QOpenGLShaderProgram.uniformLocation(self,name:PySide2.QtCore.QByteArray)->int",
    "1:PySide2.QtGui.QOpenGLShaderProgram.uniformLocation(self,name:QString)->int",
    "0:PySide2.QtGui.QOpenGLShaderProgram.uniformLocation(self,name:char*)->int",
    nullptr}; // Sentinel

void init_QOpenGLShaderProgram(PyObject *module)
{
    _Sbk_QOpenGLShaderProgram_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLShaderProgram",
        "QOpenGLShaderProgram*",
        &Sbk_QOpenGLShaderProgram_spec,
        &Shiboken::callCppDestructor< ::QOpenGLShaderProgram >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLShaderProgram_Type);
    InitSignatureStrings(pyType, QOpenGLShaderProgram_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLShaderProgram_Type), Sbk_QOpenGLShaderProgram_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADERPROGRAM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLShaderProgram_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLShaderProgram_TypeF(),
        QOpenGLShaderProgram_PythonToCpp_QOpenGLShaderProgram_PTR,
        is_QOpenGLShaderProgram_PythonToCpp_QOpenGLShaderProgram_PTR_Convertible,
        QOpenGLShaderProgram_PTR_CppToPython_QOpenGLShaderProgram);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLShaderProgram");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLShaderProgram*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLShaderProgram&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLShaderProgram).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLShaderProgramWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QOpenGLShaderProgram_TypeF(), &Sbk_QOpenGLShaderProgram_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QOpenGLShaderProgram_TypeF(), &::QOpenGLShaderProgram::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QOpenGLShaderProgram_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QOpenGLShaderProgram_TypeF(), &::QOpenGLShaderProgram::staticMetaObject, sizeof(QOpenGLShaderProgramWrapper));
}
