/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qkeysequence_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtGui/qkeysequence.h>
#include <qdatastream.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QKeySequence_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QKeySequence >()))
        return -1;

    ::QKeySequence *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QKeySequence_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QKeySequence", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QKeySequence::QKeySequence()
    // 1: QKeySequence::QKeySequence(QKeySequence::StandardKey)
    // 2: QKeySequence::QKeySequence(QKeySequence)
    // 3: QKeySequence::QKeySequence(QString,QKeySequence::SequenceFormat)
    // 4: QKeySequence::QKeySequence(int,int,int,int)
    if (numArgs == 0) {
        overloadId = 0; // QKeySequence()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // QKeySequence(QString,QKeySequence::SequenceFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 3; // QKeySequence(QString,QKeySequence::SequenceFormat)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QKeySequence(QKeySequence::StandardKey)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 4; // QKeySequence(int,int,int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 4; // QKeySequence(int,int,int,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 4; // QKeySequence(int,int,int,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 4; // QKeySequence(int,int,int,int)
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QKeySequence(QKeySequence)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QKeySequence_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QKeySequence()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QKeySequence_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QKeySequence()
                cptr = new ::QKeySequence();
            }
            break;
        }
        case 1: // QKeySequence(QKeySequence::StandardKey key)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QKeySequence_Init_TypeError;
            }
            ::QKeySequence::StandardKey cppArg0{QKeySequence::UnknownKey};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QKeySequence(QKeySequence::StandardKey)
                cptr = new ::QKeySequence(cppArg0);
            }
            break;
        }
        case 2: // QKeySequence(const QKeySequence & ks)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QKeySequence_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QKeySequence cppArg0_local;
            ::QKeySequence *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QKeySequence(QKeySequence)
                cptr = new ::QKeySequence(*cppArg0);
            }
            break;
        }
        case 3: // QKeySequence(const QString & key, QKeySequence::SequenceFormat format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QKeySequence_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QKeySequence_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QKeySequence_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QKeySequence::SequenceFormat cppArg1 = QKeySequence::SequenceFormat::NativeText;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QKeySequence(QString,QKeySequence::SequenceFormat)
                cptr = new ::QKeySequence(cppArg0, cppArg1);
            }
            break;
        }
        case 4: // QKeySequence(int k1, int k2, int k3, int k4)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_k2 = Shiboken::String::createStaticString("k2");
                if (PyDict_Contains(kwds, key_k2)) {
                    value = PyDict_GetItem(kwds, key_k2);
                    if (value && pyArgs[1]) {
                        errInfo = key_k2;
                        Py_INCREF(errInfo);
                        goto Sbk_QKeySequence_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QKeySequence_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_k2);
                }
                static PyObject *const key_k3 = Shiboken::String::createStaticString("k3");
                if (PyDict_Contains(kwds, key_k3)) {
                    value = PyDict_GetItem(kwds, key_k3);
                    if (value && pyArgs[2]) {
                        errInfo = key_k3;
                        Py_INCREF(errInfo);
                        goto Sbk_QKeySequence_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QKeySequence_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_k3);
                }
                static PyObject *const key_k4 = Shiboken::String::createStaticString("k4");
                if (PyDict_Contains(kwds, key_k4)) {
                    value = PyDict_GetItem(kwds, key_k4);
                    if (value && pyArgs[3]) {
                        errInfo = key_k4;
                        Py_INCREF(errInfo);
                        goto Sbk_QKeySequence_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QKeySequence_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_k4);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QKeySequence_Init_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = 0;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QKeySequence(int,int,int,int)
                cptr = new ::QKeySequence(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QKeySequence >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QKeySequence_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QKeySequence_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QKeySequenceFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(iiii))", PyObject_Type(self), (*cppSelf)[0], (*cppSelf)[1], (*cppSelf)[2], (*cppSelf)[3]);
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QKeySequenceFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code - START
            QString format = QString::asprintf("%s(%i, %i, %i, %i)",
                Py_TYPE(self)->tp_name, (*cppSelf)[0], (*cppSelf)[1], (*cppSelf)[2], (*cppSelf)[3]);
            pyResult = Shiboken::String::fromCString(qPrintable(format));
            // TEMPLATE - repr_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QKeySequenceFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = const_cast<const ::QKeySequence *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QKeySequenceFunc_fromString(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.fromString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QKeySequenceFunc_fromString_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QKeySequenceFunc_fromString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromString", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QKeySequence::fromString(QString,QKeySequence::SequenceFormat)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromString(QString,QKeySequence::SequenceFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromString(QString,QKeySequence::SequenceFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QKeySequenceFunc_fromString_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QKeySequenceFunc_fromString_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QKeySequenceFunc_fromString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QKeySequenceFunc_fromString_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QKeySequence::SequenceFormat cppArg1 = QKeySequence::SequenceFormat::PortableText;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromString(QString,QKeySequence::SequenceFormat)
            QKeySequence cppResult = ::QKeySequence::fromString(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QKeySequenceFunc_fromString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QKeySequenceFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QKeySequence *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QKeySequenceFunc_keyBindings(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.keyBindings";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QKeySequence::keyBindings(QKeySequence::StandardKey)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // keyBindings(QKeySequence::StandardKey)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QKeySequenceFunc_keyBindings_TypeError;

    // Call function/method
    {
        ::QKeySequence::StandardKey cppArg0{QKeySequence::UnknownKey};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyBindings(QKeySequence::StandardKey)
            QList<QKeySequence > cppResult = ::QKeySequence::keyBindings(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QKEYSEQUENCE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QKeySequenceFunc_keyBindings_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QKeySequenceFunc_listFromString(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.listFromString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QKeySequenceFunc_listFromString_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QKeySequenceFunc_listFromString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:listFromString", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QKeySequence::listFromString(QString,QKeySequence::SequenceFormat)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // listFromString(QString,QKeySequence::SequenceFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // listFromString(QString,QKeySequence::SequenceFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QKeySequenceFunc_listFromString_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QKeySequenceFunc_listFromString_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QKeySequenceFunc_listFromString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QKeySequenceFunc_listFromString_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QKeySequence::SequenceFormat cppArg1 = QKeySequence::SequenceFormat::PortableText;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // listFromString(QString,QKeySequence::SequenceFormat)
            QList<QKeySequence > cppResult = ::QKeySequence::listFromString(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QKEYSEQUENCE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QKeySequenceFunc_listFromString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QKeySequenceFunc_listToString(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.listToString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QKeySequenceFunc_listToString_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QKeySequenceFunc_listToString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:listToString", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QKeySequence::listToString(QList<QKeySequence>,QKeySequence::SequenceFormat)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QKEYSEQUENCE_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // listToString(QList<QKeySequence>,QKeySequence::SequenceFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // listToString(QList<QKeySequence>,QKeySequence::SequenceFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QKeySequenceFunc_listToString_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QKeySequenceFunc_listToString_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QKeySequenceFunc_listToString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QKeySequenceFunc_listToString_TypeError;
            }
        }
        ::QList<QKeySequence > cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QKeySequence::SequenceFormat cppArg1 = QKeySequence::SequenceFormat::PortableText;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // listToString(QList<QKeySequence>,QKeySequence::SequenceFormat)
            QString cppResult = ::QKeySequence::listToString(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QKeySequenceFunc_listToString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QKeySequenceFunc_matches(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.matches";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeySequence::matches(QKeySequence)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArg)))) {
        overloadId = 0; // matches(QKeySequence)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QKeySequenceFunc_matches_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeySequence cppArg0_local;
        ::QKeySequence *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // matches(QKeySequence)const
            QKeySequence::SequenceMatch cppResult = const_cast<const ::QKeySequence *>(cppSelf)->matches(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QKeySequenceFunc_matches_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QKeySequenceFunc_mnemonic(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.mnemonic";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QKeySequence::mnemonic(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // mnemonic(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QKeySequenceFunc_mnemonic_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mnemonic(QString)
            QKeySequence cppResult = ::QKeySequence::mnemonic(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QKeySequenceFunc_mnemonic_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QKeySequenceFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeySequence::swap(QKeySequence&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QKeySequence&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QKeySequenceFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeySequence cppArg0_local;
        ::QKeySequence *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QKeySequence&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QKeySequenceFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QKeySequenceFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QKeySequenceFunc_toString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toString", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QKeySequence::toString(QKeySequence::SequenceFormat)const
    if (numArgs == 0) {
        overloadId = 0; // toString(QKeySequence::SequenceFormat)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // toString(QKeySequence::SequenceFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QKeySequenceFunc_toString_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[0]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QKeySequenceFunc_toString_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QKeySequenceFunc_toString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QKeySequenceFunc_toString_TypeError;
            }
        }
        ::QKeySequence::SequenceFormat cppArg0 = QKeySequence::SequenceFormat::PortableText;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toString(QKeySequence::SequenceFormat)const
            QString cppResult = const_cast<const ::QKeySequence *>(cppSelf)->toString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QKeySequenceFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QKeySequence___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QKeySequence_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QKeySequence_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QKeySequenceFunc___reduce__), METH_NOARGS},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QKeySequenceFunc_count), METH_NOARGS},
    {"fromString", reinterpret_cast<PyCFunction>(Sbk_QKeySequenceFunc_fromString), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QKeySequenceFunc_isEmpty), METH_NOARGS},
    {"keyBindings", reinterpret_cast<PyCFunction>(Sbk_QKeySequenceFunc_keyBindings), METH_O|METH_STATIC},
    {"listFromString", reinterpret_cast<PyCFunction>(Sbk_QKeySequenceFunc_listFromString), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"listToString", reinterpret_cast<PyCFunction>(Sbk_QKeySequenceFunc_listToString), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"matches", reinterpret_cast<PyCFunction>(Sbk_QKeySequenceFunc_matches), METH_O},
    {"mnemonic", reinterpret_cast<PyCFunction>(Sbk_QKeySequenceFunc_mnemonic), METH_O|METH_STATIC},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QKeySequenceFunc_swap), METH_O},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QKeySequenceFunc_toString), METH_VARARGS|METH_KEYWORDS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QKeySequence___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QKeySequenceFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QKeySequence::operator<<(QDataStream&,QKeySequence)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QKeySequence)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QKeySequenceFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QKeySequence) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QKeySequenceFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QKeySequenceFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QKeySequence.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QKeySequence::operator>>(QDataStream&,QKeySequence&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QKeySequence&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QKeySequenceFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QKeySequence&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QKeySequenceFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

PyObject* Sbk_QKeySequenceFunc___getitem__(PyObject *self, Py_ssize_t _i)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtgui.cpp (qkeysequence-getitem)]
    if (_i < 0 || _i >= cppSelf->count()) {
        PyErr_SetString(PyExc_IndexError, "index out of bounds");
        return 0;
    }
    int item = (*cppSelf)[_i];
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &item);
    // END of custom code block [file: ../glue/qtgui.cpp (qkeysequence-getitem)]
    // ========================================================================

    // End of code injection

}

// Rich comparison
static PyObject * Sbk_QKeySequence_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArg)))) {
                // operator!=(const QKeySequence & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QKeySequence cppArg0_local;
                ::QKeySequence *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArg)))) {
                // operator<(const QKeySequence & ks) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QKeySequence cppArg0_local;
                ::QKeySequence *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QKeySequence_RichComparison_TypeError;
            }

            break;
        case Py_LE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArg)))) {
                // operator<=(const QKeySequence & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QKeySequence cppArg0_local;
                ::QKeySequence *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QKeySequence_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArg)))) {
                // operator==(const QKeySequence & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QKeySequence cppArg0_local;
                ::QKeySequence *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        case Py_GT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArg)))) {
                // operator>(const QKeySequence & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QKeySequence cppArg0_local;
                ::QKeySequence *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QKeySequence_RichComparison_TypeError;
            }

            break;
        case Py_GE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArg)))) {
                // operator>=(const QKeySequence & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QKeySequence cppArg0_local;
                ::QKeySequence *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QKeySequence_RichComparison_TypeError;
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QKeySequence_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QKeySequence_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QKeySequence_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QKeySequence_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QKeySequence_Type = nullptr;
static SbkObjectType *Sbk_QKeySequence_TypeF(void)
{
    return _Sbk_QKeySequence_Type;
}

static PyType_Slot Sbk_QKeySequence_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QKeySequenceFunc___repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QKeySequence_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QKeySequence_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QKeySequence_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QKeySequence_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QKeySequence_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports sequence protocol
    {Py_sq_item, (void *)&Sbk_QKeySequenceFunc___getitem__},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QKeySequenceFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QKeySequenceFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QKeySequence_spec = {
    "2:PySide2.QtGui.QKeySequence",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QKeySequence_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QKeySequence_StandardKey_PythonToCpp_QKeySequence_StandardKey(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QKeySequence::StandardKey *>(cppOut) =
        static_cast<::QKeySequence::StandardKey>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QKeySequence_StandardKey_PythonToCpp_QKeySequence_StandardKey_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX]))
        return QKeySequence_StandardKey_PythonToCpp_QKeySequence_StandardKey;
    return {};
}
static PyObject *QKeySequence_StandardKey_CppToPython_QKeySequence_StandardKey(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QKeySequence::StandardKey *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX], castCppIn);

}

static void QKeySequence_SequenceFormat_PythonToCpp_QKeySequence_SequenceFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QKeySequence::SequenceFormat *>(cppOut) =
        static_cast<::QKeySequence::SequenceFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QKeySequence_SequenceFormat_PythonToCpp_QKeySequence_SequenceFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX]))
        return QKeySequence_SequenceFormat_PythonToCpp_QKeySequence_SequenceFormat;
    return {};
}
static PyObject *QKeySequence_SequenceFormat_CppToPython_QKeySequence_SequenceFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QKeySequence::SequenceFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX], castCppIn);

}

static void QKeySequence_SequenceMatch_PythonToCpp_QKeySequence_SequenceMatch(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QKeySequence::SequenceMatch *>(cppOut) =
        static_cast<::QKeySequence::SequenceMatch>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QKeySequence_SequenceMatch_PythonToCpp_QKeySequence_SequenceMatch_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX]))
        return QKeySequence_SequenceMatch_PythonToCpp_QKeySequence_SequenceMatch;
    return {};
}
static PyObject *QKeySequence_SequenceMatch_CppToPython_QKeySequence_SequenceMatch(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QKeySequence::SequenceMatch *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QKeySequence_PythonToCpp_QKeySequence_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QKeySequence_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QKeySequence_PythonToCpp_QKeySequence_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QKeySequence_TypeF())))
        return QKeySequence_PythonToCpp_QKeySequence_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QKeySequence_PTR_CppToPython_QKeySequence(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QKeySequence *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QKeySequence_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QKeySequence_COPY_CppToPython_QKeySequence(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QKeySequence_TypeF(), new ::QKeySequence(*reinterpret_cast<const ::QKeySequence *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QKeySequence_PythonToCpp_QKeySequence_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QKeySequence *>(cppOut) = *reinterpret_cast< ::QKeySequence *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QKeySequence_PythonToCpp_QKeySequence_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QKeySequence_TypeF())))
        return QKeySequence_PythonToCpp_QKeySequence_COPY;
    return {};
}

// Implicit conversions.
static void QKeySequence_StandardKey_PythonToCpp_QKeySequence(PyObject *pyIn, void *cppOut) {
    ::QKeySequence::StandardKey cppIn{QKeySequence::UnknownKey};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QKeySequence *>(cppOut) = ::QKeySequence(cppIn);
}
static PythonToCppFunc is_QKeySequence_StandardKey_PythonToCpp_QKeySequence_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX], pyIn))
        return QKeySequence_StandardKey_PythonToCpp_QKeySequence;
    return {};
}

static void PySide2_QtCore_constQStringREF_PythonToCpp_QKeySequence(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QKeySequence *>(cppOut) = ::QKeySequence(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_constQStringREF_PythonToCpp_QKeySequence_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return PySide2_QtCore_constQStringREF_PythonToCpp_QKeySequence;
    return {};
}

static void PySide2_QtCore_int_PythonToCpp_QKeySequence(PyObject *pyIn, void *cppOut) {
    int cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn, &cppIn);
    *reinterpret_cast<::QKeySequence *>(cppOut) = ::QKeySequence(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_int_PythonToCpp_QKeySequence_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return PySide2_QtCore_int_PythonToCpp_QKeySequence;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QKeySequence_SignatureStrings[] = {
    "4:PySide2.QtGui.QKeySequence(self)",
    "3:PySide2.QtGui.QKeySequence(self,key:PySide2.QtGui.QKeySequence.StandardKey)",
    "2:PySide2.QtGui.QKeySequence(self,ks:PySide2.QtGui.QKeySequence)",
    "1:PySide2.QtGui.QKeySequence(self,key:QString,format:PySide2.QtGui.QKeySequence.SequenceFormat=NativeText)",
    "0:PySide2.QtGui.QKeySequence(self,k1:int,k2:int=0,k3:int=0,k4:int=0)",
    "PySide2.QtGui.QKeySequence.__reduce__(self)->PyObject",
    "PySide2.QtGui.QKeySequence.__repr__(self)->PyObject",
    "PySide2.QtGui.QKeySequence.count(self)->int",
    "PySide2.QtGui.QKeySequence.fromString(str:QString,format:PySide2.QtGui.QKeySequence.SequenceFormat=PortableText)->PySide2.QtGui.QKeySequence",
    "PySide2.QtGui.QKeySequence.isEmpty(self)->bool",
    "PySide2.QtGui.QKeySequence.keyBindings(key:PySide2.QtGui.QKeySequence.StandardKey)->QList[PySide2.QtGui.QKeySequence]",
    "PySide2.QtGui.QKeySequence.listFromString(str:QString,format:PySide2.QtGui.QKeySequence.SequenceFormat=PortableText)->QList[PySide2.QtGui.QKeySequence]",
    "PySide2.QtGui.QKeySequence.listToString(list:QList[PySide2.QtGui.QKeySequence],format:PySide2.QtGui.QKeySequence.SequenceFormat=PortableText)->QString",
    "PySide2.QtGui.QKeySequence.matches(self,seq:PySide2.QtGui.QKeySequence)->PySide2.QtGui.QKeySequence.SequenceMatch",
    "PySide2.QtGui.QKeySequence.mnemonic(text:QString)->PySide2.QtGui.QKeySequence",
    "PySide2.QtGui.QKeySequence.swap(self,other:PySide2.QtGui.QKeySequence)",
    "PySide2.QtGui.QKeySequence.toString(self,format:PySide2.QtGui.QKeySequence.SequenceFormat=PortableText)->QString",
    "PySide2.QtGui.QKeySequence.__copy__()",
    "PySide2.QtGui.QKeySequence.__lshift__(self,in:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QKeySequence.__rshift__(self,out:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QKeySequence(PyObject *module)
{
    _Sbk_QKeySequence_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QKeySequence",
        "QKeySequence",
        &Sbk_QKeySequence_spec,
        &Shiboken::callCppDestructor< ::QKeySequence >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QKeySequence_Type);
    InitSignatureStrings(pyType, QKeySequence_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QKeySequence_Type), Sbk_QKeySequence_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QKeySequence_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QKeySequence_TypeF(),
        QKeySequence_PythonToCpp_QKeySequence_PTR,
        is_QKeySequence_PythonToCpp_QKeySequence_PTR_Convertible,
        QKeySequence_PTR_CppToPython_QKeySequence,
        QKeySequence_COPY_CppToPython_QKeySequence);

    Shiboken::Conversions::registerConverterName(converter, "QKeySequence");
    Shiboken::Conversions::registerConverterName(converter, "QKeySequence*");
    Shiboken::Conversions::registerConverterName(converter, "QKeySequence&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QKeySequence).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QKeySequence_PythonToCpp_QKeySequence_COPY,
        is_QKeySequence_PythonToCpp_QKeySequence_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QKeySequence_StandardKey_PythonToCpp_QKeySequence,
        is_QKeySequence_StandardKey_PythonToCpp_QKeySequence_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQStringREF_PythonToCpp_QKeySequence,
        is_PySide2_QtCore_constQStringREF_PythonToCpp_QKeySequence_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_int_PythonToCpp_QKeySequence,
        is_PySide2_QtCore_int_PythonToCpp_QKeySequence_Convertible);

    // Initialization of enums.

    // Initialization of enum 'StandardKey'.
    SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QKeySequence_TypeF(),
        "StandardKey",
        "2:PySide2.QtGui.QKeySequence.StandardKey",
        "QKeySequence::StandardKey");
    if (!SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "UnknownKey", (long) QKeySequence::StandardKey::UnknownKey))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "HelpContents", (long) QKeySequence::StandardKey::HelpContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "WhatsThis", (long) QKeySequence::StandardKey::WhatsThis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Open", (long) QKeySequence::StandardKey::Open))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Close", (long) QKeySequence::StandardKey::Close))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Save", (long) QKeySequence::StandardKey::Save))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "New", (long) QKeySequence::StandardKey::New))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Delete", (long) QKeySequence::StandardKey::Delete))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Cut", (long) QKeySequence::StandardKey::Cut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Copy", (long) QKeySequence::StandardKey::Copy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Paste", (long) QKeySequence::StandardKey::Paste))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Undo", (long) QKeySequence::StandardKey::Undo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Redo", (long) QKeySequence::StandardKey::Redo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Back", (long) QKeySequence::StandardKey::Back))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Forward", (long) QKeySequence::StandardKey::Forward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Refresh", (long) QKeySequence::StandardKey::Refresh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "ZoomIn", (long) QKeySequence::StandardKey::ZoomIn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "ZoomOut", (long) QKeySequence::StandardKey::ZoomOut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Print", (long) QKeySequence::StandardKey::Print))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "AddTab", (long) QKeySequence::StandardKey::AddTab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "NextChild", (long) QKeySequence::StandardKey::NextChild))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "PreviousChild", (long) QKeySequence::StandardKey::PreviousChild))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Find", (long) QKeySequence::StandardKey::Find))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "FindNext", (long) QKeySequence::StandardKey::FindNext))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "FindPrevious", (long) QKeySequence::StandardKey::FindPrevious))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Replace", (long) QKeySequence::StandardKey::Replace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectAll", (long) QKeySequence::StandardKey::SelectAll))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Bold", (long) QKeySequence::StandardKey::Bold))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Italic", (long) QKeySequence::StandardKey::Italic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Underline", (long) QKeySequence::StandardKey::Underline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToNextChar", (long) QKeySequence::StandardKey::MoveToNextChar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToPreviousChar", (long) QKeySequence::StandardKey::MoveToPreviousChar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToNextWord", (long) QKeySequence::StandardKey::MoveToNextWord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToPreviousWord", (long) QKeySequence::StandardKey::MoveToPreviousWord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToNextLine", (long) QKeySequence::StandardKey::MoveToNextLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToPreviousLine", (long) QKeySequence::StandardKey::MoveToPreviousLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToNextPage", (long) QKeySequence::StandardKey::MoveToNextPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToPreviousPage", (long) QKeySequence::StandardKey::MoveToPreviousPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToStartOfLine", (long) QKeySequence::StandardKey::MoveToStartOfLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToEndOfLine", (long) QKeySequence::StandardKey::MoveToEndOfLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToStartOfBlock", (long) QKeySequence::StandardKey::MoveToStartOfBlock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToEndOfBlock", (long) QKeySequence::StandardKey::MoveToEndOfBlock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToStartOfDocument", (long) QKeySequence::StandardKey::MoveToStartOfDocument))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "MoveToEndOfDocument", (long) QKeySequence::StandardKey::MoveToEndOfDocument))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectNextChar", (long) QKeySequence::StandardKey::SelectNextChar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectPreviousChar", (long) QKeySequence::StandardKey::SelectPreviousChar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectNextWord", (long) QKeySequence::StandardKey::SelectNextWord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectPreviousWord", (long) QKeySequence::StandardKey::SelectPreviousWord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectNextLine", (long) QKeySequence::StandardKey::SelectNextLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectPreviousLine", (long) QKeySequence::StandardKey::SelectPreviousLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectNextPage", (long) QKeySequence::StandardKey::SelectNextPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectPreviousPage", (long) QKeySequence::StandardKey::SelectPreviousPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectStartOfLine", (long) QKeySequence::StandardKey::SelectStartOfLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectEndOfLine", (long) QKeySequence::StandardKey::SelectEndOfLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectStartOfBlock", (long) QKeySequence::StandardKey::SelectStartOfBlock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectEndOfBlock", (long) QKeySequence::StandardKey::SelectEndOfBlock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectStartOfDocument", (long) QKeySequence::StandardKey::SelectStartOfDocument))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SelectEndOfDocument", (long) QKeySequence::StandardKey::SelectEndOfDocument))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "DeleteStartOfWord", (long) QKeySequence::StandardKey::DeleteStartOfWord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "DeleteEndOfWord", (long) QKeySequence::StandardKey::DeleteEndOfWord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "DeleteEndOfLine", (long) QKeySequence::StandardKey::DeleteEndOfLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "InsertParagraphSeparator", (long) QKeySequence::StandardKey::InsertParagraphSeparator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "InsertLineSeparator", (long) QKeySequence::StandardKey::InsertLineSeparator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "SaveAs", (long) QKeySequence::StandardKey::SaveAs))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Preferences", (long) QKeySequence::StandardKey::Preferences))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Quit", (long) QKeySequence::StandardKey::Quit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "FullScreen", (long) QKeySequence::StandardKey::FullScreen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Deselect", (long) QKeySequence::StandardKey::Deselect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "DeleteCompleteLine", (long) QKeySequence::StandardKey::DeleteCompleteLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Backspace", (long) QKeySequence::StandardKey::Backspace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
        Sbk_QKeySequence_TypeF(), "Cancel", (long) QKeySequence::StandardKey::Cancel))
        return;
    // Register converter for enum 'QKeySequence::StandardKey'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX],
            QKeySequence_StandardKey_CppToPython_QKeySequence_StandardKey);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QKeySequence_StandardKey_PythonToCpp_QKeySequence_StandardKey,
            is_QKeySequence_StandardKey_PythonToCpp_QKeySequence_StandardKey_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QKeySequence::StandardKey");
        Shiboken::Conversions::registerConverterName(converter, "StandardKey");
    }
    // End of 'StandardKey' enum.

    // Initialization of enum 'SequenceFormat'.
    SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QKeySequence_TypeF(),
        "SequenceFormat",
        "2:PySide2.QtGui.QKeySequence.SequenceFormat",
        "QKeySequence::SequenceFormat");
    if (!SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX],
        Sbk_QKeySequence_TypeF(), "NativeText", (long) QKeySequence::SequenceFormat::NativeText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX],
        Sbk_QKeySequence_TypeF(), "PortableText", (long) QKeySequence::SequenceFormat::PortableText))
        return;
    // Register converter for enum 'QKeySequence::SequenceFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX],
            QKeySequence_SequenceFormat_CppToPython_QKeySequence_SequenceFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QKeySequence_SequenceFormat_PythonToCpp_QKeySequence_SequenceFormat,
            is_QKeySequence_SequenceFormat_PythonToCpp_QKeySequence_SequenceFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QKeySequence::SequenceFormat");
        Shiboken::Conversions::registerConverterName(converter, "SequenceFormat");
    }
    // End of 'SequenceFormat' enum.

    // Initialization of enum 'SequenceMatch'.
    SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QKeySequence_TypeF(),
        "SequenceMatch",
        "2:PySide2.QtGui.QKeySequence.SequenceMatch",
        "QKeySequence::SequenceMatch");
    if (!SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX],
        Sbk_QKeySequence_TypeF(), "NoMatch", (long) QKeySequence::SequenceMatch::NoMatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX],
        Sbk_QKeySequence_TypeF(), "PartialMatch", (long) QKeySequence::SequenceMatch::PartialMatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX],
        Sbk_QKeySequence_TypeF(), "ExactMatch", (long) QKeySequence::SequenceMatch::ExactMatch))
        return;
    // Register converter for enum 'QKeySequence::SequenceMatch'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX],
            QKeySequence_SequenceMatch_CppToPython_QKeySequence_SequenceMatch);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QKeySequence_SequenceMatch_PythonToCpp_QKeySequence_SequenceMatch,
            is_QKeySequence_SequenceMatch_PythonToCpp_QKeySequence_SequenceMatch_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QKeySequence::SequenceMatch");
        Shiboken::Conversions::registerConverterName(converter, "SequenceMatch");
    }
    // End of 'SequenceMatch' enum.

    qRegisterMetaType< ::QKeySequence >("QKeySequence");
    qRegisterMetaType< ::QKeySequence::StandardKey >("QKeySequence::StandardKey");
    qRegisterMetaType< ::QKeySequence::SequenceFormat >("QKeySequence::SequenceFormat");
    qRegisterMetaType< ::QKeySequence::SequenceMatch >("QKeySequence::SequenceMatch");
}
