/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qinputmethod_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtGui/qtransform.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qlocale.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qrect.h>
#include <qthread.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QInputMethodFunc_anchorRectangle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.anchorRectangle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // anchorRectangle()const
            QRectF cppResult = const_cast<const ::QInputMethod *>(cppSelf)->anchorRectangle();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodFunc_commit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.commit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // commit()
            cppSelf->commit();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QInputMethodFunc_cursorRectangle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.cursorRectangle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cursorRectangle()const
            QRectF cppResult = const_cast<const ::QInputMethod *>(cppSelf)->cursorRectangle();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodFunc_hide(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.hide";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hide()
            cppSelf->hide();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QInputMethodFunc_inputDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.inputDirection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // inputDirection()const
            Qt::LayoutDirection cppResult = const_cast<const ::QInputMethod *>(cppSelf)->inputDirection();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodFunc_inputItemClipRectangle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.inputItemClipRectangle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // inputItemClipRectangle()const
            QRectF cppResult = const_cast<const ::QInputMethod *>(cppSelf)->inputItemClipRectangle();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodFunc_inputItemRectangle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.inputItemRectangle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // inputItemRectangle()const
            QRectF cppResult = const_cast<const ::QInputMethod *>(cppSelf)->inputItemRectangle();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodFunc_inputItemTransform(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.inputItemTransform";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // inputItemTransform()const
            QTransform cppResult = const_cast<const ::QInputMethod *>(cppSelf)->inputItemTransform();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodFunc_invokeAction(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.invokeAction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "invokeAction", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QInputMethod::invokeAction(QInputMethod::Action,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_ACTION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // invokeAction(QInputMethod::Action,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodFunc_invokeAction_TypeError;

    // Call function/method
    {
        ::QInputMethod::Action cppArg0{QInputMethod::Click};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // invokeAction(QInputMethod::Action,int)
            cppSelf->invokeAction(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QInputMethodFunc_invokeAction_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QInputMethodFunc_isAnimating(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.isAnimating";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAnimating()const
            bool cppResult = const_cast<const ::QInputMethod *>(cppSelf)->isAnimating();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodFunc_isVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.isVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isVisible()const
            bool cppResult = const_cast<const ::QInputMethod *>(cppSelf)->isVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodFunc_keyboardRectangle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.keyboardRectangle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keyboardRectangle()const
            QRectF cppResult = const_cast<const ::QInputMethod *>(cppSelf)->keyboardRectangle();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodFunc_locale(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.locale";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // locale()const
            QLocale cppResult = const_cast<const ::QInputMethod *>(cppSelf)->locale();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QInputMethodFunc_queryFocusObject(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.queryFocusObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "queryFocusObject", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QInputMethod::queryFocusObject(Qt::InputMethodQuery,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // queryFocusObject(Qt::InputMethodQuery,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodFunc_queryFocusObject_TypeError;

    // Call function/method
    {
        ::Qt::InputMethodQuery cppArg0 = static_cast< ::Qt::InputMethodQuery>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // queryFocusObject(Qt::InputMethodQuery,QVariant)
            QVariant cppResult = ::QInputMethod::queryFocusObject(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QInputMethodFunc_queryFocusObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QInputMethodFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.reset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reset()
            cppSelf->reset();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QInputMethodFunc_setInputItemRectangle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.setInputItemRectangle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QInputMethod::setInputItemRectangle(QRectF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // setInputItemRectangle(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodFunc_setInputItemRectangle_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setInputItemRectangle(QRectF)
            cppSelf->setInputItemRectangle(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QInputMethodFunc_setInputItemRectangle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QInputMethodFunc_setInputItemTransform(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.setInputItemTransform";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QInputMethod::setInputItemTransform(QTransform)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArg)))) {
        overloadId = 0; // setInputItemTransform(QTransform)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodFunc_setInputItemTransform_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTransform cppArg0_local;
        ::QTransform *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setInputItemTransform(QTransform)
            cppSelf->setInputItemTransform(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QInputMethodFunc_setInputItemTransform_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QInputMethodFunc_setVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.setVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QInputMethod::setVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodFunc_setVisible_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVisible(bool)
            cppSelf->setVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QInputMethodFunc_setVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QInputMethodFunc_show(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.show";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // show()
            cppSelf->show();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QInputMethodFunc_update(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QInputMethod *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QInputMethod.update";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QInputMethod::update(QFlags<Qt::InputMethodQuery>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // update(QFlags<Qt::InputMethodQuery>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QInputMethodFunc_update_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::InputMethodQuery> cppArg0 = QFlags<Qt::InputMethodQuery>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // update(QFlags<Qt::InputMethodQuery>)
            cppSelf->update(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QInputMethodFunc_update_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QInputMethod_PropertyStrings[] = {
    "anchorRectangle:",
    "animating:isAnimating",
    "cursorRectangle:",
    "inputDirection:",
    "inputItemClipRectangle:",
    "keyboardRectangle:",
    "locale:",
    "visible:isVisible",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QInputMethod_methods[] = {
    {"anchorRectangle", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_anchorRectangle), METH_NOARGS},
    {"commit", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_commit), METH_NOARGS},
    {"cursorRectangle", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_cursorRectangle), METH_NOARGS},
    {"hide", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_hide), METH_NOARGS},
    {"inputDirection", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_inputDirection), METH_NOARGS},
    {"inputItemClipRectangle", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_inputItemClipRectangle), METH_NOARGS},
    {"inputItemRectangle", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_inputItemRectangle), METH_NOARGS},
    {"inputItemTransform", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_inputItemTransform), METH_NOARGS},
    {"invokeAction", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_invokeAction), METH_VARARGS},
    {"isAnimating", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_isAnimating), METH_NOARGS},
    {"isVisible", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_isVisible), METH_NOARGS},
    {"keyboardRectangle", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_keyboardRectangle), METH_NOARGS},
    {"locale", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_locale), METH_NOARGS},
    {"queryFocusObject", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_queryFocusObject), METH_VARARGS|METH_STATIC},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_reset), METH_NOARGS},
    {"setInputItemRectangle", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_setInputItemRectangle), METH_O},
    {"setInputItemTransform", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_setInputItemTransform), METH_O},
    {"setVisible", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_setVisible), METH_O},
    {"show", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_show), METH_NOARGS},
    {"update", reinterpret_cast<PyCFunction>(Sbk_QInputMethodFunc_update), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QInputMethod_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QInputMethod_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QInputMethod_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QInputMethod_Type = nullptr;
static SbkObjectType *Sbk_QInputMethod_TypeF(void)
{
    return _Sbk_QInputMethod_Type;
}

static PyType_Slot Sbk_QInputMethod_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(SbkDeallocWrapperWithPrivateDtor)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QInputMethod_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QInputMethod_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QInputMethod_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QInputMethod_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QInputMethod_spec = {
    "2:PySide2.QtGui.QInputMethod",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QInputMethod_slots
};

} //extern "C"

static void *Sbk_QInputMethod_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QInputMethod *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QInputMethod_Action_PythonToCpp_QInputMethod_Action(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QInputMethod::Action *>(cppOut) =
        static_cast<::QInputMethod::Action>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QInputMethod_Action_PythonToCpp_QInputMethod_Action_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_ACTION_IDX]))
        return QInputMethod_Action_PythonToCpp_QInputMethod_Action;
    return {};
}
static PyObject *QInputMethod_Action_CppToPython_QInputMethod_Action(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QInputMethod::Action *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_ACTION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QInputMethod_PythonToCpp_QInputMethod_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QInputMethod_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QInputMethod_PythonToCpp_QInputMethod_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QInputMethod_TypeF())))
        return QInputMethod_PythonToCpp_QInputMethod_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QInputMethod_PTR_CppToPython_QInputMethod(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QInputMethod *>(const_cast<void *>(cppIn)), Sbk_QInputMethod_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QInputMethod_SignatureStrings[] = {
    "PySide2.QtGui.QInputMethod.anchorRectangle(self)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QInputMethod.commit(self)",
    "PySide2.QtGui.QInputMethod.cursorRectangle(self)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QInputMethod.hide(self)",
    "PySide2.QtGui.QInputMethod.inputDirection(self)->PySide2.QtCore.Qt.LayoutDirection",
    "PySide2.QtGui.QInputMethod.inputItemClipRectangle(self)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QInputMethod.inputItemRectangle(self)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QInputMethod.inputItemTransform(self)->PySide2.QtGui.QTransform",
    "PySide2.QtGui.QInputMethod.invokeAction(self,a:PySide2.QtGui.QInputMethod.Action,cursorPosition:int)",
    "PySide2.QtGui.QInputMethod.isAnimating(self)->bool",
    "PySide2.QtGui.QInputMethod.isVisible(self)->bool",
    "PySide2.QtGui.QInputMethod.keyboardRectangle(self)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QInputMethod.locale(self)->PySide2.QtCore.QLocale",
    "PySide2.QtGui.QInputMethod.queryFocusObject(query:PySide2.QtCore.Qt.InputMethodQuery,argument:QVariant)->QVariant",
    "PySide2.QtGui.QInputMethod.reset(self)",
    "PySide2.QtGui.QInputMethod.setInputItemRectangle(self,rect:PySide2.QtCore.QRectF)",
    "PySide2.QtGui.QInputMethod.setInputItemTransform(self,transform:PySide2.QtGui.QTransform)",
    "PySide2.QtGui.QInputMethod.setVisible(self,visible:bool)",
    "PySide2.QtGui.QInputMethod.show(self)",
    "PySide2.QtGui.QInputMethod.update(self,queries:PySide2.QtCore.Qt.InputMethodQueries)",
    nullptr}; // Sentinel

void init_QInputMethod(PyObject *module)
{
    _Sbk_QInputMethod_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QInputMethod",
        "QInputMethod*",
        &Sbk_QInputMethod_spec,
        0,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QInputMethod_Type);
    InitSignatureStrings(pyType, QInputMethod_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QInputMethod_Type), Sbk_QInputMethod_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QInputMethod_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QInputMethod_TypeF(),
        QInputMethod_PythonToCpp_QInputMethod_PTR,
        is_QInputMethod_PythonToCpp_QInputMethod_PTR_Convertible,
        QInputMethod_PTR_CppToPython_QInputMethod);

    Shiboken::Conversions::registerConverterName(converter, "QInputMethod");
    Shiboken::Conversions::registerConverterName(converter, "QInputMethod*");
    Shiboken::Conversions::registerConverterName(converter, "QInputMethod&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QInputMethod).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QInputMethod_TypeF(), &Sbk_QInputMethod_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Action'.
    SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_ACTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QInputMethod_TypeF(),
        "Action",
        "2:PySide2.QtGui.QInputMethod.Action",
        "QInputMethod::Action");
    if (!SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_ACTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_ACTION_IDX],
        Sbk_QInputMethod_TypeF(), "Click", (long) QInputMethod::Action::Click))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_ACTION_IDX],
        Sbk_QInputMethod_TypeF(), "ContextMenu", (long) QInputMethod::Action::ContextMenu))
        return;
    // Register converter for enum 'QInputMethod::Action'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_ACTION_IDX],
            QInputMethod_Action_CppToPython_QInputMethod_Action);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QInputMethod_Action_PythonToCpp_QInputMethod_Action,
            is_QInputMethod_Action_PythonToCpp_QInputMethod_Action_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHOD_ACTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QInputMethod::Action");
        Shiboken::Conversions::registerConverterName(converter, "Action");
    }
    // End of 'Action' enum.

    PySide::Signal::registerSignals(Sbk_QInputMethod_TypeF(), &::QInputMethod::staticMetaObject);
    qRegisterMetaType< ::QInputMethod::Action >("QInputMethod::Action");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QInputMethod_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QInputMethod_TypeF(), &::QInputMethod::staticMetaObject, sizeof(::QInputMethod));
}
