/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qimagewriter_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtGui/qimage.h>
#include <qbytearray.h>
#include <qiodevice.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QImageWriter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QImageWriter >()))
        return -1;

    ::QImageWriter *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageWriter_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QImageWriter", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QImageWriter::QImageWriter()
    // 1: QImageWriter::QImageWriter(QIODevice*,QByteArray)
    // 2: QImageWriter::QImageWriter(QString,QByteArray)
    if (numArgs == 0) {
        overloadId = 0; // QImageWriter()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 1; // QImageWriter(QIODevice*,QByteArray)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QImageWriter(QString,QByteArray)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QImageWriter(QString,QByteArray)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriter_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QImageWriter()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImageWriter_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QImageWriter()
                cptr = new ::QImageWriter();
            }
            break;
        }
        case 1: // QImageWriter(QIODevice * device, const QByteArray & format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImageWriter_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QImageWriter(QIODevice*,QByteArray)
                cptr = new ::QImageWriter(cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // QImageWriter(const QString & fileName, const QByteArray & format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageWriter_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1]))))
                            goto Sbk_QImageWriter_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageWriter_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QByteArray cppArg1_local = QByteArray();
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // QImageWriter(QString,QByteArray)
                cptr = new ::QImageWriter(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QImageWriter >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QImageWriter_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QImageWriter_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QImageWriterFunc_canWrite(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.canWrite";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canWrite()const
            bool cppResult = const_cast<const ::QImageWriter *>(cppSelf)->canWrite();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_compression(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.compression";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // compression()const
            int cppResult = const_cast<const ::QImageWriter *>(cppSelf)->compression();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.description";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // description()const
            QString cppResult = const_cast<const ::QImageWriter *>(cppSelf)->description();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QIODevice * cppResult = const_cast<const ::QImageWriter *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QImageWriter::ImageWriterError cppResult = const_cast<const ::QImageWriter *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QImageWriter *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.fileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileName()const
            QString cppResult = const_cast<const ::QImageWriter *>(cppSelf)->fileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QByteArray cppResult = const_cast<const ::QImageWriter *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_gamma(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.gamma";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // gamma()const
            float cppResult = const_cast<const ::QImageWriter *>(cppSelf)->gamma();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_imageFormatsForMimeType(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.imageFormatsForMimeType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QImageWriter::imageFormatsForMimeType(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // imageFormatsForMimeType(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_imageFormatsForMimeType_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // imageFormatsForMimeType(QByteArray)
            QList<QByteArray > cppResult = ::QImageWriter::imageFormatsForMimeType(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageWriterFunc_imageFormatsForMimeType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_optimizedWrite(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.optimizedWrite";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // optimizedWrite()const
            bool cppResult = const_cast<const ::QImageWriter *>(cppSelf)->optimizedWrite();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_progressiveScanWrite(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.progressiveScanWrite";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressiveScanWrite()const
            bool cppResult = const_cast<const ::QImageWriter *>(cppSelf)->progressiveScanWrite();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_quality(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.quality";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // quality()const
            int cppResult = const_cast<const ::QImageWriter *>(cppSelf)->quality();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_setCompression(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setCompression";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::setCompression(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCompression(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setCompression_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCompression(int)
            cppSelf->setCompression(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setCompression_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_setDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setDescription";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::setDescription(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDescription(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setDescription_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDescription(QString)
            cppSelf->setDescription(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setDescription_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_setDevice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::setDevice(QIODevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevice(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setDevice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevice(QIODevice*)
            cppSelf->setDevice(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_setFileName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::setFileName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setFileName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setFileName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFileName(QString)
            cppSelf->setFileName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::setFormat(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setFormat(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFormat(QByteArray)
            cppSelf->setFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_setGamma(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setGamma";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::setGamma(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setGamma(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setGamma_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGamma(float)
            cppSelf->setGamma(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setGamma_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_setOptimizedWrite(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setOptimizedWrite";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::setOptimizedWrite(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOptimizedWrite(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setOptimizedWrite_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOptimizedWrite(bool)
            cppSelf->setOptimizedWrite(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setOptimizedWrite_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_setProgressiveScanWrite(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setProgressiveScanWrite";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::setProgressiveScanWrite(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setProgressiveScanWrite(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setProgressiveScanWrite_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProgressiveScanWrite(bool)
            cppSelf->setProgressiveScanWrite(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setProgressiveScanWrite_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_setQuality(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setQuality";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::setQuality(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setQuality(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setQuality_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setQuality(int)
            cppSelf->setQuality(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setQuality_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_setSubType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setSubType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::setSubType(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setSubType(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setSubType_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSubType(QByteArray)
            cppSelf->setSubType(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setSubType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_setText(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setText", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImageWriter::setText(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // setText(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setText(QString,QString)
            cppSelf->setText(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_setTransformation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.setTransformation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::setTransformation(QFlags<QImageIOHandler::Transformation>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTransformation(QFlags<QImageIOHandler::Transformation>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_setTransformation_TypeError;

    // Call function/method
    {
        ::QFlags<QImageIOHandler::Transformation> cppArg0 = QFlags<QImageIOHandler::Transformation>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTransformation(QFlags<QImageIOHandler::Transformation>)
            cppSelf->setTransformation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageWriterFunc_setTransformation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_subType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.subType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // subType()const
            QByteArray cppResult = const_cast<const ::QImageWriter *>(cppSelf)->subType();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_supportedImageFormats(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.supportedImageFormats";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedImageFormats()
            QList<QByteArray > cppResult = ::QImageWriter::supportedImageFormats();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_supportedMimeTypes(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.supportedMimeTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedMimeTypes()
            QList<QByteArray > cppResult = ::QImageWriter::supportedMimeTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_supportedSubTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.supportedSubTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedSubTypes()const
            QList<QByteArray > cppResult = const_cast<const ::QImageWriter *>(cppSelf)->supportedSubTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_supportsOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.supportsOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::supportsOption(QImageIOHandler::ImageOption)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // supportsOption(QImageIOHandler::ImageOption)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_supportsOption_TypeError;

    // Call function/method
    {
        ::QImageIOHandler::ImageOption cppArg0{QImageIOHandler::Size};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // supportsOption(QImageIOHandler::ImageOption)const
            bool cppResult = const_cast<const ::QImageWriter *>(cppSelf)->supportsOption(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageWriterFunc_supportsOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageWriterFunc_transformation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.transformation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transformation()const
            QFlags<QImageIOHandler::Transformation> cppResult = const_cast<const ::QImageWriter *>(cppSelf)->transformation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageWriterFunc_write(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageWriter.write";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageWriter::write(QImage)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArg)))) {
        overloadId = 0; // write(QImage)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageWriterFunc_write_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // write(QImage)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = cppSelf->write(*cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageWriterFunc_write_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QImageWriter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QImageWriter_methods[] = {
    {"canWrite", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_canWrite), METH_NOARGS},
    {"compression", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_compression), METH_NOARGS},
    {"description", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_description), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_device), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_errorString), METH_NOARGS},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_fileName), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_format), METH_NOARGS},
    {"gamma", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_gamma), METH_NOARGS},
    {"imageFormatsForMimeType", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_imageFormatsForMimeType), METH_O|METH_STATIC},
    {"optimizedWrite", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_optimizedWrite), METH_NOARGS},
    {"progressiveScanWrite", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_progressiveScanWrite), METH_NOARGS},
    {"quality", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_quality), METH_NOARGS},
    {"setCompression", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setCompression), METH_O},
    {"setDescription", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setDescription), METH_O},
    {"setDevice", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setDevice), METH_O},
    {"setFileName", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setFileName), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setFormat), METH_O},
    {"setGamma", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setGamma), METH_O},
    {"setOptimizedWrite", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setOptimizedWrite), METH_O},
    {"setProgressiveScanWrite", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setProgressiveScanWrite), METH_O},
    {"setQuality", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setQuality), METH_O},
    {"setSubType", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setSubType), METH_O},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setText), METH_VARARGS},
    {"setTransformation", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_setTransformation), METH_O},
    {"subType", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_subType), METH_NOARGS},
    {"supportedImageFormats", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_supportedImageFormats), METH_NOARGS|METH_STATIC},
    {"supportedMimeTypes", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_supportedMimeTypes), METH_NOARGS|METH_STATIC},
    {"supportedSubTypes", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_supportedSubTypes), METH_NOARGS},
    {"supportsOption", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_supportsOption), METH_O},
    {"transformation", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_transformation), METH_NOARGS},
    {"write", reinterpret_cast<PyCFunction>(Sbk_QImageWriterFunc_write), METH_O},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QImageWriter_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QImageWriter_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QImageWriter_Type = nullptr;
static SbkObjectType *Sbk_QImageWriter_TypeF(void)
{
    return _Sbk_QImageWriter_Type;
}

static PyType_Slot Sbk_QImageWriter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QImageWriter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QImageWriter_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QImageWriter_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QImageWriter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QImageWriter_spec = {
    "2:PySide2.QtGui.QImageWriter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QImageWriter_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QImageWriter_ImageWriterError_PythonToCpp_QImageWriter_ImageWriterError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QImageWriter::ImageWriterError *>(cppOut) =
        static_cast<::QImageWriter::ImageWriterError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QImageWriter_ImageWriterError_PythonToCpp_QImageWriter_ImageWriterError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX]))
        return QImageWriter_ImageWriterError_PythonToCpp_QImageWriter_ImageWriterError;
    return {};
}
static PyObject *QImageWriter_ImageWriterError_CppToPython_QImageWriter_ImageWriterError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QImageWriter::ImageWriterError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QImageWriter_PythonToCpp_QImageWriter_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QImageWriter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QImageWriter_PythonToCpp_QImageWriter_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QImageWriter_TypeF())))
        return QImageWriter_PythonToCpp_QImageWriter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QImageWriter_PTR_CppToPython_QImageWriter(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QImageWriter *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QImageWriter_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QImageWriter_SignatureStrings[] = {
    "2:PySide2.QtGui.QImageWriter(self)",
    "1:PySide2.QtGui.QImageWriter(self,device:PySide2.QtCore.QIODevice,format:PySide2.QtCore.QByteArray)",
    "0:PySide2.QtGui.QImageWriter(self,fileName:QString,format:PySide2.QtCore.QByteArray=QByteArray())",
    "PySide2.QtGui.QImageWriter.canWrite(self)->bool",
    "PySide2.QtGui.QImageWriter.compression(self)->int",
    "PySide2.QtGui.QImageWriter.description(self)->QString",
    "PySide2.QtGui.QImageWriter.device(self)->PySide2.QtCore.QIODevice",
    "PySide2.QtGui.QImageWriter.error(self)->PySide2.QtGui.QImageWriter.ImageWriterError",
    "PySide2.QtGui.QImageWriter.errorString(self)->QString",
    "PySide2.QtGui.QImageWriter.fileName(self)->QString",
    "PySide2.QtGui.QImageWriter.format(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtGui.QImageWriter.gamma(self)->float",
    "PySide2.QtGui.QImageWriter.imageFormatsForMimeType(mimeType:PySide2.QtCore.QByteArray)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtGui.QImageWriter.optimizedWrite(self)->bool",
    "PySide2.QtGui.QImageWriter.progressiveScanWrite(self)->bool",
    "PySide2.QtGui.QImageWriter.quality(self)->int",
    "PySide2.QtGui.QImageWriter.setCompression(self,compression:int)",
    "PySide2.QtGui.QImageWriter.setDescription(self,description:QString)",
    "PySide2.QtGui.QImageWriter.setDevice(self,device:PySide2.QtCore.QIODevice)",
    "PySide2.QtGui.QImageWriter.setFileName(self,fileName:QString)",
    "PySide2.QtGui.QImageWriter.setFormat(self,format:PySide2.QtCore.QByteArray)",
    "PySide2.QtGui.QImageWriter.setGamma(self,gamma:float)",
    "PySide2.QtGui.QImageWriter.setOptimizedWrite(self,optimize:bool)",
    "PySide2.QtGui.QImageWriter.setProgressiveScanWrite(self,progressive:bool)",
    "PySide2.QtGui.QImageWriter.setQuality(self,quality:int)",
    "PySide2.QtGui.QImageWriter.setSubType(self,type:PySide2.QtCore.QByteArray)",
    "PySide2.QtGui.QImageWriter.setText(self,key:QString,text:QString)",
    "PySide2.QtGui.QImageWriter.setTransformation(self,orientation:PySide2.QtGui.QImageIOHandler.Transformations)",
    "PySide2.QtGui.QImageWriter.subType(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtGui.QImageWriter.supportedImageFormats()->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtGui.QImageWriter.supportedMimeTypes()->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtGui.QImageWriter.supportedSubTypes(self)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtGui.QImageWriter.supportsOption(self,option:PySide2.QtGui.QImageIOHandler.ImageOption)->bool",
    "PySide2.QtGui.QImageWriter.transformation(self)->PySide2.QtGui.QImageIOHandler.Transformations",
    "PySide2.QtGui.QImageWriter.write(self,image:PySide2.QtGui.QImage)->bool",
    nullptr}; // Sentinel

void init_QImageWriter(PyObject *module)
{
    _Sbk_QImageWriter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QImageWriter",
        "QImageWriter*",
        &Sbk_QImageWriter_spec,
        &Shiboken::callCppDestructor< ::QImageWriter >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QImageWriter_Type);
    InitSignatureStrings(pyType, QImageWriter_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QImageWriter_Type), Sbk_QImageWriter_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QImageWriter_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QImageWriter_TypeF(),
        QImageWriter_PythonToCpp_QImageWriter_PTR,
        is_QImageWriter_PythonToCpp_QImageWriter_PTR_Convertible,
        QImageWriter_PTR_CppToPython_QImageWriter);

    Shiboken::Conversions::registerConverterName(converter, "QImageWriter");
    Shiboken::Conversions::registerConverterName(converter, "QImageWriter*");
    Shiboken::Conversions::registerConverterName(converter, "QImageWriter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QImageWriter).name());


    // Initialization of enums.

    // Initialization of enum 'ImageWriterError'.
    SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QImageWriter_TypeF(),
        "ImageWriterError",
        "2:PySide2.QtGui.QImageWriter.ImageWriterError",
        "QImageWriter::ImageWriterError");
    if (!SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX],
        Sbk_QImageWriter_TypeF(), "UnknownError", (long) QImageWriter::ImageWriterError::UnknownError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX],
        Sbk_QImageWriter_TypeF(), "DeviceError", (long) QImageWriter::ImageWriterError::DeviceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX],
        Sbk_QImageWriter_TypeF(), "UnsupportedFormatError", (long) QImageWriter::ImageWriterError::UnsupportedFormatError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX],
        Sbk_QImageWriter_TypeF(), "InvalidImageError", (long) QImageWriter::ImageWriterError::InvalidImageError))
        return;
    // Register converter for enum 'QImageWriter::ImageWriterError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX],
            QImageWriter_ImageWriterError_CppToPython_QImageWriter_ImageWriterError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QImageWriter_ImageWriterError_PythonToCpp_QImageWriter_ImageWriterError,
            is_QImageWriter_ImageWriterError_PythonToCpp_QImageWriter_ImageWriterError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGEWRITER_IMAGEWRITERERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QImageWriter::ImageWriterError");
        Shiboken::Conversions::registerConverterName(converter, "ImageWriterError");
    }
    // End of 'ImageWriterError' enum.

    qRegisterMetaType< ::QImageWriter::ImageWriterError >("QImageWriter::ImageWriterError");
}
