/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qimagereader_wrapper.h"

// inner classes

// Extra includes
#include <QColor>
#include <QImage>
#include <QList>
#include <QRect>
#include <QSize>
#include <QStringList>
#include <QtGui/qcolor.h>
#include <QtGui/qimage.h>
#include <qbytearray.h>
#include <qiodevice.h>
#include <qrect.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QImageReader_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QImageReader >()))
        return -1;

    ::QImageReader *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QImageReader_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QImageReader", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QImageReader::QImageReader()
    // 1: QImageReader::QImageReader(QIODevice*,QByteArray)
    // 2: QImageReader::QImageReader(QString,QByteArray)
    if (numArgs == 0) {
        overloadId = 0; // QImageReader()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QImageReader(QIODevice*,QByteArray)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QImageReader(QIODevice*,QByteArray)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QImageReader(QString,QByteArray)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QImageReader(QString,QByteArray)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReader_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QImageReader()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QImageReader_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QImageReader()
                cptr = new ::QImageReader();
            }
            break;
        }
        case 1: // QImageReader(QIODevice * device, const QByteArray & format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageReader_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1]))))
                            goto Sbk_QImageReader_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageReader_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QByteArray cppArg1_local = QByteArray();
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // QImageReader(QIODevice*,QByteArray)
                cptr = new ::QImageReader(cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // QImageReader(const QString & fileName, const QByteArray & format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QImageReader_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1]))))
                            goto Sbk_QImageReader_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QImageReader_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QByteArray cppArg1_local = QByteArray();
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // QImageReader(QString,QByteArray)
                cptr = new ::QImageReader(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QImageReader >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QImageReader_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QImageReader_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QImageReaderFunc_autoDetectImageFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.autoDetectImageFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoDetectImageFormat()const
            bool cppResult = const_cast<const ::QImageReader *>(cppSelf)->autoDetectImageFormat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_autoTransform(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.autoTransform";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoTransform()const
            bool cppResult = const_cast<const ::QImageReader *>(cppSelf)->autoTransform();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_backgroundColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.backgroundColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // backgroundColor()const
            QColor cppResult = const_cast<const ::QImageReader *>(cppSelf)->backgroundColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_canRead(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.canRead";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canRead()const
            bool cppResult = const_cast<const ::QImageReader *>(cppSelf)->canRead();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_clipRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.clipRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clipRect()const
            QRect cppResult = const_cast<const ::QImageReader *>(cppSelf)->clipRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_currentImageNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.currentImageNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentImageNumber()const
            int cppResult = const_cast<const ::QImageReader *>(cppSelf)->currentImageNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_currentImageRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.currentImageRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentImageRect()const
            QRect cppResult = const_cast<const ::QImageReader *>(cppSelf)->currentImageRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_decideFormatFromContent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.decideFormatFromContent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // decideFormatFromContent()const
            bool cppResult = const_cast<const ::QImageReader *>(cppSelf)->decideFormatFromContent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QIODevice * cppResult = const_cast<const ::QImageReader *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QImageReader::ImageReaderError cppResult = const_cast<const ::QImageReader *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QImageReader *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.fileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileName()const
            QString cppResult = const_cast<const ::QImageReader *>(cppSelf)->fileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QByteArray cppResult = const_cast<const ::QImageReader *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_gamma(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.gamma";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // gamma()const
            float cppResult = const_cast<const ::QImageReader *>(cppSelf)->gamma();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_imageCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.imageCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // imageCount()const
            int cppResult = const_cast<const ::QImageReader *>(cppSelf)->imageCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_imageFormat(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QImageReader *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.imageFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "imageFormat", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QImageReader::imageFormat()const
    // 1: static QImageReader::imageFormat(QIODevice*)
    // 2: static QImageReader::imageFormat(QString)
    if (numArgs == 0) {
        overloadId = 0; // imageFormat()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // imageFormat(QIODevice*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 2; // imageFormat(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_imageFormat_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // imageFormat() const
        {

            if (!PyErr_Occurred()) {
                // imageFormat()const
                QImage::Format cppResult = const_cast<const ::QImageReader *>(cppSelf)->imageFormat();
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, &cppResult);
            }
            break;
        }
        case 1: // imageFormat(QIODevice * device)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // imageFormat(QIODevice*)
                QByteArray cppResult = ::QImageReader::imageFormat(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 2: // imageFormat(const QString & fileName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // imageFormat(QString)
                QByteArray cppResult = ::QImageReader::imageFormat(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageReaderFunc_imageFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_imageFormatsForMimeType(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.imageFormatsForMimeType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QImageReader::imageFormatsForMimeType(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // imageFormatsForMimeType(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_imageFormatsForMimeType_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // imageFormatsForMimeType(QByteArray)
            QList<QByteArray > cppResult = ::QImageReader::imageFormatsForMimeType(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageReaderFunc_imageFormatsForMimeType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_jumpToImage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.jumpToImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::jumpToImage(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // jumpToImage(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_jumpToImage_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // jumpToImage(int)
            bool cppResult = cppSelf->jumpToImage(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageReaderFunc_jumpToImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_jumpToNextImage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.jumpToNextImage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // jumpToNextImage()
            bool cppResult = cppSelf->jumpToNextImage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_loopCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.loopCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loopCount()const
            int cppResult = const_cast<const ::QImageReader *>(cppSelf)->loopCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_nextImageDelay(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.nextImageDelay";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nextImageDelay()const
            int cppResult = const_cast<const ::QImageReader *>(cppSelf)->nextImageDelay();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_quality(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.quality";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // quality()const
            int cppResult = const_cast<const ::QImageReader *>(cppSelf)->quality();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_read(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.read";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // read()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QImage cppResult = cppSelf->read();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_scaledClipRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.scaledClipRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scaledClipRect()const
            QRect cppResult = const_cast<const ::QImageReader *>(cppSelf)->scaledClipRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_scaledSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.scaledSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scaledSize()const
            QSize cppResult = const_cast<const ::QImageReader *>(cppSelf)->scaledSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_setAutoDetectImageFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setAutoDetectImageFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setAutoDetectImageFormat(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoDetectImageFormat(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setAutoDetectImageFormat_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoDetectImageFormat(bool)
            cppSelf->setAutoDetectImageFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setAutoDetectImageFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_setAutoTransform(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setAutoTransform";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setAutoTransform(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoTransform(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setAutoTransform_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoTransform(bool)
            cppSelf->setAutoTransform(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setAutoTransform_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_setBackgroundColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setBackgroundColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setBackgroundColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setBackgroundColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setBackgroundColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBackgroundColor(QColor)
            cppSelf->setBackgroundColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setBackgroundColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_setClipRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setClipRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setClipRect(QRect)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 0; // setClipRect(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setClipRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setClipRect(QRect)
            cppSelf->setClipRect(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setClipRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_setDecideFormatFromContent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setDecideFormatFromContent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setDecideFormatFromContent(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDecideFormatFromContent(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setDecideFormatFromContent_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDecideFormatFromContent(bool)
            cppSelf->setDecideFormatFromContent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setDecideFormatFromContent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_setDevice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setDevice(QIODevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevice(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setDevice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevice(QIODevice*)
            cppSelf->setDevice(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_setFileName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setFileName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setFileName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setFileName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFileName(QString)
            cppSelf->setFileName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setFormat(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setFormat(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFormat(QByteArray)
            cppSelf->setFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_setGamma(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setGamma";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setGamma(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setGamma(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setGamma_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGamma(float)
            cppSelf->setGamma(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setGamma_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_setQuality(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setQuality";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setQuality(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setQuality(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setQuality_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setQuality(int)
            cppSelf->setQuality(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setQuality_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_setScaledClipRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setScaledClipRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setScaledClipRect(QRect)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 0; // setScaledClipRect(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setScaledClipRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setScaledClipRect(QRect)
            cppSelf->setScaledClipRect(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setScaledClipRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_setScaledSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.setScaledSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::setScaledSize(QSize)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArg)))) {
        overloadId = 0; // setScaledSize(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_setScaledSize_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSize cppArg0_local;
        ::QSize *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setScaledSize(QSize)
            cppSelf->setScaledSize(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageReaderFunc_setScaledSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSize cppResult = const_cast<const ::QImageReader *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_subType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.subType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // subType()const
            QByteArray cppResult = const_cast<const ::QImageReader *>(cppSelf)->subType();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_supportedImageFormats(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.supportedImageFormats";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedImageFormats()
            QList<QByteArray > cppResult = ::QImageReader::supportedImageFormats();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_supportedMimeTypes(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.supportedMimeTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedMimeTypes()
            QList<QByteArray > cppResult = ::QImageReader::supportedMimeTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_supportedSubTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.supportedSubTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedSubTypes()const
            QList<QByteArray > cppResult = const_cast<const ::QImageReader *>(cppSelf)->supportedSubTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_supportsAnimation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.supportsAnimation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsAnimation()const
            bool cppResult = const_cast<const ::QImageReader *>(cppSelf)->supportsAnimation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_supportsOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.supportsOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::supportsOption(QImageIOHandler::ImageOption)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // supportsOption(QImageIOHandler::ImageOption)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_supportsOption_TypeError;

    // Call function/method
    {
        ::QImageIOHandler::ImageOption cppArg0{QImageIOHandler::Size};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // supportsOption(QImageIOHandler::ImageOption)const
            bool cppResult = const_cast<const ::QImageReader *>(cppSelf)->supportsOption(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageReaderFunc_supportsOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_text(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.text";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageReader::text(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // text(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageReaderFunc_text_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // text(QString)const
            QString cppResult = const_cast<const ::QImageReader *>(cppSelf)->text(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageReaderFunc_text_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageReaderFunc_textKeys(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.textKeys";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textKeys()const
            QStringList cppResult = const_cast<const ::QImageReader *>(cppSelf)->textKeys();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageReaderFunc_transformation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageReader.transformation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transformation()const
            QFlags<QImageIOHandler::Transformation> cppResult = const_cast<const ::QImageReader *>(cppSelf)->transformation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyMethodDef Sbk_QImageReaderMethod_imageFormat = {
    "imageFormat", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_imageFormat), METH_VARARGS|METH_STATIC
};


static const char *Sbk_QImageReader_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QImageReader_methods[] = {
    {"autoDetectImageFormat", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_autoDetectImageFormat), METH_NOARGS},
    {"autoTransform", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_autoTransform), METH_NOARGS},
    {"backgroundColor", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_backgroundColor), METH_NOARGS},
    {"canRead", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_canRead), METH_NOARGS},
    {"clipRect", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_clipRect), METH_NOARGS},
    {"currentImageNumber", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_currentImageNumber), METH_NOARGS},
    {"currentImageRect", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_currentImageRect), METH_NOARGS},
    {"decideFormatFromContent", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_decideFormatFromContent), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_device), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_errorString), METH_NOARGS},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_fileName), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_format), METH_NOARGS},
    {"gamma", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_gamma), METH_NOARGS},
    {"imageCount", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_imageCount), METH_NOARGS},
    Sbk_QImageReaderMethod_imageFormat,
    {"imageFormatsForMimeType", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_imageFormatsForMimeType), METH_O|METH_STATIC},
    {"jumpToImage", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_jumpToImage), METH_O},
    {"jumpToNextImage", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_jumpToNextImage), METH_NOARGS},
    {"loopCount", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_loopCount), METH_NOARGS},
    {"nextImageDelay", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_nextImageDelay), METH_NOARGS},
    {"quality", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_quality), METH_NOARGS},
    {"read", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_read), METH_NOARGS},
    {"scaledClipRect", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_scaledClipRect), METH_NOARGS},
    {"scaledSize", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_scaledSize), METH_NOARGS},
    {"setAutoDetectImageFormat", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setAutoDetectImageFormat), METH_O},
    {"setAutoTransform", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setAutoTransform), METH_O},
    {"setBackgroundColor", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setBackgroundColor), METH_O},
    {"setClipRect", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setClipRect), METH_O},
    {"setDecideFormatFromContent", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setDecideFormatFromContent), METH_O},
    {"setDevice", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setDevice), METH_O},
    {"setFileName", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setFileName), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setFormat), METH_O},
    {"setGamma", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setGamma), METH_O},
    {"setQuality", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setQuality), METH_O},
    {"setScaledClipRect", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setScaledClipRect), METH_O},
    {"setScaledSize", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_setScaledSize), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_size), METH_NOARGS},
    {"subType", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_subType), METH_NOARGS},
    {"supportedImageFormats", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_supportedImageFormats), METH_NOARGS|METH_STATIC},
    {"supportedMimeTypes", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_supportedMimeTypes), METH_NOARGS|METH_STATIC},
    {"supportedSubTypes", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_supportedSubTypes), METH_NOARGS},
    {"supportsAnimation", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_supportsAnimation), METH_NOARGS},
    {"supportsOption", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_supportsOption), METH_O},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_text), METH_O},
    {"textKeys", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_textKeys), METH_NOARGS},
    {"transformation", reinterpret_cast<PyCFunction>(Sbk_QImageReaderFunc_transformation), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QImageReader_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    if (auto ob_dict = reinterpret_cast<SbkObject *>(self)->ob_dict) {
        if (auto meth = PyDict_GetItem(ob_dict, name)) {
            Py_INCREF(meth);
            return meth;
        }
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        if (auto meth = PyDict_GetItem(Py_TYPE(self)->tp_dict, tmp))
            return PyFunction_Check(meth) ? SBK_PyMethod_New(meth, self) : PyObject_GenericGetAttr(self, name);
    }
    static PyMethodDef non_static_Sbk_QImageReaderMethod_imageFormat = {
        Sbk_QImageReaderMethod_imageFormat.ml_name,
        Sbk_QImageReaderMethod_imageFormat.ml_meth,
        Sbk_QImageReaderMethod_imageFormat.ml_flags & (~METH_STATIC),
        Sbk_QImageReaderMethod_imageFormat.ml_doc,
    };
    if (Shiboken::String::compare(name, "imageFormat") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QImageReaderMethod_imageFormat, self, 0);
    return PyObject_GenericGetAttr(self, name);
}

} // extern "C"

static int Sbk_QImageReader_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QImageReader_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QImageReader_Type = nullptr;
static SbkObjectType *Sbk_QImageReader_TypeF(void)
{
    return _Sbk_QImageReader_Type;
}

static PyType_Slot Sbk_QImageReader_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QImageReader_getattro)},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QImageReader_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QImageReader_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QImageReader_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QImageReader_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QImageReader_spec = {
    "2:PySide2.QtGui.QImageReader",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QImageReader_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QImageReader_ImageReaderError_PythonToCpp_QImageReader_ImageReaderError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QImageReader::ImageReaderError *>(cppOut) =
        static_cast<::QImageReader::ImageReaderError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QImageReader_ImageReaderError_PythonToCpp_QImageReader_ImageReaderError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX]))
        return QImageReader_ImageReaderError_PythonToCpp_QImageReader_ImageReaderError;
    return {};
}
static PyObject *QImageReader_ImageReaderError_CppToPython_QImageReader_ImageReaderError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QImageReader::ImageReaderError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QImageReader_PythonToCpp_QImageReader_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QImageReader_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QImageReader_PythonToCpp_QImageReader_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QImageReader_TypeF())))
        return QImageReader_PythonToCpp_QImageReader_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QImageReader_PTR_CppToPython_QImageReader(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QImageReader *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QImageReader_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QImageReader_SignatureStrings[] = {
    "2:PySide2.QtGui.QImageReader(self)",
    "1:PySide2.QtGui.QImageReader(self,device:PySide2.QtCore.QIODevice,format:PySide2.QtCore.QByteArray=QByteArray())",
    "0:PySide2.QtGui.QImageReader(self,fileName:QString,format:PySide2.QtCore.QByteArray=QByteArray())",
    "PySide2.QtGui.QImageReader.autoDetectImageFormat(self)->bool",
    "PySide2.QtGui.QImageReader.autoTransform(self)->bool",
    "PySide2.QtGui.QImageReader.backgroundColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QImageReader.canRead(self)->bool",
    "PySide2.QtGui.QImageReader.clipRect(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QImageReader.currentImageNumber(self)->int",
    "PySide2.QtGui.QImageReader.currentImageRect(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QImageReader.decideFormatFromContent(self)->bool",
    "PySide2.QtGui.QImageReader.device(self)->PySide2.QtCore.QIODevice",
    "PySide2.QtGui.QImageReader.error(self)->PySide2.QtGui.QImageReader.ImageReaderError",
    "PySide2.QtGui.QImageReader.errorString(self)->QString",
    "PySide2.QtGui.QImageReader.fileName(self)->QString",
    "PySide2.QtGui.QImageReader.format(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtGui.QImageReader.gamma(self)->float",
    "PySide2.QtGui.QImageReader.imageCount(self)->int",
    "2:PySide2.QtGui.QImageReader.imageFormat(self)->PySide2.QtGui.QImage.Format",
    "1:PySide2.QtGui.QImageReader.imageFormat(device:PySide2.QtCore.QIODevice)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtGui.QImageReader.imageFormat(fileName:QString)->PySide2.QtCore.QByteArray",
    "PySide2.QtGui.QImageReader.imageFormatsForMimeType(mimeType:PySide2.QtCore.QByteArray)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtGui.QImageReader.jumpToImage(self,imageNumber:int)->bool",
    "PySide2.QtGui.QImageReader.jumpToNextImage(self)->bool",
    "PySide2.QtGui.QImageReader.loopCount(self)->int",
    "PySide2.QtGui.QImageReader.nextImageDelay(self)->int",
    "PySide2.QtGui.QImageReader.quality(self)->int",
    "PySide2.QtGui.QImageReader.read(self)->PySide2.QtGui.QImage",
    "PySide2.QtGui.QImageReader.scaledClipRect(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QImageReader.scaledSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QImageReader.setAutoDetectImageFormat(self,enabled:bool)",
    "PySide2.QtGui.QImageReader.setAutoTransform(self,enabled:bool)",
    "PySide2.QtGui.QImageReader.setBackgroundColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtGui.QImageReader.setClipRect(self,rect:PySide2.QtCore.QRect)",
    "PySide2.QtGui.QImageReader.setDecideFormatFromContent(self,ignored:bool)",
    "PySide2.QtGui.QImageReader.setDevice(self,device:PySide2.QtCore.QIODevice)",
    "PySide2.QtGui.QImageReader.setFileName(self,fileName:QString)",
    "PySide2.QtGui.QImageReader.setFormat(self,format:PySide2.QtCore.QByteArray)",
    "PySide2.QtGui.QImageReader.setGamma(self,gamma:float)",
    "PySide2.QtGui.QImageReader.setQuality(self,quality:int)",
    "PySide2.QtGui.QImageReader.setScaledClipRect(self,rect:PySide2.QtCore.QRect)",
    "PySide2.QtGui.QImageReader.setScaledSize(self,size:PySide2.QtCore.QSize)",
    "PySide2.QtGui.QImageReader.size(self)->PySide2.QtCore.QSize",
    "PySide2.QtGui.QImageReader.subType(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtGui.QImageReader.supportedImageFormats()->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtGui.QImageReader.supportedMimeTypes()->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtGui.QImageReader.supportedSubTypes(self)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtGui.QImageReader.supportsAnimation(self)->bool",
    "PySide2.QtGui.QImageReader.supportsOption(self,option:PySide2.QtGui.QImageIOHandler.ImageOption)->bool",
    "PySide2.QtGui.QImageReader.text(self,key:QString)->QString",
    "PySide2.QtGui.QImageReader.textKeys(self)->QStringList",
    "PySide2.QtGui.QImageReader.transformation(self)->PySide2.QtGui.QImageIOHandler.Transformations",
    nullptr}; // Sentinel

void init_QImageReader(PyObject *module)
{
    _Sbk_QImageReader_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QImageReader",
        "QImageReader*",
        &Sbk_QImageReader_spec,
        &Shiboken::callCppDestructor< ::QImageReader >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QImageReader_Type);
    InitSignatureStrings(pyType, QImageReader_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QImageReader_Type), Sbk_QImageReader_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QImageReader_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QImageReader_TypeF(),
        QImageReader_PythonToCpp_QImageReader_PTR,
        is_QImageReader_PythonToCpp_QImageReader_PTR_Convertible,
        QImageReader_PTR_CppToPython_QImageReader);

    Shiboken::Conversions::registerConverterName(converter, "QImageReader");
    Shiboken::Conversions::registerConverterName(converter, "QImageReader*");
    Shiboken::Conversions::registerConverterName(converter, "QImageReader&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QImageReader).name());


    // Initialization of enums.

    // Initialization of enum 'ImageReaderError'.
    SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QImageReader_TypeF(),
        "ImageReaderError",
        "2:PySide2.QtGui.QImageReader.ImageReaderError",
        "QImageReader::ImageReaderError");
    if (!SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX],
        Sbk_QImageReader_TypeF(), "UnknownError", (long) QImageReader::ImageReaderError::UnknownError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX],
        Sbk_QImageReader_TypeF(), "FileNotFoundError", (long) QImageReader::ImageReaderError::FileNotFoundError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX],
        Sbk_QImageReader_TypeF(), "DeviceError", (long) QImageReader::ImageReaderError::DeviceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX],
        Sbk_QImageReader_TypeF(), "UnsupportedFormatError", (long) QImageReader::ImageReaderError::UnsupportedFormatError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX],
        Sbk_QImageReader_TypeF(), "InvalidDataError", (long) QImageReader::ImageReaderError::InvalidDataError))
        return;
    // Register converter for enum 'QImageReader::ImageReaderError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX],
            QImageReader_ImageReaderError_CppToPython_QImageReader_ImageReaderError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QImageReader_ImageReaderError_PythonToCpp_QImageReader_ImageReaderError,
            is_QImageReader_ImageReaderError_PythonToCpp_QImageReader_ImageReaderError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QImageReader::ImageReaderError");
        Shiboken::Conversions::registerConverterName(converter, "ImageReaderError");
    }
    // End of 'ImageReaderError' enum.

    qRegisterMetaType< ::QImageReader::ImageReaderError >("QImageReader::ImageReaderError");
}
