/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qimageiohandler_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QImageIOHandlerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QImageIOHandlerWrapper::QImageIOHandlerWrapper() : QImageIOHandler()
{
    resetPyMethodCache();
    // ... middle
}

bool QImageIOHandlerWrapper::canRead() const
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QImageIOHandler.canRead()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "canRead";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QImageIOHandler.canRead()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.canRead", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QImageIOHandlerWrapper::currentImageNumber() const
{
    if (m_PyMethodCache[1])
        return this->::QImageIOHandler::currentImageNumber();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "currentImageNumber";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QImageIOHandler::currentImageNumber();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.currentImageNumber", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QRect QImageIOHandlerWrapper::currentImageRect() const
{
    if (m_PyMethodCache[2])
        return this->::QImageIOHandler::currentImageRect();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "currentImageRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QImageIOHandler::currentImageRect();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.currentImageRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRect >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRect cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QImageIOHandlerWrapper::imageCount() const
{
    if (m_PyMethodCache[3])
        return this->::QImageIOHandler::imageCount();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "imageCount";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QImageIOHandler::imageCount();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.imageCount", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QImageIOHandlerWrapper::jumpToImage(int imageNumber)
{
    if (m_PyMethodCache[4])
        return this->::QImageIOHandler::jumpToImage(imageNumber);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "jumpToImage";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QImageIOHandler::jumpToImage(imageNumber);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    imageNumber
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.jumpToImage", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QImageIOHandlerWrapper::jumpToNextImage()
{
    if (m_PyMethodCache[5])
        return this->::QImageIOHandler::jumpToNextImage();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "jumpToNextImage";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QImageIOHandler::jumpToNextImage();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.jumpToNextImage", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QImageIOHandlerWrapper::loopCount() const
{
    if (m_PyMethodCache[6])
        return this->::QImageIOHandler::loopCount();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "loopCount";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QImageIOHandler::loopCount();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.loopCount", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QByteArray QImageIOHandlerWrapper::name() const
{
    if (m_PyMethodCache[7])
        return this->::QImageIOHandler::name();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "name";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QImageIOHandler::name();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.name", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QByteArray >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QByteArray cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QImageIOHandlerWrapper::nextImageDelay() const
{
    if (m_PyMethodCache[8])
        return this->::QImageIOHandler::nextImageDelay();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nextImageDelay";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QImageIOHandler::nextImageDelay();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.nextImageDelay", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVariant QImageIOHandlerWrapper::option(::QImageIOHandler::ImageOption option) const
{
    if (m_PyMethodCache[9])
        return this->::QImageIOHandler::option(option);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "option";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QImageIOHandler::option(option);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX])->converter, &option)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.option", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QImageIOHandlerWrapper::read(::QImage * image)
{
    if (m_PyMethodCache[10]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QImageIOHandler.read()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "read";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QImageIOHandler.read()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), image)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.read", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QImageIOHandlerWrapper::setOption(::QImageIOHandler::ImageOption option, const ::QVariant & value)
{
    if (m_PyMethodCache[11]) {
        return this->::QImageIOHandler::setOption(option, value);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setOption";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QImageIOHandler::setOption(option, value);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX])->converter, &option),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QImageIOHandlerWrapper::supportsOption(::QImageIOHandler::ImageOption option) const
{
    if (m_PyMethodCache[12])
        return this->::QImageIOHandler::supportsOption(option);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "supportsOption";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QImageIOHandler::supportsOption(option);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX])->converter, &option)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.supportsOption", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QImageIOHandlerWrapper::write(const ::QImage & image)
{
    if (m_PyMethodCache[13])
        return this->::QImageIOHandler::write(image);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "write";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QImageIOHandler::write(image);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &image)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QImageIOHandler.write", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QImageIOHandlerWrapper::~QImageIOHandlerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QImageIOHandler_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QImageIOHandler' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QImageIOHandler >()))
        return -1;

    ::QImageIOHandlerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QImageIOHandler()
            cptr = new ::QImageIOHandlerWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QImageIOHandler >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QImageIOHandlerFunc_canRead(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.canRead";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canRead()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QImageIOHandler.canRead()' not implemented.");
                return {};
            }
            bool cppResult = const_cast<const ::QImageIOHandler *>(cppSelf)->canRead();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageIOHandlerFunc_currentImageNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.currentImageNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentImageNumber()const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QImageIOHandler *>(cppSelf)->::QImageIOHandler::currentImageNumber()
                : const_cast<const ::QImageIOHandler *>(cppSelf)->currentImageNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageIOHandlerFunc_currentImageRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.currentImageRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentImageRect()const
            QRect cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QImageIOHandler *>(cppSelf)->::QImageIOHandler::currentImageRect()
                : const_cast<const ::QImageIOHandler *>(cppSelf)->currentImageRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageIOHandlerFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QIODevice * cppResult = const_cast<const ::QImageIOHandler *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageIOHandlerFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QByteArray cppResult = const_cast<const ::QImageIOHandler *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageIOHandlerFunc_imageCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.imageCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // imageCount()const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QImageIOHandler *>(cppSelf)->::QImageIOHandler::imageCount()
                : const_cast<const ::QImageIOHandler *>(cppSelf)->imageCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageIOHandlerFunc_jumpToImage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.jumpToImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageIOHandler::jumpToImage(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // jumpToImage(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageIOHandlerFunc_jumpToImage_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // jumpToImage(int)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QImageIOHandler::jumpToImage(cppArg0)
                : cppSelf->jumpToImage(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageIOHandlerFunc_jumpToImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageIOHandlerFunc_jumpToNextImage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.jumpToNextImage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // jumpToNextImage()
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QImageIOHandler::jumpToNextImage()
                : cppSelf->jumpToNextImage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageIOHandlerFunc_loopCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.loopCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loopCount()const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QImageIOHandler *>(cppSelf)->::QImageIOHandler::loopCount()
                : const_cast<const ::QImageIOHandler *>(cppSelf)->loopCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageIOHandlerFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QByteArray cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QImageIOHandler *>(cppSelf)->::QImageIOHandler::name()
                : const_cast<const ::QImageIOHandler *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageIOHandlerFunc_nextImageDelay(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.nextImageDelay";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nextImageDelay()const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QImageIOHandler *>(cppSelf)->::QImageIOHandler::nextImageDelay()
                : const_cast<const ::QImageIOHandler *>(cppSelf)->nextImageDelay();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageIOHandlerFunc_option(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.option";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageIOHandler::option(QImageIOHandler::ImageOption)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // option(QImageIOHandler::ImageOption)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageIOHandlerFunc_option_TypeError;

    // Call function/method
    {
        ::QImageIOHandler::ImageOption cppArg0{QImageIOHandler::Size};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // option(QImageIOHandler::ImageOption)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QImageIOHandler *>(cppSelf)->::QImageIOHandler::option(cppArg0)
                : const_cast<const ::QImageIOHandler *>(cppSelf)->option(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageIOHandlerFunc_option_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageIOHandlerFunc_read(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.read";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageIOHandler::read(QImage*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArg)))) {
        overloadId = 0; // read(QImage*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageIOHandlerFunc_read_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QImage *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // read(QImage*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QImageIOHandler.read()' not implemented.");
                return {};
            }
            bool cppResult = cppSelf->read(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageIOHandlerFunc_read_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageIOHandlerFunc_setDevice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.setDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageIOHandler::setDevice(QIODevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevice(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageIOHandlerFunc_setDevice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevice(QIODevice*)
            cppSelf->setDevice(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageIOHandlerFunc_setDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageIOHandlerFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageIOHandler::setFormat(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setFormat(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageIOHandlerFunc_setFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFormat(QByteArray)
            cppSelf->setFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageIOHandlerFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageIOHandlerFunc_setOption(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.setOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setOption", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImageIOHandler::setOption(QImageIOHandler::ImageOption,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setOption(QImageIOHandler::ImageOption,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageIOHandlerFunc_setOption_TypeError;

    // Call function/method
    {
        ::QImageIOHandler::ImageOption cppArg0{QImageIOHandler::Size};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setOption(QImageIOHandler::ImageOption,QVariant)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QImageIOHandler::setOption(cppArg0, cppArg1)
                : cppSelf->setOption(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageIOHandlerFunc_setOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageIOHandlerFunc_supportsOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.supportsOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageIOHandler::supportsOption(QImageIOHandler::ImageOption)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // supportsOption(QImageIOHandler::ImageOption)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageIOHandlerFunc_supportsOption_TypeError;

    // Call function/method
    {
        ::QImageIOHandler::ImageOption cppArg0{QImageIOHandler::Size};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // supportsOption(QImageIOHandler::ImageOption)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QImageIOHandler *>(cppSelf)->::QImageIOHandler::supportsOption(cppArg0)
                : const_cast<const ::QImageIOHandler *>(cppSelf)->supportsOption(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageIOHandlerFunc_supportsOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageIOHandlerFunc_write(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QImageIOHandler.write";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageIOHandler::write(QImage)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArg)))) {
        overloadId = 0; // write(QImage)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageIOHandlerFunc_write_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // write(QImage)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QImageIOHandler::write(*cppArg0)
                : cppSelf->write(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageIOHandlerFunc_write_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QImageIOHandler_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QImageIOHandler_methods[] = {
    {"canRead", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_canRead), METH_NOARGS},
    {"currentImageNumber", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_currentImageNumber), METH_NOARGS},
    {"currentImageRect", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_currentImageRect), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_device), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_format), METH_NOARGS},
    {"imageCount", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_imageCount), METH_NOARGS},
    {"jumpToImage", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_jumpToImage), METH_O},
    {"jumpToNextImage", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_jumpToNextImage), METH_NOARGS},
    {"loopCount", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_loopCount), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_name), METH_NOARGS},
    {"nextImageDelay", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_nextImageDelay), METH_NOARGS},
    {"option", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_option), METH_O},
    {"read", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_read), METH_O},
    {"setDevice", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_setDevice), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_setFormat), METH_O},
    {"setOption", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_setOption), METH_VARARGS},
    {"supportsOption", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_supportsOption), METH_O},
    {"write", reinterpret_cast<PyCFunction>(Sbk_QImageIOHandlerFunc_write), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QImageIOHandler_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QImageIOHandler *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QImageIOHandlerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QImageIOHandler_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QImageIOHandler_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QImageIOHandler_Type = nullptr;
static SbkObjectType *Sbk_QImageIOHandler_TypeF(void)
{
    return _Sbk_QImageIOHandler_Type;
}

static PyType_Slot Sbk_QImageIOHandler_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QImageIOHandler_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QImageIOHandler_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QImageIOHandler_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QImageIOHandler_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QImageIOHandler_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QImageIOHandler_spec = {
    "2:PySide2.QtGui.QImageIOHandler",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QImageIOHandler_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QImageIOHandler_Transformation___and__(PyObject *self, PyObject *pyArg)
{
    ::QImageIOHandler::Transformations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QImageIOHandler::Transformations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QImageIOHandler::Transformations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QImageIOHandler::Transformations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QImageIOHandler::Transformations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QImageIOHandler_Transformation___or__(PyObject *self, PyObject *pyArg)
{
    ::QImageIOHandler::Transformations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QImageIOHandler::Transformations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QImageIOHandler::Transformations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QImageIOHandler::Transformations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QImageIOHandler::Transformations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QImageIOHandler_Transformation___xor__(PyObject *self, PyObject *pyArg)
{
    ::QImageIOHandler::Transformations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QImageIOHandler::Transformations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QImageIOHandler::Transformations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QImageIOHandler::Transformations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QImageIOHandler::Transformations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QImageIOHandler_Transformation___invert__(PyObject *self, PyObject *pyArg)
{
    ::QImageIOHandler::Transformations cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX])->converter, self, &cppSelf);
    ::QImageIOHandler::Transformations cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QImageIOHandler_Transformation_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QImageIOHandler_Transformation__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QImageIOHandler_Transformation_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QImageIOHandler_Transformation__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QImageIOHandler_Transformation__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QImageIOHandler_Transformation_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QImageIOHandler_Transformation___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QImageIOHandler_Transformation___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QImageIOHandler_Transformation___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QImageIOHandler_Transformation___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QImageIOHandler_Transformation_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QImageIOHandler_Transformation_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QImageIOHandler_Transformation_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QImageIOHandler_ImageOption_PythonToCpp_QImageIOHandler_ImageOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QImageIOHandler::ImageOption *>(cppOut) =
        static_cast<::QImageIOHandler::ImageOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QImageIOHandler_ImageOption_PythonToCpp_QImageIOHandler_ImageOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX]))
        return QImageIOHandler_ImageOption_PythonToCpp_QImageIOHandler_ImageOption;
    return {};
}
static PyObject *QImageIOHandler_ImageOption_CppToPython_QImageIOHandler_ImageOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QImageIOHandler::ImageOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX], castCppIn);

}

static void QImageIOHandler_Transformation_PythonToCpp_QImageIOHandler_Transformation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QImageIOHandler::Transformation *>(cppOut) =
        static_cast<::QImageIOHandler::Transformation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QImageIOHandler_Transformation_PythonToCpp_QImageIOHandler_Transformation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX]))
        return QImageIOHandler_Transformation_PythonToCpp_QImageIOHandler_Transformation;
    return {};
}
static PyObject *QImageIOHandler_Transformation_CppToPython_QImageIOHandler_Transformation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QImageIOHandler::Transformation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX], castCppIn);

}

static void QFlags_QImageIOHandler_Transformation__PythonToCpp_QFlags_QImageIOHandler_Transformation_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QImageIOHandler::Transformation> *>(cppOut) =
        ::QFlags<QImageIOHandler::Transformation>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QImageIOHandler_Transformation__PythonToCpp_QFlags_QImageIOHandler_Transformation__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX]))
        return QFlags_QImageIOHandler_Transformation__PythonToCpp_QFlags_QImageIOHandler_Transformation_;
    return {};
}
static PyObject *QFlags_QImageIOHandler_Transformation__CppToPython_QFlags_QImageIOHandler_Transformation_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QImageIOHandler::Transformation> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX]));

}

static void QImageIOHandler_Transformation_PythonToCpp_QFlags_QImageIOHandler_Transformation_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QImageIOHandler::Transformation> *>(cppOut) =
        ::QFlags<QImageIOHandler::Transformation>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QImageIOHandler_Transformation_PythonToCpp_QFlags_QImageIOHandler_Transformation__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX]))
        return QImageIOHandler_Transformation_PythonToCpp_QFlags_QImageIOHandler_Transformation_;
    return {};
}
static void number_PythonToCpp_QFlags_QImageIOHandler_Transformation_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QImageIOHandler::Transformation> *>(cppOut) =
        ::QFlags<QImageIOHandler::Transformation>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QImageIOHandler_Transformation__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX]))
        return number_PythonToCpp_QFlags_QImageIOHandler_Transformation_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QImageIOHandler_PythonToCpp_QImageIOHandler_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QImageIOHandler_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QImageIOHandler_PythonToCpp_QImageIOHandler_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QImageIOHandler_TypeF())))
        return QImageIOHandler_PythonToCpp_QImageIOHandler_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QImageIOHandler_PTR_CppToPython_QImageIOHandler(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QImageIOHandler *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QImageIOHandler_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QImageIOHandler_SignatureStrings[] = {
    "PySide2.QtGui.QImageIOHandler(self)",
    "PySide2.QtGui.QImageIOHandler.canRead(self)->bool",
    "PySide2.QtGui.QImageIOHandler.currentImageNumber(self)->int",
    "PySide2.QtGui.QImageIOHandler.currentImageRect(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QImageIOHandler.device(self)->PySide2.QtCore.QIODevice",
    "PySide2.QtGui.QImageIOHandler.format(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtGui.QImageIOHandler.imageCount(self)->int",
    "PySide2.QtGui.QImageIOHandler.jumpToImage(self,imageNumber:int)->bool",
    "PySide2.QtGui.QImageIOHandler.jumpToNextImage(self)->bool",
    "PySide2.QtGui.QImageIOHandler.loopCount(self)->int",
    "PySide2.QtGui.QImageIOHandler.name(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtGui.QImageIOHandler.nextImageDelay(self)->int",
    "PySide2.QtGui.QImageIOHandler.option(self,option:PySide2.QtGui.QImageIOHandler.ImageOption)->QVariant",
    "PySide2.QtGui.QImageIOHandler.read(self,image:PySide2.QtGui.QImage)->bool",
    "PySide2.QtGui.QImageIOHandler.setDevice(self,device:PySide2.QtCore.QIODevice)",
    "1:PySide2.QtGui.QImageIOHandler.setFormat(self,format:PySide2.QtCore.QByteArray)",
    "0:PySide2.QtGui.QImageIOHandler.setFormat(self,format:PySide2.QtCore.QByteArray)",
    "PySide2.QtGui.QImageIOHandler.setOption(self,option:PySide2.QtGui.QImageIOHandler.ImageOption,value:QVariant)",
    "PySide2.QtGui.QImageIOHandler.supportsOption(self,option:PySide2.QtGui.QImageIOHandler.ImageOption)->bool",
    "PySide2.QtGui.QImageIOHandler.write(self,image:PySide2.QtGui.QImage)->bool",
    nullptr}; // Sentinel

void init_QImageIOHandler(PyObject *module)
{
    _Sbk_QImageIOHandler_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QImageIOHandler",
        "QImageIOHandler*",
        &Sbk_QImageIOHandler_spec,
        &Shiboken::callCppDestructor< ::QImageIOHandler >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QImageIOHandler_Type);
    InitSignatureStrings(pyType, QImageIOHandler_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QImageIOHandler_Type), Sbk_QImageIOHandler_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QImageIOHandler_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QImageIOHandler_TypeF(),
        QImageIOHandler_PythonToCpp_QImageIOHandler_PTR,
        is_QImageIOHandler_PythonToCpp_QImageIOHandler_PTR_Convertible,
        QImageIOHandler_PTR_CppToPython_QImageIOHandler);

    Shiboken::Conversions::registerConverterName(converter, "QImageIOHandler");
    Shiboken::Conversions::registerConverterName(converter, "QImageIOHandler*");
    Shiboken::Conversions::registerConverterName(converter, "QImageIOHandler&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QImageIOHandler).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QImageIOHandlerWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'ImageOption'.
    SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QImageIOHandler_TypeF(),
        "ImageOption",
        "2:PySide2.QtGui.QImageIOHandler.ImageOption",
        "QImageIOHandler::ImageOption");
    if (!SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "Size", (long) QImageIOHandler::ImageOption::Size))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "ClipRect", (long) QImageIOHandler::ImageOption::ClipRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "Description", (long) QImageIOHandler::ImageOption::Description))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "ScaledClipRect", (long) QImageIOHandler::ImageOption::ScaledClipRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "ScaledSize", (long) QImageIOHandler::ImageOption::ScaledSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "CompressionRatio", (long) QImageIOHandler::ImageOption::CompressionRatio))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "Gamma", (long) QImageIOHandler::ImageOption::Gamma))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "Quality", (long) QImageIOHandler::ImageOption::Quality))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "Name", (long) QImageIOHandler::ImageOption::Name))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "SubType", (long) QImageIOHandler::ImageOption::SubType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "IncrementalReading", (long) QImageIOHandler::ImageOption::IncrementalReading))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "Endianness", (long) QImageIOHandler::ImageOption::Endianness))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "Animation", (long) QImageIOHandler::ImageOption::Animation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "BackgroundColor", (long) QImageIOHandler::ImageOption::BackgroundColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "ImageFormat", (long) QImageIOHandler::ImageOption::ImageFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "SupportedSubTypes", (long) QImageIOHandler::ImageOption::SupportedSubTypes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "OptimizedWrite", (long) QImageIOHandler::ImageOption::OptimizedWrite))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "ProgressiveScanWrite", (long) QImageIOHandler::ImageOption::ProgressiveScanWrite))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "ImageTransformation", (long) QImageIOHandler::ImageOption::ImageTransformation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
        Sbk_QImageIOHandler_TypeF(), "TransformedByDefault", (long) QImageIOHandler::ImageOption::TransformedByDefault))
        return;
    // Register converter for enum 'QImageIOHandler::ImageOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX],
            QImageIOHandler_ImageOption_CppToPython_QImageIOHandler_ImageOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QImageIOHandler_ImageOption_PythonToCpp_QImageIOHandler_ImageOption,
            is_QImageIOHandler_ImageOption_PythonToCpp_QImageIOHandler_ImageOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_IMAGEOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QImageIOHandler::ImageOption");
        Shiboken::Conversions::registerConverterName(converter, "ImageOption");
    }
    // End of 'ImageOption' enum.

    // Initialization of enum 'Transformation'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QImageIOHandler.Transformations", SbkPySide2_QtGui_QImageIOHandler_Transformation_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QImageIOHandler_TypeF(),
        "Transformation",
        "2:PySide2.QtGui.QImageIOHandler.Transformation",
        "QImageIOHandler::Transformation",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX],
        Sbk_QImageIOHandler_TypeF(), "TransformationNone", (long) QImageIOHandler::Transformation::TransformationNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX],
        Sbk_QImageIOHandler_TypeF(), "TransformationMirror", (long) QImageIOHandler::Transformation::TransformationMirror))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX],
        Sbk_QImageIOHandler_TypeF(), "TransformationFlip", (long) QImageIOHandler::Transformation::TransformationFlip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX],
        Sbk_QImageIOHandler_TypeF(), "TransformationRotate180", (long) QImageIOHandler::Transformation::TransformationRotate180))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX],
        Sbk_QImageIOHandler_TypeF(), "TransformationRotate90", (long) QImageIOHandler::Transformation::TransformationRotate90))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX],
        Sbk_QImageIOHandler_TypeF(), "TransformationMirrorAndRotate90", (long) QImageIOHandler::Transformation::TransformationMirrorAndRotate90))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX],
        Sbk_QImageIOHandler_TypeF(), "TransformationFlipAndRotate90", (long) QImageIOHandler::Transformation::TransformationFlipAndRotate90))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX],
        Sbk_QImageIOHandler_TypeF(), "TransformationRotate270", (long) QImageIOHandler::Transformation::TransformationRotate270))
        return;
    // Register converter for enum 'QImageIOHandler::Transformation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX],
            QImageIOHandler_Transformation_CppToPython_QImageIOHandler_Transformation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QImageIOHandler_Transformation_PythonToCpp_QImageIOHandler_Transformation,
            is_QImageIOHandler_Transformation_PythonToCpp_QImageIOHandler_Transformation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QIMAGEIOHANDLER_TRANSFORMATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QImageIOHandler::Transformation");
        Shiboken::Conversions::registerConverterName(converter, "Transformation");
    }
    // Register converter for flag 'QFlags<QImageIOHandler::Transformation>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX],
            QFlags_QImageIOHandler_Transformation__CppToPython_QFlags_QImageIOHandler_Transformation_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QImageIOHandler_Transformation_PythonToCpp_QFlags_QImageIOHandler_Transformation_,
            is_QImageIOHandler_Transformation_PythonToCpp_QFlags_QImageIOHandler_Transformation__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QImageIOHandler_Transformation__PythonToCpp_QFlags_QImageIOHandler_Transformation_,
            is_QFlags_QImageIOHandler_Transformation__PythonToCpp_QFlags_QImageIOHandler_Transformation__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QImageIOHandler_Transformation_,
            is_number_PythonToCpp_QFlags_QImageIOHandler_Transformation__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QIMAGEIOHANDLER_TRANSFORMATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QImageIOHandler::Transformations");
        Shiboken::Conversions::registerConverterName(converter, "Transformations");
    }
    // End of 'Transformation' enum/flags.

    qRegisterMetaType< ::QImageIOHandler::ImageOption >("QImageIOHandler::ImageOption");
    qRegisterMetaType< ::QImageIOHandler::Transformation >("QImageIOHandler::Transformation");
    qRegisterMetaType< ::QImageIOHandler::Transformations >("QImageIOHandler::Transformations");
}
