/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QIMAGEWRAPPER_H
#define SBK_QIMAGEWRAPPER_H

#define protected public

#include <QtGui/qimage.h>


// Extra includes
#include <QStringList>
#include <QMatrix>
#include <qobject.h>
#include <qsize.h>
#include <QtGui/qimage.h>
#include <qrect.h>
#include <QVector>
#include <qpoint.h>
#include <QtGui/qcolor.h>
#include <QtGui/qmatrix.h>
#include <QtGui/qtransform.h>
#include <QtGui/qcolorspace.h>
#include <qiodevice.h>
#include <qbytearray.h>
#include <QtGui/qpaintengine.h>
#include <QtGui/qpixelformat.h>
#include <QtGui/qpainter.h>
#include <QtGui/qpaintdevice.h>
#include <qdatastream.h>
class QImageWrapper : public QImage
{
public:
    QImageWrapper() noexcept;
    QImageWrapper(const QImage& self) : QImage(self)
    {
    }

    QImageWrapper(const ::QSize & size, ::QImage::Format format);
    QImageWrapper(const ::QString & fileName, const char * format = nullptr);
    QImageWrapper(const char *const xpm[]);
    QImageWrapper(int width, int height, ::QImage::Format format);
    QImageWrapper(uchar * data, int width, int height, ::QImage::Format format, ::QImageCleanupFunction cleanupFunction = nullptr, void * cleanupInfo = nullptr);
    QImageWrapper(uchar * data, int width, int height, int bytesPerLine, ::QImage::Format format, ::QImageCleanupFunction cleanupFunction = nullptr, void * cleanupInfo = nullptr);
    int devType() const override;
    void initPainter(::QPainter * painter) const override;
    int metric(::QPaintDevice::PaintDeviceMetric metric) const override;
    ::QPaintEngine * paintEngine() const override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    ::QPainter * sharedPainter() const override;
    ~QImageWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[6];
};

#endif // SBK_QIMAGEWRAPPER_H

