/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qiconengine_availablesizesargument_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QIconEngine_AvailableSizesArgument_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QIconEngine::AvailableSizesArgument >()))
        return -1;

    ::QIconEngine::AvailableSizesArgument *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QIconEngine.AvailableSizesArgument.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // AvailableSizesArgument()
            cptr = new ::QIconEngine::AvailableSizesArgument();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QIconEngine::AvailableSizesArgument >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}


static const char *Sbk_QIconEngine_AvailableSizesArgument_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QIconEngine_AvailableSizesArgument_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QIconEngine_AvailableSizesArgument_get_mode(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QIconEngine::AvailableSizesArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICONENGINE_AVAILABLESIZESARGUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QIcon::Mode cppOut_local = cppSelf->mode;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QIconEngine_AvailableSizesArgument_set_mode(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QIconEngine::AvailableSizesArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICONENGINE_AVAILABLESIZESARGUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'mode' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mode', 'Mode' or convertible type expected");
        return -1;
    }

    ::QIcon::Mode cppOut_local = cppSelf->mode;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->mode = cppOut_local;

    return 0;
}

static PyObject *Sbk_QIconEngine_AvailableSizesArgument_get_state(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QIconEngine::AvailableSizesArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICONENGINE_AVAILABLESIZESARGUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QIcon::State cppOut_local = cppSelf->state;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QIconEngine_AvailableSizesArgument_set_state(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QIconEngine::AvailableSizesArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICONENGINE_AVAILABLESIZESARGUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'state' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_STATE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'state', 'State' or convertible type expected");
        return -1;
    }

    ::QIcon::State cppOut_local = cppSelf->state;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->state = cppOut_local;

    return 0;
}

static PyObject *Sbk_QIconEngine_AvailableSizesArgument_get_sizes(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QIconEngine::AvailableSizesArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICONENGINE_AVAILABLESIZESARGUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSIZE_IDX], &cppSelf->sizes);
    return pyOut;
}
static int Sbk_QIconEngine_AvailableSizesArgument_set_sizes(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QIconEngine::AvailableSizesArgument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QICONENGINE_AVAILABLESIZESARGUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'sizes' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSIZE_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'sizes', 'QList' or convertible type expected");
        return -1;
    }

    ::QList<QSize >& cppOut_ptr = cppSelf->sizes;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for AvailableSizesArgument
static PyGetSetDef Sbk_QIconEngine_AvailableSizesArgument_getsetlist[] = {
    {const_cast<char *>("mode"), Sbk_QIconEngine_AvailableSizesArgument_get_mode, Sbk_QIconEngine_AvailableSizesArgument_set_mode},
    {const_cast<char *>("state"), Sbk_QIconEngine_AvailableSizesArgument_get_state, Sbk_QIconEngine_AvailableSizesArgument_set_state},
    {const_cast<char *>("sizes"), Sbk_QIconEngine_AvailableSizesArgument_get_sizes, Sbk_QIconEngine_AvailableSizesArgument_set_sizes},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QIconEngine_AvailableSizesArgument_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QIconEngine_AvailableSizesArgument_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QIconEngine_AvailableSizesArgument_Type = nullptr;
static SbkObjectType *Sbk_QIconEngine_AvailableSizesArgument_TypeF(void)
{
    return _Sbk_QIconEngine_AvailableSizesArgument_Type;
}

static PyType_Slot Sbk_QIconEngine_AvailableSizesArgument_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QIconEngine_AvailableSizesArgument_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QIconEngine_AvailableSizesArgument_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QIconEngine_AvailableSizesArgument_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QIconEngine_AvailableSizesArgument_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QIconEngine_AvailableSizesArgument_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QIconEngine_AvailableSizesArgument_spec = {
    "2:PySide2.QtGui.QIconEngine.AvailableSizesArgument",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QIconEngine_AvailableSizesArgument_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void AvailableSizesArgument_PythonToCpp_AvailableSizesArgument_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QIconEngine_AvailableSizesArgument_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_AvailableSizesArgument_PythonToCpp_AvailableSizesArgument_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QIconEngine_AvailableSizesArgument_TypeF())))
        return AvailableSizesArgument_PythonToCpp_AvailableSizesArgument_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *AvailableSizesArgument_PTR_CppToPython_AvailableSizesArgument(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QIconEngine::AvailableSizesArgument *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QIconEngine_AvailableSizesArgument_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QIconEngine_AvailableSizesArgument_SignatureStrings[] = {
    "PySide2.QtGui.QIconEngine.AvailableSizesArgument(self)",
    nullptr}; // Sentinel

void init_QIconEngine_AvailableSizesArgument(PyObject *enclosingClass)
{
    _Sbk_QIconEngine_AvailableSizesArgument_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "AvailableSizesArgument",
        "QIconEngine::AvailableSizesArgument*",
        &Sbk_QIconEngine_AvailableSizesArgument_spec,
        &Shiboken::callCppDestructor< ::QIconEngine::AvailableSizesArgument >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QIconEngine_AvailableSizesArgument_Type);
    InitSignatureStrings(pyType, QIconEngine_AvailableSizesArgument_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QIconEngine_AvailableSizesArgument_Type), Sbk_QIconEngine_AvailableSizesArgument_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QICONENGINE_AVAILABLESIZESARGUMENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QIconEngine_AvailableSizesArgument_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QIconEngine_AvailableSizesArgument_TypeF(),
        AvailableSizesArgument_PythonToCpp_AvailableSizesArgument_PTR,
        is_AvailableSizesArgument_PythonToCpp_AvailableSizesArgument_PTR_Convertible,
        AvailableSizesArgument_PTR_CppToPython_AvailableSizesArgument);

    Shiboken::Conversions::registerConverterName(converter, "QIconEngine::AvailableSizesArgument");
    Shiboken::Conversions::registerConverterName(converter, "QIconEngine::AvailableSizesArgument*");
    Shiboken::Conversions::registerConverterName(converter, "QIconEngine::AvailableSizesArgument&");
    Shiboken::Conversions::registerConverterName(converter, "AvailableSizesArgument");
    Shiboken::Conversions::registerConverterName(converter, "AvailableSizesArgument*");
    Shiboken::Conversions::registerConverterName(converter, "AvailableSizesArgument&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QIconEngine::AvailableSizesArgument).name());


}
