/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qhoverevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QHoverEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QHoverEventWrapper::QHoverEventWrapper(::QEvent::Type type, const ::QPointF & pos, const ::QPointF & oldPos, ::QFlags<Qt::KeyboardModifier> modifiers) : QHoverEvent(type, pos, oldPos, modifiers)
{
    resetPyMethodCache();
    // ... middle
}

QHoverEventWrapper::~QHoverEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QHoverEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QHoverEvent >()))
        return -1;

    ::QHoverEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QHoverEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QHoverEvent_Init_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QHoverEvent_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QHoverEvent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QHoverEvent::QHoverEvent(QEvent::Type,QPointF,QPointF,QFlags<Qt::KeyboardModifier>)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // QHoverEvent(QEvent::Type,QPointF,QPointF,QFlags<Qt::KeyboardModifier>)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3])))) {
            overloadId = 0; // QHoverEvent(QEvent::Type,QPointF,QPointF,QFlags<Qt::KeyboardModifier>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHoverEvent_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_modifiers = Shiboken::String::createStaticString("modifiers");
            if (PyDict_Contains(kwds, key_modifiers)) {
                value = PyDict_GetItem(kwds, key_modifiers);
                if (value && pyArgs[3]) {
                    errInfo = key_modifiers;
                    Py_INCREF(errInfo);
                    goto Sbk_QHoverEvent_Init_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QHoverEvent_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_modifiers);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QHoverEvent_Init_TypeError;
            }
        }
        ::QEvent::Type cppArg0{QEvent::None};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QPointF cppArg1_local;
        ::QPointF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return -1;
        ::QPointF cppArg2_local;
        ::QPointF *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);

        ::QFlags<Qt::KeyboardModifier> cppArg3 = Qt::NoModifier;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // QHoverEvent(QEvent::Type,QPointF,QPointF,QFlags<Qt::KeyboardModifier>)
            cptr = new ::QHoverEventWrapper(cppArg0, *cppArg1, *cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QHoverEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QHoverEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QHoverEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QHoverEventFunc_oldPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHoverEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QHoverEvent.oldPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // oldPos()const
            QPoint cppResult = const_cast<const ::QHoverEvent *>(cppSelf)->oldPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHoverEventFunc_oldPosF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHoverEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QHoverEvent.oldPosF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // oldPosF()const
            const QPointF & cppResult = const_cast<const ::QHoverEvent *>(cppSelf)->oldPosF();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHoverEventFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHoverEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QHoverEvent.pos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pos()const
            QPoint cppResult = const_cast<const ::QHoverEvent *>(cppSelf)->pos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHoverEventFunc_posF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHoverEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QHoverEvent.posF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // posF()const
            const QPointF & cppResult = const_cast<const ::QHoverEvent *>(cppSelf)->posF();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QHoverEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QHoverEvent_methods[] = {
    {"oldPos", reinterpret_cast<PyCFunction>(Sbk_QHoverEventFunc_oldPos), METH_NOARGS},
    {"oldPosF", reinterpret_cast<PyCFunction>(Sbk_QHoverEventFunc_oldPosF), METH_NOARGS},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_QHoverEventFunc_pos), METH_NOARGS},
    {"posF", reinterpret_cast<PyCFunction>(Sbk_QHoverEventFunc_posF), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QHoverEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QHoverEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QHoverEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QHoverEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QHoverEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QHoverEvent_Type = nullptr;
static SbkObjectType *Sbk_QHoverEvent_TypeF(void)
{
    return _Sbk_QHoverEvent_Type;
}

static PyType_Slot Sbk_QHoverEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QHoverEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QHoverEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QHoverEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QHoverEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QHoverEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QHoverEvent_spec = {
    "2:PySide2.QtGui.QHoverEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QHoverEvent_slots
};

} //extern "C"

static void *Sbk_QHoverEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QHoverEvent *>(cptr)->type() == QEvent::HoverEnter ||  reinterpret_cast< ::QHoverEvent *>(cptr)->type() == QEvent::HoverLeave ||  reinterpret_cast< ::QHoverEvent *>(cptr)->type() == QEvent::HoverMove)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QHoverEvent_PythonToCpp_QHoverEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QHoverEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QHoverEvent_PythonToCpp_QHoverEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QHoverEvent_TypeF())))
        return QHoverEvent_PythonToCpp_QHoverEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QHoverEvent_PTR_CppToPython_QHoverEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QHoverEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QHoverEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QHoverEvent_SignatureStrings[] = {
    "PySide2.QtGui.QHoverEvent(self,type:PySide2.QtCore.QEvent.Type,pos:PySide2.QtCore.QPointF,oldPos:PySide2.QtCore.QPointF,modifiers:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier)",
    "PySide2.QtGui.QHoverEvent.oldPos(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QHoverEvent.oldPosF(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QHoverEvent.pos(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QHoverEvent.posF(self)->PySide2.QtCore.QPointF",
    nullptr}; // Sentinel

void init_QHoverEvent(PyObject *module)
{
    _Sbk_QHoverEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QHoverEvent",
        "QHoverEvent*",
        &Sbk_QHoverEvent_spec,
        &Shiboken::callCppDestructor< ::QHoverEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QHoverEvent_Type);
    InitSignatureStrings(pyType, QHoverEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QHoverEvent_Type), Sbk_QHoverEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QHoverEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QHoverEvent_TypeF(),
        QHoverEvent_PythonToCpp_QHoverEvent_PTR,
        is_QHoverEvent_PythonToCpp_QHoverEvent_PTR_Convertible,
        QHoverEvent_PTR_CppToPython_QHoverEvent);

    Shiboken::Conversions::registerConverterName(converter, "QHoverEvent");
    Shiboken::Conversions::registerConverterName(converter, "QHoverEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QHoverEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QHoverEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QHoverEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QHoverEvent_TypeF(), &Sbk_QHoverEvent_typeDiscovery);

}
