/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qfontinfo_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qfont.h>
#include <QtGui/qfontinfo.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFontInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFontInfo >()))
        return -1;

    ::QFontInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QFontInfo", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QFontInfo::QFontInfo(QFont)
    // 1: QFontInfo::QFontInfo(QFontInfo)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QFontInfo(QFont)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QFontInfo(QFontInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFontInfo(const QFont & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFontInfo(QFont)
                cptr = new ::QFontInfo(*cppArg0);
            }
            break;
        }
        case 1: // QFontInfo(const QFontInfo & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFontInfo cppArg0_local = ::QFontInfo(::QFont());
            ::QFontInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFontInfo(QFontInfo)
                cptr = new ::QFontInfo(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFontInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFontInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QFontInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFontInfoFunc_bold(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.bold";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bold()const
            bool cppResult = const_cast<const ::QFontInfo *>(cppSelf)->bold();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_exactMatch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.exactMatch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exactMatch()const
            bool cppResult = const_cast<const ::QFontInfo *>(cppSelf)->exactMatch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_family(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.family";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // family()const
            QString cppResult = const_cast<const ::QFontInfo *>(cppSelf)->family();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_fixedPitch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.fixedPitch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fixedPitch()const
            bool cppResult = const_cast<const ::QFontInfo *>(cppSelf)->fixedPitch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_italic(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.italic";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // italic()const
            bool cppResult = const_cast<const ::QFontInfo *>(cppSelf)->italic();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_overline(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.overline";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // overline()const
            bool cppResult = const_cast<const ::QFontInfo *>(cppSelf)->overline();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_pixelSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.pixelSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelSize()const
            int cppResult = const_cast<const ::QFontInfo *>(cppSelf)->pixelSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_pointSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.pointSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pointSize()const
            int cppResult = const_cast<const ::QFontInfo *>(cppSelf)->pointSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_pointSizeF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.pointSizeF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pointSizeF()const
            qreal cppResult = const_cast<const ::QFontInfo *>(cppSelf)->pointSizeF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_rawMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.rawMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rawMode()const
            bool cppResult = const_cast<const ::QFontInfo *>(cppSelf)->rawMode();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_strikeOut(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.strikeOut";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // strikeOut()const
            bool cppResult = const_cast<const ::QFontInfo *>(cppSelf)->strikeOut();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_style(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.style";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // style()const
            QFont::Style cppResult = const_cast<const ::QFontInfo *>(cppSelf)->style();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_styleHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.styleHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // styleHint()const
            QFont::StyleHint cppResult = const_cast<const ::QFontInfo *>(cppSelf)->styleHint();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_styleName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.styleName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // styleName()const
            QString cppResult = const_cast<const ::QFontInfo *>(cppSelf)->styleName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFontInfo::swap(QFontInfo&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QFontInfo&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFontInfoFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFontInfo cppArg0_local = ::QFontInfo(::QFont());
        ::QFontInfo *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QFontInfo&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFontInfoFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFontInfoFunc_underline(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.underline";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // underline()const
            bool cppResult = const_cast<const ::QFontInfo *>(cppSelf)->underline();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfoFunc_weight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QFontInfo.weight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // weight()const
            int cppResult = const_cast<const ::QFontInfo *>(cppSelf)->weight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFontInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QFontInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFontInfo_methods[] = {
    {"bold", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_bold), METH_NOARGS},
    {"exactMatch", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_exactMatch), METH_NOARGS},
    {"family", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_family), METH_NOARGS},
    {"fixedPitch", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_fixedPitch), METH_NOARGS},
    {"italic", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_italic), METH_NOARGS},
    {"overline", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_overline), METH_NOARGS},
    {"pixelSize", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_pixelSize), METH_NOARGS},
    {"pointSize", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_pointSize), METH_NOARGS},
    {"pointSizeF", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_pointSizeF), METH_NOARGS},
    {"rawMode", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_rawMode), METH_NOARGS},
    {"strikeOut", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_strikeOut), METH_NOARGS},
    {"style", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_style), METH_NOARGS},
    {"styleHint", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_styleHint), METH_NOARGS},
    {"styleName", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_styleName), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_swap), METH_O},
    {"underline", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_underline), METH_NOARGS},
    {"weight", reinterpret_cast<PyCFunction>(Sbk_QFontInfoFunc_weight), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QFontInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QFontInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFontInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFontInfo_Type = nullptr;
static SbkObjectType *Sbk_QFontInfo_TypeF(void)
{
    return _Sbk_QFontInfo_Type;
}

static PyType_Slot Sbk_QFontInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFontInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFontInfo_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFontInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFontInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFontInfo_spec = {
    "2:PySide2.QtGui.QFontInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFontInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFontInfo_PythonToCpp_QFontInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFontInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFontInfo_PythonToCpp_QFontInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFontInfo_TypeF())))
        return QFontInfo_PythonToCpp_QFontInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFontInfo_PTR_CppToPython_QFontInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QFontInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QFontInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QFontInfo_COPY_CppToPython_QFontInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QFontInfo_TypeF(), new ::QFontInfo(*reinterpret_cast<const ::QFontInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QFontInfo_PythonToCpp_QFontInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFontInfo *>(cppOut) = *reinterpret_cast< ::QFontInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QFontInfo_PythonToCpp_QFontInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFontInfo_TypeF())))
        return QFontInfo_PythonToCpp_QFontInfo_COPY;
    return {};
}

// Implicit conversions.
static void constQFontREF_PythonToCpp_QFontInfo(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFontInfo *>(cppOut) = ::QFontInfo( *reinterpret_cast< ::QFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQFontREF_PythonToCpp_QFontInfo_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX], pyIn))
        return constQFontREF_PythonToCpp_QFontInfo;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFontInfo_SignatureStrings[] = {
    "1:PySide2.QtGui.QFontInfo(self,arg__1:PySide2.QtGui.QFont)",
    "0:PySide2.QtGui.QFontInfo(self,arg__1:PySide2.QtGui.QFontInfo)",
    "PySide2.QtGui.QFontInfo.bold(self)->bool",
    "PySide2.QtGui.QFontInfo.exactMatch(self)->bool",
    "PySide2.QtGui.QFontInfo.family(self)->QString",
    "PySide2.QtGui.QFontInfo.fixedPitch(self)->bool",
    "PySide2.QtGui.QFontInfo.italic(self)->bool",
    "PySide2.QtGui.QFontInfo.overline(self)->bool",
    "PySide2.QtGui.QFontInfo.pixelSize(self)->int",
    "PySide2.QtGui.QFontInfo.pointSize(self)->int",
    "PySide2.QtGui.QFontInfo.pointSizeF(self)->qreal",
    "PySide2.QtGui.QFontInfo.rawMode(self)->bool",
    "PySide2.QtGui.QFontInfo.strikeOut(self)->bool",
    "PySide2.QtGui.QFontInfo.style(self)->PySide2.QtGui.QFont.Style",
    "PySide2.QtGui.QFontInfo.styleHint(self)->PySide2.QtGui.QFont.StyleHint",
    "PySide2.QtGui.QFontInfo.styleName(self)->QString",
    "PySide2.QtGui.QFontInfo.swap(self,other:PySide2.QtGui.QFontInfo)",
    "PySide2.QtGui.QFontInfo.underline(self)->bool",
    "PySide2.QtGui.QFontInfo.weight(self)->int",
    "PySide2.QtGui.QFontInfo.__copy__()",
    nullptr}; // Sentinel

void init_QFontInfo(PyObject *module)
{
    _Sbk_QFontInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFontInfo",
        "QFontInfo",
        &Sbk_QFontInfo_spec,
        &Shiboken::callCppDestructor< ::QFontInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFontInfo_Type);
    InitSignatureStrings(pyType, QFontInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFontInfo_Type), Sbk_QFontInfo_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QFONTINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFontInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFontInfo_TypeF(),
        QFontInfo_PythonToCpp_QFontInfo_PTR,
        is_QFontInfo_PythonToCpp_QFontInfo_PTR_Convertible,
        QFontInfo_PTR_CppToPython_QFontInfo,
        QFontInfo_COPY_CppToPython_QFontInfo);

    Shiboken::Conversions::registerConverterName(converter, "QFontInfo");
    Shiboken::Conversions::registerConverterName(converter, "QFontInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QFontInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFontInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QFontInfo_PythonToCpp_QFontInfo_COPY,
        is_QFontInfo_PythonToCpp_QFontInfo_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQFontREF_PythonToCpp_QFontInfo,
        is_constQFontREF_PythonToCpp_QFontInfo_Convertible);

}
