/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qcontextmenuevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QContextMenuEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QContextMenuEventWrapper::QContextMenuEventWrapper(::QContextMenuEvent::Reason reason, const ::QPoint & pos) : QContextMenuEvent(reason, pos)
{
    resetPyMethodCache();
    // ... middle
}

QContextMenuEventWrapper::QContextMenuEventWrapper(::QContextMenuEvent::Reason reason, const ::QPoint & pos, const ::QPoint & globalPos) : QContextMenuEvent(reason, pos, globalPos)
{
    resetPyMethodCache();
    // ... middle
}

QContextMenuEventWrapper::QContextMenuEventWrapper(::QContextMenuEvent::Reason reason, const ::QPoint & pos, const ::QPoint & globalPos, ::QFlags<Qt::KeyboardModifier> modifiers) : QContextMenuEvent(reason, pos, globalPos, modifiers)
{
    resetPyMethodCache();
    // ... middle
}

QContextMenuEventWrapper::~QContextMenuEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QContextMenuEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QContextMenuEvent >()))
        return -1;

    ::QContextMenuEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QContextMenuEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContextMenuEvent", 2, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QContextMenuEvent::QContextMenuEvent(QContextMenuEvent::Reason,QPoint)
    // 1: QContextMenuEvent::QContextMenuEvent(QContextMenuEvent::Reason,QPoint,QPoint)
    // 2: QContextMenuEvent::QContextMenuEvent(QContextMenuEvent::Reason,QPoint,QPoint,QFlags<Qt::KeyboardModifier>)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // QContextMenuEvent(QContextMenuEvent::Reason,QPoint)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // QContextMenuEvent(QContextMenuEvent::Reason,QPoint,QPoint)
            } else if (numArgs == 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3])))) {
                overloadId = 2; // QContextMenuEvent(QContextMenuEvent::Reason,QPoint,QPoint,QFlags<Qt::KeyboardModifier>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QContextMenuEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QContextMenuEvent(QContextMenuEvent::Reason reason, const QPoint & pos)
        {
            ::QContextMenuEvent::Reason cppArg0{QContextMenuEvent::Mouse};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPoint cppArg1_local;
            ::QPoint *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QContextMenuEvent(QContextMenuEvent::Reason,QPoint)
                cptr = new ::QContextMenuEventWrapper(cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // QContextMenuEvent(QContextMenuEvent::Reason reason, const QPoint & pos, const QPoint & globalPos)
        {
            ::QContextMenuEvent::Reason cppArg0{QContextMenuEvent::Mouse};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPoint cppArg1_local;
            ::QPoint *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPoint cppArg2_local;
            ::QPoint *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // QContextMenuEvent(QContextMenuEvent::Reason,QPoint,QPoint)
                cptr = new ::QContextMenuEventWrapper(cppArg0, *cppArg1, *cppArg2);
            }
            break;
        }
        case 2: // QContextMenuEvent(QContextMenuEvent::Reason reason, const QPoint & pos, const QPoint & globalPos, QFlags<Qt::KeyboardModifier> modifiers)
        {
            ::QContextMenuEvent::Reason cppArg0{QContextMenuEvent::Mouse};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPoint cppArg1_local;
            ::QPoint *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPoint cppArg2_local;
            ::QPoint *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            ::QFlags<Qt::KeyboardModifier> cppArg3 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QContextMenuEvent(QContextMenuEvent::Reason,QPoint,QPoint,QFlags<Qt::KeyboardModifier>)
                cptr = new ::QContextMenuEventWrapper(cppArg0, *cppArg1, *cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QContextMenuEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QContextMenuEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QContextMenuEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QContextMenuEventFunc_globalPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QContextMenuEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QContextMenuEvent.globalPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalPos()const
            const QPoint & cppResult = const_cast<const ::QContextMenuEvent *>(cppSelf)->globalPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QContextMenuEventFunc_globalX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QContextMenuEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QContextMenuEvent.globalX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalX()const
            int cppResult = const_cast<const ::QContextMenuEvent *>(cppSelf)->globalX();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QContextMenuEventFunc_globalY(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QContextMenuEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QContextMenuEvent.globalY";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalY()const
            int cppResult = const_cast<const ::QContextMenuEvent *>(cppSelf)->globalY();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QContextMenuEventFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QContextMenuEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QContextMenuEvent.pos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pos()const
            const QPoint & cppResult = const_cast<const ::QContextMenuEvent *>(cppSelf)->pos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QContextMenuEventFunc_reason(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QContextMenuEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QContextMenuEvent.reason";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reason()const
            QContextMenuEvent::Reason cppResult = const_cast<const ::QContextMenuEvent *>(cppSelf)->reason();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QContextMenuEventFunc_x(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QContextMenuEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QContextMenuEvent.x";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // x()const
            int cppResult = const_cast<const ::QContextMenuEvent *>(cppSelf)->x();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QContextMenuEventFunc_y(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QContextMenuEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QContextMenuEvent.y";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // y()const
            int cppResult = const_cast<const ::QContextMenuEvent *>(cppSelf)->y();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QContextMenuEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QContextMenuEvent_methods[] = {
    {"globalPos", reinterpret_cast<PyCFunction>(Sbk_QContextMenuEventFunc_globalPos), METH_NOARGS},
    {"globalX", reinterpret_cast<PyCFunction>(Sbk_QContextMenuEventFunc_globalX), METH_NOARGS},
    {"globalY", reinterpret_cast<PyCFunction>(Sbk_QContextMenuEventFunc_globalY), METH_NOARGS},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_QContextMenuEventFunc_pos), METH_NOARGS},
    {"reason", reinterpret_cast<PyCFunction>(Sbk_QContextMenuEventFunc_reason), METH_NOARGS},
    {"x", reinterpret_cast<PyCFunction>(Sbk_QContextMenuEventFunc_x), METH_NOARGS},
    {"y", reinterpret_cast<PyCFunction>(Sbk_QContextMenuEventFunc_y), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QContextMenuEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QContextMenuEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QContextMenuEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QContextMenuEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QContextMenuEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QContextMenuEvent_Type = nullptr;
static SbkObjectType *Sbk_QContextMenuEvent_TypeF(void)
{
    return _Sbk_QContextMenuEvent_Type;
}

static PyType_Slot Sbk_QContextMenuEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QContextMenuEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QContextMenuEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QContextMenuEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QContextMenuEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QContextMenuEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QContextMenuEvent_spec = {
    "2:PySide2.QtGui.QContextMenuEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QContextMenuEvent_slots
};

} //extern "C"

static void *Sbk_QContextMenuEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QContextMenuEvent *>(cptr)->type() == QEvent::ContextMenu)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QContextMenuEvent_Reason_PythonToCpp_QContextMenuEvent_Reason(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QContextMenuEvent::Reason *>(cppOut) =
        static_cast<::QContextMenuEvent::Reason>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QContextMenuEvent_Reason_PythonToCpp_QContextMenuEvent_Reason_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX]))
        return QContextMenuEvent_Reason_PythonToCpp_QContextMenuEvent_Reason;
    return {};
}
static PyObject *QContextMenuEvent_Reason_CppToPython_QContextMenuEvent_Reason(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QContextMenuEvent::Reason *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QContextMenuEvent_PythonToCpp_QContextMenuEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QContextMenuEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QContextMenuEvent_PythonToCpp_QContextMenuEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QContextMenuEvent_TypeF())))
        return QContextMenuEvent_PythonToCpp_QContextMenuEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QContextMenuEvent_PTR_CppToPython_QContextMenuEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QContextMenuEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QContextMenuEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QContextMenuEvent_SignatureStrings[] = {
    "2:PySide2.QtGui.QContextMenuEvent(self,reason:PySide2.QtGui.QContextMenuEvent.Reason,pos:PySide2.QtCore.QPoint)",
    "1:PySide2.QtGui.QContextMenuEvent(self,reason:PySide2.QtGui.QContextMenuEvent.Reason,pos:PySide2.QtCore.QPoint,globalPos:PySide2.QtCore.QPoint)",
    "0:PySide2.QtGui.QContextMenuEvent(self,reason:PySide2.QtGui.QContextMenuEvent.Reason,pos:PySide2.QtCore.QPoint,globalPos:PySide2.QtCore.QPoint,modifiers:PySide2.QtCore.Qt.KeyboardModifiers)",
    "PySide2.QtGui.QContextMenuEvent.globalPos(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QContextMenuEvent.globalX(self)->int",
    "PySide2.QtGui.QContextMenuEvent.globalY(self)->int",
    "PySide2.QtGui.QContextMenuEvent.pos(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QContextMenuEvent.reason(self)->PySide2.QtGui.QContextMenuEvent.Reason",
    "PySide2.QtGui.QContextMenuEvent.x(self)->int",
    "PySide2.QtGui.QContextMenuEvent.y(self)->int",
    nullptr}; // Sentinel

void init_QContextMenuEvent(PyObject *module)
{
    _Sbk_QContextMenuEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QContextMenuEvent",
        "QContextMenuEvent*",
        &Sbk_QContextMenuEvent_spec,
        &Shiboken::callCppDestructor< ::QContextMenuEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QContextMenuEvent_Type);
    InitSignatureStrings(pyType, QContextMenuEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QContextMenuEvent_Type), Sbk_QContextMenuEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QContextMenuEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QContextMenuEvent_TypeF(),
        QContextMenuEvent_PythonToCpp_QContextMenuEvent_PTR,
        is_QContextMenuEvent_PythonToCpp_QContextMenuEvent_PTR_Convertible,
        QContextMenuEvent_PTR_CppToPython_QContextMenuEvent);

    Shiboken::Conversions::registerConverterName(converter, "QContextMenuEvent");
    Shiboken::Conversions::registerConverterName(converter, "QContextMenuEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QContextMenuEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QContextMenuEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QContextMenuEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QContextMenuEvent_TypeF(), &Sbk_QContextMenuEvent_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Reason'.
    SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QContextMenuEvent_TypeF(),
        "Reason",
        "2:PySide2.QtGui.QContextMenuEvent.Reason",
        "QContextMenuEvent::Reason");
    if (!SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX],
        Sbk_QContextMenuEvent_TypeF(), "Mouse", (long) QContextMenuEvent::Reason::Mouse))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX],
        Sbk_QContextMenuEvent_TypeF(), "Keyboard", (long) QContextMenuEvent::Reason::Keyboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX],
        Sbk_QContextMenuEvent_TypeF(), "Other", (long) QContextMenuEvent::Reason::Other))
        return;
    // Register converter for enum 'QContextMenuEvent::Reason'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX],
            QContextMenuEvent_Reason_CppToPython_QContextMenuEvent_Reason);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QContextMenuEvent_Reason_PythonToCpp_QContextMenuEvent_Reason,
            is_QContextMenuEvent_Reason_PythonToCpp_QContextMenuEvent_Reason_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QContextMenuEvent::Reason");
        Shiboken::Conversions::registerConverterName(converter, "Reason");
    }
    // End of 'Reason' enum.

    qRegisterMetaType< ::QContextMenuEvent::Reason >("QContextMenuEvent::Reason");
}
