/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qcolor_wrapper.h"

// inner classes

// Extra includes
#include <QVariant>
#include <QtGui/qcolor.h>
#include <qdatastream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QColor_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QColor >()))
        return -1;

    ::QColor *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColor_Init_TypeError;
    } else if (numArgs == 2)
        goto Sbk_QColor_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOO:QColor", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return -1;


    // Overloaded function decisor
    // 0: QColor::QColor()
    // 1: QColor::QColor(QColor::Spec,ushort,ushort,ushort,ushort,ushort)
    // 2: QColor::QColor(QVariant)
    // 3: QColor::QColor(Qt::GlobalColor)
    // 4: QColor::QColor(QColor)
    // 5: QColor::QColor(QString)
    // 6: QColor::QColor(int,int,int,int)
    // 7: QColor::QColor(uint)
    if (numArgs == 0) {
        overloadId = 0; // QColor()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 5; // QColor(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])->converter, (pyArgs[0])))) {
        overloadId = 3; // QColor(Qt::GlobalColor)
    } else if (numArgs >= 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[4])))) {
        if (numArgs == 5) {
            overloadId = 1; // QColor(QColor::Spec,ushort,ushort,ushort,ushort,ushort)
        } else if (numArgs >= 6
            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[5])))) {
            overloadId = 1; // QColor(QColor::Spec,ushort,ushort,ushort,ushort,ushort)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))) {
        overloadId = 7; // QColor(uint)
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 6; // QColor(int,int,int,int)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 6; // QColor(int,int,int,int)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[0])))) {
        overloadId = 2; // QColor(QVariant)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[0])))) {
        overloadId = 4; // QColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColor_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QColor()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColor_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QColor()
                cptr = new ::QColor();
            }
            break;
        }
        case 1: // QColor(QColor::Spec spec, ushort a1, ushort a2, ushort a3, ushort a4, ushort a5)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_a5 = Shiboken::String::createStaticString("a5");
                if (PyDict_Contains(kwds, key_a5)) {
                    value = PyDict_GetItem(kwds, key_a5);
                    if (value && pyArgs[5]) {
                        errInfo = key_a5;
                        Py_INCREF(errInfo);
                        goto Sbk_QColor_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[5]))))
                            goto Sbk_QColor_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_a5);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QColor_Init_TypeError;
                }
            }
            ::QColor::Spec cppArg0{QColor::Invalid};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ushort cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ushort cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ushort cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ushort cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ushort cppArg5 = 0;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // QColor(QColor::Spec,ushort,ushort,ushort,ushort,ushort)
                cptr = new ::QColor(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
        case 2: // QColor(QVariant arg__1)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColor_Init_TypeError;
            }
            ::QVariant cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // QColor(QVariant)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtgui.cpp (qcolor)]
                if (cppArg0.type() == QVariant::Color)
                    cptr = new QColor(cppArg0.value<QColor>());
                else
                    PyErr_SetString(PyExc_TypeError, "QVariant must be holding a QColor");
                // END of custom code block [file: ../glue/qtgui.cpp (qcolor)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 3: // QColor(Qt::GlobalColor color)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColor_Init_TypeError;
            }
            ::Qt::GlobalColor cppArg0{Qt::color0};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QColor(Qt::GlobalColor)
                cptr = new ::QColor(cppArg0);
            }
            break;
        }
        case 4: // QColor(const QColor & color)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColor_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QColor(QColor)
                cptr = new ::QColor(*cppArg0);
            }
            break;
        }
        case 5: // QColor(const QString & name)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColor_Init_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QColor(QString)
                cptr = new ::QColor(cppArg0);
            }
            break;
        }
        case 6: // QColor(int r, int g, int b, int a)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_a = Shiboken::String::createStaticString("a");
                if (PyDict_Contains(kwds, key_a)) {
                    value = PyDict_GetItem(kwds, key_a);
                    if (value && pyArgs[3]) {
                        errInfo = key_a;
                        Py_INCREF(errInfo);
                        goto Sbk_QColor_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QColor_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_a);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QColor_Init_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = 255;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QColor(int,int,int,int)
                cptr = new ::QColor(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 7: // QColor(unsigned int rgb)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColor_Init_TypeError;
            }
            unsigned int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QColor(uint)
                cptr = new ::QColor(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QColor >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QColor_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QColor_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QColorFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qcolor-reduce)]
            switch (cppSelf->spec()) {
                case QColor::Rgb:
                {
                    qreal r, g, b, a;
                    cppSelf->getRgbF(&r, &g, &b, &a);
                    pyResult = Py_BuildValue("(ON(s(ffff)))", Py_TYPE(self), PyTuple_New(0),
                                             "setRgbF", float(r), float(g), float(b), float(a));
                    break;
                }
                case QColor::Hsv:
                {
                    qreal h, s, v, a;
                    cppSelf->getHsvF(&h, &s, &v, &a);
                    pyResult = Py_BuildValue("(ON(s(ffff)))", Py_TYPE(self), PyTuple_New(0),
                                             "setHsvF", float(h), float(s), float(v), float(a));
                    break;
                }
                case QColor::Cmyk:
                {
                    qreal c, m, y, k, a;
                    cppSelf->getCmykF(&c, &m, &y, &k, &a);
                    pyResult = Py_BuildValue("(ON(s(fffff)))", Py_TYPE(self), PyTuple_New(0),
                                             "setCmykF", float(c), float(m), float(y), float(k), float(a));
                    break;
                }
                case QColor::Hsl:
                {
                    qreal h, s, l, a;
                    cppSelf->getHslF(&h, &s, &l, &a);
                    pyResult = Py_BuildValue("(ON(s(ffff)))", Py_TYPE(self), PyTuple_New(0),
                                             "setHslF", float(h), float(s), float(l), float(a));
                    break;
                }
                default:
                {
                    pyResult = Py_BuildValue("(N(O))", PyObject_Type(self), Py_None);
                }
            }
            // END of custom code block [file: ../glue/qtgui.cpp (qcolor-reduce)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - qcolor_repr - START
             switch(cppSelf->spec()) {
               case QColor::Rgb:
               {
                   qreal r, g, b, a;
                   cppSelf->getRgbF(&r, &g, &b, &a);
                   QString repr = QString::asprintf("PySide2.QtGui.QColor.fromRgbF(%.6f, %.6f, %.6f, %.6f)", r, g, b, a);
                   pyResult = Shiboken::String::fromCString(qPrintable(repr));
                   break;
               }
               case QColor::Hsv:
               {
                   qreal h, s, v, a;
                   cppSelf->getHsvF(&h, &s, &v, &a);
                   QString repr = QString::asprintf("PySide2.QtGui.QColor.fromHsvF(%.6f, %.6f, %.6f, %.6f)", h, s, v, a);
                   pyResult = Shiboken::String::fromCString(qPrintable(repr));
                   break;
               }
               case QColor::Cmyk:
               {
                   qreal c, m, y, k, a;
                   cppSelf->getCmykF(&c, &m, &y, &k, &a);
                   QString repr = QString::asprintf("PySide2.QtGui.QColor.fromCmykF(%.6f, %.6f, %.6f, %.6f, %.6f)", c, m, y, k, a);
                   pyResult = Shiboken::String::fromCString(qPrintable(repr));
                   break;
               }
               case QColor::Hsl:
               {
                   qreal h, s, l, a;
                   cppSelf->getHslF(&h, &s, &l, &a);
                   QString repr = QString::asprintf("PySide2.QtGui.QColor.fromHslF(%.6f, %.6f, %.6f, %.6f)", h, s, l, a);
                   pyResult = Shiboken::String::fromCString(qPrintable(repr));
                   break;
               }
               default:
               {
                   pyResult = Shiboken::String::fromCString("PySide2.QtGui.QColor()");
               }
            }
            // TEMPLATE - qcolor_repr - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc___setstate__(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.__setstate__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::__setstate__(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // __setstate__(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc___setstate___TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __setstate__(PyObject*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qcolor-setstate)]
            Shiboken::AutoDecRef func(PyObject_GetAttr(self, PyTuple_GET_ITEM(pyArg, 0)));
            PyObject *args = PyTuple_GET_ITEM(pyArg, 1);
            pyResult = PyObject_Call(func, args, NULL);
            // END of custom code block [file: ../glue/qtgui.cpp (qcolor-setstate)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc___setstate___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc___str__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.__str__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __str__()
            // Begin code injection
            // TEMPLATE - qcolor_repr - START
             switch(cppSelf->spec()) {
               case QColor::Rgb:
               {
                   qreal r, g, b, a;
                   cppSelf->getRgbF(&r, &g, &b, &a);
                   QString repr = QString::asprintf("PySide2.QtGui.QColor.fromRgbF(%.6f, %.6f, %.6f, %.6f)", r, g, b, a);
                   pyResult = Shiboken::String::fromCString(qPrintable(repr));
                   break;
               }
               case QColor::Hsv:
               {
                   qreal h, s, v, a;
                   cppSelf->getHsvF(&h, &s, &v, &a);
                   QString repr = QString::asprintf("PySide2.QtGui.QColor.fromHsvF(%.6f, %.6f, %.6f, %.6f)", h, s, v, a);
                   pyResult = Shiboken::String::fromCString(qPrintable(repr));
                   break;
               }
               case QColor::Cmyk:
               {
                   qreal c, m, y, k, a;
                   cppSelf->getCmykF(&c, &m, &y, &k, &a);
                   QString repr = QString::asprintf("PySide2.QtGui.QColor.fromCmykF(%.6f, %.6f, %.6f, %.6f, %.6f)", c, m, y, k, a);
                   pyResult = Shiboken::String::fromCString(qPrintable(repr));
                   break;
               }
               case QColor::Hsl:
               {
                   qreal h, s, l, a;
                   cppSelf->getHslF(&h, &s, &l, &a);
                   QString repr = QString::asprintf("PySide2.QtGui.QColor.fromHslF(%.6f, %.6f, %.6f, %.6f)", h, s, l, a);
                   pyResult = Shiboken::String::fromCString(qPrintable(repr));
                   break;
               }
               default:
               {
                   pyResult = Shiboken::String::fromCString("PySide2.QtGui.QColor()");
               }
            }
            // TEMPLATE - qcolor_repr - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_alpha(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.alpha";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alpha()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->alpha();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_alphaF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.alphaF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alphaF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->alphaF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_black(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.black";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // black()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->black();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_blackF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.blackF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blackF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->blackF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_blue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.blue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blue()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->blue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_blueF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.blueF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blueF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->blueF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_colorNames(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.colorNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorNames()
            QStringList cppResult = ::QColor::colorNames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_convertTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.convertTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::convertTo(QColor::Spec)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX])->converter, (pyArg)))) {
        overloadId = 0; // convertTo(QColor::Spec)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_convertTo_TypeError;

    // Call function/method
    {
        ::QColor::Spec cppArg0{QColor::Invalid};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // convertTo(QColor::Spec)const
            QColor cppResult = const_cast<const ::QColor *>(cppSelf)->convertTo(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_convertTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_cyan(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.cyan";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cyan()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->cyan();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_cyanF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.cyanF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cyanF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->cyanF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_dark(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.dark";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_dark_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:dark", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QColor::dark(int)const
    if (numArgs == 0) {
        overloadId = 0; // dark(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // dark(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_dark_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_f = Shiboken::String::createStaticString("f");
            if (PyDict_Contains(kwds, key_f)) {
                value = PyDict_GetItem(kwds, key_f);
                if (value && pyArgs[0]) {
                    errInfo = key_f;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_dark_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QColorFunc_dark_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_f);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_dark_TypeError;
            }
        }
        int cppArg0 = 200;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // dark(int)const
            QColor cppResult = const_cast<const ::QColor *>(cppSelf)->dark(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_dark_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_darker(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.darker";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_darker_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:darker", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QColor::darker(int)const
    if (numArgs == 0) {
        overloadId = 0; // darker(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // darker(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_darker_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_f = Shiboken::String::createStaticString("f");
            if (PyDict_Contains(kwds, key_f)) {
                value = PyDict_GetItem(kwds, key_f);
                if (value && pyArgs[0]) {
                    errInfo = key_f;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_darker_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QColorFunc_darker_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_f);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_darker_TypeError;
            }
        }
        int cppArg0 = 200;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // darker(int)const
            QColor cppResult = const_cast<const ::QColor *>(cppSelf)->darker(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_darker_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_fromCmyk(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.fromCmyk";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromCmyk_TypeError;
    } else if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromCmyk_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:fromCmyk", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QColor::fromCmyk(int,int,int,int,int)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // fromCmyk(int,int,int,int,int)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
            overloadId = 0; // fromCmyk(int,int,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_fromCmyk_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[4]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_fromCmyk_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                        goto Sbk_QColorFunc_fromCmyk_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_fromCmyk_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4 = 255;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // fromCmyk(int,int,int,int,int)
            QColor cppResult = ::QColor::fromCmyk(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_fromCmyk_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_fromCmykF(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.fromCmykF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromCmykF_TypeError;
    } else if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromCmykF_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:fromCmykF", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QColor::fromCmykF(qreal,qreal,qreal,qreal,qreal)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // fromCmykF(qreal,qreal,qreal,qreal,qreal)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4])))) {
            overloadId = 0; // fromCmykF(qreal,qreal,qreal,qreal,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_fromCmykF_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[4]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_fromCmykF_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4]))))
                        goto Sbk_QColorFunc_fromCmykF_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_fromCmykF_TypeError;
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        qreal cppArg4 = 1.0;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // fromCmykF(qreal,qreal,qreal,qreal,qreal)
            QColor cppResult = ::QColor::fromCmykF(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_fromCmykF_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_fromHsl(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.fromHsl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromHsl_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromHsl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:fromHsl", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QColor::fromHsl(int,int,int,int)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // fromHsl(int,int,int,int)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // fromHsl(int,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_fromHsl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[3]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_fromHsl_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QColorFunc_fromHsl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_fromHsl_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = 255;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // fromHsl(int,int,int,int)
            QColor cppResult = ::QColor::fromHsl(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_fromHsl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_fromHslF(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.fromHslF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromHslF_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromHslF_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:fromHslF", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QColor::fromHslF(qreal,qreal,qreal,qreal)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // fromHslF(qreal,qreal,qreal,qreal)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
            overloadId = 0; // fromHslF(qreal,qreal,qreal,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_fromHslF_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[3]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_fromHslF_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3]))))
                        goto Sbk_QColorFunc_fromHslF_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_fromHslF_TypeError;
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3 = 1.0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // fromHslF(qreal,qreal,qreal,qreal)
            QColor cppResult = ::QColor::fromHslF(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_fromHslF_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_fromHsv(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.fromHsv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromHsv_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromHsv_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:fromHsv", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QColor::fromHsv(int,int,int,int)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // fromHsv(int,int,int,int)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // fromHsv(int,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_fromHsv_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[3]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_fromHsv_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QColorFunc_fromHsv_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_fromHsv_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = 255;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // fromHsv(int,int,int,int)
            QColor cppResult = ::QColor::fromHsv(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_fromHsv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_fromHsvF(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.fromHsvF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromHsvF_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromHsvF_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:fromHsvF", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QColor::fromHsvF(qreal,qreal,qreal,qreal)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // fromHsvF(qreal,qreal,qreal,qreal)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
            overloadId = 0; // fromHsvF(qreal,qreal,qreal,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_fromHsvF_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[3]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_fromHsvF_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3]))))
                        goto Sbk_QColorFunc_fromHsvF_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_fromHsvF_TypeError;
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3 = 1.0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // fromHsvF(qreal,qreal,qreal,qreal)
            QColor cppResult = ::QColor::fromHsvF(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_fromHsvF_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_fromRgb(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.fromRgb";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromRgb_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromRgb_TypeError;
    } else if (numArgs == 2)
        goto Sbk_QColorFunc_fromRgb_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOO:fromRgb", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QColor::fromRgb(int,int,int,int)
    // 1: static QColor::fromRgb(uint)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))) {
        overloadId = 1; // fromRgb(uint)
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // fromRgb(int,int,int,int)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // fromRgb(int,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_fromRgb_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromRgb(int r, int g, int b, int a)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_a = Shiboken::String::createStaticString("a");
                if (PyDict_Contains(kwds, key_a)) {
                    value = PyDict_GetItem(kwds, key_a);
                    if (value && pyArgs[3]) {
                        errInfo = key_a;
                        Py_INCREF(errInfo);
                        goto Sbk_QColorFunc_fromRgb_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QColorFunc_fromRgb_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_a);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QColorFunc_fromRgb_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = 255;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // fromRgb(int,int,int,int)
                QColor cppResult = ::QColor::fromRgb(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromRgb(unsigned int rgb)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColorFunc_fromRgb_TypeError;
            }
            unsigned int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // fromRgb(uint)
                QColor cppResult = ::QColor::fromRgb(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_fromRgb_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_fromRgbF(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.fromRgbF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromRgbF_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromRgbF_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:fromRgbF", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QColor::fromRgbF(qreal,qreal,qreal,qreal)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // fromRgbF(qreal,qreal,qreal,qreal)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
            overloadId = 0; // fromRgbF(qreal,qreal,qreal,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_fromRgbF_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[3]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_fromRgbF_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3]))))
                        goto Sbk_QColorFunc_fromRgbF_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_fromRgbF_TypeError;
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3 = 1.0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // fromRgbF(qreal,qreal,qreal,qreal)
            QColor cppResult = ::QColor::fromRgbF(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_fromRgbF_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_fromRgba(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.fromRgba";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QColor::fromRgba(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // fromRgba(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_fromRgba_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromRgba(uint)
            QColor cppResult = ::QColor::fromRgba(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_fromRgba_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_fromRgba64(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.fromRgba64";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromRgba64_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_fromRgba64_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:fromRgba64", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QColor::fromRgba64(ushort,ushort,ushort,ushort)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // fromRgba64(ushort,ushort,ushort,ushort)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[3])))) {
            overloadId = 0; // fromRgba64(ushort,ushort,ushort,ushort)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_fromRgba64_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[3]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_fromRgba64_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[3]))))
                        goto Sbk_QColorFunc_fromRgba64_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_fromRgba64_TypeError;
            }
        }
        ushort cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ushort cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ushort cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ushort cppArg3 = USHRT_MAX;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // fromRgba64(ushort,ushort,ushort,ushort)
            QColor cppResult = ::QColor::fromRgba64(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_fromRgba64_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_getCmyk(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.getCmyk";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_getCmyk_TypeError;
    } else if (numArgs == 1 || numArgs == 2 || numArgs == 3)
        goto Sbk_QColorFunc_getCmyk_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOO:getCmyk", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QColor::getCmyk(int*,int*,int*,int*,int*)
    if (numArgs == 0) {
        overloadId = 0; // getCmyk(int*,int*,int*,int*,int*)
    } else if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 1; // getCmyk(int*,int*,int*,int*,int*)const
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
            overloadId = 1; // getCmyk(int*,int*,int*,int*,int*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_getCmyk_TypeError;

    // Call function/method
    {
        if (kwds) {
            errInfo = kwds;
            Py_INCREF(errInfo);
            goto Sbk_QColorFunc_getCmyk_TypeError;
        }

        if (!PyErr_Occurred()) {
            // getCmyk(int*,int*,int*,int*,int*)
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number*,number* - START
            int a, b, c, d, e;
            cppSelf->getCmyk(&a, &b, &c, &d, &e);
            pyResult = PyTuple_New(5);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &d));
            PyTuple_SET_ITEM(pyResult, 4, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &e));
            // TEMPLATE - fix_number*,number*,number*,number*,number* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_getCmyk_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_getCmykF(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.getCmykF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_getCmykF_TypeError;
    } else if (numArgs == 1 || numArgs == 2 || numArgs == 3)
        goto Sbk_QColorFunc_getCmykF_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOO:getCmykF", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QColor::getCmykF(qreal*,qreal*,qreal*,qreal*,qreal*)
    if (numArgs == 0) {
        overloadId = 0; // getCmykF(qreal*,qreal*,qreal*,qreal*,qreal*)
    } else if (numArgs >= 4
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 1; // getCmykF(qreal*,qreal*,qreal*,qreal*,qreal*)const
        } else if (numArgs >= 5
            && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4])))) {
            overloadId = 1; // getCmykF(qreal*,qreal*,qreal*,qreal*,qreal*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_getCmykF_TypeError;

    // Call function/method
    {
        if (kwds) {
            errInfo = kwds;
            Py_INCREF(errInfo);
            goto Sbk_QColorFunc_getCmykF_TypeError;
        }

        if (!PyErr_Occurred()) {
            // getCmykF(qreal*,qreal*,qreal*,qreal*,qreal*)
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number*,number* - START
            qreal a, b, c, d, e;
            cppSelf->getCmykF(&a, &b, &c, &d, &e);
            pyResult = PyTuple_New(5);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &d));
            PyTuple_SET_ITEM(pyResult, 4, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &e));
            // TEMPLATE - fix_number*,number*,number*,number*,number* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_getCmykF_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_getHsl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.getHsl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getHsl(int*,int*,int*,int*)const
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number* - START
            int a, b, c, d;
            cppSelf->::QColor::getHsl(&a, &b, &c, &d);
            // TEMPLATE - tuple_abcd_same_type - START
            pyResult = PyTuple_New(4);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &d));
            // TEMPLATE - tuple_abcd_same_type - END
            // TEMPLATE - fix_number*,number*,number*,number* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_getHslF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.getHslF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getHslF(qreal*,qreal*,qreal*,qreal*)const
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number* - START
            qreal a, b, c, d;
            cppSelf->::QColor::getHslF(&a, &b, &c, &d);
            // TEMPLATE - tuple_abcd_same_type - START
            pyResult = PyTuple_New(4);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &d));
            // TEMPLATE - tuple_abcd_same_type - END
            // TEMPLATE - fix_number*,number*,number*,number* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_getHsv(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.getHsv";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getHsv(int*,int*,int*,int*)const
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number* - START
            int a, b, c, d;
            cppSelf->::QColor::getHsv(&a, &b, &c, &d);
            // TEMPLATE - tuple_abcd_same_type - START
            pyResult = PyTuple_New(4);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &d));
            // TEMPLATE - tuple_abcd_same_type - END
            // TEMPLATE - fix_number*,number*,number*,number* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_getHsvF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.getHsvF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getHsvF(qreal*,qreal*,qreal*,qreal*)const
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number* - START
            qreal a, b, c, d;
            cppSelf->::QColor::getHsvF(&a, &b, &c, &d);
            // TEMPLATE - tuple_abcd_same_type - START
            pyResult = PyTuple_New(4);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &d));
            // TEMPLATE - tuple_abcd_same_type - END
            // TEMPLATE - fix_number*,number*,number*,number* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_getRgb(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.getRgb";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getRgb(int*,int*,int*,int*)const
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number* - START
            int a, b, c, d;
            cppSelf->::QColor::getRgb(&a, &b, &c, &d);
            // TEMPLATE - tuple_abcd_same_type - START
            pyResult = PyTuple_New(4);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &d));
            // TEMPLATE - tuple_abcd_same_type - END
            // TEMPLATE - fix_number*,number*,number*,number* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_getRgbF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.getRgbF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getRgbF(qreal*,qreal*,qreal*,qreal*)const
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number* - START
            qreal a, b, c, d;
            cppSelf->::QColor::getRgbF(&a, &b, &c, &d);
            // TEMPLATE - tuple_abcd_same_type - START
            pyResult = PyTuple_New(4);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &d));
            // TEMPLATE - tuple_abcd_same_type - END
            // TEMPLATE - fix_number*,number*,number*,number* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_green(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.green";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // green()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->green();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_greenF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.greenF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // greenF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->greenF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_hslHue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.hslHue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hslHue()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->hslHue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_hslHueF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.hslHueF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hslHueF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->hslHueF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_hslSaturation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.hslSaturation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hslSaturation()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->hslSaturation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_hslSaturationF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.hslSaturationF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hslSaturationF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->hslSaturationF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_hsvHue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.hsvHue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hsvHue()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->hsvHue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_hsvHueF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.hsvHueF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hsvHueF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->hsvHueF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_hsvSaturation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.hsvSaturation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hsvSaturation()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->hsvSaturation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_hsvSaturationF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.hsvSaturationF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hsvSaturationF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->hsvSaturationF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_hue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.hue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hue()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->hue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_hueF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.hueF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hueF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->hueF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QColor *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_isValidColor(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.isValidColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QColor::isValidColor(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // isValidColor(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_isValidColor_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isValidColor(QString)
            bool cppResult = ::QColor::isValidColor(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_isValidColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_light(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.light";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_light_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:light", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QColor::light(int)const
    if (numArgs == 0) {
        overloadId = 0; // light(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // light(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_light_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_f = Shiboken::String::createStaticString("f");
            if (PyDict_Contains(kwds, key_f)) {
                value = PyDict_GetItem(kwds, key_f);
                if (value && pyArgs[0]) {
                    errInfo = key_f;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_light_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QColorFunc_light_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_f);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_light_TypeError;
            }
        }
        int cppArg0 = 150;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // light(int)const
            QColor cppResult = const_cast<const ::QColor *>(cppSelf)->light(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_light_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_lighter(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.lighter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_lighter_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:lighter", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QColor::lighter(int)const
    if (numArgs == 0) {
        overloadId = 0; // lighter(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // lighter(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_lighter_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_f = Shiboken::String::createStaticString("f");
            if (PyDict_Contains(kwds, key_f)) {
                value = PyDict_GetItem(kwds, key_f);
                if (value && pyArgs[0]) {
                    errInfo = key_f;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_lighter_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QColorFunc_lighter_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_f);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_lighter_TypeError;
            }
        }
        int cppArg0 = 150;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // lighter(int)const
            QColor cppResult = const_cast<const ::QColor *>(cppSelf)->lighter(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_lighter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_lightness(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.lightness";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lightness()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->lightness();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_lightnessF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.lightnessF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lightnessF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->lightnessF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_magenta(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.magenta";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // magenta()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->magenta();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_magentaF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.magentaF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // magentaF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->magentaF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_name(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.name";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "name", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QColor::name()const
    // 1: QColor::name(QColor::NameFormat)const
    if (numArgs == 0) {
        overloadId = 0; // name()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLOR_NAMEFORMAT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // name(QColor::NameFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_name_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // name() const
        {

            if (!PyErr_Occurred()) {
                // name()const
                QString cppResult = const_cast<const ::QColor *>(cppSelf)->name();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // name(QColor::NameFormat format) const
        {
            ::QColor::NameFormat cppArg0{QColor::HexRgb};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // name(QColor::NameFormat)const
                QString cppResult = const_cast<const ::QColor *>(cppSelf)->name(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc_name_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_red(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.red";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // red()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->red();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_redF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.redF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // redF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->redF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_rgb(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.rgb";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rgb()const
            unsigned int cppResult = const_cast<const ::QColor *>(cppSelf)->rgb();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_rgba(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.rgba";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rgba()const
            unsigned int cppResult = const_cast<const ::QColor *>(cppSelf)->rgba();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_saturation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.saturation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // saturation()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->saturation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_saturationF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.saturationF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // saturationF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->saturationF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_setAlpha(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setAlpha";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::setAlpha(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setAlpha(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setAlpha_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlpha(int)
            cppSelf->setAlpha(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setAlpha_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setAlphaF(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setAlphaF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::setAlphaF(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setAlphaF(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setAlphaF_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlphaF(qreal)
            cppSelf->setAlphaF(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setAlphaF_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setBlue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setBlue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::setBlue(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBlue(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setBlue_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBlue(int)
            cppSelf->setBlue(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setBlue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setBlueF(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setBlueF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::setBlueF(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBlueF(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setBlueF_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBlueF(qreal)
            cppSelf->setBlueF(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setBlueF_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setCmyk(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setCmyk";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setCmyk_TypeError;
    } else if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setCmyk_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:setCmyk", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QColor::setCmyk(int,int,int,int,int)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // setCmyk(int,int,int,int,int)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
            overloadId = 0; // setCmyk(int,int,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setCmyk_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[4]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_setCmyk_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                        goto Sbk_QColorFunc_setCmyk_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_setCmyk_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4 = 255;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // setCmyk(int,int,int,int,int)
            cppSelf->setCmyk(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setCmyk_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setCmykF(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setCmykF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setCmykF_TypeError;
    } else if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setCmykF_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:setCmykF", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QColor::setCmykF(qreal,qreal,qreal,qreal,qreal)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // setCmykF(qreal,qreal,qreal,qreal,qreal)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4])))) {
            overloadId = 0; // setCmykF(qreal,qreal,qreal,qreal,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setCmykF_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[4]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_setCmykF_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4]))))
                        goto Sbk_QColorFunc_setCmykF_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_setCmykF_TypeError;
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        qreal cppArg4 = 1.0;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // setCmykF(qreal,qreal,qreal,qreal,qreal)
            cppSelf->setCmykF(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setCmykF_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setGreen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setGreen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::setGreen(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setGreen(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setGreen_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGreen(int)
            cppSelf->setGreen(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setGreen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setGreenF(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setGreenF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::setGreenF(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setGreenF(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setGreenF_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGreenF(qreal)
            cppSelf->setGreenF(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setGreenF_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setHsl(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setHsl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setHsl_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setHsl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:setHsl", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QColor::setHsl(int,int,int,int)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // setHsl(int,int,int,int)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // setHsl(int,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setHsl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[3]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_setHsl_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QColorFunc_setHsl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_setHsl_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = 255;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // setHsl(int,int,int,int)
            cppSelf->setHsl(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setHsl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setHslF(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setHslF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setHslF_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setHslF_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:setHslF", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QColor::setHslF(qreal,qreal,qreal,qreal)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // setHslF(qreal,qreal,qreal,qreal)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
            overloadId = 0; // setHslF(qreal,qreal,qreal,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setHslF_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[3]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_setHslF_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3]))))
                        goto Sbk_QColorFunc_setHslF_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_setHslF_TypeError;
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3 = 1.0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // setHslF(qreal,qreal,qreal,qreal)
            cppSelf->setHslF(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setHslF_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setHsv(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setHsv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setHsv_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setHsv_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:setHsv", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QColor::setHsv(int,int,int,int)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // setHsv(int,int,int,int)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // setHsv(int,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setHsv_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[3]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_setHsv_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QColorFunc_setHsv_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_setHsv_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = 255;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // setHsv(int,int,int,int)
            cppSelf->setHsv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setHsv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setHsvF(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setHsvF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setHsvF_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setHsvF_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:setHsvF", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QColor::setHsvF(qreal,qreal,qreal,qreal)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // setHsvF(qreal,qreal,qreal,qreal)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
            overloadId = 0; // setHsvF(qreal,qreal,qreal,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setHsvF_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[3]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_setHsvF_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3]))))
                        goto Sbk_QColorFunc_setHsvF_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_setHsvF_TypeError;
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3 = 1.0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // setHsvF(qreal,qreal,qreal,qreal)
            cppSelf->setHsvF(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setHsvF_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setNamedColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setNamedColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::setNamedColor(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setNamedColor(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setNamedColor_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNamedColor(QString)
            cppSelf->setNamedColor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setNamedColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setRed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setRed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::setRed(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setRed(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setRed_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRed(int)
            cppSelf->setRed(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setRed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setRedF(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setRedF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::setRedF(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setRedF(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setRedF_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRedF(qreal)
            cppSelf->setRedF(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setRedF_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setRgb(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setRgb";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setRgb_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setRgb_TypeError;
    } else if (numArgs == 2)
        goto Sbk_QColorFunc_setRgb_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOO:setRgb", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QColor::setRgb(int,int,int,int)
    // 1: QColor::setRgb(uint)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))) {
        overloadId = 1; // setRgb(uint)
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // setRgb(int,int,int,int)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // setRgb(int,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setRgb_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setRgb(int r, int g, int b, int a)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_a = Shiboken::String::createStaticString("a");
                if (PyDict_Contains(kwds, key_a)) {
                    value = PyDict_GetItem(kwds, key_a);
                    if (value && pyArgs[3]) {
                        errInfo = key_a;
                        Py_INCREF(errInfo);
                        goto Sbk_QColorFunc_setRgb_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QColorFunc_setRgb_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_a);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QColorFunc_setRgb_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = 255;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setRgb(int,int,int,int)
                cppSelf->setRgb(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // setRgb(unsigned int rgb)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QColorFunc_setRgb_TypeError;
            }
            unsigned int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setRgb(uint)
                cppSelf->setRgb(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setRgb_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setRgbF(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setRgbF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setRgbF_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QColorFunc_setRgbF_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:setRgbF", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QColor::setRgbF(qreal,qreal,qreal,qreal)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // setRgbF(qreal,qreal,qreal,qreal)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
            overloadId = 0; // setRgbF(qreal,qreal,qreal,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setRgbF_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_a = Shiboken::String::createStaticString("a");
            if (PyDict_Contains(kwds, key_a)) {
                value = PyDict_GetItem(kwds, key_a);
                if (value && pyArgs[3]) {
                    errInfo = key_a;
                    Py_INCREF(errInfo);
                    goto Sbk_QColorFunc_setRgbF_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3]))))
                        goto Sbk_QColorFunc_setRgbF_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_a);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColorFunc_setRgbF_TypeError;
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3 = 1.0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // setRgbF(qreal,qreal,qreal,qreal)
            cppSelf->setRgbF(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setRgbF_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_setRgba(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.setRgba";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColor::setRgba(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // setRgba(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColorFunc_setRgba_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRgba(uint)
            cppSelf->setRgba(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QColorFunc_setRgba_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc_spec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.spec";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // spec()const
            QColor::Spec cppResult = const_cast<const ::QColor *>(cppSelf)->spec();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_toCmyk(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.toCmyk";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toCmyk()const
            QColor cppResult = const_cast<const ::QColor *>(cppSelf)->toCmyk();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_toExtendedRgb(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.toExtendedRgb";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toExtendedRgb()const
            QColor cppResult = const_cast<const ::QColor *>(cppSelf)->toExtendedRgb();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_toHsl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.toHsl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toHsl()const
            QColor cppResult = const_cast<const ::QColor *>(cppSelf)->toHsl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_toHsv(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.toHsv";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toHsv()const
            QColor cppResult = const_cast<const ::QColor *>(cppSelf)->toHsv();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_toRgb(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.toRgb";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toRgb()const
            QColor cppResult = const_cast<const ::QColor *>(cppSelf)->toRgb();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_toTuple(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.toTuple";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toTuple()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtgui.cpp (qcolor-totuple)]
            switch (cppSelf->spec()) {
              case QColor::Rgb:
              {
                    int r, g, b, a;
                    cppSelf->getRgb(&r, &g, &b, &a);
                    pyResult = Py_BuildValue("iiii", r, g, b, a);
                    break;
              }
              case QColor::Hsv:
              {
                    int h, s, v, a;
                    cppSelf->getHsv(&h, &s, &v, &a);
                    pyResult = Py_BuildValue("iiii", h, s, v, a);
                    break;
              }
              case QColor::Cmyk:
              {
                    int c, m, y, k, a;
                    cppSelf->getCmyk(&c, &m, &y, &k, &a);
                    pyResult = Py_BuildValue("iiiii", c, m, y, k, a);
                    break;
              }
              case QColor::Hsl:
              {
                    int h, s, l, a;
                    cppSelf->getHsl(&h, &s, &l, &a);
                    pyResult = Py_BuildValue("iiii", h, s, l, a);
                    break;
              }
              default:
              {
                    pyResult = 0;
              }
            }
            // END of custom code block [file: ../glue/qtgui.cpp (qcolor-totuple)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_value(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.value";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // value()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->value();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_valueF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.valueF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // valueF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->valueF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_yellow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.yellow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // yellow()const
            int cppResult = const_cast<const ::QColor *>(cppSelf)->yellow();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColorFunc_yellowF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.yellowF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // yellowF()const
            qreal cppResult = const_cast<const ::QColor *>(cppSelf)->yellowF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColor___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QColor_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QColor_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QColorFunc___reduce__), METH_NOARGS},
    {"__setstate__", reinterpret_cast<PyCFunction>(Sbk_QColorFunc___setstate__), METH_O},
    {"alpha", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_alpha), METH_NOARGS},
    {"alphaF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_alphaF), METH_NOARGS},
    {"black", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_black), METH_NOARGS},
    {"blackF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_blackF), METH_NOARGS},
    {"blue", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_blue), METH_NOARGS},
    {"blueF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_blueF), METH_NOARGS},
    {"colorNames", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_colorNames), METH_NOARGS|METH_STATIC},
    {"convertTo", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_convertTo), METH_O},
    {"cyan", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_cyan), METH_NOARGS},
    {"cyanF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_cyanF), METH_NOARGS},
    {"dark", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_dark), METH_VARARGS|METH_KEYWORDS},
    {"darker", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_darker), METH_VARARGS|METH_KEYWORDS},
    {"fromCmyk", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_fromCmyk), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromCmykF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_fromCmykF), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromHsl", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_fromHsl), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromHslF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_fromHslF), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromHsv", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_fromHsv), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromHsvF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_fromHsvF), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromRgb", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_fromRgb), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromRgbF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_fromRgbF), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromRgba", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_fromRgba), METH_O|METH_STATIC},
    {"fromRgba64", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_fromRgba64), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getCmyk", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_getCmyk), METH_VARARGS|METH_KEYWORDS},
    {"getCmykF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_getCmykF), METH_VARARGS|METH_KEYWORDS},
    {"getHsl", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_getHsl), METH_NOARGS},
    {"getHslF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_getHslF), METH_NOARGS},
    {"getHsv", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_getHsv), METH_NOARGS},
    {"getHsvF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_getHsvF), METH_NOARGS},
    {"getRgb", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_getRgb), METH_NOARGS},
    {"getRgbF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_getRgbF), METH_NOARGS},
    {"green", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_green), METH_NOARGS},
    {"greenF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_greenF), METH_NOARGS},
    {"hslHue", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_hslHue), METH_NOARGS},
    {"hslHueF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_hslHueF), METH_NOARGS},
    {"hslSaturation", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_hslSaturation), METH_NOARGS},
    {"hslSaturationF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_hslSaturationF), METH_NOARGS},
    {"hsvHue", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_hsvHue), METH_NOARGS},
    {"hsvHueF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_hsvHueF), METH_NOARGS},
    {"hsvSaturation", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_hsvSaturation), METH_NOARGS},
    {"hsvSaturationF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_hsvSaturationF), METH_NOARGS},
    {"hue", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_hue), METH_NOARGS},
    {"hueF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_hueF), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_isValid), METH_NOARGS},
    {"isValidColor", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_isValidColor), METH_O|METH_STATIC},
    {"light", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_light), METH_VARARGS|METH_KEYWORDS},
    {"lighter", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_lighter), METH_VARARGS|METH_KEYWORDS},
    {"lightness", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_lightness), METH_NOARGS},
    {"lightnessF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_lightnessF), METH_NOARGS},
    {"magenta", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_magenta), METH_NOARGS},
    {"magentaF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_magentaF), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_name), METH_VARARGS},
    {"red", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_red), METH_NOARGS},
    {"redF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_redF), METH_NOARGS},
    {"rgb", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_rgb), METH_NOARGS},
    {"rgba", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_rgba), METH_NOARGS},
    {"saturation", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_saturation), METH_NOARGS},
    {"saturationF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_saturationF), METH_NOARGS},
    {"setAlpha", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setAlpha), METH_O},
    {"setAlphaF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setAlphaF), METH_O},
    {"setBlue", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setBlue), METH_O},
    {"setBlueF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setBlueF), METH_O},
    {"setCmyk", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setCmyk), METH_VARARGS|METH_KEYWORDS},
    {"setCmykF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setCmykF), METH_VARARGS|METH_KEYWORDS},
    {"setGreen", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setGreen), METH_O},
    {"setGreenF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setGreenF), METH_O},
    {"setHsl", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setHsl), METH_VARARGS|METH_KEYWORDS},
    {"setHslF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setHslF), METH_VARARGS|METH_KEYWORDS},
    {"setHsv", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setHsv), METH_VARARGS|METH_KEYWORDS},
    {"setHsvF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setHsvF), METH_VARARGS|METH_KEYWORDS},
    {"setNamedColor", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setNamedColor), METH_O},
    {"setRed", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setRed), METH_O},
    {"setRedF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setRedF), METH_O},
    {"setRgb", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setRgb), METH_VARARGS|METH_KEYWORDS},
    {"setRgbF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setRgbF), METH_VARARGS|METH_KEYWORDS},
    {"setRgba", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_setRgba), METH_O},
    {"spec", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_spec), METH_NOARGS},
    {"toCmyk", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_toCmyk), METH_NOARGS},
    {"toExtendedRgb", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_toExtendedRgb), METH_NOARGS},
    {"toHsl", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_toHsl), METH_NOARGS},
    {"toHsv", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_toHsv), METH_NOARGS},
    {"toRgb", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_toRgb), METH_NOARGS},
    {"toTuple", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_toTuple), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_value), METH_NOARGS},
    {"valueF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_valueF), METH_NOARGS},
    {"yellow", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_yellow), METH_NOARGS},
    {"yellowF", reinterpret_cast<PyCFunction>(Sbk_QColorFunc_yellowF), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QColor___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QColorFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QColor::operator<<(QDataStream&,QColor)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QColor)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QColorFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QColor) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColorFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QColor.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QColor::operator>>(QDataStream&,QColor&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QColor&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QColorFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QColor&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColorFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QColor_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
                // operator!=(const QColor & c) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QColor cppArg0_local;
                ::QColor *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
                // operator==(const QColor & c) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QColor cppArg0_local;
                ::QColor *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QColor_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QColor_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QColor_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QColor_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QColor_Type = nullptr;
static SbkObjectType *Sbk_QColor_TypeF(void)
{
    return _Sbk_QColor_Type;
}

static PyType_Slot Sbk_QColor_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QColorFunc___repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         reinterpret_cast<void *>(Sbk_QColorFunc___str__)},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QColor_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QColor_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QColor_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QColor_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QColor_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QColorFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QColorFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QColor_spec = {
    "2:PySide2.QtGui.QColor",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QColor_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QColor_Spec_PythonToCpp_QColor_Spec(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QColor::Spec *>(cppOut) =
        static_cast<::QColor::Spec>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QColor_Spec_PythonToCpp_QColor_Spec_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX]))
        return QColor_Spec_PythonToCpp_QColor_Spec;
    return {};
}
static PyObject *QColor_Spec_CppToPython_QColor_Spec(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QColor::Spec *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX], castCppIn);

}

static void QColor_NameFormat_PythonToCpp_QColor_NameFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QColor::NameFormat *>(cppOut) =
        static_cast<::QColor::NameFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QColor_NameFormat_PythonToCpp_QColor_NameFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QCOLOR_NAMEFORMAT_IDX]))
        return QColor_NameFormat_PythonToCpp_QColor_NameFormat;
    return {};
}
static PyObject *QColor_NameFormat_CppToPython_QColor_NameFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QColor::NameFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QCOLOR_NAMEFORMAT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QColor_PythonToCpp_QColor_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QColor_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QColor_PythonToCpp_QColor_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QColor_TypeF())))
        return QColor_PythonToCpp_QColor_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QColor_PTR_CppToPython_QColor(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QColor *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QColor_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QColor_COPY_CppToPython_QColor(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QColor_TypeF(), new ::QColor(*reinterpret_cast<const ::QColor *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QColor_PythonToCpp_QColor_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QColor *>(cppOut) = *reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QColor_PythonToCpp_QColor_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QColor_TypeF())))
        return QColor_PythonToCpp_QColor_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QColor(PyObject *pyIn, void *cppOut) {
    ::Qt::GlobalColor cppIn{Qt::color0};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QColor *>(cppOut) = ::QColor(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QColor_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX], pyIn))
        return PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QColor;
    return {};
}

static void PySide2_QtCore_constQStringREF_PythonToCpp_QColor(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QColor *>(cppOut) = ::QColor(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_constQStringREF_PythonToCpp_QColor_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return PySide2_QtCore_constQStringREF_PythonToCpp_QColor;
    return {};
}

static void PySide2_QtCore_unsignedint_PythonToCpp_QColor(PyObject *pyIn, void *cppOut) {
    unsigned int cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), pyIn, &cppIn);
    *reinterpret_cast<::QColor *>(cppOut) = ::QColor(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_unsignedint_PythonToCpp_QColor_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return PySide2_QtCore_unsignedint_PythonToCpp_QColor;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QColor_SignatureStrings[] = {
    "7:PySide2.QtGui.QColor(self)",
    "6:PySide2.QtGui.QColor(self,spec:PySide2.QtGui.QColor.Spec,a1:ushort,a2:ushort,a3:ushort,a4:ushort,a5:ushort=0)",
    "5:PySide2.QtGui.QColor(self,arg__1:QVariant)",
    "4:PySide2.QtGui.QColor(self,color:PySide2.QtCore.Qt.GlobalColor)",
    "3:PySide2.QtGui.QColor(self,color:PySide2.QtGui.QColor)",
    "2:PySide2.QtGui.QColor(self,name:QString)",
    "1:PySide2.QtGui.QColor(self,r:int,g:int,b:int,a:int=255)",
    "0:PySide2.QtGui.QColor(self,rgb:unsigned int)",
    "PySide2.QtGui.QColor.__reduce__(self)->PyObject",
    "PySide2.QtGui.QColor.__repr__(self)->PyObject",
    "PySide2.QtGui.QColor.__setstate__(self,arg__1:PyObject)->PyObject",
    "PySide2.QtGui.QColor.__str__(self)->PyObject",
    "PySide2.QtGui.QColor.alpha(self)->int",
    "PySide2.QtGui.QColor.alphaF(self)->qreal",
    "PySide2.QtGui.QColor.black(self)->int",
    "PySide2.QtGui.QColor.blackF(self)->qreal",
    "PySide2.QtGui.QColor.blue(self)->int",
    "PySide2.QtGui.QColor.blueF(self)->qreal",
    "PySide2.QtGui.QColor.colorNames()->QStringList",
    "PySide2.QtGui.QColor.convertTo(self,colorSpec:PySide2.QtGui.QColor.Spec)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.cyan(self)->int",
    "PySide2.QtGui.QColor.cyanF(self)->qreal",
    "PySide2.QtGui.QColor.dark(self,f:int=200)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.darker(self,f:int=200)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.fromCmyk(c:int,m:int,y:int,k:int,a:int=255)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.fromCmykF(c:qreal,m:qreal,y:qreal,k:qreal,a:qreal=1.0)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.fromHsl(h:int,s:int,l:int,a:int=255)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.fromHslF(h:qreal,s:qreal,l:qreal,a:qreal=1.0)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.fromHsv(h:int,s:int,v:int,a:int=255)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.fromHsvF(h:qreal,s:qreal,v:qreal,a:qreal=1.0)->PySide2.QtGui.QColor",
    "1:PySide2.QtGui.QColor.fromRgb(r:int,g:int,b:int,a:int=255)->PySide2.QtGui.QColor",
    "0:PySide2.QtGui.QColor.fromRgb(rgb:unsigned int)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.fromRgbF(r:qreal,g:qreal,b:qreal,a:qreal=1.0)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.fromRgba(rgba:unsigned int)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.fromRgba64(r:ushort,g:ushort,b:ushort,a:ushort=USHRT_MAX)->PySide2.QtGui.QColor",
    "1:PySide2.QtGui.QColor.getCmyk(self,c:int*,m:int*,y:int*,k:int*,a:int*)",
    "0:PySide2.QtGui.QColor.getCmyk(self,c:int*,m:int*,y:int*,k:int*,a:int*=nullptr)",
    "1:PySide2.QtGui.QColor.getCmykF(self,c:qreal*,m:qreal*,y:qreal*,k:qreal*,a:qreal*)",
    "0:PySide2.QtGui.QColor.getCmykF(self,c:qreal*,m:qreal*,y:qreal*,k:qreal*,a:qreal*=nullptr)",
    "PySide2.QtGui.QColor.getHsl(self,h:int*,s:int*,l:int*,a:int*)",
    "PySide2.QtGui.QColor.getHslF(self,h:qreal*,s:qreal*,l:qreal*,a:qreal*)",
    "PySide2.QtGui.QColor.getHsv(self,h:int*,s:int*,v:int*,a:int*)",
    "PySide2.QtGui.QColor.getHsvF(self,h:qreal*,s:qreal*,v:qreal*,a:qreal*)",
    "PySide2.QtGui.QColor.getRgb(self,r:int*,g:int*,b:int*,a:int*)",
    "PySide2.QtGui.QColor.getRgbF(self,r:qreal*,g:qreal*,b:qreal*,a:qreal*)",
    "PySide2.QtGui.QColor.green(self)->int",
    "PySide2.QtGui.QColor.greenF(self)->qreal",
    "PySide2.QtGui.QColor.hslHue(self)->int",
    "PySide2.QtGui.QColor.hslHueF(self)->qreal",
    "PySide2.QtGui.QColor.hslSaturation(self)->int",
    "PySide2.QtGui.QColor.hslSaturationF(self)->qreal",
    "PySide2.QtGui.QColor.hsvHue(self)->int",
    "PySide2.QtGui.QColor.hsvHueF(self)->qreal",
    "PySide2.QtGui.QColor.hsvSaturation(self)->int",
    "PySide2.QtGui.QColor.hsvSaturationF(self)->qreal",
    "PySide2.QtGui.QColor.hue(self)->int",
    "PySide2.QtGui.QColor.hueF(self)->qreal",
    "PySide2.QtGui.QColor.isValid(self)->bool",
    "PySide2.QtGui.QColor.isValidColor(name:QString)->bool",
    "PySide2.QtGui.QColor.light(self,f:int=150)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.lighter(self,f:int=150)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.lightness(self)->int",
    "PySide2.QtGui.QColor.lightnessF(self)->qreal",
    "PySide2.QtGui.QColor.magenta(self)->int",
    "PySide2.QtGui.QColor.magentaF(self)->qreal",
    "1:PySide2.QtGui.QColor.name(self)->QString",
    "0:PySide2.QtGui.QColor.name(self,format:PySide2.QtGui.QColor.NameFormat)->QString",
    "PySide2.QtGui.QColor.red(self)->int",
    "PySide2.QtGui.QColor.redF(self)->qreal",
    "PySide2.QtGui.QColor.rgb(self)->unsigned int",
    "PySide2.QtGui.QColor.rgba(self)->unsigned int",
    "PySide2.QtGui.QColor.saturation(self)->int",
    "PySide2.QtGui.QColor.saturationF(self)->qreal",
    "PySide2.QtGui.QColor.setAlpha(self,alpha:int)",
    "PySide2.QtGui.QColor.setAlphaF(self,alpha:qreal)",
    "PySide2.QtGui.QColor.setBlue(self,blue:int)",
    "PySide2.QtGui.QColor.setBlueF(self,blue:qreal)",
    "PySide2.QtGui.QColor.setCmyk(self,c:int,m:int,y:int,k:int,a:int=255)",
    "PySide2.QtGui.QColor.setCmykF(self,c:qreal,m:qreal,y:qreal,k:qreal,a:qreal=1.0)",
    "PySide2.QtGui.QColor.setGreen(self,green:int)",
    "PySide2.QtGui.QColor.setGreenF(self,green:qreal)",
    "PySide2.QtGui.QColor.setHsl(self,h:int,s:int,l:int,a:int=255)",
    "PySide2.QtGui.QColor.setHslF(self,h:qreal,s:qreal,l:qreal,a:qreal=1.0)",
    "PySide2.QtGui.QColor.setHsv(self,h:int,s:int,v:int,a:int=255)",
    "PySide2.QtGui.QColor.setHsvF(self,h:qreal,s:qreal,v:qreal,a:qreal=1.0)",
    "PySide2.QtGui.QColor.setNamedColor(self,name:QString)",
    "PySide2.QtGui.QColor.setRed(self,red:int)",
    "PySide2.QtGui.QColor.setRedF(self,red:qreal)",
    "1:PySide2.QtGui.QColor.setRgb(self,r:int,g:int,b:int,a:int=255)",
    "0:PySide2.QtGui.QColor.setRgb(self,rgb:unsigned int)",
    "PySide2.QtGui.QColor.setRgbF(self,r:qreal,g:qreal,b:qreal,a:qreal=1.0)",
    "PySide2.QtGui.QColor.setRgba(self,rgba:unsigned int)",
    "PySide2.QtGui.QColor.spec(self)->PySide2.QtGui.QColor.Spec",
    "PySide2.QtGui.QColor.toCmyk(self)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.toExtendedRgb(self)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.toHsl(self)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.toHsv(self)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.toRgb(self)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QColor.toTuple(self)->PyObject",
    "PySide2.QtGui.QColor.value(self)->int",
    "PySide2.QtGui.QColor.valueF(self)->qreal",
    "PySide2.QtGui.QColor.yellow(self)->int",
    "PySide2.QtGui.QColor.yellowF(self)->qreal",
    "PySide2.QtGui.QColor.__copy__()",
    "PySide2.QtGui.QColor.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QColor.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QColor(PyObject *module)
{
    _Sbk_QColor_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QColor",
        "QColor",
        &Sbk_QColor_spec,
        &Shiboken::callCppDestructor< ::QColor >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QColor_Type);
    InitSignatureStrings(pyType, QColor_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QColor_Type), Sbk_QColor_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QColor_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QColor_TypeF(),
        QColor_PythonToCpp_QColor_PTR,
        is_QColor_PythonToCpp_QColor_PTR_Convertible,
        QColor_PTR_CppToPython_QColor,
        QColor_COPY_CppToPython_QColor);

    Shiboken::Conversions::registerConverterName(converter, "QColor");
    Shiboken::Conversions::registerConverterName(converter, "QColor*");
    Shiboken::Conversions::registerConverterName(converter, "QColor&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QColor).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QColor_PythonToCpp_QColor_COPY,
        is_QColor_PythonToCpp_QColor_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QColor,
        is_PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QColor_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQStringREF_PythonToCpp_QColor,
        is_PySide2_QtCore_constQStringREF_PythonToCpp_QColor_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_unsignedint_PythonToCpp_QColor,
        is_PySide2_QtCore_unsignedint_PythonToCpp_QColor_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Spec'.
    SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QColor_TypeF(),
        "Spec",
        "2:PySide2.QtGui.QColor.Spec",
        "QColor::Spec");
    if (!SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX],
        Sbk_QColor_TypeF(), "Invalid", (long) QColor::Spec::Invalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX],
        Sbk_QColor_TypeF(), "Rgb", (long) QColor::Spec::Rgb))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX],
        Sbk_QColor_TypeF(), "Hsv", (long) QColor::Spec::Hsv))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX],
        Sbk_QColor_TypeF(), "Cmyk", (long) QColor::Spec::Cmyk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX],
        Sbk_QColor_TypeF(), "Hsl", (long) QColor::Spec::Hsl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX],
        Sbk_QColor_TypeF(), "ExtendedRgb", (long) QColor::Spec::ExtendedRgb))
        return;
    // Register converter for enum 'QColor::Spec'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX],
            QColor_Spec_CppToPython_QColor_Spec);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QColor_Spec_PythonToCpp_QColor_Spec,
            is_QColor_Spec_PythonToCpp_QColor_Spec_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QCOLOR_SPEC_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QColor::Spec");
        Shiboken::Conversions::registerConverterName(converter, "Spec");
    }
    // End of 'Spec' enum.

    // Initialization of enum 'NameFormat'.
    SbkPySide2_QtGuiTypes[SBK_QCOLOR_NAMEFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QColor_TypeF(),
        "NameFormat",
        "2:PySide2.QtGui.QColor.NameFormat",
        "QColor::NameFormat");
    if (!SbkPySide2_QtGuiTypes[SBK_QCOLOR_NAMEFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLOR_NAMEFORMAT_IDX],
        Sbk_QColor_TypeF(), "HexRgb", (long) QColor::NameFormat::HexRgb))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QCOLOR_NAMEFORMAT_IDX],
        Sbk_QColor_TypeF(), "HexArgb", (long) QColor::NameFormat::HexArgb))
        return;
    // Register converter for enum 'QColor::NameFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QCOLOR_NAMEFORMAT_IDX],
            QColor_NameFormat_CppToPython_QColor_NameFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QColor_NameFormat_PythonToCpp_QColor_NameFormat,
            is_QColor_NameFormat_PythonToCpp_QColor_NameFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QCOLOR_NAMEFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QColor::NameFormat");
        Shiboken::Conversions::registerConverterName(converter, "NameFormat");
    }
    // End of 'NameFormat' enum.

    qRegisterMetaType< ::QColor >("QColor");
    qRegisterMetaType< ::QColor::Spec >("QColor::Spec");
    qRegisterMetaType< ::QColor::NameFormat >("QColor::NameFormat");
}
