/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qaccessibletablemodelchangeevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAccessibleTableModelChangeEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAccessibleTableModelChangeEventWrapper::QAccessibleTableModelChangeEventWrapper(::QAccessibleInterface * iface, ::QAccessibleTableModelChangeEvent::ModelChangeType changeType) : QAccessibleTableModelChangeEvent(iface, changeType)
{
    resetPyMethodCache();
    // ... middle
}

QAccessibleTableModelChangeEventWrapper::QAccessibleTableModelChangeEventWrapper(::QObject * obj, ::QAccessibleTableModelChangeEvent::ModelChangeType changeType) : QAccessibleTableModelChangeEvent(obj, changeType)
{
    resetPyMethodCache();
    // ... middle
}

::QAccessibleInterface * QAccessibleTableModelChangeEventWrapper::accessibleInterface() const
{
    if (m_PyMethodCache[0])
        return this->::QAccessibleEvent::accessibleInterface();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "accessibleInterface";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QAccessibleEvent::accessibleInterface();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAccessibleTableModelChangeEvent.accessibleInterface", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QAccessibleInterface >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QAccessibleInterface *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QAccessibleTableModelChangeEventWrapper::~QAccessibleTableModelChangeEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAccessibleTableModelChangeEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAccessibleTableModelChangeEvent >()))
        return -1;

    ::QAccessibleTableModelChangeEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTableModelChangeEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QAccessibleTableModelChangeEvent", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QAccessibleTableModelChangeEvent::QAccessibleTableModelChangeEvent(QAccessibleInterface*,QAccessibleTableModelChangeEvent::ModelChangeType)
    // 1: QAccessibleTableModelChangeEvent::QAccessibleTableModelChangeEvent(QObject*,QAccessibleTableModelChangeEvent::ModelChangeType)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 1; // QAccessibleTableModelChangeEvent(QObject*,QAccessibleTableModelChangeEvent::ModelChangeType)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // QAccessibleTableModelChangeEvent(QAccessibleInterface*,QAccessibleTableModelChangeEvent::ModelChangeType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleTableModelChangeEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAccessibleTableModelChangeEvent(QAccessibleInterface * iface, QAccessibleTableModelChangeEvent::ModelChangeType changeType)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAccessibleInterface *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QAccessibleTableModelChangeEvent::ModelChangeType cppArg1{QAccessibleTableModelChangeEvent::ModelReset};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QAccessibleTableModelChangeEvent(QAccessibleInterface*,QAccessibleTableModelChangeEvent::ModelChangeType)
                cptr = new ::QAccessibleTableModelChangeEventWrapper(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // QAccessibleTableModelChangeEvent(QObject * obj, QAccessibleTableModelChangeEvent::ModelChangeType changeType)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QAccessibleTableModelChangeEvent::ModelChangeType cppArg1{QAccessibleTableModelChangeEvent::ModelReset};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QAccessibleTableModelChangeEvent(QObject*,QAccessibleTableModelChangeEvent::ModelChangeType)
                cptr = new ::QAccessibleTableModelChangeEventWrapper(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAccessibleTableModelChangeEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAccessibleTableModelChangeEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAccessibleTableModelChangeEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAccessibleTableModelChangeEventFunc_firstColumn(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTableModelChangeEvent.firstColumn";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // firstColumn()const
            int cppResult = const_cast<const ::QAccessibleTableModelChangeEvent *>(cppSelf)->firstColumn();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleTableModelChangeEventFunc_firstRow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTableModelChangeEvent.firstRow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // firstRow()const
            int cppResult = const_cast<const ::QAccessibleTableModelChangeEvent *>(cppSelf)->firstRow();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleTableModelChangeEventFunc_lastColumn(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTableModelChangeEvent.lastColumn";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastColumn()const
            int cppResult = const_cast<const ::QAccessibleTableModelChangeEvent *>(cppSelf)->lastColumn();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleTableModelChangeEventFunc_lastRow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTableModelChangeEvent.lastRow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastRow()const
            int cppResult = const_cast<const ::QAccessibleTableModelChangeEvent *>(cppSelf)->lastRow();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleTableModelChangeEventFunc_modelChangeType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTableModelChangeEvent.modelChangeType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // modelChangeType()const
            QAccessibleTableModelChangeEvent::ModelChangeType cppResult = const_cast<const ::QAccessibleTableModelChangeEvent *>(cppSelf)->modelChangeType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAccessibleTableModelChangeEventFunc_setFirstColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTableModelChangeEvent.setFirstColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAccessibleTableModelChangeEvent::setFirstColumn(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setFirstColumn(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleTableModelChangeEventFunc_setFirstColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFirstColumn(int)
            cppSelf->setFirstColumn(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAccessibleTableModelChangeEventFunc_setFirstColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleTableModelChangeEventFunc_setFirstRow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTableModelChangeEvent.setFirstRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAccessibleTableModelChangeEvent::setFirstRow(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setFirstRow(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleTableModelChangeEventFunc_setFirstRow_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFirstRow(int)
            cppSelf->setFirstRow(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAccessibleTableModelChangeEventFunc_setFirstRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleTableModelChangeEventFunc_setLastColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTableModelChangeEvent.setLastColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAccessibleTableModelChangeEvent::setLastColumn(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLastColumn(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleTableModelChangeEventFunc_setLastColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLastColumn(int)
            cppSelf->setLastColumn(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAccessibleTableModelChangeEventFunc_setLastColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleTableModelChangeEventFunc_setLastRow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTableModelChangeEvent.setLastRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAccessibleTableModelChangeEvent::setLastRow(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLastRow(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleTableModelChangeEventFunc_setLastRow_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLastRow(int)
            cppSelf->setLastRow(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAccessibleTableModelChangeEventFunc_setLastRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAccessibleTableModelChangeEventFunc_setModelChangeType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessibleTableModelChangeEvent.setModelChangeType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAccessibleTableModelChangeEvent::setModelChangeType(QAccessibleTableModelChangeEvent::ModelChangeType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setModelChangeType(QAccessibleTableModelChangeEvent::ModelChangeType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessibleTableModelChangeEventFunc_setModelChangeType_TypeError;

    // Call function/method
    {
        ::QAccessibleTableModelChangeEvent::ModelChangeType cppArg0{QAccessibleTableModelChangeEvent::ModelReset};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setModelChangeType(QAccessibleTableModelChangeEvent::ModelChangeType)
            cppSelf->setModelChangeType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAccessibleTableModelChangeEventFunc_setModelChangeType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QAccessibleTableModelChangeEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAccessibleTableModelChangeEvent_methods[] = {
    {"firstColumn", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTableModelChangeEventFunc_firstColumn), METH_NOARGS},
    {"firstRow", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTableModelChangeEventFunc_firstRow), METH_NOARGS},
    {"lastColumn", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTableModelChangeEventFunc_lastColumn), METH_NOARGS},
    {"lastRow", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTableModelChangeEventFunc_lastRow), METH_NOARGS},
    {"modelChangeType", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTableModelChangeEventFunc_modelChangeType), METH_NOARGS},
    {"setFirstColumn", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTableModelChangeEventFunc_setFirstColumn), METH_O},
    {"setFirstRow", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTableModelChangeEventFunc_setFirstRow), METH_O},
    {"setLastColumn", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTableModelChangeEventFunc_setLastColumn), METH_O},
    {"setLastRow", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTableModelChangeEventFunc_setLastRow), METH_O},
    {"setModelChangeType", reinterpret_cast<PyCFunction>(Sbk_QAccessibleTableModelChangeEventFunc_setModelChangeType), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAccessibleTableModelChangeEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAccessibleTableModelChangeEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAccessibleTableModelChangeEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAccessibleTableModelChangeEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAccessibleTableModelChangeEvent_Type = nullptr;
static SbkObjectType *Sbk_QAccessibleTableModelChangeEvent_TypeF(void)
{
    return _Sbk_QAccessibleTableModelChangeEvent_Type;
}

static PyType_Slot Sbk_QAccessibleTableModelChangeEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAccessibleTableModelChangeEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAccessibleTableModelChangeEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAccessibleTableModelChangeEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAccessibleTableModelChangeEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAccessibleTableModelChangeEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAccessibleTableModelChangeEvent_spec = {
    "2:PySide2.QtGui.QAccessibleTableModelChangeEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAccessibleTableModelChangeEvent_slots
};

} //extern "C"

static void *Sbk_QAccessibleTableModelChangeEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QAccessibleTableModelChangeEvent *>(cptr)->type() == QAccessible::TableModelChanged)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QAccessibleTableModelChangeEvent_ModelChangeType_PythonToCpp_QAccessibleTableModelChangeEvent_ModelChangeType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAccessibleTableModelChangeEvent::ModelChangeType *>(cppOut) =
        static_cast<::QAccessibleTableModelChangeEvent::ModelChangeType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAccessibleTableModelChangeEvent_ModelChangeType_PythonToCpp_QAccessibleTableModelChangeEvent_ModelChangeType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX]))
        return QAccessibleTableModelChangeEvent_ModelChangeType_PythonToCpp_QAccessibleTableModelChangeEvent_ModelChangeType;
    return {};
}
static PyObject *QAccessibleTableModelChangeEvent_ModelChangeType_CppToPython_QAccessibleTableModelChangeEvent_ModelChangeType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAccessibleTableModelChangeEvent::ModelChangeType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAccessibleTableModelChangeEvent_PythonToCpp_QAccessibleTableModelChangeEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAccessibleTableModelChangeEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAccessibleTableModelChangeEvent_PythonToCpp_QAccessibleTableModelChangeEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAccessibleTableModelChangeEvent_TypeF())))
        return QAccessibleTableModelChangeEvent_PythonToCpp_QAccessibleTableModelChangeEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAccessibleTableModelChangeEvent_PTR_CppToPython_QAccessibleTableModelChangeEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAccessibleTableModelChangeEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAccessibleTableModelChangeEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAccessibleTableModelChangeEvent_SignatureStrings[] = {
    "1:PySide2.QtGui.QAccessibleTableModelChangeEvent(self,iface:PySide2.QtGui.QAccessibleInterface,changeType:PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType)",
    "0:PySide2.QtGui.QAccessibleTableModelChangeEvent(self,obj:PySide2.QtCore.QObject,changeType:PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType)",
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.firstColumn(self)->int",
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.firstRow(self)->int",
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.lastColumn(self)->int",
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.lastRow(self)->int",
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.modelChangeType(self)->PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType",
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.setFirstColumn(self,col:int)",
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.setFirstRow(self,row:int)",
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.setLastColumn(self,col:int)",
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.setLastRow(self,row:int)",
    "PySide2.QtGui.QAccessibleTableModelChangeEvent.setModelChangeType(self,changeType:PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType)",
    nullptr}; // Sentinel

void init_QAccessibleTableModelChangeEvent(PyObject *module)
{
    _Sbk_QAccessibleTableModelChangeEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAccessibleTableModelChangeEvent",
        "QAccessibleTableModelChangeEvent*",
        &Sbk_QAccessibleTableModelChangeEvent_spec,
        &Shiboken::callCppDestructor< ::QAccessibleTableModelChangeEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAccessibleTableModelChangeEvent_Type);
    InitSignatureStrings(pyType, QAccessibleTableModelChangeEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAccessibleTableModelChangeEvent_Type), Sbk_QAccessibleTableModelChangeEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAccessibleTableModelChangeEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAccessibleTableModelChangeEvent_TypeF(),
        QAccessibleTableModelChangeEvent_PythonToCpp_QAccessibleTableModelChangeEvent_PTR,
        is_QAccessibleTableModelChangeEvent_PythonToCpp_QAccessibleTableModelChangeEvent_PTR_Convertible,
        QAccessibleTableModelChangeEvent_PTR_CppToPython_QAccessibleTableModelChangeEvent);

    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTableModelChangeEvent");
    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTableModelChangeEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QAccessibleTableModelChangeEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessibleTableModelChangeEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessibleTableModelChangeEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAccessibleTableModelChangeEvent_TypeF(), &Sbk_QAccessibleTableModelChangeEvent_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ModelChangeType'.
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAccessibleTableModelChangeEvent_TypeF(),
        "ModelChangeType",
        "2:PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType",
        "QAccessibleTableModelChangeEvent::ModelChangeType");
    if (!SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX],
        Sbk_QAccessibleTableModelChangeEvent_TypeF(), "ModelReset", (long) QAccessibleTableModelChangeEvent::ModelChangeType::ModelReset))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX],
        Sbk_QAccessibleTableModelChangeEvent_TypeF(), "DataChanged", (long) QAccessibleTableModelChangeEvent::ModelChangeType::DataChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX],
        Sbk_QAccessibleTableModelChangeEvent_TypeF(), "RowsInserted", (long) QAccessibleTableModelChangeEvent::ModelChangeType::RowsInserted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX],
        Sbk_QAccessibleTableModelChangeEvent_TypeF(), "ColumnsInserted", (long) QAccessibleTableModelChangeEvent::ModelChangeType::ColumnsInserted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX],
        Sbk_QAccessibleTableModelChangeEvent_TypeF(), "RowsRemoved", (long) QAccessibleTableModelChangeEvent::ModelChangeType::RowsRemoved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX],
        Sbk_QAccessibleTableModelChangeEvent_TypeF(), "ColumnsRemoved", (long) QAccessibleTableModelChangeEvent::ModelChangeType::ColumnsRemoved))
        return;
    // Register converter for enum 'QAccessibleTableModelChangeEvent::ModelChangeType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX],
            QAccessibleTableModelChangeEvent_ModelChangeType_CppToPython_QAccessibleTableModelChangeEvent_ModelChangeType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAccessibleTableModelChangeEvent_ModelChangeType_PythonToCpp_QAccessibleTableModelChangeEvent_ModelChangeType,
            is_QAccessibleTableModelChangeEvent_ModelChangeType_PythonToCpp_QAccessibleTableModelChangeEvent_ModelChangeType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLETABLEMODELCHANGEEVENT_MODELCHANGETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAccessibleTableModelChangeEvent::ModelChangeType");
        Shiboken::Conversions::registerConverterName(converter, "ModelChangeType");
    }
    // End of 'ModelChangeType' enum.

    qRegisterMetaType< ::QAccessibleTableModelChangeEvent::ModelChangeType >("QAccessibleTableModelChangeEvent::ModelChangeType");
}
