/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QACCESSIBLEOBJECTWRAPPER_H
#define SBK_QACCESSIBLEOBJECTWRAPPER_H

#define protected public

#include <QtGui/qaccessibleobject.h>


// Extra includes
#include <qobject.h>
#include <qrect.h>
#include <QtGui/qaccessible.h>
#include <QtGui/qwindow.h>
#include <QtGui/qcolor.h>
#include <QVector>
#include <QPair>
class QAccessibleObjectWrapper : public QAccessibleObject
{
public:
    QAccessibleObjectWrapper(::QObject * object);
    ::QColor backgroundColor() const override;
    ::QAccessibleInterface * child(int index) const override;
    ::QAccessibleInterface * childAt(int x, int y) const override;
    int childCount() const override;
    ::QAccessibleInterface * focusChild() const override;
    ::QColor foregroundColor() const override;
    int indexOfChild(const ::QAccessibleInterface * arg__1) const override;
    void * interface_cast(::QAccessible::InterfaceType arg__1) override;
    bool isValid() const override;
    ::QObject * object() const override;
    ::QAccessibleInterface * parent() const override;
    ::QRect rect() const override;
    ::QVector<QPair< QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > > relations(::QFlags<QAccessible::RelationFlag> match = QAccessible::AllRelations) const override;
    ::QAccessible::Role role() const override;
    void setText(::QAccessible::Text t, const ::QString & text) override;
    ::QAccessible::State state() const override;
    ::QString text(::QAccessible::Text t) const override;
    void virtual_hook(int id, void * data) override;
    ::QWindow * window() const override;
    ~QAccessibleObjectWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[19];
};

#endif // SBK_QACCESSIBLEOBJECTWRAPPER_H

