/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qaccessible_state_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAccessible_State_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAccessible::State >()))
        return -1;

    ::QAccessible::State *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAccessible.State.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "State", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: State::State()
    // 1: State::State(QAccessible::State)
    if (numArgs == 0) {
        overloadId = 0; // State()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // State(QAccessible::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAccessible_State_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // State()
        {

            if (!PyErr_Occurred()) {
                // State()
                cptr = new ::QAccessible::State();
            }
            break;
        }
        case 1: // State(const QAccessible::State & State)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAccessible::State cppArg0_local;
            ::QAccessible::State *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // State(QAccessible::State)
                cptr = new ::QAccessible::State(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAccessible::State >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAccessible_State_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAccessible_State_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAccessible_State___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAccessible_State_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAccessible_State_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QAccessible_State___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QAccessible_State_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX]), (pyArg)))) {
                // operator==(const QAccessible::State & second)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QAccessible::State cppArg0_local;
                ::QAccessible::State *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QAccessible_State_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QAccessible_State_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

static PyObject *Sbk_QAccessible_State_get_disabled(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->disabled;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_disabled(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'disabled' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'disabled', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->disabled;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->disabled = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_selected(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->selected;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_selected(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'selected' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selected', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->selected;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selected = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_focusable(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->focusable;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_focusable(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'focusable' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'focusable', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->focusable;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->focusable = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_focused(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->focused;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_focused(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'focused' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'focused', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->focused;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->focused = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_pressed(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->pressed;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_pressed(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'pressed' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'pressed', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->pressed;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->pressed = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_checkable(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->checkable;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_checkable(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'checkable' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'checkable', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->checkable;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->checkable = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_checked(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->checked;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_checked(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'checked' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'checked', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->checked;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->checked = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_checkStateMixed(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->checkStateMixed;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_checkStateMixed(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'checkStateMixed' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'checkStateMixed', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->checkStateMixed;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->checkStateMixed = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_readOnly(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->readOnly;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_readOnly(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'readOnly' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'readOnly', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->readOnly;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->readOnly = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_hotTracked(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->hotTracked;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_hotTracked(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'hotTracked' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'hotTracked', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->hotTracked;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->hotTracked = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_defaultButton(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->defaultButton;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_defaultButton(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'defaultButton' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'defaultButton', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->defaultButton;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->defaultButton = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_expanded(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->expanded;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_expanded(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'expanded' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'expanded', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->expanded;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->expanded = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_collapsed(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->collapsed;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_collapsed(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'collapsed' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'collapsed', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->collapsed;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->collapsed = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_busy(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->busy;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_busy(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'busy' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'busy', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->busy;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->busy = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_expandable(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->expandable;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_expandable(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'expandable' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'expandable', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->expandable;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->expandable = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_marqueed(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->marqueed;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_marqueed(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'marqueed' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'marqueed', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->marqueed;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->marqueed = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_animated(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->animated;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_animated(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'animated' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'animated', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->animated;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->animated = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_invisible(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->invisible;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_invisible(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'invisible' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'invisible', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->invisible;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->invisible = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_offscreen(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->offscreen;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_offscreen(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'offscreen' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'offscreen', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->offscreen;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->offscreen = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_sizeable(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->sizeable;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_sizeable(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'sizeable' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'sizeable', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->sizeable;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->sizeable = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_movable(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->movable;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_movable(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'movable' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'movable', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->movable;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->movable = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_selfVoicing(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->selfVoicing;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_selfVoicing(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'selfVoicing' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selfVoicing', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->selfVoicing;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selfVoicing = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_selectable(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->selectable;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_selectable(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'selectable' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selectable', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->selectable;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selectable = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_linked(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->linked;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_linked(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'linked' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'linked', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->linked;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->linked = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_traversed(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->traversed;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_traversed(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'traversed' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'traversed', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->traversed;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->traversed = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_multiSelectable(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->multiSelectable;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_multiSelectable(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'multiSelectable' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'multiSelectable', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->multiSelectable;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->multiSelectable = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_extSelectable(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->extSelectable;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_extSelectable(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'extSelectable' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'extSelectable', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->extSelectable;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->extSelectable = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_passwordEdit(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->passwordEdit;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_passwordEdit(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'passwordEdit' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'passwordEdit', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->passwordEdit;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->passwordEdit = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_hasPopup(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->hasPopup;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_hasPopup(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'hasPopup' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'hasPopup', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->hasPopup;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->hasPopup = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_modal(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->modal;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_modal(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'modal' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'modal', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->modal;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->modal = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_active(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->active;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_active(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'active' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'active', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->active;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->active = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_invalid(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->invalid;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_invalid(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'invalid' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'invalid', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->invalid;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->invalid = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_editable(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->editable;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_editable(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'editable' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'editable', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->editable;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->editable = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_multiLine(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->multiLine;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_multiLine(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'multiLine' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'multiLine', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->multiLine;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->multiLine = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_selectableText(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->selectableText;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_selectableText(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'selectableText' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selectableText', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->selectableText;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selectableText = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_supportsAutoCompletion(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->supportsAutoCompletion;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_supportsAutoCompletion(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'supportsAutoCompletion' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'supportsAutoCompletion', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->supportsAutoCompletion;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->supportsAutoCompletion = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAccessible_State_get_searchEdit(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    quint64 cppOut_local = cppSelf->searchEdit;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAccessible_State_set_searchEdit(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'searchEdit' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'searchEdit', 'quint64' or convertible type expected");
        return -1;
    }

    quint64 cppOut_local = cppSelf->searchEdit;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->searchEdit = cppOut_local;

    return 0;
}

// Getters and Setters for State
static PyGetSetDef Sbk_QAccessible_State_getsetlist[] = {
    {const_cast<char *>("disabled"), Sbk_QAccessible_State_get_disabled, Sbk_QAccessible_State_set_disabled},
    {const_cast<char *>("selected"), Sbk_QAccessible_State_get_selected, Sbk_QAccessible_State_set_selected},
    {const_cast<char *>("focusable"), Sbk_QAccessible_State_get_focusable, Sbk_QAccessible_State_set_focusable},
    {const_cast<char *>("focused"), Sbk_QAccessible_State_get_focused, Sbk_QAccessible_State_set_focused},
    {const_cast<char *>("pressed"), Sbk_QAccessible_State_get_pressed, Sbk_QAccessible_State_set_pressed},
    {const_cast<char *>("checkable"), Sbk_QAccessible_State_get_checkable, Sbk_QAccessible_State_set_checkable},
    {const_cast<char *>("checked"), Sbk_QAccessible_State_get_checked, Sbk_QAccessible_State_set_checked},
    {const_cast<char *>("checkStateMixed"), Sbk_QAccessible_State_get_checkStateMixed, Sbk_QAccessible_State_set_checkStateMixed},
    {const_cast<char *>("readOnly"), Sbk_QAccessible_State_get_readOnly, Sbk_QAccessible_State_set_readOnly},
    {const_cast<char *>("hotTracked"), Sbk_QAccessible_State_get_hotTracked, Sbk_QAccessible_State_set_hotTracked},
    {const_cast<char *>("defaultButton"), Sbk_QAccessible_State_get_defaultButton, Sbk_QAccessible_State_set_defaultButton},
    {const_cast<char *>("expanded"), Sbk_QAccessible_State_get_expanded, Sbk_QAccessible_State_set_expanded},
    {const_cast<char *>("collapsed"), Sbk_QAccessible_State_get_collapsed, Sbk_QAccessible_State_set_collapsed},
    {const_cast<char *>("busy"), Sbk_QAccessible_State_get_busy, Sbk_QAccessible_State_set_busy},
    {const_cast<char *>("expandable"), Sbk_QAccessible_State_get_expandable, Sbk_QAccessible_State_set_expandable},
    {const_cast<char *>("marqueed"), Sbk_QAccessible_State_get_marqueed, Sbk_QAccessible_State_set_marqueed},
    {const_cast<char *>("animated"), Sbk_QAccessible_State_get_animated, Sbk_QAccessible_State_set_animated},
    {const_cast<char *>("invisible"), Sbk_QAccessible_State_get_invisible, Sbk_QAccessible_State_set_invisible},
    {const_cast<char *>("offscreen"), Sbk_QAccessible_State_get_offscreen, Sbk_QAccessible_State_set_offscreen},
    {const_cast<char *>("sizeable"), Sbk_QAccessible_State_get_sizeable, Sbk_QAccessible_State_set_sizeable},
    {const_cast<char *>("movable"), Sbk_QAccessible_State_get_movable, Sbk_QAccessible_State_set_movable},
    {const_cast<char *>("selfVoicing"), Sbk_QAccessible_State_get_selfVoicing, Sbk_QAccessible_State_set_selfVoicing},
    {const_cast<char *>("selectable"), Sbk_QAccessible_State_get_selectable, Sbk_QAccessible_State_set_selectable},
    {const_cast<char *>("linked"), Sbk_QAccessible_State_get_linked, Sbk_QAccessible_State_set_linked},
    {const_cast<char *>("traversed"), Sbk_QAccessible_State_get_traversed, Sbk_QAccessible_State_set_traversed},
    {const_cast<char *>("multiSelectable"), Sbk_QAccessible_State_get_multiSelectable, Sbk_QAccessible_State_set_multiSelectable},
    {const_cast<char *>("extSelectable"), Sbk_QAccessible_State_get_extSelectable, Sbk_QAccessible_State_set_extSelectable},
    {const_cast<char *>("passwordEdit"), Sbk_QAccessible_State_get_passwordEdit, Sbk_QAccessible_State_set_passwordEdit},
    {const_cast<char *>("hasPopup"), Sbk_QAccessible_State_get_hasPopup, Sbk_QAccessible_State_set_hasPopup},
    {const_cast<char *>("modal"), Sbk_QAccessible_State_get_modal, Sbk_QAccessible_State_set_modal},
    {const_cast<char *>("active"), Sbk_QAccessible_State_get_active, Sbk_QAccessible_State_set_active},
    {const_cast<char *>("invalid"), Sbk_QAccessible_State_get_invalid, Sbk_QAccessible_State_set_invalid},
    {const_cast<char *>("editable"), Sbk_QAccessible_State_get_editable, Sbk_QAccessible_State_set_editable},
    {const_cast<char *>("multiLine"), Sbk_QAccessible_State_get_multiLine, Sbk_QAccessible_State_set_multiLine},
    {const_cast<char *>("selectableText"), Sbk_QAccessible_State_get_selectableText, Sbk_QAccessible_State_set_selectableText},
    {const_cast<char *>("supportsAutoCompletion"), Sbk_QAccessible_State_get_supportsAutoCompletion, Sbk_QAccessible_State_set_supportsAutoCompletion},
    {const_cast<char *>("searchEdit"), Sbk_QAccessible_State_get_searchEdit, Sbk_QAccessible_State_set_searchEdit},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QAccessible_State_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAccessible_State_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAccessible_State_Type = nullptr;
static SbkObjectType *Sbk_QAccessible_State_TypeF(void)
{
    return _Sbk_QAccessible_State_Type;
}

static PyType_Slot Sbk_QAccessible_State_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAccessible_State_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAccessible_State_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QAccessible_State_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAccessible_State_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QAccessible_State_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAccessible_State_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAccessible_State_spec = {
    "2:PySide2.QtGui.QAccessible.State",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAccessible_State_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void State_PythonToCpp_State_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAccessible_State_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_State_PythonToCpp_State_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAccessible_State_TypeF())))
        return State_PythonToCpp_State_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *State_PTR_CppToPython_State(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAccessible::State *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAccessible_State_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *State_COPY_CppToPython_State(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QAccessible_State_TypeF(), new ::QAccessible::State(*reinterpret_cast<const ::QAccessible::State *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void State_PythonToCpp_State_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAccessible::State *>(cppOut) = *reinterpret_cast< ::QAccessible::State *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_State_PythonToCpp_State_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAccessible_State_TypeF())))
        return State_PythonToCpp_State_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAccessible_State_SignatureStrings[] = {
    "1:PySide2.QtGui.QAccessible.State(self)",
    "0:PySide2.QtGui.QAccessible.State(self,State:PySide2.QtGui.QAccessible.State)",
    "PySide2.QtGui.QAccessible.State.__copy__()",
    nullptr}; // Sentinel

void init_QAccessible_State(PyObject *enclosingClass)
{
    _Sbk_QAccessible_State_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "State",
        "QAccessible::State",
        &Sbk_QAccessible_State_spec,
        &Shiboken::callCppDestructor< ::QAccessible::State >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAccessible_State_Type);
    InitSignatureStrings(pyType, QAccessible_State_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAccessible_State_Type), Sbk_QAccessible_State_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_STATE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAccessible_State_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAccessible_State_TypeF(),
        State_PythonToCpp_State_PTR,
        is_State_PythonToCpp_State_PTR_Convertible,
        State_PTR_CppToPython_State,
        State_COPY_CppToPython_State);

    Shiboken::Conversions::registerConverterName(converter, "QAccessible::State");
    Shiboken::Conversions::registerConverterName(converter, "QAccessible::State*");
    Shiboken::Conversions::registerConverterName(converter, "QAccessible::State&");
    Shiboken::Conversions::registerConverterName(converter, "State");
    Shiboken::Conversions::registerConverterName(converter, "State*");
    Shiboken::Conversions::registerConverterName(converter, "State&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAccessible::State).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        State_PythonToCpp_State_COPY,
        is_State_PythonToCpp_State_COPY_Convertible);

    qRegisterMetaType< ::QAccessible::State >("State");
    qRegisterMetaType< ::QAccessible::State >("QAccessible::State");
}
