/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qabstracttextdocumentlayout_paintcontext_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractTextDocumentLayout_PaintContext_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractTextDocumentLayout::PaintContext >()))
        return -1;

    ::QAbstractTextDocumentLayout::PaintContext *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "PaintContext", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: PaintContext::PaintContext()
    // 1: PaintContext::PaintContext(QAbstractTextDocumentLayout::PaintContext)
    if (numArgs == 0) {
        overloadId = 0; // PaintContext()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // PaintContext(QAbstractTextDocumentLayout::PaintContext)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractTextDocumentLayout_PaintContext_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // PaintContext()
        {

            if (!PyErr_Occurred()) {
                // PaintContext()
                cptr = new ::QAbstractTextDocumentLayout::PaintContext();
            }
            break;
        }
        case 1: // PaintContext(const QAbstractTextDocumentLayout::PaintContext & PaintContext)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractTextDocumentLayout::PaintContext cppArg0_local;
            ::QAbstractTextDocumentLayout::PaintContext *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // PaintContext(QAbstractTextDocumentLayout::PaintContext)
                cptr = new ::QAbstractTextDocumentLayout::PaintContext(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractTextDocumentLayout::PaintContext >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAbstractTextDocumentLayout_PaintContext_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAbstractTextDocumentLayout_PaintContext_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAbstractTextDocumentLayout_PaintContext___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAbstractTextDocumentLayout::PaintContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAbstractTextDocumentLayout_PaintContext_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractTextDocumentLayout_PaintContext_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QAbstractTextDocumentLayout_PaintContext___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QAbstractTextDocumentLayout_PaintContext_get_cursorPosition(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAbstractTextDocumentLayout::PaintContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->cursorPosition;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAbstractTextDocumentLayout_PaintContext_set_cursorPosition(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAbstractTextDocumentLayout::PaintContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'cursorPosition' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'cursorPosition', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->cursorPosition;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->cursorPosition = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAbstractTextDocumentLayout_PaintContext_get_palette(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAbstractTextDocumentLayout::PaintContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->palette)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->palette))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->palette)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), &(cppSelf->palette), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QAbstractTextDocumentLayout_PaintContext_set_palette(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAbstractTextDocumentLayout::PaintContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'palette' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'palette', 'QPalette' or convertible type expected");
        return -1;
    }

    ::QPalette& cppOut_ptr = cppSelf->palette;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QAbstractTextDocumentLayout_PaintContext_get_clip(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAbstractTextDocumentLayout::PaintContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->clip)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->clip))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->clip)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &(cppSelf->clip), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QAbstractTextDocumentLayout_PaintContext_set_clip(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAbstractTextDocumentLayout::PaintContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'clip' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'clip', 'QRectF' or convertible type expected");
        return -1;
    }

    ::QRectF& cppOut_ptr = cppSelf->clip;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for PaintContext
static PyGetSetDef Sbk_QAbstractTextDocumentLayout_PaintContext_getsetlist[] = {
    {const_cast<char *>("cursorPosition"), Sbk_QAbstractTextDocumentLayout_PaintContext_get_cursorPosition, Sbk_QAbstractTextDocumentLayout_PaintContext_set_cursorPosition},
    {const_cast<char *>("palette"), Sbk_QAbstractTextDocumentLayout_PaintContext_get_palette, Sbk_QAbstractTextDocumentLayout_PaintContext_set_palette},
    {const_cast<char *>("clip"), Sbk_QAbstractTextDocumentLayout_PaintContext_get_clip, Sbk_QAbstractTextDocumentLayout_PaintContext_set_clip},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QAbstractTextDocumentLayout_PaintContext_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractTextDocumentLayout_PaintContext_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractTextDocumentLayout_PaintContext_Type = nullptr;
static SbkObjectType *Sbk_QAbstractTextDocumentLayout_PaintContext_TypeF(void)
{
    return _Sbk_QAbstractTextDocumentLayout_PaintContext_Type;
}

static PyType_Slot Sbk_QAbstractTextDocumentLayout_PaintContext_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractTextDocumentLayout_PaintContext_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractTextDocumentLayout_PaintContext_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractTextDocumentLayout_PaintContext_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QAbstractTextDocumentLayout_PaintContext_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractTextDocumentLayout_PaintContext_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractTextDocumentLayout_PaintContext_spec = {
    "2:PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractTextDocumentLayout_PaintContext_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PaintContext_PythonToCpp_PaintContext_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractTextDocumentLayout_PaintContext_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PaintContext_PythonToCpp_PaintContext_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractTextDocumentLayout_PaintContext_TypeF())))
        return PaintContext_PythonToCpp_PaintContext_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PaintContext_PTR_CppToPython_PaintContext(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAbstractTextDocumentLayout::PaintContext *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAbstractTextDocumentLayout_PaintContext_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *PaintContext_COPY_CppToPython_PaintContext(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QAbstractTextDocumentLayout_PaintContext_TypeF(), new ::QAbstractTextDocumentLayout::PaintContext(*reinterpret_cast<const ::QAbstractTextDocumentLayout::PaintContext *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void PaintContext_PythonToCpp_PaintContext_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractTextDocumentLayout::PaintContext *>(cppOut) = *reinterpret_cast< ::QAbstractTextDocumentLayout::PaintContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_PaintContext_PythonToCpp_PaintContext_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractTextDocumentLayout_PaintContext_TypeF())))
        return PaintContext_PythonToCpp_PaintContext_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractTextDocumentLayout_PaintContext_SignatureStrings[] = {
    "1:PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext(self)",
    "0:PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext(self,PaintContext:PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext)",
    "PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext.__copy__()",
    nullptr}; // Sentinel

void init_QAbstractTextDocumentLayout_PaintContext(PyObject *enclosingClass)
{
    _Sbk_QAbstractTextDocumentLayout_PaintContext_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "PaintContext",
        "QAbstractTextDocumentLayout::PaintContext",
        &Sbk_QAbstractTextDocumentLayout_PaintContext_spec,
        &Shiboken::callCppDestructor< ::QAbstractTextDocumentLayout::PaintContext >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractTextDocumentLayout_PaintContext_Type);
    InitSignatureStrings(pyType, QAbstractTextDocumentLayout_PaintContext_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractTextDocumentLayout_PaintContext_Type), Sbk_QAbstractTextDocumentLayout_PaintContext_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractTextDocumentLayout_PaintContext_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractTextDocumentLayout_PaintContext_TypeF(),
        PaintContext_PythonToCpp_PaintContext_PTR,
        is_PaintContext_PythonToCpp_PaintContext_PTR_Convertible,
        PaintContext_PTR_CppToPython_PaintContext,
        PaintContext_COPY_CppToPython_PaintContext);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractTextDocumentLayout::PaintContext");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractTextDocumentLayout::PaintContext*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractTextDocumentLayout::PaintContext&");
    Shiboken::Conversions::registerConverterName(converter, "PaintContext");
    Shiboken::Conversions::registerConverterName(converter, "PaintContext*");
    Shiboken::Conversions::registerConverterName(converter, "PaintContext&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractTextDocumentLayout::PaintContext).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PaintContext_PythonToCpp_PaintContext_COPY,
        is_PaintContext_PythonToCpp_PaintContext_COPY_Convertible);

    qRegisterMetaType< ::QAbstractTextDocumentLayout::PaintContext >("PaintContext");
    qRegisterMetaType< ::QAbstractTextDocumentLayout::PaintContext >("QAbstractTextDocumentLayout::PaintContext");
}
