/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_qcustom3dvolume_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QCustom3DVolumeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QCustom3DVolumeWrapper::QCustom3DVolumeWrapper(::QObject * parent) : QtDataVisualization::QCustom3DVolume(parent)
{
    resetPyMethodCache();
    // ... middle
}

QCustom3DVolumeWrapper::QCustom3DVolumeWrapper(const ::QVector3D & position, const ::QVector3D & scaling, const ::QQuaternion & rotation, int textureWidth, int textureHeight, int textureDepth, ::QVector<uchar > * textureData, ::QImage::Format textureFormat, const ::QVector<unsigned int > & colorTable, ::QObject * parent) : QtDataVisualization::QCustom3DVolume(position, scaling, rotation, textureWidth, textureHeight, textureDepth, textureData, textureFormat, colorTable, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QCustom3DVolumeWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCustom3DVolumeWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QCustom3DVolumeWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCustom3DVolumeWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QCustom3DVolumeWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCustom3DVolume.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QCustom3DVolumeWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCustom3DVolume.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QCustom3DVolumeWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QCustom3DVolumeWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtDataVisualization::QCustom3DVolume::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QCustom3DVolumeWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtDataVisualization::QCustom3DVolume::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QCustom3DVolumeWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QCustom3DVolumeWrapper *>(this));
        return QtDataVisualization::QCustom3DVolume::qt_metacast(_clname);
}

QCustom3DVolumeWrapper::~QCustom3DVolumeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtDataVisualization_QCustom3DVolume_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtDataVisualization::QCustom3DVolume >()))
        return -1;

    ::QCustom3DVolumeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3 || numArgs == 4 || numArgs == 5 || numArgs == 6 || numArgs == 7 || numArgs == 8)
        goto Sbk_QtDataVisualization_QCustom3DVolume_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOOOOOO:QCustom3DVolume", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return -1;


    // Overloaded function decisor
    // 0: QCustom3DVolume::QCustom3DVolume(QObject*)
    // 1: QCustom3DVolume::QCustom3DVolume(QVector3D,QVector3D,QQuaternion,int,int,int,QVector<uchar>*,QImage::Format,QVector<uint>,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QCustom3DVolume(QObject*)
    } else if (numArgs >= 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UCHAR_IDX], (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UNSIGNEDINT_IDX], (pyArgs[8])))) {
        if (numArgs == 9) {
            overloadId = 1; // QCustom3DVolume(QVector3D,QVector3D,QQuaternion,int,int,int,QVector<uchar>*,QImage::Format,QVector<uint>,QObject*)
        } else if (numArgs >= 10
            && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[9])))) {
            overloadId = 1; // QCustom3DVolume(QVector3D,QVector3D,QQuaternion,int,int,int,QVector<uchar>*,QImage::Format,QVector<uint>,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QCustom3DVolume(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolume_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCustom3DVolume(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QCustom3DVolume_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QtDataVisualization_QCustom3DVolume_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCustom3DVolume(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QCustom3DVolumeWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QCustom3DVolumeWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QCustom3DVolume(const QVector3D & position, const QVector3D & scaling, const QQuaternion & rotation, int textureWidth, int textureHeight, int textureDepth, QVector<uchar > * textureData, QImage::Format textureFormat, const QVector<unsigned int > & colorTable, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[9]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtDataVisualization_QCustom3DVolume_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[9] = value;
                        if (!(pythonToCpp[9] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[9]))))
                            goto Sbk_QtDataVisualization_QCustom3DVolume_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QVector3D cppArg0_local;
            ::QVector3D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QVector3D cppArg1_local;
            ::QVector3D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QQuaternion cppArg2_local;
            ::QQuaternion *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QQUATERNION_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QVector<uchar > *cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QImage::Format cppArg7{QImage::Format_Invalid};
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::QVector<unsigned int > cppArg8;
            pythonToCpp[8](pyArgs[8], &cppArg8);
            if (!Shiboken::Object::isValid(pyArgs[9]))
                return -1;
            ::QObject *cppArg9 = nullptr;
            if (pythonToCpp[9]) pythonToCpp[9](pyArgs[9], &cppArg9);

            if (!PyErr_Occurred()) {
                // QCustom3DVolume(QVector3D,QVector3D,QQuaternion,int,int,int,QVector<uchar>*,QImage::Format,QVector<uint>,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QCustom3DVolumeWrapper(*cppArg0, *cppArg1, *cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QCustom3DVolumeWrapper(*cppArg0, *cppArg1, *cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
                }

                Shiboken::Object::setParent(pyArgs[9], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtDataVisualization::QCustom3DVolume >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtDataVisualization_QCustom3DVolume_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QtDataVisualization_QCustom3DVolume_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QtDataVisualization_QCustom3DVolume_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_alphaMultiplier(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.alphaMultiplier";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alphaMultiplier()const
            float cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->alphaMultiplier();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_colorTable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.colorTable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorTable()const
            QVector<unsigned int > cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->colorTable();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UNSIGNEDINT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_createTextureData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.createTextureData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::createTextureData(QVector<QImage*>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QIMAGEPTR_IDX], (pyArg)))) {
        overloadId = 0; // createTextureData(QVector<QImage*>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_createTextureData_TypeError;

    // Call function/method
    {
        ::QVector<QImage* > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // createTextureData(QVector<QImage*>)
            QVector<uchar > * cppResult = cppSelf->createTextureData(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_createTextureData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_drawSliceFrames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.drawSliceFrames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // drawSliceFrames()const
            bool cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->drawSliceFrames();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_drawSlices(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.drawSlices";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // drawSlices()const
            bool cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->drawSlices();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_preserveOpacity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.preserveOpacity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // preserveOpacity()const
            bool cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->preserveOpacity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_renderSlice(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.renderSlice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "renderSlice", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCustom3DVolume::renderSlice(Qt::Axis,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_AXIS_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // renderSlice(Qt::Axis,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_renderSlice_TypeError;

    // Call function/method
    {
        ::Qt::Axis cppArg0{Qt::XAxis};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // renderSlice(Qt::Axis,int)
            QImage cppResult = cppSelf->renderSlice(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_renderSlice_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setAlphaMultiplier(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setAlphaMultiplier";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setAlphaMultiplier(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setAlphaMultiplier(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setAlphaMultiplier_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlphaMultiplier(float)
            cppSelf->setAlphaMultiplier(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setAlphaMultiplier_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setColorTable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setColorTable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setColorTable(QVector<uint>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UNSIGNEDINT_IDX], (pyArg)))) {
        overloadId = 0; // setColorTable(QVector<uint>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setColorTable_TypeError;

    // Call function/method
    {
        ::QVector<unsigned int > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColorTable(QVector<uint>)
            cppSelf->setColorTable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setColorTable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setDrawSliceFrames(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setDrawSliceFrames";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setDrawSliceFrames(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDrawSliceFrames(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setDrawSliceFrames_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDrawSliceFrames(bool)
            cppSelf->setDrawSliceFrames(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setDrawSliceFrames_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setDrawSlices(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setDrawSlices";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setDrawSlices(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDrawSlices(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setDrawSlices_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDrawSlices(bool)
            cppSelf->setDrawSlices(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setDrawSlices_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setPreserveOpacity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setPreserveOpacity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setPreserveOpacity(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPreserveOpacity(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setPreserveOpacity_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPreserveOpacity(bool)
            cppSelf->setPreserveOpacity(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setPreserveOpacity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceFrameColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setSliceFrameColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setSliceFrameColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSliceFrameColor(QColor)
            cppSelf->setSliceFrameColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameGaps(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceFrameGaps";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setSliceFrameGaps(QVector3D)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArg)))) {
        overloadId = 0; // setSliceFrameGaps(QVector3D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameGaps_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector3D cppArg0_local;
        ::QVector3D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSliceFrameGaps(QVector3D)
            cppSelf->setSliceFrameGaps(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameGaps_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameThicknesses(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceFrameThicknesses";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setSliceFrameThicknesses(QVector3D)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArg)))) {
        overloadId = 0; // setSliceFrameThicknesses(QVector3D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameThicknesses_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector3D cppArg0_local;
        ::QVector3D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSliceFrameThicknesses(QVector3D)
            cppSelf->setSliceFrameThicknesses(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameThicknesses_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameWidths(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceFrameWidths";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setSliceFrameWidths(QVector3D)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArg)))) {
        overloadId = 0; // setSliceFrameWidths(QVector3D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameWidths_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector3D cppArg0_local;
        ::QVector3D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSliceFrameWidths(QVector3D)
            cppSelf->setSliceFrameWidths(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameWidths_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexX(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceIndexX";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setSliceIndexX(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSliceIndexX(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexX_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSliceIndexX(int)
            cppSelf->setSliceIndexX(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexX_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexY(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceIndexY";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setSliceIndexY(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSliceIndexY(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexY_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSliceIndexY(int)
            cppSelf->setSliceIndexY(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexY_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexZ(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceIndexZ";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setSliceIndexZ(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSliceIndexZ(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexZ_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSliceIndexZ(int)
            cppSelf->setSliceIndexZ(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexZ_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndices(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceIndices";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setSliceIndices", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QCustom3DVolume::setSliceIndices(int,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // setSliceIndices(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndices_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setSliceIndices(int,int,int)
            cppSelf->setSliceIndices(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndices_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSubTextureData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSubTextureData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setSubTextureData", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QCustom3DVolume::setSubTextureData(Qt::Axis,int,QImage)
    // 1: QCustom3DVolume::setSubTextureData(Qt::Axis,int,const uchar*)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_AXIS_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 3
            && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[2])))) {
            overloadId = 1; // setSubTextureData(Qt::Axis,int,const uchar*)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[2])))) {
            overloadId = 0; // setSubTextureData(Qt::Axis,int,QImage)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSubTextureData_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setSubTextureData(Qt::Axis axis, int index, const QImage & image)
        {
            ::Qt::Axis cppArg0{Qt::XAxis};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QImage cppArg2_local;
            ::QImage *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // setSubTextureData(Qt::Axis,int,QImage)
                cppSelf->setSubTextureData(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
        case 1: // setSubTextureData(Qt::Axis axis, int index, const uchar * data)
        {
            ::Qt::Axis cppArg0{Qt::XAxis};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            uchar *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setSubTextureData(Qt::Axis,int,const uchar*)
                cppSelf->setSubTextureData(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSubTextureData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setTextureData(QVector<uchar>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UCHAR_IDX], (pyArg)))) {
        overloadId = 0; // setTextureData(QVector<uchar>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureData_TypeError;

    // Call function/method
    {
        ::QVector<uchar > cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // setTextureData(QVector<uchar>)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtdatavisualization.cpp (qcustom3dvolume-settexturedata)]
            using VectorType = decltype(cppArg0);
            cppSelf->setTextureData(new VectorType(cppArg0));
            // END of custom code block [file: ../glue/qtdatavisualization.cpp (qcustom3dvolume-settexturedata)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureDepth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureDepth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setTextureDepth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTextureDepth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureDepth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextureDepth(int)
            cppSelf->setTextureDepth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureDepth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureDimensions(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureDimensions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setTextureDimensions", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QCustom3DVolume::setTextureDimensions(int,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // setTextureDimensions(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureDimensions_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setTextureDimensions(int,int,int)
            cppSelf->setTextureDimensions(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureDimensions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setTextureFormat(QImage::Format)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTextureFormat(QImage::Format)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureFormat_TypeError;

    // Call function/method
    {
        ::QImage::Format cppArg0{QImage::Format_Invalid};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextureFormat(QImage::Format)
            cppSelf->setTextureFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setTextureHeight(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTextureHeight(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureHeight_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextureHeight(int)
            cppSelf->setTextureHeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setTextureWidth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTextureWidth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextureWidth(int)
            cppSelf->setTextureWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_setUseHighDefShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setUseHighDefShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCustom3DVolume::setUseHighDefShader(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setUseHighDefShader(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QCustom3DVolumeFunc_setUseHighDefShader_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUseHighDefShader(bool)
            cppSelf->setUseHighDefShader(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QCustom3DVolumeFunc_setUseHighDefShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceFrameColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceFrameColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sliceFrameColor()const
            QColor cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->sliceFrameColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceFrameGaps(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceFrameGaps";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sliceFrameGaps()const
            QVector3D cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->sliceFrameGaps();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceFrameThicknesses(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceFrameThicknesses";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sliceFrameThicknesses()const
            QVector3D cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->sliceFrameThicknesses();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceFrameWidths(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceFrameWidths";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sliceFrameWidths()const
            QVector3D cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->sliceFrameWidths();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceIndexX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceIndexX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sliceIndexX()const
            int cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->sliceIndexX();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceIndexY(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceIndexY";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sliceIndexY()const
            int cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->sliceIndexY();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceIndexZ(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceIndexZ";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sliceIndexZ()const
            int cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->sliceIndexZ();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureData()const
            QVector<uchar > * cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->textureData();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureDataWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureDataWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureDataWidth()const
            int cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->textureDataWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureDepth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureDepth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureDepth()const
            int cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->textureDepth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureFormat()const
            QImage::Format cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->textureFormat();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureHeight()const
            int cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->textureHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureWidth()const
            int cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->textureWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QCustom3DVolumeFunc_useHighDefShader(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.useHighDefShader";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // useHighDefShader()const
            bool cppResult = const_cast<const ::QtDataVisualization::QCustom3DVolume *>(cppSelf)->useHighDefShader();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtDataVisualization_QCustom3DVolume_PropertyStrings[] = {
    "alphaMultiplier::",
    "colorTable::",
    "drawSliceFrames::",
    "drawSlices::",
    "preserveOpacity::",
    "sliceFrameColor::",
    "sliceFrameGaps::",
    "sliceFrameThicknesses::",
    "sliceFrameWidths::",
    "sliceIndexX::",
    "sliceIndexY::",
    "sliceIndexZ::",
    "textureData::",
    "textureDepth::",
    "textureHeight::",
    "textureWidth::",
    "useHighDefShader::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_QCustom3DVolume_methods[] = {
    {"alphaMultiplier", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_alphaMultiplier), METH_NOARGS},
    {"colorTable", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_colorTable), METH_NOARGS},
    {"createTextureData", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_createTextureData), METH_O},
    {"drawSliceFrames", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_drawSliceFrames), METH_NOARGS},
    {"drawSlices", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_drawSlices), METH_NOARGS},
    {"preserveOpacity", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_preserveOpacity), METH_NOARGS},
    {"renderSlice", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_renderSlice), METH_VARARGS},
    {"setAlphaMultiplier", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setAlphaMultiplier), METH_O},
    {"setColorTable", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setColorTable), METH_O},
    {"setDrawSliceFrames", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setDrawSliceFrames), METH_O},
    {"setDrawSlices", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setDrawSlices), METH_O},
    {"setPreserveOpacity", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setPreserveOpacity), METH_O},
    {"setSliceFrameColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameColor), METH_O},
    {"setSliceFrameGaps", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameGaps), METH_O},
    {"setSliceFrameThicknesses", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameThicknesses), METH_O},
    {"setSliceFrameWidths", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceFrameWidths), METH_O},
    {"setSliceIndexX", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexX), METH_O},
    {"setSliceIndexY", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexY), METH_O},
    {"setSliceIndexZ", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndexZ), METH_O},
    {"setSliceIndices", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSliceIndices), METH_VARARGS},
    {"setSubTextureData", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setSubTextureData), METH_VARARGS},
    {"setTextureData", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureData), METH_O},
    {"setTextureDepth", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureDepth), METH_O},
    {"setTextureDimensions", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureDimensions), METH_VARARGS},
    {"setTextureFormat", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureFormat), METH_O},
    {"setTextureHeight", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureHeight), METH_O},
    {"setTextureWidth", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setTextureWidth), METH_O},
    {"setUseHighDefShader", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_setUseHighDefShader), METH_O},
    {"sliceFrameColor", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceFrameColor), METH_NOARGS},
    {"sliceFrameGaps", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceFrameGaps), METH_NOARGS},
    {"sliceFrameThicknesses", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceFrameThicknesses), METH_NOARGS},
    {"sliceFrameWidths", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceFrameWidths), METH_NOARGS},
    {"sliceIndexX", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceIndexX), METH_NOARGS},
    {"sliceIndexY", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceIndexY), METH_NOARGS},
    {"sliceIndexZ", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_sliceIndexZ), METH_NOARGS},
    {"textureData", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureData), METH_NOARGS},
    {"textureDataWidth", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureDataWidth), METH_NOARGS},
    {"textureDepth", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureDepth), METH_NOARGS},
    {"textureFormat", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureFormat), METH_NOARGS},
    {"textureHeight", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureHeight), METH_NOARGS},
    {"textureWidth", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_textureWidth), METH_NOARGS},
    {"useHighDefShader", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QCustom3DVolumeFunc_useHighDefShader), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtDataVisualization_QCustom3DVolume_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtDataVisualization::QCustom3DVolume *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QCustom3DVolumeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtDataVisualization_QCustom3DVolume_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_QCustom3DVolume_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_QCustom3DVolume_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_QCustom3DVolume_TypeF(void)
{
    return _Sbk_QtDataVisualization_QCustom3DVolume_Type;
}

static PyType_Slot Sbk_QtDataVisualization_QCustom3DVolume_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QCustom3DVolume_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QCustom3DVolume_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_QCustom3DVolume_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_QCustom3DVolume_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtDataVisualization_QCustom3DVolume_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_QCustom3DVolume_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_QCustom3DVolume_slots
};

} //extern "C"

static void *Sbk_QtDataVisualization_QCustom3DVolume_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtDataVisualization::QCustom3DVolume *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCustom3DVolume_PythonToCpp_QCustom3DVolume_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_QCustom3DVolume_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCustom3DVolume_PythonToCpp_QCustom3DVolume_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QCustom3DVolume_TypeF())))
        return QCustom3DVolume_PythonToCpp_QCustom3DVolume_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCustom3DVolume_PTR_CppToPython_QCustom3DVolume(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtDataVisualization::QCustom3DVolume *>(const_cast<void *>(cppIn)), Sbk_QtDataVisualization_QCustom3DVolume_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_QCustom3DVolume_SignatureStrings[] = {
    "1:PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume(self,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume(self,position:PySide2.QtGui.QVector3D,scaling:PySide2.QtGui.QVector3D,rotation:PySide2.QtGui.QQuaternion,textureWidth:int,textureHeight:int,textureDepth:int,textureData:QVector[uchar],textureFormat:PySide2.QtGui.QImage.Format,colorTable:QVector[unsigned int],parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.alphaMultiplier(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.colorTable(self)->QVector[unsigned int]",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.createTextureData(self,images:QVector[PySide2.QtGui.QImage])->QVector[uchar]",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.drawSliceFrames(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.drawSlices(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.preserveOpacity(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.renderSlice(self,axis:PySide2.QtCore.Qt.Axis,index:int)->PySide2.QtGui.QImage",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setAlphaMultiplier(self,mult:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setColorTable(self,colors:QVector[unsigned int])",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setDrawSliceFrames(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setDrawSlices(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setPreserveOpacity(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceFrameColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceFrameGaps(self,values:PySide2.QtGui.QVector3D)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceFrameThicknesses(self,values:PySide2.QtGui.QVector3D)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceFrameWidths(self,values:PySide2.QtGui.QVector3D)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceIndexX(self,value:int)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceIndexY(self,value:int)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceIndexZ(self,value:int)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSliceIndices(self,x:int,y:int,z:int)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSubTextureData(self,axis:PySide2.QtCore.Qt.Axis,index:int,image:PySide2.QtGui.QImage)",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setSubTextureData(self,axis:PySide2.QtCore.Qt.Axis,index:int,data:uchar*)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureData(self,arg__1:QVector[uchar])",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureDepth(self,value:int)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureDimensions(self,width:int,height:int,depth:int)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureFormat(self,format:PySide2.QtGui.QImage.Format)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureHeight(self,value:int)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setTextureWidth(self,value:int)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.setUseHighDefShader(self,enable:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceFrameColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceFrameGaps(self)->PySide2.QtGui.QVector3D",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceFrameThicknesses(self)->PySide2.QtGui.QVector3D",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceFrameWidths(self)->PySide2.QtGui.QVector3D",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceIndexX(self)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceIndexY(self)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.sliceIndexZ(self)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureData(self)->QVector[uchar]",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureDataWidth(self)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureDepth(self)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureFormat(self)->PySide2.QtGui.QImage.Format",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureHeight(self)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.textureWidth(self)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QCustom3DVolume.useHighDefShader(self)->bool",
    nullptr}; // Sentinel

void init_QtDataVisualization_QCustom3DVolume(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_QCustom3DVolume_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QCustom3DVolume",
        "QtDataVisualization::QCustom3DVolume*",
        &Sbk_QtDataVisualization_QCustom3DVolume_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::QCustom3DVolume >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DITEM_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QCustom3DVolume_Type);
    InitSignatureStrings(pyType, QtDataVisualization_QCustom3DVolume_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QCustom3DVolume_Type), Sbk_QtDataVisualization_QCustom3DVolume_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DVOLUME_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QCustom3DVolume_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_QCustom3DVolume_TypeF(),
        QCustom3DVolume_PythonToCpp_QCustom3DVolume_PTR,
        is_QCustom3DVolume_PythonToCpp_QCustom3DVolume_PTR_Convertible,
        QCustom3DVolume_PTR_CppToPython_QCustom3DVolume);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QCustom3DVolume");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QCustom3DVolume*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QCustom3DVolume&");
    Shiboken::Conversions::registerConverterName(converter, "QCustom3DVolume");
    Shiboken::Conversions::registerConverterName(converter, "QCustom3DVolume*");
    Shiboken::Conversions::registerConverterName(converter, "QCustom3DVolume&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::QCustom3DVolume).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCustom3DVolumeWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtDataVisualization_QCustom3DVolume_TypeF(), &Sbk_QtDataVisualization_QCustom3DVolume_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QtDataVisualization_QCustom3DVolume_TypeF(), &::QtDataVisualization::QCustom3DVolume::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtDataVisualization_QCustom3DVolume_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtDataVisualization_QCustom3DVolume_TypeF(), &::QtDataVisualization::QCustom3DVolume::staticMetaObject, sizeof(QCustom3DVolumeWrapper));
}
