/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_qbardataproxy_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QBarDataProxyWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QBarDataProxyWrapper::QBarDataProxyWrapper(::QObject * parent) : QtDataVisualization::QBarDataProxy(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QBarDataProxyWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBarDataProxyWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QBarDataProxyWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBarDataProxyWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QBarDataProxyWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBarDataProxy.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QBarDataProxyWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBarDataProxy.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QBarDataProxyWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QBarDataProxyWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtDataVisualization::QBarDataProxy::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QBarDataProxyWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtDataVisualization::QBarDataProxy::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QBarDataProxyWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QBarDataProxyWrapper *>(this));
        return QtDataVisualization::QBarDataProxy::qt_metacast(_clname);
}

QBarDataProxyWrapper::~QBarDataProxyWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtDataVisualization_QBarDataProxy_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtDataVisualization::QBarDataProxy >()))
        return -1;

    ::QBarDataProxyWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QBarDataProxy", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QBarDataProxy::QBarDataProxy(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QBarDataProxy(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QBarDataProxy(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxy_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QtDataVisualization_QBarDataProxy_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QtDataVisualization_QBarDataProxy_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QBarDataProxy(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QBarDataProxyWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QBarDataProxyWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtDataVisualization::QBarDataProxy >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtDataVisualization_QBarDataProxy_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QtDataVisualization_QBarDataProxy_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QtDataVisualization_QBarDataProxy_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_addRow(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.addRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addRow", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBarDataProxy::addRow(QVector<QtDataVisualization::QBarDataItem>)
    // 1: QBarDataProxy::addRow(QVector<QtDataVisualization::QBarDataItem>,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QBARDATAITEM_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addRow(QVector<QtDataVisualization::QBarDataItem>)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // addRow(QVector<QtDataVisualization::QBarDataItem>,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_addRow_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addRow(QVector<QtDataVisualization::QBarDataItem > arg__1)
        {
            ::QVector<QtDataVisualization::QBarDataItem > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // addRow(QVector<QtDataVisualization::QBarDataItem>)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-addrow)]
                using VectorType = decltype(cppArg0);
                int cppResult = cppSelf->addRow(new VectorType(cppArg0));
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
                // END of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-addrow)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // addRow(QVector<QtDataVisualization::QBarDataItem > arg__1, QString arg__2)
        {
            ::QVector<QtDataVisualization::QBarDataItem > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // addRow(QVector<QtDataVisualization::QBarDataItem>,QString)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-addrow-string)]
                using VectorType = decltype(cppArg0);
                int cppResult = cppSelf->addRow(new VectorType(cppArg0), cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
                // END of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-addrow-string)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QBarDataProxyFunc_addRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_addRows(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.addRows";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addRows", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBarDataProxy::addRows(QtDataVisualization::QBarDataArray)
    // 1: QBarDataProxy::addRows(QtDataVisualization::QBarDataArray,QStringList)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QBARDATAARRAY_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addRows(QtDataVisualization::QBarDataArray)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
            overloadId = 1; // addRows(QtDataVisualization::QBarDataArray,QStringList)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_addRows_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addRows(const QtDataVisualization::QBarDataArray & rows)
        {
            ::QtDataVisualization::QBarDataArray cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // addRows(QtDataVisualization::QBarDataArray)
                int cppResult = cppSelf->addRows(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // addRows(const QtDataVisualization::QBarDataArray & rows, const QStringList & labels)
        {
            ::QtDataVisualization::QBarDataArray cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addRows(QtDataVisualization::QBarDataArray,QStringList)
                int cppResult = cppSelf->addRows(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QBarDataProxyFunc_addRows_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_array(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.array";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // array()const
            const QtDataVisualization::QBarDataArray * cppResult = const_cast<const ::QtDataVisualization::QBarDataProxy *>(cppSelf)->array();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QBARDATAARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_columnLabels(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.columnLabels";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnLabels()const
            QStringList cppResult = const_cast<const ::QtDataVisualization::QBarDataProxy *>(cppSelf)->columnLabels();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_insertRow(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.insertRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertRow", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QBarDataProxy::insertRow(int,QVector<QtDataVisualization::QBarDataItem>)
    // 1: QBarDataProxy::insertRow(int,QVector<QtDataVisualization::QBarDataItem>,QString)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QBARDATAITEM_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // insertRow(int,QVector<QtDataVisualization::QBarDataItem>)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            overloadId = 1; // insertRow(int,QVector<QtDataVisualization::QBarDataItem>,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_insertRow_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // insertRow(int arg__1, QVector<QtDataVisualization::QBarDataItem > arg__2)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            ::QVector<QtDataVisualization::QBarDataItem > cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // insertRow(int,QVector<QtDataVisualization::QBarDataItem>)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-insertrow)]
                using VectorType = decltype(cppArg1);
                cppSelf->insertRow(cppArg0, new VectorType(cppArg1));
                // END of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-insertrow)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // insertRow(int arg__1, QVector<QtDataVisualization::QBarDataItem > arg__2, QString arg__3)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            ::QVector<QtDataVisualization::QBarDataItem > cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            SBK_UNUSED(cppArg2)

            if (!PyErr_Occurred()) {
                // insertRow(int,QVector<QtDataVisualization::QBarDataItem>,QString)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-insertrow-string)]
                using VectorType = decltype(cppArg1);
                cppSelf->insertRow(cppArg0, new VectorType(cppArg1), cppArg2);
                // END of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-insertrow-string)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QBarDataProxyFunc_insertRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_insertRows(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.insertRows";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertRows", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QBarDataProxy::insertRows(int,QtDataVisualization::QBarDataArray)
    // 1: QBarDataProxy::insertRows(int,QtDataVisualization::QBarDataArray,QStringList)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QBARDATAARRAY_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // insertRows(int,QtDataVisualization::QBarDataArray)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[2])))) {
            overloadId = 1; // insertRows(int,QtDataVisualization::QBarDataArray,QStringList)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_insertRows_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // insertRows(int rowIndex, const QtDataVisualization::QBarDataArray & rows)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QtDataVisualization::QBarDataArray cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // insertRows(int,QtDataVisualization::QBarDataArray)
                cppSelf->insertRows(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // insertRows(int rowIndex, const QtDataVisualization::QBarDataArray & rows, const QStringList & labels)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QtDataVisualization::QBarDataArray cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QStringList cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // insertRows(int,QtDataVisualization::QBarDataArray,QStringList)
                cppSelf->insertRows(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QBarDataProxyFunc_insertRows_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_itemAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.itemAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "itemAt", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBarDataProxy::itemAt(QPoint)const
    // 1: QBarDataProxy::itemAt(int,int)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // itemAt(int,int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // itemAt(QPoint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_itemAt_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // itemAt(const QPoint & position) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // itemAt(QPoint)const
                const QtDataVisualization::QBarDataItem * cppResult = const_cast<const ::QtDataVisualization::QBarDataProxy *>(cppSelf)->itemAt(*cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // itemAt(int rowIndex, int columnIndex) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // itemAt(int,int)const
                const QtDataVisualization::QBarDataItem * cppResult = const_cast<const ::QtDataVisualization::QBarDataProxy *>(cppSelf)->itemAt(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QBarDataProxyFunc_itemAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_removeRows(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.removeRows";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtDataVisualization_QBarDataProxyFunc_removeRows_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QtDataVisualization_QBarDataProxyFunc_removeRows_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:removeRows", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QBarDataProxy::removeRows(int,int,bool)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // removeRows(int,int,bool)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
            overloadId = 0; // removeRows(int,int,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_removeRows_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_removeLabels = Shiboken::String::createStaticString("removeLabels");
            if (PyDict_Contains(kwds, key_removeLabels)) {
                value = PyDict_GetItem(kwds, key_removeLabels);
                if (value && pyArgs[2]) {
                    errInfo = key_removeLabels;
                    Py_INCREF(errInfo);
                    goto Sbk_QtDataVisualization_QBarDataProxyFunc_removeRows_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))
                        goto Sbk_QtDataVisualization_QBarDataProxyFunc_removeRows_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_removeLabels);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtDataVisualization_QBarDataProxyFunc_removeRows_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = true;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // removeRows(int,int,bool)
            cppSelf->removeRows(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QBarDataProxyFunc_removeRows_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_resetArray(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.resetArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto Sbk_QtDataVisualization_QBarDataProxyFunc_resetArray_TypeError;

    if (!PyArg_UnpackTuple(args, "resetArray", 0, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QBarDataProxy::resetArray()
    // 1: QBarDataProxy::resetArray(QtDataVisualization::QBarDataArray*)
    // 2: QBarDataProxy::resetArray(QtDataVisualization::QBarDataArray*,QStringList,QStringList)
    if (numArgs == 0) {
        overloadId = 0; // resetArray()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QBARDATAARRAY_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // resetArray(QtDataVisualization::QBarDataArray*)
        } else if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[2])))) {
            overloadId = 2; // resetArray(QtDataVisualization::QBarDataArray*,QStringList,QStringList)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_resetArray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // resetArray()
        {

            if (!PyErr_Occurred()) {
                // resetArray()
                cppSelf->resetArray();
            }
            break;
        }
        case 1: // resetArray(QtDataVisualization::QBarDataArray * newArray)
        {
            ::QtDataVisualization::QBarDataArray *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // resetArray(QtDataVisualization::QBarDataArray*)
                cppSelf->resetArray(cppArg0);
                Shiboken::Object::setParent(self, pyArgs[0]);
            }
            break;
        }
        case 2: // resetArray(QtDataVisualization::QBarDataArray * newArray, const QStringList & rowLabels, const QStringList & columnLabels)
        {
            ::QtDataVisualization::QBarDataArray *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QStringList cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // resetArray(QtDataVisualization::QBarDataArray*,QStringList,QStringList)
                cppSelf->resetArray(cppArg0, cppArg1, cppArg2);
                Shiboken::Object::setParent(self, pyArgs[0]);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QBarDataProxyFunc_resetArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_rowAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.rowAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBarDataProxy::rowAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // rowAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_rowAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rowAt(int)const
            const QVector<QtDataVisualization::QBarDataItem > * cppResult = const_cast<const ::QtDataVisualization::QBarDataProxy *>(cppSelf)->rowAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QBARDATAITEM_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtDataVisualization_QBarDataProxyFunc_rowAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_rowCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.rowCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rowCount()const
            int cppResult = const_cast<const ::QtDataVisualization::QBarDataProxy *>(cppSelf)->rowCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_rowLabels(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.rowLabels";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rowLabels()const
            QStringList cppResult = const_cast<const ::QtDataVisualization::QBarDataProxy *>(cppSelf)->rowLabels();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_series(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.series";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // series()const
            QtDataVisualization::QBar3DSeries * cppResult = const_cast<const ::QtDataVisualization::QBarDataProxy *>(cppSelf)->series();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBAR3DSERIES_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_setColumnLabels(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setColumnLabels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBarDataProxy::setColumnLabels(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setColumnLabels(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_setColumnLabels_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColumnLabels(QStringList)
            cppSelf->setColumnLabels(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QBarDataProxyFunc_setColumnLabels_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_setItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setItem", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QBarDataProxy::setItem(QPoint,QtDataVisualization::QBarDataItem)
    // 1: QBarDataProxy::setItem(int,int,QtDataVisualization::QBarDataItem)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), (pyArgs[2])))) {
        overloadId = 1; // setItem(int,int,QtDataVisualization::QBarDataItem)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setItem(QPoint,QtDataVisualization::QBarDataItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_setItem_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setItem(const QPoint & position, const QtDataVisualization::QBarDataItem & item)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QtDataVisualization::QBarDataItem cppArg1_local;
            ::QtDataVisualization::QBarDataItem *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setItem(QPoint,QtDataVisualization::QBarDataItem)
                cppSelf->setItem(*cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // setItem(int rowIndex, int columnIndex, const QtDataVisualization::QBarDataItem & item)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QtDataVisualization::QBarDataItem cppArg2_local;
            ::QtDataVisualization::QBarDataItem *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // setItem(int,int,QtDataVisualization::QBarDataItem)
                cppSelf->setItem(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QBarDataProxyFunc_setItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_setRow(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setRow", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QBarDataProxy::setRow(int,QVector<QtDataVisualization::QBarDataItem>)
    // 1: QBarDataProxy::setRow(int,QVector<QtDataVisualization::QBarDataItem>,QString)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QBARDATAITEM_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setRow(int,QVector<QtDataVisualization::QBarDataItem>)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            overloadId = 1; // setRow(int,QVector<QtDataVisualization::QBarDataItem>,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_setRow_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setRow(int arg__1, QVector<QtDataVisualization::QBarDataItem > arg__2)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            ::QVector<QtDataVisualization::QBarDataItem > cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // setRow(int,QVector<QtDataVisualization::QBarDataItem>)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-setrow)]
                using VectorType = decltype(cppArg1);
                cppSelf->setRow(cppArg0, new VectorType(cppArg1));
                // END of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-setrow)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // setRow(int arg__1, QVector<QtDataVisualization::QBarDataItem > arg__2, QString arg__3)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            ::QVector<QtDataVisualization::QBarDataItem > cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            SBK_UNUSED(cppArg2)

            if (!PyErr_Occurred()) {
                // setRow(int,QVector<QtDataVisualization::QBarDataItem>,QString)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-setrow-string)]
                using VectorType = decltype(cppArg1);
                cppSelf->setRow(cppArg0, new VectorType(cppArg1), cppArg2);
                // END of custom code block [file: ../glue/qtdatavisualization.cpp (dataproxy-setrow-string)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QBarDataProxyFunc_setRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_setRowLabels(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setRowLabels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBarDataProxy::setRowLabels(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setRowLabels(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_setRowLabels_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRowLabels(QStringList)
            cppSelf->setRowLabels(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QBarDataProxyFunc_setRowLabels_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QBarDataProxyFunc_setRows(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setRows";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setRows", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QBarDataProxy::setRows(int,QtDataVisualization::QBarDataArray)
    // 1: QBarDataProxy::setRows(int,QtDataVisualization::QBarDataArray,QStringList)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QBARDATAARRAY_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setRows(int,QtDataVisualization::QBarDataArray)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[2])))) {
            overloadId = 1; // setRows(int,QtDataVisualization::QBarDataArray,QStringList)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QBarDataProxyFunc_setRows_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setRows(int rowIndex, const QtDataVisualization::QBarDataArray & rows)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QtDataVisualization::QBarDataArray cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setRows(int,QtDataVisualization::QBarDataArray)
                cppSelf->setRows(cppArg0, cppArg1);
                Shiboken::Object::setParent(self, pyArgs[1]);
            }
            break;
        }
        case 1: // setRows(int rowIndex, const QtDataVisualization::QBarDataArray & rows, const QStringList & labels)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QtDataVisualization::QBarDataArray cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QStringList cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setRows(int,QtDataVisualization::QBarDataArray,QStringList)
                cppSelf->setRows(cppArg0, cppArg1, cppArg2);
                Shiboken::Object::setParent(self, pyArgs[1]);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QBarDataProxyFunc_setRows_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QtDataVisualization_QBarDataProxy_PropertyStrings[] = {
    "columnLabels::",
    "rowCount:",
    "rowLabels::",
    "series:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_QBarDataProxy_methods[] = {
    {"addRow", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_addRow), METH_VARARGS},
    {"addRows", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_addRows), METH_VARARGS},
    {"array", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_array), METH_NOARGS},
    {"columnLabels", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_columnLabels), METH_NOARGS},
    {"insertRow", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_insertRow), METH_VARARGS},
    {"insertRows", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_insertRows), METH_VARARGS},
    {"itemAt", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_itemAt), METH_VARARGS},
    {"removeRows", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_removeRows), METH_VARARGS|METH_KEYWORDS},
    {"resetArray", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_resetArray), METH_VARARGS},
    {"rowAt", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_rowAt), METH_O},
    {"rowCount", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_rowCount), METH_NOARGS},
    {"rowLabels", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_rowLabels), METH_NOARGS},
    {"series", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_series), METH_NOARGS},
    {"setColumnLabels", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_setColumnLabels), METH_O},
    {"setItem", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_setItem), METH_VARARGS},
    {"setRow", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_setRow), METH_VARARGS},
    {"setRowLabels", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_setRowLabels), METH_O},
    {"setRows", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QBarDataProxyFunc_setRows), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtDataVisualization_QBarDataProxy_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtDataVisualization::QBarDataProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QBarDataProxyWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtDataVisualization_QBarDataProxy_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_QBarDataProxy_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_QBarDataProxy_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_QBarDataProxy_TypeF(void)
{
    return _Sbk_QtDataVisualization_QBarDataProxy_Type;
}

static PyType_Slot Sbk_QtDataVisualization_QBarDataProxy_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QBarDataProxy_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QBarDataProxy_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_QBarDataProxy_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_QBarDataProxy_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtDataVisualization_QBarDataProxy_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_QBarDataProxy_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_QBarDataProxy_slots
};

} //extern "C"

static void *Sbk_QtDataVisualization_QBarDataProxy_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtDataVisualization::QBarDataProxy *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QBarDataProxy_PythonToCpp_QBarDataProxy_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_QBarDataProxy_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QBarDataProxy_PythonToCpp_QBarDataProxy_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QBarDataProxy_TypeF())))
        return QBarDataProxy_PythonToCpp_QBarDataProxy_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QBarDataProxy_PTR_CppToPython_QBarDataProxy(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtDataVisualization::QBarDataProxy *>(const_cast<void *>(cppIn)), Sbk_QtDataVisualization_QBarDataProxy_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_QBarDataProxy_SignatureStrings[] = {
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy(self,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.addRow(self,arg__1:QVector[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem])->int",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.addRow(self,arg__1:QVector[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem],arg__2:QString)->int",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.addRows(self,rows:QtDataVisualization.QBarDataArray)->int",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.addRows(self,rows:QtDataVisualization.QBarDataArray,labels:QStringList)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.array(self)->QtDataVisualization.QBarDataArray*",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.columnLabels(self)->QStringList",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.insertRow(self,arg__1:int,arg__2:QVector[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem])",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.insertRow(self,arg__1:int,arg__2:QVector[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem],arg__3:QString)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.insertRows(self,rowIndex:int,rows:QtDataVisualization.QBarDataArray)",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.insertRows(self,rowIndex:int,rows:QtDataVisualization.QBarDataArray,labels:QStringList)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.itemAt(self,position:PySide2.QtCore.QPoint)->PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.itemAt(self,rowIndex:int,columnIndex:int)->PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.removeRows(self,rowIndex:int,removeCount:int,removeLabels:bool=true)",
    "2:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.resetArray(self)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.resetArray(self,newArray:QtDataVisualization.QBarDataArray*)",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.resetArray(self,newArray:QtDataVisualization.QBarDataArray*,rowLabels:QStringList,columnLabels:QStringList)",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.rowAt(self,rowIndex:int)->QVector[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem]",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.rowCount(self)->int",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.rowLabels(self)->QStringList",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.series(self)->PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setColumnLabels(self,labels:QStringList)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setItem(self,position:PySide2.QtCore.QPoint,item:PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem)",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setItem(self,rowIndex:int,columnIndex:int,item:PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setRow(self,arg__1:int,arg__2:QVector[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem])",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setRow(self,arg__1:int,arg__2:QVector[PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem],arg__3:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setRowLabels(self,labels:QStringList)",
    "1:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setRows(self,rowIndex:int,rows:QtDataVisualization.QBarDataArray)",
    "0:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy.setRows(self,rowIndex:int,rows:QtDataVisualization.QBarDataArray,labels:QStringList)",
    nullptr}; // Sentinel

void init_QtDataVisualization_QBarDataProxy(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_QBarDataProxy_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QBarDataProxy",
        "QtDataVisualization::QBarDataProxy*",
        &Sbk_QtDataVisualization_QBarDataProxy_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::QBarDataProxy >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACTDATAPROXY_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QBarDataProxy_Type);
    InitSignatureStrings(pyType, QtDataVisualization_QBarDataProxy_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QBarDataProxy_Type), Sbk_QtDataVisualization_QBarDataProxy_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAPROXY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QBarDataProxy_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_QBarDataProxy_TypeF(),
        QBarDataProxy_PythonToCpp_QBarDataProxy_PTR,
        is_QBarDataProxy_PythonToCpp_QBarDataProxy_PTR_Convertible,
        QBarDataProxy_PTR_CppToPython_QBarDataProxy);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QBarDataProxy");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QBarDataProxy*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QBarDataProxy&");
    Shiboken::Conversions::registerConverterName(converter, "QBarDataProxy");
    Shiboken::Conversions::registerConverterName(converter, "QBarDataProxy*");
    Shiboken::Conversions::registerConverterName(converter, "QBarDataProxy&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::QBarDataProxy).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QBarDataProxyWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtDataVisualization_QBarDataProxy_TypeF(), &Sbk_QtDataVisualization_QBarDataProxy_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QtDataVisualization_QBarDataProxy_TypeF(), &::QtDataVisualization::QBarDataProxy::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtDataVisualization_QBarDataProxy_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtDataVisualization_QBarDataProxy_TypeF(), &::QtDataVisualization::QBarDataProxy::staticMetaObject, sizeof(QBarDataProxyWrapper));
}
