/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtdatavisualization_python.h"

// main header
#include "qtdatavisualization_qabstract3daxis_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtDataVisualization;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstract3DAxisWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QAbstract3DAxisWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstract3DAxisWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstract3DAxisWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstract3DAxisWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstract3DAxisWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DAxis.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstract3DAxisWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstract3DAxis.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstract3DAxisWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAbstract3DAxisWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtDataVisualization::QAbstract3DAxis::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstract3DAxisWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtDataVisualization::QAbstract3DAxis::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstract3DAxisWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstract3DAxisWrapper *>(this));
        return QtDataVisualization::QAbstract3DAxis::qt_metacast(_clname);
}

QAbstract3DAxisWrapper::~QAbstract3DAxisWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_isAutoAdjustRange(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.isAutoAdjustRange";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAutoAdjustRange()const
            bool cppResult = const_cast<const ::QtDataVisualization::QAbstract3DAxis *>(cppSelf)->isAutoAdjustRange();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_isTitleFixed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.isTitleFixed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTitleFixed()const
            bool cppResult = const_cast<const ::QtDataVisualization::QAbstract3DAxis *>(cppSelf)->isTitleFixed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_isTitleVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.isTitleVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTitleVisible()const
            bool cppResult = const_cast<const ::QtDataVisualization::QAbstract3DAxis *>(cppSelf)->isTitleVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_labelAutoRotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.labelAutoRotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelAutoRotation()const
            float cppResult = const_cast<const ::QtDataVisualization::QAbstract3DAxis *>(cppSelf)->labelAutoRotation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_labels(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.labels";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labels()const
            QStringList cppResult = const_cast<const ::QtDataVisualization::QAbstract3DAxis *>(cppSelf)->labels();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_max(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.max";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // max()const
            float cppResult = const_cast<const ::QtDataVisualization::QAbstract3DAxis *>(cppSelf)->max();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_min(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.min";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // min()const
            float cppResult = const_cast<const ::QtDataVisualization::QAbstract3DAxis *>(cppSelf)->min();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_orientation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.orientation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // orientation()const
            QtDataVisualization::QAbstract3DAxis::AxisOrientation cppResult = const_cast<const ::QtDataVisualization::QAbstract3DAxis *>(cppSelf)->orientation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_setAutoAdjustRange(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setAutoAdjustRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DAxis::setAutoAdjustRange(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoAdjustRange(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DAxisFunc_setAutoAdjustRange_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoAdjustRange(bool)
            cppSelf->setAutoAdjustRange(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DAxisFunc_setAutoAdjustRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_setLabelAutoRotation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setLabelAutoRotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DAxis::setLabelAutoRotation(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setLabelAutoRotation(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DAxisFunc_setLabelAutoRotation_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelAutoRotation(float)
            cppSelf->setLabelAutoRotation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DAxisFunc_setLabelAutoRotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_setLabels(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setLabels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DAxis::setLabels(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setLabels(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DAxisFunc_setLabels_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabels(QStringList)
            cppSelf->setLabels(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DAxisFunc_setLabels_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_setMax(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setMax";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DAxis::setMax(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setMax(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DAxisFunc_setMax_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMax(float)
            cppSelf->setMax(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DAxisFunc_setMax_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_setMin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setMin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DAxis::setMin(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setMin(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DAxisFunc_setMin_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMin(float)
            cppSelf->setMin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DAxisFunc_setMin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_setRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setRange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstract3DAxis::setRange(float,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // setRange(float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DAxisFunc_setRange_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setRange(float,float)
            cppSelf->setRange(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DAxisFunc_setRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setTitle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DAxis::setTitle(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitle_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTitle(QString)
            cppSelf->setTitle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitleFixed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setTitleFixed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DAxis::setTitleFixed(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setTitleFixed(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitleFixed_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTitleFixed(bool)
            cppSelf->setTitleFixed(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitleFixed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitleVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setTitleVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstract3DAxis::setTitleVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setTitleVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitleVisible_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTitleVisible(bool)
            cppSelf->setTitleVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitleVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_title(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.title";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // title()const
            QString cppResult = const_cast<const ::QtDataVisualization::QAbstract3DAxis *>(cppSelf)->title();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtDataVisualization_QAbstract3DAxisFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QtDataVisualization::QAbstract3DAxis::AxisType cppResult = const_cast<const ::QtDataVisualization::QAbstract3DAxis *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtDataVisualization_QAbstract3DAxis_PropertyStrings[] = {
    "autoAdjustRange:isAutoAdjustRange:",
    "labelAutoRotation::",
    "labels::",
    "max::",
    "min::",
    "orientation:",
    "title::",
    "titleFixed:isTitleFixed:",
    "titleVisible:isTitleVisible:",
    "type:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtDataVisualization_QAbstract3DAxis_methods[] = {
    {"isAutoAdjustRange", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_isAutoAdjustRange), METH_NOARGS},
    {"isTitleFixed", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_isTitleFixed), METH_NOARGS},
    {"isTitleVisible", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_isTitleVisible), METH_NOARGS},
    {"labelAutoRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_labelAutoRotation), METH_NOARGS},
    {"labels", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_labels), METH_NOARGS},
    {"max", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_max), METH_NOARGS},
    {"min", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_min), METH_NOARGS},
    {"orientation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_orientation), METH_NOARGS},
    {"setAutoAdjustRange", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_setAutoAdjustRange), METH_O},
    {"setLabelAutoRotation", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_setLabelAutoRotation), METH_O},
    {"setLabels", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_setLabels), METH_O},
    {"setMax", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_setMax), METH_O},
    {"setMin", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_setMin), METH_O},
    {"setRange", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_setRange), METH_VARARGS},
    {"setTitle", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitle), METH_O},
    {"setTitleFixed", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitleFixed), METH_O},
    {"setTitleVisible", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_setTitleVisible), METH_O},
    {"title", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_title), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QtDataVisualization_QAbstract3DAxisFunc_type), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtDataVisualization_QAbstract3DAxis_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtDataVisualization::QAbstract3DAxis *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstract3DAxisWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtDataVisualization_QAbstract3DAxis_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtDataVisualization_QAbstract3DAxis_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtDataVisualization_QAbstract3DAxis_Type = nullptr;
static SbkObjectType *Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(void)
{
    return _Sbk_QtDataVisualization_QAbstract3DAxis_Type;
}

static PyType_Slot Sbk_QtDataVisualization_QAbstract3DAxis_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DAxis_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DAxis_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DAxis_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtDataVisualization_QAbstract3DAxis_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtDataVisualization_QAbstract3DAxis_spec = {
    "2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtDataVisualization_QAbstract3DAxis_slots
};

} //extern "C"

static void *Sbk_QtDataVisualization_QAbstract3DAxis_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtDataVisualization::QAbstract3DAxis *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QtDataVisualization_QAbstract3DAxis_AxisOrientation_PythonToCpp_QtDataVisualization_QAbstract3DAxis_AxisOrientation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QAbstract3DAxis::AxisOrientation *>(cppOut) =
        static_cast<::QtDataVisualization::QAbstract3DAxis::AxisOrientation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_QAbstract3DAxis_AxisOrientation_PythonToCpp_QtDataVisualization_QAbstract3DAxis_AxisOrientation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISORIENTATION_IDX]))
        return QtDataVisualization_QAbstract3DAxis_AxisOrientation_PythonToCpp_QtDataVisualization_QAbstract3DAxis_AxisOrientation;
    return {};
}
static PyObject *QtDataVisualization_QAbstract3DAxis_AxisOrientation_CppToPython_QtDataVisualization_QAbstract3DAxis_AxisOrientation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::QAbstract3DAxis::AxisOrientation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISORIENTATION_IDX], castCppIn);

}

static void QtDataVisualization_QAbstract3DAxis_AxisType_PythonToCpp_QtDataVisualization_QAbstract3DAxis_AxisType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtDataVisualization::QAbstract3DAxis::AxisType *>(cppOut) =
        static_cast<::QtDataVisualization::QAbstract3DAxis::AxisType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtDataVisualization_QAbstract3DAxis_AxisType_PythonToCpp_QtDataVisualization_QAbstract3DAxis_AxisType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISTYPE_IDX]))
        return QtDataVisualization_QAbstract3DAxis_AxisType_PythonToCpp_QtDataVisualization_QAbstract3DAxis_AxisType;
    return {};
}
static PyObject *QtDataVisualization_QAbstract3DAxis_AxisType_CppToPython_QtDataVisualization_QAbstract3DAxis_AxisType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtDataVisualization::QAbstract3DAxis::AxisType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstract3DAxis_PythonToCpp_QAbstract3DAxis_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstract3DAxis_PythonToCpp_QAbstract3DAxis_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QAbstract3DAxis_TypeF())))
        return QAbstract3DAxis_PythonToCpp_QAbstract3DAxis_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstract3DAxis_PTR_CppToPython_QAbstract3DAxis(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtDataVisualization::QAbstract3DAxis *>(const_cast<void *>(cppIn)), Sbk_QtDataVisualization_QAbstract3DAxis_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_QAbstract3DAxis_SignatureStrings[] = {
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.isAutoAdjustRange(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.isTitleFixed(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.isTitleVisible(self)->bool",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.labelAutoRotation(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.labels(self)->QStringList",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.max(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.min(self)->float",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.orientation(self)->PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.AxisOrientation",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setAutoAdjustRange(self,autoAdjust:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setLabelAutoRotation(self,angle:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setLabels(self,labels:QStringList)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setMax(self,max:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setMin(self,min:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setRange(self,min:float,max:float)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setTitle(self,title:QString)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setTitleFixed(self,fixed:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.setTitleVisible(self,visible:bool)",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.title(self)->QString",
    "PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.type(self)->PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.AxisType",
    nullptr}; // Sentinel

void init_QtDataVisualization_QAbstract3DAxis(PyObject *enclosingClass)
{
    _Sbk_QtDataVisualization_QAbstract3DAxis_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QAbstract3DAxis",
        "QtDataVisualization::QAbstract3DAxis*",
        &Sbk_QtDataVisualization_QAbstract3DAxis_spec,
        &Shiboken::callCppDestructor< ::QtDataVisualization::QAbstract3DAxis >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QAbstract3DAxis_Type);
    InitSignatureStrings(pyType, QtDataVisualization_QAbstract3DAxis_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtDataVisualization_QAbstract3DAxis_Type), Sbk_QtDataVisualization_QAbstract3DAxis_PropertyStrings);
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtDataVisualization_QAbstract3DAxis_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(),
        QAbstract3DAxis_PythonToCpp_QAbstract3DAxis_PTR,
        is_QAbstract3DAxis_PythonToCpp_QAbstract3DAxis_PTR_Convertible,
        QAbstract3DAxis_PTR_CppToPython_QAbstract3DAxis);

    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DAxis");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DAxis*");
    Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DAxis&");
    Shiboken::Conversions::registerConverterName(converter, "QAbstract3DAxis");
    Shiboken::Conversions::registerConverterName(converter, "QAbstract3DAxis*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstract3DAxis&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtDataVisualization::QAbstract3DAxis).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstract3DAxisWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), &Sbk_QtDataVisualization_QAbstract3DAxis_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'AxisOrientation'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISORIENTATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(),
        "AxisOrientation",
        "2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.AxisOrientation",
        "QtDataVisualization::QAbstract3DAxis::AxisOrientation");
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISORIENTATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISORIENTATION_IDX],
        Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), "AxisOrientationNone", (long) QtDataVisualization::QAbstract3DAxis::AxisOrientation::AxisOrientationNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISORIENTATION_IDX],
        Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), "AxisOrientationX", (long) QtDataVisualization::QAbstract3DAxis::AxisOrientation::AxisOrientationX))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISORIENTATION_IDX],
        Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), "AxisOrientationY", (long) QtDataVisualization::QAbstract3DAxis::AxisOrientation::AxisOrientationY))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISORIENTATION_IDX],
        Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), "AxisOrientationZ", (long) QtDataVisualization::QAbstract3DAxis::AxisOrientation::AxisOrientationZ))
        return;
    // Register converter for enum 'QtDataVisualization::QAbstract3DAxis::AxisOrientation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISORIENTATION_IDX],
            QtDataVisualization_QAbstract3DAxis_AxisOrientation_CppToPython_QtDataVisualization_QAbstract3DAxis_AxisOrientation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QAbstract3DAxis_AxisOrientation_PythonToCpp_QtDataVisualization_QAbstract3DAxis_AxisOrientation,
            is_QtDataVisualization_QAbstract3DAxis_AxisOrientation_PythonToCpp_QtDataVisualization_QAbstract3DAxis_AxisOrientation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISORIENTATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DAxis::AxisOrientation");
        Shiboken::Conversions::registerConverterName(converter, "QAbstract3DAxis::AxisOrientation");
        Shiboken::Conversions::registerConverterName(converter, "AxisOrientation");
    }
    // End of 'AxisOrientation' enum.

    // Initialization of enum 'AxisType'.
    SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(),
        "AxisType",
        "2:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.AxisType",
        "QtDataVisualization::QAbstract3DAxis::AxisType");
    if (!SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), "AxisTypeNone", (long) QtDataVisualization::QAbstract3DAxis::AxisType::AxisTypeNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), "AxisTypeCategory", (long) QtDataVisualization::QAbstract3DAxis::AxisType::AxisTypeCategory))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISTYPE_IDX],
        Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), "AxisTypeValue", (long) QtDataVisualization::QAbstract3DAxis::AxisType::AxisTypeValue))
        return;
    // Register converter for enum 'QtDataVisualization::QAbstract3DAxis::AxisType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISTYPE_IDX],
            QtDataVisualization_QAbstract3DAxis_AxisType_CppToPython_QtDataVisualization_QAbstract3DAxis_AxisType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtDataVisualization_QAbstract3DAxis_AxisType_PythonToCpp_QtDataVisualization_QAbstract3DAxis_AxisType,
            is_QtDataVisualization_QAbstract3DAxis_AxisType_PythonToCpp_QtDataVisualization_QAbstract3DAxis_AxisType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_AXISTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtDataVisualization::QAbstract3DAxis::AxisType");
        Shiboken::Conversions::registerConverterName(converter, "QAbstract3DAxis::AxisType");
        Shiboken::Conversions::registerConverterName(converter, "AxisType");
    }
    // End of 'AxisType' enum.

    PySide::Signal::registerSignals(Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), &::QtDataVisualization::QAbstract3DAxis::staticMetaObject);
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DAxis::AxisOrientation >("QAbstract3DAxis::AxisOrientation");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DAxis::AxisOrientation >("QtDataVisualization::QAbstract3DAxis::AxisOrientation");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DAxis::AxisType >("QAbstract3DAxis::AxisType");
    qRegisterMetaType< ::QtDataVisualization::QAbstract3DAxis::AxisType >("QtDataVisualization::QAbstract3DAxis::AxisType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtDataVisualization_QAbstract3DAxis_TypeF(), &::QtDataVisualization::QAbstract3DAxis::staticMetaObject, sizeof(QAbstract3DAxisWrapper));
}
