/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtdatavisualization_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtDataVisualizationTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtDataVisualizationModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtDataVisualizationTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtDataVisualization_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtDataVisualizationTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef QtDataVisualization_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QtDataVisualizationQtDataVisualization(PyObject *module);
void init_QtDataVisualization_QSurfaceDataItem(PyObject *enclosingClass);
void init_QtDataVisualization_QScatterDataItem(PyObject *enclosingClass);
void init_QtDataVisualization_QBarDataItem(PyObject *enclosingClass);
void init_QtDataVisualization_QCustom3DItem(PyObject *enclosingClass);
void init_QtDataVisualization_QCustom3DVolume(PyObject *enclosingClass);
void init_QtDataVisualization_QCustom3DLabel(PyObject *enclosingClass);
void init_QtDataVisualization_QAbstractDataProxy(PyObject *enclosingClass);
void init_QtDataVisualization_QBarDataProxy(PyObject *enclosingClass);
void init_QtDataVisualization_QItemModelBarDataProxy(PyObject *enclosingClass);
void init_QtDataVisualization_QSurfaceDataProxy(PyObject *enclosingClass);
void init_QtDataVisualization_QItemModelSurfaceDataProxy(PyObject *enclosingClass);
void init_QtDataVisualization_QHeightMapSurfaceDataProxy(PyObject *enclosingClass);
void init_QtDataVisualization_QScatterDataProxy(PyObject *enclosingClass);
void init_QtDataVisualization_QItemModelScatterDataProxy(PyObject *enclosingClass);
void init_QtDataVisualization_QAbstract3DSeries(PyObject *enclosingClass);
void init_QtDataVisualization_QBar3DSeries(PyObject *enclosingClass);
void init_QtDataVisualization_QSurface3DSeries(PyObject *enclosingClass);
void init_QtDataVisualization_QScatter3DSeries(PyObject *enclosingClass);
void init_QtDataVisualization_QAbstract3DInputHandler(PyObject *enclosingClass);
void init_QtDataVisualization_Q3DInputHandler(PyObject *enclosingClass);
void init_QtDataVisualization_QTouch3DInputHandler(PyObject *enclosingClass);
void init_QtDataVisualization_QAbstract3DAxis(PyObject *enclosingClass);
void init_QtDataVisualization_QCategory3DAxis(PyObject *enclosingClass);
void init_QtDataVisualization_QValue3DAxis(PyObject *enclosingClass);
void init_QtDataVisualization_Q3DTheme(PyObject *enclosingClass);
void init_QtDataVisualization_Q3DScene(PyObject *enclosingClass);
void init_QtDataVisualization_Q3DObject(PyObject *enclosingClass);
void init_QtDataVisualization_Q3DLight(PyObject *enclosingClass);
void init_QtDataVisualization_Q3DCamera(PyObject *enclosingClass);
void init_QtDataVisualization_QAbstract3DGraph(PyObject *enclosingClass);
void init_QtDataVisualization_Q3DSurface(PyObject *enclosingClass);
void init_QtDataVisualization_Q3DScatter(PyObject *enclosingClass);
void init_QtDataVisualization_Q3DBars(PyObject *enclosingClass);
void init_QtDataVisualization_QValue3DAxisFormatter(PyObject *enclosingClass);
void init_QtDataVisualization_QLogValue3DAxisFormatter(PyObject *enclosingClass);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtGuiTypes;
SbkConverter **SbkPySide2_QtGuiTypeConverters;
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------

// Primitive Type converters.

// C++ to Python conversion for type 'QtDataVisualization::QBarDataArray'.
static PyObject *QtDataVisualization_QBarDataArray_CppToPython_QtDataVisualization_QBarDataArray(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QtDataVisualization::QBarDataArray *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppqlistofptrtoqvectors_to_py_conversion - START
    const int rowCount = cppInRef.size();
    PyObject* pyOut = PyList_New(rowCount);
    for (int r = 0; r < rowCount; ++r) {
        const QVector<QtDataVisualization::QBarDataItem> *row = cppInRef.at(r);
        const int columnCount = row->size();
        PyObject *pyRow = PyList_New(columnCount);
        for (int c = 0; c < columnCount; ++c) {
            const QtDataVisualization::QBarDataItem &cppItem = row->at(c);
            PyList_SET_ITEM(pyRow, c, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), &cppItem));
        }
        PyList_SET_ITEM(pyOut, r, pyRow);
    }
    return pyOut;
    // TEMPLATE - cppqlistofptrtoqvectors_to_py_conversion - END

}
// Python to C++ conversions for type 'QtDataVisualization::QBarDataArray'.
static void PySequence_PythonToCpp_QtDataVisualization_QBarDataArray(PyObject *pyIn, void *cppOut) {
    // TEMPLATE - py_to_cppqlistofptrtoqvectors_conversion - START
    const int rowCount = int(PySequence_Size(pyIn));
    QtDataVisualization::QBarDataArray &result = *reinterpret_cast<::QtDataVisualization::QBarDataArray *>(cppOut);
    result.reserve(rowCount);
    for (int r = 0; r < rowCount; ++r) {
        Shiboken::AutoDecRef rowItem(PySequence_GetItem(pyIn, r));
        const int columnCount = int(PySequence_Size(rowItem));
        QVector<QtDataVisualization::QBarDataItem> *row = new QVector<QtDataVisualization::QBarDataItem>;
        row->reserve(columnCount);
        for (int c = 0; c < columnCount; ++c) {
           Shiboken::AutoDecRef pyItem(PySequence_GetItem(rowItem, c));
           ::QtDataVisualization::QBarDataItem v;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), pyItem, &(v));
           row->append(v);
        }
        result.append(row);
    }
    // TEMPLATE - py_to_cppqlistofptrtoqvectors_conversion - END

}
static PythonToCppFunc is_PySequence_PythonToCpp_QtDataVisualization_QBarDataArray_Convertible(PyObject *pyIn) {
    if (Shiboken::String::checkIterable(pyIn))
        return PySequence_PythonToCpp_QtDataVisualization_QBarDataArray;
    return {};
}

// C++ to Python conversion for type 'QtDataVisualization::QSurfaceDataArray'.
static PyObject *QtDataVisualization_QSurfaceDataArray_CppToPython_QtDataVisualization_QSurfaceDataArray(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QtDataVisualization::QSurfaceDataArray *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppqlistofptrtoqvectors_to_py_conversion - START
    const int rowCount = cppInRef.size();
    PyObject* pyOut = PyList_New(rowCount);
    for (int r = 0; r < rowCount; ++r) {
        const QVector<QtDataVisualization::QSurfaceDataItem> *row = cppInRef.at(r);
        const int columnCount = row->size();
        PyObject *pyRow = PyList_New(columnCount);
        for (int c = 0; c < columnCount; ++c) {
            const QtDataVisualization::QSurfaceDataItem &cppItem = row->at(c);
            PyList_SET_ITEM(pyRow, c, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSURFACEDATAITEM_IDX]), &cppItem));
        }
        PyList_SET_ITEM(pyOut, r, pyRow);
    }
    return pyOut;
    // TEMPLATE - cppqlistofptrtoqvectors_to_py_conversion - END

}
// Python to C++ conversions for type 'QtDataVisualization::QSurfaceDataArray'.
static void PySequence_PythonToCpp_QtDataVisualization_QSurfaceDataArray(PyObject *pyIn, void *cppOut) {
    // TEMPLATE - py_to_cppqlistofptrtoqvectors_conversion - START
    const int rowCount = int(PySequence_Size(pyIn));
    QtDataVisualization::QSurfaceDataArray &result = *reinterpret_cast<::QtDataVisualization::QSurfaceDataArray *>(cppOut);
    result.reserve(rowCount);
    for (int r = 0; r < rowCount; ++r) {
        Shiboken::AutoDecRef rowItem(PySequence_GetItem(pyIn, r));
        const int columnCount = int(PySequence_Size(rowItem));
        QVector<QtDataVisualization::QSurfaceDataItem> *row = new QVector<QtDataVisualization::QSurfaceDataItem>;
        row->reserve(columnCount);
        for (int c = 0; c < columnCount; ++c) {
           Shiboken::AutoDecRef pyItem(PySequence_GetItem(rowItem, c));
           ::QtDataVisualization::QSurfaceDataItem v;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSURFACEDATAITEM_IDX]), pyItem, &(v));
           row->append(v);
        }
        result.append(row);
    }
    // TEMPLATE - py_to_cppqlistofptrtoqvectors_conversion - END

}
static PythonToCppFunc is_PySequence_PythonToCpp_QtDataVisualization_QSurfaceDataArray_Convertible(PyObject *pyIn) {
    if (Shiboken::String::checkIterable(pyIn))
        return PySequence_PythonToCpp_QtDataVisualization_QSurfaceDataArray;
    return {};
}


// Container Type converters.

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QVector<uchar > *'.
static PyObject *_QVector_uchar_PTR_CppToPython__QVector_uchar_PTR(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<uchar > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<uchar >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<uchar >::size_type idx = 0; idx < vectorSize; ++idx) {
        uchar cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_uchar_PTR_PythonToCpp__QVector_uchar_PTR(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<uchar > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        uchar cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_uchar_PTR_PythonToCpp__QVector_uchar_PTR_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), pyIn))
        return _QVector_uchar_PTR_PythonToCpp__QVector_uchar_PTR;
    return {};
}

// C++ to Python conversion for type 'const QVector<unsigned int > &'.
static PyObject *_constQVector_unsignedint_REF_CppToPython__constQVector_unsignedint_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<unsigned int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<unsigned int >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<unsigned int >::size_type idx = 0; idx < vectorSize; ++idx) {
        unsigned int cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_unsignedint_REF_PythonToCpp__constQVector_unsignedint_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<unsigned int > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        unsigned int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_unsignedint_REF_PythonToCpp__constQVector_unsignedint_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), pyIn))
        return _constQVector_unsignedint_REF_PythonToCpp__constQVector_unsignedint_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QImage* > &'.
static PyObject *_constQVector_QImagePTR_REF_CppToPython__constQVector_QImagePTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QImage* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QImage* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QImage* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QImage* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QImagePTR_REF_PythonToCpp__constQVector_QImagePTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QImage* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QImage* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QImagePTR_REF_PythonToCpp__constQVector_QImagePTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], pyIn))
        return _constQVector_QImagePTR_REF_PythonToCpp__constQVector_QImagePTR_REF;
    return {};
}

// C++ to Python conversion for type 'QVector<QtDataVisualization::QBarDataItem > *'.
static PyObject *_QVector_QtDataVisualization_QBarDataItem_PTR_CppToPython__QVector_QtDataVisualization_QBarDataItem_PTR(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QtDataVisualization::QBarDataItem > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QtDataVisualization::QBarDataItem >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QtDataVisualization::QBarDataItem >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QtDataVisualization::QBarDataItem cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QtDataVisualization_QBarDataItem_PTR_PythonToCpp__QVector_QtDataVisualization_QBarDataItem_PTR(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QtDataVisualization::QBarDataItem > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtDataVisualization::QBarDataItem cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QtDataVisualization_QBarDataItem_PTR_PythonToCpp__QVector_QtDataVisualization_QBarDataItem_PTR_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBARDATAITEM_IDX]), pyIn))
        return _QVector_QtDataVisualization_QBarDataItem_PTR_PythonToCpp__QVector_QtDataVisualization_QBarDataItem_PTR;
    return {};
}

// C++ to Python conversion for type 'QVector<QtDataVisualization::QSurfaceDataItem > *'.
static PyObject *_QVector_QtDataVisualization_QSurfaceDataItem_PTR_CppToPython__QVector_QtDataVisualization_QSurfaceDataItem_PTR(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QtDataVisualization::QSurfaceDataItem > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QtDataVisualization::QSurfaceDataItem >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QtDataVisualization::QSurfaceDataItem >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QtDataVisualization::QSurfaceDataItem cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSURFACEDATAITEM_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QtDataVisualization_QSurfaceDataItem_PTR_PythonToCpp__QVector_QtDataVisualization_QSurfaceDataItem_PTR(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QtDataVisualization::QSurfaceDataItem > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtDataVisualization::QSurfaceDataItem cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSURFACEDATAITEM_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QtDataVisualization_QSurfaceDataItem_PTR_PythonToCpp__QVector_QtDataVisualization_QSurfaceDataItem_PTR_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSURFACEDATAITEM_IDX]), pyIn))
        return _QVector_QtDataVisualization_QSurfaceDataItem_PTR_PythonToCpp__QVector_QtDataVisualization_QSurfaceDataItem_PTR;
    return {};
}

// C++ to Python conversion for type 'const QVector<QtDataVisualization::QScatterDataItem > &'.
static PyObject *_constQVector_QtDataVisualization_QScatterDataItem_REF_CppToPython__constQVector_QtDataVisualization_QScatterDataItem_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QtDataVisualization::QScatterDataItem > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QtDataVisualization::QScatterDataItem >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QtDataVisualization::QScatterDataItem >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QtDataVisualization::QScatterDataItem cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QtDataVisualization_QScatterDataItem_REF_PythonToCpp__constQVector_QtDataVisualization_QScatterDataItem_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QtDataVisualization::QScatterDataItem > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtDataVisualization::QScatterDataItem cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QtDataVisualization_QScatterDataItem_REF_PythonToCpp__constQVector_QtDataVisualization_QScatterDataItem_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX]), pyIn))
        return _constQVector_QtDataVisualization_QScatterDataItem_REF_PythonToCpp__constQVector_QtDataVisualization_QScatterDataItem_REF;
    return {};
}

// C++ to Python conversion for type 'QVector<float > &'.
static PyObject *_QVector_float_REF_CppToPython__QVector_float_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<float > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<float >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<float >::size_type idx = 0; idx < vectorSize; ++idx) {
        float cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_float_REF_PythonToCpp__QVector_float_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<float > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        float cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<float>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_float_REF_PythonToCpp__QVector_float_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<float>(), pyIn))
        return _QVector_float_REF_PythonToCpp__QVector_float_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QtDataVisualization::QCustom3DItem* >'.
static PyObject *_QList_QtDataVisualization_QCustom3DItemPTR__CppToPython__QList_QtDataVisualization_QCustom3DItemPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtDataVisualization::QCustom3DItem* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtDataVisualization::QCustom3DItem* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtDataVisualization::QCustom3DItem* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DITEM_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtDataVisualization_QCustom3DItemPTR__PythonToCpp__QList_QtDataVisualization_QCustom3DItemPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtDataVisualization::QCustom3DItem* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtDataVisualization::QCustom3DItem* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DITEM_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtDataVisualization_QCustom3DItemPTR__PythonToCpp__QList_QtDataVisualization_QCustom3DItemPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QCUSTOM3DITEM_IDX], pyIn))
        return _QList_QtDataVisualization_QCustom3DItemPTR__PythonToCpp__QList_QtDataVisualization_QCustom3DItemPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QtDataVisualization::QAbstract3DInputHandler* >'.
static PyObject *_QList_QtDataVisualization_QAbstract3DInputHandlerPTR__CppToPython__QList_QtDataVisualization_QAbstract3DInputHandlerPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtDataVisualization::QAbstract3DInputHandler* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtDataVisualization::QAbstract3DInputHandler* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtDataVisualization::QAbstract3DInputHandler* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DINPUTHANDLER_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtDataVisualization_QAbstract3DInputHandlerPTR__PythonToCpp__QList_QtDataVisualization_QAbstract3DInputHandlerPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtDataVisualization::QAbstract3DInputHandler* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtDataVisualization::QAbstract3DInputHandler* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DINPUTHANDLER_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtDataVisualization_QAbstract3DInputHandlerPTR__PythonToCpp__QList_QtDataVisualization_QAbstract3DInputHandlerPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DINPUTHANDLER_IDX], pyIn))
        return _QList_QtDataVisualization_QAbstract3DInputHandlerPTR__PythonToCpp__QList_QtDataVisualization_QAbstract3DInputHandlerPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QtDataVisualization::Q3DTheme* >'.
static PyObject *_QList_QtDataVisualization_Q3DThemePTR__CppToPython__QList_QtDataVisualization_Q3DThemePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtDataVisualization::Q3DTheme* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtDataVisualization::Q3DTheme* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtDataVisualization::Q3DTheme* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtDataVisualization_Q3DThemePTR__PythonToCpp__QList_QtDataVisualization_Q3DThemePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtDataVisualization::Q3DTheme* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtDataVisualization::Q3DTheme* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtDataVisualization_Q3DThemePTR__PythonToCpp__QList_QtDataVisualization_Q3DThemePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_Q3DTHEME_IDX], pyIn))
        return _QList_QtDataVisualization_Q3DThemePTR__PythonToCpp__QList_QtDataVisualization_Q3DThemePTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QtDataVisualization::QAbstract3DAxis* >'.
static PyObject *_QList_QtDataVisualization_QAbstract3DAxisPTR__CppToPython__QList_QtDataVisualization_QAbstract3DAxisPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtDataVisualization::QAbstract3DAxis* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtDataVisualization::QAbstract3DAxis* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtDataVisualization::QAbstract3DAxis* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtDataVisualization_QAbstract3DAxisPTR__PythonToCpp__QList_QtDataVisualization_QAbstract3DAxisPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtDataVisualization::QAbstract3DAxis* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtDataVisualization::QAbstract3DAxis* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtDataVisualization_QAbstract3DAxisPTR__PythonToCpp__QList_QtDataVisualization_QAbstract3DAxisPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QABSTRACT3DAXIS_IDX], pyIn))
        return _QList_QtDataVisualization_QAbstract3DAxisPTR__PythonToCpp__QList_QtDataVisualization_QAbstract3DAxisPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QtDataVisualization::QBar3DSeries* >'.
static PyObject *_QList_QtDataVisualization_QBar3DSeriesPTR__CppToPython__QList_QtDataVisualization_QBar3DSeriesPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtDataVisualization::QBar3DSeries* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtDataVisualization::QBar3DSeries* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtDataVisualization::QBar3DSeries* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBAR3DSERIES_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtDataVisualization_QBar3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QBar3DSeriesPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtDataVisualization::QBar3DSeries* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtDataVisualization::QBar3DSeries* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBAR3DSERIES_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtDataVisualization_QBar3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QBar3DSeriesPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QBAR3DSERIES_IDX], pyIn))
        return _QList_QtDataVisualization_QBar3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QBar3DSeriesPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QtDataVisualization::QValue3DAxis* >'.
static PyObject *_QList_QtDataVisualization_QValue3DAxisPTR__CppToPython__QList_QtDataVisualization_QValue3DAxisPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtDataVisualization::QValue3DAxis* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtDataVisualization::QValue3DAxis* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtDataVisualization::QValue3DAxis* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QVALUE3DAXIS_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtDataVisualization_QValue3DAxisPTR__PythonToCpp__QList_QtDataVisualization_QValue3DAxisPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtDataVisualization::QValue3DAxis* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtDataVisualization::QValue3DAxis* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QVALUE3DAXIS_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtDataVisualization_QValue3DAxisPTR__PythonToCpp__QList_QtDataVisualization_QValue3DAxisPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QVALUE3DAXIS_IDX], pyIn))
        return _QList_QtDataVisualization_QValue3DAxisPTR__PythonToCpp__QList_QtDataVisualization_QValue3DAxisPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QtDataVisualization::QSurface3DSeries* >'.
static PyObject *_QList_QtDataVisualization_QSurface3DSeriesPTR__CppToPython__QList_QtDataVisualization_QSurface3DSeriesPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtDataVisualization::QSurface3DSeries* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtDataVisualization::QSurface3DSeries* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtDataVisualization::QSurface3DSeries* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSURFACE3DSERIES_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtDataVisualization_QSurface3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QSurface3DSeriesPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtDataVisualization::QSurface3DSeries* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtDataVisualization::QSurface3DSeries* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSURFACE3DSERIES_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtDataVisualization_QSurface3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QSurface3DSeriesPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSURFACE3DSERIES_IDX], pyIn))
        return _QList_QtDataVisualization_QSurface3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QSurface3DSeriesPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QtDataVisualization::QScatter3DSeries* >'.
static PyObject *_QList_QtDataVisualization_QScatter3DSeriesPTR__CppToPython__QList_QtDataVisualization_QScatter3DSeriesPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QtDataVisualization::QScatter3DSeries* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QtDataVisualization::QScatter3DSeries* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QtDataVisualization::QScatter3DSeries* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTER3DSERIES_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QtDataVisualization_QScatter3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QScatter3DSeriesPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QtDataVisualization::QScatter3DSeries* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QtDataVisualization::QScatter3DSeries* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTER3DSERIES_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QtDataVisualization_QScatter3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QScatter3DSeriesPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtDataVisualizationTypes[SBK_QTDATAVISUALIZATION_QSCATTER3DSERIES_IDX], pyIn))
        return _QList_QtDataVisualization_QScatter3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QScatter3DSeriesPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QColor >'.
static PyObject *_QList_QColor__CppToPython__QList_QColor_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QColor > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QColor >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QColor cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QColor__PythonToCpp__QList_QColor_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QColor > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QColor cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QColor__PythonToCpp__QList_QColor__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pyIn))
        return _QList_QColor__PythonToCpp__QList_QColor_;
    return {};
}

// C++ to Python conversion for type 'QList<QLinearGradient >'.
static PyObject *_QList_QLinearGradient__CppToPython__QList_QLinearGradient_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QLinearGradient > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QLinearGradient >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QLinearGradient cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QLinearGradient__PythonToCpp__QList_QLinearGradient_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QLinearGradient > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QLinearGradient cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QLinearGradient__PythonToCpp__QList_QLinearGradient__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QLINEARGRADIENT_IDX]), pyIn))
        return _QList_QLinearGradient__PythonToCpp__QList_QLinearGradient_;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtDataVisualization",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtDataVisualization_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtDataVisualization_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtDataVisualization)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtGui"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtGuiTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtDataVisualization_IDX_COUNT];
    SbkPySide2_QtDataVisualizationTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtDataVisualization_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtDataVisualizationTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtDataVisualization", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtDataVisualization", QtDataVisualization_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtDataVisualizationModuleObject = module;

    // Initialize classes in the type system
    init_QtDataVisualizationQtDataVisualization(module);
    init_QtDataVisualization_QSurfaceDataItem(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QScatterDataItem(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QBarDataItem(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QCustom3DItem(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QCustom3DVolume(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QCustom3DLabel(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QAbstractDataProxy(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QBarDataProxy(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QItemModelBarDataProxy(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QSurfaceDataProxy(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QItemModelSurfaceDataProxy(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QHeightMapSurfaceDataProxy(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QScatterDataProxy(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QItemModelScatterDataProxy(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QAbstract3DSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QBar3DSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QSurface3DSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QScatter3DSeries(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QAbstract3DInputHandler(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_Q3DInputHandler(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QTouch3DInputHandler(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QAbstract3DAxis(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QCategory3DAxis(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QValue3DAxis(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_Q3DTheme(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_Q3DScene(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_Q3DObject(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_Q3DLight(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_Q3DCamera(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QAbstract3DGraph(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_Q3DSurface(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_Q3DScatter(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_Q3DBars(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QValue3DAxisFormatter(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);
    init_QtDataVisualization_QLogValue3DAxisFormatter(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtDataVisualizationTypes[SBK_QtDataVisualizationQTDATAVISUALIZATION_IDX])->tp_dict);

    // Register converter for type 'PySide2.QtDataVisualization.QtDataVisualization.QBarDataArray'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QBARDATAARRAY_IDX] = Shiboken::Conversions::createConverter(0, QtDataVisualization_QBarDataArray_CppToPython_QtDataVisualization_QBarDataArray);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QBARDATAARRAY_IDX], "QtDataVisualization::QBarDataArray");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QBARDATAARRAY_IDX],
        PySequence_PythonToCpp_QtDataVisualization_QBarDataArray,
        is_PySequence_PythonToCpp_QtDataVisualization_QBarDataArray_Convertible);

    // Register converter for type 'PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataArray'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QSURFACEDATAARRAY_IDX] = Shiboken::Conversions::createConverter(0, QtDataVisualization_QSurfaceDataArray_CppToPython_QtDataVisualization_QSurfaceDataArray);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QSURFACEDATAARRAY_IDX], "QtDataVisualization::QSurfaceDataArray");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QSURFACEDATAARRAY_IDX],
        PySequence_PythonToCpp_QtDataVisualization_QSurfaceDataArray,
        is_PySequence_PythonToCpp_QtDataVisualization_QSurfaceDataArray_Convertible);


    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'QVector<uchar>*'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UCHAR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_uchar_PTR_CppToPython__QVector_uchar_PTR);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UCHAR_IDX], "QVector<uchar>*");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UCHAR_IDX],
        _QVector_uchar_PTR_PythonToCpp__QVector_uchar_PTR,
        is__QVector_uchar_PTR_PythonToCpp__QVector_uchar_PTR_Convertible);

    // Register converter for type 'const QVector<unsigned int>&'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UNSIGNEDINT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_unsignedint_REF_CppToPython__constQVector_unsignedint_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UNSIGNEDINT_IDX], "const QVector<unsigned int>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UNSIGNEDINT_IDX], "QVector<unsigned int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_UNSIGNEDINT_IDX],
        _constQVector_unsignedint_REF_PythonToCpp__constQVector_unsignedint_REF,
        is__constQVector_unsignedint_REF_PythonToCpp__constQVector_unsignedint_REF_Convertible);

    // Register converter for type 'const QVector<QImage*>&'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QIMAGEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QImagePTR_REF_CppToPython__constQVector_QImagePTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QIMAGEPTR_IDX], "const QVector<QImage*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QIMAGEPTR_IDX], "QVector<QImage*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QIMAGEPTR_IDX],
        _constQVector_QImagePTR_REF_PythonToCpp__constQVector_QImagePTR_REF,
        is__constQVector_QImagePTR_REF_PythonToCpp__constQVector_QImagePTR_REF_Convertible);

    // Register converter for type 'QVector<QtDataVisualization::QBarDataItem>*'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QBARDATAITEM_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QtDataVisualization_QBarDataItem_PTR_CppToPython__QVector_QtDataVisualization_QBarDataItem_PTR);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QBARDATAITEM_IDX], "QVector<QtDataVisualization::QBarDataItem>*");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QBARDATAITEM_IDX],
        _QVector_QtDataVisualization_QBarDataItem_PTR_PythonToCpp__QVector_QtDataVisualization_QBarDataItem_PTR,
        is__QVector_QtDataVisualization_QBarDataItem_PTR_PythonToCpp__QVector_QtDataVisualization_QBarDataItem_PTR_Convertible);

    // Register converter for type 'QVector<QtDataVisualization::QSurfaceDataItem>*'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSURFACEDATAITEM_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QtDataVisualization_QSurfaceDataItem_PTR_CppToPython__QVector_QtDataVisualization_QSurfaceDataItem_PTR);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSURFACEDATAITEM_IDX], "QVector<QtDataVisualization::QSurfaceDataItem>*");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSURFACEDATAITEM_IDX],
        _QVector_QtDataVisualization_QSurfaceDataItem_PTR_PythonToCpp__QVector_QtDataVisualization_QSurfaceDataItem_PTR,
        is__QVector_QtDataVisualization_QSurfaceDataItem_PTR_PythonToCpp__QVector_QtDataVisualization_QSurfaceDataItem_PTR_Convertible);

    // Register converter for type 'const QVector<QtDataVisualization::QScatterDataItem>&'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QtDataVisualization_QScatterDataItem_REF_CppToPython__constQVector_QtDataVisualization_QScatterDataItem_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], "const QVector<QtDataVisualization::QScatterDataItem>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX], "QVector<QtDataVisualization::QScatterDataItem>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_QTDATAVISUALIZATION_QSCATTERDATAITEM_IDX],
        _constQVector_QtDataVisualization_QScatterDataItem_REF_PythonToCpp__constQVector_QtDataVisualization_QScatterDataItem_REF,
        is__constQVector_QtDataVisualization_QScatterDataItem_REF_PythonToCpp__constQVector_QtDataVisualization_QScatterDataItem_REF_Convertible);

    // Register converter for type 'QVector<float>&'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_FLOAT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_float_REF_CppToPython__QVector_float_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_FLOAT_IDX], "QVector<float>&");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QVECTOR_FLOAT_IDX],
        _QVector_float_REF_PythonToCpp__QVector_float_REF,
        is__QVector_float_REF_PythonToCpp__QVector_float_REF_Convertible);

    // Register converter for type 'QList<QtDataVisualization::QCustom3DItem*>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QCUSTOM3DITEMPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtDataVisualization_QCustom3DItemPTR__CppToPython__QList_QtDataVisualization_QCustom3DItemPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QCUSTOM3DITEMPTR_IDX], "QList<QtDataVisualization::QCustom3DItem*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QCUSTOM3DITEMPTR_IDX],
        _QList_QtDataVisualization_QCustom3DItemPTR__PythonToCpp__QList_QtDataVisualization_QCustom3DItemPTR_,
        is__QList_QtDataVisualization_QCustom3DItemPTR__PythonToCpp__QList_QtDataVisualization_QCustom3DItemPTR__Convertible);

    // Register converter for type 'QList<QtDataVisualization::QAbstract3DInputHandler*>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QABSTRACT3DINPUTHANDLERPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtDataVisualization_QAbstract3DInputHandlerPTR__CppToPython__QList_QtDataVisualization_QAbstract3DInputHandlerPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QABSTRACT3DINPUTHANDLERPTR_IDX], "QList<QtDataVisualization::QAbstract3DInputHandler*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QABSTRACT3DINPUTHANDLERPTR_IDX],
        _QList_QtDataVisualization_QAbstract3DInputHandlerPTR__PythonToCpp__QList_QtDataVisualization_QAbstract3DInputHandlerPTR_,
        is__QList_QtDataVisualization_QAbstract3DInputHandlerPTR__PythonToCpp__QList_QtDataVisualization_QAbstract3DInputHandlerPTR__Convertible);

    // Register converter for type 'QList<QtDataVisualization::Q3DTheme*>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_Q3DTHEMEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtDataVisualization_Q3DThemePTR__CppToPython__QList_QtDataVisualization_Q3DThemePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_Q3DTHEMEPTR_IDX], "QList<QtDataVisualization::Q3DTheme*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_Q3DTHEMEPTR_IDX],
        _QList_QtDataVisualization_Q3DThemePTR__PythonToCpp__QList_QtDataVisualization_Q3DThemePTR_,
        is__QList_QtDataVisualization_Q3DThemePTR__PythonToCpp__QList_QtDataVisualization_Q3DThemePTR__Convertible);

    // Register converter for type 'QList<QtDataVisualization::QAbstract3DAxis*>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QABSTRACT3DAXISPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtDataVisualization_QAbstract3DAxisPTR__CppToPython__QList_QtDataVisualization_QAbstract3DAxisPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QABSTRACT3DAXISPTR_IDX], "QList<QtDataVisualization::QAbstract3DAxis*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QABSTRACT3DAXISPTR_IDX],
        _QList_QtDataVisualization_QAbstract3DAxisPTR__PythonToCpp__QList_QtDataVisualization_QAbstract3DAxisPTR_,
        is__QList_QtDataVisualization_QAbstract3DAxisPTR__PythonToCpp__QList_QtDataVisualization_QAbstract3DAxisPTR__Convertible);

    // Register converter for type 'QList<QtDataVisualization::QBar3DSeries*>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QBAR3DSERIESPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtDataVisualization_QBar3DSeriesPTR__CppToPython__QList_QtDataVisualization_QBar3DSeriesPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QBAR3DSERIESPTR_IDX], "QList<QtDataVisualization::QBar3DSeries*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QBAR3DSERIESPTR_IDX],
        _QList_QtDataVisualization_QBar3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QBar3DSeriesPTR_,
        is__QList_QtDataVisualization_QBar3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QBar3DSeriesPTR__Convertible);

    // Register converter for type 'QList<QtDataVisualization::QValue3DAxis*>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QVALUE3DAXISPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtDataVisualization_QValue3DAxisPTR__CppToPython__QList_QtDataVisualization_QValue3DAxisPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QVALUE3DAXISPTR_IDX], "QList<QtDataVisualization::QValue3DAxis*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QVALUE3DAXISPTR_IDX],
        _QList_QtDataVisualization_QValue3DAxisPTR__PythonToCpp__QList_QtDataVisualization_QValue3DAxisPTR_,
        is__QList_QtDataVisualization_QValue3DAxisPTR__PythonToCpp__QList_QtDataVisualization_QValue3DAxisPTR__Convertible);

    // Register converter for type 'QList<QtDataVisualization::QSurface3DSeries*>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QSURFACE3DSERIESPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtDataVisualization_QSurface3DSeriesPTR__CppToPython__QList_QtDataVisualization_QSurface3DSeriesPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QSURFACE3DSERIESPTR_IDX], "QList<QtDataVisualization::QSurface3DSeries*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QSURFACE3DSERIESPTR_IDX],
        _QList_QtDataVisualization_QSurface3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QSurface3DSeriesPTR_,
        is__QList_QtDataVisualization_QSurface3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QSurface3DSeriesPTR__Convertible);

    // Register converter for type 'QList<QtDataVisualization::QScatter3DSeries*>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QSCATTER3DSERIESPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QtDataVisualization_QScatter3DSeriesPTR__CppToPython__QList_QtDataVisualization_QScatter3DSeriesPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QSCATTER3DSERIESPTR_IDX], "QList<QtDataVisualization::QScatter3DSeries*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QTDATAVISUALIZATION_QSCATTER3DSERIESPTR_IDX],
        _QList_QtDataVisualization_QScatter3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QScatter3DSeriesPTR_,
        is__QList_QtDataVisualization_QScatter3DSeriesPTR__PythonToCpp__QList_QtDataVisualization_QScatter3DSeriesPTR__Convertible);

    // Register converter for type 'QList<QColor>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QCOLOR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QColor__CppToPython__QList_QColor_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QCOLOR_IDX], "QList<QColor>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QCOLOR_IDX],
        _QList_QColor__PythonToCpp__QList_QColor_,
        is__QList_QColor__PythonToCpp__QList_QColor__Convertible);

    // Register converter for type 'QList<QLinearGradient>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QLINEARGRADIENT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QLinearGradient__CppToPython__QList_QLinearGradient_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QLINEARGRADIENT_IDX], "QList<QLinearGradient>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QLINEARGRADIENT_IDX],
        _QList_QLinearGradient__PythonToCpp__QList_QLinearGradient_,
        is__QList_QLinearGradient__PythonToCpp__QList_QLinearGradient__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtDataVisualizationTypeConverters[SBK_QTDATAVISUALIZATION_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_QtDataVisualizationTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtDataVisualizationTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtDataVisualization");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtDataVisualization_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
