/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qtimezone_wrapper.h"

// inner classes
#include "qtimezone_offsetdata_wrapper.h"

// Extra includes
#include <QList>
#include <QVector>
#include <qbytearray.h>
#include <qdatetime.h>
#include <qlocale.h>
#include <qtimezone.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTimeZone_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTimeZone >()))
        return -1;

    ::QTimeZone *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTimeZone_Init_TypeError;
    } else if (numArgs == 2 || numArgs == 3)
        goto Sbk_QTimeZone_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOO:QTimeZone", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return -1;


    // Overloaded function decisor
    // 0: QTimeZone::QTimeZone()
    // 1: QTimeZone::QTimeZone(QByteArray)
    // 2: QTimeZone::QTimeZone(QByteArray,int,QString,QString,QLocale::Country,QString)
    // 3: QTimeZone::QTimeZone(QTimeZone)
    // 4: QTimeZone::QTimeZone(int)
    if (numArgs == 0) {
        overloadId = 0; // QTimeZone()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 4; // QTimeZone(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QTimeZone(QTimeZone)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QTimeZone(QByteArray)
        } else if (numArgs >= 4
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 2; // QTimeZone(QByteArray,int,QString,QString,QLocale::Country,QString)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 2; // QTimeZone(QByteArray,int,QString,QString,QLocale::Country,QString)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5])))) {
                    overloadId = 2; // QTimeZone(QByteArray,int,QString,QString,QLocale::Country,QString)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZone_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTimeZone()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTimeZone_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QTimeZone()
                cptr = new ::QTimeZone();
            }
            break;
        }
        case 1: // QTimeZone(const QByteArray & ianaId)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTimeZone_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTimeZone(QByteArray)
                cptr = new ::QTimeZone(*cppArg0);
            }
            break;
        }
        case 2: // QTimeZone(const QByteArray & zoneId, int offsetSeconds, const QString & name, const QString & abbreviation, QLocale::Country country, const QString & comment)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_country = Shiboken::String::createStaticString("country");
                if (PyDict_Contains(kwds, key_country)) {
                    value = PyDict_GetItem(kwds, key_country);
                    if (value && pyArgs[4]) {
                        errInfo = key_country;
                        Py_INCREF(errInfo);
                        goto Sbk_QTimeZone_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, (pyArgs[4]))))
                            goto Sbk_QTimeZone_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_country);
                }
                static PyObject *const key_comment = Shiboken::String::createStaticString("comment");
                if (PyDict_Contains(kwds, key_comment)) {
                    value = PyDict_GetItem(kwds, key_comment);
                    if (value && pyArgs[5]) {
                        errInfo = key_comment;
                        Py_INCREF(errInfo);
                        goto Sbk_QTimeZone_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5]))))
                            goto Sbk_QTimeZone_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_comment);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTimeZone_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QLocale::Country cppArg4 = QLocale::AnyCountry;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QString cppArg5 = QString();
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // QTimeZone(QByteArray,int,QString,QString,QLocale::Country,QString)
                cptr = new ::QTimeZone(*cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
        case 3: // QTimeZone(const QTimeZone & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTimeZone_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTimeZone cppArg0_local;
            ::QTimeZone *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTimeZone(QTimeZone)
                cptr = new ::QTimeZone(*cppArg0);
            }
            break;
        }
        case 4: // QTimeZone(int offsetSeconds)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTimeZone_Init_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QTimeZone(int)
                cptr = new ::QTimeZone(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTimeZone >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTimeZone_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTimeZone_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTimeZoneFunc_abbreviation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.abbreviation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeZone::abbreviation(QDateTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // abbreviation(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_abbreviation_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // abbreviation(QDateTime)const
            QString cppResult = const_cast<const ::QTimeZone *>(cppSelf)->abbreviation(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_abbreviation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_availableTimeZoneIds(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.availableTimeZoneIds";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "availableTimeZoneIds", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QTimeZone::availableTimeZoneIds()
    // 1: static QTimeZone::availableTimeZoneIds(QLocale::Country)
    // 2: static QTimeZone::availableTimeZoneIds(int)
    if (numArgs == 0) {
        overloadId = 0; // availableTimeZoneIds()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // availableTimeZoneIds(QLocale::Country)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // availableTimeZoneIds(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_availableTimeZoneIds_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // availableTimeZoneIds()
        {

            if (!PyErr_Occurred()) {
                // availableTimeZoneIds()
                QList<QByteArray > cppResult = ::QTimeZone::availableTimeZoneIds();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], &cppResult);
            }
            break;
        }
        case 1: // availableTimeZoneIds(QLocale::Country country)
        {
            ::QLocale::Country cppArg0{QLocale::AnyCountry};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // availableTimeZoneIds(QLocale::Country)
                QList<QByteArray > cppResult = ::QTimeZone::availableTimeZoneIds(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], &cppResult);
            }
            break;
        }
        case 2: // availableTimeZoneIds(int offsetSeconds)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // availableTimeZoneIds(int)
                QList<QByteArray > cppResult = ::QTimeZone::availableTimeZoneIds(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_availableTimeZoneIds_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_comment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.comment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // comment()const
            QString cppResult = const_cast<const ::QTimeZone *>(cppSelf)->comment();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeZoneFunc_country(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.country";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // country()const
            QLocale::Country cppResult = const_cast<const ::QTimeZone *>(cppSelf)->country();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeZoneFunc_daylightTimeOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.daylightTimeOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeZone::daylightTimeOffset(QDateTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // daylightTimeOffset(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_daylightTimeOffset_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // daylightTimeOffset(QDateTime)const
            int cppResult = const_cast<const ::QTimeZone *>(cppSelf)->daylightTimeOffset(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_daylightTimeOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_displayName(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.displayName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTimeZoneFunc_displayName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTimeZoneFunc_displayName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:displayName", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QTimeZone::displayName(QTimeZone::TimeType,QTimeZone::NameType,QLocale)const
    // 1: QTimeZone::displayName(QDateTime,QTimeZone::NameType,QLocale)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // displayName(QDateTime,QTimeZone::NameType,QLocale)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // displayName(QDateTime,QTimeZone::NameType,QLocale)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArgs[2])))) {
                overloadId = 1; // displayName(QDateTime,QTimeZone::NameType,QLocale)const
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_TIMETYPE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // displayName(QTimeZone::TimeType,QTimeZone::NameType,QLocale)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // displayName(QTimeZone::TimeType,QTimeZone::NameType,QLocale)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArgs[2])))) {
                overloadId = 0; // displayName(QTimeZone::TimeType,QTimeZone::NameType,QLocale)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_displayName_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // displayName(QTimeZone::TimeType timeType, QTimeZone::NameType nameType, const QLocale & locale) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_nameType = Shiboken::String::createStaticString("nameType");
                if (PyDict_Contains(kwds, key_nameType)) {
                    value = PyDict_GetItem(kwds, key_nameType);
                    if (value && pyArgs[1]) {
                        errInfo = key_nameType;
                        Py_INCREF(errInfo);
                        goto Sbk_QTimeZoneFunc_displayName_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QTimeZoneFunc_displayName_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_nameType);
                }
                static PyObject *const key_locale = Shiboken::String::createStaticString("locale");
                if (PyDict_Contains(kwds, key_locale)) {
                    value = PyDict_GetItem(kwds, key_locale);
                    if (value && pyArgs[2]) {
                        errInfo = key_locale;
                        Py_INCREF(errInfo);
                        goto Sbk_QTimeZoneFunc_displayName_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArgs[2]))))
                            goto Sbk_QTimeZoneFunc_displayName_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_locale);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTimeZoneFunc_displayName_TypeError;
                }
            }
            ::QTimeZone::TimeType cppArg0{QTimeZone::StandardTime};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QTimeZone::NameType cppArg1 = QTimeZone::DefaultName;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QLocale cppArg2_local = QLocale();
            ::QLocale *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

            if (!PyErr_Occurred()) {
                // displayName(QTimeZone::TimeType,QTimeZone::NameType,QLocale)const
                QString cppResult = const_cast<const ::QTimeZone *>(cppSelf)->displayName(cppArg0, cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // displayName(const QDateTime & atDateTime, QTimeZone::NameType nameType, const QLocale & locale) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_nameType = Shiboken::String::createStaticString("nameType");
                if (PyDict_Contains(kwds, key_nameType)) {
                    value = PyDict_GetItem(kwds, key_nameType);
                    if (value && pyArgs[1]) {
                        errInfo = key_nameType;
                        Py_INCREF(errInfo);
                        goto Sbk_QTimeZoneFunc_displayName_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QTimeZoneFunc_displayName_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_nameType);
                }
                static PyObject *const key_locale = Shiboken::String::createStaticString("locale");
                if (PyDict_Contains(kwds, key_locale)) {
                    value = PyDict_GetItem(kwds, key_locale);
                    if (value && pyArgs[2]) {
                        errInfo = key_locale;
                        Py_INCREF(errInfo);
                        goto Sbk_QTimeZoneFunc_displayName_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArgs[2]))))
                            goto Sbk_QTimeZoneFunc_displayName_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_locale);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTimeZoneFunc_displayName_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QDateTime cppArg0_local;
            ::QDateTime *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QTimeZone::NameType cppArg1 = QTimeZone::DefaultName;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QLocale cppArg2_local = QLocale();
            ::QLocale *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

            if (!PyErr_Occurred()) {
                // displayName(QDateTime,QTimeZone::NameType,QLocale)const
                QString cppResult = const_cast<const ::QTimeZone *>(cppSelf)->displayName(*cppArg0, cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_displayName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_hasDaylightTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.hasDaylightTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasDaylightTime()const
            bool cppResult = const_cast<const ::QTimeZone *>(cppSelf)->hasDaylightTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeZoneFunc_hasTransitions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.hasTransitions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasTransitions()const
            bool cppResult = const_cast<const ::QTimeZone *>(cppSelf)->hasTransitions();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeZoneFunc_ianaIdToWindowsId(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.ianaIdToWindowsId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QTimeZone::ianaIdToWindowsId(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // ianaIdToWindowsId(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_ianaIdToWindowsId_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // ianaIdToWindowsId(QByteArray)
            QByteArray cppResult = ::QTimeZone::ianaIdToWindowsId(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_ianaIdToWindowsId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.id";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // id()const
            QByteArray cppResult = const_cast<const ::QTimeZone *>(cppSelf)->id();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeZoneFunc_isDaylightTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.isDaylightTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeZone::isDaylightTime(QDateTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // isDaylightTime(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_isDaylightTime_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isDaylightTime(QDateTime)const
            bool cppResult = const_cast<const ::QTimeZone *>(cppSelf)->isDaylightTime(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_isDaylightTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_isTimeZoneIdAvailable(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.isTimeZoneIdAvailable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QTimeZone::isTimeZoneIdAvailable(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // isTimeZoneIdAvailable(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_isTimeZoneIdAvailable_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isTimeZoneIdAvailable(QByteArray)
            bool cppResult = ::QTimeZone::isTimeZoneIdAvailable(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_isTimeZoneIdAvailable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QTimeZone *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeZoneFunc_nextTransition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.nextTransition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeZone::nextTransition(QDateTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // nextTransition(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_nextTransition_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // nextTransition(QDateTime)const
            QTimeZone::OffsetData cppResult = const_cast<const ::QTimeZone *>(cppSelf)->nextTransition(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_nextTransition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_offsetData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.offsetData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeZone::offsetData(QDateTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // offsetData(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_offsetData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // offsetData(QDateTime)const
            QTimeZone::OffsetData cppResult = const_cast<const ::QTimeZone *>(cppSelf)->offsetData(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_offsetData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_offsetFromUtc(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.offsetFromUtc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeZone::offsetFromUtc(QDateTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // offsetFromUtc(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_offsetFromUtc_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // offsetFromUtc(QDateTime)const
            int cppResult = const_cast<const ::QTimeZone *>(cppSelf)->offsetFromUtc(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_offsetFromUtc_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_previousTransition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.previousTransition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeZone::previousTransition(QDateTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // previousTransition(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_previousTransition_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // previousTransition(QDateTime)const
            QTimeZone::OffsetData cppResult = const_cast<const ::QTimeZone *>(cppSelf)->previousTransition(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_OFFSETDATA_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_previousTransition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_standardTimeOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.standardTimeOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeZone::standardTimeOffset(QDateTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // standardTimeOffset(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_standardTimeOffset_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // standardTimeOffset(QDateTime)const
            int cppResult = const_cast<const ::QTimeZone *>(cppSelf)->standardTimeOffset(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_standardTimeOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTimeZone::swap(QTimeZone&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QTimeZone&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTimeZone cppArg0_local;
        ::QTimeZone *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QTimeZone&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTimeZoneFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_systemTimeZone(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.systemTimeZone";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // systemTimeZone()
            QTimeZone cppResult = ::QTimeZone::systemTimeZone();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeZoneFunc_systemTimeZoneId(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.systemTimeZoneId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // systemTimeZoneId()
            QByteArray cppResult = ::QTimeZone::systemTimeZoneId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeZoneFunc_transitions(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.transitions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "transitions", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTimeZone::transitions(QDateTime,QDateTime)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArgs[1])))) {
        overloadId = 0; // transitions(QDateTime,QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_transitions_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QDateTime cppArg1_local;
        ::QDateTime *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // transitions(QDateTime,QDateTime)const
            QVector<QTimeZone::OffsetData > cppResult = const_cast<const ::QTimeZone *>(cppSelf)->transitions(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QVECTOR_QTIMEZONE_OFFSETDATA_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_transitions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_utc(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.utc";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // utc()
            QTimeZone cppResult = ::QTimeZone::utc();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTimeZoneFunc_windowsIdToDefaultIanaId(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.windowsIdToDefaultIanaId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "windowsIdToDefaultIanaId", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTimeZone::windowsIdToDefaultIanaId(QByteArray)
    // 1: static QTimeZone::windowsIdToDefaultIanaId(QByteArray,QLocale::Country)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // windowsIdToDefaultIanaId(QByteArray)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // windowsIdToDefaultIanaId(QByteArray,QLocale::Country)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_windowsIdToDefaultIanaId_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // windowsIdToDefaultIanaId(const QByteArray & windowsId)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // windowsIdToDefaultIanaId(QByteArray)
                QByteArray cppResult = ::QTimeZone::windowsIdToDefaultIanaId(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // windowsIdToDefaultIanaId(const QByteArray & windowsId, QLocale::Country country)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QLocale::Country cppArg1{QLocale::AnyCountry};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // windowsIdToDefaultIanaId(QByteArray,QLocale::Country)
                QByteArray cppResult = ::QTimeZone::windowsIdToDefaultIanaId(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_windowsIdToDefaultIanaId_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZoneFunc_windowsIdToIanaIds(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTimeZone.windowsIdToIanaIds";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "windowsIdToIanaIds", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTimeZone::windowsIdToIanaIds(QByteArray)
    // 1: static QTimeZone::windowsIdToIanaIds(QByteArray,QLocale::Country)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // windowsIdToIanaIds(QByteArray)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // windowsIdToIanaIds(QByteArray,QLocale::Country)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTimeZoneFunc_windowsIdToIanaIds_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // windowsIdToIanaIds(const QByteArray & windowsId)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // windowsIdToIanaIds(QByteArray)
                QList<QByteArray > cppResult = ::QTimeZone::windowsIdToIanaIds(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], &cppResult);
            }
            break;
        }
        case 1: // windowsIdToIanaIds(const QByteArray & windowsId, QLocale::Country country)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QLocale::Country cppArg1{QLocale::AnyCountry};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // windowsIdToIanaIds(QByteArray,QLocale::Country)
                QList<QByteArray > cppResult = ::QTimeZone::windowsIdToIanaIds(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTimeZoneFunc_windowsIdToIanaIds_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTimeZone___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTimeZone_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTimeZone_methods[] = {
    {"abbreviation", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_abbreviation), METH_O},
    {"availableTimeZoneIds", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_availableTimeZoneIds), METH_VARARGS|METH_STATIC},
    {"comment", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_comment), METH_NOARGS},
    {"country", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_country), METH_NOARGS},
    {"daylightTimeOffset", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_daylightTimeOffset), METH_O},
    {"displayName", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_displayName), METH_VARARGS|METH_KEYWORDS},
    {"hasDaylightTime", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_hasDaylightTime), METH_NOARGS},
    {"hasTransitions", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_hasTransitions), METH_NOARGS},
    {"ianaIdToWindowsId", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_ianaIdToWindowsId), METH_O|METH_STATIC},
    {"id", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_id), METH_NOARGS},
    {"isDaylightTime", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_isDaylightTime), METH_O},
    {"isTimeZoneIdAvailable", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_isTimeZoneIdAvailable), METH_O|METH_STATIC},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_isValid), METH_NOARGS},
    {"nextTransition", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_nextTransition), METH_O},
    {"offsetData", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_offsetData), METH_O},
    {"offsetFromUtc", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_offsetFromUtc), METH_O},
    {"previousTransition", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_previousTransition), METH_O},
    {"standardTimeOffset", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_standardTimeOffset), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_swap), METH_O},
    {"systemTimeZone", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_systemTimeZone), METH_NOARGS|METH_STATIC},
    {"systemTimeZoneId", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_systemTimeZoneId), METH_NOARGS|METH_STATIC},
    {"transitions", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_transitions), METH_VARARGS},
    {"utc", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_utc), METH_NOARGS|METH_STATIC},
    {"windowsIdToDefaultIanaId", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_windowsIdToDefaultIanaId), METH_VARARGS|METH_STATIC},
    {"windowsIdToIanaIds", reinterpret_cast<PyCFunction>(Sbk_QTimeZoneFunc_windowsIdToIanaIds), METH_VARARGS|METH_STATIC},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTimeZone___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QTimeZone_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArg)))) {
                // operator!=(const QTimeZone & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTimeZone cppArg0_local;
                ::QTimeZone *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArg)))) {
                // operator==(const QTimeZone & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTimeZone cppArg0_local;
                ::QTimeZone *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QTimeZone_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QTimeZone_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QTimeZone_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTimeZone_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QTimeZone__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTimeZone_Type = nullptr;
static SbkObjectType *Sbk_QTimeZone_TypeF(void)
{
    return _Sbk_QTimeZone_Type;
}

static PyType_Slot Sbk_QTimeZone_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QTimeZone__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTimeZone_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTimeZone_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QTimeZone_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTimeZone_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTimeZone_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTimeZone_spec = {
    "2:PySide2.QtCore.QTimeZone",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTimeZone_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QTimeZone_TimeType_PythonToCpp_QTimeZone_TimeType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTimeZone::TimeType *>(cppOut) =
        static_cast<::QTimeZone::TimeType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTimeZone_TimeType_PythonToCpp_QTimeZone_TimeType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_TIMETYPE_IDX]))
        return QTimeZone_TimeType_PythonToCpp_QTimeZone_TimeType;
    return {};
}
static PyObject *QTimeZone_TimeType_CppToPython_QTimeZone_TimeType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTimeZone::TimeType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_TIMETYPE_IDX], castCppIn);

}

static void QTimeZone_NameType_PythonToCpp_QTimeZone_NameType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTimeZone::NameType *>(cppOut) =
        static_cast<::QTimeZone::NameType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTimeZone_NameType_PythonToCpp_QTimeZone_NameType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX]))
        return QTimeZone_NameType_PythonToCpp_QTimeZone_NameType;
    return {};
}
static PyObject *QTimeZone_NameType_CppToPython_QTimeZone_NameType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTimeZone::NameType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTimeZone_PythonToCpp_QTimeZone_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTimeZone_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTimeZone_PythonToCpp_QTimeZone_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTimeZone_TypeF())))
        return QTimeZone_PythonToCpp_QTimeZone_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTimeZone_PTR_CppToPython_QTimeZone(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTimeZone *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTimeZone_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTimeZone_COPY_CppToPython_QTimeZone(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTimeZone_TypeF(), new ::QTimeZone(*reinterpret_cast<const ::QTimeZone *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTimeZone_PythonToCpp_QTimeZone_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTimeZone *>(cppOut) = *reinterpret_cast< ::QTimeZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTimeZone_PythonToCpp_QTimeZone_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTimeZone_TypeF())))
        return QTimeZone_PythonToCpp_QTimeZone_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTimeZone_SignatureStrings[] = {
    "4:PySide2.QtCore.QTimeZone(self)",
    "3:PySide2.QtCore.QTimeZone(self,ianaId:PySide2.QtCore.QByteArray)",
    "2:PySide2.QtCore.QTimeZone(self,zoneId:PySide2.QtCore.QByteArray,offsetSeconds:int,name:QString,abbreviation:QString,country:PySide2.QtCore.QLocale.Country=QLocale.AnyCountry,comment:QString=QString())",
    "1:PySide2.QtCore.QTimeZone(self,other:PySide2.QtCore.QTimeZone)",
    "0:PySide2.QtCore.QTimeZone(self,offsetSeconds:int)",
    "PySide2.QtCore.QTimeZone.abbreviation(self,atDateTime:PySide2.QtCore.QDateTime)->QString",
    "2:PySide2.QtCore.QTimeZone.availableTimeZoneIds()->QList[PySide2.QtCore.QByteArray]",
    "1:PySide2.QtCore.QTimeZone.availableTimeZoneIds(country:PySide2.QtCore.QLocale.Country)->QList[PySide2.QtCore.QByteArray]",
    "0:PySide2.QtCore.QTimeZone.availableTimeZoneIds(offsetSeconds:int)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtCore.QTimeZone.comment(self)->QString",
    "PySide2.QtCore.QTimeZone.country(self)->PySide2.QtCore.QLocale.Country",
    "PySide2.QtCore.QTimeZone.daylightTimeOffset(self,atDateTime:PySide2.QtCore.QDateTime)->int",
    "1:PySide2.QtCore.QTimeZone.displayName(self,timeType:PySide2.QtCore.QTimeZone.TimeType,nameType:PySide2.QtCore.QTimeZone.NameType=QTimeZone.DefaultName,locale:PySide2.QtCore.QLocale=QLocale())->QString",
    "0:PySide2.QtCore.QTimeZone.displayName(self,atDateTime:PySide2.QtCore.QDateTime,nameType:PySide2.QtCore.QTimeZone.NameType=QTimeZone.DefaultName,locale:PySide2.QtCore.QLocale=QLocale())->QString",
    "PySide2.QtCore.QTimeZone.hasDaylightTime(self)->bool",
    "PySide2.QtCore.QTimeZone.hasTransitions(self)->bool",
    "PySide2.QtCore.QTimeZone.ianaIdToWindowsId(ianaId:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QTimeZone.id(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QTimeZone.isDaylightTime(self,atDateTime:PySide2.QtCore.QDateTime)->bool",
    "PySide2.QtCore.QTimeZone.isTimeZoneIdAvailable(ianaId:PySide2.QtCore.QByteArray)->bool",
    "PySide2.QtCore.QTimeZone.isValid(self)->bool",
    "PySide2.QtCore.QTimeZone.nextTransition(self,afterDateTime:PySide2.QtCore.QDateTime)->PySide2.QtCore.QTimeZone.OffsetData",
    "PySide2.QtCore.QTimeZone.offsetData(self,forDateTime:PySide2.QtCore.QDateTime)->PySide2.QtCore.QTimeZone.OffsetData",
    "PySide2.QtCore.QTimeZone.offsetFromUtc(self,atDateTime:PySide2.QtCore.QDateTime)->int",
    "PySide2.QtCore.QTimeZone.previousTransition(self,beforeDateTime:PySide2.QtCore.QDateTime)->PySide2.QtCore.QTimeZone.OffsetData",
    "PySide2.QtCore.QTimeZone.standardTimeOffset(self,atDateTime:PySide2.QtCore.QDateTime)->int",
    "PySide2.QtCore.QTimeZone.swap(self,other:PySide2.QtCore.QTimeZone)",
    "PySide2.QtCore.QTimeZone.systemTimeZone()->PySide2.QtCore.QTimeZone",
    "PySide2.QtCore.QTimeZone.systemTimeZoneId()->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QTimeZone.transitions(self,fromDateTime:PySide2.QtCore.QDateTime,toDateTime:PySide2.QtCore.QDateTime)->QVector[PySide2.QtCore.QTimeZone.OffsetData]",
    "PySide2.QtCore.QTimeZone.utc()->PySide2.QtCore.QTimeZone",
    "1:PySide2.QtCore.QTimeZone.windowsIdToDefaultIanaId(windowsId:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QTimeZone.windowsIdToDefaultIanaId(windowsId:PySide2.QtCore.QByteArray,country:PySide2.QtCore.QLocale.Country)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QTimeZone.windowsIdToIanaIds(windowsId:PySide2.QtCore.QByteArray)->QList[PySide2.QtCore.QByteArray]",
    "0:PySide2.QtCore.QTimeZone.windowsIdToIanaIds(windowsId:PySide2.QtCore.QByteArray,country:PySide2.QtCore.QLocale.Country)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtCore.QTimeZone.__copy__()",
    nullptr}; // Sentinel

void init_QTimeZone(PyObject *module)
{
    _Sbk_QTimeZone_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTimeZone",
        "QTimeZone",
        &Sbk_QTimeZone_spec,
        &Shiboken::callCppDestructor< ::QTimeZone >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTimeZone_Type);
    InitSignatureStrings(pyType, QTimeZone_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTimeZone_Type), Sbk_QTimeZone_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTimeZone_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTimeZone_TypeF(),
        QTimeZone_PythonToCpp_QTimeZone_PTR,
        is_QTimeZone_PythonToCpp_QTimeZone_PTR_Convertible,
        QTimeZone_PTR_CppToPython_QTimeZone,
        QTimeZone_COPY_CppToPython_QTimeZone);

    Shiboken::Conversions::registerConverterName(converter, "QTimeZone");
    Shiboken::Conversions::registerConverterName(converter, "QTimeZone*");
    Shiboken::Conversions::registerConverterName(converter, "QTimeZone&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTimeZone).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTimeZone_PythonToCpp_QTimeZone_COPY,
        is_QTimeZone_PythonToCpp_QTimeZone_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'TimeType'.
    SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_TIMETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTimeZone_TypeF(),
        "TimeType",
        "2:PySide2.QtCore.QTimeZone.TimeType",
        "QTimeZone::TimeType");
    if (!SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_TIMETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_TIMETYPE_IDX],
        Sbk_QTimeZone_TypeF(), "StandardTime", (long) QTimeZone::TimeType::StandardTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_TIMETYPE_IDX],
        Sbk_QTimeZone_TypeF(), "DaylightTime", (long) QTimeZone::TimeType::DaylightTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_TIMETYPE_IDX],
        Sbk_QTimeZone_TypeF(), "GenericTime", (long) QTimeZone::TimeType::GenericTime))
        return;
    // Register converter for enum 'QTimeZone::TimeType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_TIMETYPE_IDX],
            QTimeZone_TimeType_CppToPython_QTimeZone_TimeType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTimeZone_TimeType_PythonToCpp_QTimeZone_TimeType,
            is_QTimeZone_TimeType_PythonToCpp_QTimeZone_TimeType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_TIMETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTimeZone::TimeType");
        Shiboken::Conversions::registerConverterName(converter, "TimeType");
    }
    // End of 'TimeType' enum.

    // Initialization of enum 'NameType'.
    SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTimeZone_TypeF(),
        "NameType",
        "2:PySide2.QtCore.QTimeZone.NameType",
        "QTimeZone::NameType");
    if (!SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX],
        Sbk_QTimeZone_TypeF(), "DefaultName", (long) QTimeZone::NameType::DefaultName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX],
        Sbk_QTimeZone_TypeF(), "LongName", (long) QTimeZone::NameType::LongName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX],
        Sbk_QTimeZone_TypeF(), "ShortName", (long) QTimeZone::NameType::ShortName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX],
        Sbk_QTimeZone_TypeF(), "OffsetName", (long) QTimeZone::NameType::OffsetName))
        return;
    // Register converter for enum 'QTimeZone::NameType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX],
            QTimeZone_NameType_CppToPython_QTimeZone_NameType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTimeZone_NameType_PythonToCpp_QTimeZone_NameType,
            is_QTimeZone_NameType_PythonToCpp_QTimeZone_NameType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_NAMETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTimeZone::NameType");
        Shiboken::Conversions::registerConverterName(converter, "NameType");
    }
    // End of 'NameType' enum.

    qRegisterMetaType< ::QTimeZone >("QTimeZone");
    qRegisterMetaType< ::QTimeZone::TimeType >("QTimeZone::TimeType");
    qRegisterMetaType< ::QTimeZone::NameType >("QTimeZone::NameType");
}
