/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qtextstreammanipulator_wrapper.h"

// inner classes

// Extra includes
#include <qtextstream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QTextStreamManipulatorFunc_exec_(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextStreamManipulator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAMMANIPULATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QTextStreamManipulator.exec_";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextStreamManipulator::exec(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // exec(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextStreamManipulatorFunc_exec__TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // exec(QTextStream&)
            cppSelf->exec(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextStreamManipulatorFunc_exec__TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextStreamManipulator___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextStreamManipulator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAMMANIPULATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAMMANIPULATOR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextStreamManipulator_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextStreamManipulator_methods[] = {
    {"exec_", reinterpret_cast<PyCFunction>(Sbk_QTextStreamManipulatorFunc_exec_), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextStreamManipulator___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextStreamManipulator_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextStreamManipulator_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextStreamManipulator_Type = nullptr;
static SbkObjectType *Sbk_QTextStreamManipulator_TypeF(void)
{
    return _Sbk_QTextStreamManipulator_Type;
}

static PyType_Slot Sbk_QTextStreamManipulator_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextStreamManipulator_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextStreamManipulator_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextStreamManipulator_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextStreamManipulator_spec = {
    "2:PySide2.QtCore.QTextStreamManipulator",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextStreamManipulator_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextStreamManipulator_PythonToCpp_QTextStreamManipulator_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextStreamManipulator_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextStreamManipulator_PythonToCpp_QTextStreamManipulator_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextStreamManipulator_TypeF())))
        return QTextStreamManipulator_PythonToCpp_QTextStreamManipulator_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextStreamManipulator_PTR_CppToPython_QTextStreamManipulator(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextStreamManipulator *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextStreamManipulator_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextStreamManipulator_COPY_CppToPython_QTextStreamManipulator(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextStreamManipulator_TypeF(), new ::QTextStreamManipulator(*reinterpret_cast<const ::QTextStreamManipulator *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextStreamManipulator_PythonToCpp_QTextStreamManipulator_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextStreamManipulator *>(cppOut) = *reinterpret_cast< ::QTextStreamManipulator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAMMANIPULATOR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextStreamManipulator_PythonToCpp_QTextStreamManipulator_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextStreamManipulator_TypeF())))
        return QTextStreamManipulator_PythonToCpp_QTextStreamManipulator_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextStreamManipulator_SignatureStrings[] = {
    "PySide2.QtCore.QTextStreamManipulator.exec_(self,s:PySide2.QtCore.QTextStream)",
    "PySide2.QtCore.QTextStreamManipulator.__copy__()",
    nullptr}; // Sentinel

void init_QTextStreamManipulator(PyObject *module)
{
    _Sbk_QTextStreamManipulator_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextStreamManipulator",
        "QTextStreamManipulator",
        &Sbk_QTextStreamManipulator_spec,
        &Shiboken::callCppDestructor< ::QTextStreamManipulator >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextStreamManipulator_Type);
    InitSignatureStrings(pyType, QTextStreamManipulator_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextStreamManipulator_Type), Sbk_QTextStreamManipulator_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAMMANIPULATOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextStreamManipulator_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextStreamManipulator_TypeF(),
        QTextStreamManipulator_PythonToCpp_QTextStreamManipulator_PTR,
        is_QTextStreamManipulator_PythonToCpp_QTextStreamManipulator_PTR_Convertible,
        QTextStreamManipulator_PTR_CppToPython_QTextStreamManipulator,
        QTextStreamManipulator_COPY_CppToPython_QTextStreamManipulator);

    Shiboken::Conversions::registerConverterName(converter, "QTextStreamManipulator");
    Shiboken::Conversions::registerConverterName(converter, "QTextStreamManipulator*");
    Shiboken::Conversions::registerConverterName(converter, "QTextStreamManipulator&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextStreamManipulator).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextStreamManipulator_PythonToCpp_QTextStreamManipulator_COPY,
        is_QTextStreamManipulator_PythonToCpp_QTextStreamManipulator_COPY_Convertible);

}
