/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qt_wrapper.h"

// inner classes

// Extra includes
#include <qtextstream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QtFunc_bin(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.bin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::bin(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // bin(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_bin_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // bin(QTextStream&)
            QTextStream & cppResult = ::Qt::bin(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_bin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_bom(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.bom";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::bom(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // bom(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_bom_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // bom(QTextStream&)
            QTextStream & cppResult = ::Qt::bom(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_bom_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_center(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.center";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::center(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // center(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_center_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // center(QTextStream&)
            QTextStream & cppResult = ::Qt::center(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_center_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_dec(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.dec";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::dec(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // dec(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_dec_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dec(QTextStream&)
            QTextStream & cppResult = ::Qt::dec(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_dec_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_endl(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.endl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::endl(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // endl(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_endl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // endl(QTextStream&)
            QTextStream & cppResult = ::Qt::endl(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_endl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_fixed(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.fixed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::fixed(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // fixed(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_fixed_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fixed(QTextStream&)
            QTextStream & cppResult = ::Qt::fixed(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_fixed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_flush(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.flush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::flush(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // flush(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_flush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // flush(QTextStream&)
            QTextStream & cppResult = ::Qt::flush(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_flush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_forcepoint(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.forcepoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::forcepoint(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // forcepoint(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_forcepoint_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // forcepoint(QTextStream&)
            QTextStream & cppResult = ::Qt::forcepoint(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_forcepoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_forcesign(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.forcesign";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::forcesign(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // forcesign(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_forcesign_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // forcesign(QTextStream&)
            QTextStream & cppResult = ::Qt::forcesign(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_forcesign_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_hex(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.hex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::hex(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // hex(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_hex_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hex(QTextStream&)
            QTextStream & cppResult = ::Qt::hex(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_hex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_left(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.left";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::left(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // left(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_left_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // left(QTextStream&)
            QTextStream & cppResult = ::Qt::left(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_left_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_lowercasebase(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.lowercasebase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::lowercasebase(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // lowercasebase(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_lowercasebase_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // lowercasebase(QTextStream&)
            QTextStream & cppResult = ::Qt::lowercasebase(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_lowercasebase_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_lowercasedigits(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.lowercasedigits";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::lowercasedigits(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // lowercasedigits(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_lowercasedigits_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // lowercasedigits(QTextStream&)
            QTextStream & cppResult = ::Qt::lowercasedigits(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_lowercasedigits_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_noforcepoint(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.noforcepoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::noforcepoint(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // noforcepoint(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_noforcepoint_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // noforcepoint(QTextStream&)
            QTextStream & cppResult = ::Qt::noforcepoint(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_noforcepoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_noforcesign(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.noforcesign";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::noforcesign(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // noforcesign(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_noforcesign_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // noforcesign(QTextStream&)
            QTextStream & cppResult = ::Qt::noforcesign(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_noforcesign_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_noshowbase(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.noshowbase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::noshowbase(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // noshowbase(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_noshowbase_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // noshowbase(QTextStream&)
            QTextStream & cppResult = ::Qt::noshowbase(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_noshowbase_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_oct(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.oct";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::oct(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // oct(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_oct_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // oct(QTextStream&)
            QTextStream & cppResult = ::Qt::oct(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_oct_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_reset(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.reset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::reset(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // reset(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_reset_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // reset(QTextStream&)
            QTextStream & cppResult = ::Qt::reset(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_reset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_right(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.right";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::right(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // right(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_right_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // right(QTextStream&)
            QTextStream & cppResult = ::Qt::right(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_right_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_scientific(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.scientific";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::scientific(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // scientific(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_scientific_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // scientific(QTextStream&)
            QTextStream & cppResult = ::Qt::scientific(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_scientific_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_showbase(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.showbase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::showbase(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // showbase(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_showbase_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // showbase(QTextStream&)
            QTextStream & cppResult = ::Qt::showbase(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_showbase_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_uppercasebase(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.uppercasebase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::uppercasebase(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // uppercasebase(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_uppercasebase_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // uppercasebase(QTextStream&)
            QTextStream & cppResult = ::Qt::uppercasebase(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_uppercasebase_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_uppercasedigits(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.uppercasedigits";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::uppercasedigits(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // uppercasedigits(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_uppercasedigits_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // uppercasedigits(QTextStream&)
            QTextStream & cppResult = ::Qt::uppercasedigits(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_uppercasedigits_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtFunc_ws(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.Qt.ws";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt::ws(QTextStream&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
        overloadId = 0; // ws(QTextStream&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtFunc_ws_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // ws(QTextStream&)
            QTextStream & cppResult = ::Qt::ws(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtFunc_ws_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_Qt_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt_methods[] = {
    {"bin", reinterpret_cast<PyCFunction>(Sbk_QtFunc_bin), METH_O|METH_STATIC},
    {"bom", reinterpret_cast<PyCFunction>(Sbk_QtFunc_bom), METH_O|METH_STATIC},
    {"center", reinterpret_cast<PyCFunction>(Sbk_QtFunc_center), METH_O|METH_STATIC},
    {"dec", reinterpret_cast<PyCFunction>(Sbk_QtFunc_dec), METH_O|METH_STATIC},
    {"endl", reinterpret_cast<PyCFunction>(Sbk_QtFunc_endl), METH_O|METH_STATIC},
    {"fixed", reinterpret_cast<PyCFunction>(Sbk_QtFunc_fixed), METH_O|METH_STATIC},
    {"flush", reinterpret_cast<PyCFunction>(Sbk_QtFunc_flush), METH_O|METH_STATIC},
    {"forcepoint", reinterpret_cast<PyCFunction>(Sbk_QtFunc_forcepoint), METH_O|METH_STATIC},
    {"forcesign", reinterpret_cast<PyCFunction>(Sbk_QtFunc_forcesign), METH_O|METH_STATIC},
    {"hex", reinterpret_cast<PyCFunction>(Sbk_QtFunc_hex), METH_O|METH_STATIC},
    {"left", reinterpret_cast<PyCFunction>(Sbk_QtFunc_left), METH_O|METH_STATIC},
    {"lowercasebase", reinterpret_cast<PyCFunction>(Sbk_QtFunc_lowercasebase), METH_O|METH_STATIC},
    {"lowercasedigits", reinterpret_cast<PyCFunction>(Sbk_QtFunc_lowercasedigits), METH_O|METH_STATIC},
    {"noforcepoint", reinterpret_cast<PyCFunction>(Sbk_QtFunc_noforcepoint), METH_O|METH_STATIC},
    {"noforcesign", reinterpret_cast<PyCFunction>(Sbk_QtFunc_noforcesign), METH_O|METH_STATIC},
    {"noshowbase", reinterpret_cast<PyCFunction>(Sbk_QtFunc_noshowbase), METH_O|METH_STATIC},
    {"oct", reinterpret_cast<PyCFunction>(Sbk_QtFunc_oct), METH_O|METH_STATIC},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QtFunc_reset), METH_O|METH_STATIC},
    {"right", reinterpret_cast<PyCFunction>(Sbk_QtFunc_right), METH_O|METH_STATIC},
    {"scientific", reinterpret_cast<PyCFunction>(Sbk_QtFunc_scientific), METH_O|METH_STATIC},
    {"showbase", reinterpret_cast<PyCFunction>(Sbk_QtFunc_showbase), METH_O|METH_STATIC},
    {"uppercasebase", reinterpret_cast<PyCFunction>(Sbk_QtFunc_uppercasebase), METH_O|METH_STATIC},
    {"uppercasedigits", reinterpret_cast<PyCFunction>(Sbk_QtFunc_uppercasedigits), METH_O|METH_STATIC},
    {"ws", reinterpret_cast<PyCFunction>(Sbk_QtFunc_ws), METH_O|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Qt_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt_Type = nullptr;
static SbkObjectType *Sbk_Qt_TypeF(void)
{
    return _Sbk_Qt_Type;
}

static PyType_Slot Sbk_Qt_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt_spec = {
    "2:PySide2.QtCore.Qt",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_Qt_KeyboardModifier___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::KeyboardModifiers cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::KeyboardModifiers>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::KeyboardModifiers>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::KeyboardModifiers>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::KeyboardModifiers>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_KeyboardModifier___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::KeyboardModifiers cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::KeyboardModifiers>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::KeyboardModifiers>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::KeyboardModifiers>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::KeyboardModifiers>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_KeyboardModifier___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::KeyboardModifiers cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::KeyboardModifiers>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::KeyboardModifiers>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::KeyboardModifiers>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::KeyboardModifiers>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_KeyboardModifier___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::KeyboardModifiers cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, self, &cppSelf);
    ::Qt::KeyboardModifiers cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_KeyboardModifier_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_KeyboardModifier__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_KeyboardModifier_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_KeyboardModifier__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_KeyboardModifier__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_KeyboardModifier_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_KeyboardModifier___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_KeyboardModifier___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_KeyboardModifier___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_KeyboardModifier___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_KeyboardModifier_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_KeyboardModifier_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_KeyboardModifier_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_MouseButton___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MouseButtons cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::MouseButtons>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::MouseButtons>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::MouseButtons>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::MouseButtons>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_MouseButton___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MouseButtons cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::MouseButtons>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::MouseButtons>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::MouseButtons>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::MouseButtons>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_MouseButton___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MouseButtons cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::MouseButtons>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::MouseButtons>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::MouseButtons>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::MouseButtons>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_MouseButton___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MouseButtons cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, self, &cppSelf);
    ::Qt::MouseButtons cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_MouseButton_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_MouseButton__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_MouseButton_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseButton__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseButton__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseButton_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseButton___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseButton___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseButton___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseButton___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseButton_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseButton_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseButton_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_Orientation___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Orientations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::Orientations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::Orientations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::Orientations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::Orientations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_Orientation___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Orientations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::Orientations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::Orientations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::Orientations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::Orientations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_Orientation___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Orientations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::Orientations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::Orientations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::Orientations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::Orientations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_Orientation___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Orientations cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, self, &cppSelf);
    ::Qt::Orientations cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_Orientation_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_Orientation__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_Orientation_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Orientation__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Orientation__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Orientation_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Orientation___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Orientation___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Orientation___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Orientation___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Orientation_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Orientation_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Orientation_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_SplitBehaviorFlags___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::SplitBehavior cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::SplitBehavior>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::SplitBehavior>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::SplitBehavior>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::SplitBehavior>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_SplitBehaviorFlags___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::SplitBehavior cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::SplitBehavior>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::SplitBehavior>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::SplitBehavior>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::SplitBehavior>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_SplitBehaviorFlags___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::SplitBehavior cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::SplitBehavior>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::SplitBehavior>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::SplitBehavior>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::SplitBehavior>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_SplitBehaviorFlags___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::SplitBehavior cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX])->converter, self, &cppSelf);
    ::Qt::SplitBehavior cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_SplitBehaviorFlags_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_SplitBehaviorFlags__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_SplitBehaviorFlags_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_SplitBehaviorFlags__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_SplitBehaviorFlags__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_SplitBehaviorFlags_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_SplitBehaviorFlags___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_SplitBehaviorFlags___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_SplitBehaviorFlags___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_SplitBehaviorFlags___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_SplitBehaviorFlags_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_SplitBehaviorFlags_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_SplitBehaviorFlags_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_AlignmentFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Alignment cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::Alignment>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::Alignment>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::Alignment>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::Alignment>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_AlignmentFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Alignment cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::Alignment>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::Alignment>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::Alignment>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::Alignment>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_AlignmentFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Alignment cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::Alignment>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::Alignment>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::Alignment>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::Alignment>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_AlignmentFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Alignment cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, self, &cppSelf);
    ::Qt::Alignment cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_AlignmentFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_AlignmentFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_AlignmentFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_AlignmentFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_AlignmentFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_AlignmentFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_AlignmentFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_AlignmentFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_AlignmentFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_AlignmentFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_AlignmentFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_AlignmentFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_AlignmentFlag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_WindowType___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::WindowFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::WindowFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::WindowFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::WindowFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::WindowFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_WindowType___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::WindowFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::WindowFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::WindowFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::WindowFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::WindowFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_WindowType___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::WindowFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::WindowFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::WindowFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::WindowFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::WindowFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_WindowType___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::WindowFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, self, &cppSelf);
    ::Qt::WindowFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_WindowType_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_WindowType__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_WindowType_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowType__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowType__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowType_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowType___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowType___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowType___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowType___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowType_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowType_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowType_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_WindowState___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::WindowStates cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::WindowStates>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::WindowStates>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::WindowStates>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::WindowStates>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_WindowState___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::WindowStates cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::WindowStates>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::WindowStates>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::WindowStates>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::WindowStates>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_WindowState___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::WindowStates cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::WindowStates>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::WindowStates>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::WindowStates>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::WindowStates>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_WindowState___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::WindowStates cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX])->converter, self, &cppSelf);
    ::Qt::WindowStates cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_WindowState_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_WindowState__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_WindowState_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowState__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowState__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowState_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowState___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowState___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowState___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowState___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowState_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowState_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_WindowState_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_ApplicationState___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ApplicationStates cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ApplicationStates>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ApplicationStates>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ApplicationStates>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ApplicationStates>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ApplicationState___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ApplicationStates cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ApplicationStates>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ApplicationStates>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ApplicationStates>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ApplicationStates>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ApplicationState___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ApplicationStates cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ApplicationStates>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ApplicationStates>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ApplicationStates>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ApplicationStates>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ApplicationState___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ApplicationStates cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX])->converter, self, &cppSelf);
    ::Qt::ApplicationStates cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_ApplicationState_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_ApplicationState__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_ApplicationState_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ApplicationState__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ApplicationState__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ApplicationState_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ApplicationState___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ApplicationState___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ApplicationState___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ApplicationState___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ApplicationState_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ApplicationState_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ApplicationState_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_ScreenOrientation___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ScreenOrientations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ScreenOrientations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ScreenOrientations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ScreenOrientations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ScreenOrientations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ScreenOrientation___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ScreenOrientations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ScreenOrientations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ScreenOrientations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ScreenOrientations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ScreenOrientations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ScreenOrientation___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ScreenOrientations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ScreenOrientations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ScreenOrientations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ScreenOrientations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ScreenOrientations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ScreenOrientation___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ScreenOrientations cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX])->converter, self, &cppSelf);
    ::Qt::ScreenOrientations cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_ScreenOrientation_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_ScreenOrientation__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_ScreenOrientation_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ScreenOrientation__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ScreenOrientation__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ScreenOrientation_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ScreenOrientation___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ScreenOrientation___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ScreenOrientation___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ScreenOrientation___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ScreenOrientation_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ScreenOrientation_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ScreenOrientation_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_ImageConversionFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ImageConversionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ImageConversionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ImageConversionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ImageConversionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ImageConversionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ImageConversionFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ImageConversionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ImageConversionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ImageConversionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ImageConversionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ImageConversionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ImageConversionFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ImageConversionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ImageConversionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ImageConversionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ImageConversionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ImageConversionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ImageConversionFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ImageConversionFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, self, &cppSelf);
    ::Qt::ImageConversionFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_ImageConversionFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_ImageConversionFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_ImageConversionFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ImageConversionFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ImageConversionFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ImageConversionFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ImageConversionFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ImageConversionFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ImageConversionFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ImageConversionFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ImageConversionFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ImageConversionFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ImageConversionFlag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_DockWidgetArea___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::DockWidgetAreas cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::DockWidgetAreas>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::DockWidgetAreas>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::DockWidgetAreas>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::DockWidgetAreas>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_DockWidgetArea___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::DockWidgetAreas cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::DockWidgetAreas>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::DockWidgetAreas>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::DockWidgetAreas>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::DockWidgetAreas>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_DockWidgetArea___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::DockWidgetAreas cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::DockWidgetAreas>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::DockWidgetAreas>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::DockWidgetAreas>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::DockWidgetAreas>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_DockWidgetArea___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::DockWidgetAreas cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX])->converter, self, &cppSelf);
    ::Qt::DockWidgetAreas cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_DockWidgetArea_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_DockWidgetArea__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_DockWidgetArea_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DockWidgetArea__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DockWidgetArea__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DockWidgetArea_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DockWidgetArea___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DockWidgetArea___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DockWidgetArea___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DockWidgetArea___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DockWidgetArea_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DockWidgetArea_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DockWidgetArea_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_ToolBarArea___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ToolBarAreas cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ToolBarAreas>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ToolBarAreas>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ToolBarAreas>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ToolBarAreas>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ToolBarArea___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ToolBarAreas cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ToolBarAreas>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ToolBarAreas>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ToolBarAreas>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ToolBarAreas>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ToolBarArea___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ToolBarAreas cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ToolBarAreas>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ToolBarAreas>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ToolBarAreas>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ToolBarAreas>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ToolBarArea___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ToolBarAreas cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX])->converter, self, &cppSelf);
    ::Qt::ToolBarAreas cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_ToolBarArea_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_ToolBarArea__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_ToolBarArea_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ToolBarArea__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ToolBarArea__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ToolBarArea_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ToolBarArea___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ToolBarArea___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ToolBarArea___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ToolBarArea___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ToolBarArea_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ToolBarArea_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ToolBarArea_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_Edge___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Edges cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::Edges>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::Edges>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::Edges>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::Edges>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_Edge___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Edges cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::Edges>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::Edges>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::Edges>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::Edges>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_Edge___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Edges cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::Edges>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::Edges>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::Edges>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::Edges>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_Edge___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::Edges cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX])->converter, self, &cppSelf);
    ::Qt::Edges cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_Edge_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_Edge__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_Edge_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Edge__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Edge__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Edge_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Edge___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Edge___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Edge___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Edge___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Edge_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Edge_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_Edge_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_InputMethodQuery___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::InputMethodQueries cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::InputMethodQueries>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodQueries>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::InputMethodQueries>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodQueries>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_InputMethodQuery___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::InputMethodQueries cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::InputMethodQueries>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodQueries>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::InputMethodQueries>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodQueries>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_InputMethodQuery___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::InputMethodQueries cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::InputMethodQueries>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodQueries>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::InputMethodQueries>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodQueries>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_InputMethodQuery___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::InputMethodQueries cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, self, &cppSelf);
    ::Qt::InputMethodQueries cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_InputMethodQuery_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_InputMethodQuery__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_InputMethodQuery_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodQuery__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodQuery__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodQuery_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodQuery___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodQuery___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodQuery___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodQuery___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodQuery_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodQuery_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodQuery_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_InputMethodHint___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::InputMethodHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::InputMethodHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::InputMethodHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_InputMethodHint___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::InputMethodHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::InputMethodHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::InputMethodHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_InputMethodHint___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::InputMethodHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::InputMethodHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::InputMethodHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::InputMethodHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_InputMethodHint___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::InputMethodHints cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX])->converter, self, &cppSelf);
    ::Qt::InputMethodHints cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_InputMethodHint_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_InputMethodHint__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_InputMethodHint_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodHint__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodHint__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodHint_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodHint___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodHint___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodHint___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodHint___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodHint_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodHint_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_InputMethodHint_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_FindChildOption___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::FindChildOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::FindChildOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::FindChildOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::FindChildOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::FindChildOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_FindChildOption___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::FindChildOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::FindChildOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::FindChildOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::FindChildOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::FindChildOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_FindChildOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::FindChildOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::FindChildOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::FindChildOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::FindChildOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::FindChildOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_FindChildOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::FindChildOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX])->converter, self, &cppSelf);
    ::Qt::FindChildOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_FindChildOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_FindChildOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_FindChildOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_FindChildOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_FindChildOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_FindChildOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_FindChildOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_FindChildOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_FindChildOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_FindChildOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_FindChildOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_FindChildOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_FindChildOption_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_DropAction___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::DropActions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::DropActions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::DropActions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::DropActions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::DropActions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_DropAction___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::DropActions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::DropActions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::DropActions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::DropActions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::DropActions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_DropAction___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::DropActions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::DropActions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::DropActions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::DropActions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::DropActions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_DropAction___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::DropActions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, self, &cppSelf);
    ::Qt::DropActions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_DropAction_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_DropAction__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_DropAction_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DropAction__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DropAction__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DropAction_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DropAction___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DropAction___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DropAction___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DropAction___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DropAction_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DropAction_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_DropAction_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_ItemFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ItemFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ItemFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ItemFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ItemFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ItemFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ItemFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ItemFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ItemFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ItemFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ItemFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ItemFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ItemFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ItemFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::ItemFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::ItemFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::ItemFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::ItemFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_ItemFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::ItemFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX])->converter, self, &cppSelf);
    ::Qt::ItemFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_ItemFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_ItemFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_ItemFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ItemFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ItemFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ItemFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ItemFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ItemFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ItemFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ItemFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ItemFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ItemFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_ItemFlag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_MatchFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MatchFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::MatchFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::MatchFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::MatchFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::MatchFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_MatchFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MatchFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::MatchFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::MatchFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::MatchFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::MatchFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_MatchFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MatchFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::MatchFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::MatchFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::MatchFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::MatchFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_MatchFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MatchFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX])->converter, self, &cppSelf);
    ::Qt::MatchFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_MatchFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_MatchFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_MatchFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MatchFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MatchFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MatchFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MatchFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MatchFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MatchFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MatchFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MatchFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MatchFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MatchFlag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_TextInteractionFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::TextInteractionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::TextInteractionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::TextInteractionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::TextInteractionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::TextInteractionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_TextInteractionFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::TextInteractionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::TextInteractionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::TextInteractionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::TextInteractionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::TextInteractionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_TextInteractionFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::TextInteractionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::TextInteractionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::TextInteractionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::TextInteractionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::TextInteractionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_TextInteractionFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::TextInteractionFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX])->converter, self, &cppSelf);
    ::Qt::TextInteractionFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_TextInteractionFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_TextInteractionFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_TextInteractionFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TextInteractionFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TextInteractionFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TextInteractionFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TextInteractionFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TextInteractionFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TextInteractionFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TextInteractionFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TextInteractionFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TextInteractionFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TextInteractionFlag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_TouchPointState___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::TouchPointStates cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::TouchPointStates>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::TouchPointStates>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::TouchPointStates>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::TouchPointStates>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_TouchPointState___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::TouchPointStates cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::TouchPointStates>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::TouchPointStates>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::TouchPointStates>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::TouchPointStates>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_TouchPointState___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::TouchPointStates cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::TouchPointStates>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::TouchPointStates>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::TouchPointStates>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::TouchPointStates>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_TouchPointState___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::TouchPointStates cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, self, &cppSelf);
    ::Qt::TouchPointStates cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_TouchPointState_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_TouchPointState__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_TouchPointState_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TouchPointState__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TouchPointState__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TouchPointState_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TouchPointState___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TouchPointState___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TouchPointState___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TouchPointState___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TouchPointState_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TouchPointState_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_TouchPointState_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_GestureFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::GestureFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::GestureFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::GestureFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::GestureFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::GestureFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_GestureFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::GestureFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::GestureFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::GestureFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::GestureFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::GestureFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_GestureFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::GestureFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::GestureFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::GestureFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::GestureFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::GestureFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_GestureFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::GestureFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX])->converter, self, &cppSelf);
    ::Qt::GestureFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_GestureFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_GestureFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_GestureFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_GestureFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_GestureFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_GestureFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_GestureFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_GestureFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_GestureFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_GestureFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_GestureFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_GestureFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_GestureFlag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_Qt_MouseEventFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MouseEventFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::MouseEventFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::MouseEventFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::MouseEventFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::MouseEventFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_MouseEventFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MouseEventFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::MouseEventFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::MouseEventFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::MouseEventFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::MouseEventFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_MouseEventFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MouseEventFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt::MouseEventFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt::MouseEventFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt::MouseEventFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt::MouseEventFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_Qt_MouseEventFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt::MouseEventFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX])->converter, self, &cppSelf);
    ::Qt::MouseEventFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_Qt_MouseEventFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_Qt_MouseEventFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_Qt_MouseEventFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseEventFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseEventFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseEventFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseEventFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseEventFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseEventFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseEventFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseEventFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseEventFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_Qt_MouseEventFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void Qt_GlobalColor_PythonToCpp_Qt_GlobalColor(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::GlobalColor *>(cppOut) =
        static_cast<::Qt::GlobalColor>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_GlobalColor_PythonToCpp_Qt_GlobalColor_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX]))
        return Qt_GlobalColor_PythonToCpp_Qt_GlobalColor;
    return {};
}
static PyObject *Qt_GlobalColor_CppToPython_Qt_GlobalColor(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::GlobalColor *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX], castCppIn);

}

static void Qt_KeyboardModifier_PythonToCpp_Qt_KeyboardModifier(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::KeyboardModifier *>(cppOut) =
        static_cast<::Qt::KeyboardModifier>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_KeyboardModifier_PythonToCpp_Qt_KeyboardModifier_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX]))
        return Qt_KeyboardModifier_PythonToCpp_Qt_KeyboardModifier;
    return {};
}
static PyObject *Qt_KeyboardModifier_CppToPython_Qt_KeyboardModifier(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::KeyboardModifier *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX], castCppIn);

}

static void QFlags_Qt_KeyboardModifier__PythonToCpp_QFlags_Qt_KeyboardModifier_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::KeyboardModifier> *>(cppOut) =
        ::QFlags<Qt::KeyboardModifier>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_KeyboardModifier__PythonToCpp_QFlags_Qt_KeyboardModifier__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX]))
        return QFlags_Qt_KeyboardModifier__PythonToCpp_QFlags_Qt_KeyboardModifier_;
    return {};
}
static PyObject *QFlags_Qt_KeyboardModifier__CppToPython_QFlags_Qt_KeyboardModifier_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::KeyboardModifier> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX]));

}

static void Qt_KeyboardModifier_PythonToCpp_QFlags_Qt_KeyboardModifier_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::KeyboardModifier> *>(cppOut) =
        ::QFlags<Qt::KeyboardModifier>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_KeyboardModifier_PythonToCpp_QFlags_Qt_KeyboardModifier__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX]))
        return Qt_KeyboardModifier_PythonToCpp_QFlags_Qt_KeyboardModifier_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_KeyboardModifier_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::KeyboardModifier> *>(cppOut) =
        ::QFlags<Qt::KeyboardModifier>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_KeyboardModifier__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX]))
        return number_PythonToCpp_QFlags_Qt_KeyboardModifier_;
    return {};
}
static void Qt_Modifier_PythonToCpp_Qt_Modifier(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::Modifier *>(cppOut) =
        static_cast<::Qt::Modifier>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_Modifier_PythonToCpp_Qt_Modifier_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX]))
        return Qt_Modifier_PythonToCpp_Qt_Modifier;
    return {};
}
static PyObject *Qt_Modifier_CppToPython_Qt_Modifier(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::Modifier *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX], castCppIn);

}

static void Qt_MouseButton_PythonToCpp_Qt_MouseButton(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::MouseButton *>(cppOut) =
        static_cast<::Qt::MouseButton>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_MouseButton_PythonToCpp_Qt_MouseButton_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX]))
        return Qt_MouseButton_PythonToCpp_Qt_MouseButton;
    return {};
}
static PyObject *Qt_MouseButton_CppToPython_Qt_MouseButton(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::MouseButton *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX], castCppIn);

}

static void QFlags_Qt_MouseButton__PythonToCpp_QFlags_Qt_MouseButton_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::MouseButton> *>(cppOut) =
        ::QFlags<Qt::MouseButton>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_MouseButton__PythonToCpp_QFlags_Qt_MouseButton__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX]))
        return QFlags_Qt_MouseButton__PythonToCpp_QFlags_Qt_MouseButton_;
    return {};
}
static PyObject *QFlags_Qt_MouseButton__CppToPython_QFlags_Qt_MouseButton_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::MouseButton> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX]));

}

static void Qt_MouseButton_PythonToCpp_QFlags_Qt_MouseButton_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::MouseButton> *>(cppOut) =
        ::QFlags<Qt::MouseButton>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_MouseButton_PythonToCpp_QFlags_Qt_MouseButton__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX]))
        return Qt_MouseButton_PythonToCpp_QFlags_Qt_MouseButton_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_MouseButton_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::MouseButton> *>(cppOut) =
        ::QFlags<Qt::MouseButton>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_MouseButton__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX]))
        return number_PythonToCpp_QFlags_Qt_MouseButton_;
    return {};
}
static void Qt_Orientation_PythonToCpp_Qt_Orientation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::Orientation *>(cppOut) =
        static_cast<::Qt::Orientation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_Orientation_PythonToCpp_Qt_Orientation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX]))
        return Qt_Orientation_PythonToCpp_Qt_Orientation;
    return {};
}
static PyObject *Qt_Orientation_CppToPython_Qt_Orientation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::Orientation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX], castCppIn);

}

static void QFlags_Qt_Orientation__PythonToCpp_QFlags_Qt_Orientation_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::Orientation> *>(cppOut) =
        ::QFlags<Qt::Orientation>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_Orientation__PythonToCpp_QFlags_Qt_Orientation__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX]))
        return QFlags_Qt_Orientation__PythonToCpp_QFlags_Qt_Orientation_;
    return {};
}
static PyObject *QFlags_Qt_Orientation__CppToPython_QFlags_Qt_Orientation_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::Orientation> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX]));

}

static void Qt_Orientation_PythonToCpp_QFlags_Qt_Orientation_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::Orientation> *>(cppOut) =
        ::QFlags<Qt::Orientation>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_Orientation_PythonToCpp_QFlags_Qt_Orientation__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX]))
        return Qt_Orientation_PythonToCpp_QFlags_Qt_Orientation_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_Orientation_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::Orientation> *>(cppOut) =
        ::QFlags<Qt::Orientation>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_Orientation__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX]))
        return number_PythonToCpp_QFlags_Qt_Orientation_;
    return {};
}
static void Qt_FocusPolicy_PythonToCpp_Qt_FocusPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::FocusPolicy *>(cppOut) =
        static_cast<::Qt::FocusPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_FocusPolicy_PythonToCpp_Qt_FocusPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX]))
        return Qt_FocusPolicy_PythonToCpp_Qt_FocusPolicy;
    return {};
}
static PyObject *Qt_FocusPolicy_CppToPython_Qt_FocusPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::FocusPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX], castCppIn);

}

static void Qt_TabFocusBehavior_PythonToCpp_Qt_TabFocusBehavior(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::TabFocusBehavior *>(cppOut) =
        static_cast<::Qt::TabFocusBehavior>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_TabFocusBehavior_PythonToCpp_Qt_TabFocusBehavior_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX]))
        return Qt_TabFocusBehavior_PythonToCpp_Qt_TabFocusBehavior;
    return {};
}
static PyObject *Qt_TabFocusBehavior_CppToPython_Qt_TabFocusBehavior(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::TabFocusBehavior *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX], castCppIn);

}

static void Qt_SortOrder_PythonToCpp_Qt_SortOrder(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::SortOrder *>(cppOut) =
        static_cast<::Qt::SortOrder>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_SortOrder_PythonToCpp_Qt_SortOrder_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX]))
        return Qt_SortOrder_PythonToCpp_Qt_SortOrder;
    return {};
}
static PyObject *Qt_SortOrder_CppToPython_Qt_SortOrder(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::SortOrder *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX], castCppIn);

}

static void Qt_SplitBehaviorFlags_PythonToCpp_Qt_SplitBehaviorFlags(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::SplitBehaviorFlags *>(cppOut) =
        static_cast<::Qt::SplitBehaviorFlags>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_SplitBehaviorFlags_PythonToCpp_Qt_SplitBehaviorFlags_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SPLITBEHAVIORFLAGS_IDX]))
        return Qt_SplitBehaviorFlags_PythonToCpp_Qt_SplitBehaviorFlags;
    return {};
}
static PyObject *Qt_SplitBehaviorFlags_CppToPython_Qt_SplitBehaviorFlags(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::SplitBehaviorFlags *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_SPLITBEHAVIORFLAGS_IDX], castCppIn);

}

static void QFlags_Qt_SplitBehaviorFlags__PythonToCpp_QFlags_Qt_SplitBehaviorFlags_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::SplitBehaviorFlags> *>(cppOut) =
        ::QFlags<Qt::SplitBehaviorFlags>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_SplitBehaviorFlags__PythonToCpp_QFlags_Qt_SplitBehaviorFlags__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX]))
        return QFlags_Qt_SplitBehaviorFlags__PythonToCpp_QFlags_Qt_SplitBehaviorFlags_;
    return {};
}
static PyObject *QFlags_Qt_SplitBehaviorFlags__CppToPython_QFlags_Qt_SplitBehaviorFlags_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::SplitBehaviorFlags> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX]));

}

static void Qt_SplitBehaviorFlags_PythonToCpp_QFlags_Qt_SplitBehaviorFlags_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::SplitBehaviorFlags> *>(cppOut) =
        ::QFlags<Qt::SplitBehaviorFlags>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_SplitBehaviorFlags_PythonToCpp_QFlags_Qt_SplitBehaviorFlags__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SPLITBEHAVIORFLAGS_IDX]))
        return Qt_SplitBehaviorFlags_PythonToCpp_QFlags_Qt_SplitBehaviorFlags_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_SplitBehaviorFlags_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::SplitBehaviorFlags> *>(cppOut) =
        ::QFlags<Qt::SplitBehaviorFlags>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_SplitBehaviorFlags__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SPLITBEHAVIORFLAGS_IDX]))
        return number_PythonToCpp_QFlags_Qt_SplitBehaviorFlags_;
    return {};
}
static void Qt_TileRule_PythonToCpp_Qt_TileRule(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::TileRule *>(cppOut) =
        static_cast<::Qt::TileRule>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_TileRule_PythonToCpp_Qt_TileRule_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX]))
        return Qt_TileRule_PythonToCpp_Qt_TileRule;
    return {};
}
static PyObject *Qt_TileRule_CppToPython_Qt_TileRule(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::TileRule *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX], castCppIn);

}

static void Qt_AlignmentFlag_PythonToCpp_Qt_AlignmentFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::AlignmentFlag *>(cppOut) =
        static_cast<::Qt::AlignmentFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_AlignmentFlag_PythonToCpp_Qt_AlignmentFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX]))
        return Qt_AlignmentFlag_PythonToCpp_Qt_AlignmentFlag;
    return {};
}
static PyObject *Qt_AlignmentFlag_CppToPython_Qt_AlignmentFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::AlignmentFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX], castCppIn);

}

static void QFlags_Qt_AlignmentFlag__PythonToCpp_QFlags_Qt_AlignmentFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::AlignmentFlag> *>(cppOut) =
        ::QFlags<Qt::AlignmentFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_AlignmentFlag__PythonToCpp_QFlags_Qt_AlignmentFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX]))
        return QFlags_Qt_AlignmentFlag__PythonToCpp_QFlags_Qt_AlignmentFlag_;
    return {};
}
static PyObject *QFlags_Qt_AlignmentFlag__CppToPython_QFlags_Qt_AlignmentFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::AlignmentFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX]));

}

static void Qt_AlignmentFlag_PythonToCpp_QFlags_Qt_AlignmentFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::AlignmentFlag> *>(cppOut) =
        ::QFlags<Qt::AlignmentFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_AlignmentFlag_PythonToCpp_QFlags_Qt_AlignmentFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX]))
        return Qt_AlignmentFlag_PythonToCpp_QFlags_Qt_AlignmentFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_AlignmentFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::AlignmentFlag> *>(cppOut) =
        ::QFlags<Qt::AlignmentFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_AlignmentFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX]))
        return number_PythonToCpp_QFlags_Qt_AlignmentFlag_;
    return {};
}
static void Qt_TextFlag_PythonToCpp_Qt_TextFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::TextFlag *>(cppOut) =
        static_cast<::Qt::TextFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_TextFlag_PythonToCpp_Qt_TextFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX]))
        return Qt_TextFlag_PythonToCpp_Qt_TextFlag;
    return {};
}
static PyObject *Qt_TextFlag_CppToPython_Qt_TextFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::TextFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX], castCppIn);

}

static void Qt_TextElideMode_PythonToCpp_Qt_TextElideMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::TextElideMode *>(cppOut) =
        static_cast<::Qt::TextElideMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_TextElideMode_PythonToCpp_Qt_TextElideMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX]))
        return Qt_TextElideMode_PythonToCpp_Qt_TextElideMode;
    return {};
}
static PyObject *Qt_TextElideMode_CppToPython_Qt_TextElideMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::TextElideMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX], castCppIn);

}

static void Qt_WhiteSpaceMode_PythonToCpp_Qt_WhiteSpaceMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::WhiteSpaceMode *>(cppOut) =
        static_cast<::Qt::WhiteSpaceMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_WhiteSpaceMode_PythonToCpp_Qt_WhiteSpaceMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX]))
        return Qt_WhiteSpaceMode_PythonToCpp_Qt_WhiteSpaceMode;
    return {};
}
static PyObject *Qt_WhiteSpaceMode_CppToPython_Qt_WhiteSpaceMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::WhiteSpaceMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX], castCppIn);

}

static void Qt_HitTestAccuracy_PythonToCpp_Qt_HitTestAccuracy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::HitTestAccuracy *>(cppOut) =
        static_cast<::Qt::HitTestAccuracy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_HitTestAccuracy_PythonToCpp_Qt_HitTestAccuracy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_HITTESTACCURACY_IDX]))
        return Qt_HitTestAccuracy_PythonToCpp_Qt_HitTestAccuracy;
    return {};
}
static PyObject *Qt_HitTestAccuracy_CppToPython_Qt_HitTestAccuracy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::HitTestAccuracy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_HITTESTACCURACY_IDX], castCppIn);

}

static void Qt_WindowType_PythonToCpp_Qt_WindowType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::WindowType *>(cppOut) =
        static_cast<::Qt::WindowType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_WindowType_PythonToCpp_Qt_WindowType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX]))
        return Qt_WindowType_PythonToCpp_Qt_WindowType;
    return {};
}
static PyObject *Qt_WindowType_CppToPython_Qt_WindowType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::WindowType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX], castCppIn);

}

static void QFlags_Qt_WindowType__PythonToCpp_QFlags_Qt_WindowType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::WindowType> *>(cppOut) =
        ::QFlags<Qt::WindowType>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_WindowType__PythonToCpp_QFlags_Qt_WindowType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX]))
        return QFlags_Qt_WindowType__PythonToCpp_QFlags_Qt_WindowType_;
    return {};
}
static PyObject *QFlags_Qt_WindowType__CppToPython_QFlags_Qt_WindowType_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::WindowType> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX]));

}

static void Qt_WindowType_PythonToCpp_QFlags_Qt_WindowType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::WindowType> *>(cppOut) =
        ::QFlags<Qt::WindowType>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_WindowType_PythonToCpp_QFlags_Qt_WindowType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX]))
        return Qt_WindowType_PythonToCpp_QFlags_Qt_WindowType_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_WindowType_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::WindowType> *>(cppOut) =
        ::QFlags<Qt::WindowType>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_WindowType__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX]))
        return number_PythonToCpp_QFlags_Qt_WindowType_;
    return {};
}
static void Qt_WindowState_PythonToCpp_Qt_WindowState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::WindowState *>(cppOut) =
        static_cast<::Qt::WindowState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_WindowState_PythonToCpp_Qt_WindowState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX]))
        return Qt_WindowState_PythonToCpp_Qt_WindowState;
    return {};
}
static PyObject *Qt_WindowState_CppToPython_Qt_WindowState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::WindowState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX], castCppIn);

}

static void QFlags_Qt_WindowState__PythonToCpp_QFlags_Qt_WindowState_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::WindowState> *>(cppOut) =
        ::QFlags<Qt::WindowState>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_WindowState__PythonToCpp_QFlags_Qt_WindowState__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX]))
        return QFlags_Qt_WindowState__PythonToCpp_QFlags_Qt_WindowState_;
    return {};
}
static PyObject *QFlags_Qt_WindowState__CppToPython_QFlags_Qt_WindowState_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::WindowState> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX]));

}

static void Qt_WindowState_PythonToCpp_QFlags_Qt_WindowState_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::WindowState> *>(cppOut) =
        ::QFlags<Qt::WindowState>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_WindowState_PythonToCpp_QFlags_Qt_WindowState__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX]))
        return Qt_WindowState_PythonToCpp_QFlags_Qt_WindowState_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_WindowState_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::WindowState> *>(cppOut) =
        ::QFlags<Qt::WindowState>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_WindowState__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX]))
        return number_PythonToCpp_QFlags_Qt_WindowState_;
    return {};
}
static void Qt_ApplicationState_PythonToCpp_Qt_ApplicationState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ApplicationState *>(cppOut) =
        static_cast<::Qt::ApplicationState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ApplicationState_PythonToCpp_Qt_ApplicationState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX]))
        return Qt_ApplicationState_PythonToCpp_Qt_ApplicationState;
    return {};
}
static PyObject *Qt_ApplicationState_CppToPython_Qt_ApplicationState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ApplicationState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX], castCppIn);

}

static void QFlags_Qt_ApplicationState__PythonToCpp_QFlags_Qt_ApplicationState_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::ApplicationState> *>(cppOut) =
        ::QFlags<Qt::ApplicationState>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_ApplicationState__PythonToCpp_QFlags_Qt_ApplicationState__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX]))
        return QFlags_Qt_ApplicationState__PythonToCpp_QFlags_Qt_ApplicationState_;
    return {};
}
static PyObject *QFlags_Qt_ApplicationState__CppToPython_QFlags_Qt_ApplicationState_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::ApplicationState> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX]));

}

static void Qt_ApplicationState_PythonToCpp_QFlags_Qt_ApplicationState_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::ApplicationState> *>(cppOut) =
        ::QFlags<Qt::ApplicationState>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_ApplicationState_PythonToCpp_QFlags_Qt_ApplicationState__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX]))
        return Qt_ApplicationState_PythonToCpp_QFlags_Qt_ApplicationState_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_ApplicationState_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::ApplicationState> *>(cppOut) =
        ::QFlags<Qt::ApplicationState>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_ApplicationState__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX]))
        return number_PythonToCpp_QFlags_Qt_ApplicationState_;
    return {};
}
static void Qt_ScreenOrientation_PythonToCpp_Qt_ScreenOrientation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ScreenOrientation *>(cppOut) =
        static_cast<::Qt::ScreenOrientation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ScreenOrientation_PythonToCpp_Qt_ScreenOrientation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX]))
        return Qt_ScreenOrientation_PythonToCpp_Qt_ScreenOrientation;
    return {};
}
static PyObject *Qt_ScreenOrientation_CppToPython_Qt_ScreenOrientation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ScreenOrientation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX], castCppIn);

}

static void QFlags_Qt_ScreenOrientation__PythonToCpp_QFlags_Qt_ScreenOrientation_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::ScreenOrientation> *>(cppOut) =
        ::QFlags<Qt::ScreenOrientation>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_ScreenOrientation__PythonToCpp_QFlags_Qt_ScreenOrientation__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX]))
        return QFlags_Qt_ScreenOrientation__PythonToCpp_QFlags_Qt_ScreenOrientation_;
    return {};
}
static PyObject *QFlags_Qt_ScreenOrientation__CppToPython_QFlags_Qt_ScreenOrientation_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::ScreenOrientation> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX]));

}

static void Qt_ScreenOrientation_PythonToCpp_QFlags_Qt_ScreenOrientation_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::ScreenOrientation> *>(cppOut) =
        ::QFlags<Qt::ScreenOrientation>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_ScreenOrientation_PythonToCpp_QFlags_Qt_ScreenOrientation__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX]))
        return Qt_ScreenOrientation_PythonToCpp_QFlags_Qt_ScreenOrientation_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_ScreenOrientation_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::ScreenOrientation> *>(cppOut) =
        ::QFlags<Qt::ScreenOrientation>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_ScreenOrientation__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX]))
        return number_PythonToCpp_QFlags_Qt_ScreenOrientation_;
    return {};
}
static void Qt_WidgetAttribute_PythonToCpp_Qt_WidgetAttribute(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::WidgetAttribute *>(cppOut) =
        static_cast<::Qt::WidgetAttribute>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_WidgetAttribute_PythonToCpp_Qt_WidgetAttribute_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX]))
        return Qt_WidgetAttribute_PythonToCpp_Qt_WidgetAttribute;
    return {};
}
static PyObject *Qt_WidgetAttribute_CppToPython_Qt_WidgetAttribute(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::WidgetAttribute *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX], castCppIn);

}

static void Qt_ApplicationAttribute_PythonToCpp_Qt_ApplicationAttribute(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ApplicationAttribute *>(cppOut) =
        static_cast<::Qt::ApplicationAttribute>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ApplicationAttribute_PythonToCpp_Qt_ApplicationAttribute_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX]))
        return Qt_ApplicationAttribute_PythonToCpp_Qt_ApplicationAttribute;
    return {};
}
static PyObject *Qt_ApplicationAttribute_CppToPython_Qt_ApplicationAttribute(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ApplicationAttribute *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX], castCppIn);

}

static void Qt_ImageConversionFlag_PythonToCpp_Qt_ImageConversionFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ImageConversionFlag *>(cppOut) =
        static_cast<::Qt::ImageConversionFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ImageConversionFlag_PythonToCpp_Qt_ImageConversionFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX]))
        return Qt_ImageConversionFlag_PythonToCpp_Qt_ImageConversionFlag;
    return {};
}
static PyObject *Qt_ImageConversionFlag_CppToPython_Qt_ImageConversionFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ImageConversionFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX], castCppIn);

}

static void QFlags_Qt_ImageConversionFlag__PythonToCpp_QFlags_Qt_ImageConversionFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::ImageConversionFlag> *>(cppOut) =
        ::QFlags<Qt::ImageConversionFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_ImageConversionFlag__PythonToCpp_QFlags_Qt_ImageConversionFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX]))
        return QFlags_Qt_ImageConversionFlag__PythonToCpp_QFlags_Qt_ImageConversionFlag_;
    return {};
}
static PyObject *QFlags_Qt_ImageConversionFlag__CppToPython_QFlags_Qt_ImageConversionFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::ImageConversionFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX]));

}

static void Qt_ImageConversionFlag_PythonToCpp_QFlags_Qt_ImageConversionFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::ImageConversionFlag> *>(cppOut) =
        ::QFlags<Qt::ImageConversionFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_ImageConversionFlag_PythonToCpp_QFlags_Qt_ImageConversionFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX]))
        return Qt_ImageConversionFlag_PythonToCpp_QFlags_Qt_ImageConversionFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_ImageConversionFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::ImageConversionFlag> *>(cppOut) =
        ::QFlags<Qt::ImageConversionFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_ImageConversionFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX]))
        return number_PythonToCpp_QFlags_Qt_ImageConversionFlag_;
    return {};
}
static void Qt_BGMode_PythonToCpp_Qt_BGMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::BGMode *>(cppOut) =
        static_cast<::Qt::BGMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_BGMode_PythonToCpp_Qt_BGMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_BGMODE_IDX]))
        return Qt_BGMode_PythonToCpp_Qt_BGMode;
    return {};
}
static PyObject *Qt_BGMode_CppToPython_Qt_BGMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::BGMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_BGMODE_IDX], castCppIn);

}

static void Qt_Key_PythonToCpp_Qt_Key(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::Key *>(cppOut) =
        static_cast<::Qt::Key>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_Key_PythonToCpp_Qt_Key_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX]))
        return Qt_Key_PythonToCpp_Qt_Key;
    return {};
}
static PyObject *Qt_Key_CppToPython_Qt_Key(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::Key *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX], castCppIn);

}

static void Qt_ArrowType_PythonToCpp_Qt_ArrowType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ArrowType *>(cppOut) =
        static_cast<::Qt::ArrowType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ArrowType_PythonToCpp_Qt_ArrowType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX]))
        return Qt_ArrowType_PythonToCpp_Qt_ArrowType;
    return {};
}
static PyObject *Qt_ArrowType_CppToPython_Qt_ArrowType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ArrowType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX], castCppIn);

}

static void Qt_PenStyle_PythonToCpp_Qt_PenStyle(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::PenStyle *>(cppOut) =
        static_cast<::Qt::PenStyle>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_PenStyle_PythonToCpp_Qt_PenStyle_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX]))
        return Qt_PenStyle_PythonToCpp_Qt_PenStyle;
    return {};
}
static PyObject *Qt_PenStyle_CppToPython_Qt_PenStyle(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::PenStyle *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX], castCppIn);

}

static void Qt_PenCapStyle_PythonToCpp_Qt_PenCapStyle(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::PenCapStyle *>(cppOut) =
        static_cast<::Qt::PenCapStyle>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_PenCapStyle_PythonToCpp_Qt_PenCapStyle_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX]))
        return Qt_PenCapStyle_PythonToCpp_Qt_PenCapStyle;
    return {};
}
static PyObject *Qt_PenCapStyle_CppToPython_Qt_PenCapStyle(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::PenCapStyle *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX], castCppIn);

}

static void Qt_PenJoinStyle_PythonToCpp_Qt_PenJoinStyle(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::PenJoinStyle *>(cppOut) =
        static_cast<::Qt::PenJoinStyle>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_PenJoinStyle_PythonToCpp_Qt_PenJoinStyle_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX]))
        return Qt_PenJoinStyle_PythonToCpp_Qt_PenJoinStyle;
    return {};
}
static PyObject *Qt_PenJoinStyle_CppToPython_Qt_PenJoinStyle(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::PenJoinStyle *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX], castCppIn);

}

static void Qt_BrushStyle_PythonToCpp_Qt_BrushStyle(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::BrushStyle *>(cppOut) =
        static_cast<::Qt::BrushStyle>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_BrushStyle_PythonToCpp_Qt_BrushStyle_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX]))
        return Qt_BrushStyle_PythonToCpp_Qt_BrushStyle;
    return {};
}
static PyObject *Qt_BrushStyle_CppToPython_Qt_BrushStyle(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::BrushStyle *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX], castCppIn);

}

static void Qt_SizeMode_PythonToCpp_Qt_SizeMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::SizeMode *>(cppOut) =
        static_cast<::Qt::SizeMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_SizeMode_PythonToCpp_Qt_SizeMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX]))
        return Qt_SizeMode_PythonToCpp_Qt_SizeMode;
    return {};
}
static PyObject *Qt_SizeMode_CppToPython_Qt_SizeMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::SizeMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX], castCppIn);

}

static void Qt_UIEffect_PythonToCpp_Qt_UIEffect(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::UIEffect *>(cppOut) =
        static_cast<::Qt::UIEffect>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_UIEffect_PythonToCpp_Qt_UIEffect_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX]))
        return Qt_UIEffect_PythonToCpp_Qt_UIEffect;
    return {};
}
static PyObject *Qt_UIEffect_CppToPython_Qt_UIEffect(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::UIEffect *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX], castCppIn);

}

static void Qt_CursorShape_PythonToCpp_Qt_CursorShape(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::CursorShape *>(cppOut) =
        static_cast<::Qt::CursorShape>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_CursorShape_PythonToCpp_Qt_CursorShape_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX]))
        return Qt_CursorShape_PythonToCpp_Qt_CursorShape;
    return {};
}
static PyObject *Qt_CursorShape_CppToPython_Qt_CursorShape(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::CursorShape *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX], castCppIn);

}

static void Qt_TextFormat_PythonToCpp_Qt_TextFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::TextFormat *>(cppOut) =
        static_cast<::Qt::TextFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_TextFormat_PythonToCpp_Qt_TextFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX]))
        return Qt_TextFormat_PythonToCpp_Qt_TextFormat;
    return {};
}
static PyObject *Qt_TextFormat_CppToPython_Qt_TextFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::TextFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX], castCppIn);

}

static void Qt_AspectRatioMode_PythonToCpp_Qt_AspectRatioMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::AspectRatioMode *>(cppOut) =
        static_cast<::Qt::AspectRatioMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_AspectRatioMode_PythonToCpp_Qt_AspectRatioMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX]))
        return Qt_AspectRatioMode_PythonToCpp_Qt_AspectRatioMode;
    return {};
}
static PyObject *Qt_AspectRatioMode_CppToPython_Qt_AspectRatioMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::AspectRatioMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX], castCppIn);

}

static void Qt_DockWidgetArea_PythonToCpp_Qt_DockWidgetArea(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::DockWidgetArea *>(cppOut) =
        static_cast<::Qt::DockWidgetArea>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_DockWidgetArea_PythonToCpp_Qt_DockWidgetArea_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX]))
        return Qt_DockWidgetArea_PythonToCpp_Qt_DockWidgetArea;
    return {};
}
static PyObject *Qt_DockWidgetArea_CppToPython_Qt_DockWidgetArea(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::DockWidgetArea *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX], castCppIn);

}

static void QFlags_Qt_DockWidgetArea__PythonToCpp_QFlags_Qt_DockWidgetArea_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::DockWidgetArea> *>(cppOut) =
        ::QFlags<Qt::DockWidgetArea>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_DockWidgetArea__PythonToCpp_QFlags_Qt_DockWidgetArea__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX]))
        return QFlags_Qt_DockWidgetArea__PythonToCpp_QFlags_Qt_DockWidgetArea_;
    return {};
}
static PyObject *QFlags_Qt_DockWidgetArea__CppToPython_QFlags_Qt_DockWidgetArea_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::DockWidgetArea> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX]));

}

static void Qt_DockWidgetArea_PythonToCpp_QFlags_Qt_DockWidgetArea_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::DockWidgetArea> *>(cppOut) =
        ::QFlags<Qt::DockWidgetArea>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_DockWidgetArea_PythonToCpp_QFlags_Qt_DockWidgetArea__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX]))
        return Qt_DockWidgetArea_PythonToCpp_QFlags_Qt_DockWidgetArea_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_DockWidgetArea_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::DockWidgetArea> *>(cppOut) =
        ::QFlags<Qt::DockWidgetArea>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_DockWidgetArea__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX]))
        return number_PythonToCpp_QFlags_Qt_DockWidgetArea_;
    return {};
}
static void Qt_DockWidgetAreaSizes_PythonToCpp_Qt_DockWidgetAreaSizes(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::DockWidgetAreaSizes *>(cppOut) =
        static_cast<::Qt::DockWidgetAreaSizes>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_DockWidgetAreaSizes_PythonToCpp_Qt_DockWidgetAreaSizes_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREASIZES_IDX]))
        return Qt_DockWidgetAreaSizes_PythonToCpp_Qt_DockWidgetAreaSizes;
    return {};
}
static PyObject *Qt_DockWidgetAreaSizes_CppToPython_Qt_DockWidgetAreaSizes(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::DockWidgetAreaSizes *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREASIZES_IDX], castCppIn);

}

static void Qt_ToolBarArea_PythonToCpp_Qt_ToolBarArea(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ToolBarArea *>(cppOut) =
        static_cast<::Qt::ToolBarArea>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ToolBarArea_PythonToCpp_Qt_ToolBarArea_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX]))
        return Qt_ToolBarArea_PythonToCpp_Qt_ToolBarArea;
    return {};
}
static PyObject *Qt_ToolBarArea_CppToPython_Qt_ToolBarArea(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ToolBarArea *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX], castCppIn);

}

static void QFlags_Qt_ToolBarArea__PythonToCpp_QFlags_Qt_ToolBarArea_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::ToolBarArea> *>(cppOut) =
        ::QFlags<Qt::ToolBarArea>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_ToolBarArea__PythonToCpp_QFlags_Qt_ToolBarArea__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX]))
        return QFlags_Qt_ToolBarArea__PythonToCpp_QFlags_Qt_ToolBarArea_;
    return {};
}
static PyObject *QFlags_Qt_ToolBarArea__CppToPython_QFlags_Qt_ToolBarArea_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::ToolBarArea> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX]));

}

static void Qt_ToolBarArea_PythonToCpp_QFlags_Qt_ToolBarArea_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::ToolBarArea> *>(cppOut) =
        ::QFlags<Qt::ToolBarArea>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_ToolBarArea_PythonToCpp_QFlags_Qt_ToolBarArea__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX]))
        return Qt_ToolBarArea_PythonToCpp_QFlags_Qt_ToolBarArea_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_ToolBarArea_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::ToolBarArea> *>(cppOut) =
        ::QFlags<Qt::ToolBarArea>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_ToolBarArea__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX]))
        return number_PythonToCpp_QFlags_Qt_ToolBarArea_;
    return {};
}
static void Qt_ToolBarAreaSizes_PythonToCpp_Qt_ToolBarAreaSizes(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ToolBarAreaSizes *>(cppOut) =
        static_cast<::Qt::ToolBarAreaSizes>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ToolBarAreaSizes_PythonToCpp_Qt_ToolBarAreaSizes_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREASIZES_IDX]))
        return Qt_ToolBarAreaSizes_PythonToCpp_Qt_ToolBarAreaSizes;
    return {};
}
static PyObject *Qt_ToolBarAreaSizes_CppToPython_Qt_ToolBarAreaSizes(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ToolBarAreaSizes *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREASIZES_IDX], castCppIn);

}

static void Qt_DateFormat_PythonToCpp_Qt_DateFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::DateFormat *>(cppOut) =
        static_cast<::Qt::DateFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_DateFormat_PythonToCpp_Qt_DateFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX]))
        return Qt_DateFormat_PythonToCpp_Qt_DateFormat;
    return {};
}
static PyObject *Qt_DateFormat_CppToPython_Qt_DateFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::DateFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX], castCppIn);

}

static void Qt_TimeSpec_PythonToCpp_Qt_TimeSpec(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::TimeSpec *>(cppOut) =
        static_cast<::Qt::TimeSpec>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_TimeSpec_PythonToCpp_Qt_TimeSpec_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX]))
        return Qt_TimeSpec_PythonToCpp_Qt_TimeSpec;
    return {};
}
static PyObject *Qt_TimeSpec_CppToPython_Qt_TimeSpec(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::TimeSpec *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX], castCppIn);

}

static void Qt_DayOfWeek_PythonToCpp_Qt_DayOfWeek(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::DayOfWeek *>(cppOut) =
        static_cast<::Qt::DayOfWeek>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_DayOfWeek_PythonToCpp_Qt_DayOfWeek_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX]))
        return Qt_DayOfWeek_PythonToCpp_Qt_DayOfWeek;
    return {};
}
static PyObject *Qt_DayOfWeek_CppToPython_Qt_DayOfWeek(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::DayOfWeek *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX], castCppIn);

}

static void Qt_ScrollBarPolicy_PythonToCpp_Qt_ScrollBarPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ScrollBarPolicy *>(cppOut) =
        static_cast<::Qt::ScrollBarPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ScrollBarPolicy_PythonToCpp_Qt_ScrollBarPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX]))
        return Qt_ScrollBarPolicy_PythonToCpp_Qt_ScrollBarPolicy;
    return {};
}
static PyObject *Qt_ScrollBarPolicy_CppToPython_Qt_ScrollBarPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ScrollBarPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX], castCppIn);

}

static void Qt_CaseSensitivity_PythonToCpp_Qt_CaseSensitivity(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::CaseSensitivity *>(cppOut) =
        static_cast<::Qt::CaseSensitivity>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_CaseSensitivity_PythonToCpp_Qt_CaseSensitivity_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX]))
        return Qt_CaseSensitivity_PythonToCpp_Qt_CaseSensitivity;
    return {};
}
static PyObject *Qt_CaseSensitivity_CppToPython_Qt_CaseSensitivity(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::CaseSensitivity *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX], castCppIn);

}

static void Qt_Corner_PythonToCpp_Qt_Corner(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::Corner *>(cppOut) =
        static_cast<::Qt::Corner>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_Corner_PythonToCpp_Qt_Corner_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX]))
        return Qt_Corner_PythonToCpp_Qt_Corner;
    return {};
}
static PyObject *Qt_Corner_CppToPython_Qt_Corner(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::Corner *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX], castCppIn);

}

static void Qt_Edge_PythonToCpp_Qt_Edge(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::Edge *>(cppOut) =
        static_cast<::Qt::Edge>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_Edge_PythonToCpp_Qt_Edge_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX]))
        return Qt_Edge_PythonToCpp_Qt_Edge;
    return {};
}
static PyObject *Qt_Edge_CppToPython_Qt_Edge(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::Edge *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX], castCppIn);

}

static void QFlags_Qt_Edge__PythonToCpp_QFlags_Qt_Edge_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::Edge> *>(cppOut) =
        ::QFlags<Qt::Edge>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_Edge__PythonToCpp_QFlags_Qt_Edge__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX]))
        return QFlags_Qt_Edge__PythonToCpp_QFlags_Qt_Edge_;
    return {};
}
static PyObject *QFlags_Qt_Edge__CppToPython_QFlags_Qt_Edge_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::Edge> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX]));

}

static void Qt_Edge_PythonToCpp_QFlags_Qt_Edge_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::Edge> *>(cppOut) =
        ::QFlags<Qt::Edge>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_Edge_PythonToCpp_QFlags_Qt_Edge__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX]))
        return Qt_Edge_PythonToCpp_QFlags_Qt_Edge_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_Edge_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::Edge> *>(cppOut) =
        ::QFlags<Qt::Edge>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_Edge__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX]))
        return number_PythonToCpp_QFlags_Qt_Edge_;
    return {};
}
static void Qt_ConnectionType_PythonToCpp_Qt_ConnectionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ConnectionType *>(cppOut) =
        static_cast<::Qt::ConnectionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ConnectionType_PythonToCpp_Qt_ConnectionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX]))
        return Qt_ConnectionType_PythonToCpp_Qt_ConnectionType;
    return {};
}
static PyObject *Qt_ConnectionType_CppToPython_Qt_ConnectionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ConnectionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX], castCppIn);

}

static void Qt_ShortcutContext_PythonToCpp_Qt_ShortcutContext(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ShortcutContext *>(cppOut) =
        static_cast<::Qt::ShortcutContext>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ShortcutContext_PythonToCpp_Qt_ShortcutContext_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX]))
        return Qt_ShortcutContext_PythonToCpp_Qt_ShortcutContext;
    return {};
}
static PyObject *Qt_ShortcutContext_CppToPython_Qt_ShortcutContext(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ShortcutContext *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX], castCppIn);

}

static void Qt_FillRule_PythonToCpp_Qt_FillRule(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::FillRule *>(cppOut) =
        static_cast<::Qt::FillRule>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_FillRule_PythonToCpp_Qt_FillRule_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX]))
        return Qt_FillRule_PythonToCpp_Qt_FillRule;
    return {};
}
static PyObject *Qt_FillRule_CppToPython_Qt_FillRule(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::FillRule *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX], castCppIn);

}

static void Qt_MaskMode_PythonToCpp_Qt_MaskMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::MaskMode *>(cppOut) =
        static_cast<::Qt::MaskMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_MaskMode_PythonToCpp_Qt_MaskMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX]))
        return Qt_MaskMode_PythonToCpp_Qt_MaskMode;
    return {};
}
static PyObject *Qt_MaskMode_CppToPython_Qt_MaskMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::MaskMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX], castCppIn);

}

static void Qt_ClipOperation_PythonToCpp_Qt_ClipOperation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ClipOperation *>(cppOut) =
        static_cast<::Qt::ClipOperation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ClipOperation_PythonToCpp_Qt_ClipOperation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX]))
        return Qt_ClipOperation_PythonToCpp_Qt_ClipOperation;
    return {};
}
static PyObject *Qt_ClipOperation_CppToPython_Qt_ClipOperation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ClipOperation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX], castCppIn);

}

static void Qt_ItemSelectionMode_PythonToCpp_Qt_ItemSelectionMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ItemSelectionMode *>(cppOut) =
        static_cast<::Qt::ItemSelectionMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ItemSelectionMode_PythonToCpp_Qt_ItemSelectionMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX]))
        return Qt_ItemSelectionMode_PythonToCpp_Qt_ItemSelectionMode;
    return {};
}
static PyObject *Qt_ItemSelectionMode_CppToPython_Qt_ItemSelectionMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ItemSelectionMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX], castCppIn);

}

static void Qt_ItemSelectionOperation_PythonToCpp_Qt_ItemSelectionOperation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ItemSelectionOperation *>(cppOut) =
        static_cast<::Qt::ItemSelectionOperation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ItemSelectionOperation_PythonToCpp_Qt_ItemSelectionOperation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONOPERATION_IDX]))
        return Qt_ItemSelectionOperation_PythonToCpp_Qt_ItemSelectionOperation;
    return {};
}
static PyObject *Qt_ItemSelectionOperation_CppToPython_Qt_ItemSelectionOperation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ItemSelectionOperation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONOPERATION_IDX], castCppIn);

}

static void Qt_TransformationMode_PythonToCpp_Qt_TransformationMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::TransformationMode *>(cppOut) =
        static_cast<::Qt::TransformationMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_TransformationMode_PythonToCpp_Qt_TransformationMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX]))
        return Qt_TransformationMode_PythonToCpp_Qt_TransformationMode;
    return {};
}
static PyObject *Qt_TransformationMode_CppToPython_Qt_TransformationMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::TransformationMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX], castCppIn);

}

static void Qt_Axis_PythonToCpp_Qt_Axis(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::Axis *>(cppOut) =
        static_cast<::Qt::Axis>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_Axis_PythonToCpp_Qt_Axis_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_AXIS_IDX]))
        return Qt_Axis_PythonToCpp_Qt_Axis;
    return {};
}
static PyObject *Qt_Axis_CppToPython_Qt_Axis(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::Axis *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_AXIS_IDX], castCppIn);

}

static void Qt_FocusReason_PythonToCpp_Qt_FocusReason(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::FocusReason *>(cppOut) =
        static_cast<::Qt::FocusReason>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_FocusReason_PythonToCpp_Qt_FocusReason_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX]))
        return Qt_FocusReason_PythonToCpp_Qt_FocusReason;
    return {};
}
static PyObject *Qt_FocusReason_CppToPython_Qt_FocusReason(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::FocusReason *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX], castCppIn);

}

static void Qt_ContextMenuPolicy_PythonToCpp_Qt_ContextMenuPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ContextMenuPolicy *>(cppOut) =
        static_cast<::Qt::ContextMenuPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ContextMenuPolicy_PythonToCpp_Qt_ContextMenuPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX]))
        return Qt_ContextMenuPolicy_PythonToCpp_Qt_ContextMenuPolicy;
    return {};
}
static PyObject *Qt_ContextMenuPolicy_CppToPython_Qt_ContextMenuPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ContextMenuPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX], castCppIn);

}

static void Qt_InputMethodQuery_PythonToCpp_Qt_InputMethodQuery(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::InputMethodQuery *>(cppOut) =
        static_cast<::Qt::InputMethodQuery>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_InputMethodQuery_PythonToCpp_Qt_InputMethodQuery_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX]))
        return Qt_InputMethodQuery_PythonToCpp_Qt_InputMethodQuery;
    return {};
}
static PyObject *Qt_InputMethodQuery_CppToPython_Qt_InputMethodQuery(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::InputMethodQuery *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX], castCppIn);

}

static void QFlags_Qt_InputMethodQuery__PythonToCpp_QFlags_Qt_InputMethodQuery_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::InputMethodQuery> *>(cppOut) =
        ::QFlags<Qt::InputMethodQuery>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_InputMethodQuery__PythonToCpp_QFlags_Qt_InputMethodQuery__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX]))
        return QFlags_Qt_InputMethodQuery__PythonToCpp_QFlags_Qt_InputMethodQuery_;
    return {};
}
static PyObject *QFlags_Qt_InputMethodQuery__CppToPython_QFlags_Qt_InputMethodQuery_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::InputMethodQuery> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX]));

}

static void Qt_InputMethodQuery_PythonToCpp_QFlags_Qt_InputMethodQuery_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::InputMethodQuery> *>(cppOut) =
        ::QFlags<Qt::InputMethodQuery>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_InputMethodQuery_PythonToCpp_QFlags_Qt_InputMethodQuery__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX]))
        return Qt_InputMethodQuery_PythonToCpp_QFlags_Qt_InputMethodQuery_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_InputMethodQuery_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::InputMethodQuery> *>(cppOut) =
        ::QFlags<Qt::InputMethodQuery>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_InputMethodQuery__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX]))
        return number_PythonToCpp_QFlags_Qt_InputMethodQuery_;
    return {};
}
static void Qt_InputMethodHint_PythonToCpp_Qt_InputMethodHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::InputMethodHint *>(cppOut) =
        static_cast<::Qt::InputMethodHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_InputMethodHint_PythonToCpp_Qt_InputMethodHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX]))
        return Qt_InputMethodHint_PythonToCpp_Qt_InputMethodHint;
    return {};
}
static PyObject *Qt_InputMethodHint_CppToPython_Qt_InputMethodHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::InputMethodHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX], castCppIn);

}

static void QFlags_Qt_InputMethodHint__PythonToCpp_QFlags_Qt_InputMethodHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::InputMethodHint> *>(cppOut) =
        ::QFlags<Qt::InputMethodHint>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_InputMethodHint__PythonToCpp_QFlags_Qt_InputMethodHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX]))
        return QFlags_Qt_InputMethodHint__PythonToCpp_QFlags_Qt_InputMethodHint_;
    return {};
}
static PyObject *QFlags_Qt_InputMethodHint__CppToPython_QFlags_Qt_InputMethodHint_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::InputMethodHint> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX]));

}

static void Qt_InputMethodHint_PythonToCpp_QFlags_Qt_InputMethodHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::InputMethodHint> *>(cppOut) =
        ::QFlags<Qt::InputMethodHint>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_InputMethodHint_PythonToCpp_QFlags_Qt_InputMethodHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX]))
        return Qt_InputMethodHint_PythonToCpp_QFlags_Qt_InputMethodHint_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_InputMethodHint_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::InputMethodHint> *>(cppOut) =
        ::QFlags<Qt::InputMethodHint>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_InputMethodHint__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX]))
        return number_PythonToCpp_QFlags_Qt_InputMethodHint_;
    return {};
}
static void Qt_EnterKeyType_PythonToCpp_Qt_EnterKeyType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::EnterKeyType *>(cppOut) =
        static_cast<::Qt::EnterKeyType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_EnterKeyType_PythonToCpp_Qt_EnterKeyType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX]))
        return Qt_EnterKeyType_PythonToCpp_Qt_EnterKeyType;
    return {};
}
static PyObject *Qt_EnterKeyType_CppToPython_Qt_EnterKeyType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::EnterKeyType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX], castCppIn);

}

static void Qt_ToolButtonStyle_PythonToCpp_Qt_ToolButtonStyle(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ToolButtonStyle *>(cppOut) =
        static_cast<::Qt::ToolButtonStyle>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ToolButtonStyle_PythonToCpp_Qt_ToolButtonStyle_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX]))
        return Qt_ToolButtonStyle_PythonToCpp_Qt_ToolButtonStyle;
    return {};
}
static PyObject *Qt_ToolButtonStyle_CppToPython_Qt_ToolButtonStyle(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ToolButtonStyle *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX], castCppIn);

}

static void Qt_LayoutDirection_PythonToCpp_Qt_LayoutDirection(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::LayoutDirection *>(cppOut) =
        static_cast<::Qt::LayoutDirection>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_LayoutDirection_PythonToCpp_Qt_LayoutDirection_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX]))
        return Qt_LayoutDirection_PythonToCpp_Qt_LayoutDirection;
    return {};
}
static PyObject *Qt_LayoutDirection_CppToPython_Qt_LayoutDirection(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::LayoutDirection *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX], castCppIn);

}

static void Qt_AnchorPoint_PythonToCpp_Qt_AnchorPoint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::AnchorPoint *>(cppOut) =
        static_cast<::Qt::AnchorPoint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_AnchorPoint_PythonToCpp_Qt_AnchorPoint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX]))
        return Qt_AnchorPoint_PythonToCpp_Qt_AnchorPoint;
    return {};
}
static PyObject *Qt_AnchorPoint_CppToPython_Qt_AnchorPoint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::AnchorPoint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX], castCppIn);

}

static void Qt_FindChildOption_PythonToCpp_Qt_FindChildOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::FindChildOption *>(cppOut) =
        static_cast<::Qt::FindChildOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_FindChildOption_PythonToCpp_Qt_FindChildOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_FINDCHILDOPTION_IDX]))
        return Qt_FindChildOption_PythonToCpp_Qt_FindChildOption;
    return {};
}
static PyObject *Qt_FindChildOption_CppToPython_Qt_FindChildOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::FindChildOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_FINDCHILDOPTION_IDX], castCppIn);

}

static void QFlags_Qt_FindChildOption__PythonToCpp_QFlags_Qt_FindChildOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::FindChildOption> *>(cppOut) =
        ::QFlags<Qt::FindChildOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_FindChildOption__PythonToCpp_QFlags_Qt_FindChildOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX]))
        return QFlags_Qt_FindChildOption__PythonToCpp_QFlags_Qt_FindChildOption_;
    return {};
}
static PyObject *QFlags_Qt_FindChildOption__CppToPython_QFlags_Qt_FindChildOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::FindChildOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX]));

}

static void Qt_FindChildOption_PythonToCpp_QFlags_Qt_FindChildOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::FindChildOption> *>(cppOut) =
        ::QFlags<Qt::FindChildOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_FindChildOption_PythonToCpp_QFlags_Qt_FindChildOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_FINDCHILDOPTION_IDX]))
        return Qt_FindChildOption_PythonToCpp_QFlags_Qt_FindChildOption_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_FindChildOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::FindChildOption> *>(cppOut) =
        ::QFlags<Qt::FindChildOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_FindChildOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_FINDCHILDOPTION_IDX]))
        return number_PythonToCpp_QFlags_Qt_FindChildOption_;
    return {};
}
static void Qt_DropAction_PythonToCpp_Qt_DropAction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::DropAction *>(cppOut) =
        static_cast<::Qt::DropAction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_DropAction_PythonToCpp_Qt_DropAction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX]))
        return Qt_DropAction_PythonToCpp_Qt_DropAction;
    return {};
}
static PyObject *Qt_DropAction_CppToPython_Qt_DropAction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::DropAction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX], castCppIn);

}

static void QFlags_Qt_DropAction__PythonToCpp_QFlags_Qt_DropAction_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::DropAction> *>(cppOut) =
        ::QFlags<Qt::DropAction>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_DropAction__PythonToCpp_QFlags_Qt_DropAction__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX]))
        return QFlags_Qt_DropAction__PythonToCpp_QFlags_Qt_DropAction_;
    return {};
}
static PyObject *QFlags_Qt_DropAction__CppToPython_QFlags_Qt_DropAction_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::DropAction> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX]));

}

static void Qt_DropAction_PythonToCpp_QFlags_Qt_DropAction_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::DropAction> *>(cppOut) =
        ::QFlags<Qt::DropAction>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_DropAction_PythonToCpp_QFlags_Qt_DropAction__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX]))
        return Qt_DropAction_PythonToCpp_QFlags_Qt_DropAction_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_DropAction_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::DropAction> *>(cppOut) =
        ::QFlags<Qt::DropAction>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_DropAction__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX]))
        return number_PythonToCpp_QFlags_Qt_DropAction_;
    return {};
}
static void Qt_CheckState_PythonToCpp_Qt_CheckState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::CheckState *>(cppOut) =
        static_cast<::Qt::CheckState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_CheckState_PythonToCpp_Qt_CheckState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_CHECKSTATE_IDX]))
        return Qt_CheckState_PythonToCpp_Qt_CheckState;
    return {};
}
static PyObject *Qt_CheckState_CppToPython_Qt_CheckState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::CheckState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSTATE_IDX], castCppIn);

}

static void Qt_ItemDataRole_PythonToCpp_Qt_ItemDataRole(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ItemDataRole *>(cppOut) =
        static_cast<::Qt::ItemDataRole>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ItemDataRole_PythonToCpp_Qt_ItemDataRole_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX]))
        return Qt_ItemDataRole_PythonToCpp_Qt_ItemDataRole;
    return {};
}
static PyObject *Qt_ItemDataRole_CppToPython_Qt_ItemDataRole(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ItemDataRole *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX], castCppIn);

}

static void Qt_ItemFlag_PythonToCpp_Qt_ItemFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ItemFlag *>(cppOut) =
        static_cast<::Qt::ItemFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ItemFlag_PythonToCpp_Qt_ItemFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX]))
        return Qt_ItemFlag_PythonToCpp_Qt_ItemFlag;
    return {};
}
static PyObject *Qt_ItemFlag_CppToPython_Qt_ItemFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ItemFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX], castCppIn);

}

static void QFlags_Qt_ItemFlag__PythonToCpp_QFlags_Qt_ItemFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::ItemFlag> *>(cppOut) =
        ::QFlags<Qt::ItemFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_ItemFlag__PythonToCpp_QFlags_Qt_ItemFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX]))
        return QFlags_Qt_ItemFlag__PythonToCpp_QFlags_Qt_ItemFlag_;
    return {};
}
static PyObject *QFlags_Qt_ItemFlag__CppToPython_QFlags_Qt_ItemFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::ItemFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX]));

}

static void Qt_ItemFlag_PythonToCpp_QFlags_Qt_ItemFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::ItemFlag> *>(cppOut) =
        ::QFlags<Qt::ItemFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_ItemFlag_PythonToCpp_QFlags_Qt_ItemFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX]))
        return Qt_ItemFlag_PythonToCpp_QFlags_Qt_ItemFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_ItemFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::ItemFlag> *>(cppOut) =
        ::QFlags<Qt::ItemFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_ItemFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX]))
        return number_PythonToCpp_QFlags_Qt_ItemFlag_;
    return {};
}
static void Qt_MatchFlag_PythonToCpp_Qt_MatchFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::MatchFlag *>(cppOut) =
        static_cast<::Qt::MatchFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_MatchFlag_PythonToCpp_Qt_MatchFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX]))
        return Qt_MatchFlag_PythonToCpp_Qt_MatchFlag;
    return {};
}
static PyObject *Qt_MatchFlag_CppToPython_Qt_MatchFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::MatchFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX], castCppIn);

}

static void QFlags_Qt_MatchFlag__PythonToCpp_QFlags_Qt_MatchFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::MatchFlag> *>(cppOut) =
        ::QFlags<Qt::MatchFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_MatchFlag__PythonToCpp_QFlags_Qt_MatchFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX]))
        return QFlags_Qt_MatchFlag__PythonToCpp_QFlags_Qt_MatchFlag_;
    return {};
}
static PyObject *QFlags_Qt_MatchFlag__CppToPython_QFlags_Qt_MatchFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::MatchFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX]));

}

static void Qt_MatchFlag_PythonToCpp_QFlags_Qt_MatchFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::MatchFlag> *>(cppOut) =
        ::QFlags<Qt::MatchFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_MatchFlag_PythonToCpp_QFlags_Qt_MatchFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX]))
        return Qt_MatchFlag_PythonToCpp_QFlags_Qt_MatchFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_MatchFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::MatchFlag> *>(cppOut) =
        ::QFlags<Qt::MatchFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_MatchFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX]))
        return number_PythonToCpp_QFlags_Qt_MatchFlag_;
    return {};
}
static void Qt_WindowModality_PythonToCpp_Qt_WindowModality(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::WindowModality *>(cppOut) =
        static_cast<::Qt::WindowModality>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_WindowModality_PythonToCpp_Qt_WindowModality_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX]))
        return Qt_WindowModality_PythonToCpp_Qt_WindowModality;
    return {};
}
static PyObject *Qt_WindowModality_CppToPython_Qt_WindowModality(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::WindowModality *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX], castCppIn);

}

static void Qt_TextInteractionFlag_PythonToCpp_Qt_TextInteractionFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::TextInteractionFlag *>(cppOut) =
        static_cast<::Qt::TextInteractionFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_TextInteractionFlag_PythonToCpp_Qt_TextInteractionFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX]))
        return Qt_TextInteractionFlag_PythonToCpp_Qt_TextInteractionFlag;
    return {};
}
static PyObject *Qt_TextInteractionFlag_CppToPython_Qt_TextInteractionFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::TextInteractionFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX], castCppIn);

}

static void QFlags_Qt_TextInteractionFlag__PythonToCpp_QFlags_Qt_TextInteractionFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::TextInteractionFlag> *>(cppOut) =
        ::QFlags<Qt::TextInteractionFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_TextInteractionFlag__PythonToCpp_QFlags_Qt_TextInteractionFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX]))
        return QFlags_Qt_TextInteractionFlag__PythonToCpp_QFlags_Qt_TextInteractionFlag_;
    return {};
}
static PyObject *QFlags_Qt_TextInteractionFlag__CppToPython_QFlags_Qt_TextInteractionFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::TextInteractionFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX]));

}

static void Qt_TextInteractionFlag_PythonToCpp_QFlags_Qt_TextInteractionFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::TextInteractionFlag> *>(cppOut) =
        ::QFlags<Qt::TextInteractionFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_TextInteractionFlag_PythonToCpp_QFlags_Qt_TextInteractionFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX]))
        return Qt_TextInteractionFlag_PythonToCpp_QFlags_Qt_TextInteractionFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_TextInteractionFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::TextInteractionFlag> *>(cppOut) =
        ::QFlags<Qt::TextInteractionFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_TextInteractionFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX]))
        return number_PythonToCpp_QFlags_Qt_TextInteractionFlag_;
    return {};
}
static void Qt_EventPriority_PythonToCpp_Qt_EventPriority(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::EventPriority *>(cppOut) =
        static_cast<::Qt::EventPriority>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_EventPriority_PythonToCpp_Qt_EventPriority_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX]))
        return Qt_EventPriority_PythonToCpp_Qt_EventPriority;
    return {};
}
static PyObject *Qt_EventPriority_CppToPython_Qt_EventPriority(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::EventPriority *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX], castCppIn);

}

static void Qt_SizeHint_PythonToCpp_Qt_SizeHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::SizeHint *>(cppOut) =
        static_cast<::Qt::SizeHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_SizeHint_PythonToCpp_Qt_SizeHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX]))
        return Qt_SizeHint_PythonToCpp_Qt_SizeHint;
    return {};
}
static PyObject *Qt_SizeHint_CppToPython_Qt_SizeHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::SizeHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX], castCppIn);

}

static void Qt_WindowFrameSection_PythonToCpp_Qt_WindowFrameSection(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::WindowFrameSection *>(cppOut) =
        static_cast<::Qt::WindowFrameSection>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_WindowFrameSection_PythonToCpp_Qt_WindowFrameSection_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX]))
        return Qt_WindowFrameSection_PythonToCpp_Qt_WindowFrameSection;
    return {};
}
static PyObject *Qt_WindowFrameSection_CppToPython_Qt_WindowFrameSection(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::WindowFrameSection *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX], castCppIn);

}

static void Qt_CoordinateSystem_PythonToCpp_Qt_CoordinateSystem(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::CoordinateSystem *>(cppOut) =
        static_cast<::Qt::CoordinateSystem>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_CoordinateSystem_PythonToCpp_Qt_CoordinateSystem_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX]))
        return Qt_CoordinateSystem_PythonToCpp_Qt_CoordinateSystem;
    return {};
}
static PyObject *Qt_CoordinateSystem_CppToPython_Qt_CoordinateSystem(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::CoordinateSystem *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX], castCppIn);

}

static void Qt_TouchPointState_PythonToCpp_Qt_TouchPointState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::TouchPointState *>(cppOut) =
        static_cast<::Qt::TouchPointState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_TouchPointState_PythonToCpp_Qt_TouchPointState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX]))
        return Qt_TouchPointState_PythonToCpp_Qt_TouchPointState;
    return {};
}
static PyObject *Qt_TouchPointState_CppToPython_Qt_TouchPointState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::TouchPointState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX], castCppIn);

}

static void QFlags_Qt_TouchPointState__PythonToCpp_QFlags_Qt_TouchPointState_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::TouchPointState> *>(cppOut) =
        ::QFlags<Qt::TouchPointState>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_TouchPointState__PythonToCpp_QFlags_Qt_TouchPointState__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX]))
        return QFlags_Qt_TouchPointState__PythonToCpp_QFlags_Qt_TouchPointState_;
    return {};
}
static PyObject *QFlags_Qt_TouchPointState__CppToPython_QFlags_Qt_TouchPointState_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::TouchPointState> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX]));

}

static void Qt_TouchPointState_PythonToCpp_QFlags_Qt_TouchPointState_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::TouchPointState> *>(cppOut) =
        ::QFlags<Qt::TouchPointState>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_TouchPointState_PythonToCpp_QFlags_Qt_TouchPointState__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX]))
        return Qt_TouchPointState_PythonToCpp_QFlags_Qt_TouchPointState_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_TouchPointState_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::TouchPointState> *>(cppOut) =
        ::QFlags<Qt::TouchPointState>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_TouchPointState__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX]))
        return number_PythonToCpp_QFlags_Qt_TouchPointState_;
    return {};
}
static void Qt_GestureState_PythonToCpp_Qt_GestureState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::GestureState *>(cppOut) =
        static_cast<::Qt::GestureState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_GestureState_PythonToCpp_Qt_GestureState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_GESTURESTATE_IDX]))
        return Qt_GestureState_PythonToCpp_Qt_GestureState;
    return {};
}
static PyObject *Qt_GestureState_CppToPython_Qt_GestureState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::GestureState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURESTATE_IDX], castCppIn);

}

static void Qt_GestureType_PythonToCpp_Qt_GestureType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::GestureType *>(cppOut) =
        static_cast<::Qt::GestureType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_GestureType_PythonToCpp_Qt_GestureType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX]))
        return Qt_GestureType_PythonToCpp_Qt_GestureType;
    return {};
}
static PyObject *Qt_GestureType_CppToPython_Qt_GestureType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::GestureType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX], castCppIn);

}

static void Qt_GestureFlag_PythonToCpp_Qt_GestureFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::GestureFlag *>(cppOut) =
        static_cast<::Qt::GestureFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_GestureFlag_PythonToCpp_Qt_GestureFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX]))
        return Qt_GestureFlag_PythonToCpp_Qt_GestureFlag;
    return {};
}
static PyObject *Qt_GestureFlag_CppToPython_Qt_GestureFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::GestureFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX], castCppIn);

}

static void QFlags_Qt_GestureFlag__PythonToCpp_QFlags_Qt_GestureFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::GestureFlag> *>(cppOut) =
        ::QFlags<Qt::GestureFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_GestureFlag__PythonToCpp_QFlags_Qt_GestureFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX]))
        return QFlags_Qt_GestureFlag__PythonToCpp_QFlags_Qt_GestureFlag_;
    return {};
}
static PyObject *QFlags_Qt_GestureFlag__CppToPython_QFlags_Qt_GestureFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::GestureFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX]));

}

static void Qt_GestureFlag_PythonToCpp_QFlags_Qt_GestureFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::GestureFlag> *>(cppOut) =
        ::QFlags<Qt::GestureFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_GestureFlag_PythonToCpp_QFlags_Qt_GestureFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX]))
        return Qt_GestureFlag_PythonToCpp_QFlags_Qt_GestureFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_GestureFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::GestureFlag> *>(cppOut) =
        ::QFlags<Qt::GestureFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_GestureFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX]))
        return number_PythonToCpp_QFlags_Qt_GestureFlag_;
    return {};
}
static void Qt_NativeGestureType_PythonToCpp_Qt_NativeGestureType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::NativeGestureType *>(cppOut) =
        static_cast<::Qt::NativeGestureType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_NativeGestureType_PythonToCpp_Qt_NativeGestureType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX]))
        return Qt_NativeGestureType_PythonToCpp_Qt_NativeGestureType;
    return {};
}
static PyObject *Qt_NativeGestureType_CppToPython_Qt_NativeGestureType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::NativeGestureType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX], castCppIn);

}

static void Qt_NavigationMode_PythonToCpp_Qt_NavigationMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::NavigationMode *>(cppOut) =
        static_cast<::Qt::NavigationMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_NavigationMode_PythonToCpp_Qt_NavigationMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX]))
        return Qt_NavigationMode_PythonToCpp_Qt_NavigationMode;
    return {};
}
static PyObject *Qt_NavigationMode_CppToPython_Qt_NavigationMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::NavigationMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX], castCppIn);

}

static void Qt_CursorMoveStyle_PythonToCpp_Qt_CursorMoveStyle(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::CursorMoveStyle *>(cppOut) =
        static_cast<::Qt::CursorMoveStyle>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_CursorMoveStyle_PythonToCpp_Qt_CursorMoveStyle_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_CURSORMOVESTYLE_IDX]))
        return Qt_CursorMoveStyle_PythonToCpp_Qt_CursorMoveStyle;
    return {};
}
static PyObject *Qt_CursorMoveStyle_CppToPython_Qt_CursorMoveStyle(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::CursorMoveStyle *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORMOVESTYLE_IDX], castCppIn);

}

static void Qt_TimerType_PythonToCpp_Qt_TimerType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::TimerType *>(cppOut) =
        static_cast<::Qt::TimerType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_TimerType_PythonToCpp_Qt_TimerType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX]))
        return Qt_TimerType_PythonToCpp_Qt_TimerType;
    return {};
}
static PyObject *Qt_TimerType_CppToPython_Qt_TimerType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::TimerType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX], castCppIn);

}

static void Qt_ScrollPhase_PythonToCpp_Qt_ScrollPhase(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ScrollPhase *>(cppOut) =
        static_cast<::Qt::ScrollPhase>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ScrollPhase_PythonToCpp_Qt_ScrollPhase_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX]))
        return Qt_ScrollPhase_PythonToCpp_Qt_ScrollPhase;
    return {};
}
static PyObject *Qt_ScrollPhase_CppToPython_Qt_ScrollPhase(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ScrollPhase *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX], castCppIn);

}

static void Qt_MouseEventSource_PythonToCpp_Qt_MouseEventSource(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::MouseEventSource *>(cppOut) =
        static_cast<::Qt::MouseEventSource>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_MouseEventSource_PythonToCpp_Qt_MouseEventSource_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX]))
        return Qt_MouseEventSource_PythonToCpp_Qt_MouseEventSource;
    return {};
}
static PyObject *Qt_MouseEventSource_CppToPython_Qt_MouseEventSource(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::MouseEventSource *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX], castCppIn);

}

static void Qt_MouseEventFlag_PythonToCpp_Qt_MouseEventFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::MouseEventFlag *>(cppOut) =
        static_cast<::Qt::MouseEventFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_MouseEventFlag_PythonToCpp_Qt_MouseEventFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTFLAG_IDX]))
        return Qt_MouseEventFlag_PythonToCpp_Qt_MouseEventFlag;
    return {};
}
static PyObject *Qt_MouseEventFlag_CppToPython_Qt_MouseEventFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::MouseEventFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTFLAG_IDX], castCppIn);

}

static void QFlags_Qt_MouseEventFlag__PythonToCpp_QFlags_Qt_MouseEventFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::MouseEventFlag> *>(cppOut) =
        ::QFlags<Qt::MouseEventFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt_MouseEventFlag__PythonToCpp_QFlags_Qt_MouseEventFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX]))
        return QFlags_Qt_MouseEventFlag__PythonToCpp_QFlags_Qt_MouseEventFlag_;
    return {};
}
static PyObject *QFlags_Qt_MouseEventFlag__CppToPython_QFlags_Qt_MouseEventFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt::MouseEventFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX]));

}

static void Qt_MouseEventFlag_PythonToCpp_QFlags_Qt_MouseEventFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt::MouseEventFlag> *>(cppOut) =
        ::QFlags<Qt::MouseEventFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt_MouseEventFlag_PythonToCpp_QFlags_Qt_MouseEventFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTFLAG_IDX]))
        return Qt_MouseEventFlag_PythonToCpp_QFlags_Qt_MouseEventFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt_MouseEventFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt::MouseEventFlag> *>(cppOut) =
        ::QFlags<Qt::MouseEventFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt_MouseEventFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTFLAG_IDX]))
        return number_PythonToCpp_QFlags_Qt_MouseEventFlag_;
    return {};
}
static void Qt_ChecksumType_PythonToCpp_Qt_ChecksumType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::ChecksumType *>(cppOut) =
        static_cast<::Qt::ChecksumType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_ChecksumType_PythonToCpp_Qt_ChecksumType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_CHECKSUMTYPE_IDX]))
        return Qt_ChecksumType_PythonToCpp_Qt_ChecksumType;
    return {};
}
static PyObject *Qt_ChecksumType_CppToPython_Qt_ChecksumType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::ChecksumType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSUMTYPE_IDX], castCppIn);

}

static void Qt_HighDpiScaleFactorRoundingPolicy_PythonToCpp_Qt_HighDpiScaleFactorRoundingPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt::HighDpiScaleFactorRoundingPolicy *>(cppOut) =
        static_cast<::Qt::HighDpiScaleFactorRoundingPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt_HighDpiScaleFactorRoundingPolicy_PythonToCpp_Qt_HighDpiScaleFactorRoundingPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX]))
        return Qt_HighDpiScaleFactorRoundingPolicy_PythonToCpp_Qt_HighDpiScaleFactorRoundingPolicy;
    return {};
}
static PyObject *Qt_HighDpiScaleFactorRoundingPolicy_CppToPython_Qt_HighDpiScaleFactorRoundingPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt::HighDpiScaleFactorRoundingPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX], castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtCoreQt_SignatureStrings[] = {
    "PySide2.QtCore.Qt.bin(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.bom(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.center(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.dec(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.endl(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.fixed(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.flush(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.forcepoint(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.forcesign(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.hex(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.left(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.lowercasebase(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.lowercasedigits(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.noforcepoint(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.noforcesign(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.noshowbase(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.oct(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.reset(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.right(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.scientific(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.showbase(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.uppercasebase(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.uppercasedigits(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    "PySide2.QtCore.Qt.ws(s:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    nullptr}; // Sentinel

void init_QtCoreQt(PyObject *module)
{
    _Sbk_Qt_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "Qt",
        "Qt",
        &Sbk_Qt_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt_Type);
    InitSignatureStrings(pyType, QtCoreQt_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt_Type), Sbk_Qt_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QtCoreQT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt_TypeF());


    // Initialization of enums.

    // Initialization of enum 'GlobalColor'.
    SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "GlobalColor",
        "2:PySide2.QtCore.Qt.GlobalColor",
        "Qt::GlobalColor");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "color0", (long) Qt::GlobalColor::color0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "color1", (long) Qt::GlobalColor::color1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "black", (long) Qt::GlobalColor::black))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "white", (long) Qt::GlobalColor::white))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "darkGray", (long) Qt::GlobalColor::darkGray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "gray", (long) Qt::GlobalColor::gray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "lightGray", (long) Qt::GlobalColor::lightGray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "red", (long) Qt::GlobalColor::red))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "green", (long) Qt::GlobalColor::green))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "blue", (long) Qt::GlobalColor::blue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "cyan", (long) Qt::GlobalColor::cyan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "magenta", (long) Qt::GlobalColor::magenta))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "yellow", (long) Qt::GlobalColor::yellow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "darkRed", (long) Qt::GlobalColor::darkRed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "darkGreen", (long) Qt::GlobalColor::darkGreen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "darkBlue", (long) Qt::GlobalColor::darkBlue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "darkCyan", (long) Qt::GlobalColor::darkCyan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "darkMagenta", (long) Qt::GlobalColor::darkMagenta))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "darkYellow", (long) Qt::GlobalColor::darkYellow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
        Sbk_Qt_TypeF(), "transparent", (long) Qt::GlobalColor::transparent))
        return;
    // Register converter for enum 'Qt::GlobalColor'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX],
            Qt_GlobalColor_CppToPython_Qt_GlobalColor);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_GlobalColor_PythonToCpp_Qt_GlobalColor,
            is_Qt_GlobalColor_PythonToCpp_Qt_GlobalColor_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::GlobalColor");
        Shiboken::Conversions::registerConverterName(converter, "GlobalColor");
    }
    // End of 'GlobalColor' enum.

    // Initialization of enum 'KeyboardModifier'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.KeyboardModifiers", SbkPySide2_QtCore_Qt_KeyboardModifier_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "KeyboardModifier",
        "2:PySide2.QtCore.Qt.KeyboardModifier",
        "Qt::KeyboardModifier",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX],
        Sbk_Qt_TypeF(), "NoModifier", (long) Qt::KeyboardModifier::NoModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX],
        Sbk_Qt_TypeF(), "ShiftModifier", (long) Qt::KeyboardModifier::ShiftModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX],
        Sbk_Qt_TypeF(), "ControlModifier", (long) Qt::KeyboardModifier::ControlModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX],
        Sbk_Qt_TypeF(), "AltModifier", (long) Qt::KeyboardModifier::AltModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX],
        Sbk_Qt_TypeF(), "MetaModifier", (long) Qt::KeyboardModifier::MetaModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX],
        Sbk_Qt_TypeF(), "KeypadModifier", (long) Qt::KeyboardModifier::KeypadModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX],
        Sbk_Qt_TypeF(), "GroupSwitchModifier", (long) Qt::KeyboardModifier::GroupSwitchModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX],
        Sbk_Qt_TypeF(), "KeyboardModifierMask", (long) Qt::KeyboardModifier::KeyboardModifierMask))
        return;
    // Register converter for enum 'Qt::KeyboardModifier'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX],
            Qt_KeyboardModifier_CppToPython_Qt_KeyboardModifier);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_KeyboardModifier_PythonToCpp_Qt_KeyboardModifier,
            is_Qt_KeyboardModifier_PythonToCpp_Qt_KeyboardModifier_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::KeyboardModifier");
        Shiboken::Conversions::registerConverterName(converter, "KeyboardModifier");
    }
    // Register converter for flag 'QFlags<Qt::KeyboardModifier>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX],
            QFlags_Qt_KeyboardModifier__CppToPython_QFlags_Qt_KeyboardModifier_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_KeyboardModifier_PythonToCpp_QFlags_Qt_KeyboardModifier_,
            is_Qt_KeyboardModifier_PythonToCpp_QFlags_Qt_KeyboardModifier__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_KeyboardModifier__PythonToCpp_QFlags_Qt_KeyboardModifier_,
            is_QFlags_Qt_KeyboardModifier__PythonToCpp_QFlags_Qt_KeyboardModifier__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_KeyboardModifier_,
            is_number_PythonToCpp_QFlags_Qt_KeyboardModifier__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::KeyboardModifiers");
        Shiboken::Conversions::registerConverterName(converter, "KeyboardModifiers");
    }
    // End of 'KeyboardModifier' enum/flags.

    // Initialization of enum 'Modifier'.
    SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "Modifier",
        "2:PySide2.QtCore.Qt.Modifier",
        "Qt::Modifier");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX],
        Sbk_Qt_TypeF(), "META", (long) Qt::Modifier::META))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX],
        Sbk_Qt_TypeF(), "SHIFT", (long) Qt::Modifier::SHIFT))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX],
        Sbk_Qt_TypeF(), "CTRL", (long) Qt::Modifier::CTRL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX],
        Sbk_Qt_TypeF(), "ALT", (long) Qt::Modifier::ALT))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX],
        Sbk_Qt_TypeF(), "MODIFIER_MASK", (long) Qt::Modifier::MODIFIER_MASK))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX],
        Sbk_Qt_TypeF(), "UNICODE_ACCEL", (long) Qt::Modifier::UNICODE_ACCEL))
        return;
    // Register converter for enum 'Qt::Modifier'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX],
            Qt_Modifier_CppToPython_Qt_Modifier);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_Modifier_PythonToCpp_Qt_Modifier,
            is_Qt_Modifier_PythonToCpp_Qt_Modifier_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_MODIFIER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::Modifier");
        Shiboken::Conversions::registerConverterName(converter, "Modifier");
    }
    // End of 'Modifier' enum.

    // Initialization of enum 'MouseButton'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.MouseButtons", SbkPySide2_QtCore_Qt_MouseButton_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "MouseButton",
        "2:PySide2.QtCore.Qt.MouseButton",
        "Qt::MouseButton",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "NoButton", (long) Qt::MouseButton::NoButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "LeftButton", (long) Qt::MouseButton::LeftButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "RightButton", (long) Qt::MouseButton::RightButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "MiddleButton", (long) Qt::MouseButton::MiddleButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "MidButton", (long) Qt::MouseButton::MidButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "BackButton", (long) Qt::MouseButton::BackButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "XButton1", (long) Qt::MouseButton::XButton1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton1", (long) Qt::MouseButton::ExtraButton1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ForwardButton", (long) Qt::MouseButton::ForwardButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "XButton2", (long) Qt::MouseButton::XButton2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton2", (long) Qt::MouseButton::ExtraButton2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "TaskButton", (long) Qt::MouseButton::TaskButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton3", (long) Qt::MouseButton::ExtraButton3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton4", (long) Qt::MouseButton::ExtraButton4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton5", (long) Qt::MouseButton::ExtraButton5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton6", (long) Qt::MouseButton::ExtraButton6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton7", (long) Qt::MouseButton::ExtraButton7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton8", (long) Qt::MouseButton::ExtraButton8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton9", (long) Qt::MouseButton::ExtraButton9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton10", (long) Qt::MouseButton::ExtraButton10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton11", (long) Qt::MouseButton::ExtraButton11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton12", (long) Qt::MouseButton::ExtraButton12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton13", (long) Qt::MouseButton::ExtraButton13))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton14", (long) Qt::MouseButton::ExtraButton14))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton15", (long) Qt::MouseButton::ExtraButton15))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton16", (long) Qt::MouseButton::ExtraButton16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton17", (long) Qt::MouseButton::ExtraButton17))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton18", (long) Qt::MouseButton::ExtraButton18))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton19", (long) Qt::MouseButton::ExtraButton19))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton20", (long) Qt::MouseButton::ExtraButton20))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton21", (long) Qt::MouseButton::ExtraButton21))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton22", (long) Qt::MouseButton::ExtraButton22))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton23", (long) Qt::MouseButton::ExtraButton23))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "ExtraButton24", (long) Qt::MouseButton::ExtraButton24))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "AllButtons", (long) Qt::MouseButton::AllButtons))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "MaxMouseButton", (long) Qt::MouseButton::MaxMouseButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
        Sbk_Qt_TypeF(), "MouseButtonMask", (long) Qt::MouseButton::MouseButtonMask))
        return;
    // Register converter for enum 'Qt::MouseButton'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX],
            Qt_MouseButton_CppToPython_Qt_MouseButton);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_MouseButton_PythonToCpp_Qt_MouseButton,
            is_Qt_MouseButton_PythonToCpp_Qt_MouseButton_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::MouseButton");
        Shiboken::Conversions::registerConverterName(converter, "MouseButton");
    }
    // Register converter for flag 'QFlags<Qt::MouseButton>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX],
            QFlags_Qt_MouseButton__CppToPython_QFlags_Qt_MouseButton_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_MouseButton_PythonToCpp_QFlags_Qt_MouseButton_,
            is_Qt_MouseButton_PythonToCpp_QFlags_Qt_MouseButton__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_MouseButton__PythonToCpp_QFlags_Qt_MouseButton_,
            is_QFlags_Qt_MouseButton__PythonToCpp_QFlags_Qt_MouseButton__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_MouseButton_,
            is_number_PythonToCpp_QFlags_Qt_MouseButton__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::MouseButtons");
        Shiboken::Conversions::registerConverterName(converter, "MouseButtons");
    }
    // End of 'MouseButton' enum/flags.

    // Initialization of enum 'Orientation'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.Orientations", SbkPySide2_QtCore_Qt_Orientation_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "Orientation",
        "2:PySide2.QtCore.Qt.Orientation",
        "Qt::Orientation",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX],
        Sbk_Qt_TypeF(), "Horizontal", (long) Qt::Orientation::Horizontal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX],
        Sbk_Qt_TypeF(), "Vertical", (long) Qt::Orientation::Vertical))
        return;
    // Register converter for enum 'Qt::Orientation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX],
            Qt_Orientation_CppToPython_Qt_Orientation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_Orientation_PythonToCpp_Qt_Orientation,
            is_Qt_Orientation_PythonToCpp_Qt_Orientation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::Orientation");
        Shiboken::Conversions::registerConverterName(converter, "Orientation");
    }
    // Register converter for flag 'QFlags<Qt::Orientation>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX],
            QFlags_Qt_Orientation__CppToPython_QFlags_Qt_Orientation_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_Orientation_PythonToCpp_QFlags_Qt_Orientation_,
            is_Qt_Orientation_PythonToCpp_QFlags_Qt_Orientation__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_Orientation__PythonToCpp_QFlags_Qt_Orientation_,
            is_QFlags_Qt_Orientation__PythonToCpp_QFlags_Qt_Orientation__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_Orientation_,
            is_number_PythonToCpp_QFlags_Qt_Orientation__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::Orientations");
        Shiboken::Conversions::registerConverterName(converter, "Orientations");
    }
    // End of 'Orientation' enum/flags.

    // Initialization of enum 'FocusPolicy'.
    SbkPySide2_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "FocusPolicy",
        "2:PySide2.QtCore.Qt.FocusPolicy",
        "Qt::FocusPolicy");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX],
        Sbk_Qt_TypeF(), "NoFocus", (long) Qt::FocusPolicy::NoFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX],
        Sbk_Qt_TypeF(), "TabFocus", (long) Qt::FocusPolicy::TabFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX],
        Sbk_Qt_TypeF(), "ClickFocus", (long) Qt::FocusPolicy::ClickFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX],
        Sbk_Qt_TypeF(), "StrongFocus", (long) Qt::FocusPolicy::StrongFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX],
        Sbk_Qt_TypeF(), "WheelFocus", (long) Qt::FocusPolicy::WheelFocus))
        return;
    // Register converter for enum 'Qt::FocusPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX],
            Qt_FocusPolicy_CppToPython_Qt_FocusPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_FocusPolicy_PythonToCpp_Qt_FocusPolicy,
            is_Qt_FocusPolicy_PythonToCpp_Qt_FocusPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::FocusPolicy");
        Shiboken::Conversions::registerConverterName(converter, "FocusPolicy");
    }
    // End of 'FocusPolicy' enum.

    // Initialization of enum 'TabFocusBehavior'.
    SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "TabFocusBehavior",
        "2:PySide2.QtCore.Qt.TabFocusBehavior",
        "Qt::TabFocusBehavior");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX],
        Sbk_Qt_TypeF(), "NoTabFocus", (long) Qt::TabFocusBehavior::NoTabFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX],
        Sbk_Qt_TypeF(), "TabFocusTextControls", (long) Qt::TabFocusBehavior::TabFocusTextControls))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX],
        Sbk_Qt_TypeF(), "TabFocusListControls", (long) Qt::TabFocusBehavior::TabFocusListControls))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX],
        Sbk_Qt_TypeF(), "TabFocusAllControls", (long) Qt::TabFocusBehavior::TabFocusAllControls))
        return;
    // Register converter for enum 'Qt::TabFocusBehavior'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX],
            Qt_TabFocusBehavior_CppToPython_Qt_TabFocusBehavior);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TabFocusBehavior_PythonToCpp_Qt_TabFocusBehavior,
            is_Qt_TabFocusBehavior_PythonToCpp_Qt_TabFocusBehavior_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TabFocusBehavior");
        Shiboken::Conversions::registerConverterName(converter, "TabFocusBehavior");
    }
    // End of 'TabFocusBehavior' enum.

    // Initialization of enum 'SortOrder'.
    SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "SortOrder",
        "2:PySide2.QtCore.Qt.SortOrder",
        "Qt::SortOrder");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX],
        Sbk_Qt_TypeF(), "AscendingOrder", (long) Qt::SortOrder::AscendingOrder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX],
        Sbk_Qt_TypeF(), "DescendingOrder", (long) Qt::SortOrder::DescendingOrder))
        return;
    // Register converter for enum 'Qt::SortOrder'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX],
            Qt_SortOrder_CppToPython_Qt_SortOrder);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_SortOrder_PythonToCpp_Qt_SortOrder,
            is_Qt_SortOrder_PythonToCpp_Qt_SortOrder_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::SortOrder");
        Shiboken::Conversions::registerConverterName(converter, "SortOrder");
    }
    // End of 'SortOrder' enum.

    // Initialization of enum 'SplitBehaviorFlags'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.SplitBehavior", SbkPySide2_QtCore_Qt_SplitBehaviorFlags_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_SPLITBEHAVIORFLAGS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "SplitBehaviorFlags",
        "2:PySide2.QtCore.Qt.SplitBehaviorFlags",
        "Qt::SplitBehaviorFlags",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_SPLITBEHAVIORFLAGS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SPLITBEHAVIORFLAGS_IDX],
        Sbk_Qt_TypeF(), "KeepEmptyParts", (long) Qt::SplitBehaviorFlags::KeepEmptyParts))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SPLITBEHAVIORFLAGS_IDX],
        Sbk_Qt_TypeF(), "SkipEmptyParts", (long) Qt::SplitBehaviorFlags::SkipEmptyParts))
        return;
    // Register converter for enum 'Qt::SplitBehaviorFlags'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_SPLITBEHAVIORFLAGS_IDX],
            Qt_SplitBehaviorFlags_CppToPython_Qt_SplitBehaviorFlags);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_SplitBehaviorFlags_PythonToCpp_Qt_SplitBehaviorFlags,
            is_Qt_SplitBehaviorFlags_PythonToCpp_Qt_SplitBehaviorFlags_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_SPLITBEHAVIORFLAGS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::SplitBehaviorFlags");
        Shiboken::Conversions::registerConverterName(converter, "SplitBehaviorFlags");
    }
    // Register converter for flag 'QFlags<Qt::SplitBehaviorFlags>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX],
            QFlags_Qt_SplitBehaviorFlags__CppToPython_QFlags_Qt_SplitBehaviorFlags_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_SplitBehaviorFlags_PythonToCpp_QFlags_Qt_SplitBehaviorFlags_,
            is_Qt_SplitBehaviorFlags_PythonToCpp_QFlags_Qt_SplitBehaviorFlags__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_SplitBehaviorFlags__PythonToCpp_QFlags_Qt_SplitBehaviorFlags_,
            is_QFlags_Qt_SplitBehaviorFlags__PythonToCpp_QFlags_Qt_SplitBehaviorFlags__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_SplitBehaviorFlags_,
            is_number_PythonToCpp_QFlags_Qt_SplitBehaviorFlags__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SPLITBEHAVIORFLAGS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::SplitBehavior");
        Shiboken::Conversions::registerConverterName(converter, "SplitBehavior");
    }
    // End of 'SplitBehaviorFlags' enum/flags.

    // Initialization of enum 'TileRule'.
    SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "TileRule",
        "2:PySide2.QtCore.Qt.TileRule",
        "Qt::TileRule");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX],
        Sbk_Qt_TypeF(), "StretchTile", (long) Qt::TileRule::StretchTile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX],
        Sbk_Qt_TypeF(), "RepeatTile", (long) Qt::TileRule::RepeatTile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX],
        Sbk_Qt_TypeF(), "RoundTile", (long) Qt::TileRule::RoundTile))
        return;
    // Register converter for enum 'Qt::TileRule'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX],
            Qt_TileRule_CppToPython_Qt_TileRule);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TileRule_PythonToCpp_Qt_TileRule,
            is_Qt_TileRule_PythonToCpp_Qt_TileRule_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TileRule");
        Shiboken::Conversions::registerConverterName(converter, "TileRule");
    }
    // End of 'TileRule' enum.

    // Initialization of enum 'AlignmentFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.Alignment", SbkPySide2_QtCore_Qt_AlignmentFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "AlignmentFlag",
        "2:PySide2.QtCore.Qt.AlignmentFlag",
        "Qt::AlignmentFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignLeft", (long) Qt::AlignmentFlag::AlignLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignLeading", (long) Qt::AlignmentFlag::AlignLeading))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignRight", (long) Qt::AlignmentFlag::AlignRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignTrailing", (long) Qt::AlignmentFlag::AlignTrailing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignHCenter", (long) Qt::AlignmentFlag::AlignHCenter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignJustify", (long) Qt::AlignmentFlag::AlignJustify))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignAbsolute", (long) Qt::AlignmentFlag::AlignAbsolute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignHorizontal_Mask", (long) Qt::AlignmentFlag::AlignHorizontal_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignTop", (long) Qt::AlignmentFlag::AlignTop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignBottom", (long) Qt::AlignmentFlag::AlignBottom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignVCenter", (long) Qt::AlignmentFlag::AlignVCenter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignBaseline", (long) Qt::AlignmentFlag::AlignBaseline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignVertical_Mask", (long) Qt::AlignmentFlag::AlignVertical_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
        Sbk_Qt_TypeF(), "AlignCenter", (long) Qt::AlignmentFlag::AlignCenter))
        return;
    // Register converter for enum 'Qt::AlignmentFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX],
            Qt_AlignmentFlag_CppToPython_Qt_AlignmentFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_AlignmentFlag_PythonToCpp_Qt_AlignmentFlag,
            is_Qt_AlignmentFlag_PythonToCpp_Qt_AlignmentFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::AlignmentFlag");
        Shiboken::Conversions::registerConverterName(converter, "AlignmentFlag");
    }
    // Register converter for flag 'QFlags<Qt::AlignmentFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX],
            QFlags_Qt_AlignmentFlag__CppToPython_QFlags_Qt_AlignmentFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_AlignmentFlag_PythonToCpp_QFlags_Qt_AlignmentFlag_,
            is_Qt_AlignmentFlag_PythonToCpp_QFlags_Qt_AlignmentFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_AlignmentFlag__PythonToCpp_QFlags_Qt_AlignmentFlag_,
            is_QFlags_Qt_AlignmentFlag__PythonToCpp_QFlags_Qt_AlignmentFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_AlignmentFlag_,
            is_number_PythonToCpp_QFlags_Qt_AlignmentFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::Alignment");
        Shiboken::Conversions::registerConverterName(converter, "Alignment");
    }
    // End of 'AlignmentFlag' enum/flags.

    // Initialization of enum 'TextFlag'.
    SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "TextFlag",
        "2:PySide2.QtCore.Qt.TextFlag",
        "Qt::TextFlag");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextSingleLine", (long) Qt::TextFlag::TextSingleLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextDontClip", (long) Qt::TextFlag::TextDontClip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextExpandTabs", (long) Qt::TextFlag::TextExpandTabs))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextShowMnemonic", (long) Qt::TextFlag::TextShowMnemonic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextWordWrap", (long) Qt::TextFlag::TextWordWrap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextWrapAnywhere", (long) Qt::TextFlag::TextWrapAnywhere))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextDontPrint", (long) Qt::TextFlag::TextDontPrint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextIncludeTrailingSpaces", (long) Qt::TextFlag::TextIncludeTrailingSpaces))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextHideMnemonic", (long) Qt::TextFlag::TextHideMnemonic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextJustificationForced", (long) Qt::TextFlag::TextJustificationForced))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextForceLeftToRight", (long) Qt::TextFlag::TextForceLeftToRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextForceRightToLeft", (long) Qt::TextFlag::TextForceRightToLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextLongestVariant", (long) Qt::TextFlag::TextLongestVariant))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
        Sbk_Qt_TypeF(), "TextBypassShaping", (long) Qt::TextFlag::TextBypassShaping))
        return;
    // Register converter for enum 'Qt::TextFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX],
            Qt_TextFlag_CppToPython_Qt_TextFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TextFlag_PythonToCpp_Qt_TextFlag,
            is_Qt_TextFlag_PythonToCpp_Qt_TextFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TextFlag");
        Shiboken::Conversions::registerConverterName(converter, "TextFlag");
    }
    // End of 'TextFlag' enum.

    // Initialization of enum 'TextElideMode'.
    SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "TextElideMode",
        "2:PySide2.QtCore.Qt.TextElideMode",
        "Qt::TextElideMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX],
        Sbk_Qt_TypeF(), "ElideLeft", (long) Qt::TextElideMode::ElideLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX],
        Sbk_Qt_TypeF(), "ElideRight", (long) Qt::TextElideMode::ElideRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX],
        Sbk_Qt_TypeF(), "ElideMiddle", (long) Qt::TextElideMode::ElideMiddle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX],
        Sbk_Qt_TypeF(), "ElideNone", (long) Qt::TextElideMode::ElideNone))
        return;
    // Register converter for enum 'Qt::TextElideMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX],
            Qt_TextElideMode_CppToPython_Qt_TextElideMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TextElideMode_PythonToCpp_Qt_TextElideMode,
            is_Qt_TextElideMode_PythonToCpp_Qt_TextElideMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TextElideMode");
        Shiboken::Conversions::registerConverterName(converter, "TextElideMode");
    }
    // End of 'TextElideMode' enum.

    // Initialization of enum 'WhiteSpaceMode'.
    SbkPySide2_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "WhiteSpaceMode",
        "2:PySide2.QtCore.Qt.WhiteSpaceMode",
        "Qt::WhiteSpaceMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX],
        Sbk_Qt_TypeF(), "WhiteSpaceNormal", (long) Qt::WhiteSpaceMode::WhiteSpaceNormal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX],
        Sbk_Qt_TypeF(), "WhiteSpacePre", (long) Qt::WhiteSpaceMode::WhiteSpacePre))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX],
        Sbk_Qt_TypeF(), "WhiteSpaceNoWrap", (long) Qt::WhiteSpaceMode::WhiteSpaceNoWrap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX],
        Sbk_Qt_TypeF(), "WhiteSpaceModeUndefined", (long) Qt::WhiteSpaceMode::WhiteSpaceModeUndefined))
        return;
    // Register converter for enum 'Qt::WhiteSpaceMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX],
            Qt_WhiteSpaceMode_CppToPython_Qt_WhiteSpaceMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_WhiteSpaceMode_PythonToCpp_Qt_WhiteSpaceMode,
            is_Qt_WhiteSpaceMode_PythonToCpp_Qt_WhiteSpaceMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::WhiteSpaceMode");
        Shiboken::Conversions::registerConverterName(converter, "WhiteSpaceMode");
    }
    // End of 'WhiteSpaceMode' enum.

    // Initialization of enum 'HitTestAccuracy'.
    SbkPySide2_QtCoreTypes[SBK_QT_HITTESTACCURACY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "HitTestAccuracy",
        "2:PySide2.QtCore.Qt.HitTestAccuracy",
        "Qt::HitTestAccuracy");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_HITTESTACCURACY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_HITTESTACCURACY_IDX],
        Sbk_Qt_TypeF(), "ExactHit", (long) Qt::HitTestAccuracy::ExactHit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_HITTESTACCURACY_IDX],
        Sbk_Qt_TypeF(), "FuzzyHit", (long) Qt::HitTestAccuracy::FuzzyHit))
        return;
    // Register converter for enum 'Qt::HitTestAccuracy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_HITTESTACCURACY_IDX],
            Qt_HitTestAccuracy_CppToPython_Qt_HitTestAccuracy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_HitTestAccuracy_PythonToCpp_Qt_HitTestAccuracy,
            is_Qt_HitTestAccuracy_PythonToCpp_Qt_HitTestAccuracy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_HITTESTACCURACY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::HitTestAccuracy");
        Shiboken::Conversions::registerConverterName(converter, "HitTestAccuracy");
    }
    // End of 'HitTestAccuracy' enum.

    // Initialization of enum 'WindowType'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.WindowFlags", SbkPySide2_QtCore_Qt_WindowType_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "WindowType",
        "2:PySide2.QtCore.Qt.WindowType",
        "Qt::WindowType",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "Widget", (long) Qt::WindowType::Widget))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "Window", (long) Qt::WindowType::Window))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "Dialog", (long) Qt::WindowType::Dialog))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "Sheet", (long) Qt::WindowType::Sheet))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "Drawer", (long) Qt::WindowType::Drawer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "Popup", (long) Qt::WindowType::Popup))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "Tool", (long) Qt::WindowType::Tool))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "ToolTip", (long) Qt::WindowType::ToolTip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "SplashScreen", (long) Qt::WindowType::SplashScreen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "Desktop", (long) Qt::WindowType::Desktop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "SubWindow", (long) Qt::WindowType::SubWindow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "ForeignWindow", (long) Qt::WindowType::ForeignWindow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "CoverWindow", (long) Qt::WindowType::CoverWindow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowType_Mask", (long) Qt::WindowType::WindowType_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "MSWindowsFixedSizeDialogHint", (long) Qt::WindowType::MSWindowsFixedSizeDialogHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "MSWindowsOwnDC", (long) Qt::WindowType::MSWindowsOwnDC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "BypassWindowManagerHint", (long) Qt::WindowType::BypassWindowManagerHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "X11BypassWindowManagerHint", (long) Qt::WindowType::X11BypassWindowManagerHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "FramelessWindowHint", (long) Qt::WindowType::FramelessWindowHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowTitleHint", (long) Qt::WindowType::WindowTitleHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowSystemMenuHint", (long) Qt::WindowType::WindowSystemMenuHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowMinimizeButtonHint", (long) Qt::WindowType::WindowMinimizeButtonHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowMaximizeButtonHint", (long) Qt::WindowType::WindowMaximizeButtonHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowMinMaxButtonsHint", (long) Qt::WindowType::WindowMinMaxButtonsHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowContextHelpButtonHint", (long) Qt::WindowType::WindowContextHelpButtonHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowShadeButtonHint", (long) Qt::WindowType::WindowShadeButtonHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowStaysOnTopHint", (long) Qt::WindowType::WindowStaysOnTopHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowTransparentForInput", (long) Qt::WindowType::WindowTransparentForInput))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowOverridesSystemGestures", (long) Qt::WindowType::WindowOverridesSystemGestures))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowDoesNotAcceptFocus", (long) Qt::WindowType::WindowDoesNotAcceptFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "MaximizeUsingFullscreenGeometryHint", (long) Qt::WindowType::MaximizeUsingFullscreenGeometryHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "CustomizeWindowHint", (long) Qt::WindowType::CustomizeWindowHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowStaysOnBottomHint", (long) Qt::WindowType::WindowStaysOnBottomHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowCloseButtonHint", (long) Qt::WindowType::WindowCloseButtonHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "MacWindowToolBarButtonHint", (long) Qt::WindowType::MacWindowToolBarButtonHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "BypassGraphicsProxyWidget", (long) Qt::WindowType::BypassGraphicsProxyWidget))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "NoDropShadowWindowHint", (long) Qt::WindowType::NoDropShadowWindowHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
        Sbk_Qt_TypeF(), "WindowFullscreenButtonHint", (long) Qt::WindowType::WindowFullscreenButtonHint))
        return;
    // Register converter for enum 'Qt::WindowType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX],
            Qt_WindowType_CppToPython_Qt_WindowType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_WindowType_PythonToCpp_Qt_WindowType,
            is_Qt_WindowType_PythonToCpp_Qt_WindowType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::WindowType");
        Shiboken::Conversions::registerConverterName(converter, "WindowType");
    }
    // Register converter for flag 'QFlags<Qt::WindowType>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX],
            QFlags_Qt_WindowType__CppToPython_QFlags_Qt_WindowType_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_WindowType_PythonToCpp_QFlags_Qt_WindowType_,
            is_Qt_WindowType_PythonToCpp_QFlags_Qt_WindowType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_WindowType__PythonToCpp_QFlags_Qt_WindowType_,
            is_QFlags_Qt_WindowType__PythonToCpp_QFlags_Qt_WindowType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_WindowType_,
            is_number_PythonToCpp_QFlags_Qt_WindowType__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::WindowFlags");
        Shiboken::Conversions::registerConverterName(converter, "WindowFlags");
    }
    // End of 'WindowType' enum/flags.

    // Initialization of enum 'WindowState'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.WindowStates", SbkPySide2_QtCore_Qt_WindowState_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "WindowState",
        "2:PySide2.QtCore.Qt.WindowState",
        "Qt::WindowState",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX],
        Sbk_Qt_TypeF(), "WindowNoState", (long) Qt::WindowState::WindowNoState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX],
        Sbk_Qt_TypeF(), "WindowMinimized", (long) Qt::WindowState::WindowMinimized))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX],
        Sbk_Qt_TypeF(), "WindowMaximized", (long) Qt::WindowState::WindowMaximized))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX],
        Sbk_Qt_TypeF(), "WindowFullScreen", (long) Qt::WindowState::WindowFullScreen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX],
        Sbk_Qt_TypeF(), "WindowActive", (long) Qt::WindowState::WindowActive))
        return;
    // Register converter for enum 'Qt::WindowState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX],
            Qt_WindowState_CppToPython_Qt_WindowState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_WindowState_PythonToCpp_Qt_WindowState,
            is_Qt_WindowState_PythonToCpp_Qt_WindowState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::WindowState");
        Shiboken::Conversions::registerConverterName(converter, "WindowState");
    }
    // Register converter for flag 'QFlags<Qt::WindowState>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX],
            QFlags_Qt_WindowState__CppToPython_QFlags_Qt_WindowState_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_WindowState_PythonToCpp_QFlags_Qt_WindowState_,
            is_Qt_WindowState_PythonToCpp_QFlags_Qt_WindowState__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_WindowState__PythonToCpp_QFlags_Qt_WindowState_,
            is_QFlags_Qt_WindowState__PythonToCpp_QFlags_Qt_WindowState__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_WindowState_,
            is_number_PythonToCpp_QFlags_Qt_WindowState__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::WindowStates");
        Shiboken::Conversions::registerConverterName(converter, "WindowStates");
    }
    // End of 'WindowState' enum/flags.

    // Initialization of enum 'ApplicationState'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.ApplicationStates", SbkPySide2_QtCore_Qt_ApplicationState_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ApplicationState",
        "2:PySide2.QtCore.Qt.ApplicationState",
        "Qt::ApplicationState",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX],
        Sbk_Qt_TypeF(), "ApplicationSuspended", (long) Qt::ApplicationState::ApplicationSuspended))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX],
        Sbk_Qt_TypeF(), "ApplicationHidden", (long) Qt::ApplicationState::ApplicationHidden))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX],
        Sbk_Qt_TypeF(), "ApplicationInactive", (long) Qt::ApplicationState::ApplicationInactive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX],
        Sbk_Qt_TypeF(), "ApplicationActive", (long) Qt::ApplicationState::ApplicationActive))
        return;
    // Register converter for enum 'Qt::ApplicationState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX],
            Qt_ApplicationState_CppToPython_Qt_ApplicationState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ApplicationState_PythonToCpp_Qt_ApplicationState,
            is_Qt_ApplicationState_PythonToCpp_Qt_ApplicationState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ApplicationState");
        Shiboken::Conversions::registerConverterName(converter, "ApplicationState");
    }
    // Register converter for flag 'QFlags<Qt::ApplicationState>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX],
            QFlags_Qt_ApplicationState__CppToPython_QFlags_Qt_ApplicationState_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ApplicationState_PythonToCpp_QFlags_Qt_ApplicationState_,
            is_Qt_ApplicationState_PythonToCpp_QFlags_Qt_ApplicationState__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_ApplicationState__PythonToCpp_QFlags_Qt_ApplicationState_,
            is_QFlags_Qt_ApplicationState__PythonToCpp_QFlags_Qt_ApplicationState__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_ApplicationState_,
            is_number_PythonToCpp_QFlags_Qt_ApplicationState__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_APPLICATIONSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ApplicationStates");
        Shiboken::Conversions::registerConverterName(converter, "ApplicationStates");
    }
    // End of 'ApplicationState' enum/flags.

    // Initialization of enum 'ScreenOrientation'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.ScreenOrientations", SbkPySide2_QtCore_Qt_ScreenOrientation_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ScreenOrientation",
        "2:PySide2.QtCore.Qt.ScreenOrientation",
        "Qt::ScreenOrientation",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX],
        Sbk_Qt_TypeF(), "PrimaryOrientation", (long) Qt::ScreenOrientation::PrimaryOrientation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX],
        Sbk_Qt_TypeF(), "PortraitOrientation", (long) Qt::ScreenOrientation::PortraitOrientation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX],
        Sbk_Qt_TypeF(), "LandscapeOrientation", (long) Qt::ScreenOrientation::LandscapeOrientation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX],
        Sbk_Qt_TypeF(), "InvertedPortraitOrientation", (long) Qt::ScreenOrientation::InvertedPortraitOrientation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX],
        Sbk_Qt_TypeF(), "InvertedLandscapeOrientation", (long) Qt::ScreenOrientation::InvertedLandscapeOrientation))
        return;
    // Register converter for enum 'Qt::ScreenOrientation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX],
            Qt_ScreenOrientation_CppToPython_Qt_ScreenOrientation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ScreenOrientation_PythonToCpp_Qt_ScreenOrientation,
            is_Qt_ScreenOrientation_PythonToCpp_Qt_ScreenOrientation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_SCREENORIENTATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ScreenOrientation");
        Shiboken::Conversions::registerConverterName(converter, "ScreenOrientation");
    }
    // Register converter for flag 'QFlags<Qt::ScreenOrientation>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX],
            QFlags_Qt_ScreenOrientation__CppToPython_QFlags_Qt_ScreenOrientation_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ScreenOrientation_PythonToCpp_QFlags_Qt_ScreenOrientation_,
            is_Qt_ScreenOrientation_PythonToCpp_QFlags_Qt_ScreenOrientation__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_ScreenOrientation__PythonToCpp_QFlags_Qt_ScreenOrientation_,
            is_QFlags_Qt_ScreenOrientation__PythonToCpp_QFlags_Qt_ScreenOrientation__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_ScreenOrientation_,
            is_number_PythonToCpp_QFlags_Qt_ScreenOrientation__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_SCREENORIENTATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ScreenOrientations");
        Shiboken::Conversions::registerConverterName(converter, "ScreenOrientations");
    }
    // End of 'ScreenOrientation' enum/flags.

    // Initialization of enum 'WidgetAttribute'.
    SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "WidgetAttribute",
        "2:PySide2.QtCore.Qt.WidgetAttribute",
        "Qt::WidgetAttribute");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_Disabled", (long) Qt::WidgetAttribute::WA_Disabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_UnderMouse", (long) Qt::WidgetAttribute::WA_UnderMouse))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MouseTracking", (long) Qt::WidgetAttribute::WA_MouseTracking))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_ContentsPropagated", (long) Qt::WidgetAttribute::WA_ContentsPropagated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_OpaquePaintEvent", (long) Qt::WidgetAttribute::WA_OpaquePaintEvent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_NoBackground", (long) Qt::WidgetAttribute::WA_NoBackground))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_StaticContents", (long) Qt::WidgetAttribute::WA_StaticContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_LaidOut", (long) Qt::WidgetAttribute::WA_LaidOut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_PaintOnScreen", (long) Qt::WidgetAttribute::WA_PaintOnScreen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_NoSystemBackground", (long) Qt::WidgetAttribute::WA_NoSystemBackground))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_UpdatesDisabled", (long) Qt::WidgetAttribute::WA_UpdatesDisabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_Mapped", (long) Qt::WidgetAttribute::WA_Mapped))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacNoClickThrough", (long) Qt::WidgetAttribute::WA_MacNoClickThrough))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_InputMethodEnabled", (long) Qt::WidgetAttribute::WA_InputMethodEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_Visible", (long) Qt::WidgetAttribute::WA_WState_Visible))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_Hidden", (long) Qt::WidgetAttribute::WA_WState_Hidden))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_ForceDisabled", (long) Qt::WidgetAttribute::WA_ForceDisabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_KeyCompression", (long) Qt::WidgetAttribute::WA_KeyCompression))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_PendingMoveEvent", (long) Qt::WidgetAttribute::WA_PendingMoveEvent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_PendingResizeEvent", (long) Qt::WidgetAttribute::WA_PendingResizeEvent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_SetPalette", (long) Qt::WidgetAttribute::WA_SetPalette))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_SetFont", (long) Qt::WidgetAttribute::WA_SetFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_SetCursor", (long) Qt::WidgetAttribute::WA_SetCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_NoChildEventsFromChildren", (long) Qt::WidgetAttribute::WA_NoChildEventsFromChildren))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WindowModified", (long) Qt::WidgetAttribute::WA_WindowModified))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_Resized", (long) Qt::WidgetAttribute::WA_Resized))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_Moved", (long) Qt::WidgetAttribute::WA_Moved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_PendingUpdate", (long) Qt::WidgetAttribute::WA_PendingUpdate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_InvalidSize", (long) Qt::WidgetAttribute::WA_InvalidSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacBrushedMetal", (long) Qt::WidgetAttribute::WA_MacBrushedMetal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacMetalStyle", (long) Qt::WidgetAttribute::WA_MacMetalStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_CustomWhatsThis", (long) Qt::WidgetAttribute::WA_CustomWhatsThis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_LayoutOnEntireRect", (long) Qt::WidgetAttribute::WA_LayoutOnEntireRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_OutsideWSRange", (long) Qt::WidgetAttribute::WA_OutsideWSRange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_GrabbedShortcut", (long) Qt::WidgetAttribute::WA_GrabbedShortcut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_TransparentForMouseEvents", (long) Qt::WidgetAttribute::WA_TransparentForMouseEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_PaintUnclipped", (long) Qt::WidgetAttribute::WA_PaintUnclipped))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_SetWindowIcon", (long) Qt::WidgetAttribute::WA_SetWindowIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_NoMouseReplay", (long) Qt::WidgetAttribute::WA_NoMouseReplay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_DeleteOnClose", (long) Qt::WidgetAttribute::WA_DeleteOnClose))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_RightToLeft", (long) Qt::WidgetAttribute::WA_RightToLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_SetLayoutDirection", (long) Qt::WidgetAttribute::WA_SetLayoutDirection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_NoChildEventsForParent", (long) Qt::WidgetAttribute::WA_NoChildEventsForParent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_ForceUpdatesDisabled", (long) Qt::WidgetAttribute::WA_ForceUpdatesDisabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_Created", (long) Qt::WidgetAttribute::WA_WState_Created))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_CompressKeys", (long) Qt::WidgetAttribute::WA_WState_CompressKeys))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_InPaintEvent", (long) Qt::WidgetAttribute::WA_WState_InPaintEvent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_Reparented", (long) Qt::WidgetAttribute::WA_WState_Reparented))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_ConfigPending", (long) Qt::WidgetAttribute::WA_WState_ConfigPending))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_Polished", (long) Qt::WidgetAttribute::WA_WState_Polished))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_DND", (long) Qt::WidgetAttribute::WA_WState_DND))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_OwnSizePolicy", (long) Qt::WidgetAttribute::WA_WState_OwnSizePolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_ExplicitShowHide", (long) Qt::WidgetAttribute::WA_WState_ExplicitShowHide))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_ShowModal", (long) Qt::WidgetAttribute::WA_ShowModal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MouseNoMask", (long) Qt::WidgetAttribute::WA_MouseNoMask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_GroupLeader", (long) Qt::WidgetAttribute::WA_GroupLeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_NoMousePropagation", (long) Qt::WidgetAttribute::WA_NoMousePropagation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_Hover", (long) Qt::WidgetAttribute::WA_Hover))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_InputMethodTransparent", (long) Qt::WidgetAttribute::WA_InputMethodTransparent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_QuitOnClose", (long) Qt::WidgetAttribute::WA_QuitOnClose))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_KeyboardFocusChange", (long) Qt::WidgetAttribute::WA_KeyboardFocusChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_AcceptDrops", (long) Qt::WidgetAttribute::WA_AcceptDrops))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_DropSiteRegistered", (long) Qt::WidgetAttribute::WA_DropSiteRegistered))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_ForceAcceptDrops", (long) Qt::WidgetAttribute::WA_ForceAcceptDrops))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WindowPropagation", (long) Qt::WidgetAttribute::WA_WindowPropagation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_NoX11EventCompression", (long) Qt::WidgetAttribute::WA_NoX11EventCompression))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_TintedBackground", (long) Qt::WidgetAttribute::WA_TintedBackground))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11OpenGLOverlay", (long) Qt::WidgetAttribute::WA_X11OpenGLOverlay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_AlwaysShowToolTips", (long) Qt::WidgetAttribute::WA_AlwaysShowToolTips))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacOpaqueSizeGrip", (long) Qt::WidgetAttribute::WA_MacOpaqueSizeGrip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_SetStyle", (long) Qt::WidgetAttribute::WA_SetStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_SetLocale", (long) Qt::WidgetAttribute::WA_SetLocale))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacShowFocusRect", (long) Qt::WidgetAttribute::WA_MacShowFocusRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacNormalSize", (long) Qt::WidgetAttribute::WA_MacNormalSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacSmallSize", (long) Qt::WidgetAttribute::WA_MacSmallSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacMiniSize", (long) Qt::WidgetAttribute::WA_MacMiniSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_LayoutUsesWidgetRect", (long) Qt::WidgetAttribute::WA_LayoutUsesWidgetRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_StyledBackground", (long) Qt::WidgetAttribute::WA_StyledBackground))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MSWindowsUseDirect3D", (long) Qt::WidgetAttribute::WA_MSWindowsUseDirect3D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_CanHostQMdiSubWindowTitleBar", (long) Qt::WidgetAttribute::WA_CanHostQMdiSubWindowTitleBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacAlwaysShowToolWindow", (long) Qt::WidgetAttribute::WA_MacAlwaysShowToolWindow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_StyleSheet", (long) Qt::WidgetAttribute::WA_StyleSheet))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_ShowWithoutActivating", (long) Qt::WidgetAttribute::WA_ShowWithoutActivating))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11BypassTransientForHint", (long) Qt::WidgetAttribute::WA_X11BypassTransientForHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_NativeWindow", (long) Qt::WidgetAttribute::WA_NativeWindow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_DontCreateNativeAncestors", (long) Qt::WidgetAttribute::WA_DontCreateNativeAncestors))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacVariableSize", (long) Qt::WidgetAttribute::WA_MacVariableSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_DontShowOnScreen", (long) Qt::WidgetAttribute::WA_DontShowOnScreen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeDesktop", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeDesktop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeDock", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeDock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeToolBar", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeToolBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeMenu", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeUtility", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeUtility))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeSplash", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeSplash))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeDialog", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeDialog))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeDropDownMenu", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeDropDownMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypePopupMenu", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypePopupMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeToolTip", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeToolTip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeNotification", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeNotification))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeCombo", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeCombo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11NetWmWindowTypeDND", (long) Qt::WidgetAttribute::WA_X11NetWmWindowTypeDND))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacFrameworkScaled", (long) Qt::WidgetAttribute::WA_MacFrameworkScaled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_SetWindowModality", (long) Qt::WidgetAttribute::WA_SetWindowModality))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_WindowOpacitySet", (long) Qt::WidgetAttribute::WA_WState_WindowOpacitySet))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_TranslucentBackground", (long) Qt::WidgetAttribute::WA_TranslucentBackground))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_AcceptTouchEvents", (long) Qt::WidgetAttribute::WA_AcceptTouchEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_WState_AcceptedTouchBeginEvent", (long) Qt::WidgetAttribute::WA_WState_AcceptedTouchBeginEvent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_TouchPadAcceptSingleTouchEvents", (long) Qt::WidgetAttribute::WA_TouchPadAcceptSingleTouchEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_X11DoNotAcceptFocus", (long) Qt::WidgetAttribute::WA_X11DoNotAcceptFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_MacNoShadow", (long) Qt::WidgetAttribute::WA_MacNoShadow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_AlwaysStackOnTop", (long) Qt::WidgetAttribute::WA_AlwaysStackOnTop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_TabletTracking", (long) Qt::WidgetAttribute::WA_TabletTracking))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_ContentsMarginsRespectsSafeArea", (long) Qt::WidgetAttribute::WA_ContentsMarginsRespectsSafeArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_StyleSheetTarget", (long) Qt::WidgetAttribute::WA_StyleSheetTarget))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "WA_AttributeCount", (long) Qt::WidgetAttribute::WA_AttributeCount))
        return;
    // Register converter for enum 'Qt::WidgetAttribute'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX],
            Qt_WidgetAttribute_CppToPython_Qt_WidgetAttribute);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_WidgetAttribute_PythonToCpp_Qt_WidgetAttribute,
            is_Qt_WidgetAttribute_PythonToCpp_Qt_WidgetAttribute_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::WidgetAttribute");
        Shiboken::Conversions::registerConverterName(converter, "WidgetAttribute");
    }
    // End of 'WidgetAttribute' enum.

    // Initialization of enum 'ApplicationAttribute'.
    SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ApplicationAttribute",
        "2:PySide2.QtCore.Qt.ApplicationAttribute",
        "Qt::ApplicationAttribute");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_ImmediateWidgetCreation", (long) Qt::ApplicationAttribute::AA_ImmediateWidgetCreation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_MSWindowsUseDirect3DByDefault", (long) Qt::ApplicationAttribute::AA_MSWindowsUseDirect3DByDefault))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_DontShowIconsInMenus", (long) Qt::ApplicationAttribute::AA_DontShowIconsInMenus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_NativeWindows", (long) Qt::ApplicationAttribute::AA_NativeWindows))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_DontCreateNativeWidgetSiblings", (long) Qt::ApplicationAttribute::AA_DontCreateNativeWidgetSiblings))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_PluginApplication", (long) Qt::ApplicationAttribute::AA_PluginApplication))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_MacPluginApplication", (long) Qt::ApplicationAttribute::AA_MacPluginApplication))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_DontUseNativeMenuBar", (long) Qt::ApplicationAttribute::AA_DontUseNativeMenuBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_MacDontSwapCtrlAndMeta", (long) Qt::ApplicationAttribute::AA_MacDontSwapCtrlAndMeta))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_Use96Dpi", (long) Qt::ApplicationAttribute::AA_Use96Dpi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_DisableNativeVirtualKeyboard", (long) Qt::ApplicationAttribute::AA_DisableNativeVirtualKeyboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_X11InitThreads", (long) Qt::ApplicationAttribute::AA_X11InitThreads))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_SynthesizeTouchForUnhandledMouseEvents", (long) Qt::ApplicationAttribute::AA_SynthesizeTouchForUnhandledMouseEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_SynthesizeMouseForUnhandledTouchEvents", (long) Qt::ApplicationAttribute::AA_SynthesizeMouseForUnhandledTouchEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_UseHighDpiPixmaps", (long) Qt::ApplicationAttribute::AA_UseHighDpiPixmaps))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_ForceRasterWidgets", (long) Qt::ApplicationAttribute::AA_ForceRasterWidgets))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_UseDesktopOpenGL", (long) Qt::ApplicationAttribute::AA_UseDesktopOpenGL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_UseOpenGLES", (long) Qt::ApplicationAttribute::AA_UseOpenGLES))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_UseSoftwareOpenGL", (long) Qt::ApplicationAttribute::AA_UseSoftwareOpenGL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_ShareOpenGLContexts", (long) Qt::ApplicationAttribute::AA_ShareOpenGLContexts))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_SetPalette", (long) Qt::ApplicationAttribute::AA_SetPalette))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_EnableHighDpiScaling", (long) Qt::ApplicationAttribute::AA_EnableHighDpiScaling))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_DisableHighDpiScaling", (long) Qt::ApplicationAttribute::AA_DisableHighDpiScaling))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_UseStyleSheetPropagationInWidgetStyles", (long) Qt::ApplicationAttribute::AA_UseStyleSheetPropagationInWidgetStyles))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_DontUseNativeDialogs", (long) Qt::ApplicationAttribute::AA_DontUseNativeDialogs))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_SynthesizeMouseForUnhandledTabletEvents", (long) Qt::ApplicationAttribute::AA_SynthesizeMouseForUnhandledTabletEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_CompressHighFrequencyEvents", (long) Qt::ApplicationAttribute::AA_CompressHighFrequencyEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_DontCheckOpenGLContextThreadAffinity", (long) Qt::ApplicationAttribute::AA_DontCheckOpenGLContextThreadAffinity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_DisableShaderDiskCache", (long) Qt::ApplicationAttribute::AA_DisableShaderDiskCache))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_DontShowShortcutsInContextMenus", (long) Qt::ApplicationAttribute::AA_DontShowShortcutsInContextMenus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_CompressTabletEvents", (long) Qt::ApplicationAttribute::AA_CompressTabletEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_DisableWindowContextHelpButton", (long) Qt::ApplicationAttribute::AA_DisableWindowContextHelpButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_DisableSessionManager", (long) Qt::ApplicationAttribute::AA_DisableSessionManager))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
        Sbk_Qt_TypeF(), "AA_AttributeCount", (long) Qt::ApplicationAttribute::AA_AttributeCount))
        return;
    // Register converter for enum 'Qt::ApplicationAttribute'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX],
            Qt_ApplicationAttribute_CppToPython_Qt_ApplicationAttribute);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ApplicationAttribute_PythonToCpp_Qt_ApplicationAttribute,
            is_Qt_ApplicationAttribute_PythonToCpp_Qt_ApplicationAttribute_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ApplicationAttribute");
        Shiboken::Conversions::registerConverterName(converter, "ApplicationAttribute");
    }
    // End of 'ApplicationAttribute' enum.

    // Initialization of enum 'ImageConversionFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.ImageConversionFlags", SbkPySide2_QtCore_Qt_ImageConversionFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ImageConversionFlag",
        "2:PySide2.QtCore.Qt.ImageConversionFlag",
        "Qt::ImageConversionFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "ColorMode_Mask", (long) Qt::ImageConversionFlag::ColorMode_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "AutoColor", (long) Qt::ImageConversionFlag::AutoColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "ColorOnly", (long) Qt::ImageConversionFlag::ColorOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "MonoOnly", (long) Qt::ImageConversionFlag::MonoOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "AlphaDither_Mask", (long) Qt::ImageConversionFlag::AlphaDither_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "ThresholdAlphaDither", (long) Qt::ImageConversionFlag::ThresholdAlphaDither))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "OrderedAlphaDither", (long) Qt::ImageConversionFlag::OrderedAlphaDither))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "DiffuseAlphaDither", (long) Qt::ImageConversionFlag::DiffuseAlphaDither))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "NoAlpha", (long) Qt::ImageConversionFlag::NoAlpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "Dither_Mask", (long) Qt::ImageConversionFlag::Dither_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "DiffuseDither", (long) Qt::ImageConversionFlag::DiffuseDither))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "OrderedDither", (long) Qt::ImageConversionFlag::OrderedDither))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "ThresholdDither", (long) Qt::ImageConversionFlag::ThresholdDither))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "DitherMode_Mask", (long) Qt::ImageConversionFlag::DitherMode_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "AutoDither", (long) Qt::ImageConversionFlag::AutoDither))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "PreferDither", (long) Qt::ImageConversionFlag::PreferDither))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "AvoidDither", (long) Qt::ImageConversionFlag::AvoidDither))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "NoOpaqueDetection", (long) Qt::ImageConversionFlag::NoOpaqueDetection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
        Sbk_Qt_TypeF(), "NoFormatConversion", (long) Qt::ImageConversionFlag::NoFormatConversion))
        return;
    // Register converter for enum 'Qt::ImageConversionFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX],
            Qt_ImageConversionFlag_CppToPython_Qt_ImageConversionFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ImageConversionFlag_PythonToCpp_Qt_ImageConversionFlag,
            is_Qt_ImageConversionFlag_PythonToCpp_Qt_ImageConversionFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ImageConversionFlag");
        Shiboken::Conversions::registerConverterName(converter, "ImageConversionFlag");
    }
    // Register converter for flag 'QFlags<Qt::ImageConversionFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX],
            QFlags_Qt_ImageConversionFlag__CppToPython_QFlags_Qt_ImageConversionFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ImageConversionFlag_PythonToCpp_QFlags_Qt_ImageConversionFlag_,
            is_Qt_ImageConversionFlag_PythonToCpp_QFlags_Qt_ImageConversionFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_ImageConversionFlag__PythonToCpp_QFlags_Qt_ImageConversionFlag_,
            is_QFlags_Qt_ImageConversionFlag__PythonToCpp_QFlags_Qt_ImageConversionFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_ImageConversionFlag_,
            is_number_PythonToCpp_QFlags_Qt_ImageConversionFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ImageConversionFlags");
        Shiboken::Conversions::registerConverterName(converter, "ImageConversionFlags");
    }
    // End of 'ImageConversionFlag' enum/flags.

    // Initialization of enum 'BGMode'.
    SbkPySide2_QtCoreTypes[SBK_QT_BGMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "BGMode",
        "2:PySide2.QtCore.Qt.BGMode",
        "Qt::BGMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_BGMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BGMODE_IDX],
        Sbk_Qt_TypeF(), "TransparentMode", (long) Qt::BGMode::TransparentMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BGMODE_IDX],
        Sbk_Qt_TypeF(), "OpaqueMode", (long) Qt::BGMode::OpaqueMode))
        return;
    // Register converter for enum 'Qt::BGMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_BGMODE_IDX],
            Qt_BGMode_CppToPython_Qt_BGMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_BGMode_PythonToCpp_Qt_BGMode,
            is_Qt_BGMode_PythonToCpp_Qt_BGMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_BGMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::BGMode");
        Shiboken::Conversions::registerConverterName(converter, "BGMode");
    }
    // End of 'BGMode' enum.

    // Initialization of enum 'Key'.
    SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "Key",
        "2:PySide2.QtCore.Qt.Key",
        "Qt::Key");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Escape", (long) Qt::Key::Key_Escape))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Tab", (long) Qt::Key::Key_Tab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Backtab", (long) Qt::Key::Key_Backtab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Backspace", (long) Qt::Key::Key_Backspace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Return", (long) Qt::Key::Key_Return))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Enter", (long) Qt::Key::Key_Enter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Insert", (long) Qt::Key::Key_Insert))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Delete", (long) Qt::Key::Key_Delete))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Pause", (long) Qt::Key::Key_Pause))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Print", (long) Qt::Key::Key_Print))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_SysReq", (long) Qt::Key::Key_SysReq))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Clear", (long) Qt::Key::Key_Clear))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Home", (long) Qt::Key::Key_Home))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_End", (long) Qt::Key::Key_End))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Left", (long) Qt::Key::Key_Left))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Up", (long) Qt::Key::Key_Up))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Right", (long) Qt::Key::Key_Right))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Down", (long) Qt::Key::Key_Down))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_PageUp", (long) Qt::Key::Key_PageUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_PageDown", (long) Qt::Key::Key_PageDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Shift", (long) Qt::Key::Key_Shift))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Control", (long) Qt::Key::Key_Control))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Meta", (long) Qt::Key::Key_Meta))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Alt", (long) Qt::Key::Key_Alt))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_CapsLock", (long) Qt::Key::Key_CapsLock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_NumLock", (long) Qt::Key::Key_NumLock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ScrollLock", (long) Qt::Key::Key_ScrollLock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F1", (long) Qt::Key::Key_F1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F2", (long) Qt::Key::Key_F2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F3", (long) Qt::Key::Key_F3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F4", (long) Qt::Key::Key_F4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F5", (long) Qt::Key::Key_F5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F6", (long) Qt::Key::Key_F6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F7", (long) Qt::Key::Key_F7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F8", (long) Qt::Key::Key_F8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F9", (long) Qt::Key::Key_F9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F10", (long) Qt::Key::Key_F10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F11", (long) Qt::Key::Key_F11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F12", (long) Qt::Key::Key_F12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F13", (long) Qt::Key::Key_F13))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F14", (long) Qt::Key::Key_F14))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F15", (long) Qt::Key::Key_F15))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F16", (long) Qt::Key::Key_F16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F17", (long) Qt::Key::Key_F17))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F18", (long) Qt::Key::Key_F18))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F19", (long) Qt::Key::Key_F19))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F20", (long) Qt::Key::Key_F20))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F21", (long) Qt::Key::Key_F21))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F22", (long) Qt::Key::Key_F22))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F23", (long) Qt::Key::Key_F23))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F24", (long) Qt::Key::Key_F24))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F25", (long) Qt::Key::Key_F25))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F26", (long) Qt::Key::Key_F26))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F27", (long) Qt::Key::Key_F27))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F28", (long) Qt::Key::Key_F28))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F29", (long) Qt::Key::Key_F29))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F30", (long) Qt::Key::Key_F30))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F31", (long) Qt::Key::Key_F31))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F32", (long) Qt::Key::Key_F32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F33", (long) Qt::Key::Key_F33))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F34", (long) Qt::Key::Key_F34))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F35", (long) Qt::Key::Key_F35))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Super_L", (long) Qt::Key::Key_Super_L))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Super_R", (long) Qt::Key::Key_Super_R))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Menu", (long) Qt::Key::Key_Menu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hyper_L", (long) Qt::Key::Key_Hyper_L))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hyper_R", (long) Qt::Key::Key_Hyper_R))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Help", (long) Qt::Key::Key_Help))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Direction_L", (long) Qt::Key::Key_Direction_L))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Direction_R", (long) Qt::Key::Key_Direction_R))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Space", (long) Qt::Key::Key_Space))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Any", (long) Qt::Key::Key_Any))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Exclam", (long) Qt::Key::Key_Exclam))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_QuoteDbl", (long) Qt::Key::Key_QuoteDbl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_NumberSign", (long) Qt::Key::Key_NumberSign))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dollar", (long) Qt::Key::Key_Dollar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Percent", (long) Qt::Key::Key_Percent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Ampersand", (long) Qt::Key::Key_Ampersand))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Apostrophe", (long) Qt::Key::Key_Apostrophe))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ParenLeft", (long) Qt::Key::Key_ParenLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ParenRight", (long) Qt::Key::Key_ParenRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Asterisk", (long) Qt::Key::Key_Asterisk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Plus", (long) Qt::Key::Key_Plus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Comma", (long) Qt::Key::Key_Comma))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Minus", (long) Qt::Key::Key_Minus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Period", (long) Qt::Key::Key_Period))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Slash", (long) Qt::Key::Key_Slash))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_0", (long) Qt::Key::Key_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_1", (long) Qt::Key::Key_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_2", (long) Qt::Key::Key_2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_3", (long) Qt::Key::Key_3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_4", (long) Qt::Key::Key_4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_5", (long) Qt::Key::Key_5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_6", (long) Qt::Key::Key_6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_7", (long) Qt::Key::Key_7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_8", (long) Qt::Key::Key_8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_9", (long) Qt::Key::Key_9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Colon", (long) Qt::Key::Key_Colon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Semicolon", (long) Qt::Key::Key_Semicolon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Less", (long) Qt::Key::Key_Less))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Equal", (long) Qt::Key::Key_Equal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Greater", (long) Qt::Key::Key_Greater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Question", (long) Qt::Key::Key_Question))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_At", (long) Qt::Key::Key_At))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_A", (long) Qt::Key::Key_A))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_B", (long) Qt::Key::Key_B))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_C", (long) Qt::Key::Key_C))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_D", (long) Qt::Key::Key_D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_E", (long) Qt::Key::Key_E))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_F", (long) Qt::Key::Key_F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_G", (long) Qt::Key::Key_G))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_H", (long) Qt::Key::Key_H))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_I", (long) Qt::Key::Key_I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_J", (long) Qt::Key::Key_J))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_K", (long) Qt::Key::Key_K))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_L", (long) Qt::Key::Key_L))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_M", (long) Qt::Key::Key_M))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_N", (long) Qt::Key::Key_N))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_O", (long) Qt::Key::Key_O))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_P", (long) Qt::Key::Key_P))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Q", (long) Qt::Key::Key_Q))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_R", (long) Qt::Key::Key_R))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_S", (long) Qt::Key::Key_S))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_T", (long) Qt::Key::Key_T))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_U", (long) Qt::Key::Key_U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_V", (long) Qt::Key::Key_V))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_W", (long) Qt::Key::Key_W))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_X", (long) Qt::Key::Key_X))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Y", (long) Qt::Key::Key_Y))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Z", (long) Qt::Key::Key_Z))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_BracketLeft", (long) Qt::Key::Key_BracketLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Backslash", (long) Qt::Key::Key_Backslash))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_BracketRight", (long) Qt::Key::Key_BracketRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_AsciiCircum", (long) Qt::Key::Key_AsciiCircum))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Underscore", (long) Qt::Key::Key_Underscore))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_QuoteLeft", (long) Qt::Key::Key_QuoteLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_BraceLeft", (long) Qt::Key::Key_BraceLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Bar", (long) Qt::Key::Key_Bar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_BraceRight", (long) Qt::Key::Key_BraceRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_AsciiTilde", (long) Qt::Key::Key_AsciiTilde))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_nobreakspace", (long) Qt::Key::Key_nobreakspace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_exclamdown", (long) Qt::Key::Key_exclamdown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_cent", (long) Qt::Key::Key_cent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_sterling", (long) Qt::Key::Key_sterling))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_currency", (long) Qt::Key::Key_currency))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_yen", (long) Qt::Key::Key_yen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_brokenbar", (long) Qt::Key::Key_brokenbar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_section", (long) Qt::Key::Key_section))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_diaeresis", (long) Qt::Key::Key_diaeresis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_copyright", (long) Qt::Key::Key_copyright))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ordfeminine", (long) Qt::Key::Key_ordfeminine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_guillemotleft", (long) Qt::Key::Key_guillemotleft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_notsign", (long) Qt::Key::Key_notsign))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_hyphen", (long) Qt::Key::Key_hyphen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_registered", (long) Qt::Key::Key_registered))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_macron", (long) Qt::Key::Key_macron))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_degree", (long) Qt::Key::Key_degree))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_plusminus", (long) Qt::Key::Key_plusminus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_twosuperior", (long) Qt::Key::Key_twosuperior))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_threesuperior", (long) Qt::Key::Key_threesuperior))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_acute", (long) Qt::Key::Key_acute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_mu", (long) Qt::Key::Key_mu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_paragraph", (long) Qt::Key::Key_paragraph))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_periodcentered", (long) Qt::Key::Key_periodcentered))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_cedilla", (long) Qt::Key::Key_cedilla))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_onesuperior", (long) Qt::Key::Key_onesuperior))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_masculine", (long) Qt::Key::Key_masculine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_guillemotright", (long) Qt::Key::Key_guillemotright))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_onequarter", (long) Qt::Key::Key_onequarter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_onehalf", (long) Qt::Key::Key_onehalf))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_threequarters", (long) Qt::Key::Key_threequarters))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_questiondown", (long) Qt::Key::Key_questiondown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Agrave", (long) Qt::Key::Key_Agrave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Aacute", (long) Qt::Key::Key_Aacute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Acircumflex", (long) Qt::Key::Key_Acircumflex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Atilde", (long) Qt::Key::Key_Atilde))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Adiaeresis", (long) Qt::Key::Key_Adiaeresis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Aring", (long) Qt::Key::Key_Aring))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_AE", (long) Qt::Key::Key_AE))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Ccedilla", (long) Qt::Key::Key_Ccedilla))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Egrave", (long) Qt::Key::Key_Egrave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Eacute", (long) Qt::Key::Key_Eacute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Ecircumflex", (long) Qt::Key::Key_Ecircumflex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Ediaeresis", (long) Qt::Key::Key_Ediaeresis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Igrave", (long) Qt::Key::Key_Igrave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Iacute", (long) Qt::Key::Key_Iacute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Icircumflex", (long) Qt::Key::Key_Icircumflex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Idiaeresis", (long) Qt::Key::Key_Idiaeresis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ETH", (long) Qt::Key::Key_ETH))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Ntilde", (long) Qt::Key::Key_Ntilde))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Ograve", (long) Qt::Key::Key_Ograve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Oacute", (long) Qt::Key::Key_Oacute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Ocircumflex", (long) Qt::Key::Key_Ocircumflex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Otilde", (long) Qt::Key::Key_Otilde))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Odiaeresis", (long) Qt::Key::Key_Odiaeresis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_multiply", (long) Qt::Key::Key_multiply))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Ooblique", (long) Qt::Key::Key_Ooblique))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Ugrave", (long) Qt::Key::Key_Ugrave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Uacute", (long) Qt::Key::Key_Uacute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Ucircumflex", (long) Qt::Key::Key_Ucircumflex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Udiaeresis", (long) Qt::Key::Key_Udiaeresis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Yacute", (long) Qt::Key::Key_Yacute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_THORN", (long) Qt::Key::Key_THORN))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ssharp", (long) Qt::Key::Key_ssharp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_division", (long) Qt::Key::Key_division))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ydiaeresis", (long) Qt::Key::Key_ydiaeresis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_AltGr", (long) Qt::Key::Key_AltGr))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Multi_key", (long) Qt::Key::Key_Multi_key))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Codeinput", (long) Qt::Key::Key_Codeinput))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_SingleCandidate", (long) Qt::Key::Key_SingleCandidate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MultipleCandidate", (long) Qt::Key::Key_MultipleCandidate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_PreviousCandidate", (long) Qt::Key::Key_PreviousCandidate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Mode_switch", (long) Qt::Key::Key_Mode_switch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Kanji", (long) Qt::Key::Key_Kanji))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Muhenkan", (long) Qt::Key::Key_Muhenkan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Henkan", (long) Qt::Key::Key_Henkan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Romaji", (long) Qt::Key::Key_Romaji))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hiragana", (long) Qt::Key::Key_Hiragana))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Katakana", (long) Qt::Key::Key_Katakana))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hiragana_Katakana", (long) Qt::Key::Key_Hiragana_Katakana))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Zenkaku", (long) Qt::Key::Key_Zenkaku))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hankaku", (long) Qt::Key::Key_Hankaku))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Zenkaku_Hankaku", (long) Qt::Key::Key_Zenkaku_Hankaku))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Touroku", (long) Qt::Key::Key_Touroku))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Massyo", (long) Qt::Key::Key_Massyo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Kana_Lock", (long) Qt::Key::Key_Kana_Lock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Kana_Shift", (long) Qt::Key::Key_Kana_Shift))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Eisu_Shift", (long) Qt::Key::Key_Eisu_Shift))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Eisu_toggle", (long) Qt::Key::Key_Eisu_toggle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangul", (long) Qt::Key::Key_Hangul))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangul_Start", (long) Qt::Key::Key_Hangul_Start))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangul_End", (long) Qt::Key::Key_Hangul_End))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangul_Hanja", (long) Qt::Key::Key_Hangul_Hanja))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangul_Jamo", (long) Qt::Key::Key_Hangul_Jamo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangul_Romaja", (long) Qt::Key::Key_Hangul_Romaja))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangul_Jeonja", (long) Qt::Key::Key_Hangul_Jeonja))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangul_Banja", (long) Qt::Key::Key_Hangul_Banja))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangul_PreHanja", (long) Qt::Key::Key_Hangul_PreHanja))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangul_PostHanja", (long) Qt::Key::Key_Hangul_PostHanja))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangul_Special", (long) Qt::Key::Key_Hangul_Special))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Grave", (long) Qt::Key::Key_Dead_Grave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Acute", (long) Qt::Key::Key_Dead_Acute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Circumflex", (long) Qt::Key::Key_Dead_Circumflex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Tilde", (long) Qt::Key::Key_Dead_Tilde))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Macron", (long) Qt::Key::Key_Dead_Macron))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Breve", (long) Qt::Key::Key_Dead_Breve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Abovedot", (long) Qt::Key::Key_Dead_Abovedot))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Diaeresis", (long) Qt::Key::Key_Dead_Diaeresis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Abovering", (long) Qt::Key::Key_Dead_Abovering))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Doubleacute", (long) Qt::Key::Key_Dead_Doubleacute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Caron", (long) Qt::Key::Key_Dead_Caron))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Cedilla", (long) Qt::Key::Key_Dead_Cedilla))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Ogonek", (long) Qt::Key::Key_Dead_Ogonek))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Iota", (long) Qt::Key::Key_Dead_Iota))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Voiced_Sound", (long) Qt::Key::Key_Dead_Voiced_Sound))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Semivoiced_Sound", (long) Qt::Key::Key_Dead_Semivoiced_Sound))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Belowdot", (long) Qt::Key::Key_Dead_Belowdot))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Hook", (long) Qt::Key::Key_Dead_Hook))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Horn", (long) Qt::Key::Key_Dead_Horn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Stroke", (long) Qt::Key::Key_Dead_Stroke))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Abovecomma", (long) Qt::Key::Key_Dead_Abovecomma))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Abovereversedcomma", (long) Qt::Key::Key_Dead_Abovereversedcomma))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Doublegrave", (long) Qt::Key::Key_Dead_Doublegrave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Belowring", (long) Qt::Key::Key_Dead_Belowring))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Belowmacron", (long) Qt::Key::Key_Dead_Belowmacron))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Belowcircumflex", (long) Qt::Key::Key_Dead_Belowcircumflex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Belowtilde", (long) Qt::Key::Key_Dead_Belowtilde))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Belowbreve", (long) Qt::Key::Key_Dead_Belowbreve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Belowdiaeresis", (long) Qt::Key::Key_Dead_Belowdiaeresis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Invertedbreve", (long) Qt::Key::Key_Dead_Invertedbreve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Belowcomma", (long) Qt::Key::Key_Dead_Belowcomma))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Currency", (long) Qt::Key::Key_Dead_Currency))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_a", (long) Qt::Key::Key_Dead_a))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_A", (long) Qt::Key::Key_Dead_A))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_e", (long) Qt::Key::Key_Dead_e))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_E", (long) Qt::Key::Key_Dead_E))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_i", (long) Qt::Key::Key_Dead_i))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_I", (long) Qt::Key::Key_Dead_I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_o", (long) Qt::Key::Key_Dead_o))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_O", (long) Qt::Key::Key_Dead_O))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_u", (long) Qt::Key::Key_Dead_u))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_U", (long) Qt::Key::Key_Dead_U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Small_Schwa", (long) Qt::Key::Key_Dead_Small_Schwa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Capital_Schwa", (long) Qt::Key::Key_Dead_Capital_Schwa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Greek", (long) Qt::Key::Key_Dead_Greek))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Lowline", (long) Qt::Key::Key_Dead_Lowline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Aboveverticalline", (long) Qt::Key::Key_Dead_Aboveverticalline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Belowverticalline", (long) Qt::Key::Key_Dead_Belowverticalline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Dead_Longsolidusoverlay", (long) Qt::Key::Key_Dead_Longsolidusoverlay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Back", (long) Qt::Key::Key_Back))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Forward", (long) Qt::Key::Key_Forward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Stop", (long) Qt::Key::Key_Stop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Refresh", (long) Qt::Key::Key_Refresh))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_VolumeDown", (long) Qt::Key::Key_VolumeDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_VolumeMute", (long) Qt::Key::Key_VolumeMute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_VolumeUp", (long) Qt::Key::Key_VolumeUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_BassBoost", (long) Qt::Key::Key_BassBoost))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_BassUp", (long) Qt::Key::Key_BassUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_BassDown", (long) Qt::Key::Key_BassDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_TrebleUp", (long) Qt::Key::Key_TrebleUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_TrebleDown", (long) Qt::Key::Key_TrebleDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MediaPlay", (long) Qt::Key::Key_MediaPlay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MediaStop", (long) Qt::Key::Key_MediaStop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MediaPrevious", (long) Qt::Key::Key_MediaPrevious))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MediaNext", (long) Qt::Key::Key_MediaNext))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MediaRecord", (long) Qt::Key::Key_MediaRecord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MediaPause", (long) Qt::Key::Key_MediaPause))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MediaTogglePlayPause", (long) Qt::Key::Key_MediaTogglePlayPause))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_HomePage", (long) Qt::Key::Key_HomePage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Favorites", (long) Qt::Key::Key_Favorites))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Search", (long) Qt::Key::Key_Search))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Standby", (long) Qt::Key::Key_Standby))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_OpenUrl", (long) Qt::Key::Key_OpenUrl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LaunchMail", (long) Qt::Key::Key_LaunchMail))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LaunchMedia", (long) Qt::Key::Key_LaunchMedia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Launch0", (long) Qt::Key::Key_Launch0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Launch1", (long) Qt::Key::Key_Launch1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Launch2", (long) Qt::Key::Key_Launch2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Launch3", (long) Qt::Key::Key_Launch3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Launch4", (long) Qt::Key::Key_Launch4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Launch5", (long) Qt::Key::Key_Launch5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Launch6", (long) Qt::Key::Key_Launch6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Launch7", (long) Qt::Key::Key_Launch7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Launch8", (long) Qt::Key::Key_Launch8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Launch9", (long) Qt::Key::Key_Launch9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LaunchA", (long) Qt::Key::Key_LaunchA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LaunchB", (long) Qt::Key::Key_LaunchB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LaunchC", (long) Qt::Key::Key_LaunchC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LaunchD", (long) Qt::Key::Key_LaunchD))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LaunchE", (long) Qt::Key::Key_LaunchE))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LaunchF", (long) Qt::Key::Key_LaunchF))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MonBrightnessUp", (long) Qt::Key::Key_MonBrightnessUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MonBrightnessDown", (long) Qt::Key::Key_MonBrightnessDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_KeyboardLightOnOff", (long) Qt::Key::Key_KeyboardLightOnOff))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_KeyboardBrightnessUp", (long) Qt::Key::Key_KeyboardBrightnessUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_KeyboardBrightnessDown", (long) Qt::Key::Key_KeyboardBrightnessDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_PowerOff", (long) Qt::Key::Key_PowerOff))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_WakeUp", (long) Qt::Key::Key_WakeUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Eject", (long) Qt::Key::Key_Eject))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ScreenSaver", (long) Qt::Key::Key_ScreenSaver))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_WWW", (long) Qt::Key::Key_WWW))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Memo", (long) Qt::Key::Key_Memo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LightBulb", (long) Qt::Key::Key_LightBulb))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Shop", (long) Qt::Key::Key_Shop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_History", (long) Qt::Key::Key_History))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_AddFavorite", (long) Qt::Key::Key_AddFavorite))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_HotLinks", (long) Qt::Key::Key_HotLinks))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_BrightnessAdjust", (long) Qt::Key::Key_BrightnessAdjust))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Finance", (long) Qt::Key::Key_Finance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Community", (long) Qt::Key::Key_Community))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_AudioRewind", (long) Qt::Key::Key_AudioRewind))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_BackForward", (long) Qt::Key::Key_BackForward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ApplicationLeft", (long) Qt::Key::Key_ApplicationLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ApplicationRight", (long) Qt::Key::Key_ApplicationRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Book", (long) Qt::Key::Key_Book))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_CD", (long) Qt::Key::Key_CD))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Calculator", (long) Qt::Key::Key_Calculator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ToDoList", (long) Qt::Key::Key_ToDoList))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ClearGrab", (long) Qt::Key::Key_ClearGrab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Close", (long) Qt::Key::Key_Close))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Copy", (long) Qt::Key::Key_Copy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Cut", (long) Qt::Key::Key_Cut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Display", (long) Qt::Key::Key_Display))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_DOS", (long) Qt::Key::Key_DOS))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Documents", (long) Qt::Key::Key_Documents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Excel", (long) Qt::Key::Key_Excel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Explorer", (long) Qt::Key::Key_Explorer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Game", (long) Qt::Key::Key_Game))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Go", (long) Qt::Key::Key_Go))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_iTouch", (long) Qt::Key::Key_iTouch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LogOff", (long) Qt::Key::Key_LogOff))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Market", (long) Qt::Key::Key_Market))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Meeting", (long) Qt::Key::Key_Meeting))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MenuKB", (long) Qt::Key::Key_MenuKB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MenuPB", (long) Qt::Key::Key_MenuPB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MySites", (long) Qt::Key::Key_MySites))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_News", (long) Qt::Key::Key_News))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_OfficeHome", (long) Qt::Key::Key_OfficeHome))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Option", (long) Qt::Key::Key_Option))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Paste", (long) Qt::Key::Key_Paste))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Phone", (long) Qt::Key::Key_Phone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Calendar", (long) Qt::Key::Key_Calendar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Reply", (long) Qt::Key::Key_Reply))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Reload", (long) Qt::Key::Key_Reload))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_RotateWindows", (long) Qt::Key::Key_RotateWindows))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_RotationPB", (long) Qt::Key::Key_RotationPB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_RotationKB", (long) Qt::Key::Key_RotationKB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Save", (long) Qt::Key::Key_Save))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Send", (long) Qt::Key::Key_Send))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Spell", (long) Qt::Key::Key_Spell))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_SplitScreen", (long) Qt::Key::Key_SplitScreen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Support", (long) Qt::Key::Key_Support))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_TaskPane", (long) Qt::Key::Key_TaskPane))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Terminal", (long) Qt::Key::Key_Terminal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Tools", (long) Qt::Key::Key_Tools))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Travel", (long) Qt::Key::Key_Travel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Video", (long) Qt::Key::Key_Video))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Word", (long) Qt::Key::Key_Word))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Xfer", (long) Qt::Key::Key_Xfer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ZoomIn", (long) Qt::Key::Key_ZoomIn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ZoomOut", (long) Qt::Key::Key_ZoomOut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Away", (long) Qt::Key::Key_Away))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Messenger", (long) Qt::Key::Key_Messenger))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_WebCam", (long) Qt::Key::Key_WebCam))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MailForward", (long) Qt::Key::Key_MailForward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Pictures", (long) Qt::Key::Key_Pictures))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Music", (long) Qt::Key::Key_Music))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Battery", (long) Qt::Key::Key_Battery))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Bluetooth", (long) Qt::Key::Key_Bluetooth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_WLAN", (long) Qt::Key::Key_WLAN))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_UWB", (long) Qt::Key::Key_UWB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_AudioForward", (long) Qt::Key::Key_AudioForward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_AudioRepeat", (long) Qt::Key::Key_AudioRepeat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_AudioRandomPlay", (long) Qt::Key::Key_AudioRandomPlay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Subtitle", (long) Qt::Key::Key_Subtitle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_AudioCycleTrack", (long) Qt::Key::Key_AudioCycleTrack))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Time", (long) Qt::Key::Key_Time))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hibernate", (long) Qt::Key::Key_Hibernate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_View", (long) Qt::Key::Key_View))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_TopMenu", (long) Qt::Key::Key_TopMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_PowerDown", (long) Qt::Key::Key_PowerDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Suspend", (long) Qt::Key::Key_Suspend))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ContrastAdjust", (long) Qt::Key::Key_ContrastAdjust))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LaunchG", (long) Qt::Key::Key_LaunchG))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LaunchH", (long) Qt::Key::Key_LaunchH))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_TouchpadToggle", (long) Qt::Key::Key_TouchpadToggle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_TouchpadOn", (long) Qt::Key::Key_TouchpadOn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_TouchpadOff", (long) Qt::Key::Key_TouchpadOff))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MicMute", (long) Qt::Key::Key_MicMute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Red", (long) Qt::Key::Key_Red))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Green", (long) Qt::Key::Key_Green))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Yellow", (long) Qt::Key::Key_Yellow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Blue", (long) Qt::Key::Key_Blue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ChannelUp", (long) Qt::Key::Key_ChannelUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ChannelDown", (long) Qt::Key::Key_ChannelDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Guide", (long) Qt::Key::Key_Guide))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Info", (long) Qt::Key::Key_Info))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Settings", (long) Qt::Key::Key_Settings))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MicVolumeUp", (long) Qt::Key::Key_MicVolumeUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MicVolumeDown", (long) Qt::Key::Key_MicVolumeDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_New", (long) Qt::Key::Key_New))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Open", (long) Qt::Key::Key_Open))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Find", (long) Qt::Key::Key_Find))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Undo", (long) Qt::Key::Key_Undo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Redo", (long) Qt::Key::Key_Redo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_MediaLast", (long) Qt::Key::Key_MediaLast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Select", (long) Qt::Key::Key_Select))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Yes", (long) Qt::Key::Key_Yes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_No", (long) Qt::Key::Key_No))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Cancel", (long) Qt::Key::Key_Cancel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Printer", (long) Qt::Key::Key_Printer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Execute", (long) Qt::Key::Key_Execute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Sleep", (long) Qt::Key::Key_Sleep))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Play", (long) Qt::Key::Key_Play))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Zoom", (long) Qt::Key::Key_Zoom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Exit", (long) Qt::Key::Key_Exit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Context1", (long) Qt::Key::Key_Context1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Context2", (long) Qt::Key::Key_Context2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Context3", (long) Qt::Key::Key_Context3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Context4", (long) Qt::Key::Key_Context4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Call", (long) Qt::Key::Key_Call))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Hangup", (long) Qt::Key::Key_Hangup))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Flip", (long) Qt::Key::Key_Flip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_ToggleCallHangup", (long) Qt::Key::Key_ToggleCallHangup))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_VoiceDial", (long) Qt::Key::Key_VoiceDial))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_LastNumberRedial", (long) Qt::Key::Key_LastNumberRedial))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_Camera", (long) Qt::Key::Key_Camera))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_CameraFocus", (long) Qt::Key::Key_CameraFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
        Sbk_Qt_TypeF(), "Key_unknown", (long) Qt::Key::Key_unknown))
        return;
    // Register converter for enum 'Qt::Key'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX],
            Qt_Key_CppToPython_Qt_Key);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_Key_PythonToCpp_Qt_Key,
            is_Qt_Key_PythonToCpp_Qt_Key_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::Key");
        Shiboken::Conversions::registerConverterName(converter, "Key");
    }
    // End of 'Key' enum.

    // Initialization of enum 'ArrowType'.
    SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ArrowType",
        "2:PySide2.QtCore.Qt.ArrowType",
        "Qt::ArrowType");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX],
        Sbk_Qt_TypeF(), "NoArrow", (long) Qt::ArrowType::NoArrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX],
        Sbk_Qt_TypeF(), "UpArrow", (long) Qt::ArrowType::UpArrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX],
        Sbk_Qt_TypeF(), "DownArrow", (long) Qt::ArrowType::DownArrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX],
        Sbk_Qt_TypeF(), "LeftArrow", (long) Qt::ArrowType::LeftArrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX],
        Sbk_Qt_TypeF(), "RightArrow", (long) Qt::ArrowType::RightArrow))
        return;
    // Register converter for enum 'Qt::ArrowType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX],
            Qt_ArrowType_CppToPython_Qt_ArrowType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ArrowType_PythonToCpp_Qt_ArrowType,
            is_Qt_ArrowType_PythonToCpp_Qt_ArrowType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ArrowType");
        Shiboken::Conversions::registerConverterName(converter, "ArrowType");
    }
    // End of 'ArrowType' enum.

    // Initialization of enum 'PenStyle'.
    SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "PenStyle",
        "2:PySide2.QtCore.Qt.PenStyle",
        "Qt::PenStyle");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX],
        Sbk_Qt_TypeF(), "NoPen", (long) Qt::PenStyle::NoPen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX],
        Sbk_Qt_TypeF(), "SolidLine", (long) Qt::PenStyle::SolidLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX],
        Sbk_Qt_TypeF(), "DashLine", (long) Qt::PenStyle::DashLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX],
        Sbk_Qt_TypeF(), "DotLine", (long) Qt::PenStyle::DotLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX],
        Sbk_Qt_TypeF(), "DashDotLine", (long) Qt::PenStyle::DashDotLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX],
        Sbk_Qt_TypeF(), "DashDotDotLine", (long) Qt::PenStyle::DashDotDotLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX],
        Sbk_Qt_TypeF(), "CustomDashLine", (long) Qt::PenStyle::CustomDashLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX],
        Sbk_Qt_TypeF(), "MPenStyle", (long) Qt::PenStyle::MPenStyle))
        return;
    // Register converter for enum 'Qt::PenStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX],
            Qt_PenStyle_CppToPython_Qt_PenStyle);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_PenStyle_PythonToCpp_Qt_PenStyle,
            is_Qt_PenStyle_PythonToCpp_Qt_PenStyle_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::PenStyle");
        Shiboken::Conversions::registerConverterName(converter, "PenStyle");
    }
    // End of 'PenStyle' enum.

    // Initialization of enum 'PenCapStyle'.
    SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "PenCapStyle",
        "2:PySide2.QtCore.Qt.PenCapStyle",
        "Qt::PenCapStyle");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX],
        Sbk_Qt_TypeF(), "FlatCap", (long) Qt::PenCapStyle::FlatCap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX],
        Sbk_Qt_TypeF(), "SquareCap", (long) Qt::PenCapStyle::SquareCap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX],
        Sbk_Qt_TypeF(), "RoundCap", (long) Qt::PenCapStyle::RoundCap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX],
        Sbk_Qt_TypeF(), "MPenCapStyle", (long) Qt::PenCapStyle::MPenCapStyle))
        return;
    // Register converter for enum 'Qt::PenCapStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX],
            Qt_PenCapStyle_CppToPython_Qt_PenCapStyle);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_PenCapStyle_PythonToCpp_Qt_PenCapStyle,
            is_Qt_PenCapStyle_PythonToCpp_Qt_PenCapStyle_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::PenCapStyle");
        Shiboken::Conversions::registerConverterName(converter, "PenCapStyle");
    }
    // End of 'PenCapStyle' enum.

    // Initialization of enum 'PenJoinStyle'.
    SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "PenJoinStyle",
        "2:PySide2.QtCore.Qt.PenJoinStyle",
        "Qt::PenJoinStyle");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX],
        Sbk_Qt_TypeF(), "MiterJoin", (long) Qt::PenJoinStyle::MiterJoin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX],
        Sbk_Qt_TypeF(), "BevelJoin", (long) Qt::PenJoinStyle::BevelJoin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX],
        Sbk_Qt_TypeF(), "RoundJoin", (long) Qt::PenJoinStyle::RoundJoin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX],
        Sbk_Qt_TypeF(), "SvgMiterJoin", (long) Qt::PenJoinStyle::SvgMiterJoin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX],
        Sbk_Qt_TypeF(), "MPenJoinStyle", (long) Qt::PenJoinStyle::MPenJoinStyle))
        return;
    // Register converter for enum 'Qt::PenJoinStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX],
            Qt_PenJoinStyle_CppToPython_Qt_PenJoinStyle);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_PenJoinStyle_PythonToCpp_Qt_PenJoinStyle,
            is_Qt_PenJoinStyle_PythonToCpp_Qt_PenJoinStyle_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::PenJoinStyle");
        Shiboken::Conversions::registerConverterName(converter, "PenJoinStyle");
    }
    // End of 'PenJoinStyle' enum.

    // Initialization of enum 'BrushStyle'.
    SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "BrushStyle",
        "2:PySide2.QtCore.Qt.BrushStyle",
        "Qt::BrushStyle");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "NoBrush", (long) Qt::BrushStyle::NoBrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "SolidPattern", (long) Qt::BrushStyle::SolidPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "Dense1Pattern", (long) Qt::BrushStyle::Dense1Pattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "Dense2Pattern", (long) Qt::BrushStyle::Dense2Pattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "Dense3Pattern", (long) Qt::BrushStyle::Dense3Pattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "Dense4Pattern", (long) Qt::BrushStyle::Dense4Pattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "Dense5Pattern", (long) Qt::BrushStyle::Dense5Pattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "Dense6Pattern", (long) Qt::BrushStyle::Dense6Pattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "Dense7Pattern", (long) Qt::BrushStyle::Dense7Pattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "HorPattern", (long) Qt::BrushStyle::HorPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "VerPattern", (long) Qt::BrushStyle::VerPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "CrossPattern", (long) Qt::BrushStyle::CrossPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "BDiagPattern", (long) Qt::BrushStyle::BDiagPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "FDiagPattern", (long) Qt::BrushStyle::FDiagPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "DiagCrossPattern", (long) Qt::BrushStyle::DiagCrossPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "LinearGradientPattern", (long) Qt::BrushStyle::LinearGradientPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "RadialGradientPattern", (long) Qt::BrushStyle::RadialGradientPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "ConicalGradientPattern", (long) Qt::BrushStyle::ConicalGradientPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
        Sbk_Qt_TypeF(), "TexturePattern", (long) Qt::BrushStyle::TexturePattern))
        return;
    // Register converter for enum 'Qt::BrushStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX],
            Qt_BrushStyle_CppToPython_Qt_BrushStyle);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_BrushStyle_PythonToCpp_Qt_BrushStyle,
            is_Qt_BrushStyle_PythonToCpp_Qt_BrushStyle_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::BrushStyle");
        Shiboken::Conversions::registerConverterName(converter, "BrushStyle");
    }
    // End of 'BrushStyle' enum.

    // Initialization of enum 'SizeMode'.
    SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "SizeMode",
        "2:PySide2.QtCore.Qt.SizeMode",
        "Qt::SizeMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX],
        Sbk_Qt_TypeF(), "AbsoluteSize", (long) Qt::SizeMode::AbsoluteSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX],
        Sbk_Qt_TypeF(), "RelativeSize", (long) Qt::SizeMode::RelativeSize))
        return;
    // Register converter for enum 'Qt::SizeMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX],
            Qt_SizeMode_CppToPython_Qt_SizeMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_SizeMode_PythonToCpp_Qt_SizeMode,
            is_Qt_SizeMode_PythonToCpp_Qt_SizeMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_SIZEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::SizeMode");
        Shiboken::Conversions::registerConverterName(converter, "SizeMode");
    }
    // End of 'SizeMode' enum.

    // Initialization of enum 'UIEffect'.
    SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "UIEffect",
        "2:PySide2.QtCore.Qt.UIEffect",
        "Qt::UIEffect");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX],
        Sbk_Qt_TypeF(), "UI_General", (long) Qt::UIEffect::UI_General))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX],
        Sbk_Qt_TypeF(), "UI_AnimateMenu", (long) Qt::UIEffect::UI_AnimateMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX],
        Sbk_Qt_TypeF(), "UI_FadeMenu", (long) Qt::UIEffect::UI_FadeMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX],
        Sbk_Qt_TypeF(), "UI_AnimateCombo", (long) Qt::UIEffect::UI_AnimateCombo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX],
        Sbk_Qt_TypeF(), "UI_AnimateTooltip", (long) Qt::UIEffect::UI_AnimateTooltip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX],
        Sbk_Qt_TypeF(), "UI_FadeTooltip", (long) Qt::UIEffect::UI_FadeTooltip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX],
        Sbk_Qt_TypeF(), "UI_AnimateToolBox", (long) Qt::UIEffect::UI_AnimateToolBox))
        return;
    // Register converter for enum 'Qt::UIEffect'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX],
            Qt_UIEffect_CppToPython_Qt_UIEffect);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_UIEffect_PythonToCpp_Qt_UIEffect,
            is_Qt_UIEffect_PythonToCpp_Qt_UIEffect_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::UIEffect");
        Shiboken::Conversions::registerConverterName(converter, "UIEffect");
    }
    // End of 'UIEffect' enum.

    // Initialization of enum 'CursorShape'.
    SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "CursorShape",
        "2:PySide2.QtCore.Qt.CursorShape",
        "Qt::CursorShape");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "ArrowCursor", (long) Qt::CursorShape::ArrowCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "UpArrowCursor", (long) Qt::CursorShape::UpArrowCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "CrossCursor", (long) Qt::CursorShape::CrossCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "WaitCursor", (long) Qt::CursorShape::WaitCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "IBeamCursor", (long) Qt::CursorShape::IBeamCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "SizeVerCursor", (long) Qt::CursorShape::SizeVerCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "SizeHorCursor", (long) Qt::CursorShape::SizeHorCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "SizeBDiagCursor", (long) Qt::CursorShape::SizeBDiagCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "SizeFDiagCursor", (long) Qt::CursorShape::SizeFDiagCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "SizeAllCursor", (long) Qt::CursorShape::SizeAllCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "BlankCursor", (long) Qt::CursorShape::BlankCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "SplitVCursor", (long) Qt::CursorShape::SplitVCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "SplitHCursor", (long) Qt::CursorShape::SplitHCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "PointingHandCursor", (long) Qt::CursorShape::PointingHandCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "ForbiddenCursor", (long) Qt::CursorShape::ForbiddenCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "WhatsThisCursor", (long) Qt::CursorShape::WhatsThisCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "BusyCursor", (long) Qt::CursorShape::BusyCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "OpenHandCursor", (long) Qt::CursorShape::OpenHandCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "ClosedHandCursor", (long) Qt::CursorShape::ClosedHandCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "DragCopyCursor", (long) Qt::CursorShape::DragCopyCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "DragMoveCursor", (long) Qt::CursorShape::DragMoveCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "DragLinkCursor", (long) Qt::CursorShape::DragLinkCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "LastCursor", (long) Qt::CursorShape::LastCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "BitmapCursor", (long) Qt::CursorShape::BitmapCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
        Sbk_Qt_TypeF(), "CustomCursor", (long) Qt::CursorShape::CustomCursor))
        return;
    // Register converter for enum 'Qt::CursorShape'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX],
            Qt_CursorShape_CppToPython_Qt_CursorShape);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_CursorShape_PythonToCpp_Qt_CursorShape,
            is_Qt_CursorShape_PythonToCpp_Qt_CursorShape_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::CursorShape");
        Shiboken::Conversions::registerConverterName(converter, "CursorShape");
    }
    // End of 'CursorShape' enum.

    // Initialization of enum 'TextFormat'.
    SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "TextFormat",
        "2:PySide2.QtCore.Qt.TextFormat",
        "Qt::TextFormat");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX],
        Sbk_Qt_TypeF(), "PlainText", (long) Qt::TextFormat::PlainText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX],
        Sbk_Qt_TypeF(), "RichText", (long) Qt::TextFormat::RichText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX],
        Sbk_Qt_TypeF(), "AutoText", (long) Qt::TextFormat::AutoText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX],
        Sbk_Qt_TypeF(), "MarkdownText", (long) Qt::TextFormat::MarkdownText))
        return;
    // Register converter for enum 'Qt::TextFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX],
            Qt_TextFormat_CppToPython_Qt_TextFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TextFormat_PythonToCpp_Qt_TextFormat,
            is_Qt_TextFormat_PythonToCpp_Qt_TextFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TextFormat");
        Shiboken::Conversions::registerConverterName(converter, "TextFormat");
    }
    // End of 'TextFormat' enum.

    // Initialization of enum 'AspectRatioMode'.
    SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "AspectRatioMode",
        "2:PySide2.QtCore.Qt.AspectRatioMode",
        "Qt::AspectRatioMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX],
        Sbk_Qt_TypeF(), "IgnoreAspectRatio", (long) Qt::AspectRatioMode::IgnoreAspectRatio))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX],
        Sbk_Qt_TypeF(), "KeepAspectRatio", (long) Qt::AspectRatioMode::KeepAspectRatio))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX],
        Sbk_Qt_TypeF(), "KeepAspectRatioByExpanding", (long) Qt::AspectRatioMode::KeepAspectRatioByExpanding))
        return;
    // Register converter for enum 'Qt::AspectRatioMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX],
            Qt_AspectRatioMode_CppToPython_Qt_AspectRatioMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_AspectRatioMode_PythonToCpp_Qt_AspectRatioMode,
            is_Qt_AspectRatioMode_PythonToCpp_Qt_AspectRatioMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::AspectRatioMode");
        Shiboken::Conversions::registerConverterName(converter, "AspectRatioMode");
    }
    // End of 'AspectRatioMode' enum.

    // Initialization of enum 'DockWidgetArea'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.DockWidgetAreas", SbkPySide2_QtCore_Qt_DockWidgetArea_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "DockWidgetArea",
        "2:PySide2.QtCore.Qt.DockWidgetArea",
        "Qt::DockWidgetArea",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX],
        Sbk_Qt_TypeF(), "LeftDockWidgetArea", (long) Qt::DockWidgetArea::LeftDockWidgetArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX],
        Sbk_Qt_TypeF(), "RightDockWidgetArea", (long) Qt::DockWidgetArea::RightDockWidgetArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX],
        Sbk_Qt_TypeF(), "TopDockWidgetArea", (long) Qt::DockWidgetArea::TopDockWidgetArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX],
        Sbk_Qt_TypeF(), "BottomDockWidgetArea", (long) Qt::DockWidgetArea::BottomDockWidgetArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX],
        Sbk_Qt_TypeF(), "DockWidgetArea_Mask", (long) Qt::DockWidgetArea::DockWidgetArea_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX],
        Sbk_Qt_TypeF(), "AllDockWidgetAreas", (long) Qt::DockWidgetArea::AllDockWidgetAreas))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX],
        Sbk_Qt_TypeF(), "NoDockWidgetArea", (long) Qt::DockWidgetArea::NoDockWidgetArea))
        return;
    // Register converter for enum 'Qt::DockWidgetArea'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX],
            Qt_DockWidgetArea_CppToPython_Qt_DockWidgetArea);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_DockWidgetArea_PythonToCpp_Qt_DockWidgetArea,
            is_Qt_DockWidgetArea_PythonToCpp_Qt_DockWidgetArea_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::DockWidgetArea");
        Shiboken::Conversions::registerConverterName(converter, "DockWidgetArea");
    }
    // Register converter for flag 'QFlags<Qt::DockWidgetArea>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX],
            QFlags_Qt_DockWidgetArea__CppToPython_QFlags_Qt_DockWidgetArea_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_DockWidgetArea_PythonToCpp_QFlags_Qt_DockWidgetArea_,
            is_Qt_DockWidgetArea_PythonToCpp_QFlags_Qt_DockWidgetArea__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_DockWidgetArea__PythonToCpp_QFlags_Qt_DockWidgetArea_,
            is_QFlags_Qt_DockWidgetArea__PythonToCpp_QFlags_Qt_DockWidgetArea__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_DockWidgetArea_,
            is_number_PythonToCpp_QFlags_Qt_DockWidgetArea__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::DockWidgetAreas");
        Shiboken::Conversions::registerConverterName(converter, "DockWidgetAreas");
    }
    // End of 'DockWidgetArea' enum/flags.

    // Initialization of enum 'DockWidgetAreaSizes'.
    SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREASIZES_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "DockWidgetAreaSizes",
        "2:PySide2.QtCore.Qt.DockWidgetAreaSizes",
        "Qt::DockWidgetAreaSizes");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREASIZES_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREASIZES_IDX],
        Sbk_Qt_TypeF(), "NDockWidgetAreas", (long) Qt::DockWidgetAreaSizes::NDockWidgetAreas))
        return;
    // Register converter for enum 'Qt::DockWidgetAreaSizes'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREASIZES_IDX],
            Qt_DockWidgetAreaSizes_CppToPython_Qt_DockWidgetAreaSizes);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_DockWidgetAreaSizes_PythonToCpp_Qt_DockWidgetAreaSizes,
            is_Qt_DockWidgetAreaSizes_PythonToCpp_Qt_DockWidgetAreaSizes_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_DOCKWIDGETAREASIZES_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::DockWidgetAreaSizes");
        Shiboken::Conversions::registerConverterName(converter, "DockWidgetAreaSizes");
    }
    // End of 'DockWidgetAreaSizes' enum.

    // Initialization of enum 'ToolBarArea'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.ToolBarAreas", SbkPySide2_QtCore_Qt_ToolBarArea_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ToolBarArea",
        "2:PySide2.QtCore.Qt.ToolBarArea",
        "Qt::ToolBarArea",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX],
        Sbk_Qt_TypeF(), "LeftToolBarArea", (long) Qt::ToolBarArea::LeftToolBarArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX],
        Sbk_Qt_TypeF(), "RightToolBarArea", (long) Qt::ToolBarArea::RightToolBarArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX],
        Sbk_Qt_TypeF(), "TopToolBarArea", (long) Qt::ToolBarArea::TopToolBarArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX],
        Sbk_Qt_TypeF(), "BottomToolBarArea", (long) Qt::ToolBarArea::BottomToolBarArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX],
        Sbk_Qt_TypeF(), "ToolBarArea_Mask", (long) Qt::ToolBarArea::ToolBarArea_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX],
        Sbk_Qt_TypeF(), "AllToolBarAreas", (long) Qt::ToolBarArea::AllToolBarAreas))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX],
        Sbk_Qt_TypeF(), "NoToolBarArea", (long) Qt::ToolBarArea::NoToolBarArea))
        return;
    // Register converter for enum 'Qt::ToolBarArea'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX],
            Qt_ToolBarArea_CppToPython_Qt_ToolBarArea);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ToolBarArea_PythonToCpp_Qt_ToolBarArea,
            is_Qt_ToolBarArea_PythonToCpp_Qt_ToolBarArea_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ToolBarArea");
        Shiboken::Conversions::registerConverterName(converter, "ToolBarArea");
    }
    // Register converter for flag 'QFlags<Qt::ToolBarArea>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX],
            QFlags_Qt_ToolBarArea__CppToPython_QFlags_Qt_ToolBarArea_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ToolBarArea_PythonToCpp_QFlags_Qt_ToolBarArea_,
            is_Qt_ToolBarArea_PythonToCpp_QFlags_Qt_ToolBarArea__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_ToolBarArea__PythonToCpp_QFlags_Qt_ToolBarArea_,
            is_QFlags_Qt_ToolBarArea__PythonToCpp_QFlags_Qt_ToolBarArea__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_ToolBarArea_,
            is_number_PythonToCpp_QFlags_Qt_ToolBarArea__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ToolBarAreas");
        Shiboken::Conversions::registerConverterName(converter, "ToolBarAreas");
    }
    // End of 'ToolBarArea' enum/flags.

    // Initialization of enum 'ToolBarAreaSizes'.
    SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREASIZES_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ToolBarAreaSizes",
        "2:PySide2.QtCore.Qt.ToolBarAreaSizes",
        "Qt::ToolBarAreaSizes");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREASIZES_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREASIZES_IDX],
        Sbk_Qt_TypeF(), "NToolBarAreas", (long) Qt::ToolBarAreaSizes::NToolBarAreas))
        return;
    // Register converter for enum 'Qt::ToolBarAreaSizes'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREASIZES_IDX],
            Qt_ToolBarAreaSizes_CppToPython_Qt_ToolBarAreaSizes);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ToolBarAreaSizes_PythonToCpp_Qt_ToolBarAreaSizes,
            is_Qt_ToolBarAreaSizes_PythonToCpp_Qt_ToolBarAreaSizes_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREASIZES_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ToolBarAreaSizes");
        Shiboken::Conversions::registerConverterName(converter, "ToolBarAreaSizes");
    }
    // End of 'ToolBarAreaSizes' enum.

    // Initialization of enum 'DateFormat'.
    SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "DateFormat",
        "2:PySide2.QtCore.Qt.DateFormat",
        "Qt::DateFormat");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
        Sbk_Qt_TypeF(), "TextDate", (long) Qt::DateFormat::TextDate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
        Sbk_Qt_TypeF(), "ISODate", (long) Qt::DateFormat::ISODate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
        Sbk_Qt_TypeF(), "SystemLocaleDate", (long) Qt::DateFormat::SystemLocaleDate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
        Sbk_Qt_TypeF(), "LocalDate", (long) Qt::DateFormat::LocalDate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
        Sbk_Qt_TypeF(), "LocaleDate", (long) Qt::DateFormat::LocaleDate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
        Sbk_Qt_TypeF(), "SystemLocaleShortDate", (long) Qt::DateFormat::SystemLocaleShortDate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
        Sbk_Qt_TypeF(), "SystemLocaleLongDate", (long) Qt::DateFormat::SystemLocaleLongDate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
        Sbk_Qt_TypeF(), "DefaultLocaleShortDate", (long) Qt::DateFormat::DefaultLocaleShortDate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
        Sbk_Qt_TypeF(), "DefaultLocaleLongDate", (long) Qt::DateFormat::DefaultLocaleLongDate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
        Sbk_Qt_TypeF(), "RFC2822Date", (long) Qt::DateFormat::RFC2822Date))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
        Sbk_Qt_TypeF(), "ISODateWithMs", (long) Qt::DateFormat::ISODateWithMs))
        return;
    // Register converter for enum 'Qt::DateFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX],
            Qt_DateFormat_CppToPython_Qt_DateFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_DateFormat_PythonToCpp_Qt_DateFormat,
            is_Qt_DateFormat_PythonToCpp_Qt_DateFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::DateFormat");
        Shiboken::Conversions::registerConverterName(converter, "DateFormat");
    }
    // End of 'DateFormat' enum.

    // Initialization of enum 'TimeSpec'.
    SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "TimeSpec",
        "2:PySide2.QtCore.Qt.TimeSpec",
        "Qt::TimeSpec");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX],
        Sbk_Qt_TypeF(), "LocalTime", (long) Qt::TimeSpec::LocalTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX],
        Sbk_Qt_TypeF(), "UTC", (long) Qt::TimeSpec::UTC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX],
        Sbk_Qt_TypeF(), "OffsetFromUTC", (long) Qt::TimeSpec::OffsetFromUTC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX],
        Sbk_Qt_TypeF(), "TimeZone", (long) Qt::TimeSpec::TimeZone))
        return;
    // Register converter for enum 'Qt::TimeSpec'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX],
            Qt_TimeSpec_CppToPython_Qt_TimeSpec);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TimeSpec_PythonToCpp_Qt_TimeSpec,
            is_Qt_TimeSpec_PythonToCpp_Qt_TimeSpec_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TimeSpec");
        Shiboken::Conversions::registerConverterName(converter, "TimeSpec");
    }
    // End of 'TimeSpec' enum.

    // Initialization of enum 'DayOfWeek'.
    SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "DayOfWeek",
        "2:PySide2.QtCore.Qt.DayOfWeek",
        "Qt::DayOfWeek");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX],
        Sbk_Qt_TypeF(), "Monday", (long) Qt::DayOfWeek::Monday))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX],
        Sbk_Qt_TypeF(), "Tuesday", (long) Qt::DayOfWeek::Tuesday))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX],
        Sbk_Qt_TypeF(), "Wednesday", (long) Qt::DayOfWeek::Wednesday))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX],
        Sbk_Qt_TypeF(), "Thursday", (long) Qt::DayOfWeek::Thursday))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX],
        Sbk_Qt_TypeF(), "Friday", (long) Qt::DayOfWeek::Friday))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX],
        Sbk_Qt_TypeF(), "Saturday", (long) Qt::DayOfWeek::Saturday))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX],
        Sbk_Qt_TypeF(), "Sunday", (long) Qt::DayOfWeek::Sunday))
        return;
    // Register converter for enum 'Qt::DayOfWeek'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX],
            Qt_DayOfWeek_CppToPython_Qt_DayOfWeek);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_DayOfWeek_PythonToCpp_Qt_DayOfWeek,
            is_Qt_DayOfWeek_PythonToCpp_Qt_DayOfWeek_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::DayOfWeek");
        Shiboken::Conversions::registerConverterName(converter, "DayOfWeek");
    }
    // End of 'DayOfWeek' enum.

    // Initialization of enum 'ScrollBarPolicy'.
    SbkPySide2_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ScrollBarPolicy",
        "2:PySide2.QtCore.Qt.ScrollBarPolicy",
        "Qt::ScrollBarPolicy");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX],
        Sbk_Qt_TypeF(), "ScrollBarAsNeeded", (long) Qt::ScrollBarPolicy::ScrollBarAsNeeded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX],
        Sbk_Qt_TypeF(), "ScrollBarAlwaysOff", (long) Qt::ScrollBarPolicy::ScrollBarAlwaysOff))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX],
        Sbk_Qt_TypeF(), "ScrollBarAlwaysOn", (long) Qt::ScrollBarPolicy::ScrollBarAlwaysOn))
        return;
    // Register converter for enum 'Qt::ScrollBarPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX],
            Qt_ScrollBarPolicy_CppToPython_Qt_ScrollBarPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ScrollBarPolicy_PythonToCpp_Qt_ScrollBarPolicy,
            is_Qt_ScrollBarPolicy_PythonToCpp_Qt_ScrollBarPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ScrollBarPolicy");
        Shiboken::Conversions::registerConverterName(converter, "ScrollBarPolicy");
    }
    // End of 'ScrollBarPolicy' enum.

    // Initialization of enum 'CaseSensitivity'.
    SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "CaseSensitivity",
        "2:PySide2.QtCore.Qt.CaseSensitivity",
        "Qt::CaseSensitivity");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX],
        Sbk_Qt_TypeF(), "CaseInsensitive", (long) Qt::CaseSensitivity::CaseInsensitive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX],
        Sbk_Qt_TypeF(), "CaseSensitive", (long) Qt::CaseSensitivity::CaseSensitive))
        return;
    // Register converter for enum 'Qt::CaseSensitivity'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX],
            Qt_CaseSensitivity_CppToPython_Qt_CaseSensitivity);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_CaseSensitivity_PythonToCpp_Qt_CaseSensitivity,
            is_Qt_CaseSensitivity_PythonToCpp_Qt_CaseSensitivity_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::CaseSensitivity");
        Shiboken::Conversions::registerConverterName(converter, "CaseSensitivity");
    }
    // End of 'CaseSensitivity' enum.

    // Initialization of enum 'Corner'.
    SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "Corner",
        "2:PySide2.QtCore.Qt.Corner",
        "Qt::Corner");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX],
        Sbk_Qt_TypeF(), "TopLeftCorner", (long) Qt::Corner::TopLeftCorner))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX],
        Sbk_Qt_TypeF(), "TopRightCorner", (long) Qt::Corner::TopRightCorner))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX],
        Sbk_Qt_TypeF(), "BottomLeftCorner", (long) Qt::Corner::BottomLeftCorner))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX],
        Sbk_Qt_TypeF(), "BottomRightCorner", (long) Qt::Corner::BottomRightCorner))
        return;
    // Register converter for enum 'Qt::Corner'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX],
            Qt_Corner_CppToPython_Qt_Corner);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_Corner_PythonToCpp_Qt_Corner,
            is_Qt_Corner_PythonToCpp_Qt_Corner_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::Corner");
        Shiboken::Conversions::registerConverterName(converter, "Corner");
    }
    // End of 'Corner' enum.

    // Initialization of enum 'Edge'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.Edges", SbkPySide2_QtCore_Qt_Edge_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "Edge",
        "2:PySide2.QtCore.Qt.Edge",
        "Qt::Edge",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX],
        Sbk_Qt_TypeF(), "TopEdge", (long) Qt::Edge::TopEdge))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX],
        Sbk_Qt_TypeF(), "LeftEdge", (long) Qt::Edge::LeftEdge))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX],
        Sbk_Qt_TypeF(), "RightEdge", (long) Qt::Edge::RightEdge))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX],
        Sbk_Qt_TypeF(), "BottomEdge", (long) Qt::Edge::BottomEdge))
        return;
    // Register converter for enum 'Qt::Edge'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX],
            Qt_Edge_CppToPython_Qt_Edge);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_Edge_PythonToCpp_Qt_Edge,
            is_Qt_Edge_PythonToCpp_Qt_Edge_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_EDGE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::Edge");
        Shiboken::Conversions::registerConverterName(converter, "Edge");
    }
    // Register converter for flag 'QFlags<Qt::Edge>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX],
            QFlags_Qt_Edge__CppToPython_QFlags_Qt_Edge_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_Edge_PythonToCpp_QFlags_Qt_Edge_,
            is_Qt_Edge_PythonToCpp_QFlags_Qt_Edge__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_Edge__PythonToCpp_QFlags_Qt_Edge_,
            is_QFlags_Qt_Edge__PythonToCpp_QFlags_Qt_Edge__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_Edge_,
            is_number_PythonToCpp_QFlags_Qt_Edge__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_EDGE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::Edges");
        Shiboken::Conversions::registerConverterName(converter, "Edges");
    }
    // End of 'Edge' enum/flags.

    // Initialization of enum 'ConnectionType'.
    SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ConnectionType",
        "2:PySide2.QtCore.Qt.ConnectionType",
        "Qt::ConnectionType");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX],
        Sbk_Qt_TypeF(), "AutoConnection", (long) Qt::ConnectionType::AutoConnection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX],
        Sbk_Qt_TypeF(), "DirectConnection", (long) Qt::ConnectionType::DirectConnection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX],
        Sbk_Qt_TypeF(), "QueuedConnection", (long) Qt::ConnectionType::QueuedConnection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX],
        Sbk_Qt_TypeF(), "BlockingQueuedConnection", (long) Qt::ConnectionType::BlockingQueuedConnection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX],
        Sbk_Qt_TypeF(), "UniqueConnection", (long) Qt::ConnectionType::UniqueConnection))
        return;
    // Register converter for enum 'Qt::ConnectionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX],
            Qt_ConnectionType_CppToPython_Qt_ConnectionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ConnectionType_PythonToCpp_Qt_ConnectionType,
            is_Qt_ConnectionType_PythonToCpp_Qt_ConnectionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ConnectionType");
        Shiboken::Conversions::registerConverterName(converter, "ConnectionType");
    }
    // End of 'ConnectionType' enum.

    // Initialization of enum 'ShortcutContext'.
    SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ShortcutContext",
        "2:PySide2.QtCore.Qt.ShortcutContext",
        "Qt::ShortcutContext");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX],
        Sbk_Qt_TypeF(), "WidgetShortcut", (long) Qt::ShortcutContext::WidgetShortcut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX],
        Sbk_Qt_TypeF(), "WindowShortcut", (long) Qt::ShortcutContext::WindowShortcut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX],
        Sbk_Qt_TypeF(), "ApplicationShortcut", (long) Qt::ShortcutContext::ApplicationShortcut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX],
        Sbk_Qt_TypeF(), "WidgetWithChildrenShortcut", (long) Qt::ShortcutContext::WidgetWithChildrenShortcut))
        return;
    // Register converter for enum 'Qt::ShortcutContext'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX],
            Qt_ShortcutContext_CppToPython_Qt_ShortcutContext);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ShortcutContext_PythonToCpp_Qt_ShortcutContext,
            is_Qt_ShortcutContext_PythonToCpp_Qt_ShortcutContext_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ShortcutContext");
        Shiboken::Conversions::registerConverterName(converter, "ShortcutContext");
    }
    // End of 'ShortcutContext' enum.

    // Initialization of enum 'FillRule'.
    SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "FillRule",
        "2:PySide2.QtCore.Qt.FillRule",
        "Qt::FillRule");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX],
        Sbk_Qt_TypeF(), "OddEvenFill", (long) Qt::FillRule::OddEvenFill))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX],
        Sbk_Qt_TypeF(), "WindingFill", (long) Qt::FillRule::WindingFill))
        return;
    // Register converter for enum 'Qt::FillRule'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX],
            Qt_FillRule_CppToPython_Qt_FillRule);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_FillRule_PythonToCpp_Qt_FillRule,
            is_Qt_FillRule_PythonToCpp_Qt_FillRule_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_FILLRULE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::FillRule");
        Shiboken::Conversions::registerConverterName(converter, "FillRule");
    }
    // End of 'FillRule' enum.

    // Initialization of enum 'MaskMode'.
    SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "MaskMode",
        "2:PySide2.QtCore.Qt.MaskMode",
        "Qt::MaskMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX],
        Sbk_Qt_TypeF(), "MaskInColor", (long) Qt::MaskMode::MaskInColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX],
        Sbk_Qt_TypeF(), "MaskOutColor", (long) Qt::MaskMode::MaskOutColor))
        return;
    // Register converter for enum 'Qt::MaskMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX],
            Qt_MaskMode_CppToPython_Qt_MaskMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_MaskMode_PythonToCpp_Qt_MaskMode,
            is_Qt_MaskMode_PythonToCpp_Qt_MaskMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_MASKMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::MaskMode");
        Shiboken::Conversions::registerConverterName(converter, "MaskMode");
    }
    // End of 'MaskMode' enum.

    // Initialization of enum 'ClipOperation'.
    SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ClipOperation",
        "2:PySide2.QtCore.Qt.ClipOperation",
        "Qt::ClipOperation");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX],
        Sbk_Qt_TypeF(), "NoClip", (long) Qt::ClipOperation::NoClip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX],
        Sbk_Qt_TypeF(), "ReplaceClip", (long) Qt::ClipOperation::ReplaceClip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX],
        Sbk_Qt_TypeF(), "IntersectClip", (long) Qt::ClipOperation::IntersectClip))
        return;
    // Register converter for enum 'Qt::ClipOperation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX],
            Qt_ClipOperation_CppToPython_Qt_ClipOperation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ClipOperation_PythonToCpp_Qt_ClipOperation,
            is_Qt_ClipOperation_PythonToCpp_Qt_ClipOperation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ClipOperation");
        Shiboken::Conversions::registerConverterName(converter, "ClipOperation");
    }
    // End of 'ClipOperation' enum.

    // Initialization of enum 'ItemSelectionMode'.
    SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ItemSelectionMode",
        "2:PySide2.QtCore.Qt.ItemSelectionMode",
        "Qt::ItemSelectionMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX],
        Sbk_Qt_TypeF(), "ContainsItemShape", (long) Qt::ItemSelectionMode::ContainsItemShape))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX],
        Sbk_Qt_TypeF(), "IntersectsItemShape", (long) Qt::ItemSelectionMode::IntersectsItemShape))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX],
        Sbk_Qt_TypeF(), "ContainsItemBoundingRect", (long) Qt::ItemSelectionMode::ContainsItemBoundingRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX],
        Sbk_Qt_TypeF(), "IntersectsItemBoundingRect", (long) Qt::ItemSelectionMode::IntersectsItemBoundingRect))
        return;
    // Register converter for enum 'Qt::ItemSelectionMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX],
            Qt_ItemSelectionMode_CppToPython_Qt_ItemSelectionMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ItemSelectionMode_PythonToCpp_Qt_ItemSelectionMode,
            is_Qt_ItemSelectionMode_PythonToCpp_Qt_ItemSelectionMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ItemSelectionMode");
        Shiboken::Conversions::registerConverterName(converter, "ItemSelectionMode");
    }
    // End of 'ItemSelectionMode' enum.

    // Initialization of enum 'ItemSelectionOperation'.
    SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONOPERATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ItemSelectionOperation",
        "2:PySide2.QtCore.Qt.ItemSelectionOperation",
        "Qt::ItemSelectionOperation");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONOPERATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONOPERATION_IDX],
        Sbk_Qt_TypeF(), "ReplaceSelection", (long) Qt::ItemSelectionOperation::ReplaceSelection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONOPERATION_IDX],
        Sbk_Qt_TypeF(), "AddToSelection", (long) Qt::ItemSelectionOperation::AddToSelection))
        return;
    // Register converter for enum 'Qt::ItemSelectionOperation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONOPERATION_IDX],
            Qt_ItemSelectionOperation_CppToPython_Qt_ItemSelectionOperation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ItemSelectionOperation_PythonToCpp_Qt_ItemSelectionOperation,
            is_Qt_ItemSelectionOperation_PythonToCpp_Qt_ItemSelectionOperation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONOPERATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ItemSelectionOperation");
        Shiboken::Conversions::registerConverterName(converter, "ItemSelectionOperation");
    }
    // End of 'ItemSelectionOperation' enum.

    // Initialization of enum 'TransformationMode'.
    SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "TransformationMode",
        "2:PySide2.QtCore.Qt.TransformationMode",
        "Qt::TransformationMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX],
        Sbk_Qt_TypeF(), "FastTransformation", (long) Qt::TransformationMode::FastTransformation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX],
        Sbk_Qt_TypeF(), "SmoothTransformation", (long) Qt::TransformationMode::SmoothTransformation))
        return;
    // Register converter for enum 'Qt::TransformationMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX],
            Qt_TransformationMode_CppToPython_Qt_TransformationMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TransformationMode_PythonToCpp_Qt_TransformationMode,
            is_Qt_TransformationMode_PythonToCpp_Qt_TransformationMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TransformationMode");
        Shiboken::Conversions::registerConverterName(converter, "TransformationMode");
    }
    // End of 'TransformationMode' enum.

    // Initialization of enum 'Axis'.
    SbkPySide2_QtCoreTypes[SBK_QT_AXIS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "Axis",
        "2:PySide2.QtCore.Qt.Axis",
        "Qt::Axis");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_AXIS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_AXIS_IDX],
        Sbk_Qt_TypeF(), "XAxis", (long) Qt::Axis::XAxis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_AXIS_IDX],
        Sbk_Qt_TypeF(), "YAxis", (long) Qt::Axis::YAxis))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_AXIS_IDX],
        Sbk_Qt_TypeF(), "ZAxis", (long) Qt::Axis::ZAxis))
        return;
    // Register converter for enum 'Qt::Axis'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_AXIS_IDX],
            Qt_Axis_CppToPython_Qt_Axis);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_Axis_PythonToCpp_Qt_Axis,
            is_Qt_Axis_PythonToCpp_Qt_Axis_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_AXIS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::Axis");
        Shiboken::Conversions::registerConverterName(converter, "Axis");
    }
    // End of 'Axis' enum.

    // Initialization of enum 'FocusReason'.
    SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "FocusReason",
        "2:PySide2.QtCore.Qt.FocusReason",
        "Qt::FocusReason");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX],
        Sbk_Qt_TypeF(), "MouseFocusReason", (long) Qt::FocusReason::MouseFocusReason))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX],
        Sbk_Qt_TypeF(), "TabFocusReason", (long) Qt::FocusReason::TabFocusReason))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX],
        Sbk_Qt_TypeF(), "BacktabFocusReason", (long) Qt::FocusReason::BacktabFocusReason))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX],
        Sbk_Qt_TypeF(), "ActiveWindowFocusReason", (long) Qt::FocusReason::ActiveWindowFocusReason))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX],
        Sbk_Qt_TypeF(), "PopupFocusReason", (long) Qt::FocusReason::PopupFocusReason))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX],
        Sbk_Qt_TypeF(), "ShortcutFocusReason", (long) Qt::FocusReason::ShortcutFocusReason))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX],
        Sbk_Qt_TypeF(), "MenuBarFocusReason", (long) Qt::FocusReason::MenuBarFocusReason))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX],
        Sbk_Qt_TypeF(), "OtherFocusReason", (long) Qt::FocusReason::OtherFocusReason))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX],
        Sbk_Qt_TypeF(), "NoFocusReason", (long) Qt::FocusReason::NoFocusReason))
        return;
    // Register converter for enum 'Qt::FocusReason'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX],
            Qt_FocusReason_CppToPython_Qt_FocusReason);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_FocusReason_PythonToCpp_Qt_FocusReason,
            is_Qt_FocusReason_PythonToCpp_Qt_FocusReason_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::FocusReason");
        Shiboken::Conversions::registerConverterName(converter, "FocusReason");
    }
    // End of 'FocusReason' enum.

    // Initialization of enum 'ContextMenuPolicy'.
    SbkPySide2_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ContextMenuPolicy",
        "2:PySide2.QtCore.Qt.ContextMenuPolicy",
        "Qt::ContextMenuPolicy");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX],
        Sbk_Qt_TypeF(), "NoContextMenu", (long) Qt::ContextMenuPolicy::NoContextMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX],
        Sbk_Qt_TypeF(), "DefaultContextMenu", (long) Qt::ContextMenuPolicy::DefaultContextMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX],
        Sbk_Qt_TypeF(), "ActionsContextMenu", (long) Qt::ContextMenuPolicy::ActionsContextMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX],
        Sbk_Qt_TypeF(), "CustomContextMenu", (long) Qt::ContextMenuPolicy::CustomContextMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX],
        Sbk_Qt_TypeF(), "PreventContextMenu", (long) Qt::ContextMenuPolicy::PreventContextMenu))
        return;
    // Register converter for enum 'Qt::ContextMenuPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX],
            Qt_ContextMenuPolicy_CppToPython_Qt_ContextMenuPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ContextMenuPolicy_PythonToCpp_Qt_ContextMenuPolicy,
            is_Qt_ContextMenuPolicy_PythonToCpp_Qt_ContextMenuPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ContextMenuPolicy");
        Shiboken::Conversions::registerConverterName(converter, "ContextMenuPolicy");
    }
    // End of 'ContextMenuPolicy' enum.

    // Initialization of enum 'InputMethodQuery'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.InputMethodQueries", SbkPySide2_QtCore_Qt_InputMethodQuery_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "InputMethodQuery",
        "2:PySide2.QtCore.Qt.InputMethodQuery",
        "Qt::InputMethodQuery",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImEnabled", (long) Qt::InputMethodQuery::ImEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImCursorRectangle", (long) Qt::InputMethodQuery::ImCursorRectangle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImMicroFocus", (long) Qt::InputMethodQuery::ImMicroFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImFont", (long) Qt::InputMethodQuery::ImFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImCursorPosition", (long) Qt::InputMethodQuery::ImCursorPosition))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImSurroundingText", (long) Qt::InputMethodQuery::ImSurroundingText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImCurrentSelection", (long) Qt::InputMethodQuery::ImCurrentSelection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImMaximumTextLength", (long) Qt::InputMethodQuery::ImMaximumTextLength))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImAnchorPosition", (long) Qt::InputMethodQuery::ImAnchorPosition))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImHints", (long) Qt::InputMethodQuery::ImHints))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImPreferredLanguage", (long) Qt::InputMethodQuery::ImPreferredLanguage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImAbsolutePosition", (long) Qt::InputMethodQuery::ImAbsolutePosition))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImTextBeforeCursor", (long) Qt::InputMethodQuery::ImTextBeforeCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImTextAfterCursor", (long) Qt::InputMethodQuery::ImTextAfterCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImEnterKeyType", (long) Qt::InputMethodQuery::ImEnterKeyType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImAnchorRectangle", (long) Qt::InputMethodQuery::ImAnchorRectangle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImInputItemClipRectangle", (long) Qt::InputMethodQuery::ImInputItemClipRectangle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImPlatformData", (long) Qt::InputMethodQuery::ImPlatformData))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImQueryInput", (long) Qt::InputMethodQuery::ImQueryInput))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
        Sbk_Qt_TypeF(), "ImQueryAll", (long) Qt::InputMethodQuery::ImQueryAll))
        return;
    // Register converter for enum 'Qt::InputMethodQuery'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX],
            Qt_InputMethodQuery_CppToPython_Qt_InputMethodQuery);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_InputMethodQuery_PythonToCpp_Qt_InputMethodQuery,
            is_Qt_InputMethodQuery_PythonToCpp_Qt_InputMethodQuery_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::InputMethodQuery");
        Shiboken::Conversions::registerConverterName(converter, "InputMethodQuery");
    }
    // Register converter for flag 'QFlags<Qt::InputMethodQuery>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX],
            QFlags_Qt_InputMethodQuery__CppToPython_QFlags_Qt_InputMethodQuery_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_InputMethodQuery_PythonToCpp_QFlags_Qt_InputMethodQuery_,
            is_Qt_InputMethodQuery_PythonToCpp_QFlags_Qt_InputMethodQuery__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_InputMethodQuery__PythonToCpp_QFlags_Qt_InputMethodQuery_,
            is_QFlags_Qt_InputMethodQuery__PythonToCpp_QFlags_Qt_InputMethodQuery__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_InputMethodQuery_,
            is_number_PythonToCpp_QFlags_Qt_InputMethodQuery__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::InputMethodQueries");
        Shiboken::Conversions::registerConverterName(converter, "InputMethodQueries");
    }
    // End of 'InputMethodQuery' enum/flags.

    // Initialization of enum 'InputMethodHint'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.InputMethodHints", SbkPySide2_QtCore_Qt_InputMethodHint_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "InputMethodHint",
        "2:PySide2.QtCore.Qt.InputMethodHint",
        "Qt::InputMethodHint",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhNone", (long) Qt::InputMethodHint::ImhNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhHiddenText", (long) Qt::InputMethodHint::ImhHiddenText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhSensitiveData", (long) Qt::InputMethodHint::ImhSensitiveData))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhNoAutoUppercase", (long) Qt::InputMethodHint::ImhNoAutoUppercase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhPreferNumbers", (long) Qt::InputMethodHint::ImhPreferNumbers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhPreferUppercase", (long) Qt::InputMethodHint::ImhPreferUppercase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhPreferLowercase", (long) Qt::InputMethodHint::ImhPreferLowercase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhNoPredictiveText", (long) Qt::InputMethodHint::ImhNoPredictiveText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhDate", (long) Qt::InputMethodHint::ImhDate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhTime", (long) Qt::InputMethodHint::ImhTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhPreferLatin", (long) Qt::InputMethodHint::ImhPreferLatin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhMultiLine", (long) Qt::InputMethodHint::ImhMultiLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhNoEditMenu", (long) Qt::InputMethodHint::ImhNoEditMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhNoTextHandles", (long) Qt::InputMethodHint::ImhNoTextHandles))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhDigitsOnly", (long) Qt::InputMethodHint::ImhDigitsOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhFormattedNumbersOnly", (long) Qt::InputMethodHint::ImhFormattedNumbersOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhUppercaseOnly", (long) Qt::InputMethodHint::ImhUppercaseOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhLowercaseOnly", (long) Qt::InputMethodHint::ImhLowercaseOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhDialableCharactersOnly", (long) Qt::InputMethodHint::ImhDialableCharactersOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhEmailCharactersOnly", (long) Qt::InputMethodHint::ImhEmailCharactersOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhUrlCharactersOnly", (long) Qt::InputMethodHint::ImhUrlCharactersOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhLatinOnly", (long) Qt::InputMethodHint::ImhLatinOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
        Sbk_Qt_TypeF(), "ImhExclusiveInputMask", (long) Qt::InputMethodHint::ImhExclusiveInputMask))
        return;
    // Register converter for enum 'Qt::InputMethodHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX],
            Qt_InputMethodHint_CppToPython_Qt_InputMethodHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_InputMethodHint_PythonToCpp_Qt_InputMethodHint,
            is_Qt_InputMethodHint_PythonToCpp_Qt_InputMethodHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::InputMethodHint");
        Shiboken::Conversions::registerConverterName(converter, "InputMethodHint");
    }
    // Register converter for flag 'QFlags<Qt::InputMethodHint>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX],
            QFlags_Qt_InputMethodHint__CppToPython_QFlags_Qt_InputMethodHint_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_InputMethodHint_PythonToCpp_QFlags_Qt_InputMethodHint_,
            is_Qt_InputMethodHint_PythonToCpp_QFlags_Qt_InputMethodHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_InputMethodHint__PythonToCpp_QFlags_Qt_InputMethodHint_,
            is_QFlags_Qt_InputMethodHint__PythonToCpp_QFlags_Qt_InputMethodHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_InputMethodHint_,
            is_number_PythonToCpp_QFlags_Qt_InputMethodHint__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::InputMethodHints");
        Shiboken::Conversions::registerConverterName(converter, "InputMethodHints");
    }
    // End of 'InputMethodHint' enum/flags.

    // Initialization of enum 'EnterKeyType'.
    SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "EnterKeyType",
        "2:PySide2.QtCore.Qt.EnterKeyType",
        "Qt::EnterKeyType");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX],
        Sbk_Qt_TypeF(), "EnterKeyDefault", (long) Qt::EnterKeyType::EnterKeyDefault))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX],
        Sbk_Qt_TypeF(), "EnterKeyReturn", (long) Qt::EnterKeyType::EnterKeyReturn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX],
        Sbk_Qt_TypeF(), "EnterKeyDone", (long) Qt::EnterKeyType::EnterKeyDone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX],
        Sbk_Qt_TypeF(), "EnterKeyGo", (long) Qt::EnterKeyType::EnterKeyGo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX],
        Sbk_Qt_TypeF(), "EnterKeySend", (long) Qt::EnterKeyType::EnterKeySend))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX],
        Sbk_Qt_TypeF(), "EnterKeySearch", (long) Qt::EnterKeyType::EnterKeySearch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX],
        Sbk_Qt_TypeF(), "EnterKeyNext", (long) Qt::EnterKeyType::EnterKeyNext))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX],
        Sbk_Qt_TypeF(), "EnterKeyPrevious", (long) Qt::EnterKeyType::EnterKeyPrevious))
        return;
    // Register converter for enum 'Qt::EnterKeyType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX],
            Qt_EnterKeyType_CppToPython_Qt_EnterKeyType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_EnterKeyType_PythonToCpp_Qt_EnterKeyType,
            is_Qt_EnterKeyType_PythonToCpp_Qt_EnterKeyType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_ENTERKEYTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::EnterKeyType");
        Shiboken::Conversions::registerConverterName(converter, "EnterKeyType");
    }
    // End of 'EnterKeyType' enum.

    // Initialization of enum 'ToolButtonStyle'.
    SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ToolButtonStyle",
        "2:PySide2.QtCore.Qt.ToolButtonStyle",
        "Qt::ToolButtonStyle");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX],
        Sbk_Qt_TypeF(), "ToolButtonIconOnly", (long) Qt::ToolButtonStyle::ToolButtonIconOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX],
        Sbk_Qt_TypeF(), "ToolButtonTextOnly", (long) Qt::ToolButtonStyle::ToolButtonTextOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX],
        Sbk_Qt_TypeF(), "ToolButtonTextBesideIcon", (long) Qt::ToolButtonStyle::ToolButtonTextBesideIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX],
        Sbk_Qt_TypeF(), "ToolButtonTextUnderIcon", (long) Qt::ToolButtonStyle::ToolButtonTextUnderIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX],
        Sbk_Qt_TypeF(), "ToolButtonFollowStyle", (long) Qt::ToolButtonStyle::ToolButtonFollowStyle))
        return;
    // Register converter for enum 'Qt::ToolButtonStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX],
            Qt_ToolButtonStyle_CppToPython_Qt_ToolButtonStyle);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ToolButtonStyle_PythonToCpp_Qt_ToolButtonStyle,
            is_Qt_ToolButtonStyle_PythonToCpp_Qt_ToolButtonStyle_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ToolButtonStyle");
        Shiboken::Conversions::registerConverterName(converter, "ToolButtonStyle");
    }
    // End of 'ToolButtonStyle' enum.

    // Initialization of enum 'LayoutDirection'.
    SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "LayoutDirection",
        "2:PySide2.QtCore.Qt.LayoutDirection",
        "Qt::LayoutDirection");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX],
        Sbk_Qt_TypeF(), "LeftToRight", (long) Qt::LayoutDirection::LeftToRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX],
        Sbk_Qt_TypeF(), "RightToLeft", (long) Qt::LayoutDirection::RightToLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX],
        Sbk_Qt_TypeF(), "LayoutDirectionAuto", (long) Qt::LayoutDirection::LayoutDirectionAuto))
        return;
    // Register converter for enum 'Qt::LayoutDirection'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX],
            Qt_LayoutDirection_CppToPython_Qt_LayoutDirection);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_LayoutDirection_PythonToCpp_Qt_LayoutDirection,
            is_Qt_LayoutDirection_PythonToCpp_Qt_LayoutDirection_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::LayoutDirection");
        Shiboken::Conversions::registerConverterName(converter, "LayoutDirection");
    }
    // End of 'LayoutDirection' enum.

    // Initialization of enum 'AnchorPoint'.
    SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "AnchorPoint",
        "2:PySide2.QtCore.Qt.AnchorPoint",
        "Qt::AnchorPoint");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX],
        Sbk_Qt_TypeF(), "AnchorLeft", (long) Qt::AnchorPoint::AnchorLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX],
        Sbk_Qt_TypeF(), "AnchorHorizontalCenter", (long) Qt::AnchorPoint::AnchorHorizontalCenter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX],
        Sbk_Qt_TypeF(), "AnchorRight", (long) Qt::AnchorPoint::AnchorRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX],
        Sbk_Qt_TypeF(), "AnchorTop", (long) Qt::AnchorPoint::AnchorTop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX],
        Sbk_Qt_TypeF(), "AnchorVerticalCenter", (long) Qt::AnchorPoint::AnchorVerticalCenter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX],
        Sbk_Qt_TypeF(), "AnchorBottom", (long) Qt::AnchorPoint::AnchorBottom))
        return;
    // Register converter for enum 'Qt::AnchorPoint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX],
            Qt_AnchorPoint_CppToPython_Qt_AnchorPoint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_AnchorPoint_PythonToCpp_Qt_AnchorPoint,
            is_Qt_AnchorPoint_PythonToCpp_Qt_AnchorPoint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::AnchorPoint");
        Shiboken::Conversions::registerConverterName(converter, "AnchorPoint");
    }
    // End of 'AnchorPoint' enum.

    // Initialization of enum 'FindChildOption'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.FindChildOptions", SbkPySide2_QtCore_Qt_FindChildOption_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_FINDCHILDOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "FindChildOption",
        "2:PySide2.QtCore.Qt.FindChildOption",
        "Qt::FindChildOption",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_FINDCHILDOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FINDCHILDOPTION_IDX],
        Sbk_Qt_TypeF(), "FindDirectChildrenOnly", (long) Qt::FindChildOption::FindDirectChildrenOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_FINDCHILDOPTION_IDX],
        Sbk_Qt_TypeF(), "FindChildrenRecursively", (long) Qt::FindChildOption::FindChildrenRecursively))
        return;
    // Register converter for enum 'Qt::FindChildOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_FINDCHILDOPTION_IDX],
            Qt_FindChildOption_CppToPython_Qt_FindChildOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_FindChildOption_PythonToCpp_Qt_FindChildOption,
            is_Qt_FindChildOption_PythonToCpp_Qt_FindChildOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_FINDCHILDOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::FindChildOption");
        Shiboken::Conversions::registerConverterName(converter, "FindChildOption");
    }
    // Register converter for flag 'QFlags<Qt::FindChildOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX],
            QFlags_Qt_FindChildOption__CppToPython_QFlags_Qt_FindChildOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_FindChildOption_PythonToCpp_QFlags_Qt_FindChildOption_,
            is_Qt_FindChildOption_PythonToCpp_QFlags_Qt_FindChildOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_FindChildOption__PythonToCpp_QFlags_Qt_FindChildOption_,
            is_QFlags_Qt_FindChildOption__PythonToCpp_QFlags_Qt_FindChildOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_FindChildOption_,
            is_number_PythonToCpp_QFlags_Qt_FindChildOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::FindChildOptions");
        Shiboken::Conversions::registerConverterName(converter, "FindChildOptions");
    }
    // End of 'FindChildOption' enum/flags.

    // Initialization of enum 'DropAction'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.DropActions", SbkPySide2_QtCore_Qt_DropAction_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "DropAction",
        "2:PySide2.QtCore.Qt.DropAction",
        "Qt::DropAction",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX],
        Sbk_Qt_TypeF(), "CopyAction", (long) Qt::DropAction::CopyAction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX],
        Sbk_Qt_TypeF(), "MoveAction", (long) Qt::DropAction::MoveAction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX],
        Sbk_Qt_TypeF(), "LinkAction", (long) Qt::DropAction::LinkAction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX],
        Sbk_Qt_TypeF(), "ActionMask", (long) Qt::DropAction::ActionMask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX],
        Sbk_Qt_TypeF(), "TargetMoveAction", (long) Qt::DropAction::TargetMoveAction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX],
        Sbk_Qt_TypeF(), "IgnoreAction", (long) Qt::DropAction::IgnoreAction))
        return;
    // Register converter for enum 'Qt::DropAction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX],
            Qt_DropAction_CppToPython_Qt_DropAction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_DropAction_PythonToCpp_Qt_DropAction,
            is_Qt_DropAction_PythonToCpp_Qt_DropAction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::DropAction");
        Shiboken::Conversions::registerConverterName(converter, "DropAction");
    }
    // Register converter for flag 'QFlags<Qt::DropAction>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX],
            QFlags_Qt_DropAction__CppToPython_QFlags_Qt_DropAction_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_DropAction_PythonToCpp_QFlags_Qt_DropAction_,
            is_Qt_DropAction_PythonToCpp_QFlags_Qt_DropAction__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_DropAction__PythonToCpp_QFlags_Qt_DropAction_,
            is_QFlags_Qt_DropAction__PythonToCpp_QFlags_Qt_DropAction__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_DropAction_,
            is_number_PythonToCpp_QFlags_Qt_DropAction__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::DropActions");
        Shiboken::Conversions::registerConverterName(converter, "DropActions");
    }
    // End of 'DropAction' enum/flags.

    // Initialization of enum 'CheckState'.
    SbkPySide2_QtCoreTypes[SBK_QT_CHECKSTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "CheckState",
        "2:PySide2.QtCore.Qt.CheckState",
        "Qt::CheckState");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_CHECKSTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSTATE_IDX],
        Sbk_Qt_TypeF(), "Unchecked", (long) Qt::CheckState::Unchecked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSTATE_IDX],
        Sbk_Qt_TypeF(), "PartiallyChecked", (long) Qt::CheckState::PartiallyChecked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSTATE_IDX],
        Sbk_Qt_TypeF(), "Checked", (long) Qt::CheckState::Checked))
        return;
    // Register converter for enum 'Qt::CheckState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSTATE_IDX],
            Qt_CheckState_CppToPython_Qt_CheckState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_CheckState_PythonToCpp_Qt_CheckState,
            is_Qt_CheckState_PythonToCpp_Qt_CheckState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::CheckState");
        Shiboken::Conversions::registerConverterName(converter, "CheckState");
    }
    // End of 'CheckState' enum.

    // Initialization of enum 'ItemDataRole'.
    SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ItemDataRole",
        "2:PySide2.QtCore.Qt.ItemDataRole",
        "Qt::ItemDataRole");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "DisplayRole", (long) Qt::ItemDataRole::DisplayRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "DecorationRole", (long) Qt::ItemDataRole::DecorationRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "EditRole", (long) Qt::ItemDataRole::EditRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "ToolTipRole", (long) Qt::ItemDataRole::ToolTipRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "StatusTipRole", (long) Qt::ItemDataRole::StatusTipRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "WhatsThisRole", (long) Qt::ItemDataRole::WhatsThisRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "FontRole", (long) Qt::ItemDataRole::FontRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "TextAlignmentRole", (long) Qt::ItemDataRole::TextAlignmentRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "BackgroundRole", (long) Qt::ItemDataRole::BackgroundRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "ForegroundRole", (long) Qt::ItemDataRole::ForegroundRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "BackgroundColorRole", (long) Qt::ItemDataRole::BackgroundColorRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "TextColorRole", (long) Qt::ItemDataRole::TextColorRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "CheckStateRole", (long) Qt::ItemDataRole::CheckStateRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "AccessibleTextRole", (long) Qt::ItemDataRole::AccessibleTextRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "AccessibleDescriptionRole", (long) Qt::ItemDataRole::AccessibleDescriptionRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "SizeHintRole", (long) Qt::ItemDataRole::SizeHintRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "InitialSortOrderRole", (long) Qt::ItemDataRole::InitialSortOrderRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "DisplayPropertyRole", (long) Qt::ItemDataRole::DisplayPropertyRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "DecorationPropertyRole", (long) Qt::ItemDataRole::DecorationPropertyRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "ToolTipPropertyRole", (long) Qt::ItemDataRole::ToolTipPropertyRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "StatusTipPropertyRole", (long) Qt::ItemDataRole::StatusTipPropertyRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "WhatsThisPropertyRole", (long) Qt::ItemDataRole::WhatsThisPropertyRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
        Sbk_Qt_TypeF(), "UserRole", (long) Qt::ItemDataRole::UserRole))
        return;
    // Register converter for enum 'Qt::ItemDataRole'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX],
            Qt_ItemDataRole_CppToPython_Qt_ItemDataRole);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ItemDataRole_PythonToCpp_Qt_ItemDataRole,
            is_Qt_ItemDataRole_PythonToCpp_Qt_ItemDataRole_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ItemDataRole");
        Shiboken::Conversions::registerConverterName(converter, "ItemDataRole");
    }
    // End of 'ItemDataRole' enum.

    // Initialization of enum 'ItemFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.ItemFlags", SbkPySide2_QtCore_Qt_ItemFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ItemFlag",
        "2:PySide2.QtCore.Qt.ItemFlag",
        "Qt::ItemFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
        Sbk_Qt_TypeF(), "NoItemFlags", (long) Qt::ItemFlag::NoItemFlags))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
        Sbk_Qt_TypeF(), "ItemIsSelectable", (long) Qt::ItemFlag::ItemIsSelectable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
        Sbk_Qt_TypeF(), "ItemIsEditable", (long) Qt::ItemFlag::ItemIsEditable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
        Sbk_Qt_TypeF(), "ItemIsDragEnabled", (long) Qt::ItemFlag::ItemIsDragEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
        Sbk_Qt_TypeF(), "ItemIsDropEnabled", (long) Qt::ItemFlag::ItemIsDropEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
        Sbk_Qt_TypeF(), "ItemIsUserCheckable", (long) Qt::ItemFlag::ItemIsUserCheckable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
        Sbk_Qt_TypeF(), "ItemIsEnabled", (long) Qt::ItemFlag::ItemIsEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
        Sbk_Qt_TypeF(), "ItemIsAutoTristate", (long) Qt::ItemFlag::ItemIsAutoTristate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
        Sbk_Qt_TypeF(), "ItemIsTristate", (long) Qt::ItemFlag::ItemIsTristate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
        Sbk_Qt_TypeF(), "ItemNeverHasChildren", (long) Qt::ItemFlag::ItemNeverHasChildren))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
        Sbk_Qt_TypeF(), "ItemIsUserTristate", (long) Qt::ItemFlag::ItemIsUserTristate))
        return;
    // Register converter for enum 'Qt::ItemFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX],
            Qt_ItemFlag_CppToPython_Qt_ItemFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ItemFlag_PythonToCpp_Qt_ItemFlag,
            is_Qt_ItemFlag_PythonToCpp_Qt_ItemFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_ITEMFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ItemFlag");
        Shiboken::Conversions::registerConverterName(converter, "ItemFlag");
    }
    // Register converter for flag 'QFlags<Qt::ItemFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX],
            QFlags_Qt_ItemFlag__CppToPython_QFlags_Qt_ItemFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ItemFlag_PythonToCpp_QFlags_Qt_ItemFlag_,
            is_Qt_ItemFlag_PythonToCpp_QFlags_Qt_ItemFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_ItemFlag__PythonToCpp_QFlags_Qt_ItemFlag_,
            is_QFlags_Qt_ItemFlag__PythonToCpp_QFlags_Qt_ItemFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_ItemFlag_,
            is_number_PythonToCpp_QFlags_Qt_ItemFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ItemFlags");
        Shiboken::Conversions::registerConverterName(converter, "ItemFlags");
    }
    // End of 'ItemFlag' enum/flags.

    // Initialization of enum 'MatchFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.MatchFlags", SbkPySide2_QtCore_Qt_MatchFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "MatchFlag",
        "2:PySide2.QtCore.Qt.MatchFlag",
        "Qt::MatchFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
        Sbk_Qt_TypeF(), "MatchExactly", (long) Qt::MatchFlag::MatchExactly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
        Sbk_Qt_TypeF(), "MatchContains", (long) Qt::MatchFlag::MatchContains))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
        Sbk_Qt_TypeF(), "MatchStartsWith", (long) Qt::MatchFlag::MatchStartsWith))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
        Sbk_Qt_TypeF(), "MatchEndsWith", (long) Qt::MatchFlag::MatchEndsWith))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
        Sbk_Qt_TypeF(), "MatchRegExp", (long) Qt::MatchFlag::MatchRegExp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
        Sbk_Qt_TypeF(), "MatchWildcard", (long) Qt::MatchFlag::MatchWildcard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
        Sbk_Qt_TypeF(), "MatchFixedString", (long) Qt::MatchFlag::MatchFixedString))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
        Sbk_Qt_TypeF(), "MatchRegularExpression", (long) Qt::MatchFlag::MatchRegularExpression))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
        Sbk_Qt_TypeF(), "MatchCaseSensitive", (long) Qt::MatchFlag::MatchCaseSensitive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
        Sbk_Qt_TypeF(), "MatchWrap", (long) Qt::MatchFlag::MatchWrap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
        Sbk_Qt_TypeF(), "MatchRecursive", (long) Qt::MatchFlag::MatchRecursive))
        return;
    // Register converter for enum 'Qt::MatchFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX],
            Qt_MatchFlag_CppToPython_Qt_MatchFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_MatchFlag_PythonToCpp_Qt_MatchFlag,
            is_Qt_MatchFlag_PythonToCpp_Qt_MatchFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_MATCHFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::MatchFlag");
        Shiboken::Conversions::registerConverterName(converter, "MatchFlag");
    }
    // Register converter for flag 'QFlags<Qt::MatchFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX],
            QFlags_Qt_MatchFlag__CppToPython_QFlags_Qt_MatchFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_MatchFlag_PythonToCpp_QFlags_Qt_MatchFlag_,
            is_Qt_MatchFlag_PythonToCpp_QFlags_Qt_MatchFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_MatchFlag__PythonToCpp_QFlags_Qt_MatchFlag_,
            is_QFlags_Qt_MatchFlag__PythonToCpp_QFlags_Qt_MatchFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_MatchFlag_,
            is_number_PythonToCpp_QFlags_Qt_MatchFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::MatchFlags");
        Shiboken::Conversions::registerConverterName(converter, "MatchFlags");
    }
    // End of 'MatchFlag' enum/flags.

    // Initialization of enum 'WindowModality'.
    SbkPySide2_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "WindowModality",
        "2:PySide2.QtCore.Qt.WindowModality",
        "Qt::WindowModality");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX],
        Sbk_Qt_TypeF(), "NonModal", (long) Qt::WindowModality::NonModal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX],
        Sbk_Qt_TypeF(), "WindowModal", (long) Qt::WindowModality::WindowModal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX],
        Sbk_Qt_TypeF(), "ApplicationModal", (long) Qt::WindowModality::ApplicationModal))
        return;
    // Register converter for enum 'Qt::WindowModality'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX],
            Qt_WindowModality_CppToPython_Qt_WindowModality);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_WindowModality_PythonToCpp_Qt_WindowModality,
            is_Qt_WindowModality_PythonToCpp_Qt_WindowModality_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::WindowModality");
        Shiboken::Conversions::registerConverterName(converter, "WindowModality");
    }
    // End of 'WindowModality' enum.

    // Initialization of enum 'TextInteractionFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.TextInteractionFlags", SbkPySide2_QtCore_Qt_TextInteractionFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "TextInteractionFlag",
        "2:PySide2.QtCore.Qt.TextInteractionFlag",
        "Qt::TextInteractionFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX],
        Sbk_Qt_TypeF(), "NoTextInteraction", (long) Qt::TextInteractionFlag::NoTextInteraction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX],
        Sbk_Qt_TypeF(), "TextSelectableByMouse", (long) Qt::TextInteractionFlag::TextSelectableByMouse))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX],
        Sbk_Qt_TypeF(), "TextSelectableByKeyboard", (long) Qt::TextInteractionFlag::TextSelectableByKeyboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX],
        Sbk_Qt_TypeF(), "LinksAccessibleByMouse", (long) Qt::TextInteractionFlag::LinksAccessibleByMouse))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX],
        Sbk_Qt_TypeF(), "LinksAccessibleByKeyboard", (long) Qt::TextInteractionFlag::LinksAccessibleByKeyboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX],
        Sbk_Qt_TypeF(), "TextEditable", (long) Qt::TextInteractionFlag::TextEditable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX],
        Sbk_Qt_TypeF(), "TextEditorInteraction", (long) Qt::TextInteractionFlag::TextEditorInteraction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX],
        Sbk_Qt_TypeF(), "TextBrowserInteraction", (long) Qt::TextInteractionFlag::TextBrowserInteraction))
        return;
    // Register converter for enum 'Qt::TextInteractionFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX],
            Qt_TextInteractionFlag_CppToPython_Qt_TextInteractionFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TextInteractionFlag_PythonToCpp_Qt_TextInteractionFlag,
            is_Qt_TextInteractionFlag_PythonToCpp_Qt_TextInteractionFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TextInteractionFlag");
        Shiboken::Conversions::registerConverterName(converter, "TextInteractionFlag");
    }
    // Register converter for flag 'QFlags<Qt::TextInteractionFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX],
            QFlags_Qt_TextInteractionFlag__CppToPython_QFlags_Qt_TextInteractionFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TextInteractionFlag_PythonToCpp_QFlags_Qt_TextInteractionFlag_,
            is_Qt_TextInteractionFlag_PythonToCpp_QFlags_Qt_TextInteractionFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_TextInteractionFlag__PythonToCpp_QFlags_Qt_TextInteractionFlag_,
            is_QFlags_Qt_TextInteractionFlag__PythonToCpp_QFlags_Qt_TextInteractionFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_TextInteractionFlag_,
            is_number_PythonToCpp_QFlags_Qt_TextInteractionFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TextInteractionFlags");
        Shiboken::Conversions::registerConverterName(converter, "TextInteractionFlags");
    }
    // End of 'TextInteractionFlag' enum/flags.

    // Initialization of enum 'EventPriority'.
    SbkPySide2_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "EventPriority",
        "2:PySide2.QtCore.Qt.EventPriority",
        "Qt::EventPriority");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX],
        Sbk_Qt_TypeF(), "HighEventPriority", (long) Qt::EventPriority::HighEventPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX],
        Sbk_Qt_TypeF(), "NormalEventPriority", (long) Qt::EventPriority::NormalEventPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX],
        Sbk_Qt_TypeF(), "LowEventPriority", (long) Qt::EventPriority::LowEventPriority))
        return;
    // Register converter for enum 'Qt::EventPriority'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX],
            Qt_EventPriority_CppToPython_Qt_EventPriority);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_EventPriority_PythonToCpp_Qt_EventPriority,
            is_Qt_EventPriority_PythonToCpp_Qt_EventPriority_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::EventPriority");
        Shiboken::Conversions::registerConverterName(converter, "EventPriority");
    }
    // End of 'EventPriority' enum.

    // Initialization of enum 'SizeHint'.
    SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "SizeHint",
        "2:PySide2.QtCore.Qt.SizeHint",
        "Qt::SizeHint");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX],
        Sbk_Qt_TypeF(), "MinimumSize", (long) Qt::SizeHint::MinimumSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX],
        Sbk_Qt_TypeF(), "PreferredSize", (long) Qt::SizeHint::PreferredSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX],
        Sbk_Qt_TypeF(), "MaximumSize", (long) Qt::SizeHint::MaximumSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX],
        Sbk_Qt_TypeF(), "MinimumDescent", (long) Qt::SizeHint::MinimumDescent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX],
        Sbk_Qt_TypeF(), "NSizeHints", (long) Qt::SizeHint::NSizeHints))
        return;
    // Register converter for enum 'Qt::SizeHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX],
            Qt_SizeHint_CppToPython_Qt_SizeHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_SizeHint_PythonToCpp_Qt_SizeHint,
            is_Qt_SizeHint_PythonToCpp_Qt_SizeHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::SizeHint");
        Shiboken::Conversions::registerConverterName(converter, "SizeHint");
    }
    // End of 'SizeHint' enum.

    // Initialization of enum 'WindowFrameSection'.
    SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "WindowFrameSection",
        "2:PySide2.QtCore.Qt.WindowFrameSection",
        "Qt::WindowFrameSection");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX],
        Sbk_Qt_TypeF(), "NoSection", (long) Qt::WindowFrameSection::NoSection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX],
        Sbk_Qt_TypeF(), "LeftSection", (long) Qt::WindowFrameSection::LeftSection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX],
        Sbk_Qt_TypeF(), "TopLeftSection", (long) Qt::WindowFrameSection::TopLeftSection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX],
        Sbk_Qt_TypeF(), "TopSection", (long) Qt::WindowFrameSection::TopSection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX],
        Sbk_Qt_TypeF(), "TopRightSection", (long) Qt::WindowFrameSection::TopRightSection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX],
        Sbk_Qt_TypeF(), "RightSection", (long) Qt::WindowFrameSection::RightSection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX],
        Sbk_Qt_TypeF(), "BottomRightSection", (long) Qt::WindowFrameSection::BottomRightSection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX],
        Sbk_Qt_TypeF(), "BottomSection", (long) Qt::WindowFrameSection::BottomSection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX],
        Sbk_Qt_TypeF(), "BottomLeftSection", (long) Qt::WindowFrameSection::BottomLeftSection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX],
        Sbk_Qt_TypeF(), "TitleBarArea", (long) Qt::WindowFrameSection::TitleBarArea))
        return;
    // Register converter for enum 'Qt::WindowFrameSection'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX],
            Qt_WindowFrameSection_CppToPython_Qt_WindowFrameSection);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_WindowFrameSection_PythonToCpp_Qt_WindowFrameSection,
            is_Qt_WindowFrameSection_PythonToCpp_Qt_WindowFrameSection_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::WindowFrameSection");
        Shiboken::Conversions::registerConverterName(converter, "WindowFrameSection");
    }
    // End of 'WindowFrameSection' enum.

    // Initialization of enum 'CoordinateSystem'.
    SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "CoordinateSystem",
        "2:PySide2.QtCore.Qt.CoordinateSystem",
        "Qt::CoordinateSystem");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX],
        Sbk_Qt_TypeF(), "DeviceCoordinates", (long) Qt::CoordinateSystem::DeviceCoordinates))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX],
        Sbk_Qt_TypeF(), "LogicalCoordinates", (long) Qt::CoordinateSystem::LogicalCoordinates))
        return;
    // Register converter for enum 'Qt::CoordinateSystem'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX],
            Qt_CoordinateSystem_CppToPython_Qt_CoordinateSystem);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_CoordinateSystem_PythonToCpp_Qt_CoordinateSystem,
            is_Qt_CoordinateSystem_PythonToCpp_Qt_CoordinateSystem_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::CoordinateSystem");
        Shiboken::Conversions::registerConverterName(converter, "CoordinateSystem");
    }
    // End of 'CoordinateSystem' enum.

    // Initialization of enum 'TouchPointState'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.TouchPointStates", SbkPySide2_QtCore_Qt_TouchPointState_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "TouchPointState",
        "2:PySide2.QtCore.Qt.TouchPointState",
        "Qt::TouchPointState",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX],
        Sbk_Qt_TypeF(), "TouchPointPressed", (long) Qt::TouchPointState::TouchPointPressed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX],
        Sbk_Qt_TypeF(), "TouchPointMoved", (long) Qt::TouchPointState::TouchPointMoved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX],
        Sbk_Qt_TypeF(), "TouchPointStationary", (long) Qt::TouchPointState::TouchPointStationary))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX],
        Sbk_Qt_TypeF(), "TouchPointReleased", (long) Qt::TouchPointState::TouchPointReleased))
        return;
    // Register converter for enum 'Qt::TouchPointState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX],
            Qt_TouchPointState_CppToPython_Qt_TouchPointState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TouchPointState_PythonToCpp_Qt_TouchPointState,
            is_Qt_TouchPointState_PythonToCpp_Qt_TouchPointState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TouchPointState");
        Shiboken::Conversions::registerConverterName(converter, "TouchPointState");
    }
    // Register converter for flag 'QFlags<Qt::TouchPointState>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX],
            QFlags_Qt_TouchPointState__CppToPython_QFlags_Qt_TouchPointState_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TouchPointState_PythonToCpp_QFlags_Qt_TouchPointState_,
            is_Qt_TouchPointState_PythonToCpp_QFlags_Qt_TouchPointState__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_TouchPointState__PythonToCpp_QFlags_Qt_TouchPointState_,
            is_QFlags_Qt_TouchPointState__PythonToCpp_QFlags_Qt_TouchPointState__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_TouchPointState_,
            is_number_PythonToCpp_QFlags_Qt_TouchPointState__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TouchPointStates");
        Shiboken::Conversions::registerConverterName(converter, "TouchPointStates");
    }
    // End of 'TouchPointState' enum/flags.

    // Initialization of enum 'GestureState'.
    SbkPySide2_QtCoreTypes[SBK_QT_GESTURESTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "GestureState",
        "2:PySide2.QtCore.Qt.GestureState",
        "Qt::GestureState");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_GESTURESTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURESTATE_IDX],
        Sbk_Qt_TypeF(), "NoGesture", (long) Qt::GestureState::NoGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURESTATE_IDX],
        Sbk_Qt_TypeF(), "GestureStarted", (long) Qt::GestureState::GestureStarted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURESTATE_IDX],
        Sbk_Qt_TypeF(), "GestureUpdated", (long) Qt::GestureState::GestureUpdated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURESTATE_IDX],
        Sbk_Qt_TypeF(), "GestureFinished", (long) Qt::GestureState::GestureFinished))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURESTATE_IDX],
        Sbk_Qt_TypeF(), "GestureCanceled", (long) Qt::GestureState::GestureCanceled))
        return;
    // Register converter for enum 'Qt::GestureState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_GESTURESTATE_IDX],
            Qt_GestureState_CppToPython_Qt_GestureState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_GestureState_PythonToCpp_Qt_GestureState,
            is_Qt_GestureState_PythonToCpp_Qt_GestureState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_GESTURESTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::GestureState");
        Shiboken::Conversions::registerConverterName(converter, "GestureState");
    }
    // End of 'GestureState' enum.

    // Initialization of enum 'GestureType'.
    SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "GestureType",
        "2:PySide2.QtCore.Qt.GestureType",
        "Qt::GestureType");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "TapGesture", (long) Qt::GestureType::TapGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "TapAndHoldGesture", (long) Qt::GestureType::TapAndHoldGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "PanGesture", (long) Qt::GestureType::PanGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "PinchGesture", (long) Qt::GestureType::PinchGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "SwipeGesture", (long) Qt::GestureType::SwipeGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "CustomGesture", (long) Qt::GestureType::CustomGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "LastGestureType", (long) Qt::GestureType::LastGestureType))
        return;
    // Register converter for enum 'Qt::GestureType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX],
            Qt_GestureType_CppToPython_Qt_GestureType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_GestureType_PythonToCpp_Qt_GestureType,
            is_Qt_GestureType_PythonToCpp_Qt_GestureType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::GestureType");
        Shiboken::Conversions::registerConverterName(converter, "GestureType");
    }
    // End of 'GestureType' enum.

    // Initialization of enum 'GestureFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.GestureFlags", SbkPySide2_QtCore_Qt_GestureFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "GestureFlag",
        "2:PySide2.QtCore.Qt.GestureFlag",
        "Qt::GestureFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX],
        Sbk_Qt_TypeF(), "DontStartGestureOnChildren", (long) Qt::GestureFlag::DontStartGestureOnChildren))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX],
        Sbk_Qt_TypeF(), "ReceivePartialGestures", (long) Qt::GestureFlag::ReceivePartialGestures))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX],
        Sbk_Qt_TypeF(), "IgnoredGesturesPropagateToParent", (long) Qt::GestureFlag::IgnoredGesturesPropagateToParent))
        return;
    // Register converter for enum 'Qt::GestureFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX],
            Qt_GestureFlag_CppToPython_Qt_GestureFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_GestureFlag_PythonToCpp_Qt_GestureFlag,
            is_Qt_GestureFlag_PythonToCpp_Qt_GestureFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::GestureFlag");
        Shiboken::Conversions::registerConverterName(converter, "GestureFlag");
    }
    // Register converter for flag 'QFlags<Qt::GestureFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX],
            QFlags_Qt_GestureFlag__CppToPython_QFlags_Qt_GestureFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_GestureFlag_PythonToCpp_QFlags_Qt_GestureFlag_,
            is_Qt_GestureFlag_PythonToCpp_QFlags_Qt_GestureFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_GestureFlag__PythonToCpp_QFlags_Qt_GestureFlag_,
            is_QFlags_Qt_GestureFlag__PythonToCpp_QFlags_Qt_GestureFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_GestureFlag_,
            is_number_PythonToCpp_QFlags_Qt_GestureFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::GestureFlags");
        Shiboken::Conversions::registerConverterName(converter, "GestureFlags");
    }
    // End of 'GestureFlag' enum/flags.

    // Initialization of enum 'NativeGestureType'.
    SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "NativeGestureType",
        "2:PySide2.QtCore.Qt.NativeGestureType",
        "Qt::NativeGestureType");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "BeginNativeGesture", (long) Qt::NativeGestureType::BeginNativeGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "EndNativeGesture", (long) Qt::NativeGestureType::EndNativeGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "PanNativeGesture", (long) Qt::NativeGestureType::PanNativeGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "ZoomNativeGesture", (long) Qt::NativeGestureType::ZoomNativeGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "SmartZoomNativeGesture", (long) Qt::NativeGestureType::SmartZoomNativeGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "RotateNativeGesture", (long) Qt::NativeGestureType::RotateNativeGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX],
        Sbk_Qt_TypeF(), "SwipeNativeGesture", (long) Qt::NativeGestureType::SwipeNativeGesture))
        return;
    // Register converter for enum 'Qt::NativeGestureType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX],
            Qt_NativeGestureType_CppToPython_Qt_NativeGestureType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_NativeGestureType_PythonToCpp_Qt_NativeGestureType,
            is_Qt_NativeGestureType_PythonToCpp_Qt_NativeGestureType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_NATIVEGESTURETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::NativeGestureType");
        Shiboken::Conversions::registerConverterName(converter, "NativeGestureType");
    }
    // End of 'NativeGestureType' enum.

    // Initialization of enum 'NavigationMode'.
    SbkPySide2_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "NavigationMode",
        "2:PySide2.QtCore.Qt.NavigationMode",
        "Qt::NavigationMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX],
        Sbk_Qt_TypeF(), "NavigationModeNone", (long) Qt::NavigationMode::NavigationModeNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX],
        Sbk_Qt_TypeF(), "NavigationModeKeypadTabOrder", (long) Qt::NavigationMode::NavigationModeKeypadTabOrder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX],
        Sbk_Qt_TypeF(), "NavigationModeKeypadDirectional", (long) Qt::NavigationMode::NavigationModeKeypadDirectional))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX],
        Sbk_Qt_TypeF(), "NavigationModeCursorAuto", (long) Qt::NavigationMode::NavigationModeCursorAuto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX],
        Sbk_Qt_TypeF(), "NavigationModeCursorForceVisible", (long) Qt::NavigationMode::NavigationModeCursorForceVisible))
        return;
    // Register converter for enum 'Qt::NavigationMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX],
            Qt_NavigationMode_CppToPython_Qt_NavigationMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_NavigationMode_PythonToCpp_Qt_NavigationMode,
            is_Qt_NavigationMode_PythonToCpp_Qt_NavigationMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::NavigationMode");
        Shiboken::Conversions::registerConverterName(converter, "NavigationMode");
    }
    // End of 'NavigationMode' enum.

    // Initialization of enum 'CursorMoveStyle'.
    SbkPySide2_QtCoreTypes[SBK_QT_CURSORMOVESTYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "CursorMoveStyle",
        "2:PySide2.QtCore.Qt.CursorMoveStyle",
        "Qt::CursorMoveStyle");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_CURSORMOVESTYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORMOVESTYLE_IDX],
        Sbk_Qt_TypeF(), "LogicalMoveStyle", (long) Qt::CursorMoveStyle::LogicalMoveStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CURSORMOVESTYLE_IDX],
        Sbk_Qt_TypeF(), "VisualMoveStyle", (long) Qt::CursorMoveStyle::VisualMoveStyle))
        return;
    // Register converter for enum 'Qt::CursorMoveStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_CURSORMOVESTYLE_IDX],
            Qt_CursorMoveStyle_CppToPython_Qt_CursorMoveStyle);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_CursorMoveStyle_PythonToCpp_Qt_CursorMoveStyle,
            is_Qt_CursorMoveStyle_PythonToCpp_Qt_CursorMoveStyle_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_CURSORMOVESTYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::CursorMoveStyle");
        Shiboken::Conversions::registerConverterName(converter, "CursorMoveStyle");
    }
    // End of 'CursorMoveStyle' enum.

    // Initialization of enum 'TimerType'.
    SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "TimerType",
        "2:PySide2.QtCore.Qt.TimerType",
        "Qt::TimerType");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX],
        Sbk_Qt_TypeF(), "PreciseTimer", (long) Qt::TimerType::PreciseTimer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX],
        Sbk_Qt_TypeF(), "CoarseTimer", (long) Qt::TimerType::CoarseTimer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX],
        Sbk_Qt_TypeF(), "VeryCoarseTimer", (long) Qt::TimerType::VeryCoarseTimer))
        return;
    // Register converter for enum 'Qt::TimerType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX],
            Qt_TimerType_CppToPython_Qt_TimerType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_TimerType_PythonToCpp_Qt_TimerType,
            is_Qt_TimerType_PythonToCpp_Qt_TimerType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::TimerType");
        Shiboken::Conversions::registerConverterName(converter, "TimerType");
    }
    // End of 'TimerType' enum.

    // Initialization of enum 'ScrollPhase'.
    SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ScrollPhase",
        "2:PySide2.QtCore.Qt.ScrollPhase",
        "Qt::ScrollPhase");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX],
        Sbk_Qt_TypeF(), "NoScrollPhase", (long) Qt::ScrollPhase::NoScrollPhase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX],
        Sbk_Qt_TypeF(), "ScrollBegin", (long) Qt::ScrollPhase::ScrollBegin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX],
        Sbk_Qt_TypeF(), "ScrollUpdate", (long) Qt::ScrollPhase::ScrollUpdate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX],
        Sbk_Qt_TypeF(), "ScrollEnd", (long) Qt::ScrollPhase::ScrollEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX],
        Sbk_Qt_TypeF(), "ScrollMomentum", (long) Qt::ScrollPhase::ScrollMomentum))
        return;
    // Register converter for enum 'Qt::ScrollPhase'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX],
            Qt_ScrollPhase_CppToPython_Qt_ScrollPhase);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ScrollPhase_PythonToCpp_Qt_ScrollPhase,
            is_Qt_ScrollPhase_PythonToCpp_Qt_ScrollPhase_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ScrollPhase");
        Shiboken::Conversions::registerConverterName(converter, "ScrollPhase");
    }
    // End of 'ScrollPhase' enum.

    // Initialization of enum 'MouseEventSource'.
    SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "MouseEventSource",
        "2:PySide2.QtCore.Qt.MouseEventSource",
        "Qt::MouseEventSource");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX],
        Sbk_Qt_TypeF(), "MouseEventNotSynthesized", (long) Qt::MouseEventSource::MouseEventNotSynthesized))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX],
        Sbk_Qt_TypeF(), "MouseEventSynthesizedBySystem", (long) Qt::MouseEventSource::MouseEventSynthesizedBySystem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX],
        Sbk_Qt_TypeF(), "MouseEventSynthesizedByQt", (long) Qt::MouseEventSource::MouseEventSynthesizedByQt))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX],
        Sbk_Qt_TypeF(), "MouseEventSynthesizedByApplication", (long) Qt::MouseEventSource::MouseEventSynthesizedByApplication))
        return;
    // Register converter for enum 'Qt::MouseEventSource'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX],
            Qt_MouseEventSource_CppToPython_Qt_MouseEventSource);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_MouseEventSource_PythonToCpp_Qt_MouseEventSource,
            is_Qt_MouseEventSource_PythonToCpp_Qt_MouseEventSource_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::MouseEventSource");
        Shiboken::Conversions::registerConverterName(converter, "MouseEventSource");
    }
    // End of 'MouseEventSource' enum.

    // Initialization of enum 'MouseEventFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.Qt.MouseEventFlags", SbkPySide2_QtCore_Qt_MouseEventFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "MouseEventFlag",
        "2:PySide2.QtCore.Qt.MouseEventFlag",
        "Qt::MouseEventFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTFLAG_IDX],
        Sbk_Qt_TypeF(), "MouseEventCreatedDoubleClick", (long) Qt::MouseEventFlag::MouseEventCreatedDoubleClick))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTFLAG_IDX],
        Sbk_Qt_TypeF(), "MouseEventFlagMask", (long) Qt::MouseEventFlag::MouseEventFlagMask))
        return;
    // Register converter for enum 'Qt::MouseEventFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTFLAG_IDX],
            Qt_MouseEventFlag_CppToPython_Qt_MouseEventFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_MouseEventFlag_PythonToCpp_Qt_MouseEventFlag,
            is_Qt_MouseEventFlag_PythonToCpp_Qt_MouseEventFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::MouseEventFlag");
        Shiboken::Conversions::registerConverterName(converter, "MouseEventFlag");
    }
    // Register converter for flag 'QFlags<Qt::MouseEventFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX],
            QFlags_Qt_MouseEventFlag__CppToPython_QFlags_Qt_MouseEventFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_MouseEventFlag_PythonToCpp_QFlags_Qt_MouseEventFlag_,
            is_Qt_MouseEventFlag_PythonToCpp_QFlags_Qt_MouseEventFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt_MouseEventFlag__PythonToCpp_QFlags_Qt_MouseEventFlag_,
            is_QFlags_Qt_MouseEventFlag__PythonToCpp_QFlags_Qt_MouseEventFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt_MouseEventFlag_,
            is_number_PythonToCpp_QFlags_Qt_MouseEventFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEEVENTFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::MouseEventFlags");
        Shiboken::Conversions::registerConverterName(converter, "MouseEventFlags");
    }
    // End of 'MouseEventFlag' enum/flags.

    // Initialization of enum 'ChecksumType'.
    SbkPySide2_QtCoreTypes[SBK_QT_CHECKSUMTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "ChecksumType",
        "2:PySide2.QtCore.Qt.ChecksumType",
        "Qt::ChecksumType");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_CHECKSUMTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSUMTYPE_IDX],
        Sbk_Qt_TypeF(), "ChecksumIso3309", (long) Qt::ChecksumType::ChecksumIso3309))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSUMTYPE_IDX],
        Sbk_Qt_TypeF(), "ChecksumItuV41", (long) Qt::ChecksumType::ChecksumItuV41))
        return;
    // Register converter for enum 'Qt::ChecksumType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSUMTYPE_IDX],
            Qt_ChecksumType_CppToPython_Qt_ChecksumType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_ChecksumType_PythonToCpp_Qt_ChecksumType,
            is_Qt_ChecksumType_PythonToCpp_Qt_ChecksumType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSUMTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::ChecksumType");
        Shiboken::Conversions::registerConverterName(converter, "ChecksumType");
    }
    // End of 'ChecksumType' enum.

    // Initialization of enum 'HighDpiScaleFactorRoundingPolicy'.
    SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt_TypeF(),
        "HighDpiScaleFactorRoundingPolicy",
        "2:PySide2.QtCore.Qt.HighDpiScaleFactorRoundingPolicy",
        "Qt::HighDpiScaleFactorRoundingPolicy");
    if (!SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX],
        SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX], "Unset", (long) Qt::HighDpiScaleFactorRoundingPolicy::Unset))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX],
        SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX], "Round", (long) Qt::HighDpiScaleFactorRoundingPolicy::Round))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX],
        SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX], "Ceil", (long) Qt::HighDpiScaleFactorRoundingPolicy::Ceil))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX],
        SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX], "Floor", (long) Qt::HighDpiScaleFactorRoundingPolicy::Floor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX],
        SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX], "RoundPreferFloor", (long) Qt::HighDpiScaleFactorRoundingPolicy::RoundPreferFloor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX],
        SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX], "PassThrough", (long) Qt::HighDpiScaleFactorRoundingPolicy::PassThrough))
        return;
    // Register converter for enum 'Qt::HighDpiScaleFactorRoundingPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX],
            Qt_HighDpiScaleFactorRoundingPolicy_CppToPython_Qt_HighDpiScaleFactorRoundingPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt_HighDpiScaleFactorRoundingPolicy_PythonToCpp_Qt_HighDpiScaleFactorRoundingPolicy,
            is_Qt_HighDpiScaleFactorRoundingPolicy_PythonToCpp_Qt_HighDpiScaleFactorRoundingPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QT_HIGHDPISCALEFACTORROUNDINGPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt::HighDpiScaleFactorRoundingPolicy");
        Shiboken::Conversions::registerConverterName(converter, "HighDpiScaleFactorRoundingPolicy");
    }
    // End of 'HighDpiScaleFactorRoundingPolicy' enum.

    qRegisterMetaType< ::Qt::GlobalColor >("Qt::GlobalColor");
    qRegisterMetaType< ::Qt::KeyboardModifier >("Qt::KeyboardModifier");
    qRegisterMetaType< ::Qt::KeyboardModifiers >("Qt::KeyboardModifiers");
    qRegisterMetaType< ::Qt::Modifier >("Qt::Modifier");
    qRegisterMetaType< ::Qt::MouseButton >("Qt::MouseButton");
    qRegisterMetaType< ::Qt::MouseButtons >("Qt::MouseButtons");
    qRegisterMetaType< ::Qt::Orientation >("Qt::Orientation");
    qRegisterMetaType< ::Qt::Orientations >("Qt::Orientations");
    qRegisterMetaType< ::Qt::FocusPolicy >("Qt::FocusPolicy");
    qRegisterMetaType< ::Qt::TabFocusBehavior >("Qt::TabFocusBehavior");
    qRegisterMetaType< ::Qt::SortOrder >("Qt::SortOrder");
    qRegisterMetaType< ::Qt::SplitBehaviorFlags >("Qt::SplitBehaviorFlags");
    qRegisterMetaType< ::Qt::SplitBehavior >("Qt::SplitBehavior");
    qRegisterMetaType< ::Qt::TileRule >("Qt::TileRule");
    qRegisterMetaType< ::Qt::AlignmentFlag >("Qt::AlignmentFlag");
    qRegisterMetaType< ::Qt::Alignment >("Qt::Alignment");
    qRegisterMetaType< ::Qt::TextFlag >("Qt::TextFlag");
    qRegisterMetaType< ::Qt::TextElideMode >("Qt::TextElideMode");
    qRegisterMetaType< ::Qt::WhiteSpaceMode >("Qt::WhiteSpaceMode");
    qRegisterMetaType< ::Qt::HitTestAccuracy >("Qt::HitTestAccuracy");
    qRegisterMetaType< ::Qt::WindowType >("Qt::WindowType");
    qRegisterMetaType< ::Qt::WindowFlags >("Qt::WindowFlags");
    qRegisterMetaType< ::Qt::WindowState >("Qt::WindowState");
    qRegisterMetaType< ::Qt::WindowStates >("Qt::WindowStates");
    qRegisterMetaType< ::Qt::ApplicationState >("Qt::ApplicationState");
    qRegisterMetaType< ::Qt::ApplicationStates >("Qt::ApplicationStates");
    qRegisterMetaType< ::Qt::ScreenOrientation >("Qt::ScreenOrientation");
    qRegisterMetaType< ::Qt::ScreenOrientations >("Qt::ScreenOrientations");
    qRegisterMetaType< ::Qt::WidgetAttribute >("Qt::WidgetAttribute");
    qRegisterMetaType< ::Qt::ApplicationAttribute >("Qt::ApplicationAttribute");
    qRegisterMetaType< ::Qt::ImageConversionFlag >("Qt::ImageConversionFlag");
    qRegisterMetaType< ::Qt::ImageConversionFlags >("Qt::ImageConversionFlags");
    qRegisterMetaType< ::Qt::BGMode >("Qt::BGMode");
    qRegisterMetaType< ::Qt::Key >("Qt::Key");
    qRegisterMetaType< ::Qt::ArrowType >("Qt::ArrowType");
    qRegisterMetaType< ::Qt::PenStyle >("Qt::PenStyle");
    qRegisterMetaType< ::Qt::PenCapStyle >("Qt::PenCapStyle");
    qRegisterMetaType< ::Qt::PenJoinStyle >("Qt::PenJoinStyle");
    qRegisterMetaType< ::Qt::BrushStyle >("Qt::BrushStyle");
    qRegisterMetaType< ::Qt::SizeMode >("Qt::SizeMode");
    qRegisterMetaType< ::Qt::UIEffect >("Qt::UIEffect");
    qRegisterMetaType< ::Qt::CursorShape >("Qt::CursorShape");
    qRegisterMetaType< ::Qt::TextFormat >("Qt::TextFormat");
    qRegisterMetaType< ::Qt::AspectRatioMode >("Qt::AspectRatioMode");
    qRegisterMetaType< ::Qt::DockWidgetArea >("Qt::DockWidgetArea");
    qRegisterMetaType< ::Qt::DockWidgetAreas >("Qt::DockWidgetAreas");
    qRegisterMetaType< ::Qt::DockWidgetAreaSizes >("Qt::DockWidgetAreaSizes");
    qRegisterMetaType< ::Qt::ToolBarArea >("Qt::ToolBarArea");
    qRegisterMetaType< ::Qt::ToolBarAreas >("Qt::ToolBarAreas");
    qRegisterMetaType< ::Qt::ToolBarAreaSizes >("Qt::ToolBarAreaSizes");
    qRegisterMetaType< ::Qt::DateFormat >("Qt::DateFormat");
    qRegisterMetaType< ::Qt::TimeSpec >("Qt::TimeSpec");
    qRegisterMetaType< ::Qt::DayOfWeek >("Qt::DayOfWeek");
    qRegisterMetaType< ::Qt::ScrollBarPolicy >("Qt::ScrollBarPolicy");
    qRegisterMetaType< ::Qt::CaseSensitivity >("Qt::CaseSensitivity");
    qRegisterMetaType< ::Qt::Corner >("Qt::Corner");
    qRegisterMetaType< ::Qt::Edge >("Qt::Edge");
    qRegisterMetaType< ::Qt::Edges >("Qt::Edges");
    qRegisterMetaType< ::Qt::ConnectionType >("Qt::ConnectionType");
    qRegisterMetaType< ::Qt::ShortcutContext >("Qt::ShortcutContext");
    qRegisterMetaType< ::Qt::FillRule >("Qt::FillRule");
    qRegisterMetaType< ::Qt::MaskMode >("Qt::MaskMode");
    qRegisterMetaType< ::Qt::ClipOperation >("Qt::ClipOperation");
    qRegisterMetaType< ::Qt::ItemSelectionMode >("Qt::ItemSelectionMode");
    qRegisterMetaType< ::Qt::ItemSelectionOperation >("Qt::ItemSelectionOperation");
    qRegisterMetaType< ::Qt::TransformationMode >("Qt::TransformationMode");
    qRegisterMetaType< ::Qt::Axis >("Qt::Axis");
    qRegisterMetaType< ::Qt::FocusReason >("Qt::FocusReason");
    qRegisterMetaType< ::Qt::ContextMenuPolicy >("Qt::ContextMenuPolicy");
    qRegisterMetaType< ::Qt::InputMethodQuery >("Qt::InputMethodQuery");
    qRegisterMetaType< ::Qt::InputMethodQueries >("Qt::InputMethodQueries");
    qRegisterMetaType< ::Qt::InputMethodHint >("Qt::InputMethodHint");
    qRegisterMetaType< ::Qt::InputMethodHints >("Qt::InputMethodHints");
    qRegisterMetaType< ::Qt::EnterKeyType >("Qt::EnterKeyType");
    qRegisterMetaType< ::Qt::ToolButtonStyle >("Qt::ToolButtonStyle");
    qRegisterMetaType< ::Qt::LayoutDirection >("Qt::LayoutDirection");
    qRegisterMetaType< ::Qt::AnchorPoint >("Qt::AnchorPoint");
    qRegisterMetaType< ::Qt::FindChildOption >("Qt::FindChildOption");
    qRegisterMetaType< ::Qt::FindChildOptions >("Qt::FindChildOptions");
    qRegisterMetaType< ::Qt::DropAction >("Qt::DropAction");
    qRegisterMetaType< ::Qt::DropActions >("Qt::DropActions");
    qRegisterMetaType< ::Qt::CheckState >("Qt::CheckState");
    qRegisterMetaType< ::Qt::ItemDataRole >("Qt::ItemDataRole");
    qRegisterMetaType< ::Qt::ItemFlag >("Qt::ItemFlag");
    qRegisterMetaType< ::Qt::ItemFlags >("Qt::ItemFlags");
    qRegisterMetaType< ::Qt::MatchFlag >("Qt::MatchFlag");
    qRegisterMetaType< ::Qt::MatchFlags >("Qt::MatchFlags");
    qRegisterMetaType< ::Qt::WindowModality >("Qt::WindowModality");
    qRegisterMetaType< ::Qt::TextInteractionFlag >("Qt::TextInteractionFlag");
    qRegisterMetaType< ::Qt::TextInteractionFlags >("Qt::TextInteractionFlags");
    qRegisterMetaType< ::Qt::EventPriority >("Qt::EventPriority");
    qRegisterMetaType< ::Qt::SizeHint >("Qt::SizeHint");
    qRegisterMetaType< ::Qt::WindowFrameSection >("Qt::WindowFrameSection");
    qRegisterMetaType< ::Qt::CoordinateSystem >("Qt::CoordinateSystem");
    qRegisterMetaType< ::Qt::TouchPointState >("Qt::TouchPointState");
    qRegisterMetaType< ::Qt::TouchPointStates >("Qt::TouchPointStates");
    qRegisterMetaType< ::Qt::GestureState >("Qt::GestureState");
    qRegisterMetaType< ::Qt::GestureType >("Qt::GestureType");
    qRegisterMetaType< ::Qt::GestureFlag >("Qt::GestureFlag");
    qRegisterMetaType< ::Qt::GestureFlags >("Qt::GestureFlags");
    qRegisterMetaType< ::Qt::NativeGestureType >("Qt::NativeGestureType");
    qRegisterMetaType< ::Qt::NavigationMode >("Qt::NavigationMode");
    qRegisterMetaType< ::Qt::CursorMoveStyle >("Qt::CursorMoveStyle");
    qRegisterMetaType< ::Qt::TimerType >("Qt::TimerType");
    qRegisterMetaType< ::Qt::ScrollPhase >("Qt::ScrollPhase");
    qRegisterMetaType< ::Qt::MouseEventSource >("Qt::MouseEventSource");
    qRegisterMetaType< ::Qt::MouseEventFlag >("Qt::MouseEventFlag");
    qRegisterMetaType< ::Qt::MouseEventFlags >("Qt::MouseEventFlags");
    qRegisterMetaType< ::Qt::ChecksumType >("Qt::ChecksumType");
    qRegisterMetaType< ::Qt::HighDpiScaleFactorRoundingPolicy >("Qt::HighDpiScaleFactorRoundingPolicy");
}
