/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qsysinfo_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSysInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSysInfo >()))
        return -1;

    ::QSysInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QSysInfo()
            cptr = new ::QSysInfo();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSysInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QSysInfoFunc_bootUniqueId(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.bootUniqueId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bootUniqueId()
            QByteArray cppResult = ::QSysInfo::bootUniqueId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSysInfoFunc_buildAbi(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.buildAbi";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buildAbi()
            QString cppResult = ::QSysInfo::buildAbi();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSysInfoFunc_buildCpuArchitecture(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.buildCpuArchitecture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buildCpuArchitecture()
            QString cppResult = ::QSysInfo::buildCpuArchitecture();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSysInfoFunc_currentCpuArchitecture(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.currentCpuArchitecture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentCpuArchitecture()
            QString cppResult = ::QSysInfo::currentCpuArchitecture();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSysInfoFunc_kernelType(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.kernelType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // kernelType()
            QString cppResult = ::QSysInfo::kernelType();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSysInfoFunc_kernelVersion(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.kernelVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // kernelVersion()
            QString cppResult = ::QSysInfo::kernelVersion();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSysInfoFunc_machineHostName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.machineHostName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // machineHostName()
            QString cppResult = ::QSysInfo::machineHostName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSysInfoFunc_machineUniqueId(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.machineUniqueId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // machineUniqueId()
            QByteArray cppResult = ::QSysInfo::machineUniqueId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSysInfoFunc_prettyProductName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.prettyProductName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // prettyProductName()
            QString cppResult = ::QSysInfo::prettyProductName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSysInfoFunc_productType(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.productType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // productType()
            QString cppResult = ::QSysInfo::productType();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSysInfoFunc_productVersion(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSysInfo.productVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // productVersion()
            QString cppResult = ::QSysInfo::productVersion();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSysInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSysInfo_methods[] = {
    {"bootUniqueId", reinterpret_cast<PyCFunction>(Sbk_QSysInfoFunc_bootUniqueId), METH_NOARGS|METH_STATIC},
    {"buildAbi", reinterpret_cast<PyCFunction>(Sbk_QSysInfoFunc_buildAbi), METH_NOARGS|METH_STATIC},
    {"buildCpuArchitecture", reinterpret_cast<PyCFunction>(Sbk_QSysInfoFunc_buildCpuArchitecture), METH_NOARGS|METH_STATIC},
    {"currentCpuArchitecture", reinterpret_cast<PyCFunction>(Sbk_QSysInfoFunc_currentCpuArchitecture), METH_NOARGS|METH_STATIC},
    {"kernelType", reinterpret_cast<PyCFunction>(Sbk_QSysInfoFunc_kernelType), METH_NOARGS|METH_STATIC},
    {"kernelVersion", reinterpret_cast<PyCFunction>(Sbk_QSysInfoFunc_kernelVersion), METH_NOARGS|METH_STATIC},
    {"machineHostName", reinterpret_cast<PyCFunction>(Sbk_QSysInfoFunc_machineHostName), METH_NOARGS|METH_STATIC},
    {"machineUniqueId", reinterpret_cast<PyCFunction>(Sbk_QSysInfoFunc_machineUniqueId), METH_NOARGS|METH_STATIC},
    {"prettyProductName", reinterpret_cast<PyCFunction>(Sbk_QSysInfoFunc_prettyProductName), METH_NOARGS|METH_STATIC},
    {"productType", reinterpret_cast<PyCFunction>(Sbk_QSysInfoFunc_productType), METH_NOARGS|METH_STATIC},
    {"productVersion", reinterpret_cast<PyCFunction>(Sbk_QSysInfoFunc_productVersion), METH_NOARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QSysInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSysInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSysInfo_Type = nullptr;
static SbkObjectType *Sbk_QSysInfo_TypeF(void)
{
    return _Sbk_QSysInfo_Type;
}

static PyType_Slot Sbk_QSysInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSysInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSysInfo_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSysInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSysInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSysInfo_spec = {
    "2:PySide2.QtCore.QSysInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSysInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QSysInfo_Sizes_PythonToCpp_QSysInfo_Sizes(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSysInfo::Sizes *>(cppOut) =
        static_cast<::QSysInfo::Sizes>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSysInfo_Sizes_PythonToCpp_QSysInfo_Sizes_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSYSINFO_SIZES_IDX]))
        return QSysInfo_Sizes_PythonToCpp_QSysInfo_Sizes;
    return {};
}
static PyObject *QSysInfo_Sizes_CppToPython_QSysInfo_Sizes(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSysInfo::Sizes *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSYSINFO_SIZES_IDX], castCppIn);

}

static void QSysInfo_Endian_PythonToCpp_QSysInfo_Endian(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSysInfo::Endian *>(cppOut) =
        static_cast<::QSysInfo::Endian>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSysInfo_Endian_PythonToCpp_QSysInfo_Endian_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX]))
        return QSysInfo_Endian_PythonToCpp_QSysInfo_Endian;
    return {};
}
static PyObject *QSysInfo_Endian_CppToPython_QSysInfo_Endian(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSysInfo::Endian *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSysInfo_PythonToCpp_QSysInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSysInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSysInfo_PythonToCpp_QSysInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSysInfo_TypeF())))
        return QSysInfo_PythonToCpp_QSysInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSysInfo_PTR_CppToPython_QSysInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSysInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSysInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSysInfo_SignatureStrings[] = {
    "PySide2.QtCore.QSysInfo(self)",
    "PySide2.QtCore.QSysInfo.bootUniqueId()->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QSysInfo.buildAbi()->QString",
    "PySide2.QtCore.QSysInfo.buildCpuArchitecture()->QString",
    "PySide2.QtCore.QSysInfo.currentCpuArchitecture()->QString",
    "PySide2.QtCore.QSysInfo.kernelType()->QString",
    "PySide2.QtCore.QSysInfo.kernelVersion()->QString",
    "PySide2.QtCore.QSysInfo.machineHostName()->QString",
    "PySide2.QtCore.QSysInfo.machineUniqueId()->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QSysInfo.prettyProductName()->QString",
    "PySide2.QtCore.QSysInfo.productType()->QString",
    "PySide2.QtCore.QSysInfo.productVersion()->QString",
    nullptr}; // Sentinel

void init_QSysInfo(PyObject *module)
{
    _Sbk_QSysInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSysInfo",
        "QSysInfo*",
        &Sbk_QSysInfo_spec,
        &Shiboken::callCppDestructor< ::QSysInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSysInfo_Type);
    InitSignatureStrings(pyType, QSysInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSysInfo_Type), Sbk_QSysInfo_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QSYSINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSysInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSysInfo_TypeF(),
        QSysInfo_PythonToCpp_QSysInfo_PTR,
        is_QSysInfo_PythonToCpp_QSysInfo_PTR_Convertible,
        QSysInfo_PTR_CppToPython_QSysInfo);

    Shiboken::Conversions::registerConverterName(converter, "QSysInfo");
    Shiboken::Conversions::registerConverterName(converter, "QSysInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QSysInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSysInfo).name());


    // Initialization of enums.

    // Initialization of enum 'Sizes'.
    SbkPySide2_QtCoreTypes[SBK_QSYSINFO_SIZES_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSysInfo_TypeF(),
        "Sizes",
        "2:PySide2.QtCore.QSysInfo.Sizes",
        "QSysInfo::Sizes");
    if (!SbkPySide2_QtCoreTypes[SBK_QSYSINFO_SIZES_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSINFO_SIZES_IDX],
        Sbk_QSysInfo_TypeF(), "WordSize", (long) QSysInfo::Sizes::WordSize))
        return;
    // Register converter for enum 'QSysInfo::Sizes'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSYSINFO_SIZES_IDX],
            QSysInfo_Sizes_CppToPython_QSysInfo_Sizes);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSysInfo_Sizes_PythonToCpp_QSysInfo_Sizes,
            is_QSysInfo_Sizes_PythonToCpp_QSysInfo_Sizes_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSYSINFO_SIZES_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSysInfo::Sizes");
        Shiboken::Conversions::registerConverterName(converter, "Sizes");
    }
    // End of 'Sizes' enum.

    // Initialization of enum 'Endian'.
    SbkPySide2_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSysInfo_TypeF(),
        "Endian",
        "2:PySide2.QtCore.QSysInfo.Endian",
        "QSysInfo::Endian");
    if (!SbkPySide2_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX],
        Sbk_QSysInfo_TypeF(), "BigEndian", (long) QSysInfo::Endian::BigEndian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX],
        Sbk_QSysInfo_TypeF(), "LittleEndian", (long) QSysInfo::Endian::LittleEndian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX],
        Sbk_QSysInfo_TypeF(), "ByteOrder", (long) QSysInfo::Endian::ByteOrder))
        return;
    // Register converter for enum 'QSysInfo::Endian'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX],
            QSysInfo_Endian_CppToPython_QSysInfo_Endian);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSysInfo_Endian_PythonToCpp_QSysInfo_Endian,
            is_QSysInfo_Endian_PythonToCpp_QSysInfo_Endian_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSysInfo::Endian");
        Shiboken::Conversions::registerConverterName(converter, "Endian");
    }
    // End of 'Endian' enum.

    qRegisterMetaType< ::QSysInfo::Sizes >("QSysInfo::Sizes");
    qRegisterMetaType< ::QSysInfo::Endian >("QSysInfo::Endian");
}
