/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qstorageinfo_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qdir.h>
#include <qstorageinfo.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStorageInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStorageInfo >()))
        return -1;

    ::QStorageInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStorageInfo", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStorageInfo::QStorageInfo()
    // 1: QStorageInfo::QStorageInfo(QDir)
    // 2: QStorageInfo::QStorageInfo(QStorageInfo)
    // 3: QStorageInfo::QStorageInfo(QString)
    if (numArgs == 0) {
        overloadId = 0; // QStorageInfo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 3; // QStorageInfo(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QStorageInfo(QStorageInfo)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStorageInfo(QDir)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStorageInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStorageInfo()
        {

            if (!PyErr_Occurred()) {
                // QStorageInfo()
                cptr = new ::QStorageInfo();
            }
            break;
        }
        case 1: // QStorageInfo(const QDir & dir)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDir cppArg0_local;
            ::QDir *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QStorageInfo(QDir)
                cptr = new ::QStorageInfo(*cppArg0);
            }
            break;
        }
        case 2: // QStorageInfo(const QStorageInfo & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStorageInfo cppArg0_local;
            ::QStorageInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QStorageInfo(QStorageInfo)
                cptr = new ::QStorageInfo(*cppArg0);
            }
            break;
        }
        case 3: // QStorageInfo(const QString & path)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStorageInfo(QString)
                cptr = new ::QStorageInfo(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStorageInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStorageInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStorageInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QStorageInfoFunc_blockSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.blockSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blockSize()const
            int cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->blockSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_bytesAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.bytesAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesAvailable()const
            qint64 cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->bytesAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_bytesFree(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.bytesFree";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesFree()const
            qint64 cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->bytesFree();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_bytesTotal(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.bytesTotal";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesTotal()const
            qint64 cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->bytesTotal();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QByteArray cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_displayName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.displayName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // displayName()const
            QString cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->displayName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_fileSystemType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.fileSystemType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileSystemType()const
            QByteArray cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->fileSystemType();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_isReadOnly(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.isReadOnly";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReadOnly()const
            bool cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->isReadOnly();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_isReady(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.isReady";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReady()const
            bool cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->isReady();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_isRoot(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.isRoot";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRoot()const
            bool cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->isRoot();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_mountedVolumes(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.mountedVolumes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mountedVolumes()
            QList<QStorageInfo > cppResult = ::QStorageInfo::mountedVolumes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QSTORAGEINFO_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_refresh(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.refresh";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // refresh()
            cppSelf->refresh();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QStorageInfoFunc_root(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.root";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // root()
            QStorageInfo cppResult = ::QStorageInfo::root();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_rootPath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.rootPath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rootPath()const
            QString cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->rootPath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_setPath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.setPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStorageInfo::setPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStorageInfoFunc_setPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPath(QString)
            cppSelf->setPath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStorageInfoFunc_setPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStorageInfoFunc_subvolume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.subvolume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // subvolume()const
            QByteArray cppResult = const_cast<const ::QStorageInfo *>(cppSelf)->subvolume();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStorageInfoFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStorageInfo.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStorageInfo::swap(QStorageInfo&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QStorageInfo&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStorageInfoFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QStorageInfo cppArg0_local;
        ::QStorageInfo *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QStorageInfo&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStorageInfoFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStorageInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QStorageInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStorageInfo_methods[] = {
    {"blockSize", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_blockSize), METH_NOARGS},
    {"bytesAvailable", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_bytesAvailable), METH_NOARGS},
    {"bytesFree", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_bytesFree), METH_NOARGS},
    {"bytesTotal", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_bytesTotal), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_device), METH_NOARGS},
    {"displayName", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_displayName), METH_NOARGS},
    {"fileSystemType", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_fileSystemType), METH_NOARGS},
    {"isReadOnly", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_isReadOnly), METH_NOARGS},
    {"isReady", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_isReady), METH_NOARGS},
    {"isRoot", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_isRoot), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_isValid), METH_NOARGS},
    {"mountedVolumes", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_mountedVolumes), METH_NOARGS|METH_STATIC},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_name), METH_NOARGS},
    {"refresh", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_refresh), METH_NOARGS},
    {"root", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_root), METH_NOARGS|METH_STATIC},
    {"rootPath", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_rootPath), METH_NOARGS},
    {"setPath", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_setPath), METH_O},
    {"subvolume", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_subvolume), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QStorageInfoFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QStorageInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QStorageInfo_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), (pyArg)))) {
                // operator!=(const QStorageInfo & second)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QStorageInfo cppArg0_local;
                ::QStorageInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), (pyArg)))) {
                // operator==(const QStorageInfo & second)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QStorageInfo cppArg0_local;
                ::QStorageInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QStorageInfo_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QStorageInfo_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QStorageInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStorageInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QStorageInfo__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStorageInfo_Type = nullptr;
static SbkObjectType *Sbk_QStorageInfo_TypeF(void)
{
    return _Sbk_QStorageInfo_Type;
}

static PyType_Slot Sbk_QStorageInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QStorageInfo__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStorageInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStorageInfo_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QStorageInfo_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStorageInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStorageInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStorageInfo_spec = {
    "2:PySide2.QtCore.QStorageInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStorageInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStorageInfo_PythonToCpp_QStorageInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStorageInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStorageInfo_PythonToCpp_QStorageInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStorageInfo_TypeF())))
        return QStorageInfo_PythonToCpp_QStorageInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStorageInfo_PTR_CppToPython_QStorageInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStorageInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStorageInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QStorageInfo_COPY_CppToPython_QStorageInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QStorageInfo_TypeF(), new ::QStorageInfo(*reinterpret_cast<const ::QStorageInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QStorageInfo_PythonToCpp_QStorageInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStorageInfo *>(cppOut) = *reinterpret_cast< ::QStorageInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QStorageInfo_PythonToCpp_QStorageInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStorageInfo_TypeF())))
        return QStorageInfo_PythonToCpp_QStorageInfo_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStorageInfo_SignatureStrings[] = {
    "3:PySide2.QtCore.QStorageInfo(self)",
    "2:PySide2.QtCore.QStorageInfo(self,dir:PySide2.QtCore.QDir)",
    "1:PySide2.QtCore.QStorageInfo(self,other:PySide2.QtCore.QStorageInfo)",
    "0:PySide2.QtCore.QStorageInfo(self,path:QString)",
    "PySide2.QtCore.QStorageInfo.blockSize(self)->int",
    "PySide2.QtCore.QStorageInfo.bytesAvailable(self)->qint64",
    "PySide2.QtCore.QStorageInfo.bytesFree(self)->qint64",
    "PySide2.QtCore.QStorageInfo.bytesTotal(self)->qint64",
    "PySide2.QtCore.QStorageInfo.device(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QStorageInfo.displayName(self)->QString",
    "PySide2.QtCore.QStorageInfo.fileSystemType(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QStorageInfo.isReadOnly(self)->bool",
    "PySide2.QtCore.QStorageInfo.isReady(self)->bool",
    "PySide2.QtCore.QStorageInfo.isRoot(self)->bool",
    "PySide2.QtCore.QStorageInfo.isValid(self)->bool",
    "PySide2.QtCore.QStorageInfo.mountedVolumes()->QList[PySide2.QtCore.QStorageInfo]",
    "PySide2.QtCore.QStorageInfo.name(self)->QString",
    "PySide2.QtCore.QStorageInfo.refresh(self)",
    "PySide2.QtCore.QStorageInfo.root()->PySide2.QtCore.QStorageInfo",
    "PySide2.QtCore.QStorageInfo.rootPath(self)->QString",
    "PySide2.QtCore.QStorageInfo.setPath(self,path:QString)",
    "PySide2.QtCore.QStorageInfo.subvolume(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QStorageInfo.swap(self,other:PySide2.QtCore.QStorageInfo)",
    "PySide2.QtCore.QStorageInfo.__copy__()",
    nullptr}; // Sentinel

void init_QStorageInfo(PyObject *module)
{
    _Sbk_QStorageInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStorageInfo",
        "QStorageInfo",
        &Sbk_QStorageInfo_spec,
        &Shiboken::callCppDestructor< ::QStorageInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStorageInfo_Type);
    InitSignatureStrings(pyType, QStorageInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStorageInfo_Type), Sbk_QStorageInfo_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QSTORAGEINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStorageInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStorageInfo_TypeF(),
        QStorageInfo_PythonToCpp_QStorageInfo_PTR,
        is_QStorageInfo_PythonToCpp_QStorageInfo_PTR_Convertible,
        QStorageInfo_PTR_CppToPython_QStorageInfo,
        QStorageInfo_COPY_CppToPython_QStorageInfo);

    Shiboken::Conversions::registerConverterName(converter, "QStorageInfo");
    Shiboken::Conversions::registerConverterName(converter, "QStorageInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QStorageInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStorageInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QStorageInfo_PythonToCpp_QStorageInfo_COPY,
        is_QStorageInfo_PythonToCpp_QStorageInfo_COPY_Convertible);

    qRegisterMetaType< ::QStorageInfo >("QStorageInfo");
}
