/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qstatemachine_wrapper.h"

// inner classes
#include "qstatemachine_wrappedevent_wrapper.h"
#include "qstatemachine_signalevent_wrapper.h"

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QStateMachineWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QStateMachineWrapper::QStateMachineWrapper(::QObject * parent) : QStateMachine(parent)
{
    resetPyMethodCache();
    // ... middle
}

QStateMachineWrapper::QStateMachineWrapper(::QState::ChildMode childMode, ::QObject * parent) : QStateMachine(childMode, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QStateMachineWrapper::beginMicrostep(::QEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QStateMachine::beginMicrostep(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "beginMicrostep";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QStateMachine::beginMicrostep(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStateMachineWrapper::beginSelectTransitions(::QEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QStateMachine::beginSelectTransitions(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "beginSelectTransitions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QStateMachine::beginSelectTransitions(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStateMachineWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStateMachineWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStateMachineWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStateMachineWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStateMachineWrapper::endMicrostep(::QEvent * event)
{
    if (m_PyMethodCache[6]) {
        return this->::QStateMachine::endMicrostep(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "endMicrostep";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QStateMachine::endMicrostep(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStateMachineWrapper::endSelectTransitions(::QEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QStateMachine::endSelectTransitions(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "endSelectTransitions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QStateMachine::endSelectTransitions(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QStateMachineWrapper::event(::QEvent * e)
{
    if (m_PyMethodCache[8])
        return this->::QStateMachine::event(e);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QStateMachine::event(e);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), e)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStateMachine.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QStateMachineWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[9])
        return this->::QStateMachine::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QStateMachine::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStateMachine.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QStateMachineWrapper::onEntry(::QEvent * event)
{
    if (m_PyMethodCache[11]) {
        return this->::QStateMachine::onEntry(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "onEntry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QStateMachine::onEntry(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStateMachineWrapper::onExit(::QEvent * event)
{
    if (m_PyMethodCache[12]) {
        return this->::QStateMachine::onExit(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "onExit";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QStateMachine::onExit(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStateMachineWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[13]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QStateMachineWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QStateMachine::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QStateMachineWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QStateMachine::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QStateMachineWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QStateMachineWrapper *>(this));
        return QStateMachine::qt_metacast(_clname);
}

QStateMachineWrapper::~QStateMachineWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStateMachine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStateMachine >()))
        return -1;

    ::QStateMachineWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QStateMachine", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QStateMachine::QStateMachine(QObject*)
    // 1: QStateMachine::QStateMachine(QState::ChildMode,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QStateMachine(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QStateMachine(QState::ChildMode,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QStateMachine(QState::ChildMode,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QStateMachine(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachine_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStateMachine(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QStateMachine_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QStateMachine_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStateMachine(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QStateMachineWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QStateMachineWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QStateMachine(QState::ChildMode childMode, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QStateMachine_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QStateMachine_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QState::ChildMode cppArg0{QState::ExclusiveStates};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QStateMachine(QState::ChildMode,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QStateMachineWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QStateMachineWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStateMachine >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStateMachine_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QStateMachine_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QStateMachine_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QStateMachineFunc_addDefaultAnimation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.addDefaultAnimation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::addDefaultAnimation(QAbstractAnimation*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX]), (pyArg)))) {
        overloadId = 0; // addDefaultAnimation(QAbstractAnimation*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_addDefaultAnimation_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractAnimation *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addDefaultAnimation(QAbstractAnimation*)
            cppSelf->addDefaultAnimation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_addDefaultAnimation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_addState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.addState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::addState(QAbstractState*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), (pyArg)))) {
        overloadId = 0; // addState(QAbstractState*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_addState_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractState *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addState(QAbstractState*)
            cppSelf->addState(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_addState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_beginMicrostep(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.beginMicrostep";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::beginMicrostep(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // beginMicrostep(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_beginMicrostep_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // beginMicrostep(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QStateMachine::beginMicrostep(cppArg0)
                : cppSelf->beginMicrostep(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_beginMicrostep_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_beginSelectTransitions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.beginSelectTransitions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::beginSelectTransitions(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // beginSelectTransitions(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_beginSelectTransitions_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // beginSelectTransitions(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QStateMachine::beginSelectTransitions(cppArg0)
                : cppSelf->beginSelectTransitions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_beginSelectTransitions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_cancelDelayedEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.cancelDelayedEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::cancelDelayedEvent(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // cancelDelayedEvent(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_cancelDelayedEvent_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // cancelDelayedEvent(int)
            bool cppResult = cppSelf->cancelDelayedEvent(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStateMachineFunc_cancelDelayedEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_clearError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.clearError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearError()
            cppSelf->clearError();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QStateMachineFunc_configuration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.configuration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // configuration()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qstatemachine-configuration)]
            pyResult = PySet_New(0);
            for (auto *abs_state : cppSelf->configuration()) {
                    Shiboken::AutoDecRef obj(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), abs_state));
                    Shiboken::Object::setParent(self, obj);
                    PySet_Add(pyResult, obj);
            }
            // END of custom code block [file: ../glue/qtcore.cpp (qstatemachine-configuration)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateMachineFunc_defaultAnimations(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.defaultAnimations";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultAnimations()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qstatemachine-defaultanimations)]
            pyResult = PyList_New(0);
            for (auto *abs_anim : cppSelf->defaultAnimations()) {
                    Shiboken::AutoDecRef obj(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX]), abs_anim));
                    Shiboken::Object::setParent(self, obj);
                    PyList_Append(pyResult, obj);
            }
            // END of custom code block [file: ../glue/qtcore.cpp (qstatemachine-defaultanimations)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateMachineFunc_endMicrostep(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.endMicrostep";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::endMicrostep(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // endMicrostep(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_endMicrostep_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // endMicrostep(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QStateMachine::endMicrostep(cppArg0)
                : cppSelf->endMicrostep(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_endMicrostep_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_endSelectTransitions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.endSelectTransitions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::endSelectTransitions(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // endSelectTransitions(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_endSelectTransitions_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // endSelectTransitions(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QStateMachine::endSelectTransitions(cppArg0)
                : cppSelf->endSelectTransitions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_endSelectTransitions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QStateMachine::Error cppResult = const_cast<const ::QStateMachine *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateMachineFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QStateMachine *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateMachineFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QStateMachine::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStateMachineFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.eventFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_eventFilter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QStateMachine::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStateMachineFunc_eventFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_globalRestorePolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.globalRestorePolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalRestorePolicy()const
            QState::RestorePolicy cppResult = const_cast<const ::QStateMachine *>(cppSelf)->globalRestorePolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTATE_RESTOREPOLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateMachineFunc_isAnimated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.isAnimated";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAnimated()const
            bool cppResult = const_cast<const ::QStateMachine *>(cppSelf)->isAnimated();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateMachineFunc_isRunning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.isRunning";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRunning()const
            bool cppResult = const_cast<const ::QStateMachine *>(cppSelf)->isRunning();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStateMachineFunc_onEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.onEntry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractState::onEntry(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // onEntry(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_onEntry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // onEntry(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QStateMachine::onEntry(cppArg0)
                : cppSelf->onEntry(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_onEntry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_onExit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.onExit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractState::onExit(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // onExit(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_onExit_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // onExit(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QStateMachine::onExit(cppArg0)
                : cppSelf->onExit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_onExit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_postDelayedEvent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.postDelayedEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "postDelayedEvent", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QStateMachine::postDelayedEvent(QEvent*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // postDelayedEvent(QEvent*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_postDelayedEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // postDelayedEvent(QEvent*,int)
            int cppResult = cppSelf->postDelayedEvent(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStateMachineFunc_postDelayedEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_postEvent(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.postEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStateMachineFunc_postEvent_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStateMachineFunc_postEvent_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:postEvent", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QStateMachine::postEvent(QEvent*,QStateMachine::EventPriority)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // postEvent(QEvent*,QStateMachine::EventPriority)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // postEvent(QEvent*,QStateMachine::EventPriority)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_postEvent_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_priority = Shiboken::String::createStaticString("priority");
            if (PyDict_Contains(kwds, key_priority)) {
                value = PyDict_GetItem(kwds, key_priority);
                if (value && pyArgs[1]) {
                    errInfo = key_priority;
                    Py_INCREF(errInfo);
                    goto Sbk_QStateMachineFunc_postEvent_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QStateMachineFunc_postEvent_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_priority);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStateMachineFunc_postEvent_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QStateMachine::EventPriority cppArg1 = QStateMachine::EventPriority::NormalPriority;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // postEvent(QEvent*,QStateMachine::EventPriority)
            cppSelf->postEvent(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_postEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_removeDefaultAnimation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.removeDefaultAnimation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::removeDefaultAnimation(QAbstractAnimation*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX]), (pyArg)))) {
        overloadId = 0; // removeDefaultAnimation(QAbstractAnimation*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_removeDefaultAnimation_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractAnimation *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeDefaultAnimation(QAbstractAnimation*)
            cppSelf->removeDefaultAnimation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_removeDefaultAnimation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_removeState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.removeState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::removeState(QAbstractState*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]), (pyArg)))) {
        overloadId = 0; // removeState(QAbstractState*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_removeState_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractState *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeState(QAbstractState*)
            cppSelf->removeState(cppArg0);
            Shiboken::Object::setParent(Py_None, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_removeState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_setAnimated(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.setAnimated";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::setAnimated(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAnimated(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_setAnimated_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAnimated(bool)
            cppSelf->setAnimated(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_setAnimated_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_setGlobalRestorePolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.setGlobalRestorePolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::setGlobalRestorePolicy(QState::RestorePolicy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTATE_RESTOREPOLICY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setGlobalRestorePolicy(QState::RestorePolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_setGlobalRestorePolicy_TypeError;

    // Call function/method
    {
        ::QState::RestorePolicy cppArg0{QState::DontRestoreProperties};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGlobalRestorePolicy(QState::RestorePolicy)
            cppSelf->setGlobalRestorePolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_setGlobalRestorePolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_setRunning(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.setRunning";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStateMachine::setRunning(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setRunning(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStateMachineFunc_setRunning_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRunning(bool)
            cppSelf->setRunning(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStateMachineFunc_setRunning_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStateMachineFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.start";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // start()
            cppSelf->start();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QStateMachineFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStateMachine.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QStateMachine_PropertyStrings[] = {
    "animated:isAnimated:",
    "errorString:",
    "globalRestorePolicy::",
    "running:isRunning:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStateMachine_methods[] = {
    {"addDefaultAnimation", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_addDefaultAnimation), METH_O},
    {"addState", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_addState), METH_O},
    {"beginMicrostep", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_beginMicrostep), METH_O},
    {"beginSelectTransitions", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_beginSelectTransitions), METH_O},
    {"cancelDelayedEvent", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_cancelDelayedEvent), METH_O},
    {"clearError", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_clearError), METH_NOARGS},
    {"configuration", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_configuration), METH_NOARGS},
    {"defaultAnimations", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_defaultAnimations), METH_NOARGS},
    {"endMicrostep", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_endMicrostep), METH_O},
    {"endSelectTransitions", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_endSelectTransitions), METH_O},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_errorString), METH_NOARGS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_event), METH_O},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_eventFilter), METH_VARARGS},
    {"globalRestorePolicy", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_globalRestorePolicy), METH_NOARGS},
    {"isAnimated", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_isAnimated), METH_NOARGS},
    {"isRunning", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_isRunning), METH_NOARGS},
    {"onEntry", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_onEntry), METH_O},
    {"onExit", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_onExit), METH_O},
    {"postDelayedEvent", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_postDelayedEvent), METH_VARARGS},
    {"postEvent", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_postEvent), METH_VARARGS|METH_KEYWORDS},
    {"removeDefaultAnimation", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_removeDefaultAnimation), METH_O},
    {"removeState", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_removeState), METH_O},
    {"setAnimated", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_setAnimated), METH_O},
    {"setGlobalRestorePolicy", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_setGlobalRestorePolicy), METH_O},
    {"setRunning", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_setRunning), METH_O},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_start), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QStateMachineFunc_stop), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QStateMachine_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QStateMachine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QStateMachineWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QStateMachine_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStateMachine_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStateMachine_Type = nullptr;
static SbkObjectType *Sbk_QStateMachine_TypeF(void)
{
    return _Sbk_QStateMachine_Type;
}

static PyType_Slot Sbk_QStateMachine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QStateMachine_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStateMachine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStateMachine_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStateMachine_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStateMachine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStateMachine_spec = {
    "2:PySide2.QtCore.QStateMachine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStateMachine_slots
};

} //extern "C"

static void *Sbk_QStateMachine_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QStateMachine *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QStateMachine_EventPriority_PythonToCpp_QStateMachine_EventPriority(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStateMachine::EventPriority *>(cppOut) =
        static_cast<::QStateMachine::EventPriority>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStateMachine_EventPriority_PythonToCpp_QStateMachine_EventPriority_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX]))
        return QStateMachine_EventPriority_PythonToCpp_QStateMachine_EventPriority;
    return {};
}
static PyObject *QStateMachine_EventPriority_CppToPython_QStateMachine_EventPriority(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStateMachine::EventPriority *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX], castCppIn);

}

static void QStateMachine_Error_PythonToCpp_QStateMachine_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStateMachine::Error *>(cppOut) =
        static_cast<::QStateMachine::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStateMachine_Error_PythonToCpp_QStateMachine_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX]))
        return QStateMachine_Error_PythonToCpp_QStateMachine_Error;
    return {};
}
static PyObject *QStateMachine_Error_CppToPython_QStateMachine_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStateMachine::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStateMachine_PythonToCpp_QStateMachine_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStateMachine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStateMachine_PythonToCpp_QStateMachine_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStateMachine_TypeF())))
        return QStateMachine_PythonToCpp_QStateMachine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStateMachine_PTR_CppToPython_QStateMachine(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QStateMachine *>(const_cast<void *>(cppIn)), Sbk_QStateMachine_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStateMachine_SignatureStrings[] = {
    "1:PySide2.QtCore.QStateMachine(self,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtCore.QStateMachine(self,childMode:PySide2.QtCore.QState.ChildMode,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtCore.QStateMachine.addDefaultAnimation(self,animation:PySide2.QtCore.QAbstractAnimation)",
    "PySide2.QtCore.QStateMachine.addState(self,state:PySide2.QtCore.QAbstractState)",
    "PySide2.QtCore.QStateMachine.beginMicrostep(self,event:PySide2.QtCore.QEvent)",
    "PySide2.QtCore.QStateMachine.beginSelectTransitions(self,event:PySide2.QtCore.QEvent)",
    "PySide2.QtCore.QStateMachine.cancelDelayedEvent(self,id:int)->bool",
    "PySide2.QtCore.QStateMachine.clearError(self)",
    "1:PySide2.QtCore.QStateMachine.configuration(self)->list of QAbstractState",
    "0:PySide2.QtCore.QStateMachine.configuration(self)->QSet[PySide2.QtCore.QAbstractState]",
    "PySide2.QtCore.QStateMachine.defaultAnimations(self)->list of QAbstractAnimation",
    "PySide2.QtCore.QStateMachine.endMicrostep(self,event:PySide2.QtCore.QEvent)",
    "PySide2.QtCore.QStateMachine.endSelectTransitions(self,event:PySide2.QtCore.QEvent)",
    "PySide2.QtCore.QStateMachine.error(self)->PySide2.QtCore.QStateMachine.Error",
    "PySide2.QtCore.QStateMachine.errorString(self)->QString",
    "PySide2.QtCore.QStateMachine.event(self,e:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtCore.QStateMachine.eventFilter(self,watched:PySide2.QtCore.QObject,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtCore.QStateMachine.globalRestorePolicy(self)->PySide2.QtCore.QState.RestorePolicy",
    "PySide2.QtCore.QStateMachine.isAnimated(self)->bool",
    "PySide2.QtCore.QStateMachine.isRunning(self)->bool",
    "PySide2.QtCore.QStateMachine.onEntry(self,event:PySide2.QtCore.QEvent)",
    "PySide2.QtCore.QStateMachine.onExit(self,event:PySide2.QtCore.QEvent)",
    "PySide2.QtCore.QStateMachine.postDelayedEvent(self,event:PySide2.QtCore.QEvent,delay:int)->int",
    "PySide2.QtCore.QStateMachine.postEvent(self,event:PySide2.QtCore.QEvent,priority:PySide2.QtCore.QStateMachine.EventPriority=NormalPriority)",
    "PySide2.QtCore.QStateMachine.removeDefaultAnimation(self,animation:PySide2.QtCore.QAbstractAnimation)",
    "PySide2.QtCore.QStateMachine.removeState(self,state:PySide2.QtCore.QAbstractState)",
    "PySide2.QtCore.QStateMachine.setAnimated(self,enabled:bool)",
    "PySide2.QtCore.QStateMachine.setGlobalRestorePolicy(self,restorePolicy:PySide2.QtCore.QState.RestorePolicy)",
    "PySide2.QtCore.QStateMachine.setRunning(self,running:bool)",
    "PySide2.QtCore.QStateMachine.start(self)",
    "PySide2.QtCore.QStateMachine.stop(self)",
    nullptr}; // Sentinel

void init_QStateMachine(PyObject *module)
{
    _Sbk_QStateMachine_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStateMachine",
        "QStateMachine*",
        &Sbk_QStateMachine_spec,
        &Shiboken::callCppDestructor< ::QStateMachine >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTATE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStateMachine_Type);
    InitSignatureStrings(pyType, QStateMachine_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStateMachine_Type), Sbk_QStateMachine_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStateMachine_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStateMachine_TypeF(),
        QStateMachine_PythonToCpp_QStateMachine_PTR,
        is_QStateMachine_PythonToCpp_QStateMachine_PTR_Convertible,
        QStateMachine_PTR_CppToPython_QStateMachine);

    Shiboken::Conversions::registerConverterName(converter, "QStateMachine");
    Shiboken::Conversions::registerConverterName(converter, "QStateMachine*");
    Shiboken::Conversions::registerConverterName(converter, "QStateMachine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStateMachine).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStateMachineWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QStateMachine_TypeF(), &Sbk_QStateMachine_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'EventPriority'.
    SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStateMachine_TypeF(),
        "EventPriority",
        "2:PySide2.QtCore.QStateMachine.EventPriority",
        "QStateMachine::EventPriority");
    if (!SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX],
        Sbk_QStateMachine_TypeF(), "NormalPriority", (long) QStateMachine::EventPriority::NormalPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX],
        Sbk_QStateMachine_TypeF(), "HighPriority", (long) QStateMachine::EventPriority::HighPriority))
        return;
    // Register converter for enum 'QStateMachine::EventPriority'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX],
            QStateMachine_EventPriority_CppToPython_QStateMachine_EventPriority);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStateMachine_EventPriority_PythonToCpp_QStateMachine_EventPriority,
            is_QStateMachine_EventPriority_PythonToCpp_QStateMachine_EventPriority_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStateMachine::EventPriority");
        Shiboken::Conversions::registerConverterName(converter, "EventPriority");
    }
    // End of 'EventPriority' enum.

    // Initialization of enum 'Error'.
    SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStateMachine_TypeF(),
        "Error",
        "2:PySide2.QtCore.QStateMachine.Error",
        "QStateMachine::Error");
    if (!SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX],
        Sbk_QStateMachine_TypeF(), "NoError", (long) QStateMachine::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX],
        Sbk_QStateMachine_TypeF(), "NoInitialStateError", (long) QStateMachine::Error::NoInitialStateError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX],
        Sbk_QStateMachine_TypeF(), "NoDefaultStateInHistoryStateError", (long) QStateMachine::Error::NoDefaultStateInHistoryStateError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX],
        Sbk_QStateMachine_TypeF(), "NoCommonAncestorForTransitionError", (long) QStateMachine::Error::NoCommonAncestorForTransitionError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX],
        Sbk_QStateMachine_TypeF(), "StateMachineChildModeSetToParallelError", (long) QStateMachine::Error::StateMachineChildModeSetToParallelError))
        return;
    // Register converter for enum 'QStateMachine::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX],
            QStateMachine_Error_CppToPython_QStateMachine_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStateMachine_Error_PythonToCpp_QStateMachine_Error,
            is_QStateMachine_Error_PythonToCpp_QStateMachine_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStateMachine::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    PySide::Signal::registerSignals(Sbk_QStateMachine_TypeF(), &::QStateMachine::staticMetaObject);
    qRegisterMetaType< ::QStateMachine::EventPriority >("QStateMachine::EventPriority");
    qRegisterMetaType< ::QStateMachine::Error >("QStateMachine::Error");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QStateMachine_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QStateMachine_TypeF(), &::QStateMachine::staticMetaObject, sizeof(QStateMachineWrapper));
}
