/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qstandardpaths_wrapper.h"

// inner classes

// Extra includes
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QStandardPathsFunc_displayName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStandardPaths.displayName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QStandardPaths::displayName(QStandardPaths::StandardLocation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // displayName(QStandardPaths::StandardLocation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStandardPathsFunc_displayName_TypeError;

    // Call function/method
    {
        ::QStandardPaths::StandardLocation cppArg0{QStandardPaths::DesktopLocation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // displayName(QStandardPaths::StandardLocation)
            QString cppResult = ::QStandardPaths::displayName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStandardPathsFunc_displayName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStandardPathsFunc_enableTestMode(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStandardPaths.enableTestMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QStandardPaths::enableTestMode(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // enableTestMode(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStandardPathsFunc_enableTestMode_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // enableTestMode(bool)
            ::QStandardPaths::enableTestMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStandardPathsFunc_enableTestMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStandardPathsFunc_findExecutable(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStandardPaths.findExecutable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStandardPathsFunc_findExecutable_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStandardPathsFunc_findExecutable_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:findExecutable", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QStandardPaths::findExecutable(QString,QStringList)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // findExecutable(QString,QStringList)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
            overloadId = 0; // findExecutable(QString,QStringList)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStandardPathsFunc_findExecutable_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_paths = Shiboken::String::createStaticString("paths");
            if (PyDict_Contains(kwds, key_paths)) {
                value = PyDict_GetItem(kwds, key_paths);
                if (value && pyArgs[1]) {
                    errInfo = key_paths;
                    Py_INCREF(errInfo);
                    goto Sbk_QStandardPathsFunc_findExecutable_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1]))))
                        goto Sbk_QStandardPathsFunc_findExecutable_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_paths);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStandardPathsFunc_findExecutable_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QStringList cppArg1 = QStringList();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // findExecutable(QString,QStringList)
            QString cppResult = ::QStandardPaths::findExecutable(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStandardPathsFunc_findExecutable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStandardPathsFunc_isTestModeEnabled(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStandardPaths.isTestModeEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTestModeEnabled()
            bool cppResult = ::QStandardPaths::isTestModeEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStandardPathsFunc_locate(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStandardPaths.locate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStandardPathsFunc_locate_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStandardPathsFunc_locate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:locate", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QStandardPaths::locate(QStandardPaths::StandardLocation,QString,QFlags<QStandardPaths::LocateOption>)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // locate(QStandardPaths::StandardLocation,QString,QFlags<QStandardPaths::LocateOption>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // locate(QStandardPaths::StandardLocation,QString,QFlags<QStandardPaths::LocateOption>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStandardPathsFunc_locate_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[2]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QStandardPathsFunc_locate_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QStandardPathsFunc_locate_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStandardPathsFunc_locate_TypeError;
            }
        }
        ::QStandardPaths::StandardLocation cppArg0{QStandardPaths::DesktopLocation};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<QStandardPaths::LocateOption> cppArg2 = QStandardPaths::LocateFile;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // locate(QStandardPaths::StandardLocation,QString,QFlags<QStandardPaths::LocateOption>)
            QString cppResult = ::QStandardPaths::locate(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStandardPathsFunc_locate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStandardPathsFunc_locateAll(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStandardPaths.locateAll";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStandardPathsFunc_locateAll_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStandardPathsFunc_locateAll_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:locateAll", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QStandardPaths::locateAll(QStandardPaths::StandardLocation,QString,QFlags<QStandardPaths::LocateOption>)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // locateAll(QStandardPaths::StandardLocation,QString,QFlags<QStandardPaths::LocateOption>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // locateAll(QStandardPaths::StandardLocation,QString,QFlags<QStandardPaths::LocateOption>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStandardPathsFunc_locateAll_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[2]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QStandardPathsFunc_locateAll_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QStandardPathsFunc_locateAll_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStandardPathsFunc_locateAll_TypeError;
            }
        }
        ::QStandardPaths::StandardLocation cppArg0{QStandardPaths::DesktopLocation};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<QStandardPaths::LocateOption> cppArg2 = QStandardPaths::LocateFile;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // locateAll(QStandardPaths::StandardLocation,QString,QFlags<QStandardPaths::LocateOption>)
            QStringList cppResult = ::QStandardPaths::locateAll(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStandardPathsFunc_locateAll_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStandardPathsFunc_setTestModeEnabled(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStandardPaths.setTestModeEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QStandardPaths::setTestModeEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setTestModeEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStandardPathsFunc_setTestModeEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTestModeEnabled(bool)
            ::QStandardPaths::setTestModeEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStandardPathsFunc_setTestModeEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStandardPathsFunc_standardLocations(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStandardPaths.standardLocations";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QStandardPaths::standardLocations(QStandardPaths::StandardLocation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // standardLocations(QStandardPaths::StandardLocation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStandardPathsFunc_standardLocations_TypeError;

    // Call function/method
    {
        ::QStandardPaths::StandardLocation cppArg0{QStandardPaths::DesktopLocation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // standardLocations(QStandardPaths::StandardLocation)
            QStringList cppResult = ::QStandardPaths::standardLocations(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStandardPathsFunc_standardLocations_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStandardPathsFunc_writableLocation(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QStandardPaths.writableLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QStandardPaths::writableLocation(QStandardPaths::StandardLocation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // writableLocation(QStandardPaths::StandardLocation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStandardPathsFunc_writableLocation_TypeError;

    // Call function/method
    {
        ::QStandardPaths::StandardLocation cppArg0{QStandardPaths::DesktopLocation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // writableLocation(QStandardPaths::StandardLocation)
            QString cppResult = ::QStandardPaths::writableLocation(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStandardPathsFunc_writableLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QStandardPaths_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStandardPaths_methods[] = {
    {"displayName", reinterpret_cast<PyCFunction>(Sbk_QStandardPathsFunc_displayName), METH_O|METH_STATIC},
    {"enableTestMode", reinterpret_cast<PyCFunction>(Sbk_QStandardPathsFunc_enableTestMode), METH_O|METH_STATIC},
    {"findExecutable", reinterpret_cast<PyCFunction>(Sbk_QStandardPathsFunc_findExecutable), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isTestModeEnabled", reinterpret_cast<PyCFunction>(Sbk_QStandardPathsFunc_isTestModeEnabled), METH_NOARGS|METH_STATIC},
    {"locate", reinterpret_cast<PyCFunction>(Sbk_QStandardPathsFunc_locate), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"locateAll", reinterpret_cast<PyCFunction>(Sbk_QStandardPathsFunc_locateAll), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"setTestModeEnabled", reinterpret_cast<PyCFunction>(Sbk_QStandardPathsFunc_setTestModeEnabled), METH_O|METH_STATIC},
    {"standardLocations", reinterpret_cast<PyCFunction>(Sbk_QStandardPathsFunc_standardLocations), METH_O|METH_STATIC},
    {"writableLocation", reinterpret_cast<PyCFunction>(Sbk_QStandardPathsFunc_writableLocation), METH_O|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStandardPaths_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStandardPaths_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStandardPaths_Type = nullptr;
static SbkObjectType *Sbk_QStandardPaths_TypeF(void)
{
    return _Sbk_QStandardPaths_Type;
}

static PyType_Slot Sbk_QStandardPaths_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(SbkDeallocWrapperWithPrivateDtor)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStandardPaths_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStandardPaths_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStandardPaths_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStandardPaths_spec = {
    "2:PySide2.QtCore.QStandardPaths",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStandardPaths_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QStandardPaths_LocateOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QStandardPaths::LocateOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStandardPaths::LocateOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStandardPaths::LocateOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStandardPaths::LocateOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStandardPaths::LocateOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QStandardPaths_LocateOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QStandardPaths::LocateOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStandardPaths::LocateOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStandardPaths::LocateOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStandardPaths::LocateOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStandardPaths::LocateOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QStandardPaths_LocateOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QStandardPaths::LocateOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStandardPaths::LocateOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStandardPaths::LocateOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStandardPaths::LocateOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStandardPaths::LocateOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QStandardPaths_LocateOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QStandardPaths::LocateOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX])->converter, self, &cppSelf);
    ::QStandardPaths::LocateOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QStandardPaths_LocateOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QStandardPaths_LocateOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QStandardPaths_LocateOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QStandardPaths_LocateOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QStandardPaths_LocateOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QStandardPaths_LocateOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QStandardPaths_LocateOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QStandardPaths_LocateOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QStandardPaths_LocateOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QStandardPaths_LocateOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QStandardPaths_LocateOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QStandardPaths_LocateOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QStandardPaths_LocateOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QStandardPaths_StandardLocation_PythonToCpp_QStandardPaths_StandardLocation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStandardPaths::StandardLocation *>(cppOut) =
        static_cast<::QStandardPaths::StandardLocation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStandardPaths_StandardLocation_PythonToCpp_QStandardPaths_StandardLocation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX]))
        return QStandardPaths_StandardLocation_PythonToCpp_QStandardPaths_StandardLocation;
    return {};
}
static PyObject *QStandardPaths_StandardLocation_CppToPython_QStandardPaths_StandardLocation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStandardPaths::StandardLocation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX], castCppIn);

}

static void QStandardPaths_LocateOption_PythonToCpp_QStandardPaths_LocateOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStandardPaths::LocateOption *>(cppOut) =
        static_cast<::QStandardPaths::LocateOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStandardPaths_LocateOption_PythonToCpp_QStandardPaths_LocateOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_LOCATEOPTION_IDX]))
        return QStandardPaths_LocateOption_PythonToCpp_QStandardPaths_LocateOption;
    return {};
}
static PyObject *QStandardPaths_LocateOption_CppToPython_QStandardPaths_LocateOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStandardPaths::LocateOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_LOCATEOPTION_IDX], castCppIn);

}

static void QFlags_QStandardPaths_LocateOption__PythonToCpp_QFlags_QStandardPaths_LocateOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStandardPaths::LocateOption> *>(cppOut) =
        ::QFlags<QStandardPaths::LocateOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QStandardPaths_LocateOption__PythonToCpp_QFlags_QStandardPaths_LocateOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX]))
        return QFlags_QStandardPaths_LocateOption__PythonToCpp_QFlags_QStandardPaths_LocateOption_;
    return {};
}
static PyObject *QFlags_QStandardPaths_LocateOption__CppToPython_QFlags_QStandardPaths_LocateOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QStandardPaths::LocateOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX]));

}

static void QStandardPaths_LocateOption_PythonToCpp_QFlags_QStandardPaths_LocateOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStandardPaths::LocateOption> *>(cppOut) =
        ::QFlags<QStandardPaths::LocateOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QStandardPaths_LocateOption_PythonToCpp_QFlags_QStandardPaths_LocateOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_LOCATEOPTION_IDX]))
        return QStandardPaths_LocateOption_PythonToCpp_QFlags_QStandardPaths_LocateOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QStandardPaths_LocateOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QStandardPaths::LocateOption> *>(cppOut) =
        ::QFlags<QStandardPaths::LocateOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QStandardPaths_LocateOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_LOCATEOPTION_IDX]))
        return number_PythonToCpp_QFlags_QStandardPaths_LocateOption_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStandardPaths_PythonToCpp_QStandardPaths_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStandardPaths_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStandardPaths_PythonToCpp_QStandardPaths_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStandardPaths_TypeF())))
        return QStandardPaths_PythonToCpp_QStandardPaths_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStandardPaths_PTR_CppToPython_QStandardPaths(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStandardPaths *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStandardPaths_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStandardPaths_SignatureStrings[] = {
    "PySide2.QtCore.QStandardPaths.displayName(type:PySide2.QtCore.QStandardPaths.StandardLocation)->QString",
    "PySide2.QtCore.QStandardPaths.enableTestMode(testMode:bool)",
    "PySide2.QtCore.QStandardPaths.findExecutable(executableName:QString,paths:QStringList=QStringList())->QString",
    "PySide2.QtCore.QStandardPaths.isTestModeEnabled()->bool",
    "PySide2.QtCore.QStandardPaths.locate(type:PySide2.QtCore.QStandardPaths.StandardLocation,fileName:QString,options:PySide2.QtCore.QStandardPaths.LocateOptions=QStandardPaths.LocateFile)->QString",
    "PySide2.QtCore.QStandardPaths.locateAll(type:PySide2.QtCore.QStandardPaths.StandardLocation,fileName:QString,options:PySide2.QtCore.QStandardPaths.LocateOptions=QStandardPaths.LocateFile)->QStringList",
    "PySide2.QtCore.QStandardPaths.setTestModeEnabled(testMode:bool)",
    "PySide2.QtCore.QStandardPaths.standardLocations(type:PySide2.QtCore.QStandardPaths.StandardLocation)->QStringList",
    "PySide2.QtCore.QStandardPaths.writableLocation(type:PySide2.QtCore.QStandardPaths.StandardLocation)->QString",
    nullptr}; // Sentinel

void init_QStandardPaths(PyObject *module)
{
    _Sbk_QStandardPaths_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStandardPaths",
        "QStandardPaths*",
        &Sbk_QStandardPaths_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStandardPaths_Type);
    InitSignatureStrings(pyType, QStandardPaths_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStandardPaths_Type), Sbk_QStandardPaths_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStandardPaths_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStandardPaths_TypeF(),
        QStandardPaths_PythonToCpp_QStandardPaths_PTR,
        is_QStandardPaths_PythonToCpp_QStandardPaths_PTR_Convertible,
        QStandardPaths_PTR_CppToPython_QStandardPaths);

    Shiboken::Conversions::registerConverterName(converter, "QStandardPaths");
    Shiboken::Conversions::registerConverterName(converter, "QStandardPaths*");
    Shiboken::Conversions::registerConverterName(converter, "QStandardPaths&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStandardPaths).name());


    // Initialization of enums.

    // Initialization of enum 'StandardLocation'.
    SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStandardPaths_TypeF(),
        "StandardLocation",
        "2:PySide2.QtCore.QStandardPaths.StandardLocation",
        "QStandardPaths::StandardLocation");
    if (!SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "DesktopLocation", (long) QStandardPaths::StandardLocation::DesktopLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "DocumentsLocation", (long) QStandardPaths::StandardLocation::DocumentsLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "FontsLocation", (long) QStandardPaths::StandardLocation::FontsLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "ApplicationsLocation", (long) QStandardPaths::StandardLocation::ApplicationsLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "MusicLocation", (long) QStandardPaths::StandardLocation::MusicLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "MoviesLocation", (long) QStandardPaths::StandardLocation::MoviesLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "PicturesLocation", (long) QStandardPaths::StandardLocation::PicturesLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "TempLocation", (long) QStandardPaths::StandardLocation::TempLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "HomeLocation", (long) QStandardPaths::StandardLocation::HomeLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "DataLocation", (long) QStandardPaths::StandardLocation::DataLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "CacheLocation", (long) QStandardPaths::StandardLocation::CacheLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "GenericDataLocation", (long) QStandardPaths::StandardLocation::GenericDataLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "RuntimeLocation", (long) QStandardPaths::StandardLocation::RuntimeLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "ConfigLocation", (long) QStandardPaths::StandardLocation::ConfigLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "DownloadLocation", (long) QStandardPaths::StandardLocation::DownloadLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "GenericCacheLocation", (long) QStandardPaths::StandardLocation::GenericCacheLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "GenericConfigLocation", (long) QStandardPaths::StandardLocation::GenericConfigLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "AppDataLocation", (long) QStandardPaths::StandardLocation::AppDataLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "AppConfigLocation", (long) QStandardPaths::StandardLocation::AppConfigLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
        Sbk_QStandardPaths_TypeF(), "AppLocalDataLocation", (long) QStandardPaths::StandardLocation::AppLocalDataLocation))
        return;
    // Register converter for enum 'QStandardPaths::StandardLocation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX],
            QStandardPaths_StandardLocation_CppToPython_QStandardPaths_StandardLocation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStandardPaths_StandardLocation_PythonToCpp_QStandardPaths_StandardLocation,
            is_QStandardPaths_StandardLocation_PythonToCpp_QStandardPaths_StandardLocation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_STANDARDLOCATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStandardPaths::StandardLocation");
        Shiboken::Conversions::registerConverterName(converter, "StandardLocation");
    }
    // End of 'StandardLocation' enum.

    // Initialization of enum 'LocateOption'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QStandardPaths.LocateOptions", SbkPySide2_QtCore_QStandardPaths_LocateOption_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_LOCATEOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStandardPaths_TypeF(),
        "LocateOption",
        "2:PySide2.QtCore.QStandardPaths.LocateOption",
        "QStandardPaths::LocateOption",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_LOCATEOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_LOCATEOPTION_IDX],
        Sbk_QStandardPaths_TypeF(), "LocateFile", (long) QStandardPaths::LocateOption::LocateFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_LOCATEOPTION_IDX],
        Sbk_QStandardPaths_TypeF(), "LocateDirectory", (long) QStandardPaths::LocateOption::LocateDirectory))
        return;
    // Register converter for enum 'QStandardPaths::LocateOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_LOCATEOPTION_IDX],
            QStandardPaths_LocateOption_CppToPython_QStandardPaths_LocateOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStandardPaths_LocateOption_PythonToCpp_QStandardPaths_LocateOption,
            is_QStandardPaths_LocateOption_PythonToCpp_QStandardPaths_LocateOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSTANDARDPATHS_LOCATEOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStandardPaths::LocateOption");
        Shiboken::Conversions::registerConverterName(converter, "LocateOption");
    }
    // Register converter for flag 'QFlags<QStandardPaths::LocateOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX],
            QFlags_QStandardPaths_LocateOption__CppToPython_QFlags_QStandardPaths_LocateOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStandardPaths_LocateOption_PythonToCpp_QFlags_QStandardPaths_LocateOption_,
            is_QStandardPaths_LocateOption_PythonToCpp_QFlags_QStandardPaths_LocateOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QStandardPaths_LocateOption__PythonToCpp_QFlags_QStandardPaths_LocateOption_,
            is_QFlags_QStandardPaths_LocateOption__PythonToCpp_QFlags_QStandardPaths_LocateOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QStandardPaths_LocateOption_,
            is_number_PythonToCpp_QFlags_QStandardPaths_LocateOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QSTANDARDPATHS_LOCATEOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStandardPaths::LocateOptions");
        Shiboken::Conversions::registerConverterName(converter, "LocateOptions");
    }
    // End of 'LocateOption' enum/flags.

    qRegisterMetaType< ::QStandardPaths::StandardLocation >("QStandardPaths::StandardLocation");
    qRegisterMetaType< ::QStandardPaths::LocateOption >("QStandardPaths::LocateOption");
    qRegisterMetaType< ::QStandardPaths::LocateOptions >("QStandardPaths::LocateOptions");
}
