/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qsettings_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSettingsWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSettingsWrapper::QSettingsWrapper(::QObject * parent) : QSettings(parent)
{
    resetPyMethodCache();
    // ... middle
}

QSettingsWrapper::QSettingsWrapper(::QSettings::Format format, ::QSettings::Scope scope, const ::QString & organization, const ::QString & application, ::QObject * parent) : QSettings(format, scope, organization, application, parent)
{
    resetPyMethodCache();
    // ... middle
}

QSettingsWrapper::QSettingsWrapper(::QSettings::Scope scope, ::QObject * parent) : QSettings(scope, parent)
{
    resetPyMethodCache();
    // ... middle
}

QSettingsWrapper::QSettingsWrapper(::QSettings::Scope scope, const ::QString & organization, const ::QString & application, ::QObject * parent) : QSettings(scope, organization, application, parent)
{
    resetPyMethodCache();
    // ... middle
}

QSettingsWrapper::QSettingsWrapper(const ::QString & fileName, ::QSettings::Format format, ::QObject * parent) : QSettings(fileName, format, parent)
{
    resetPyMethodCache();
    // ... middle
}

QSettingsWrapper::QSettingsWrapper(const ::QString & organization, const ::QString & application, ::QObject * parent) : QSettings(organization, application, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QSettingsWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSettingsWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSettingsWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSettingsWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QSettingsWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QSettings::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QSettings::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSettings.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QSettingsWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSettings.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QSettingsWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QSettingsWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QSettings::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QSettingsWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QSettings::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QSettingsWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QSettingsWrapper *>(this));
        return QSettings::qt_metacast(_clname);
}

QSettingsWrapper::~QSettingsWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSettings_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSettings >()))
        return -1;

    ::QSettingsWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OOOOO:QSettings", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return -1;


    // Overloaded function decisor
    // 0: QSettings::QSettings(QObject*)
    // 1: QSettings::QSettings(QSettings::Format,QSettings::Scope,QString,QString,QObject*)
    // 2: QSettings::QSettings(QSettings::Scope,QObject*)
    // 3: QSettings::QSettings(QSettings::Scope,QString,QString,QObject*)
    // 4: QSettings::QSettings(QString,QSettings::Format,QObject*)
    // 5: QSettings::QSettings(QString,QString,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QSettings(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QSettings(QSettings::Scope,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QSettings(QSettings::Scope,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // QSettings(QSettings::Scope,QString,QString,QObject*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 3; // QSettings(QSettings::Scope,QString,QString,QObject*)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[3])))) {
                    overloadId = 3; // QSettings(QSettings::Scope,QString,QString,QObject*)
                }
            }
        }
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 1; // QSettings(QSettings::Format,QSettings::Scope,QString,QString,QObject*)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 1; // QSettings(QSettings::Format,QSettings::Scope,QString,QString,QObject*)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[4])))) {
                overloadId = 1; // QSettings(QSettings::Format,QSettings::Scope,QString,QString,QObject*)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QSettings(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 5; // QSettings(QString,QString,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 5; // QSettings(QString,QString,QObject*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
                overloadId = 5; // QSettings(QString,QString,QObject*)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 4; // QSettings(QString,QSettings::Format,QObject*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
                overloadId = 4; // QSettings(QString,QSettings::Format,QObject*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettings_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSettings(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QSettings_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QSettings_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSettings(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSettingsWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSettingsWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QSettings(QSettings::Format format, QSettings::Scope scope, const QString & organization, const QString & application, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_application = Shiboken::String::createStaticString("application");
                if (PyDict_Contains(kwds, key_application)) {
                    value = PyDict_GetItem(kwds, key_application);
                    if (value && pyArgs[3]) {
                        errInfo = key_application;
                        Py_INCREF(errInfo);
                        goto Sbk_QSettings_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                            goto Sbk_QSettings_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_application);
                }
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[4]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QSettings_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[4]))))
                            goto Sbk_QSettings_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QSettings::Format cppArg0{QSettings::NativeFormat};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QSettings::Scope cppArg1{QSettings::UserScope};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return -1;
            ::QObject *cppArg4 = nullptr;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QSettings(QSettings::Format,QSettings::Scope,QString,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSettingsWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSettingsWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                }

                Shiboken::Object::setParent(pyArgs[4], self);
            }
            break;
        }
        case 2: // QSettings(QSettings::Scope scope, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QSettings_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QSettings_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QSettings::Scope cppArg0{QSettings::UserScope};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QSettings(QSettings::Scope,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSettingsWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSettingsWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
        case 3: // QSettings(QSettings::Scope scope, const QString & organization, const QString & application, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_application = Shiboken::String::createStaticString("application");
                if (PyDict_Contains(kwds, key_application)) {
                    value = PyDict_GetItem(kwds, key_application);
                    if (value && pyArgs[2]) {
                        errInfo = key_application;
                        Py_INCREF(errInfo);
                        goto Sbk_QSettings_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                            goto Sbk_QSettings_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_application);
                }
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[3]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QSettings_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[3]))))
                            goto Sbk_QSettings_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QSettings::Scope cppArg0{QSettings::UserScope};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QObject *cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QSettings(QSettings::Scope,QString,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSettingsWrapper(cppArg0, cppArg1, cppArg2, cppArg3);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSettingsWrapper(cppArg0, cppArg1, cppArg2, cppArg3);
                }

                Shiboken::Object::setParent(pyArgs[3], self);
            }
            break;
        }
        case 4: // QSettings(const QString & fileName, QSettings::Format format, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[2]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QSettings_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                            goto Sbk_QSettings_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QSettings::Format cppArg1{QSettings::NativeFormat};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QSettings(QString,QSettings::Format,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSettingsWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSettingsWrapper(cppArg0, cppArg1, cppArg2);
                }

                Shiboken::Object::setParent(pyArgs[2], self);
            }
            break;
        }
        case 5: // QSettings(const QString & organization, const QString & application, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_application = Shiboken::String::createStaticString("application");
                if (PyDict_Contains(kwds, key_application)) {
                    value = PyDict_GetItem(kwds, key_application);
                    if (value && pyArgs[1]) {
                        errInfo = key_application;
                        Py_INCREF(errInfo);
                        goto Sbk_QSettings_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QSettings_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_application);
                }
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[2]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QSettings_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                            goto Sbk_QSettings_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QSettings(QString,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSettingsWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSettingsWrapper(cppArg0, cppArg1, cppArg2);
                }

                Shiboken::Object::setParent(pyArgs[2], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSettings >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSettings_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QSettings_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QSettings_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSettingsFunc_allKeys(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.allKeys";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allKeys()const
            QStringList cppResult = const_cast<const ::QSettings *>(cppSelf)->allKeys();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_applicationName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.applicationName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // applicationName()const
            QString cppResult = const_cast<const ::QSettings *>(cppSelf)->applicationName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_beginGroup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.beginGroup";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSettings::beginGroup(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // beginGroup(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_beginGroup_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // beginGroup(QString)
            cppSelf->beginGroup(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSettingsFunc_beginGroup_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_beginReadArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.beginReadArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSettings::beginReadArray(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // beginReadArray(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_beginReadArray_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // beginReadArray(QString)
            int cppResult = cppSelf->beginReadArray(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSettingsFunc_beginReadArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_beginWriteArray(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.beginWriteArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSettingsFunc_beginWriteArray_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSettingsFunc_beginWriteArray_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:beginWriteArray", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSettings::beginWriteArray(QString,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // beginWriteArray(QString,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // beginWriteArray(QString,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_beginWriteArray_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_size = Shiboken::String::createStaticString("size");
            if (PyDict_Contains(kwds, key_size)) {
                value = PyDict_GetItem(kwds, key_size);
                if (value && pyArgs[1]) {
                    errInfo = key_size;
                    Py_INCREF(errInfo);
                    goto Sbk_QSettingsFunc_beginWriteArray_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QSettingsFunc_beginWriteArray_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_size);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSettingsFunc_beginWriteArray_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // beginWriteArray(QString,int)
            cppSelf->beginWriteArray(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSettingsFunc_beginWriteArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_childGroups(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.childGroups";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // childGroups()const
            QStringList cppResult = const_cast<const ::QSettings *>(cppSelf)->childGroups();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_childKeys(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.childKeys";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // childKeys()const
            QStringList cppResult = const_cast<const ::QSettings *>(cppSelf)->childKeys();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSettingsFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSettings::contains(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // contains(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_contains_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // contains(QString)const
            bool cppResult = const_cast<const ::QSettings *>(cppSelf)->contains(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSettingsFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_defaultFormat(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.defaultFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultFormat()
            QSettings::Format cppResult = ::QSettings::defaultFormat();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_endArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.endArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // endArray()
            cppSelf->endArray();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSettingsFunc_endGroup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.endGroup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // endGroup()
            cppSelf->endGroup();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSettingsFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSettings::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSettingsFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_fallbacksEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.fallbacksEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fallbacksEnabled()const
            bool cppResult = const_cast<const ::QSettings *>(cppSelf)->fallbacksEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.fileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileName()const
            QString cppResult = const_cast<const ::QSettings *>(cppSelf)->fileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QSettings::Format cppResult = const_cast<const ::QSettings *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_group(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.group";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // group()const
            QString cppResult = const_cast<const ::QSettings *>(cppSelf)->group();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_iniCodec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.iniCodec";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // iniCodec()const
            QTextCodec * cppResult = const_cast<const ::QSettings *>(cppSelf)->iniCodec();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_isAtomicSyncRequired(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.isAtomicSyncRequired";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAtomicSyncRequired()const
            bool cppResult = const_cast<const ::QSettings *>(cppSelf)->isAtomicSyncRequired();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_isWritable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.isWritable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isWritable()const
            bool cppResult = const_cast<const ::QSettings *>(cppSelf)->isWritable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_organizationName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.organizationName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // organizationName()const
            QString cppResult = const_cast<const ::QSettings *>(cppSelf)->organizationName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_remove(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.remove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSettings::remove(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // remove(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_remove_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // remove(QString)
            cppSelf->remove(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSettingsFunc_remove_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_scope(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.scope";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scope()const
            QSettings::Scope cppResult = const_cast<const ::QSettings *>(cppSelf)->scope();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_setArrayIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.setArrayIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSettings::setArrayIndex(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setArrayIndex(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_setArrayIndex_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setArrayIndex(int)
            cppSelf->setArrayIndex(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSettingsFunc_setArrayIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_setAtomicSyncRequired(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.setAtomicSyncRequired";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSettings::setAtomicSyncRequired(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAtomicSyncRequired(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_setAtomicSyncRequired_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAtomicSyncRequired(bool)
            cppSelf->setAtomicSyncRequired(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSettingsFunc_setAtomicSyncRequired_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_setDefaultFormat(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.setDefaultFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QSettings::setDefaultFormat(QSettings::Format)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDefaultFormat(QSettings::Format)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_setDefaultFormat_TypeError;

    // Call function/method
    {
        ::QSettings::Format cppArg0{QSettings::NativeFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultFormat(QSettings::Format)
            ::QSettings::setDefaultFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSettingsFunc_setDefaultFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_setFallbacksEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.setFallbacksEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSettings::setFallbacksEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFallbacksEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_setFallbacksEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFallbacksEnabled(bool)
            cppSelf->setFallbacksEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSettingsFunc_setFallbacksEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_setIniCodec(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.setIniCodec";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSettings::setIniCodec(QTextCodec*)
    // 1: QSettings::setIniCodec(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 1; // setIniCodec(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTCODEC_IDX]), (pyArg)))) {
        overloadId = 0; // setIniCodec(QTextCodec*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_setIniCodec_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setIniCodec(QTextCodec * codec)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QTextCodec *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setIniCodec(QTextCodec*)
                cppSelf->setIniCodec(cppArg0);
            }
            break;
        }
        case 1: // setIniCodec(const char * codecName)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setIniCodec(const char*)
                cppSelf->setIniCodec(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSettingsFunc_setIniCodec_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_setPath(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.setPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPath", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QSettings::setPath(QSettings::Format,QSettings::Scope,QString)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 0; // setPath(QSettings::Format,QSettings::Scope,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_setPath_TypeError;

    // Call function/method
    {
        ::QSettings::Format cppArg0{QSettings::NativeFormat};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QSettings::Scope cppArg1{QSettings::UserScope};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setPath(QSettings::Format,QSettings::Scope,QString)
            ::QSettings::setPath(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSettingsFunc_setPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_setValue(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.setValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setValue", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSettings::setValue(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setValue(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_setValue_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setValue(QString,QVariant)
            cppSelf->setValue(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSettingsFunc_setValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSettingsFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            QSettings::Status cppResult = const_cast<const ::QSettings *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSettingsFunc_sync(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.sync";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sync()
            cppSelf->sync();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSettingsFunc_value(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QSettings.value";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSettingsFunc_value_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSettingsFunc_value_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:value", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QSettings::value(QString,QVariant&,PyObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // value(QString,QVariant&,PyObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // value(QString,QVariant&,PyObject*)
            } else if (numArgs >= 3
                && PyObject_Check(pyArgs[2])) {
                overloadId = 0; // value(QString,QVariant&,PyObject*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSettingsFunc_value_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[1]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QSettingsFunc_value_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1]))))
                        goto Sbk_QSettingsFunc_value_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[2]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QSettingsFunc_value_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!PyObject_Check(pyArgs[2]))
                        goto Sbk_QSettingsFunc_value_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSettingsFunc_value_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        SBK_UNUSED(cppArg0)
        ::QVariant cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        SBK_UNUSED(cppArg1)

        if (!PyErr_Occurred()) {
            // value(QString,QVariant&,PyObject*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qsettings-value)]
            // If we enter the kwds, means that we have a defaultValue or
            // at least a type.
            // This avoids that we are passing '0' as defaultValue.
            // defaultValue can also be passed as positional argument,
            // not only as keyword.
            QVariant out;
            if (kwds || numArgs > 1) {
                Py_BEGIN_ALLOW_THREADS
                out = cppSelf->value(cppArg0, cppArg1);
                Py_END_ALLOW_THREADS
            } else {
                Py_BEGIN_ALLOW_THREADS
                out = cppSelf->value(cppArg0);
                Py_END_ALLOW_THREADS
            }

            PyTypeObject *typeObj = reinterpret_cast<PyTypeObject*>(pyArgs[3-1]);

            if (typeObj && !Shiboken::ObjectType::checkType(typeObj)) {
                if (typeObj == &PyList_Type) {
                    QByteArray out_ba = out.toByteArray();
                    if (!out_ba.isEmpty()) {
                        QByteArrayList valuesList = out_ba.split(',');
                        const int valuesSize = valuesList.size();
                        if (valuesSize > 0) {
                            PyObject *list = PyList_New(valuesSize);
                            for (int i = 0; i < valuesSize; i++) {
                                PyObject *item = PyUnicode_FromString(valuesList[i].data());
                                PyList_SET_ITEM(list, i, item);
                            }
                            pyResult = list;

                        } else {
                            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &out);
                        }
                    } else {
                        pyResult = PyList_New(0);
                    }
                } else if (typeObj == &PyBytes_Type) {
                    QByteArray asByteArray = out.toByteArray();
                    pyResult = PyBytes_FromString(asByteArray.data());
                } else if (typeObj == &PyUnicode_Type) {
                    QByteArray asByteArray = out.toByteArray();
                    pyResult = PyUnicode_FromString(asByteArray.data());
#ifdef IS_PY3K
                } else if (typeObj == &PyLong_Type) {
                    float asFloat = out.toFloat();
                    pyResult = PyLong_FromDouble(asFloat);
#else
                } else if (typeObj == &PyInt_Type) {
                    float asFloat = out.toFloat();
                    pyResult = PyInt_FromLong(long(asFloat));
#endif
                } else if (typeObj == &PyFloat_Type) {
                    float asFloat = out.toFloat();
                    pyResult = PyFloat_FromDouble(asFloat);
                } else if (typeObj == &PyBool_Type) {
                    if (out.toBool()) {
                        Py_INCREF(Py_True);
                        pyResult = Py_True;
                    } else {
                        Py_INCREF(Py_False);
                        pyResult = Py_False;
                    }
                } else {
                    // TODO: PyDict_Type and PyTuple_Type
                    PyErr_SetString(PyExc_TypeError,
                                    "Invalid type parameter.\n"
                                    "\tUse 'list', 'bytes', 'str', 'int', 'float', 'bool', "
                                    "or a Qt-derived type");
                    return nullptr;
                }
            }
            else {
                if (!out.isValid()) {
                    Py_INCREF(Py_None);
                    pyResult = Py_None;
                } else {
                    pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &out);
                }
            }
            // END of custom code block [file: ../glue/qtcore.cpp (qsettings-value)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSettingsFunc_value_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QSettings_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSettings_methods[] = {
    {"allKeys", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_allKeys), METH_NOARGS},
    {"applicationName", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_applicationName), METH_NOARGS},
    {"beginGroup", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_beginGroup), METH_O},
    {"beginReadArray", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_beginReadArray), METH_O},
    {"beginWriteArray", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_beginWriteArray), METH_VARARGS|METH_KEYWORDS},
    {"childGroups", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_childGroups), METH_NOARGS},
    {"childKeys", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_childKeys), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_clear), METH_NOARGS},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_contains), METH_O},
    {"defaultFormat", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_defaultFormat), METH_NOARGS|METH_STATIC},
    {"endArray", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_endArray), METH_NOARGS},
    {"endGroup", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_endGroup), METH_NOARGS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_event), METH_O},
    {"fallbacksEnabled", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_fallbacksEnabled), METH_NOARGS},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_fileName), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_format), METH_NOARGS},
    {"group", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_group), METH_NOARGS},
    {"iniCodec", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_iniCodec), METH_NOARGS},
    {"isAtomicSyncRequired", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_isAtomicSyncRequired), METH_NOARGS},
    {"isWritable", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_isWritable), METH_NOARGS},
    {"organizationName", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_organizationName), METH_NOARGS},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_remove), METH_O},
    {"scope", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_scope), METH_NOARGS},
    {"setArrayIndex", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_setArrayIndex), METH_O},
    {"setAtomicSyncRequired", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_setAtomicSyncRequired), METH_O},
    {"setDefaultFormat", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_setDefaultFormat), METH_O|METH_STATIC},
    {"setFallbacksEnabled", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_setFallbacksEnabled), METH_O},
    {"setIniCodec", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_setIniCodec), METH_O},
    {"setPath", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_setPath), METH_VARARGS|METH_STATIC},
    {"setValue", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_setValue), METH_VARARGS},
    {"status", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_status), METH_NOARGS},
    {"sync", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_sync), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QSettingsFunc_value), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSettings_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSettingsWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSettings_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSettings_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSettings_Type = nullptr;
static SbkObjectType *Sbk_QSettings_TypeF(void)
{
    return _Sbk_QSettings_Type;
}

static PyType_Slot Sbk_QSettings_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSettings_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSettings_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSettings_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSettings_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSettings_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSettings_spec = {
    "2:PySide2.QtCore.QSettings",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSettings_slots
};

} //extern "C"

static void *Sbk_QSettings_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QSettings *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QSettings_Status_PythonToCpp_QSettings_Status(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSettings::Status *>(cppOut) =
        static_cast<::QSettings::Status>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSettings_Status_PythonToCpp_QSettings_Status_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX]))
        return QSettings_Status_PythonToCpp_QSettings_Status;
    return {};
}
static PyObject *QSettings_Status_CppToPython_QSettings_Status(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSettings::Status *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX], castCppIn);

}

static void QSettings_Format_PythonToCpp_QSettings_Format(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSettings::Format *>(cppOut) =
        static_cast<::QSettings::Format>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSettings_Format_PythonToCpp_QSettings_Format_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX]))
        return QSettings_Format_PythonToCpp_QSettings_Format;
    return {};
}
static PyObject *QSettings_Format_CppToPython_QSettings_Format(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSettings::Format *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX], castCppIn);

}

static void QSettings_Scope_PythonToCpp_QSettings_Scope(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSettings::Scope *>(cppOut) =
        static_cast<::QSettings::Scope>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSettings_Scope_PythonToCpp_QSettings_Scope_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX]))
        return QSettings_Scope_PythonToCpp_QSettings_Scope;
    return {};
}
static PyObject *QSettings_Scope_CppToPython_QSettings_Scope(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSettings::Scope *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSettings_PythonToCpp_QSettings_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSettings_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSettings_PythonToCpp_QSettings_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSettings_TypeF())))
        return QSettings_PythonToCpp_QSettings_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSettings_PTR_CppToPython_QSettings(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QSettings *>(const_cast<void *>(cppIn)), Sbk_QSettings_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSettings_SignatureStrings[] = {
    "5:PySide2.QtCore.QSettings(self,parent:PySide2.QtCore.QObject=nullptr)",
    "4:PySide2.QtCore.QSettings(self,format:PySide2.QtCore.QSettings.Format,scope:PySide2.QtCore.QSettings.Scope,organization:QString,application:QString=QString(),parent:PySide2.QtCore.QObject=nullptr)",
    "3:PySide2.QtCore.QSettings(self,scope:PySide2.QtCore.QSettings.Scope,parent:PySide2.QtCore.QObject=nullptr)",
    "2:PySide2.QtCore.QSettings(self,scope:PySide2.QtCore.QSettings.Scope,organization:QString,application:QString=QString(),parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtCore.QSettings(self,fileName:QString,format:PySide2.QtCore.QSettings.Format,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtCore.QSettings(self,organization:QString,application:QString=QString(),parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtCore.QSettings.allKeys(self)->QStringList",
    "PySide2.QtCore.QSettings.applicationName(self)->QString",
    "PySide2.QtCore.QSettings.beginGroup(self,prefix:QString)",
    "PySide2.QtCore.QSettings.beginReadArray(self,prefix:QString)->int",
    "PySide2.QtCore.QSettings.beginWriteArray(self,prefix:QString,size:int=-1)",
    "PySide2.QtCore.QSettings.childGroups(self)->QStringList",
    "PySide2.QtCore.QSettings.childKeys(self)->QStringList",
    "PySide2.QtCore.QSettings.clear(self)",
    "PySide2.QtCore.QSettings.contains(self,key:QString)->bool",
    "PySide2.QtCore.QSettings.defaultFormat()->PySide2.QtCore.QSettings.Format",
    "PySide2.QtCore.QSettings.endArray(self)",
    "PySide2.QtCore.QSettings.endGroup(self)",
    "PySide2.QtCore.QSettings.event(self,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtCore.QSettings.fallbacksEnabled(self)->bool",
    "PySide2.QtCore.QSettings.fileName(self)->QString",
    "PySide2.QtCore.QSettings.format(self)->PySide2.QtCore.QSettings.Format",
    "PySide2.QtCore.QSettings.group(self)->QString",
    "PySide2.QtCore.QSettings.iniCodec(self)->PySide2.QtCore.QTextCodec",
    "PySide2.QtCore.QSettings.isAtomicSyncRequired(self)->bool",
    "PySide2.QtCore.QSettings.isWritable(self)->bool",
    "PySide2.QtCore.QSettings.organizationName(self)->QString",
    "PySide2.QtCore.QSettings.remove(self,key:QString)",
    "PySide2.QtCore.QSettings.scope(self)->PySide2.QtCore.QSettings.Scope",
    "PySide2.QtCore.QSettings.setArrayIndex(self,i:int)",
    "PySide2.QtCore.QSettings.setAtomicSyncRequired(self,enable:bool)",
    "PySide2.QtCore.QSettings.setDefaultFormat(format:PySide2.QtCore.QSettings.Format)",
    "PySide2.QtCore.QSettings.setFallbacksEnabled(self,b:bool)",
    "1:PySide2.QtCore.QSettings.setIniCodec(self,codec:PySide2.QtCore.QTextCodec)",
    "0:PySide2.QtCore.QSettings.setIniCodec(self,codecName:char*)",
    "PySide2.QtCore.QSettings.setPath(format:PySide2.QtCore.QSettings.Format,scope:PySide2.QtCore.QSettings.Scope,path:QString)",
    "PySide2.QtCore.QSettings.setValue(self,key:QString,value:QVariant)",
    "PySide2.QtCore.QSettings.status(self)->PySide2.QtCore.QSettings.Status",
    "PySide2.QtCore.QSettings.sync(self)",
    "PySide2.QtCore.QSettings.value(self,arg__1:QString,defaultValue:QVariant=0,type:PyObject=0)->PyObject",
    nullptr}; // Sentinel

void init_QSettings(PyObject *module)
{
    _Sbk_QSettings_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSettings",
        "QSettings*",
        &Sbk_QSettings_spec,
        &Shiboken::callCppDestructor< ::QSettings >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSettings_Type);
    InitSignatureStrings(pyType, QSettings_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSettings_Type), Sbk_QSettings_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QSETTINGS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSettings_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSettings_TypeF(),
        QSettings_PythonToCpp_QSettings_PTR,
        is_QSettings_PythonToCpp_QSettings_PTR_Convertible,
        QSettings_PTR_CppToPython_QSettings);

    Shiboken::Conversions::registerConverterName(converter, "QSettings");
    Shiboken::Conversions::registerConverterName(converter, "QSettings*");
    Shiboken::Conversions::registerConverterName(converter, "QSettings&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSettings).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSettingsWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSettings_TypeF(), &Sbk_QSettings_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Status'.
    SbkPySide2_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSettings_TypeF(),
        "Status",
        "2:PySide2.QtCore.QSettings.Status",
        "QSettings::Status");
    if (!SbkPySide2_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX],
        Sbk_QSettings_TypeF(), "NoError", (long) QSettings::Status::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX],
        Sbk_QSettings_TypeF(), "AccessError", (long) QSettings::Status::AccessError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX],
        Sbk_QSettings_TypeF(), "FormatError", (long) QSettings::Status::FormatError))
        return;
    // Register converter for enum 'QSettings::Status'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX],
            QSettings_Status_CppToPython_QSettings_Status);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSettings_Status_PythonToCpp_QSettings_Status,
            is_QSettings_Status_PythonToCpp_QSettings_Status_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSettings::Status");
        Shiboken::Conversions::registerConverterName(converter, "Status");
    }
    // End of 'Status' enum.

    // Initialization of enum 'Format'.
    SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSettings_TypeF(),
        "Format",
        "2:PySide2.QtCore.QSettings.Format",
        "QSettings::Format");
    if (!SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "NativeFormat", (long) QSettings::Format::NativeFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "IniFormat", (long) QSettings::Format::IniFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "InvalidFormat", (long) QSettings::Format::InvalidFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat1", (long) QSettings::Format::CustomFormat1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat2", (long) QSettings::Format::CustomFormat2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat3", (long) QSettings::Format::CustomFormat3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat4", (long) QSettings::Format::CustomFormat4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat5", (long) QSettings::Format::CustomFormat5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat6", (long) QSettings::Format::CustomFormat6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat7", (long) QSettings::Format::CustomFormat7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat8", (long) QSettings::Format::CustomFormat8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat9", (long) QSettings::Format::CustomFormat9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat10", (long) QSettings::Format::CustomFormat10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat11", (long) QSettings::Format::CustomFormat11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat12", (long) QSettings::Format::CustomFormat12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat13", (long) QSettings::Format::CustomFormat13))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat14", (long) QSettings::Format::CustomFormat14))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat15", (long) QSettings::Format::CustomFormat15))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
        Sbk_QSettings_TypeF(), "CustomFormat16", (long) QSettings::Format::CustomFormat16))
        return;
    // Register converter for enum 'QSettings::Format'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX],
            QSettings_Format_CppToPython_QSettings_Format);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSettings_Format_PythonToCpp_QSettings_Format,
            is_QSettings_Format_PythonToCpp_QSettings_Format_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSettings::Format");
        Shiboken::Conversions::registerConverterName(converter, "Format");
    }
    // End of 'Format' enum.

    // Initialization of enum 'Scope'.
    SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSettings_TypeF(),
        "Scope",
        "2:PySide2.QtCore.QSettings.Scope",
        "QSettings::Scope");
    if (!SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX],
        Sbk_QSettings_TypeF(), "UserScope", (long) QSettings::Scope::UserScope))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX],
        Sbk_QSettings_TypeF(), "SystemScope", (long) QSettings::Scope::SystemScope))
        return;
    // Register converter for enum 'QSettings::Scope'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX],
            QSettings_Scope_CppToPython_QSettings_Scope);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSettings_Scope_PythonToCpp_QSettings_Scope,
            is_QSettings_Scope_PythonToCpp_QSettings_Scope_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSettings::Scope");
        Shiboken::Conversions::registerConverterName(converter, "Scope");
    }
    // End of 'Scope' enum.

    PySide::Signal::registerSignals(Sbk_QSettings_TypeF(), &::QSettings::staticMetaObject);
    qRegisterMetaType< ::QSettings::Status >("QSettings::Status");
    qRegisterMetaType< ::QSettings::Format >("QSettings::Format");
    qRegisterMetaType< ::QSettings::Scope >("QSettings::Scope");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QSettings_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QSettings_TypeF(), &::QSettings::staticMetaObject, sizeof(QSettingsWrapper));
}
