/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qregularexpression_wrapper.h"

// inner classes

// Extra includes
#include <qregularexpression.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRegularExpression_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRegularExpression >()))
        return -1;

    ::QRegularExpression *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegularExpression_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QRegularExpression", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QRegularExpression::QRegularExpression()
    // 1: QRegularExpression::QRegularExpression(QRegularExpression)
    // 2: QRegularExpression::QRegularExpression(QString,QFlags<QRegularExpression::PatternOption>)
    if (numArgs == 0) {
        overloadId = 0; // QRegularExpression()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QRegularExpression(QString,QFlags<QRegularExpression::PatternOption>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 2; // QRegularExpression(QString,QFlags<QRegularExpression::PatternOption>)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QRegularExpression(QRegularExpression)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpression_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QRegularExpression()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRegularExpression_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QRegularExpression()
                cptr = new ::QRegularExpression();
            }
            break;
        }
        case 1: // QRegularExpression(const QRegularExpression & re)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRegularExpression_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRegularExpression cppArg0_local;
            ::QRegularExpression *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QRegularExpression(QRegularExpression)
                cptr = new ::QRegularExpression(*cppArg0);
            }
            break;
        }
        case 2: // QRegularExpression(const QString & pattern, QFlags<QRegularExpression::PatternOption> options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[1]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpression_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QRegularExpression_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRegularExpression_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QRegularExpression::PatternOption> cppArg1 = QRegularExpression::NoPatternOption;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QRegularExpression(QString,QFlags<QRegularExpression::PatternOption>)
                cptr = new ::QRegularExpression(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRegularExpression >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRegularExpression_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QRegularExpression_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRegularExpressionFunc_anchoredPattern(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.anchoredPattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QRegularExpression::anchoredPattern(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // anchoredPattern(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionFunc_anchoredPattern_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // anchoredPattern(QString)
            QString cppResult = ::QRegularExpression::anchoredPattern(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegularExpressionFunc_anchoredPattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionFunc_captureCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.captureCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // captureCount()const
            int cppResult = const_cast<const ::QRegularExpression *>(cppSelf)->captureCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QRegularExpression *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionFunc_escape(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.escape";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QRegularExpression::escape(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // escape(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionFunc_escape_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // escape(QString)
            QString cppResult = ::QRegularExpression::escape(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegularExpressionFunc_escape_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionFunc_globalMatch(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.globalMatch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:globalMatch", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QRegularExpression::globalMatch(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
    // 1: QRegularExpression::globalMatch(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // globalMatch(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // globalMatch(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // globalMatch(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 1; // globalMatch(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // globalMatch(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // globalMatch(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // globalMatch(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 0; // globalMatch(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // globalMatch(const QString & subject, int offset, QRegularExpression::MatchType matchType, QFlags<QRegularExpression::MatchOption> matchOptions) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
                if (PyDict_Contains(kwds, key_offset)) {
                    value = PyDict_GetItem(kwds, key_offset);
                    if (value && pyArgs[1]) {
                        errInfo = key_offset;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offset);
                }
                static PyObject *const key_matchType = Shiboken::String::createStaticString("matchType");
                if (PyDict_Contains(kwds, key_matchType)) {
                    value = PyDict_GetItem(kwds, key_matchType);
                    if (value && pyArgs[2]) {
                        errInfo = key_matchType;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchType);
                }
                static PyObject *const key_matchOptions = Shiboken::String::createStaticString("matchOptions");
                if (PyDict_Contains(kwds, key_matchOptions)) {
                    value = PyDict_GetItem(kwds, key_matchOptions);
                    if (value && pyArgs[3]) {
                        errInfo = key_matchOptions;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchOptions);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QRegularExpression::MatchType cppArg2 = QRegularExpression::MatchType::NormalMatch;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<QRegularExpression::MatchOption> cppArg3 = QRegularExpression::NoMatchOption;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // globalMatch(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                QRegularExpressionMatchIterator cppResult = const_cast<const ::QRegularExpression *>(cppSelf)->globalMatch(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX]), &cppResult);
            }
            break;
        }
        case 1: // globalMatch(const QStringRef & subjectRef, int offset, QRegularExpression::MatchType matchType, QFlags<QRegularExpression::MatchOption> matchOptions) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
                if (PyDict_Contains(kwds, key_offset)) {
                    value = PyDict_GetItem(kwds, key_offset);
                    if (value && pyArgs[1]) {
                        errInfo = key_offset;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offset);
                }
                static PyObject *const key_matchType = Shiboken::String::createStaticString("matchType");
                if (PyDict_Contains(kwds, key_matchType)) {
                    value = PyDict_GetItem(kwds, key_matchType);
                    if (value && pyArgs[2]) {
                        errInfo = key_matchType;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchType);
                }
                static PyObject *const key_matchOptions = Shiboken::String::createStaticString("matchOptions");
                if (PyDict_Contains(kwds, key_matchOptions)) {
                    value = PyDict_GetItem(kwds, key_matchOptions);
                    if (value && pyArgs[3]) {
                        errInfo = key_matchOptions;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchOptions);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRegularExpressionFunc_globalMatch_TypeError;
                }
            }
            ::QStringRef cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QRegularExpression::MatchType cppArg2 = QRegularExpression::MatchType::NormalMatch;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<QRegularExpression::MatchOption> cppArg3 = QRegularExpression::NoMatchOption;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // globalMatch(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                QRegularExpressionMatchIterator cppResult = const_cast<const ::QRegularExpression *>(cppSelf)->globalMatch(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCHITERATOR_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegularExpressionFunc_globalMatch_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QRegularExpression *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionFunc_match(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.match";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRegularExpressionFunc_match_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRegularExpressionFunc_match_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:match", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QRegularExpression::match(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
    // 1: QRegularExpression::match(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // match(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // match(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // match(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 1; // match(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // match(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // match(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // match(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 0; // match(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionFunc_match_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // match(const QString & subject, int offset, QRegularExpression::MatchType matchType, QFlags<QRegularExpression::MatchOption> matchOptions) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
                if (PyDict_Contains(kwds, key_offset)) {
                    value = PyDict_GetItem(kwds, key_offset);
                    if (value && pyArgs[1]) {
                        errInfo = key_offset;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offset);
                }
                static PyObject *const key_matchType = Shiboken::String::createStaticString("matchType");
                if (PyDict_Contains(kwds, key_matchType)) {
                    value = PyDict_GetItem(kwds, key_matchType);
                    if (value && pyArgs[2]) {
                        errInfo = key_matchType;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchType);
                }
                static PyObject *const key_matchOptions = Shiboken::String::createStaticString("matchOptions");
                if (PyDict_Contains(kwds, key_matchOptions)) {
                    value = PyDict_GetItem(kwds, key_matchOptions);
                    if (value && pyArgs[3]) {
                        errInfo = key_matchOptions;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchOptions);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRegularExpressionFunc_match_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QRegularExpression::MatchType cppArg2 = QRegularExpression::MatchType::NormalMatch;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<QRegularExpression::MatchOption> cppArg3 = QRegularExpression::NoMatchOption;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // match(QString,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                QRegularExpressionMatch cppResult = const_cast<const ::QRegularExpression *>(cppSelf)->match(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX]), &cppResult);
            }
            break;
        }
        case 1: // match(const QStringRef & subjectRef, int offset, QRegularExpression::MatchType matchType, QFlags<QRegularExpression::MatchOption> matchOptions) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
                if (PyDict_Contains(kwds, key_offset)) {
                    value = PyDict_GetItem(kwds, key_offset);
                    if (value && pyArgs[1]) {
                        errInfo = key_offset;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offset);
                }
                static PyObject *const key_matchType = Shiboken::String::createStaticString("matchType");
                if (PyDict_Contains(kwds, key_matchType)) {
                    value = PyDict_GetItem(kwds, key_matchType);
                    if (value && pyArgs[2]) {
                        errInfo = key_matchType;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchType);
                }
                static PyObject *const key_matchOptions = Shiboken::String::createStaticString("matchOptions");
                if (PyDict_Contains(kwds, key_matchOptions)) {
                    value = PyDict_GetItem(kwds, key_matchOptions);
                    if (value && pyArgs[3]) {
                        errInfo = key_matchOptions;
                        Py_INCREF(errInfo);
                        goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QRegularExpressionFunc_match_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_matchOptions);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRegularExpressionFunc_match_TypeError;
                }
            }
            ::QStringRef cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QRegularExpression::MatchType cppArg2 = QRegularExpression::MatchType::NormalMatch;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<QRegularExpression::MatchOption> cppArg3 = QRegularExpression::NoMatchOption;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // match(QStringRef,int,QRegularExpression::MatchType,QFlags<QRegularExpression::MatchOption>)const
                QRegularExpressionMatch cppResult = const_cast<const ::QRegularExpression *>(cppSelf)->match(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSIONMATCH_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegularExpressionFunc_match_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionFunc_namedCaptureGroups(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.namedCaptureGroups";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // namedCaptureGroups()const
            QStringList cppResult = const_cast<const ::QRegularExpression *>(cppSelf)->namedCaptureGroups();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionFunc_optimize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.optimize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // optimize()const
            const_cast<const ::QRegularExpression *>(cppSelf)->optimize();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QRegularExpressionFunc_pattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.pattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pattern()const
            QString cppResult = const_cast<const ::QRegularExpression *>(cppSelf)->pattern();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionFunc_patternErrorOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.patternErrorOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // patternErrorOffset()const
            int cppResult = const_cast<const ::QRegularExpression *>(cppSelf)->patternErrorOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionFunc_patternOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.patternOptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // patternOptions()const
            QFlags<QRegularExpression::PatternOption> cppResult = const_cast<const ::QRegularExpression *>(cppSelf)->patternOptions();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRegularExpressionFunc_setPattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.setPattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRegularExpression::setPattern(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPattern(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionFunc_setPattern_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPattern(QString)
            cppSelf->setPattern(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRegularExpressionFunc_setPattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionFunc_setPatternOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.setPatternOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRegularExpression::setPatternOptions(QFlags<QRegularExpression::PatternOption>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPatternOptions(QFlags<QRegularExpression::PatternOption>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionFunc_setPatternOptions_TypeError;

    // Call function/method
    {
        ::QFlags<QRegularExpression::PatternOption> cppArg0 = QFlags<QRegularExpression::PatternOption>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPatternOptions(QFlags<QRegularExpression::PatternOption>)
            cppSelf->setPatternOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRegularExpressionFunc_setPatternOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRegularExpression::swap(QRegularExpression&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QRegularExpression&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRegularExpression cppArg0_local;
        ::QRegularExpression *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QRegularExpression&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRegularExpressionFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpressionFunc_wildcardToRegularExpression(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QRegularExpression.wildcardToRegularExpression";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QRegularExpression::wildcardToRegularExpression(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // wildcardToRegularExpression(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRegularExpressionFunc_wildcardToRegularExpression_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // wildcardToRegularExpression(QString)
            QString cppResult = ::QRegularExpression::wildcardToRegularExpression(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRegularExpressionFunc_wildcardToRegularExpression_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRegularExpression___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QRegularExpression_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRegularExpression_methods[] = {
    {"anchoredPattern", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_anchoredPattern), METH_O|METH_STATIC},
    {"captureCount", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_captureCount), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_errorString), METH_NOARGS},
    {"escape", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_escape), METH_O|METH_STATIC},
    {"globalMatch", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_globalMatch), METH_VARARGS|METH_KEYWORDS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_isValid), METH_NOARGS},
    {"match", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_match), METH_VARARGS|METH_KEYWORDS},
    {"namedCaptureGroups", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_namedCaptureGroups), METH_NOARGS},
    {"optimize", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_optimize), METH_NOARGS},
    {"pattern", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_pattern), METH_NOARGS},
    {"patternErrorOffset", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_patternErrorOffset), METH_NOARGS},
    {"patternOptions", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_patternOptions), METH_NOARGS},
    {"setPattern", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_setPattern), METH_O},
    {"setPatternOptions", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_setPatternOptions), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_swap), METH_O},
    {"wildcardToRegularExpression", reinterpret_cast<PyCFunction>(Sbk_QRegularExpressionFunc_wildcardToRegularExpression), METH_O|METH_STATIC},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QRegularExpression___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QRegularExpression_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), (pyArg)))) {
                // operator!=(const QRegularExpression & re) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRegularExpression cppArg0_local;
                ::QRegularExpression *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), (pyArg)))) {
                // operator==(const QRegularExpression & re) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRegularExpression cppArg0_local;
                ::QRegularExpression *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QRegularExpression_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QRegularExpression_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QRegularExpression_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRegularExpression_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QRegularExpression__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRegularExpression_Type = nullptr;
static SbkObjectType *Sbk_QRegularExpression_TypeF(void)
{
    return _Sbk_QRegularExpression_Type;
}

static PyType_Slot Sbk_QRegularExpression_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QRegularExpression__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRegularExpression_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRegularExpression_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QRegularExpression_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRegularExpression_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRegularExpression_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRegularExpression_spec = {
    "2:PySide2.QtCore.QRegularExpression",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRegularExpression_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QRegularExpression_PatternOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QRegularExpression::PatternOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QRegularExpression::PatternOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QRegularExpression::PatternOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QRegularExpression::PatternOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QRegularExpression::PatternOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QRegularExpression_PatternOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QRegularExpression::PatternOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QRegularExpression::PatternOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QRegularExpression::PatternOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QRegularExpression::PatternOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QRegularExpression::PatternOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QRegularExpression_PatternOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QRegularExpression::PatternOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QRegularExpression::PatternOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QRegularExpression::PatternOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QRegularExpression::PatternOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QRegularExpression::PatternOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QRegularExpression_PatternOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QRegularExpression::PatternOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX])->converter, self, &cppSelf);
    ::QRegularExpression::PatternOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QRegularExpression_PatternOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QRegularExpression_PatternOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QRegularExpression_PatternOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_PatternOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_PatternOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_PatternOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_PatternOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_PatternOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_PatternOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_PatternOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_PatternOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_PatternOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_PatternOption_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_QRegularExpression_MatchOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QRegularExpression::MatchOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QRegularExpression::MatchOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QRegularExpression::MatchOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QRegularExpression::MatchOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QRegularExpression::MatchOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QRegularExpression_MatchOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QRegularExpression::MatchOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QRegularExpression::MatchOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QRegularExpression::MatchOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QRegularExpression::MatchOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QRegularExpression::MatchOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QRegularExpression_MatchOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QRegularExpression::MatchOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QRegularExpression::MatchOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QRegularExpression::MatchOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QRegularExpression::MatchOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QRegularExpression::MatchOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QRegularExpression_MatchOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QRegularExpression::MatchOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, self, &cppSelf);
    ::QRegularExpression::MatchOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QRegularExpression_MatchOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QRegularExpression_MatchOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QRegularExpression_MatchOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_MatchOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_MatchOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_MatchOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_MatchOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_MatchOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_MatchOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_MatchOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_MatchOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_MatchOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QRegularExpression_MatchOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QRegularExpression_PatternOption_PythonToCpp_QRegularExpression_PatternOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRegularExpression::PatternOption *>(cppOut) =
        static_cast<::QRegularExpression::PatternOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRegularExpression_PatternOption_PythonToCpp_QRegularExpression_PatternOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX]))
        return QRegularExpression_PatternOption_PythonToCpp_QRegularExpression_PatternOption;
    return {};
}
static PyObject *QRegularExpression_PatternOption_CppToPython_QRegularExpression_PatternOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRegularExpression::PatternOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX], castCppIn);

}

static void QFlags_QRegularExpression_PatternOption__PythonToCpp_QFlags_QRegularExpression_PatternOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QRegularExpression::PatternOption> *>(cppOut) =
        ::QFlags<QRegularExpression::PatternOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QRegularExpression_PatternOption__PythonToCpp_QFlags_QRegularExpression_PatternOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX]))
        return QFlags_QRegularExpression_PatternOption__PythonToCpp_QFlags_QRegularExpression_PatternOption_;
    return {};
}
static PyObject *QFlags_QRegularExpression_PatternOption__CppToPython_QFlags_QRegularExpression_PatternOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QRegularExpression::PatternOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX]));

}

static void QRegularExpression_PatternOption_PythonToCpp_QFlags_QRegularExpression_PatternOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QRegularExpression::PatternOption> *>(cppOut) =
        ::QFlags<QRegularExpression::PatternOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QRegularExpression_PatternOption_PythonToCpp_QFlags_QRegularExpression_PatternOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX]))
        return QRegularExpression_PatternOption_PythonToCpp_QFlags_QRegularExpression_PatternOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QRegularExpression_PatternOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QRegularExpression::PatternOption> *>(cppOut) =
        ::QFlags<QRegularExpression::PatternOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QRegularExpression_PatternOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX]))
        return number_PythonToCpp_QFlags_QRegularExpression_PatternOption_;
    return {};
}
static void QRegularExpression_MatchType_PythonToCpp_QRegularExpression_MatchType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRegularExpression::MatchType *>(cppOut) =
        static_cast<::QRegularExpression::MatchType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRegularExpression_MatchType_PythonToCpp_QRegularExpression_MatchType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX]))
        return QRegularExpression_MatchType_PythonToCpp_QRegularExpression_MatchType;
    return {};
}
static PyObject *QRegularExpression_MatchType_CppToPython_QRegularExpression_MatchType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRegularExpression::MatchType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX], castCppIn);

}

static void QRegularExpression_MatchOption_PythonToCpp_QRegularExpression_MatchOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRegularExpression::MatchOption *>(cppOut) =
        static_cast<::QRegularExpression::MatchOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRegularExpression_MatchOption_PythonToCpp_QRegularExpression_MatchOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHOPTION_IDX]))
        return QRegularExpression_MatchOption_PythonToCpp_QRegularExpression_MatchOption;
    return {};
}
static PyObject *QRegularExpression_MatchOption_CppToPython_QRegularExpression_MatchOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRegularExpression::MatchOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHOPTION_IDX], castCppIn);

}

static void QFlags_QRegularExpression_MatchOption__PythonToCpp_QFlags_QRegularExpression_MatchOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QRegularExpression::MatchOption> *>(cppOut) =
        ::QFlags<QRegularExpression::MatchOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QRegularExpression_MatchOption__PythonToCpp_QFlags_QRegularExpression_MatchOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX]))
        return QFlags_QRegularExpression_MatchOption__PythonToCpp_QFlags_QRegularExpression_MatchOption_;
    return {};
}
static PyObject *QFlags_QRegularExpression_MatchOption__CppToPython_QFlags_QRegularExpression_MatchOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QRegularExpression::MatchOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX]));

}

static void QRegularExpression_MatchOption_PythonToCpp_QFlags_QRegularExpression_MatchOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QRegularExpression::MatchOption> *>(cppOut) =
        ::QFlags<QRegularExpression::MatchOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QRegularExpression_MatchOption_PythonToCpp_QFlags_QRegularExpression_MatchOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHOPTION_IDX]))
        return QRegularExpression_MatchOption_PythonToCpp_QFlags_QRegularExpression_MatchOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QRegularExpression_MatchOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QRegularExpression::MatchOption> *>(cppOut) =
        ::QFlags<QRegularExpression::MatchOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QRegularExpression_MatchOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHOPTION_IDX]))
        return number_PythonToCpp_QFlags_QRegularExpression_MatchOption_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRegularExpression_PythonToCpp_QRegularExpression_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRegularExpression_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRegularExpression_PythonToCpp_QRegularExpression_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRegularExpression_TypeF())))
        return QRegularExpression_PythonToCpp_QRegularExpression_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRegularExpression_PTR_CppToPython_QRegularExpression(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QRegularExpression *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QRegularExpression_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QRegularExpression_COPY_CppToPython_QRegularExpression(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QRegularExpression_TypeF(), new ::QRegularExpression(*reinterpret_cast<const ::QRegularExpression *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QRegularExpression_PythonToCpp_QRegularExpression_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRegularExpression *>(cppOut) = *reinterpret_cast< ::QRegularExpression *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QRegularExpression_PythonToCpp_QRegularExpression_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRegularExpression_TypeF())))
        return QRegularExpression_PythonToCpp_QRegularExpression_COPY;
    return {};
}

// Implicit conversions.
static void constQStringREF_PythonToCpp_QRegularExpression(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QRegularExpression *>(cppOut) = ::QRegularExpression(cppIn);
}
static PythonToCppFunc is_constQStringREF_PythonToCpp_QRegularExpression_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constQStringREF_PythonToCpp_QRegularExpression;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRegularExpression_SignatureStrings[] = {
    "2:PySide2.QtCore.QRegularExpression(self)",
    "1:PySide2.QtCore.QRegularExpression(self,re:PySide2.QtCore.QRegularExpression)",
    "0:PySide2.QtCore.QRegularExpression(self,pattern:QString,options:PySide2.QtCore.QRegularExpression.PatternOptions=QRegularExpression.NoPatternOption)",
    "PySide2.QtCore.QRegularExpression.anchoredPattern(expression:QString)->QString",
    "PySide2.QtCore.QRegularExpression.captureCount(self)->int",
    "PySide2.QtCore.QRegularExpression.errorString(self)->QString",
    "PySide2.QtCore.QRegularExpression.escape(str:QString)->QString",
    "1:PySide2.QtCore.QRegularExpression.globalMatch(self,subject:QString,offset:int=0,matchType:PySide2.QtCore.QRegularExpression.MatchType=NormalMatch,matchOptions:PySide2.QtCore.QRegularExpression.MatchOptions=QRegularExpression.NoMatchOption)->PySide2.QtCore.QRegularExpressionMatchIterator",
    "0:PySide2.QtCore.QRegularExpression.globalMatch(self,subjectRef:QStringRef,offset:int=0,matchType:PySide2.QtCore.QRegularExpression.MatchType=NormalMatch,matchOptions:PySide2.QtCore.QRegularExpression.MatchOptions=QRegularExpression.NoMatchOption)->PySide2.QtCore.QRegularExpressionMatchIterator",
    "PySide2.QtCore.QRegularExpression.isValid(self)->bool",
    "1:PySide2.QtCore.QRegularExpression.match(self,subject:QString,offset:int=0,matchType:PySide2.QtCore.QRegularExpression.MatchType=NormalMatch,matchOptions:PySide2.QtCore.QRegularExpression.MatchOptions=QRegularExpression.NoMatchOption)->PySide2.QtCore.QRegularExpressionMatch",
    "0:PySide2.QtCore.QRegularExpression.match(self,subjectRef:QStringRef,offset:int=0,matchType:PySide2.QtCore.QRegularExpression.MatchType=NormalMatch,matchOptions:PySide2.QtCore.QRegularExpression.MatchOptions=QRegularExpression.NoMatchOption)->PySide2.QtCore.QRegularExpressionMatch",
    "PySide2.QtCore.QRegularExpression.namedCaptureGroups(self)->QStringList",
    "PySide2.QtCore.QRegularExpression.optimize(self)",
    "PySide2.QtCore.QRegularExpression.pattern(self)->QString",
    "PySide2.QtCore.QRegularExpression.patternErrorOffset(self)->int",
    "PySide2.QtCore.QRegularExpression.patternOptions(self)->PySide2.QtCore.QRegularExpression.PatternOptions",
    "PySide2.QtCore.QRegularExpression.setPattern(self,pattern:QString)",
    "PySide2.QtCore.QRegularExpression.setPatternOptions(self,options:PySide2.QtCore.QRegularExpression.PatternOptions)",
    "PySide2.QtCore.QRegularExpression.swap(self,other:PySide2.QtCore.QRegularExpression)",
    "PySide2.QtCore.QRegularExpression.wildcardToRegularExpression(str:QString)->QString",
    "PySide2.QtCore.QRegularExpression.__copy__()",
    nullptr}; // Sentinel

void init_QRegularExpression(PyObject *module)
{
    _Sbk_QRegularExpression_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRegularExpression",
        "QRegularExpression",
        &Sbk_QRegularExpression_spec,
        &Shiboken::callCppDestructor< ::QRegularExpression >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRegularExpression_Type);
    InitSignatureStrings(pyType, QRegularExpression_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRegularExpression_Type), Sbk_QRegularExpression_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRegularExpression_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRegularExpression_TypeF(),
        QRegularExpression_PythonToCpp_QRegularExpression_PTR,
        is_QRegularExpression_PythonToCpp_QRegularExpression_PTR_Convertible,
        QRegularExpression_PTR_CppToPython_QRegularExpression,
        QRegularExpression_COPY_CppToPython_QRegularExpression);

    Shiboken::Conversions::registerConverterName(converter, "QRegularExpression");
    Shiboken::Conversions::registerConverterName(converter, "QRegularExpression*");
    Shiboken::Conversions::registerConverterName(converter, "QRegularExpression&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRegularExpression).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QRegularExpression_PythonToCpp_QRegularExpression_COPY,
        is_QRegularExpression_PythonToCpp_QRegularExpression_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQStringREF_PythonToCpp_QRegularExpression,
        is_constQStringREF_PythonToCpp_QRegularExpression_Convertible);

    // Initialization of enums.

    // Initialization of enum 'PatternOption'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QRegularExpression.PatternOptions", SbkPySide2_QtCore_QRegularExpression_PatternOption_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRegularExpression_TypeF(),
        "PatternOption",
        "2:PySide2.QtCore.QRegularExpression.PatternOption",
        "QRegularExpression::PatternOption",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "NoPatternOption", (long) QRegularExpression::PatternOption::NoPatternOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "CaseInsensitiveOption", (long) QRegularExpression::PatternOption::CaseInsensitiveOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "DotMatchesEverythingOption", (long) QRegularExpression::PatternOption::DotMatchesEverythingOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "MultilineOption", (long) QRegularExpression::PatternOption::MultilineOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "ExtendedPatternSyntaxOption", (long) QRegularExpression::PatternOption::ExtendedPatternSyntaxOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "InvertedGreedinessOption", (long) QRegularExpression::PatternOption::InvertedGreedinessOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "DontCaptureOption", (long) QRegularExpression::PatternOption::DontCaptureOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "UseUnicodePropertiesOption", (long) QRegularExpression::PatternOption::UseUnicodePropertiesOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "OptimizeOnFirstUsageOption", (long) QRegularExpression::PatternOption::OptimizeOnFirstUsageOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "DontAutomaticallyOptimizeOption", (long) QRegularExpression::PatternOption::DontAutomaticallyOptimizeOption))
        return;
    // Register converter for enum 'QRegularExpression::PatternOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX],
            QRegularExpression_PatternOption_CppToPython_QRegularExpression_PatternOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRegularExpression_PatternOption_PythonToCpp_QRegularExpression_PatternOption,
            is_QRegularExpression_PatternOption_PythonToCpp_QRegularExpression_PatternOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_PATTERNOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRegularExpression::PatternOption");
        Shiboken::Conversions::registerConverterName(converter, "PatternOption");
    }
    // Register converter for flag 'QFlags<QRegularExpression::PatternOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX],
            QFlags_QRegularExpression_PatternOption__CppToPython_QFlags_QRegularExpression_PatternOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRegularExpression_PatternOption_PythonToCpp_QFlags_QRegularExpression_PatternOption_,
            is_QRegularExpression_PatternOption_PythonToCpp_QFlags_QRegularExpression_PatternOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QRegularExpression_PatternOption__PythonToCpp_QFlags_QRegularExpression_PatternOption_,
            is_QFlags_QRegularExpression_PatternOption__PythonToCpp_QFlags_QRegularExpression_PatternOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QRegularExpression_PatternOption_,
            is_number_PythonToCpp_QFlags_QRegularExpression_PatternOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_PATTERNOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRegularExpression::PatternOptions");
        Shiboken::Conversions::registerConverterName(converter, "PatternOptions");
    }
    // End of 'PatternOption' enum/flags.

    // Initialization of enum 'MatchType'.
    SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRegularExpression_TypeF(),
        "MatchType",
        "2:PySide2.QtCore.QRegularExpression.MatchType",
        "QRegularExpression::MatchType");
    if (!SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX],
        Sbk_QRegularExpression_TypeF(), "NormalMatch", (long) QRegularExpression::MatchType::NormalMatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX],
        Sbk_QRegularExpression_TypeF(), "PartialPreferCompleteMatch", (long) QRegularExpression::MatchType::PartialPreferCompleteMatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX],
        Sbk_QRegularExpression_TypeF(), "PartialPreferFirstMatch", (long) QRegularExpression::MatchType::PartialPreferFirstMatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX],
        Sbk_QRegularExpression_TypeF(), "NoMatch", (long) QRegularExpression::MatchType::NoMatch))
        return;
    // Register converter for enum 'QRegularExpression::MatchType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX],
            QRegularExpression_MatchType_CppToPython_QRegularExpression_MatchType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRegularExpression_MatchType_PythonToCpp_QRegularExpression_MatchType,
            is_QRegularExpression_MatchType_PythonToCpp_QRegularExpression_MatchType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRegularExpression::MatchType");
        Shiboken::Conversions::registerConverterName(converter, "MatchType");
    }
    // End of 'MatchType' enum.

    // Initialization of enum 'MatchOption'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QRegularExpression.MatchOptions", SbkPySide2_QtCore_QRegularExpression_MatchOption_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRegularExpression_TypeF(),
        "MatchOption",
        "2:PySide2.QtCore.QRegularExpression.MatchOption",
        "QRegularExpression::MatchOption",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "NoMatchOption", (long) QRegularExpression::MatchOption::NoMatchOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "AnchoredMatchOption", (long) QRegularExpression::MatchOption::AnchoredMatchOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHOPTION_IDX],
        Sbk_QRegularExpression_TypeF(), "DontCheckSubjectStringMatchOption", (long) QRegularExpression::MatchOption::DontCheckSubjectStringMatchOption))
        return;
    // Register converter for enum 'QRegularExpression::MatchOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHOPTION_IDX],
            QRegularExpression_MatchOption_CppToPython_QRegularExpression_MatchOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRegularExpression_MatchOption_PythonToCpp_QRegularExpression_MatchOption,
            is_QRegularExpression_MatchOption_PythonToCpp_QRegularExpression_MatchOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_MATCHOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRegularExpression::MatchOption");
        Shiboken::Conversions::registerConverterName(converter, "MatchOption");
    }
    // Register converter for flag 'QFlags<QRegularExpression::MatchOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX],
            QFlags_QRegularExpression_MatchOption__CppToPython_QFlags_QRegularExpression_MatchOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRegularExpression_MatchOption_PythonToCpp_QFlags_QRegularExpression_MatchOption_,
            is_QRegularExpression_MatchOption_PythonToCpp_QFlags_QRegularExpression_MatchOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QRegularExpression_MatchOption__PythonToCpp_QFlags_QRegularExpression_MatchOption_,
            is_QFlags_QRegularExpression_MatchOption__PythonToCpp_QFlags_QRegularExpression_MatchOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QRegularExpression_MatchOption_,
            is_number_PythonToCpp_QFlags_QRegularExpression_MatchOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QREGULAREXPRESSION_MATCHOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRegularExpression::MatchOptions");
        Shiboken::Conversions::registerConverterName(converter, "MatchOptions");
    }
    // End of 'MatchOption' enum/flags.

    qRegisterMetaType< ::QRegularExpression >("QRegularExpression");
    qRegisterMetaType< ::QRegularExpression::PatternOption >("QRegularExpression::PatternOption");
    qRegisterMetaType< ::QRegularExpression::PatternOptions >("QRegularExpression::PatternOptions");
    qRegisterMetaType< ::QRegularExpression::MatchType >("QRegularExpression::MatchType");
    qRegisterMetaType< ::QRegularExpression::MatchOption >("QRegularExpression::MatchOption");
    qRegisterMetaType< ::QRegularExpression::MatchOptions >("QRegularExpression::MatchOptions");
}
