/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qreadwritelock_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QReadWriteLock_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QReadWriteLock >()))
        return -1;

    ::QReadWriteLock *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadWriteLock.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QReadWriteLock_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QReadWriteLock", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QReadWriteLock::QReadWriteLock(QReadWriteLock::RecursionMode)
    if (numArgs == 0) {
        overloadId = 0; // QReadWriteLock(QReadWriteLock::RecursionMode)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QReadWriteLock(QReadWriteLock::RecursionMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QReadWriteLock_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_recursionMode = Shiboken::String::createStaticString("recursionMode");
            if (PyDict_Contains(kwds, key_recursionMode)) {
                value = PyDict_GetItem(kwds, key_recursionMode);
                if (value && pyArgs[0]) {
                    errInfo = key_recursionMode;
                    Py_INCREF(errInfo);
                    goto Sbk_QReadWriteLock_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QReadWriteLock_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_recursionMode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QReadWriteLock_Init_TypeError;
            }
        }
        ::QReadWriteLock::RecursionMode cppArg0 = QReadWriteLock::RecursionMode::NonRecursive;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QReadWriteLock(QReadWriteLock::RecursionMode)
            cptr = new ::QReadWriteLock(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QReadWriteLock >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QReadWriteLock_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QReadWriteLock_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QReadWriteLockFunc_lockForRead(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QReadWriteLock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadWriteLock.lockForRead";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lockForRead()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->lockForRead();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QReadWriteLockFunc_lockForWrite(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QReadWriteLock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadWriteLock.lockForWrite";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lockForWrite()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->lockForWrite();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QReadWriteLockFunc_tryLockForRead(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QReadWriteLock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadWriteLock.tryLockForRead";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "tryLockForRead", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QReadWriteLock::tryLockForRead()
    // 1: QReadWriteLock::tryLockForRead(int)
    if (numArgs == 0) {
        overloadId = 0; // tryLockForRead()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // tryLockForRead(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QReadWriteLockFunc_tryLockForRead_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // tryLockForRead()
        {

            if (!PyErr_Occurred()) {
                // tryLockForRead()
                bool cppResult = cppSelf->tryLockForRead();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // tryLockForRead(int timeout)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // tryLockForRead(int)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->tryLockForRead(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QReadWriteLockFunc_tryLockForRead_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QReadWriteLockFunc_tryLockForWrite(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QReadWriteLock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadWriteLock.tryLockForWrite";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "tryLockForWrite", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QReadWriteLock::tryLockForWrite()
    // 1: QReadWriteLock::tryLockForWrite(int)
    if (numArgs == 0) {
        overloadId = 0; // tryLockForWrite()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // tryLockForWrite(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QReadWriteLockFunc_tryLockForWrite_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // tryLockForWrite()
        {

            if (!PyErr_Occurred()) {
                // tryLockForWrite()
                bool cppResult = cppSelf->tryLockForWrite();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // tryLockForWrite(int timeout)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // tryLockForWrite(int)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->tryLockForWrite(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QReadWriteLockFunc_tryLockForWrite_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QReadWriteLockFunc_unlock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QReadWriteLock *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QReadWriteLock.unlock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unlock()
            cppSelf->unlock();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QReadWriteLock_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QReadWriteLock_methods[] = {
    {"lockForRead", reinterpret_cast<PyCFunction>(Sbk_QReadWriteLockFunc_lockForRead), METH_NOARGS},
    {"lockForWrite", reinterpret_cast<PyCFunction>(Sbk_QReadWriteLockFunc_lockForWrite), METH_NOARGS},
    {"tryLockForRead", reinterpret_cast<PyCFunction>(Sbk_QReadWriteLockFunc_tryLockForRead), METH_VARARGS},
    {"tryLockForWrite", reinterpret_cast<PyCFunction>(Sbk_QReadWriteLockFunc_tryLockForWrite), METH_VARARGS},
    {"unlock", reinterpret_cast<PyCFunction>(Sbk_QReadWriteLockFunc_unlock), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QReadWriteLock_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QReadWriteLock_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QReadWriteLock_Type = nullptr;
static SbkObjectType *Sbk_QReadWriteLock_TypeF(void)
{
    return _Sbk_QReadWriteLock_Type;
}

static PyType_Slot Sbk_QReadWriteLock_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QReadWriteLock_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QReadWriteLock_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QReadWriteLock_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QReadWriteLock_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QReadWriteLock_spec = {
    "2:PySide2.QtCore.QReadWriteLock",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QReadWriteLock_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QReadWriteLock_RecursionMode_PythonToCpp_QReadWriteLock_RecursionMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QReadWriteLock::RecursionMode *>(cppOut) =
        static_cast<::QReadWriteLock::RecursionMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QReadWriteLock_RecursionMode_PythonToCpp_QReadWriteLock_RecursionMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX]))
        return QReadWriteLock_RecursionMode_PythonToCpp_QReadWriteLock_RecursionMode;
    return {};
}
static PyObject *QReadWriteLock_RecursionMode_CppToPython_QReadWriteLock_RecursionMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QReadWriteLock::RecursionMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QReadWriteLock_PythonToCpp_QReadWriteLock_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QReadWriteLock_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QReadWriteLock_PythonToCpp_QReadWriteLock_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QReadWriteLock_TypeF())))
        return QReadWriteLock_PythonToCpp_QReadWriteLock_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QReadWriteLock_PTR_CppToPython_QReadWriteLock(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QReadWriteLock *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QReadWriteLock_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QReadWriteLock_SignatureStrings[] = {
    "PySide2.QtCore.QReadWriteLock(self,recursionMode:PySide2.QtCore.QReadWriteLock.RecursionMode=NonRecursive)",
    "PySide2.QtCore.QReadWriteLock.lockForRead(self)",
    "PySide2.QtCore.QReadWriteLock.lockForWrite(self)",
    "1:PySide2.QtCore.QReadWriteLock.tryLockForRead(self)->bool",
    "0:PySide2.QtCore.QReadWriteLock.tryLockForRead(self,timeout:int)->bool",
    "1:PySide2.QtCore.QReadWriteLock.tryLockForWrite(self)->bool",
    "0:PySide2.QtCore.QReadWriteLock.tryLockForWrite(self,timeout:int)->bool",
    "PySide2.QtCore.QReadWriteLock.unlock(self)",
    nullptr}; // Sentinel

void init_QReadWriteLock(PyObject *module)
{
    _Sbk_QReadWriteLock_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QReadWriteLock",
        "QReadWriteLock*",
        &Sbk_QReadWriteLock_spec,
        &Shiboken::callCppDestructor< ::QReadWriteLock >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QReadWriteLock_Type);
    InitSignatureStrings(pyType, QReadWriteLock_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QReadWriteLock_Type), Sbk_QReadWriteLock_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QReadWriteLock_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QReadWriteLock_TypeF(),
        QReadWriteLock_PythonToCpp_QReadWriteLock_PTR,
        is_QReadWriteLock_PythonToCpp_QReadWriteLock_PTR_Convertible,
        QReadWriteLock_PTR_CppToPython_QReadWriteLock);

    Shiboken::Conversions::registerConverterName(converter, "QReadWriteLock");
    Shiboken::Conversions::registerConverterName(converter, "QReadWriteLock*");
    Shiboken::Conversions::registerConverterName(converter, "QReadWriteLock&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QReadWriteLock).name());


    // Initialization of enums.

    // Initialization of enum 'RecursionMode'.
    SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QReadWriteLock_TypeF(),
        "RecursionMode",
        "2:PySide2.QtCore.QReadWriteLock.RecursionMode",
        "QReadWriteLock::RecursionMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX],
        Sbk_QReadWriteLock_TypeF(), "NonRecursive", (long) QReadWriteLock::RecursionMode::NonRecursive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX],
        Sbk_QReadWriteLock_TypeF(), "Recursive", (long) QReadWriteLock::RecursionMode::Recursive))
        return;
    // Register converter for enum 'QReadWriteLock::RecursionMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX],
            QReadWriteLock_RecursionMode_CppToPython_QReadWriteLock_RecursionMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QReadWriteLock_RecursionMode_PythonToCpp_QReadWriteLock_RecursionMode,
            is_QReadWriteLock_RecursionMode_PythonToCpp_QReadWriteLock_RecursionMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QReadWriteLock::RecursionMode");
        Shiboken::Conversions::registerConverterName(converter, "RecursionMode");
    }
    // End of 'RecursionMode' enum.

    qRegisterMetaType< ::QReadWriteLock::RecursionMode >("QReadWriteLock::RecursionMode");
}
