/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qprocess_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QProcessWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QProcessWrapper::QProcessWrapper(::QObject * parent) : QProcess(parent)
{
    resetPyMethodCache();
    // ... middle
}

bool QProcessWrapper::atEnd() const
{
    if (m_PyMethodCache[0])
        return this->::QProcess::atEnd();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "atEnd";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QProcess::atEnd();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.atEnd", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QProcessWrapper::bytesAvailable() const
{
    if (m_PyMethodCache[1])
        return this->::QProcess::bytesAvailable();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesAvailable";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QProcess::bytesAvailable();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.bytesAvailable", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QProcessWrapper::bytesToWrite() const
{
    if (m_PyMethodCache[2])
        return this->::QProcess::bytesToWrite();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesToWrite";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QProcess::bytesToWrite();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.bytesToWrite", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QProcessWrapper::canReadLine() const
{
    if (m_PyMethodCache[3])
        return this->::QProcess::canReadLine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "canReadLine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QProcess::canReadLine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.canReadLine", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QProcessWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QProcessWrapper::close()
{
    if (m_PyMethodCache[5]) {
        return this->::QProcess::close();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "close";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QProcess::close();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QProcessWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QProcessWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QProcessWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QProcessWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[9])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QProcessWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[10])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QProcessWrapper::isSequential() const
{
    if (m_PyMethodCache[11])
        return this->::QProcess::isSequential();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isSequential";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QProcess::isSequential();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.isSequential", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QProcessWrapper::open(::QFlags<QIODevice::OpenModeFlag> mode)
{
    if (m_PyMethodCache[13])
        return this->::QProcess::open(mode);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "open";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QProcess::open(mode);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &mode)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.open", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QProcessWrapper::pos() const
{
    if (m_PyMethodCache[14])
        return this->::QIODevice::pos();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "pos";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QIODevice::pos();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.pos", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QProcessWrapper::readData(char * data, qint64 maxlen)
{
    if (m_PyMethodCache[15]) {
        return this->::QProcess::readData(data, maxlen);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QProcess::readData(data, maxlen);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

qint64 QProcessWrapper::readLineData(char * data, qint64 maxlen)
{
    if (m_PyMethodCache[16]) {
        return this->::QIODevice::readLineData(data, maxlen);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readLineData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QIODevice::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

bool QProcessWrapper::reset()
{
    if (m_PyMethodCache[17])
        return this->::QIODevice::reset();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "reset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QIODevice::reset();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.reset", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QProcessWrapper::seek(qint64 pos)
{
    if (m_PyMethodCache[18])
        return this->::QIODevice::seek(pos);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "seek";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QIODevice::seek(pos);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    pos
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.seek", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QProcessWrapper::setupChildProcess()
{
    if (m_PyMethodCache[19]) {
        return this->::QProcess::setupChildProcess();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setupChildProcess";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QProcess::setupChildProcess();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

qint64 QProcessWrapper::size() const
{
    if (m_PyMethodCache[20])
        return this->::QIODevice::size();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "size";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QIODevice::size();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.size", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QProcessWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[21]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QProcessWrapper::waitForBytesWritten(int msecs)
{
    if (m_PyMethodCache[22])
        return this->::QProcess::waitForBytesWritten(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForBytesWritten";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QProcess::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.waitForBytesWritten", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QProcessWrapper::waitForReadyRead(int msecs)
{
    if (m_PyMethodCache[23])
        return this->::QProcess::waitForReadyRead(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForReadyRead";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QProcess::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.waitForReadyRead", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QProcessWrapper::writeData(const char * data, qint64 len)
{
    if (m_PyMethodCache[24])
        return this->::QProcess::writeData(data, len);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "writeData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QProcess::writeData(data, len);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NL)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), data),
    len
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QProcess.writeData", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QProcessWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QProcess::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QProcessWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QProcess::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QProcessWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QProcessWrapper *>(this));
        return QProcess::qt_metacast(_clname);
}

QProcessWrapper::~QProcessWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QProcess_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QProcess >()))
        return -1;

    ::QProcessWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QProcess", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QProcess::QProcess(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QProcess(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QProcess(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcess_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QProcess_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QProcess_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QProcess(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QProcessWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QProcessWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QProcess >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QProcess_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QProcess_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QProcess_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QProcessFunc_arguments(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.arguments";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // arguments()const
            QStringList cppResult = const_cast<const ::QProcess *>(cppSelf)->arguments();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_atEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.atEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atEnd()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QProcess *>(cppSelf)->::QProcess::atEnd()
                : const_cast<const ::QProcess *>(cppSelf)->atEnd();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_bytesAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.bytesAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesAvailable()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QProcess *>(cppSelf)->::QProcess::bytesAvailable()
                : const_cast<const ::QProcess *>(cppSelf)->bytesAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_bytesToWrite(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.bytesToWrite";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesToWrite()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QProcess *>(cppSelf)->::QProcess::bytesToWrite()
                : const_cast<const ::QProcess *>(cppSelf)->bytesToWrite();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_canReadLine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.canReadLine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canReadLine()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QProcess *>(cppSelf)->::QProcess::canReadLine()
                : const_cast<const ::QProcess *>(cppSelf)->canReadLine();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_close(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.close";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // close()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QProcess::close()
                : cppSelf->close();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QProcessFunc_closeReadChannel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.closeReadChannel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::closeReadChannel(QProcess::ProcessChannel)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX])->converter, (pyArg)))) {
        overloadId = 0; // closeReadChannel(QProcess::ProcessChannel)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_closeReadChannel_TypeError;

    // Call function/method
    {
        ::QProcess::ProcessChannel cppArg0{QProcess::StandardOutput};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // closeReadChannel(QProcess::ProcessChannel)
            cppSelf->closeReadChannel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_closeReadChannel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_closeWriteChannel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.closeWriteChannel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // closeWriteChannel()
            cppSelf->closeWriteChannel();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QProcessFunc_environment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.environment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // environment()const
            QStringList cppResult = const_cast<const ::QProcess *>(cppSelf)->environment();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QProcess::ProcessError cppResult = const_cast<const ::QProcess *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_execute(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.execute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "execute", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QProcess::execute(QString)
    // 1: static QProcess::execute(QString,QStringList)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // execute(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
            overloadId = 1; // execute(QString,QStringList)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_execute_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // execute(const QString & command)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // execute(QString)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                int cppResult = ::QProcess::execute(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QProcess.execute(const QString & command) is deprecated", 1);
            break;
        }
        case 1: // execute(const QString & program, const QStringList & arguments)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // execute(QString,QStringList)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                int cppResult = ::QProcess::execute(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QProcessFunc_execute_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_exitCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.exitCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exitCode()const
            int cppResult = const_cast<const ::QProcess *>(cppSelf)->exitCode();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_exitStatus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.exitStatus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exitStatus()const
            QProcess::ExitStatus cppResult = const_cast<const ::QProcess *>(cppSelf)->exitStatus();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_inputChannelMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.inputChannelMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // inputChannelMode()const
            QProcess::InputChannelMode cppResult = const_cast<const ::QProcess *>(cppSelf)->inputChannelMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPROCESS_INPUTCHANNELMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_isSequential(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.isSequential";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSequential()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QProcess *>(cppSelf)->::QProcess::isSequential()
                : const_cast<const ::QProcess *>(cppSelf)->isSequential();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_kill(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.kill";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // kill()
            cppSelf->kill();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QProcessFunc_nullDevice(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.nullDevice";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nullDevice()
            QString cppResult = ::QProcess::nullDevice();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_open(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.open";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QProcessFunc_open_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:open", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::open(QFlags<QIODevice::OpenModeFlag>)
    if (numArgs == 0) {
        overloadId = 0; // open(QFlags<QIODevice::OpenModeFlag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // open(QFlags<QIODevice::OpenModeFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_open_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[0]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QProcessFunc_open_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QProcessFunc_open_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QProcessFunc_open_TypeError;
            }
        }
        ::QFlags<QIODevice::OpenModeFlag> cppArg0 = QIODevice::ReadWrite;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // open(QFlags<QIODevice::OpenModeFlag>)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QProcess::open(cppArg0)
                : cppSelf->open(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QProcessFunc_open_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_pid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.pid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pid()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qprocess-pid)]
            long result;
#ifdef WIN32
                _PROCESS_INFORMATION *procInfo = cppSelf->pid();
                result = procInfo ? procInfo->dwProcessId : 0;
#else
                result = cppSelf->pid();
#endif
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<long>(), &result);
            // END of custom code block [file: ../glue/qtcore.cpp (qprocess-pid)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_processChannelMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.processChannelMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // processChannelMode()const
            QProcess::ProcessChannelMode cppResult = const_cast<const ::QProcess *>(cppSelf)->processChannelMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_processEnvironment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.processEnvironment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // processEnvironment()const
            QProcessEnvironment cppResult = const_cast<const ::QProcess *>(cppSelf)->processEnvironment();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPROCESSENVIRONMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_processId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.processId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // processId()const
            qint64 cppResult = const_cast<const ::QProcess *>(cppSelf)->processId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_program(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.program";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // program()const
            QString cppResult = const_cast<const ::QProcess *>(cppSelf)->program();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_readAllStandardError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.readAllStandardError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readAllStandardError()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QByteArray cppResult = cppSelf->readAllStandardError();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_readAllStandardOutput(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.readAllStandardOutput";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readAllStandardOutput()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QByteArray cppResult = cppSelf->readAllStandardOutput();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_readChannel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.readChannel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readChannel()const
            QProcess::ProcessChannel cppResult = const_cast<const ::QProcess *>(cppSelf)->readChannel();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_readData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.readData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::readData(char*,qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // readData(char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_readData_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readData(char*,qint64)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            QByteArray ba(1 + int(cppArg0), char(0));
            Py_BEGIN_ALLOW_THREADS
            (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self)) ? cppSelf->::QProcess::readData(ba.data(), int(cppArg0)) : cppSelf->readData(ba.data(), int(cppArg0)));
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::String::fromCString(ba.constData());
            // END of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QProcessFunc_readData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setArguments(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setArguments";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::setArguments(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setArguments(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setArguments_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setArguments(QStringList)
            cppSelf->setArguments(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setArguments_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setEnvironment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setEnvironment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::setEnvironment(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setEnvironment(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setEnvironment_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEnvironment(QStringList)
            cppSelf->setEnvironment(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setEnvironment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setInputChannelMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setInputChannelMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::setInputChannelMode(QProcess::InputChannelMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPROCESS_INPUTCHANNELMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setInputChannelMode(QProcess::InputChannelMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setInputChannelMode_TypeError;

    // Call function/method
    {
        ::QProcess::InputChannelMode cppArg0{QProcess::ManagedInputChannel};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInputChannelMode(QProcess::InputChannelMode)
            cppSelf->setInputChannelMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setInputChannelMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setProcessChannelMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setProcessChannelMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::setProcessChannelMode(QProcess::ProcessChannelMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setProcessChannelMode(QProcess::ProcessChannelMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setProcessChannelMode_TypeError;

    // Call function/method
    {
        ::QProcess::ProcessChannelMode cppArg0{QProcess::SeparateChannels};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProcessChannelMode(QProcess::ProcessChannelMode)
            cppSelf->setProcessChannelMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setProcessChannelMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setProcessEnvironment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setProcessEnvironment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::setProcessEnvironment(QProcessEnvironment)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPROCESSENVIRONMENT_IDX]), (pyArg)))) {
        overloadId = 0; // setProcessEnvironment(QProcessEnvironment)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setProcessEnvironment_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QProcessEnvironment cppArg0_local;
        ::QProcessEnvironment *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPROCESSENVIRONMENT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setProcessEnvironment(QProcessEnvironment)
            cppSelf->setProcessEnvironment(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setProcessEnvironment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setProcessState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setProcessState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::setProcessState(QProcess::ProcessState)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setProcessState(QProcess::ProcessState)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setProcessState_TypeError;

    // Call function/method
    {
        ::QProcess::ProcessState cppArg0{QProcess::NotRunning};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProcessState(QProcess::ProcessState)
            cppSelf->setProcessState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setProcessState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::setProgram(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setProgram(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setProgram_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProgram(QString)
            cppSelf->setProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setReadChannel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setReadChannel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::setReadChannel(QProcess::ProcessChannel)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setReadChannel(QProcess::ProcessChannel)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setReadChannel_TypeError;

    // Call function/method
    {
        ::QProcess::ProcessChannel cppArg0{QProcess::StandardOutput};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setReadChannel(QProcess::ProcessChannel)
            cppSelf->setReadChannel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setReadChannel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setStandardErrorFile(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setStandardErrorFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QProcessFunc_setStandardErrorFile_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QProcessFunc_setStandardErrorFile_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setStandardErrorFile", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QProcess::setStandardErrorFile(QString,QFlags<QIODevice::OpenModeFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setStandardErrorFile(QString,QFlags<QIODevice::OpenModeFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setStandardErrorFile(QString,QFlags<QIODevice::OpenModeFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setStandardErrorFile_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QProcessFunc_setStandardErrorFile_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QProcessFunc_setStandardErrorFile_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QProcessFunc_setStandardErrorFile_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<QIODevice::OpenModeFlag> cppArg1 = QIODevice::Truncate;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setStandardErrorFile(QString,QFlags<QIODevice::OpenModeFlag>)
            cppSelf->setStandardErrorFile(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setStandardErrorFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setStandardInputFile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setStandardInputFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::setStandardInputFile(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setStandardInputFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setStandardInputFile_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStandardInputFile(QString)
            cppSelf->setStandardInputFile(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setStandardInputFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setStandardOutputFile(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setStandardOutputFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QProcessFunc_setStandardOutputFile_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QProcessFunc_setStandardOutputFile_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setStandardOutputFile", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QProcess::setStandardOutputFile(QString,QFlags<QIODevice::OpenModeFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setStandardOutputFile(QString,QFlags<QIODevice::OpenModeFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setStandardOutputFile(QString,QFlags<QIODevice::OpenModeFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setStandardOutputFile_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QProcessFunc_setStandardOutputFile_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QProcessFunc_setStandardOutputFile_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QProcessFunc_setStandardOutputFile_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<QIODevice::OpenModeFlag> cppArg1 = QIODevice::Truncate;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setStandardOutputFile(QString,QFlags<QIODevice::OpenModeFlag>)
            cppSelf->setStandardOutputFile(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setStandardOutputFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setStandardOutputProcess(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setStandardOutputProcess";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::setStandardOutputProcess(QProcess*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX]), (pyArg)))) {
        overloadId = 0; // setStandardOutputProcess(QProcess*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setStandardOutputProcess_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QProcess *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStandardOutputProcess(QProcess*)
            cppSelf->setStandardOutputProcess(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setStandardOutputProcess_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setWorkingDirectory(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setWorkingDirectory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QProcess::setWorkingDirectory(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setWorkingDirectory(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_setWorkingDirectory_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWorkingDirectory(QString)
            cppSelf->setWorkingDirectory(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_setWorkingDirectory_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_setupChildProcess(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.setupChildProcess";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // setupChildProcess()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QProcess::setupChildProcess()
                : cppSelf->setupChildProcess();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QProcessFunc_start(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.start";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QProcessFunc_start_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:start", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QProcess::start(QFlags<QIODevice::OpenModeFlag>)
    // 1: QProcess::start(QString,QFlags<QIODevice::OpenModeFlag>)
    // 2: QProcess::start(QString,QStringList,QFlags<QIODevice::OpenModeFlag>)
    if (numArgs == 0) {
        overloadId = 0; // start(QFlags<QIODevice::OpenModeFlag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // start(QString,QFlags<QIODevice::OpenModeFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // start(QString,QStringList,QFlags<QIODevice::OpenModeFlag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 2; // start(QString,QStringList,QFlags<QIODevice::OpenModeFlag>)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // start(QString,QFlags<QIODevice::OpenModeFlag>)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // start(QFlags<QIODevice::OpenModeFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_start_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // start(QFlags<QIODevice::OpenModeFlag> mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[0]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QProcessFunc_start_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QProcessFunc_start_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QProcessFunc_start_TypeError;
                }
            }
            ::QFlags<QIODevice::OpenModeFlag> cppArg0 = QIODevice::ReadWrite;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // start(QFlags<QIODevice::OpenModeFlag>)
                cppSelf->start(cppArg0);
            }
            break;
        }
        case 1: // start(const QString & command, QFlags<QIODevice::OpenModeFlag> mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QProcessFunc_start_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QProcessFunc_start_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QProcessFunc_start_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QIODevice::OpenModeFlag> cppArg1 = QIODevice::ReadWrite;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // start(QString,QFlags<QIODevice::OpenModeFlag>)
                cppSelf->start(cppArg0, cppArg1);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QProcess.start(const QString & command, QFlags<QIODevice::OpenModeFlag> mode) is deprecated", 1);
            break;
        }
        case 2: // start(const QString & program, const QStringList & arguments, QFlags<QIODevice::OpenModeFlag> mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[2]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QProcessFunc_start_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QProcessFunc_start_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QProcessFunc_start_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QIODevice::OpenModeFlag> cppArg2 = QIODevice::ReadWrite;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // start(QString,QStringList,QFlags<QIODevice::OpenModeFlag>)
                cppSelf->start(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QProcessFunc_start_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_startDetached(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QProcess *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.startDetached";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QProcessFunc_startDetached_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:startDetached", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QProcess::startDetached(QString)
    // 1: static QProcess::startDetached(QString,QStringList)
    // 2: static QProcess::startDetached(QString,QStringList,QString,qint64*)
    // 3: QProcess::startDetached(qint64*)
    if (numArgs == 0) {
        overloadId = 3; // startDetached(qint64*)
    } else if (numArgs >= 1
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        overloadId = 3; // startDetached(qint64*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // startDetached(QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // startDetached(QString,QStringList)
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                overloadId = 2; // startDetached(QString,QStringList,QString,qint64*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_startDetached_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // startDetached(const QString & command)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QProcessFunc_startDetached_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // startDetached(QString)
                bool cppResult = ::QProcess::startDetached(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QProcess.startDetached(const QString & command) is deprecated", 1);
            break;
        }
        case 1: // startDetached(const QString & program, const QStringList & arguments)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QProcessFunc_startDetached_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // startDetached(QString,QStringList)
                bool cppResult = ::QProcess::startDetached(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // startDetached(const QString & program, const QStringList & arguments, const QString & workingDirectory, qint64 * pid)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QProcessFunc_startDetached_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qint64* removed_cppArg3 = nullptr;
            SBK_UNUSED(removed_cppArg3)

            if (!PyErr_Occurred()) {
                // startDetached(QString,QStringList,QString,qint64*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qprocess-startdetached)]
                qint64 pid;
                bool retval = QProcess::startDetached(cppArg0, cppArg1, cppArg2, &pid);
                pyResult = PyTuple_New(2);
                PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &retval));
                PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &pid));
                // END of custom code block [file: ../glue/qtcore.cpp (qprocess-startdetached)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 3: // startDetached(qint64 * pid)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pid = Shiboken::String::createStaticString("pid");
                if (PyDict_Contains(kwds, key_pid)) {
                    value = PyDict_GetItem(kwds, key_pid);
                    if (value && pyArgs[0]) {
                        errInfo = key_pid;
                        Py_INCREF(errInfo);
                        goto Sbk_QProcessFunc_startDetached_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0]))))
                            goto Sbk_QProcessFunc_startDetached_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pid);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QProcessFunc_startDetached_TypeError;
                }
            }
            qint64 *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // startDetached(qint64*)
                bool cppResult = cppSelf->startDetached(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QProcessFunc_startDetached_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QProcess::ProcessState cppResult = const_cast<const ::QProcess *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_systemEnvironment(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.systemEnvironment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // systemEnvironment()
            QStringList cppResult = ::QProcess::systemEnvironment();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_terminate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.terminate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // terminate()
            cppSelf->terminate();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QProcessFunc_waitForBytesWritten(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.waitForBytesWritten";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QProcessFunc_waitForBytesWritten_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForBytesWritten", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::waitForBytesWritten(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForBytesWritten(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForBytesWritten(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_waitForBytesWritten_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[0]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QProcessFunc_waitForBytesWritten_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QProcessFunc_waitForBytesWritten_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QProcessFunc_waitForBytesWritten_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForBytesWritten(int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QProcess::waitForBytesWritten(cppArg0)
                : cppSelf->waitForBytesWritten(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QProcessFunc_waitForBytesWritten_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_waitForFinished(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.waitForFinished";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QProcessFunc_waitForFinished_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForFinished", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QProcess::waitForFinished(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForFinished(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForFinished(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_waitForFinished_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[0]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QProcessFunc_waitForFinished_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QProcessFunc_waitForFinished_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QProcessFunc_waitForFinished_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForFinished(int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = cppSelf->waitForFinished(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QProcessFunc_waitForFinished_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_waitForReadyRead(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.waitForReadyRead";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QProcessFunc_waitForReadyRead_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForReadyRead", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::waitForReadyRead(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForReadyRead(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForReadyRead(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_waitForReadyRead_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[0]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QProcessFunc_waitForReadyRead_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QProcessFunc_waitForReadyRead_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QProcessFunc_waitForReadyRead_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForReadyRead(int)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QProcess::waitForReadyRead(cppArg0)
                : cppSelf->waitForReadyRead(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QProcessFunc_waitForReadyRead_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_waitForStarted(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.waitForStarted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QProcessFunc_waitForStarted_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForStarted", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QProcess::waitForStarted(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForStarted(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForStarted(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_waitForStarted_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[0]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QProcessFunc_waitForStarted_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QProcessFunc_waitForStarted_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QProcessFunc_waitForStarted_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForStarted(int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = cppSelf->waitForStarted(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QProcessFunc_waitForStarted_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QProcessFunc_workingDirectory(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.workingDirectory";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // workingDirectory()const
            QString cppResult = const_cast<const ::QProcess *>(cppSelf)->workingDirectory();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QProcessFunc_writeData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QProcess.writeData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::writeData(const char*,qint64)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        overloadId = 0; // writeData(const char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QProcessFunc_writeData_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qint64 cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // writeData(const char*,qint64)
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QProcess::writeData(cppArg0, cppArg1)
                : cppSelf->writeData(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QProcessFunc_writeData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyMethodDef Sbk_QProcessMethod_startDetached = {
    "startDetached", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_startDetached), METH_VARARGS|METH_KEYWORDS|METH_STATIC
};


static const char *Sbk_QProcess_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QProcess_methods[] = {
    {"arguments", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_arguments), METH_NOARGS},
    {"atEnd", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_atEnd), METH_NOARGS},
    {"bytesAvailable", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_bytesAvailable), METH_NOARGS},
    {"bytesToWrite", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_bytesToWrite), METH_NOARGS},
    {"canReadLine", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_canReadLine), METH_NOARGS},
    {"close", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_close), METH_NOARGS},
    {"closeReadChannel", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_closeReadChannel), METH_O},
    {"closeWriteChannel", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_closeWriteChannel), METH_NOARGS},
    {"environment", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_environment), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_error), METH_NOARGS},
    {"execute", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_execute), METH_VARARGS|METH_STATIC},
    {"exitCode", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_exitCode), METH_NOARGS},
    {"exitStatus", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_exitStatus), METH_NOARGS},
    {"inputChannelMode", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_inputChannelMode), METH_NOARGS},
    {"isSequential", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_isSequential), METH_NOARGS},
    {"kill", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_kill), METH_NOARGS},
    {"nullDevice", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_nullDevice), METH_NOARGS|METH_STATIC},
    {"open", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_open), METH_VARARGS|METH_KEYWORDS},
    {"pid", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_pid), METH_NOARGS},
    {"processChannelMode", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_processChannelMode), METH_NOARGS},
    {"processEnvironment", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_processEnvironment), METH_NOARGS},
    {"processId", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_processId), METH_NOARGS},
    {"program", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_program), METH_NOARGS},
    {"readAllStandardError", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_readAllStandardError), METH_NOARGS},
    {"readAllStandardOutput", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_readAllStandardOutput), METH_NOARGS},
    {"readChannel", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_readChannel), METH_NOARGS},
    {"readData", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_readData), METH_O},
    {"setArguments", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setArguments), METH_O},
    {"setEnvironment", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setEnvironment), METH_O},
    {"setInputChannelMode", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setInputChannelMode), METH_O},
    {"setProcessChannelMode", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setProcessChannelMode), METH_O},
    {"setProcessEnvironment", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setProcessEnvironment), METH_O},
    {"setProcessState", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setProcessState), METH_O},
    {"setProgram", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setProgram), METH_O},
    {"setReadChannel", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setReadChannel), METH_O},
    {"setStandardErrorFile", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setStandardErrorFile), METH_VARARGS|METH_KEYWORDS},
    {"setStandardInputFile", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setStandardInputFile), METH_O},
    {"setStandardOutputFile", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setStandardOutputFile), METH_VARARGS|METH_KEYWORDS},
    {"setStandardOutputProcess", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setStandardOutputProcess), METH_O},
    {"setWorkingDirectory", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setWorkingDirectory), METH_O},
    {"setupChildProcess", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_setupChildProcess), METH_NOARGS},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_start), METH_VARARGS|METH_KEYWORDS},
    Sbk_QProcessMethod_startDetached,
    {"state", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_state), METH_NOARGS},
    {"systemEnvironment", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_systemEnvironment), METH_NOARGS|METH_STATIC},
    {"terminate", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_terminate), METH_NOARGS},
    {"waitForBytesWritten", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_waitForBytesWritten), METH_VARARGS|METH_KEYWORDS},
    {"waitForFinished", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_waitForFinished), METH_VARARGS|METH_KEYWORDS},
    {"waitForReadyRead", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_waitForReadyRead), METH_VARARGS|METH_KEYWORDS},
    {"waitForStarted", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_waitForStarted), METH_VARARGS|METH_KEYWORDS},
    {"workingDirectory", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_workingDirectory), METH_NOARGS},
    {"writeData", reinterpret_cast<PyCFunction>(Sbk_QProcessFunc_writeData), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QProcess_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    if (auto ob_dict = reinterpret_cast<SbkObject *>(self)->ob_dict) {
        if (auto meth = PyDict_GetItem(ob_dict, name)) {
            Py_INCREF(meth);
            return meth;
        }
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        if (auto meth = PyDict_GetItem(Py_TYPE(self)->tp_dict, tmp))
            return PyFunction_Check(meth) ? SBK_PyMethod_New(meth, self) : PySide::getMetaDataFromQObject(reinterpret_cast< ::QObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], reinterpret_cast<SbkObject *>(self))), self, name);
    }
    static PyMethodDef non_static_Sbk_QProcessMethod_startDetached = {
        Sbk_QProcessMethod_startDetached.ml_name,
        Sbk_QProcessMethod_startDetached.ml_meth,
        Sbk_QProcessMethod_startDetached.ml_flags & (~METH_STATIC),
        Sbk_QProcessMethod_startDetached.ml_doc,
    };
    if (Shiboken::String::compare(name, "startDetached") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QProcessMethod_startDetached, self, 0);
    return PySide::getMetaDataFromQObject(reinterpret_cast< ::QObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], reinterpret_cast<SbkObject *>(self))), self, name);
}

static int Sbk_QProcess_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QProcess *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QProcessWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QProcess_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QProcess_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QProcess_Type = nullptr;
static SbkObjectType *Sbk_QProcess_TypeF(void)
{
    return _Sbk_QProcess_Type;
}

static PyType_Slot Sbk_QProcess_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QProcess_getattro)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QProcess_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QProcess_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QProcess_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QProcess_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QProcess_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QProcess_spec = {
    "2:PySide2.QtCore.QProcess",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QProcess_slots
};

} //extern "C"

static void *Sbk_QProcess_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QProcess *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QProcess_ProcessError_PythonToCpp_QProcess_ProcessError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QProcess::ProcessError *>(cppOut) =
        static_cast<::QProcess::ProcessError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QProcess_ProcessError_PythonToCpp_QProcess_ProcessError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX]))
        return QProcess_ProcessError_PythonToCpp_QProcess_ProcessError;
    return {};
}
static PyObject *QProcess_ProcessError_CppToPython_QProcess_ProcessError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QProcess::ProcessError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX], castCppIn);

}

static void QProcess_ProcessState_PythonToCpp_QProcess_ProcessState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QProcess::ProcessState *>(cppOut) =
        static_cast<::QProcess::ProcessState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QProcess_ProcessState_PythonToCpp_QProcess_ProcessState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX]))
        return QProcess_ProcessState_PythonToCpp_QProcess_ProcessState;
    return {};
}
static PyObject *QProcess_ProcessState_CppToPython_QProcess_ProcessState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QProcess::ProcessState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX], castCppIn);

}

static void QProcess_ProcessChannel_PythonToCpp_QProcess_ProcessChannel(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QProcess::ProcessChannel *>(cppOut) =
        static_cast<::QProcess::ProcessChannel>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QProcess_ProcessChannel_PythonToCpp_QProcess_ProcessChannel_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX]))
        return QProcess_ProcessChannel_PythonToCpp_QProcess_ProcessChannel;
    return {};
}
static PyObject *QProcess_ProcessChannel_CppToPython_QProcess_ProcessChannel(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QProcess::ProcessChannel *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX], castCppIn);

}

static void QProcess_ProcessChannelMode_PythonToCpp_QProcess_ProcessChannelMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QProcess::ProcessChannelMode *>(cppOut) =
        static_cast<::QProcess::ProcessChannelMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QProcess_ProcessChannelMode_PythonToCpp_QProcess_ProcessChannelMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX]))
        return QProcess_ProcessChannelMode_PythonToCpp_QProcess_ProcessChannelMode;
    return {};
}
static PyObject *QProcess_ProcessChannelMode_CppToPython_QProcess_ProcessChannelMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QProcess::ProcessChannelMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX], castCppIn);

}

static void QProcess_InputChannelMode_PythonToCpp_QProcess_InputChannelMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QProcess::InputChannelMode *>(cppOut) =
        static_cast<::QProcess::InputChannelMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QProcess_InputChannelMode_PythonToCpp_QProcess_InputChannelMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QPROCESS_INPUTCHANNELMODE_IDX]))
        return QProcess_InputChannelMode_PythonToCpp_QProcess_InputChannelMode;
    return {};
}
static PyObject *QProcess_InputChannelMode_CppToPython_QProcess_InputChannelMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QProcess::InputChannelMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_INPUTCHANNELMODE_IDX], castCppIn);

}

static void QProcess_ExitStatus_PythonToCpp_QProcess_ExitStatus(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QProcess::ExitStatus *>(cppOut) =
        static_cast<::QProcess::ExitStatus>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QProcess_ExitStatus_PythonToCpp_QProcess_ExitStatus_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX]))
        return QProcess_ExitStatus_PythonToCpp_QProcess_ExitStatus;
    return {};
}
static PyObject *QProcess_ExitStatus_CppToPython_QProcess_ExitStatus(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QProcess::ExitStatus *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QProcess_PythonToCpp_QProcess_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QProcess_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QProcess_PythonToCpp_QProcess_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QProcess_TypeF())))
        return QProcess_PythonToCpp_QProcess_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QProcess_PTR_CppToPython_QProcess(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QProcess *>(const_cast<void *>(cppIn)), Sbk_QProcess_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QProcess_SignatureStrings[] = {
    "PySide2.QtCore.QProcess(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtCore.QProcess.arguments(self)->QStringList",
    "PySide2.QtCore.QProcess.atEnd(self)->bool",
    "PySide2.QtCore.QProcess.bytesAvailable(self)->qint64",
    "PySide2.QtCore.QProcess.bytesToWrite(self)->qint64",
    "PySide2.QtCore.QProcess.canReadLine(self)->bool",
    "PySide2.QtCore.QProcess.close(self)",
    "PySide2.QtCore.QProcess.closeReadChannel(self,channel:PySide2.QtCore.QProcess.ProcessChannel)",
    "PySide2.QtCore.QProcess.closeWriteChannel(self)",
    "PySide2.QtCore.QProcess.environment(self)->QStringList",
    "PySide2.QtCore.QProcess.error(self)->PySide2.QtCore.QProcess.ProcessError",
    "1:PySide2.QtCore.QProcess.execute(command:QString)->int",
    "0:PySide2.QtCore.QProcess.execute(program:QString,arguments:QStringList)->int",
    "PySide2.QtCore.QProcess.exitCode(self)->int",
    "PySide2.QtCore.QProcess.exitStatus(self)->PySide2.QtCore.QProcess.ExitStatus",
    "PySide2.QtCore.QProcess.inputChannelMode(self)->PySide2.QtCore.QProcess.InputChannelMode",
    "PySide2.QtCore.QProcess.isSequential(self)->bool",
    "PySide2.QtCore.QProcess.kill(self)",
    "PySide2.QtCore.QProcess.nullDevice()->QString",
    "PySide2.QtCore.QProcess.open(self,mode:PySide2.QtCore.QIODevice.OpenMode=QIODevice.ReadWrite)->bool",
    "PySide2.QtCore.QProcess.pid(self)->long",
    "PySide2.QtCore.QProcess.processChannelMode(self)->PySide2.QtCore.QProcess.ProcessChannelMode",
    "PySide2.QtCore.QProcess.processEnvironment(self)->PySide2.QtCore.QProcessEnvironment",
    "PySide2.QtCore.QProcess.processId(self)->qint64",
    "PySide2.QtCore.QProcess.program(self)->QString",
    "PySide2.QtCore.QProcess.readAllStandardError(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QProcess.readAllStandardOutput(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QProcess.readChannel(self)->PySide2.QtCore.QProcess.ProcessChannel",
    "PySide2.QtCore.QProcess.readData(self,data:char*,maxlen:qint64)->qint64",
    "PySide2.QtCore.QProcess.setArguments(self,arguments:QStringList)",
    "PySide2.QtCore.QProcess.setEnvironment(self,environment:QStringList)",
    "PySide2.QtCore.QProcess.setInputChannelMode(self,mode:PySide2.QtCore.QProcess.InputChannelMode)",
    "PySide2.QtCore.QProcess.setProcessChannelMode(self,mode:PySide2.QtCore.QProcess.ProcessChannelMode)",
    "PySide2.QtCore.QProcess.setProcessEnvironment(self,environment:PySide2.QtCore.QProcessEnvironment)",
    "PySide2.QtCore.QProcess.setProcessState(self,state:PySide2.QtCore.QProcess.ProcessState)",
    "PySide2.QtCore.QProcess.setProgram(self,program:QString)",
    "PySide2.QtCore.QProcess.setReadChannel(self,channel:PySide2.QtCore.QProcess.ProcessChannel)",
    "PySide2.QtCore.QProcess.setStandardErrorFile(self,fileName:QString,mode:PySide2.QtCore.QIODevice.OpenMode=QIODevice.Truncate)",
    "PySide2.QtCore.QProcess.setStandardInputFile(self,fileName:QString)",
    "PySide2.QtCore.QProcess.setStandardOutputFile(self,fileName:QString,mode:PySide2.QtCore.QIODevice.OpenMode=QIODevice.Truncate)",
    "PySide2.QtCore.QProcess.setStandardOutputProcess(self,destination:PySide2.QtCore.QProcess)",
    "PySide2.QtCore.QProcess.setWorkingDirectory(self,dir:QString)",
    "PySide2.QtCore.QProcess.setupChildProcess(self)",
    "2:PySide2.QtCore.QProcess.start(self,mode:PySide2.QtCore.QIODevice.OpenMode=QIODevice.ReadWrite)",
    "1:PySide2.QtCore.QProcess.start(self,command:QString,mode:PySide2.QtCore.QIODevice.OpenMode=QIODevice.ReadWrite)",
    "0:PySide2.QtCore.QProcess.start(self,program:QString,arguments:QStringList,mode:PySide2.QtCore.QIODevice.OpenMode=QIODevice.ReadWrite)",
    "3:PySide2.QtCore.QProcess.startDetached(command:QString)->bool",
    "2:PySide2.QtCore.QProcess.startDetached(program:QString,arguments:QStringList)->bool",
    "1:PySide2.QtCore.QProcess.startDetached(program:QString,arguments:QStringList,workingDirectory:QString,pid:qint64*=nullptr)->bool",
    "0:PySide2.QtCore.QProcess.startDetached(self,pid:qint64*=nullptr)->bool",
    "PySide2.QtCore.QProcess.state(self)->PySide2.QtCore.QProcess.ProcessState",
    "PySide2.QtCore.QProcess.systemEnvironment()->QStringList",
    "PySide2.QtCore.QProcess.terminate(self)",
    "PySide2.QtCore.QProcess.waitForBytesWritten(self,msecs:int=30000)->bool",
    "PySide2.QtCore.QProcess.waitForFinished(self,msecs:int=30000)->bool",
    "PySide2.QtCore.QProcess.waitForReadyRead(self,msecs:int=30000)->bool",
    "PySide2.QtCore.QProcess.waitForStarted(self,msecs:int=30000)->bool",
    "PySide2.QtCore.QProcess.workingDirectory(self)->QString",
    "PySide2.QtCore.QProcess.writeData(self,data:char*,len:qint64)->qint64",
    nullptr}; // Sentinel

void init_QProcess(PyObject *module)
{
    _Sbk_QProcess_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QProcess",
        "QProcess*",
        &Sbk_QProcess_spec,
        &Shiboken::callCppDestructor< ::QProcess >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QProcess_Type);
    InitSignatureStrings(pyType, QProcess_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QProcess_Type), Sbk_QProcess_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QPROCESS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QProcess_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QProcess_TypeF(),
        QProcess_PythonToCpp_QProcess_PTR,
        is_QProcess_PythonToCpp_QProcess_PTR_Convertible,
        QProcess_PTR_CppToPython_QProcess);

    Shiboken::Conversions::registerConverterName(converter, "QProcess");
    Shiboken::Conversions::registerConverterName(converter, "QProcess*");
    Shiboken::Conversions::registerConverterName(converter, "QProcess&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QProcess).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QProcessWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QProcess_TypeF(), &Sbk_QProcess_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ProcessError'.
    SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QProcess_TypeF(),
        "ProcessError",
        "2:PySide2.QtCore.QProcess.ProcessError",
        "QProcess::ProcessError");
    if (!SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX],
        Sbk_QProcess_TypeF(), "FailedToStart", (long) QProcess::ProcessError::FailedToStart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX],
        Sbk_QProcess_TypeF(), "Crashed", (long) QProcess::ProcessError::Crashed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX],
        Sbk_QProcess_TypeF(), "Timedout", (long) QProcess::ProcessError::Timedout))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX],
        Sbk_QProcess_TypeF(), "ReadError", (long) QProcess::ProcessError::ReadError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX],
        Sbk_QProcess_TypeF(), "WriteError", (long) QProcess::ProcessError::WriteError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX],
        Sbk_QProcess_TypeF(), "UnknownError", (long) QProcess::ProcessError::UnknownError))
        return;
    // Register converter for enum 'QProcess::ProcessError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX],
            QProcess_ProcessError_CppToPython_QProcess_ProcessError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QProcess_ProcessError_PythonToCpp_QProcess_ProcessError,
            is_QProcess_ProcessError_PythonToCpp_QProcess_ProcessError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QProcess::ProcessError");
        Shiboken::Conversions::registerConverterName(converter, "ProcessError");
    }
    // End of 'ProcessError' enum.

    // Initialization of enum 'ProcessState'.
    SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QProcess_TypeF(),
        "ProcessState",
        "2:PySide2.QtCore.QProcess.ProcessState",
        "QProcess::ProcessState");
    if (!SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX],
        Sbk_QProcess_TypeF(), "NotRunning", (long) QProcess::ProcessState::NotRunning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX],
        Sbk_QProcess_TypeF(), "Starting", (long) QProcess::ProcessState::Starting))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX],
        Sbk_QProcess_TypeF(), "Running", (long) QProcess::ProcessState::Running))
        return;
    // Register converter for enum 'QProcess::ProcessState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX],
            QProcess_ProcessState_CppToPython_QProcess_ProcessState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QProcess_ProcessState_PythonToCpp_QProcess_ProcessState,
            is_QProcess_ProcessState_PythonToCpp_QProcess_ProcessState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QProcess::ProcessState");
        Shiboken::Conversions::registerConverterName(converter, "ProcessState");
    }
    // End of 'ProcessState' enum.

    // Initialization of enum 'ProcessChannel'.
    SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QProcess_TypeF(),
        "ProcessChannel",
        "2:PySide2.QtCore.QProcess.ProcessChannel",
        "QProcess::ProcessChannel");
    if (!SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX],
        Sbk_QProcess_TypeF(), "StandardOutput", (long) QProcess::ProcessChannel::StandardOutput))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX],
        Sbk_QProcess_TypeF(), "StandardError", (long) QProcess::ProcessChannel::StandardError))
        return;
    // Register converter for enum 'QProcess::ProcessChannel'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX],
            QProcess_ProcessChannel_CppToPython_QProcess_ProcessChannel);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QProcess_ProcessChannel_PythonToCpp_QProcess_ProcessChannel,
            is_QProcess_ProcessChannel_PythonToCpp_QProcess_ProcessChannel_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QProcess::ProcessChannel");
        Shiboken::Conversions::registerConverterName(converter, "ProcessChannel");
    }
    // End of 'ProcessChannel' enum.

    // Initialization of enum 'ProcessChannelMode'.
    SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QProcess_TypeF(),
        "ProcessChannelMode",
        "2:PySide2.QtCore.QProcess.ProcessChannelMode",
        "QProcess::ProcessChannelMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX],
        Sbk_QProcess_TypeF(), "SeparateChannels", (long) QProcess::ProcessChannelMode::SeparateChannels))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX],
        Sbk_QProcess_TypeF(), "MergedChannels", (long) QProcess::ProcessChannelMode::MergedChannels))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX],
        Sbk_QProcess_TypeF(), "ForwardedChannels", (long) QProcess::ProcessChannelMode::ForwardedChannels))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX],
        Sbk_QProcess_TypeF(), "ForwardedOutputChannel", (long) QProcess::ProcessChannelMode::ForwardedOutputChannel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX],
        Sbk_QProcess_TypeF(), "ForwardedErrorChannel", (long) QProcess::ProcessChannelMode::ForwardedErrorChannel))
        return;
    // Register converter for enum 'QProcess::ProcessChannelMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX],
            QProcess_ProcessChannelMode_CppToPython_QProcess_ProcessChannelMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QProcess_ProcessChannelMode_PythonToCpp_QProcess_ProcessChannelMode,
            is_QProcess_ProcessChannelMode_PythonToCpp_QProcess_ProcessChannelMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QProcess::ProcessChannelMode");
        Shiboken::Conversions::registerConverterName(converter, "ProcessChannelMode");
    }
    // End of 'ProcessChannelMode' enum.

    // Initialization of enum 'InputChannelMode'.
    SbkPySide2_QtCoreTypes[SBK_QPROCESS_INPUTCHANNELMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QProcess_TypeF(),
        "InputChannelMode",
        "2:PySide2.QtCore.QProcess.InputChannelMode",
        "QProcess::InputChannelMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QPROCESS_INPUTCHANNELMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_INPUTCHANNELMODE_IDX],
        Sbk_QProcess_TypeF(), "ManagedInputChannel", (long) QProcess::InputChannelMode::ManagedInputChannel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_INPUTCHANNELMODE_IDX],
        Sbk_QProcess_TypeF(), "ForwardedInputChannel", (long) QProcess::InputChannelMode::ForwardedInputChannel))
        return;
    // Register converter for enum 'QProcess::InputChannelMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_INPUTCHANNELMODE_IDX],
            QProcess_InputChannelMode_CppToPython_QProcess_InputChannelMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QProcess_InputChannelMode_PythonToCpp_QProcess_InputChannelMode,
            is_QProcess_InputChannelMode_PythonToCpp_QProcess_InputChannelMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_INPUTCHANNELMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QProcess::InputChannelMode");
        Shiboken::Conversions::registerConverterName(converter, "InputChannelMode");
    }
    // End of 'InputChannelMode' enum.

    // Initialization of enum 'ExitStatus'.
    SbkPySide2_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QProcess_TypeF(),
        "ExitStatus",
        "2:PySide2.QtCore.QProcess.ExitStatus",
        "QProcess::ExitStatus");
    if (!SbkPySide2_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX],
        Sbk_QProcess_TypeF(), "NormalExit", (long) QProcess::ExitStatus::NormalExit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX],
        Sbk_QProcess_TypeF(), "CrashExit", (long) QProcess::ExitStatus::CrashExit))
        return;
    // Register converter for enum 'QProcess::ExitStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX],
            QProcess_ExitStatus_CppToPython_QProcess_ExitStatus);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QProcess_ExitStatus_PythonToCpp_QProcess_ExitStatus,
            is_QProcess_ExitStatus_PythonToCpp_QProcess_ExitStatus_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QProcess::ExitStatus");
        Shiboken::Conversions::registerConverterName(converter, "ExitStatus");
    }
    // End of 'ExitStatus' enum.

    PySide::Signal::registerSignals(Sbk_QProcess_TypeF(), &::QProcess::staticMetaObject);
    qRegisterMetaType< ::QProcess::ProcessError >("QProcess::ProcessError");
    qRegisterMetaType< ::QProcess::ProcessState >("QProcess::ProcessState");
    qRegisterMetaType< ::QProcess::ProcessChannel >("QProcess::ProcessChannel");
    qRegisterMetaType< ::QProcess::ProcessChannelMode >("QProcess::ProcessChannelMode");
    qRegisterMetaType< ::QProcess::InputChannelMode >("QProcess::InputChannelMode");
    qRegisterMetaType< ::QProcess::ExitStatus >("QProcess::ExitStatus");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QProcess_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QProcess_TypeF(), &::QProcess::staticMetaObject, sizeof(QProcessWrapper));
}
