/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qlockfile_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QLockFile_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QLockFile >()))
        return -1;

    ::QLockFile *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLockFile.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QLockFile", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QLockFile::QLockFile(QString)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // QLockFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLockFile_Init_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QLockFile(QString)
            cptr = new ::QLockFile(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QLockFile >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QLockFile_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QLockFile_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QLockFileFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLockFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLockFile.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QLockFile::LockError cppResult = const_cast<const ::QLockFile *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_LOCKERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLockFileFunc_getLockInfo(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLockFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLockFile.getLockInfo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "getLockInfo", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QLockFile::getLockInfo(qint64*,QString*,QString*)const
    if (numArgs == 3
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 0; // getLockInfo(qint64*,QString*,QString*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLockFileFunc_getLockInfo_TypeError;

    // Call function/method
    {
        qint64 *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // getLockInfo(qint64*,QString*,QString*)const
            bool cppResult = const_cast<const ::QLockFile *>(cppSelf)->getLockInfo(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLockFileFunc_getLockInfo_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLockFileFunc_isLocked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLockFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLockFile.isLocked";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLocked()const
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = const_cast<const ::QLockFile *>(cppSelf)->isLocked();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLockFileFunc_lock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLockFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLockFile.lock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lock()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = cppSelf->lock();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLockFileFunc_removeStaleLockFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLockFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLockFile.removeStaleLockFile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeStaleLockFile()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = cppSelf->removeStaleLockFile();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLockFileFunc_setStaleLockTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLockFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLockFile.setStaleLockTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLockFile::setStaleLockTime(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setStaleLockTime(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLockFileFunc_setStaleLockTime_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStaleLockTime(int)
            cppSelf->setStaleLockTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLockFileFunc_setStaleLockTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLockFileFunc_staleLockTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLockFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLockFile.staleLockTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // staleLockTime()const
            int cppResult = const_cast<const ::QLockFile *>(cppSelf)->staleLockTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLockFileFunc_tryLock(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLockFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLockFile.tryLock";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLockFileFunc_tryLock_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:tryLock", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QLockFile::tryLock(int)
    if (numArgs == 0) {
        overloadId = 0; // tryLock(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // tryLock(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLockFileFunc_tryLock_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timeout = Shiboken::String::createStaticString("timeout");
            if (PyDict_Contains(kwds, key_timeout)) {
                value = PyDict_GetItem(kwds, key_timeout);
                if (value && pyArgs[0]) {
                    errInfo = key_timeout;
                    Py_INCREF(errInfo);
                    goto Sbk_QLockFileFunc_tryLock_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QLockFileFunc_tryLock_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timeout);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLockFileFunc_tryLock_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // tryLock(int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = cppSelf->tryLock(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLockFileFunc_tryLock_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLockFileFunc_unlock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLockFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QLockFile.unlock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unlock()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->unlock();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QLockFile_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QLockFile_methods[] = {
    {"error", reinterpret_cast<PyCFunction>(Sbk_QLockFileFunc_error), METH_NOARGS},
    {"getLockInfo", reinterpret_cast<PyCFunction>(Sbk_QLockFileFunc_getLockInfo), METH_VARARGS},
    {"isLocked", reinterpret_cast<PyCFunction>(Sbk_QLockFileFunc_isLocked), METH_NOARGS},
    {"lock", reinterpret_cast<PyCFunction>(Sbk_QLockFileFunc_lock), METH_NOARGS},
    {"removeStaleLockFile", reinterpret_cast<PyCFunction>(Sbk_QLockFileFunc_removeStaleLockFile), METH_NOARGS},
    {"setStaleLockTime", reinterpret_cast<PyCFunction>(Sbk_QLockFileFunc_setStaleLockTime), METH_O},
    {"staleLockTime", reinterpret_cast<PyCFunction>(Sbk_QLockFileFunc_staleLockTime), METH_NOARGS},
    {"tryLock", reinterpret_cast<PyCFunction>(Sbk_QLockFileFunc_tryLock), METH_VARARGS|METH_KEYWORDS},
    {"unlock", reinterpret_cast<PyCFunction>(Sbk_QLockFileFunc_unlock), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QLockFile_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QLockFile_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QLockFile_Type = nullptr;
static SbkObjectType *Sbk_QLockFile_TypeF(void)
{
    return _Sbk_QLockFile_Type;
}

static PyType_Slot Sbk_QLockFile_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QLockFile_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QLockFile_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QLockFile_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QLockFile_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QLockFile_spec = {
    "2:PySide2.QtCore.QLockFile",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QLockFile_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QLockFile_LockError_PythonToCpp_QLockFile_LockError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLockFile::LockError *>(cppOut) =
        static_cast<::QLockFile::LockError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLockFile_LockError_PythonToCpp_QLockFile_LockError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_LOCKERROR_IDX]))
        return QLockFile_LockError_PythonToCpp_QLockFile_LockError;
    return {};
}
static PyObject *QLockFile_LockError_CppToPython_QLockFile_LockError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLockFile::LockError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_LOCKERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QLockFile_PythonToCpp_QLockFile_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QLockFile_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QLockFile_PythonToCpp_QLockFile_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QLockFile_TypeF())))
        return QLockFile_PythonToCpp_QLockFile_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QLockFile_PTR_CppToPython_QLockFile(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QLockFile *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QLockFile_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QLockFile_SignatureStrings[] = {
    "PySide2.QtCore.QLockFile(self,fileName:QString)",
    "PySide2.QtCore.QLockFile.error(self)->PySide2.QtCore.QLockFile.LockError",
    "PySide2.QtCore.QLockFile.getLockInfo(self,pid:qint64*,hostname:QString*,appname:QString*)->bool",
    "PySide2.QtCore.QLockFile.isLocked(self)->bool",
    "PySide2.QtCore.QLockFile.lock(self)->bool",
    "PySide2.QtCore.QLockFile.removeStaleLockFile(self)->bool",
    "PySide2.QtCore.QLockFile.setStaleLockTime(self,arg__1:int)",
    "PySide2.QtCore.QLockFile.staleLockTime(self)->int",
    "PySide2.QtCore.QLockFile.tryLock(self,timeout:int=0)->bool",
    "PySide2.QtCore.QLockFile.unlock(self)",
    nullptr}; // Sentinel

void init_QLockFile(PyObject *module)
{
    _Sbk_QLockFile_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QLockFile",
        "QLockFile*",
        &Sbk_QLockFile_spec,
        &Shiboken::callCppDestructor< ::QLockFile >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QLockFile_Type);
    InitSignatureStrings(pyType, QLockFile_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QLockFile_Type), Sbk_QLockFile_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QLockFile_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QLockFile_TypeF(),
        QLockFile_PythonToCpp_QLockFile_PTR,
        is_QLockFile_PythonToCpp_QLockFile_PTR_Convertible,
        QLockFile_PTR_CppToPython_QLockFile);

    Shiboken::Conversions::registerConverterName(converter, "QLockFile");
    Shiboken::Conversions::registerConverterName(converter, "QLockFile*");
    Shiboken::Conversions::registerConverterName(converter, "QLockFile&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLockFile).name());


    // Initialization of enums.

    // Initialization of enum 'LockError'.
    SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_LOCKERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLockFile_TypeF(),
        "LockError",
        "2:PySide2.QtCore.QLockFile.LockError",
        "QLockFile::LockError");
    if (!SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_LOCKERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_LOCKERROR_IDX],
        Sbk_QLockFile_TypeF(), "NoError", (long) QLockFile::LockError::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_LOCKERROR_IDX],
        Sbk_QLockFile_TypeF(), "LockFailedError", (long) QLockFile::LockError::LockFailedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_LOCKERROR_IDX],
        Sbk_QLockFile_TypeF(), "PermissionError", (long) QLockFile::LockError::PermissionError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_LOCKERROR_IDX],
        Sbk_QLockFile_TypeF(), "UnknownError", (long) QLockFile::LockError::UnknownError))
        return;
    // Register converter for enum 'QLockFile::LockError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_LOCKERROR_IDX],
            QLockFile_LockError_CppToPython_QLockFile_LockError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLockFile_LockError_PythonToCpp_QLockFile_LockError,
            is_QLockFile_LockError_PythonToCpp_QLockFile_LockError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QLOCKFILE_LOCKERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLockFile::LockError");
        Shiboken::Conversions::registerConverterName(converter, "LockError");
    }
    // End of 'LockError' enum.

    qRegisterMetaType< ::QLockFile::LockError >("QLockFile::LockError");
}
