/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qfile_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QFileWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QFileWrapper::QFileWrapper() : QFile()
{
    resetPyMethodCache();
    // ... middle
}

QFileWrapper::QFileWrapper(::QObject * parent) : QFile(parent)
{
    resetPyMethodCache();
    // ... middle
}

QFileWrapper::QFileWrapper(const ::QString & name) : QFile(name)
{
    resetPyMethodCache();
    // ... middle
}

QFileWrapper::QFileWrapper(const ::QString & name, ::QObject * parent) : QFile(name, parent)
{
    resetPyMethodCache();
    // ... middle
}

bool QFileWrapper::atEnd() const
{
    if (m_PyMethodCache[0])
        return this->::QFileDevice::atEnd();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "atEnd";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QFileDevice::atEnd();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.atEnd", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileWrapper::bytesAvailable() const
{
    if (m_PyMethodCache[1])
        return this->::QIODevice::bytesAvailable();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesAvailable";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QIODevice::bytesAvailable();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.bytesAvailable", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileWrapper::bytesToWrite() const
{
    if (m_PyMethodCache[2])
        return this->::QIODevice::bytesToWrite();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesToWrite";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QIODevice::bytesToWrite();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.bytesToWrite", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileWrapper::canReadLine() const
{
    if (m_PyMethodCache[3])
        return this->::QIODevice::canReadLine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "canReadLine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QIODevice::canReadLine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.canReadLine", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileWrapper::close()
{
    if (m_PyMethodCache[5]) {
        return this->::QFileDevice::close();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "close";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QFileDevice::close();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QFileWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QFileWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QFileWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[9])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QFileWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[10])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QString QFileWrapper::fileName() const
{
    if (m_PyMethodCache[11])
        return this->::QFile::fileName();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "fileName";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QFile::fileName();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.fileName", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileWrapper::isSequential() const
{
    if (m_PyMethodCache[12])
        return this->::QFileDevice::isSequential();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isSequential";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QFileDevice::isSequential();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.isSequential", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileWrapper::open(::QFlags<QIODevice::OpenModeFlag> flags)
{
    if (m_PyMethodCache[14])
        return this->::QFile::open(flags);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "open";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QFile::open(flags);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &flags)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.open", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<QFileDevice::Permission> QFileWrapper::permissions() const
{
    if (m_PyMethodCache[15])
        return this->::QFile::permissions();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QFileDevice::Permission>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "permissions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QFile::permissions();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QFileDevice::Permission>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.permissions", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QFileDevice::Permission> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QFileDevice::Permission>(0);
    }
    ::QFlags<QFileDevice::Permission> cppResult = QFlags<QFileDevice::Permission>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileWrapper::pos() const
{
    if (m_PyMethodCache[16])
        return this->::QFileDevice::pos();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "pos";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QFileDevice::pos();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.pos", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileWrapper::readData(char * data, qint64 maxlen)
{
    if (m_PyMethodCache[17]) {
        return this->::QFileDevice::readData(data, maxlen);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QFileDevice::readData(data, maxlen);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

qint64 QFileWrapper::readLineData(char * data, qint64 maxlen)
{
    if (m_PyMethodCache[18]) {
        return this->::QFileDevice::readLineData(data, maxlen);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readLineData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QFileDevice::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

bool QFileWrapper::reset()
{
    if (m_PyMethodCache[19])
        return this->::QIODevice::reset();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "reset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QIODevice::reset();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.reset", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileWrapper::resize(qint64 sz)
{
    if (m_PyMethodCache[20])
        return this->::QFile::resize(sz);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "resize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QFile::resize(sz);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    sz
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.resize", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileWrapper::seek(qint64 offset)
{
    if (m_PyMethodCache[21])
        return this->::QFileDevice::seek(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "seek";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QFileDevice::seek(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    offset
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.seek", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileWrapper::setPermissions(::QFlags<QFileDevice::Permission> permissionSpec)
{
    if (m_PyMethodCache[22])
        return this->::QFile::setPermissions(permissionSpec);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setPermissions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QFile::setPermissions(permissionSpec);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, &permissionSpec)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.setPermissions", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileWrapper::size() const
{
    if (m_PyMethodCache[23])
        return this->::QFile::size();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "size";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QFile::size();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.size", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[24]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QFileWrapper::waitForBytesWritten(int msecs)
{
    if (m_PyMethodCache[25])
        return this->::QIODevice::waitForBytesWritten(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForBytesWritten";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QIODevice::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.waitForBytesWritten", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QFileWrapper::waitForReadyRead(int msecs)
{
    if (m_PyMethodCache[26])
        return this->::QIODevice::waitForReadyRead(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForReadyRead";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QIODevice::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.waitForReadyRead", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QFileWrapper::writeData(const char * data, qint64 len)
{
    if (m_PyMethodCache[27])
        return this->::QFileDevice::writeData(data, len);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "writeData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QFileDevice::writeData(data, len);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NL)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), data),
    len
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFile.writeData", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QFileWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QFile::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QFileWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QFile::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QFileWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QFileWrapper *>(this));
        return QFile::qt_metacast(_clname);
}

QFileWrapper::~QFileWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFile_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFile >()))
        return -1;

    ::QFileWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QFile", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QFile::QFile()
    // 1: QFile::QFile(QObject*)
    // 2: QFile::QFile(QString)
    // 3: QFile::QFile(QString,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QFile()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QFile(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QFile(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 3; // QFile(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFile_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFile()
        {

            if (!PyErr_Occurred()) {
                // QFile()
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QFileWrapper();
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QFileWrapper();
                }

            }
            break;
        }
        case 1: // QFile(QObject * parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QFile(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QFileWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QFileWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 2: // QFile(const QString & name)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QFile(QString)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QFileWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QFileWrapper(cppArg0);
                }

            }
            break;
        }
        case 3: // QFile(const QString & name, QObject * parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QFile(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QFileWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QFileWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFile >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFile_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QFile_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QFile_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFileFunc_copy(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFile *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.copy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "copy", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QFile::copy(QString,QString)
    // 1: QFile::copy(QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // copy(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // copy(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_copy_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // copy(const QString & fileName, const QString & newName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // copy(QString,QString)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = ::QFile::copy(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // copy(const QString & newName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // copy(QString)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->copy(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_copy_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_decodeName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.decodeName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFile::decodeName(QByteArray)
    // 1: static QFile::decodeName(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 1; // decodeName(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // decodeName(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_decodeName_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // decodeName(const QByteArray & localFileName)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // decodeName(QByteArray)
                QString cppResult = ::QFile::decodeName(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // decodeName(const char * localFileName)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // decodeName(const char*)
                QString cppResult = ::QFile::decodeName(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_decodeName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_encodeName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.encodeName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QFile::encodeName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // encodeName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_encodeName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // encodeName(QString)
            QByteArray cppResult = ::QFile::encodeName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_encodeName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_exists(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFile *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.exists";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "exists", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QFile::exists()const
    // 1: static QFile::exists(QString)
    if (numArgs == 0) {
        overloadId = 0; // exists()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // exists(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_exists_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // exists() const
        {

            if (!PyErr_Occurred()) {
                // exists()const
                bool cppResult = const_cast<const ::QFile *>(cppSelf)->exists();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // exists(const QString & fileName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // exists(QString)
                bool cppResult = ::QFile::exists(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_exists_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.fileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileName()const
            QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QFile *>(cppSelf)->::QFile::fileName()
                : const_cast<const ::QFile *>(cppSelf)->fileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileFunc_link(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFile *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.link";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "link", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFile::link(QString)
    // 1: static QFile::link(QString,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // link(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // link(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_link_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // link(const QString & newName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // link(QString)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->link(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // link(const QString & oldname, const QString & newName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // link(QString,QString)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = ::QFile::link(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_link_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_moveToTrash(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFile *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.moveToTrash";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileFunc_moveToTrash_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:moveToTrash", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFile::moveToTrash()
    // 1: static QFile::moveToTrash(QString,QString*)
    if (numArgs == 0) {
        overloadId = 0; // moveToTrash()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // moveToTrash(QString,QString*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // moveToTrash(QString,QString*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_moveToTrash_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // moveToTrash()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFileFunc_moveToTrash_TypeError;
            }

            if (!PyErr_Occurred()) {
                // moveToTrash()
                bool cppResult = cppSelf->moveToTrash();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // moveToTrash(const QString & fileName, QString * pathInTrash)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pathInTrash = Shiboken::String::createStaticString("pathInTrash");
                if (PyDict_Contains(kwds, key_pathInTrash)) {
                    value = PyDict_GetItem(kwds, key_pathInTrash);
                    if (value && pyArgs[1]) {
                        errInfo = key_pathInTrash;
                        Py_INCREF(errInfo);
                        goto Sbk_QFileFunc_moveToTrash_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QFileFunc_moveToTrash_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pathInTrash);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QFileFunc_moveToTrash_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // moveToTrash(QString,QString*)
                bool cppResult = ::QFile::moveToTrash(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_moveToTrash_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_open(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.open";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileFunc_open_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFileFunc_open_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:open", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::open(QFlags<QIODevice::OpenModeFlag>)
    // 1: QFile::open(int,QFlags<QIODevice::OpenModeFlag>,QFlags<QFileDevice::FileHandleFlag>)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // open(int,QFlags<QIODevice::OpenModeFlag>,QFlags<QFileDevice::FileHandleFlag>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX])->converter, (pyArgs[2])))) {
            overloadId = 1; // open(int,QFlags<QIODevice::OpenModeFlag>,QFlags<QFileDevice::FileHandleFlag>)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // open(QFlags<QIODevice::OpenModeFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_open_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // open(QFlags<QIODevice::OpenModeFlag> flags)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFileFunc_open_TypeError;
            }
            ::QFlags<QIODevice::OpenModeFlag> cppArg0 = QFlags<QIODevice::OpenModeFlag>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // open(QFlags<QIODevice::OpenModeFlag>)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QFile::open(cppArg0)
                    : cppSelf->open(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // open(int fd, QFlags<QIODevice::OpenModeFlag> ioFlags, QFlags<QFileDevice::FileHandleFlag> handleFlags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_handleFlags = Shiboken::String::createStaticString("handleFlags");
                if (PyDict_Contains(kwds, key_handleFlags)) {
                    value = PyDict_GetItem(kwds, key_handleFlags);
                    if (value && pyArgs[2]) {
                        errInfo = key_handleFlags;
                        Py_INCREF(errInfo);
                        goto Sbk_QFileFunc_open_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_FILEHANDLEFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QFileFunc_open_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_handleFlags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QFileFunc_open_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QIODevice::OpenModeFlag> cppArg1 = QFlags<QIODevice::OpenModeFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QFileDevice::FileHandleFlag> cppArg2 = QFileDevice::DontCloseHandle;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // open(int,QFlags<QIODevice::OpenModeFlag>,QFlags<QFileDevice::FileHandleFlag>)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->open(cppArg0, cppArg1, cppArg2);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_open_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_permissions(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFile *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.permissions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "permissions", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QFileDevice::permissions()const
    // 1: static QFile::permissions(QString)
    if (numArgs == 0) {
        overloadId = 0; // permissions()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // permissions(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_permissions_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // permissions() const
        {

            if (!PyErr_Occurred()) {
                // permissions()const
                QFlags<QFileDevice::Permission> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? const_cast<const ::QFile *>(cppSelf)->::QFile::permissions()
                    : const_cast<const ::QFile *>(cppSelf)->permissions();
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, &cppResult);
            }
            break;
        }
        case 1: // permissions(const QString & filename)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // permissions(QString)
                QFlags<QFileDevice::Permission> cppResult = ::QFile::permissions(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_permissions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_readLink(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFile *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.readLink";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "readLink", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QFile::readLink()const
    // 1: static QFile::readLink(QString)
    if (numArgs == 0) {
        overloadId = 0; // readLink()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // readLink(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_readLink_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // readLink() const
        {

            if (!PyErr_Occurred()) {
                // readLink()const
                QString cppResult = const_cast<const ::QFile *>(cppSelf)->readLink();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QFile.readLink() const is deprecated", 1);
            break;
        }
        case 1: // readLink(const QString & fileName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // readLink(QString)
                QString cppResult = ::QFile::readLink(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QFile.readLink(const QString & fileName) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_readLink_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_remove(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFile *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.remove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "remove", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QFile::remove()
    // 1: static QFile::remove(QString)
    if (numArgs == 0) {
        overloadId = 0; // remove()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // remove(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_remove_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // remove()
        {

            if (!PyErr_Occurred()) {
                // remove()
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->remove();
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // remove(const QString & fileName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // remove(QString)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = ::QFile::remove(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_remove_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_rename(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFile *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.rename";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "rename", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFile::rename(QString)
    // 1: static QFile::rename(QString,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // rename(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // rename(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_rename_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // rename(const QString & newName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // rename(QString)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = cppSelf->rename(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // rename(const QString & oldName, const QString & newName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // rename(QString,QString)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = ::QFile::rename(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_rename_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_resize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFile *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.resize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "resize", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFileDevice::resize(qint64)
    // 1: static QFile::resize(QString,qint64)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        overloadId = 1; // resize(QString,qint64)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        overloadId = 0; // resize(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_resize_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // resize(qint64 sz)
        {
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // resize(qint64)
                bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QFile::resize(cppArg0)
                    : cppSelf->resize(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // resize(const QString & filename, qint64 sz)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qint64 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // resize(QString,qint64)
                bool cppResult = ::QFile::resize(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_resize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_setFileName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.setFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFile::setFileName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setFileName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_setFileName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFileName(QString)
            cppSelf->setFileName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileFunc_setFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_setPermissions(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFile *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.setPermissions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPermissions", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFileDevice::setPermissions(QFlags<QFileDevice::Permission>)
    // 1: static QFile::setPermissions(QString,QFlags<QFileDevice::Permission>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, (pyArgs[1])))) {
        overloadId = 1; // setPermissions(QString,QFlags<QFileDevice::Permission>)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QFILEDEVICE_PERMISSION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // setPermissions(QFlags<QFileDevice::Permission>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_setPermissions_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPermissions(QFlags<QFileDevice::Permission> permissionSpec)
        {
            ::QFlags<QFileDevice::Permission> cppArg0 = QFlags<QFileDevice::Permission>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setPermissions(QFlags<QFileDevice::Permission>)
                bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QFile::setPermissions(cppArg0)
                    : cppSelf->setPermissions(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // setPermissions(const QString & filename, QFlags<QFileDevice::Permission> permissionSpec)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QFileDevice::Permission> cppArg1 = QFlags<QFileDevice::Permission>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setPermissions(QString,QFlags<QFileDevice::Permission>)
                bool cppResult = ::QFile::setPermissions(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_setPermissions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QFile *>(cppSelf)->::QFile::size()
                : const_cast<const ::QFile *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileFunc_symLinkTarget(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QFile *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QFile.symLinkTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "symLinkTarget", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QFile::symLinkTarget()const
    // 1: static QFile::symLinkTarget(QString)
    if (numArgs == 0) {
        overloadId = 0; // symLinkTarget()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // symLinkTarget(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileFunc_symLinkTarget_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // symLinkTarget() const
        {

            if (!PyErr_Occurred()) {
                // symLinkTarget()const
                QString cppResult = const_cast<const ::QFile *>(cppSelf)->symLinkTarget();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // symLinkTarget(const QString & fileName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // symLinkTarget(QString)
                QString cppResult = ::QFile::symLinkTarget(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileFunc_symLinkTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyMethodDef Sbk_QFileMethod_copy = {
    "copy", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_copy), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QFileMethod_exists = {
    "exists", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_exists), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QFileMethod_link = {
    "link", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_link), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QFileMethod_moveToTrash = {
    "moveToTrash", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_moveToTrash), METH_VARARGS|METH_KEYWORDS|METH_STATIC
};

static PyMethodDef Sbk_QFileMethod_permissions = {
    "permissions", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_permissions), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QFileMethod_readLink = {
    "readLink", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_readLink), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QFileMethod_remove = {
    "remove", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_remove), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QFileMethod_rename = {
    "rename", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_rename), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QFileMethod_resize = {
    "resize", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_resize), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QFileMethod_setPermissions = {
    "setPermissions", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_setPermissions), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QFileMethod_symLinkTarget = {
    "symLinkTarget", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_symLinkTarget), METH_VARARGS|METH_STATIC
};


static const char *Sbk_QFile_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFile_methods[] = {
    Sbk_QFileMethod_copy,
    {"decodeName", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_decodeName), METH_O|METH_STATIC},
    {"encodeName", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_encodeName), METH_O|METH_STATIC},
    Sbk_QFileMethod_exists,
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_fileName), METH_NOARGS},
    Sbk_QFileMethod_link,
    Sbk_QFileMethod_moveToTrash,
    {"open", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_open), METH_VARARGS|METH_KEYWORDS},
    Sbk_QFileMethod_permissions,
    Sbk_QFileMethod_readLink,
    Sbk_QFileMethod_remove,
    Sbk_QFileMethod_rename,
    Sbk_QFileMethod_resize,
    {"setFileName", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_setFileName), METH_O},
    Sbk_QFileMethod_setPermissions,
    {"size", reinterpret_cast<PyCFunction>(Sbk_QFileFunc_size), METH_NOARGS},
    Sbk_QFileMethod_symLinkTarget,

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QFile_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    if (auto ob_dict = reinterpret_cast<SbkObject *>(self)->ob_dict) {
        if (auto meth = PyDict_GetItem(ob_dict, name)) {
            Py_INCREF(meth);
            return meth;
        }
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        if (auto meth = PyDict_GetItem(Py_TYPE(self)->tp_dict, tmp))
            return PyFunction_Check(meth) ? SBK_PyMethod_New(meth, self) : PySide::getMetaDataFromQObject(reinterpret_cast< ::QObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], reinterpret_cast<SbkObject *>(self))), self, name);
    }
    static PyMethodDef non_static_Sbk_QFileMethod_copy = {
        Sbk_QFileMethod_copy.ml_name,
        Sbk_QFileMethod_copy.ml_meth,
        Sbk_QFileMethod_copy.ml_flags & (~METH_STATIC),
        Sbk_QFileMethod_copy.ml_doc,
    };
    if (Shiboken::String::compare(name, "copy") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileMethod_copy, self, 0);
    static PyMethodDef non_static_Sbk_QFileMethod_exists = {
        Sbk_QFileMethod_exists.ml_name,
        Sbk_QFileMethod_exists.ml_meth,
        Sbk_QFileMethod_exists.ml_flags & (~METH_STATIC),
        Sbk_QFileMethod_exists.ml_doc,
    };
    if (Shiboken::String::compare(name, "exists") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileMethod_exists, self, 0);
    static PyMethodDef non_static_Sbk_QFileMethod_link = {
        Sbk_QFileMethod_link.ml_name,
        Sbk_QFileMethod_link.ml_meth,
        Sbk_QFileMethod_link.ml_flags & (~METH_STATIC),
        Sbk_QFileMethod_link.ml_doc,
    };
    if (Shiboken::String::compare(name, "link") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileMethod_link, self, 0);
    static PyMethodDef non_static_Sbk_QFileMethod_moveToTrash = {
        Sbk_QFileMethod_moveToTrash.ml_name,
        Sbk_QFileMethod_moveToTrash.ml_meth,
        Sbk_QFileMethod_moveToTrash.ml_flags & (~METH_STATIC),
        Sbk_QFileMethod_moveToTrash.ml_doc,
    };
    if (Shiboken::String::compare(name, "moveToTrash") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileMethod_moveToTrash, self, 0);
    static PyMethodDef non_static_Sbk_QFileMethod_permissions = {
        Sbk_QFileMethod_permissions.ml_name,
        Sbk_QFileMethod_permissions.ml_meth,
        Sbk_QFileMethod_permissions.ml_flags & (~METH_STATIC),
        Sbk_QFileMethod_permissions.ml_doc,
    };
    if (Shiboken::String::compare(name, "permissions") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileMethod_permissions, self, 0);
    static PyMethodDef non_static_Sbk_QFileMethod_readLink = {
        Sbk_QFileMethod_readLink.ml_name,
        Sbk_QFileMethod_readLink.ml_meth,
        Sbk_QFileMethod_readLink.ml_flags & (~METH_STATIC),
        Sbk_QFileMethod_readLink.ml_doc,
    };
    if (Shiboken::String::compare(name, "readLink") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileMethod_readLink, self, 0);
    static PyMethodDef non_static_Sbk_QFileMethod_remove = {
        Sbk_QFileMethod_remove.ml_name,
        Sbk_QFileMethod_remove.ml_meth,
        Sbk_QFileMethod_remove.ml_flags & (~METH_STATIC),
        Sbk_QFileMethod_remove.ml_doc,
    };
    if (Shiboken::String::compare(name, "remove") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileMethod_remove, self, 0);
    static PyMethodDef non_static_Sbk_QFileMethod_rename = {
        Sbk_QFileMethod_rename.ml_name,
        Sbk_QFileMethod_rename.ml_meth,
        Sbk_QFileMethod_rename.ml_flags & (~METH_STATIC),
        Sbk_QFileMethod_rename.ml_doc,
    };
    if (Shiboken::String::compare(name, "rename") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileMethod_rename, self, 0);
    static PyMethodDef non_static_Sbk_QFileMethod_resize = {
        Sbk_QFileMethod_resize.ml_name,
        Sbk_QFileMethod_resize.ml_meth,
        Sbk_QFileMethod_resize.ml_flags & (~METH_STATIC),
        Sbk_QFileMethod_resize.ml_doc,
    };
    if (Shiboken::String::compare(name, "resize") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileMethod_resize, self, 0);
    static PyMethodDef non_static_Sbk_QFileMethod_setPermissions = {
        Sbk_QFileMethod_setPermissions.ml_name,
        Sbk_QFileMethod_setPermissions.ml_meth,
        Sbk_QFileMethod_setPermissions.ml_flags & (~METH_STATIC),
        Sbk_QFileMethod_setPermissions.ml_doc,
    };
    if (Shiboken::String::compare(name, "setPermissions") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileMethod_setPermissions, self, 0);
    static PyMethodDef non_static_Sbk_QFileMethod_symLinkTarget = {
        Sbk_QFileMethod_symLinkTarget.ml_name,
        Sbk_QFileMethod_symLinkTarget.ml_meth,
        Sbk_QFileMethod_symLinkTarget.ml_flags & (~METH_STATIC),
        Sbk_QFileMethod_symLinkTarget.ml_doc,
    };
    if (Shiboken::String::compare(name, "symLinkTarget") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QFileMethod_symLinkTarget, self, 0);
    return PySide::getMetaDataFromQObject(reinterpret_cast< ::QObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], reinterpret_cast<SbkObject *>(self))), self, name);
}

static int Sbk_QFile_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QFILE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QFileWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QFile_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFile_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFile_Type = nullptr;
static SbkObjectType *Sbk_QFile_TypeF(void)
{
    return _Sbk_QFile_Type;
}

static PyType_Slot Sbk_QFile_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QFile_getattro)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QFile_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFile_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFile_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFile_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFile_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFile_spec = {
    "2:PySide2.QtCore.QFile",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFile_slots
};

} //extern "C"

static void *Sbk_QFile_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QFile *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFile_PythonToCpp_QFile_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFile_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFile_PythonToCpp_QFile_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFile_TypeF())))
        return QFile_PythonToCpp_QFile_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFile_PTR_CppToPython_QFile(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QFile *>(const_cast<void *>(cppIn)), Sbk_QFile_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFile_SignatureStrings[] = {
    "3:PySide2.QtCore.QFile(self)",
    "2:PySide2.QtCore.QFile(self,parent:PySide2.QtCore.QObject)",
    "1:PySide2.QtCore.QFile(self,name:QString)",
    "0:PySide2.QtCore.QFile(self,name:QString,parent:PySide2.QtCore.QObject)",
    "1:PySide2.QtCore.QFile.copy(fileName:QString,newName:QString)->bool",
    "0:PySide2.QtCore.QFile.copy(self,newName:QString)->bool",
    "1:PySide2.QtCore.QFile.decodeName(localFileName:PySide2.QtCore.QByteArray)->QString",
    "0:PySide2.QtCore.QFile.decodeName(localFileName:char*)->QString",
    "PySide2.QtCore.QFile.encodeName(fileName:QString)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QFile.exists(self)->bool",
    "0:PySide2.QtCore.QFile.exists(fileName:QString)->bool",
    "PySide2.QtCore.QFile.fileName(self)->QString",
    "1:PySide2.QtCore.QFile.link(self,newName:QString)->bool",
    "0:PySide2.QtCore.QFile.link(oldname:QString,newName:QString)->bool",
    "1:PySide2.QtCore.QFile.moveToTrash(self)->bool",
    "0:PySide2.QtCore.QFile.moveToTrash(fileName:QString,pathInTrash:QString*=nullptr)->bool",
    "1:PySide2.QtCore.QFile.open(self,flags:PySide2.QtCore.QIODevice.OpenMode)->bool",
    "0:PySide2.QtCore.QFile.open(self,fd:int,ioFlags:PySide2.QtCore.QIODevice.OpenMode,handleFlags:PySide2.QtCore.QFileDevice.FileHandleFlags=QFileDevice.DontCloseHandle)->bool",
    "1:PySide2.QtCore.QFile.permissions(self)->PySide2.QtCore.QFileDevice.Permissions",
    "0:PySide2.QtCore.QFile.permissions(filename:QString)->PySide2.QtCore.QFileDevice.Permissions",
    "1:PySide2.QtCore.QFile.readLink(self)->QString",
    "0:PySide2.QtCore.QFile.readLink(fileName:QString)->QString",
    "1:PySide2.QtCore.QFile.remove(self)->bool",
    "0:PySide2.QtCore.QFile.remove(fileName:QString)->bool",
    "1:PySide2.QtCore.QFile.rename(self,newName:QString)->bool",
    "0:PySide2.QtCore.QFile.rename(oldName:QString,newName:QString)->bool",
    "1:PySide2.QtCore.QFile.resize(self,sz:qint64)->bool",
    "0:PySide2.QtCore.QFile.resize(filename:QString,sz:qint64)->bool",
    "PySide2.QtCore.QFile.setFileName(self,name:QString)",
    "1:PySide2.QtCore.QFile.setPermissions(self,permissionSpec:PySide2.QtCore.QFileDevice.Permissions)->bool",
    "0:PySide2.QtCore.QFile.setPermissions(filename:QString,permissionSpec:PySide2.QtCore.QFileDevice.Permissions)->bool",
    "PySide2.QtCore.QFile.size(self)->qint64",
    "1:PySide2.QtCore.QFile.symLinkTarget(self)->QString",
    "0:PySide2.QtCore.QFile.symLinkTarget(fileName:QString)->QString",
    nullptr}; // Sentinel

void init_QFile(PyObject *module)
{
    _Sbk_QFile_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFile",
        "QFile*",
        &Sbk_QFile_spec,
        &Shiboken::callCppDestructor< ::QFile >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFILEDEVICE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFile_Type);
    InitSignatureStrings(pyType, QFile_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFile_Type), Sbk_QFile_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QFILE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFile_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFile_TypeF(),
        QFile_PythonToCpp_QFile_PTR,
        is_QFile_PythonToCpp_QFile_PTR_Convertible,
        QFile_PTR_CppToPython_QFile);

    Shiboken::Conversions::registerConverterName(converter, "QFile");
    Shiboken::Conversions::registerConverterName(converter, "QFile*");
    Shiboken::Conversions::registerConverterName(converter, "QFile&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFile).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFileWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QFile_TypeF(), &Sbk_QFile_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QFile_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QFile_TypeF(), &::QFile::staticMetaObject, sizeof(QFileWrapper));
}
