/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qdir_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <qdir.h>
#include <qfileinfo.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDir_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDir >()))
        return -1;

    ::QDir *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDir_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QDir", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QDir::QDir(QDir)
    // 1: QDir::QDir(QString)
    // 2: QDir::QDir(QString,QString,QFlags<QDir::SortFlag>,QFlags<QDir::Filter>)
    if (numArgs == 0) {
        overloadId = 1; // QDir(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QDir(QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // QDir(QString,QString,QFlags<QDir::SortFlag>,QFlags<QDir::Filter>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // QDir(QString,QString,QFlags<QDir::SortFlag>,QFlags<QDir::Filter>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 2; // QDir(QString,QString,QFlags<QDir::SortFlag>,QFlags<QDir::Filter>)
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QDir(QDir)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDir_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDir(const QDir & arg__1)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDir_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDir cppArg0_local;
            ::QDir *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDir(QDir)
                cptr = new ::QDir(*cppArg0);
            }
            break;
        }
        case 1: // QDir(const QString & path)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_path = Shiboken::String::createStaticString("path");
                if (PyDict_Contains(kwds, key_path)) {
                    value = PyDict_GetItem(kwds, key_path);
                    if (value && pyArgs[0]) {
                        errInfo = key_path;
                        Py_INCREF(errInfo);
                        goto Sbk_QDir_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                            goto Sbk_QDir_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_path);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDir_Init_TypeError;
                }
            }
            ::QString cppArg0 = QString();
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QDir(QString)
                cptr = new ::QDir(cppArg0);
            }
            break;
        }
        case 2: // QDir(const QString & path, const QString & nameFilter, QFlags<QDir::SortFlag> sort, QFlags<QDir::Filter> filter)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_sort = Shiboken::String::createStaticString("sort");
                if (PyDict_Contains(kwds, key_sort)) {
                    value = PyDict_GetItem(kwds, key_sort);
                    if (value && pyArgs[2]) {
                        errInfo = key_sort;
                        Py_INCREF(errInfo);
                        goto Sbk_QDir_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QDir_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sort);
                }
                static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
                if (PyDict_Contains(kwds, key_filter)) {
                    value = PyDict_GetItem(kwds, key_filter);
                    if (value && pyArgs[3]) {
                        errInfo = key_filter;
                        Py_INCREF(errInfo);
                        goto Sbk_QDir_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QDir_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_filter);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDir_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QDir::SortFlag> cppArg2 = QDir::SortFlags(QDir::SortFlag::Name|QDir::SortFlag::IgnoreCase);
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<QDir::Filter> cppArg3 = QDir::AllEntries;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QDir(QString,QString,QFlags<QDir::SortFlag>,QFlags<QDir::Filter>)
                cptr = new ::QDir(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDir >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDir_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDir_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDirFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(s))", PyObject_Type(self), qPrintable(cppSelf->path()));
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_absoluteFilePath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.absoluteFilePath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::absoluteFilePath(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // absoluteFilePath(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_absoluteFilePath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // absoluteFilePath(QString)const
            QString cppResult = const_cast<const ::QDir *>(cppSelf)->absoluteFilePath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_absoluteFilePath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_absolutePath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.absolutePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // absolutePath()const
            QString cppResult = const_cast<const ::QDir *>(cppSelf)->absolutePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_addResourceSearchPath(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.addResourceSearchPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDir::addResourceSearchPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // addResourceSearchPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_addResourceSearchPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addResourceSearchPath(QString)
            ::QDir::addResourceSearchPath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDirFunc_addResourceSearchPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_addSearchPath(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.addSearchPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addSearchPath", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QDir::addSearchPath(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // addSearchPath(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_addSearchPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addSearchPath(QString,QString)
            ::QDir::addSearchPath(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDirFunc_addSearchPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_canonicalPath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.canonicalPath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canonicalPath()const
            QString cppResult = const_cast<const ::QDir *>(cppSelf)->canonicalPath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_cd(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.cd";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::cd(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // cd(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_cd_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // cd(QString)
            bool cppResult = cppSelf->cd(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_cd_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_cdUp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.cdUp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cdUp()
            bool cppResult = cppSelf->cdUp();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_cleanPath(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.cleanPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDir::cleanPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // cleanPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_cleanPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // cleanPath(QString)
            QString cppResult = ::QDir::cleanPath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_cleanPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            uint cppResult = const_cast<const ::QDir *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_current(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.current";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // current()
            QDir cppResult = ::QDir::current();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_currentPath(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.currentPath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentPath()
            QString cppResult = ::QDir::currentPath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_dirName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.dirName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dirName()const
            QString cppResult = const_cast<const ::QDir *>(cppSelf)->dirName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_drives(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.drives";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // drives()
            QList<QFileInfo > cppResult = ::QDir::drives();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QFILEINFO_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_entryInfoList(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.entryInfoList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDirFunc_entryInfoList_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:entryInfoList", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QDir::entryInfoList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
    // 1: QDir::entryInfoList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
    if (numArgs == 0) {
        overloadId = 0; // entryInfoList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // entryInfoList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // entryInfoList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // entryInfoList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // entryInfoList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // entryInfoList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_entryInfoList_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // entryInfoList(QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_filters = Shiboken::String::createStaticString("filters");
                if (PyDict_Contains(kwds, key_filters)) {
                    value = PyDict_GetItem(kwds, key_filters);
                    if (value && pyArgs[0]) {
                        errInfo = key_filters;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirFunc_entryInfoList_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QDirFunc_entryInfoList_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_filters);
                }
                static PyObject *const key_sort = Shiboken::String::createStaticString("sort");
                if (PyDict_Contains(kwds, key_sort)) {
                    value = PyDict_GetItem(kwds, key_sort);
                    if (value && pyArgs[1]) {
                        errInfo = key_sort;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirFunc_entryInfoList_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QDirFunc_entryInfoList_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sort);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDirFunc_entryInfoList_TypeError;
                }
            }
            ::QFlags<QDir::Filter> cppArg0 = QDir::NoFilter;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QDir::SortFlag> cppArg1 = QDir::NoSort;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // entryInfoList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
                QList<QFileInfo > cppResult = const_cast<const ::QDir *>(cppSelf)->entryInfoList(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QFILEINFO_IDX], &cppResult);
            }
            break;
        }
        case 1: // entryInfoList(const QStringList & nameFilters, QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_filters = Shiboken::String::createStaticString("filters");
                if (PyDict_Contains(kwds, key_filters)) {
                    value = PyDict_GetItem(kwds, key_filters);
                    if (value && pyArgs[1]) {
                        errInfo = key_filters;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirFunc_entryInfoList_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QDirFunc_entryInfoList_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_filters);
                }
                static PyObject *const key_sort = Shiboken::String::createStaticString("sort");
                if (PyDict_Contains(kwds, key_sort)) {
                    value = PyDict_GetItem(kwds, key_sort);
                    if (value && pyArgs[2]) {
                        errInfo = key_sort;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirFunc_entryInfoList_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QDirFunc_entryInfoList_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sort);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDirFunc_entryInfoList_TypeError;
                }
            }
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QDir::Filter> cppArg1 = QDir::NoFilter;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QDir::SortFlag> cppArg2 = QDir::NoSort;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // entryInfoList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
                QList<QFileInfo > cppResult = const_cast<const ::QDir *>(cppSelf)->entryInfoList(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QFILEINFO_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_entryInfoList_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_entryList(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.entryList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDirFunc_entryList_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:entryList", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QDir::entryList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
    // 1: QDir::entryList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
    if (numArgs == 0) {
        overloadId = 0; // entryList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // entryList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // entryList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // entryList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // entryList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // entryList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_entryList_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // entryList(QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_filters = Shiboken::String::createStaticString("filters");
                if (PyDict_Contains(kwds, key_filters)) {
                    value = PyDict_GetItem(kwds, key_filters);
                    if (value && pyArgs[0]) {
                        errInfo = key_filters;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirFunc_entryList_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QDirFunc_entryList_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_filters);
                }
                static PyObject *const key_sort = Shiboken::String::createStaticString("sort");
                if (PyDict_Contains(kwds, key_sort)) {
                    value = PyDict_GetItem(kwds, key_sort);
                    if (value && pyArgs[1]) {
                        errInfo = key_sort;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirFunc_entryList_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QDirFunc_entryList_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sort);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDirFunc_entryList_TypeError;
                }
            }
            ::QFlags<QDir::Filter> cppArg0 = QDir::NoFilter;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QDir::SortFlag> cppArg1 = QDir::NoSort;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // entryList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
                QStringList cppResult = const_cast<const ::QDir *>(cppSelf)->entryList(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
            }
            break;
        }
        case 1: // entryList(const QStringList & nameFilters, QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_filters = Shiboken::String::createStaticString("filters");
                if (PyDict_Contains(kwds, key_filters)) {
                    value = PyDict_GetItem(kwds, key_filters);
                    if (value && pyArgs[1]) {
                        errInfo = key_filters;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirFunc_entryList_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QDirFunc_entryList_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_filters);
                }
                static PyObject *const key_sort = Shiboken::String::createStaticString("sort");
                if (PyDict_Contains(kwds, key_sort)) {
                    value = PyDict_GetItem(kwds, key_sort);
                    if (value && pyArgs[2]) {
                        errInfo = key_sort;
                        Py_INCREF(errInfo);
                        goto Sbk_QDirFunc_entryList_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QDirFunc_entryList_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sort);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDirFunc_entryList_TypeError;
                }
            }
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QDir::Filter> cppArg1 = QDir::NoFilter;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QDir::SortFlag> cppArg2 = QDir::NoSort;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // entryList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
                QStringList cppResult = const_cast<const ::QDir *>(cppSelf)->entryList(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_entryList_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_exists(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.exists";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "exists", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDir::exists()const
    // 1: QDir::exists(QString)const
    if (numArgs == 0) {
        overloadId = 0; // exists()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // exists(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_exists_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // exists() const
        {

            if (!PyErr_Occurred()) {
                // exists()const
                bool cppResult = const_cast<const ::QDir *>(cppSelf)->exists();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // exists(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // exists(QString)const
                bool cppResult = const_cast<const ::QDir *>(cppSelf)->exists(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_exists_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_filePath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.filePath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::filePath(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // filePath(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_filePath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // filePath(QString)const
            QString cppResult = const_cast<const ::QDir *>(cppSelf)->filePath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_filePath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_filter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.filter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filter()const
            QFlags<QDir::Filter> cppResult = const_cast<const ::QDir *>(cppSelf)->filter();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_fromNativeSeparators(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.fromNativeSeparators";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDir::fromNativeSeparators(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // fromNativeSeparators(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_fromNativeSeparators_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromNativeSeparators(QString)
            QString cppResult = ::QDir::fromNativeSeparators(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_fromNativeSeparators_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_home(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.home";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // home()
            QDir cppResult = ::QDir::home();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_homePath(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.homePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // homePath()
            QString cppResult = ::QDir::homePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_isAbsolute(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.isAbsolute";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAbsolute()const
            bool cppResult = const_cast<const ::QDir *>(cppSelf)->isAbsolute();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_isAbsolutePath(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.isAbsolutePath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDir::isAbsolutePath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // isAbsolutePath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_isAbsolutePath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isAbsolutePath(QString)
            bool cppResult = ::QDir::isAbsolutePath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_isAbsolutePath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_isEmpty(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.isEmpty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDirFunc_isEmpty_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:isEmpty", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDir::isEmpty(QFlags<QDir::Filter>)const
    if (numArgs == 0) {
        overloadId = 0; // isEmpty(QFlags<QDir::Filter>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // isEmpty(QFlags<QDir::Filter>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_isEmpty_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_filters = Shiboken::String::createStaticString("filters");
            if (PyDict_Contains(kwds, key_filters)) {
                value = PyDict_GetItem(kwds, key_filters);
                if (value && pyArgs[0]) {
                    errInfo = key_filters;
                    Py_INCREF(errInfo);
                    goto Sbk_QDirFunc_isEmpty_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QDirFunc_isEmpty_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filters);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDirFunc_isEmpty_TypeError;
            }
        }
        ::QFlags<QDir::Filter> cppArg0 = QDir::Filters(QDir::Filter::AllEntries|QDir::Filter::NoDotAndDotDot);
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // isEmpty(QFlags<QDir::Filter>)const
            bool cppResult = const_cast<const ::QDir *>(cppSelf)->isEmpty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_isEmpty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_isReadable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.isReadable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReadable()const
            bool cppResult = const_cast<const ::QDir *>(cppSelf)->isReadable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_isRelative(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.isRelative";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRelative()const
            bool cppResult = const_cast<const ::QDir *>(cppSelf)->isRelative();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_isRelativePath(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.isRelativePath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDir::isRelativePath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // isRelativePath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_isRelativePath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isRelativePath(QString)
            bool cppResult = ::QDir::isRelativePath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_isRelativePath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_isRoot(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.isRoot";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRoot()const
            bool cppResult = const_cast<const ::QDir *>(cppSelf)->isRoot();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_listSeparator(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.listSeparator";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // listSeparator()
            QChar cppResult = ::QDir::listSeparator();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_makeAbsolute(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.makeAbsolute";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // makeAbsolute()
            bool cppResult = cppSelf->makeAbsolute();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_match(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.match";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "match", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QDir::match(QString,QString)
    // 1: static QDir::match(QStringList,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 1; // match(QStringList,QString)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // match(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_match_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // match(const QString & filter, const QString & fileName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // match(QString,QString)
                bool cppResult = ::QDir::match(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // match(const QStringList & filters, const QString & fileName)
        {
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // match(QStringList,QString)
                bool cppResult = ::QDir::match(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_match_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_mkdir(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.mkdir";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::mkdir(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // mkdir(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_mkdir_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mkdir(QString)const
            bool cppResult = const_cast<const ::QDir *>(cppSelf)->mkdir(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_mkdir_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_mkpath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.mkpath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::mkpath(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // mkpath(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_mkpath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mkpath(QString)const
            bool cppResult = const_cast<const ::QDir *>(cppSelf)->mkpath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_mkpath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_nameFilters(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.nameFilters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nameFilters()const
            QStringList cppResult = const_cast<const ::QDir *>(cppSelf)->nameFilters();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_nameFiltersFromString(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.nameFiltersFromString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDir::nameFiltersFromString(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // nameFiltersFromString(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_nameFiltersFromString_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // nameFiltersFromString(QString)
            QStringList cppResult = ::QDir::nameFiltersFromString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_nameFiltersFromString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_path(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.path";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // path()const
            QString cppResult = const_cast<const ::QDir *>(cppSelf)->path();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_refresh(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.refresh";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // refresh()const
            const_cast<const ::QDir *>(cppSelf)->refresh();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QDirFunc_relativeFilePath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.relativeFilePath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::relativeFilePath(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // relativeFilePath(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_relativeFilePath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // relativeFilePath(QString)const
            QString cppResult = const_cast<const ::QDir *>(cppSelf)->relativeFilePath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_relativeFilePath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_remove(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.remove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::remove(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // remove(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_remove_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // remove(QString)
            bool cppResult = cppSelf->remove(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_remove_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_removeRecursively(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.removeRecursively";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeRecursively()
            bool cppResult = cppSelf->removeRecursively();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_rename(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.rename";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "rename", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDir::rename(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // rename(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_rename_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // rename(QString,QString)
            bool cppResult = cppSelf->rename(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_rename_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_rmdir(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.rmdir";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::rmdir(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // rmdir(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_rmdir_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rmdir(QString)const
            bool cppResult = const_cast<const ::QDir *>(cppSelf)->rmdir(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_rmdir_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_rmpath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.rmpath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::rmpath(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // rmpath(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_rmpath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rmpath(QString)const
            bool cppResult = const_cast<const ::QDir *>(cppSelf)->rmpath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_rmpath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_root(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.root";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // root()
            QDir cppResult = ::QDir::root();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_rootPath(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.rootPath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rootPath()
            QString cppResult = ::QDir::rootPath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_searchPaths(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.searchPaths";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDir::searchPaths(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // searchPaths(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_searchPaths_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // searchPaths(QString)
            QStringList cppResult = ::QDir::searchPaths(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_searchPaths_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_separator(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.separator";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // separator()
            QChar cppResult = ::QDir::separator();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_setCurrent(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.setCurrent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDir::setCurrent(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCurrent(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_setCurrent_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrent(QString)
            bool cppResult = ::QDir::setCurrent(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_setCurrent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_setFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.setFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::setFilter(QFlags<QDir::Filter>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFilter(QFlags<QDir::Filter>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_setFilter_TypeError;

    // Call function/method
    {
        ::QFlags<QDir::Filter> cppArg0 = QFlags<QDir::Filter>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFilter(QFlags<QDir::Filter>)
            cppSelf->setFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDirFunc_setFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_setNameFilters(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.setNameFilters";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::setNameFilters(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setNameFilters(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_setNameFilters_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNameFilters(QStringList)
            cppSelf->setNameFilters(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDirFunc_setNameFilters_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_setPath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.setPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::setPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_setPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPath(QString)
            cppSelf->setPath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDirFunc_setPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_setSearchPaths(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.setSearchPaths";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setSearchPaths", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QDir::setSearchPaths(QString,QStringList)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
        overloadId = 0; // setSearchPaths(QString,QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_setSearchPaths_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QStringList cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setSearchPaths(QString,QStringList)
            ::QDir::setSearchPaths(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDirFunc_setSearchPaths_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_setSorting(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.setSorting";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::setSorting(QFlags<QDir::SortFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSorting(QFlags<QDir::SortFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_setSorting_TypeError;

    // Call function/method
    {
        ::QFlags<QDir::SortFlag> cppArg0 = QFlags<QDir::SortFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSorting(QFlags<QDir::SortFlag>)
            cppSelf->setSorting(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDirFunc_setSorting_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_sorting(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.sorting";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sorting()const
            QFlags<QDir::SortFlag> cppResult = const_cast<const ::QDir *>(cppSelf)->sorting();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDir::swap(QDir&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QDir&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDir cppArg0_local;
        ::QDir *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QDir&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDirFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDirFunc_temp(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.temp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // temp()
            QDir cppResult = ::QDir::temp();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_tempPath(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.tempPath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tempPath()
            QString cppResult = ::QDir::tempPath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDirFunc_toNativeSeparators(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDir.toNativeSeparators";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDir::toNativeSeparators(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toNativeSeparators(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDirFunc_toNativeSeparators_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toNativeSeparators(QString)
            QString cppResult = ::QDir::toNativeSeparators(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDirFunc_toNativeSeparators_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDir___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDir_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDir_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QDirFunc___reduce__), METH_NOARGS},
    {"absoluteFilePath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_absoluteFilePath), METH_O},
    {"absolutePath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_absolutePath), METH_NOARGS},
    {"addResourceSearchPath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_addResourceSearchPath), METH_O|METH_STATIC},
    {"addSearchPath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_addSearchPath), METH_VARARGS|METH_STATIC},
    {"canonicalPath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_canonicalPath), METH_NOARGS},
    {"cd", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_cd), METH_O},
    {"cdUp", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_cdUp), METH_NOARGS},
    {"cleanPath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_cleanPath), METH_O|METH_STATIC},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_count), METH_NOARGS},
    {"current", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_current), METH_NOARGS|METH_STATIC},
    {"currentPath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_currentPath), METH_NOARGS|METH_STATIC},
    {"dirName", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_dirName), METH_NOARGS},
    {"drives", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_drives), METH_NOARGS|METH_STATIC},
    {"entryInfoList", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_entryInfoList), METH_VARARGS|METH_KEYWORDS},
    {"entryList", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_entryList), METH_VARARGS|METH_KEYWORDS},
    {"exists", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_exists), METH_VARARGS},
    {"filePath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_filePath), METH_O},
    {"filter", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_filter), METH_NOARGS},
    {"fromNativeSeparators", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_fromNativeSeparators), METH_O|METH_STATIC},
    {"home", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_home), METH_NOARGS|METH_STATIC},
    {"homePath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_homePath), METH_NOARGS|METH_STATIC},
    {"isAbsolute", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_isAbsolute), METH_NOARGS},
    {"isAbsolutePath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_isAbsolutePath), METH_O|METH_STATIC},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_isEmpty), METH_VARARGS|METH_KEYWORDS},
    {"isReadable", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_isReadable), METH_NOARGS},
    {"isRelative", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_isRelative), METH_NOARGS},
    {"isRelativePath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_isRelativePath), METH_O|METH_STATIC},
    {"isRoot", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_isRoot), METH_NOARGS},
    {"listSeparator", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_listSeparator), METH_NOARGS|METH_STATIC},
    {"makeAbsolute", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_makeAbsolute), METH_NOARGS},
    {"match", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_match), METH_VARARGS|METH_STATIC},
    {"mkdir", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_mkdir), METH_O},
    {"mkpath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_mkpath), METH_O},
    {"nameFilters", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_nameFilters), METH_NOARGS},
    {"nameFiltersFromString", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_nameFiltersFromString), METH_O|METH_STATIC},
    {"path", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_path), METH_NOARGS},
    {"refresh", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_refresh), METH_NOARGS},
    {"relativeFilePath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_relativeFilePath), METH_O},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_remove), METH_O},
    {"removeRecursively", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_removeRecursively), METH_NOARGS},
    {"rename", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_rename), METH_VARARGS},
    {"rmdir", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_rmdir), METH_O},
    {"rmpath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_rmpath), METH_O},
    {"root", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_root), METH_NOARGS|METH_STATIC},
    {"rootPath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_rootPath), METH_NOARGS|METH_STATIC},
    {"searchPaths", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_searchPaths), METH_O|METH_STATIC},
    {"separator", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_separator), METH_NOARGS|METH_STATIC},
    {"setCurrent", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_setCurrent), METH_O|METH_STATIC},
    {"setFilter", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_setFilter), METH_O},
    {"setNameFilters", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_setNameFilters), METH_O},
    {"setPath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_setPath), METH_O},
    {"setSearchPaths", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_setSearchPaths), METH_VARARGS|METH_STATIC},
    {"setSorting", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_setSorting), METH_O},
    {"sorting", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_sorting), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_swap), METH_O},
    {"temp", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_temp), METH_NOARGS|METH_STATIC},
    {"tempPath", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_tempPath), METH_NOARGS|METH_STATIC},
    {"toNativeSeparators", reinterpret_cast<PyCFunction>(Sbk_QDirFunc_toNativeSeparators), METH_O|METH_STATIC},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDir___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QDir_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), (pyArg)))) {
                // operator!=(const QDir & dir) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDir cppArg0_local;
                ::QDir *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), (pyArg)))) {
                // operator==(const QDir & dir) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDir cppArg0_local;
                ::QDir *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QDir_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QDir_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QDir_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDir_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QDir__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDir_Type = nullptr;
static SbkObjectType *Sbk_QDir_TypeF(void)
{
    return _Sbk_QDir_Type;
}

static PyType_Slot Sbk_QDir_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QDir__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDir_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDir_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QDir_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDir_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDir_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QDir_spec = {
    "2:PySide2.QtCore.QDir",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDir_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QDir_Filter___and__(PyObject *self, PyObject *pyArg)
{
    ::QDir::Filters cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QDir::Filters>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QDir::Filters>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QDir::Filters>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QDir::Filters>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QDir_Filter___or__(PyObject *self, PyObject *pyArg)
{
    ::QDir::Filters cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QDir::Filters>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QDir::Filters>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QDir::Filters>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QDir::Filters>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QDir_Filter___xor__(PyObject *self, PyObject *pyArg)
{
    ::QDir::Filters cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QDir::Filters>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QDir::Filters>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QDir::Filters>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QDir::Filters>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QDir_Filter___invert__(PyObject *self, PyObject *pyArg)
{
    ::QDir::Filters cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, self, &cppSelf);
    ::QDir::Filters cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QDir_Filter_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QDir_Filter__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QDir_Filter_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_Filter__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_Filter__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_Filter_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_Filter___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_Filter___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_Filter___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_Filter___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_Filter_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_Filter_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_Filter_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_QDir_SortFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QDir::SortFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QDir::SortFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QDir::SortFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QDir::SortFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QDir::SortFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QDir_SortFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QDir::SortFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QDir::SortFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QDir::SortFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QDir::SortFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QDir::SortFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QDir_SortFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QDir::SortFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QDir::SortFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QDir::SortFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QDir::SortFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QDir::SortFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QDir_SortFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QDir::SortFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, self, &cppSelf);
    ::QDir::SortFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QDir_SortFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QDir_SortFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QDir_SortFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_SortFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_SortFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_SortFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_SortFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_SortFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_SortFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_SortFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_SortFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_SortFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QDir_SortFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QDir_Filter_PythonToCpp_QDir_Filter(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDir::Filter *>(cppOut) =
        static_cast<::QDir::Filter>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDir_Filter_PythonToCpp_QDir_Filter_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX]))
        return QDir_Filter_PythonToCpp_QDir_Filter;
    return {};
}
static PyObject *QDir_Filter_CppToPython_QDir_Filter(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDir::Filter *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX], castCppIn);

}

static void QFlags_QDir_Filter__PythonToCpp_QFlags_QDir_Filter_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QDir::Filter> *>(cppOut) =
        ::QFlags<QDir::Filter>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QDir_Filter__PythonToCpp_QFlags_QDir_Filter__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX]))
        return QFlags_QDir_Filter__PythonToCpp_QFlags_QDir_Filter_;
    return {};
}
static PyObject *QFlags_QDir_Filter__CppToPython_QFlags_QDir_Filter_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QDir::Filter> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX]));

}

static void QDir_Filter_PythonToCpp_QFlags_QDir_Filter_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QDir::Filter> *>(cppOut) =
        ::QFlags<QDir::Filter>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QDir_Filter_PythonToCpp_QFlags_QDir_Filter__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX]))
        return QDir_Filter_PythonToCpp_QFlags_QDir_Filter_;
    return {};
}
static void number_PythonToCpp_QFlags_QDir_Filter_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QDir::Filter> *>(cppOut) =
        ::QFlags<QDir::Filter>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QDir_Filter__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX]))
        return number_PythonToCpp_QFlags_QDir_Filter_;
    return {};
}
static void QDir_SortFlag_PythonToCpp_QDir_SortFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDir::SortFlag *>(cppOut) =
        static_cast<::QDir::SortFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDir_SortFlag_PythonToCpp_QDir_SortFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX]))
        return QDir_SortFlag_PythonToCpp_QDir_SortFlag;
    return {};
}
static PyObject *QDir_SortFlag_CppToPython_QDir_SortFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDir::SortFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX], castCppIn);

}

static void QFlags_QDir_SortFlag__PythonToCpp_QFlags_QDir_SortFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QDir::SortFlag> *>(cppOut) =
        ::QFlags<QDir::SortFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QDir_SortFlag__PythonToCpp_QFlags_QDir_SortFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX]))
        return QFlags_QDir_SortFlag__PythonToCpp_QFlags_QDir_SortFlag_;
    return {};
}
static PyObject *QFlags_QDir_SortFlag__CppToPython_QFlags_QDir_SortFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QDir::SortFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX]));

}

static void QDir_SortFlag_PythonToCpp_QFlags_QDir_SortFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QDir::SortFlag> *>(cppOut) =
        ::QFlags<QDir::SortFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QDir_SortFlag_PythonToCpp_QFlags_QDir_SortFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX]))
        return QDir_SortFlag_PythonToCpp_QFlags_QDir_SortFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QDir_SortFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QDir::SortFlag> *>(cppOut) =
        ::QFlags<QDir::SortFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QDir_SortFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX]))
        return number_PythonToCpp_QFlags_QDir_SortFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDir_PythonToCpp_QDir_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDir_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDir_PythonToCpp_QDir_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDir_TypeF())))
        return QDir_PythonToCpp_QDir_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDir_PTR_CppToPython_QDir(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDir *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDir_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDir_COPY_CppToPython_QDir(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDir_TypeF(), new ::QDir(*reinterpret_cast<const ::QDir *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDir_PythonToCpp_QDir_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDir *>(cppOut) = *reinterpret_cast< ::QDir *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDir_PythonToCpp_QDir_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDir_TypeF())))
        return QDir_PythonToCpp_QDir_COPY;
    return {};
}

// Implicit conversions.
static void constQStringREF_PythonToCpp_QDir(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QDir *>(cppOut) = ::QDir(cppIn);
}
static PythonToCppFunc is_constQStringREF_PythonToCpp_QDir_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constQStringREF_PythonToCpp_QDir;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDir_SignatureStrings[] = {
    "2:PySide2.QtCore.QDir(self,arg__1:PySide2.QtCore.QDir)",
    "1:PySide2.QtCore.QDir(self,path:QString=QString())",
    "0:PySide2.QtCore.QDir(self,path:QString,nameFilter:QString,sort:PySide2.QtCore.QDir.SortFlags=QDir.SortFlags(Name | IgnoreCase),filter:PySide2.QtCore.QDir.Filters=QDir.AllEntries)",
    "PySide2.QtCore.QDir.__reduce__(self)->PyObject",
    "PySide2.QtCore.QDir.absoluteFilePath(self,fileName:QString)->QString",
    "PySide2.QtCore.QDir.absolutePath(self)->QString",
    "PySide2.QtCore.QDir.addResourceSearchPath(path:QString)",
    "PySide2.QtCore.QDir.addSearchPath(prefix:QString,path:QString)",
    "PySide2.QtCore.QDir.canonicalPath(self)->QString",
    "PySide2.QtCore.QDir.cd(self,dirName:QString)->bool",
    "PySide2.QtCore.QDir.cdUp(self)->bool",
    "PySide2.QtCore.QDir.cleanPath(path:QString)->QString",
    "PySide2.QtCore.QDir.count(self)->uint",
    "PySide2.QtCore.QDir.current()->PySide2.QtCore.QDir",
    "PySide2.QtCore.QDir.currentPath()->QString",
    "PySide2.QtCore.QDir.dirName(self)->QString",
    "PySide2.QtCore.QDir.drives()->QList[PySide2.QtCore.QFileInfo]",
    "1:PySide2.QtCore.QDir.entryInfoList(self,filters:PySide2.QtCore.QDir.Filters=QDir.NoFilter,sort:PySide2.QtCore.QDir.SortFlags=QDir.NoSort)->QList[PySide2.QtCore.QFileInfo]",
    "0:PySide2.QtCore.QDir.entryInfoList(self,nameFilters:QStringList,filters:PySide2.QtCore.QDir.Filters=QDir.NoFilter,sort:PySide2.QtCore.QDir.SortFlags=QDir.NoSort)->QList[PySide2.QtCore.QFileInfo]",
    "1:PySide2.QtCore.QDir.entryList(self,filters:PySide2.QtCore.QDir.Filters=QDir.NoFilter,sort:PySide2.QtCore.QDir.SortFlags=QDir.NoSort)->QStringList",
    "0:PySide2.QtCore.QDir.entryList(self,nameFilters:QStringList,filters:PySide2.QtCore.QDir.Filters=QDir.NoFilter,sort:PySide2.QtCore.QDir.SortFlags=QDir.NoSort)->QStringList",
    "1:PySide2.QtCore.QDir.exists(self)->bool",
    "0:PySide2.QtCore.QDir.exists(self,name:QString)->bool",
    "PySide2.QtCore.QDir.filePath(self,fileName:QString)->QString",
    "PySide2.QtCore.QDir.filter(self)->PySide2.QtCore.QDir.Filters",
    "PySide2.QtCore.QDir.fromNativeSeparators(pathName:QString)->QString",
    "PySide2.QtCore.QDir.home()->PySide2.QtCore.QDir",
    "PySide2.QtCore.QDir.homePath()->QString",
    "PySide2.QtCore.QDir.isAbsolute(self)->bool",
    "PySide2.QtCore.QDir.isAbsolutePath(path:QString)->bool",
    "PySide2.QtCore.QDir.isEmpty(self,filters:PySide2.QtCore.QDir.Filters=QDir.Filters(AllEntries | NoDotAndDotDot))->bool",
    "PySide2.QtCore.QDir.isReadable(self)->bool",
    "PySide2.QtCore.QDir.isRelative(self)->bool",
    "PySide2.QtCore.QDir.isRelativePath(path:QString)->bool",
    "PySide2.QtCore.QDir.isRoot(self)->bool",
    "PySide2.QtCore.QDir.listSeparator()->QChar",
    "PySide2.QtCore.QDir.makeAbsolute(self)->bool",
    "1:PySide2.QtCore.QDir.match(filter:QString,fileName:QString)->bool",
    "0:PySide2.QtCore.QDir.match(filters:QStringList,fileName:QString)->bool",
    "PySide2.QtCore.QDir.mkdir(self,dirName:QString)->bool",
    "PySide2.QtCore.QDir.mkpath(self,dirPath:QString)->bool",
    "PySide2.QtCore.QDir.nameFilters(self)->QStringList",
    "PySide2.QtCore.QDir.nameFiltersFromString(nameFilter:QString)->QStringList",
    "PySide2.QtCore.QDir.path(self)->QString",
    "PySide2.QtCore.QDir.refresh(self)",
    "PySide2.QtCore.QDir.relativeFilePath(self,fileName:QString)->QString",
    "PySide2.QtCore.QDir.remove(self,fileName:QString)->bool",
    "PySide2.QtCore.QDir.removeRecursively(self)->bool",
    "PySide2.QtCore.QDir.rename(self,oldName:QString,newName:QString)->bool",
    "PySide2.QtCore.QDir.rmdir(self,dirName:QString)->bool",
    "PySide2.QtCore.QDir.rmpath(self,dirPath:QString)->bool",
    "PySide2.QtCore.QDir.root()->PySide2.QtCore.QDir",
    "PySide2.QtCore.QDir.rootPath()->QString",
    "PySide2.QtCore.QDir.searchPaths(prefix:QString)->QStringList",
    "PySide2.QtCore.QDir.separator()->QChar",
    "PySide2.QtCore.QDir.setCurrent(path:QString)->bool",
    "PySide2.QtCore.QDir.setFilter(self,filter:PySide2.QtCore.QDir.Filters)",
    "PySide2.QtCore.QDir.setNameFilters(self,nameFilters:QStringList)",
    "PySide2.QtCore.QDir.setPath(self,path:QString)",
    "PySide2.QtCore.QDir.setSearchPaths(prefix:QString,searchPaths:QStringList)",
    "PySide2.QtCore.QDir.setSorting(self,sort:PySide2.QtCore.QDir.SortFlags)",
    "PySide2.QtCore.QDir.sorting(self)->PySide2.QtCore.QDir.SortFlags",
    "PySide2.QtCore.QDir.swap(self,other:PySide2.QtCore.QDir)",
    "PySide2.QtCore.QDir.temp()->PySide2.QtCore.QDir",
    "PySide2.QtCore.QDir.tempPath()->QString",
    "PySide2.QtCore.QDir.toNativeSeparators(pathName:QString)->QString",
    "PySide2.QtCore.QDir.__copy__()",
    nullptr}; // Sentinel

void init_QDir(PyObject *module)
{
    _Sbk_QDir_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDir",
        "QDir",
        &Sbk_QDir_spec,
        &Shiboken::callCppDestructor< ::QDir >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDir_Type);
    InitSignatureStrings(pyType, QDir_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDir_Type), Sbk_QDir_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDir_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDir_TypeF(),
        QDir_PythonToCpp_QDir_PTR,
        is_QDir_PythonToCpp_QDir_PTR_Convertible,
        QDir_PTR_CppToPython_QDir,
        QDir_COPY_CppToPython_QDir);

    Shiboken::Conversions::registerConverterName(converter, "QDir");
    Shiboken::Conversions::registerConverterName(converter, "QDir*");
    Shiboken::Conversions::registerConverterName(converter, "QDir&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDir).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDir_PythonToCpp_QDir_COPY,
        is_QDir_PythonToCpp_QDir_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQStringREF_PythonToCpp_QDir,
        is_constQStringREF_PythonToCpp_QDir_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Filter'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QDir.Filters", SbkPySide2_QtCore_QDir_Filter_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDir_TypeF(),
        "Filter",
        "2:PySide2.QtCore.QDir.Filter",
        "QDir::Filter",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "Dirs", (long) QDir::Filter::Dirs))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "Files", (long) QDir::Filter::Files))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "Drives", (long) QDir::Filter::Drives))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "NoSymLinks", (long) QDir::Filter::NoSymLinks))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "AllEntries", (long) QDir::Filter::AllEntries))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "TypeMask", (long) QDir::Filter::TypeMask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "Readable", (long) QDir::Filter::Readable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "Writable", (long) QDir::Filter::Writable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "Executable", (long) QDir::Filter::Executable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "PermissionMask", (long) QDir::Filter::PermissionMask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "Modified", (long) QDir::Filter::Modified))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "Hidden", (long) QDir::Filter::Hidden))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "System", (long) QDir::Filter::System))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "AccessMask", (long) QDir::Filter::AccessMask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "AllDirs", (long) QDir::Filter::AllDirs))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "CaseSensitive", (long) QDir::Filter::CaseSensitive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "NoDot", (long) QDir::Filter::NoDot))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "NoDotDot", (long) QDir::Filter::NoDotDot))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "NoDotAndDotDot", (long) QDir::Filter::NoDotAndDotDot))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
        Sbk_QDir_TypeF(), "NoFilter", (long) QDir::Filter::NoFilter))
        return;
    // Register converter for enum 'QDir::Filter'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX],
            QDir_Filter_CppToPython_QDir_Filter);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDir_Filter_PythonToCpp_QDir_Filter,
            is_QDir_Filter_PythonToCpp_QDir_Filter_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QDIR_FILTER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDir::Filter");
        Shiboken::Conversions::registerConverterName(converter, "Filter");
    }
    // Register converter for flag 'QFlags<QDir::Filter>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX],
            QFlags_QDir_Filter__CppToPython_QFlags_QDir_Filter_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDir_Filter_PythonToCpp_QFlags_QDir_Filter_,
            is_QDir_Filter_PythonToCpp_QFlags_QDir_Filter__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QDir_Filter__PythonToCpp_QFlags_QDir_Filter_,
            is_QFlags_QDir_Filter__PythonToCpp_QFlags_QDir_Filter__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QDir_Filter_,
            is_number_PythonToCpp_QFlags_QDir_Filter__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDir::Filters");
        Shiboken::Conversions::registerConverterName(converter, "Filters");
    }
    // End of 'Filter' enum/flags.

    // Initialization of enum 'SortFlag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QDir.SortFlags", SbkPySide2_QtCore_QDir_SortFlag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDir_TypeF(),
        "SortFlag",
        "2:PySide2.QtCore.QDir.SortFlag",
        "QDir::SortFlag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "Name", (long) QDir::SortFlag::Name))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "Time", (long) QDir::SortFlag::Time))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "Size", (long) QDir::SortFlag::Size))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "Unsorted", (long) QDir::SortFlag::Unsorted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "SortByMask", (long) QDir::SortFlag::SortByMask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "DirsFirst", (long) QDir::SortFlag::DirsFirst))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "Reversed", (long) QDir::SortFlag::Reversed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "IgnoreCase", (long) QDir::SortFlag::IgnoreCase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "DirsLast", (long) QDir::SortFlag::DirsLast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "LocaleAware", (long) QDir::SortFlag::LocaleAware))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "Type", (long) QDir::SortFlag::Type))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
        Sbk_QDir_TypeF(), "NoSort", (long) QDir::SortFlag::NoSort))
        return;
    // Register converter for enum 'QDir::SortFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX],
            QDir_SortFlag_CppToPython_QDir_SortFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDir_SortFlag_PythonToCpp_QDir_SortFlag,
            is_QDir_SortFlag_PythonToCpp_QDir_SortFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDir::SortFlag");
        Shiboken::Conversions::registerConverterName(converter, "SortFlag");
    }
    // Register converter for flag 'QFlags<QDir::SortFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX],
            QFlags_QDir_SortFlag__CppToPython_QFlags_QDir_SortFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDir_SortFlag_PythonToCpp_QFlags_QDir_SortFlag_,
            is_QDir_SortFlag_PythonToCpp_QFlags_QDir_SortFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QDir_SortFlag__PythonToCpp_QFlags_QDir_SortFlag_,
            is_QFlags_QDir_SortFlag__PythonToCpp_QFlags_QDir_SortFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QDir_SortFlag_,
            is_number_PythonToCpp_QFlags_QDir_SortFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDir::SortFlags");
        Shiboken::Conversions::registerConverterName(converter, "SortFlags");
    }
    // End of 'SortFlag' enum/flags.

    qRegisterMetaType< ::QDir::Filter >("QDir::Filter");
    qRegisterMetaType< ::QDir::Filters >("QDir::Filters");
    qRegisterMetaType< ::QDir::SortFlag >("QDir::SortFlag");
    qRegisterMetaType< ::QDir::SortFlags >("QDir::SortFlags");
}
