/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qdeadlinetimer_wrapper.h"

// inner classes

// Extra includes
#include <QPair>
#include <qdeadlinetimer.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDeadlineTimer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDeadlineTimer >()))
        return -1;

    ::QDeadlineTimer *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDeadlineTimer_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QDeadlineTimer", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QDeadlineTimer::QDeadlineTimer(QDeadlineTimer::ForeverConstant,Qt::TimerType)
    // 1: QDeadlineTimer::QDeadlineTimer(Qt::TimerType)
    // 2: QDeadlineTimer::QDeadlineTimer(QDeadlineTimer)
    // 3: QDeadlineTimer::QDeadlineTimer(qint64,Qt::TimerType)
    if (numArgs == 0) {
        overloadId = 1; // QDeadlineTimer(Qt::TimerType)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // QDeadlineTimer(qint64,Qt::TimerType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 3; // QDeadlineTimer(qint64,Qt::TimerType)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QDeadlineTimer(Qt::TimerType)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_FOREVERCONSTANT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QDeadlineTimer(QDeadlineTimer::ForeverConstant,Qt::TimerType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // QDeadlineTimer(QDeadlineTimer::ForeverConstant,Qt::TimerType)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QDeadlineTimer(QDeadlineTimer)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDeadlineTimer_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDeadlineTimer(QDeadlineTimer::ForeverConstant arg__1, Qt::TimerType type_)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_type_ = Shiboken::String::createStaticString("type_");
                if (PyDict_Contains(kwds, key_type_)) {
                    value = PyDict_GetItem(kwds, key_type_);
                    if (value && pyArgs[1]) {
                        errInfo = key_type_;
                        Py_INCREF(errInfo);
                        goto Sbk_QDeadlineTimer_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QDeadlineTimer_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_type_);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDeadlineTimer_Init_TypeError;
                }
            }
            ::QDeadlineTimer::ForeverConstant cppArg0{QDeadlineTimer::Forever};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::TimerType cppArg1 = Qt::CoarseTimer;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QDeadlineTimer(QDeadlineTimer::ForeverConstant,Qt::TimerType)
                cptr = new ::QDeadlineTimer(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // QDeadlineTimer(Qt::TimerType type_)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_type_ = Shiboken::String::createStaticString("type_");
                if (PyDict_Contains(kwds, key_type_)) {
                    value = PyDict_GetItem(kwds, key_type_);
                    if (value && pyArgs[0]) {
                        errInfo = key_type_;
                        Py_INCREF(errInfo);
                        goto Sbk_QDeadlineTimer_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QDeadlineTimer_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_type_);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDeadlineTimer_Init_TypeError;
                }
            }
            ::Qt::TimerType cppArg0 = Qt::CoarseTimer;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QDeadlineTimer(Qt::TimerType)
                cptr = new ::QDeadlineTimer(cppArg0);
            }
            break;
        }
        case 2: // QDeadlineTimer(const QDeadlineTimer & QDeadlineTimer)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDeadlineTimer_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDeadlineTimer cppArg0_local;
            ::QDeadlineTimer *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDeadlineTimer(QDeadlineTimer)
                cptr = new ::QDeadlineTimer(*cppArg0);
            }
            break;
        }
        case 3: // QDeadlineTimer(qint64 msecs, Qt::TimerType type)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_type = Shiboken::String::createStaticString("type");
                if (PyDict_Contains(kwds, key_type)) {
                    value = PyDict_GetItem(kwds, key_type);
                    if (value && pyArgs[1]) {
                        errInfo = key_type;
                        Py_INCREF(errInfo);
                        goto Sbk_QDeadlineTimer_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QDeadlineTimer_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_type);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDeadlineTimer_Init_TypeError;
                }
            }
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::TimerType cppArg1 = Qt::CoarseTimer;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QDeadlineTimer(qint64,Qt::TimerType)
                cptr = new ::QDeadlineTimer(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDeadlineTimer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDeadlineTimer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDeadlineTimer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDeadlineTimerFunc__q_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer._q_data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // _q_data()const
            QPair<qint64,unsigned int > cppResult = const_cast<const ::QDeadlineTimer *>(cppSelf)->_q_data();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QPAIR_QINT64_UNSIGNEDINT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDeadlineTimerFunc_addNSecs(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.addNSecs";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addNSecs", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QDeadlineTimer::addNSecs(QDeadlineTimer,qint64)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        overloadId = 0; // addNSecs(QDeadlineTimer,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDeadlineTimerFunc_addNSecs_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDeadlineTimer cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qint64 cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addNSecs(QDeadlineTimer,qint64)
            QDeadlineTimer cppResult = ::QDeadlineTimer::addNSecs(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDeadlineTimerFunc_addNSecs_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDeadlineTimerFunc_current(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.current";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDeadlineTimerFunc_current_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:current", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QDeadlineTimer::current(Qt::TimerType)
    if (numArgs == 0) {
        overloadId = 0; // current(Qt::TimerType)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // current(Qt::TimerType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDeadlineTimerFunc_current_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timerType = Shiboken::String::createStaticString("timerType");
            if (PyDict_Contains(kwds, key_timerType)) {
                value = PyDict_GetItem(kwds, key_timerType);
                if (value && pyArgs[0]) {
                    errInfo = key_timerType;
                    Py_INCREF(errInfo);
                    goto Sbk_QDeadlineTimerFunc_current_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QDeadlineTimerFunc_current_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timerType);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDeadlineTimerFunc_current_TypeError;
            }
        }
        ::Qt::TimerType cppArg0 = Qt::CoarseTimer;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // current(Qt::TimerType)
            QDeadlineTimer cppResult = ::QDeadlineTimer::current(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDeadlineTimerFunc_current_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDeadlineTimerFunc_deadline(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.deadline";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deadline()const
            qint64 cppResult = const_cast<const ::QDeadlineTimer *>(cppSelf)->deadline();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDeadlineTimerFunc_deadlineNSecs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.deadlineNSecs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deadlineNSecs()const
            qint64 cppResult = const_cast<const ::QDeadlineTimer *>(cppSelf)->deadlineNSecs();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDeadlineTimerFunc_hasExpired(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.hasExpired";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasExpired()const
            bool cppResult = const_cast<const ::QDeadlineTimer *>(cppSelf)->hasExpired();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDeadlineTimerFunc_isForever(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.isForever";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isForever()const
            bool cppResult = const_cast<const ::QDeadlineTimer *>(cppSelf)->isForever();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDeadlineTimerFunc_remainingTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.remainingTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // remainingTime()const
            qint64 cppResult = const_cast<const ::QDeadlineTimer *>(cppSelf)->remainingTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDeadlineTimerFunc_remainingTimeNSecs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.remainingTimeNSecs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // remainingTimeNSecs()const
            qint64 cppResult = const_cast<const ::QDeadlineTimer *>(cppSelf)->remainingTimeNSecs();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDeadlineTimerFunc_setDeadline(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.setDeadline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDeadlineTimerFunc_setDeadline_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDeadlineTimerFunc_setDeadline_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setDeadline", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDeadlineTimer::setDeadline(qint64,Qt::TimerType)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setDeadline(qint64,Qt::TimerType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setDeadline(qint64,Qt::TimerType)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDeadlineTimerFunc_setDeadline_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timerType = Shiboken::String::createStaticString("timerType");
            if (PyDict_Contains(kwds, key_timerType)) {
                value = PyDict_GetItem(kwds, key_timerType);
                if (value && pyArgs[1]) {
                    errInfo = key_timerType;
                    Py_INCREF(errInfo);
                    goto Sbk_QDeadlineTimerFunc_setDeadline_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QDeadlineTimerFunc_setDeadline_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timerType);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDeadlineTimerFunc_setDeadline_TypeError;
            }
        }
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::TimerType cppArg1 = Qt::CoarseTimer;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setDeadline(qint64,Qt::TimerType)
            cppSelf->setDeadline(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDeadlineTimerFunc_setDeadline_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDeadlineTimerFunc_setPreciseDeadline(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.setPreciseDeadline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDeadlineTimerFunc_setPreciseDeadline_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDeadlineTimerFunc_setPreciseDeadline_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setPreciseDeadline", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QDeadlineTimer::setPreciseDeadline(qint64,qint64,Qt::TimerType)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setPreciseDeadline(qint64,qint64,Qt::TimerType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setPreciseDeadline(qint64,qint64,Qt::TimerType)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // setPreciseDeadline(qint64,qint64,Qt::TimerType)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDeadlineTimerFunc_setPreciseDeadline_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_nsecs = Shiboken::String::createStaticString("nsecs");
            if (PyDict_Contains(kwds, key_nsecs)) {
                value = PyDict_GetItem(kwds, key_nsecs);
                if (value && pyArgs[1]) {
                    errInfo = key_nsecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QDeadlineTimerFunc_setPreciseDeadline_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1]))))
                        goto Sbk_QDeadlineTimerFunc_setPreciseDeadline_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_nsecs);
            }
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[2]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QDeadlineTimerFunc_setPreciseDeadline_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QDeadlineTimerFunc_setPreciseDeadline_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDeadlineTimerFunc_setPreciseDeadline_TypeError;
            }
        }
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qint64 cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::Qt::TimerType cppArg2 = Qt::CoarseTimer;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setPreciseDeadline(qint64,qint64,Qt::TimerType)
            cppSelf->setPreciseDeadline(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDeadlineTimerFunc_setPreciseDeadline_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDeadlineTimerFunc_setPreciseRemainingTime(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.setPreciseRemainingTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDeadlineTimerFunc_setPreciseRemainingTime_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDeadlineTimerFunc_setPreciseRemainingTime_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setPreciseRemainingTime", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QDeadlineTimer::setPreciseRemainingTime(qint64,qint64,Qt::TimerType)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setPreciseRemainingTime(qint64,qint64,Qt::TimerType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setPreciseRemainingTime(qint64,qint64,Qt::TimerType)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // setPreciseRemainingTime(qint64,qint64,Qt::TimerType)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDeadlineTimerFunc_setPreciseRemainingTime_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_nsecs = Shiboken::String::createStaticString("nsecs");
            if (PyDict_Contains(kwds, key_nsecs)) {
                value = PyDict_GetItem(kwds, key_nsecs);
                if (value && pyArgs[1]) {
                    errInfo = key_nsecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QDeadlineTimerFunc_setPreciseRemainingTime_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1]))))
                        goto Sbk_QDeadlineTimerFunc_setPreciseRemainingTime_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_nsecs);
            }
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[2]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QDeadlineTimerFunc_setPreciseRemainingTime_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QDeadlineTimerFunc_setPreciseRemainingTime_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDeadlineTimerFunc_setPreciseRemainingTime_TypeError;
            }
        }
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qint64 cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::Qt::TimerType cppArg2 = Qt::CoarseTimer;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setPreciseRemainingTime(qint64,qint64,Qt::TimerType)
            cppSelf->setPreciseRemainingTime(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDeadlineTimerFunc_setPreciseRemainingTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDeadlineTimerFunc_setRemainingTime(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.setRemainingTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDeadlineTimerFunc_setRemainingTime_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDeadlineTimerFunc_setRemainingTime_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setRemainingTime", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDeadlineTimer::setRemainingTime(qint64,Qt::TimerType)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setRemainingTime(qint64,Qt::TimerType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setRemainingTime(qint64,Qt::TimerType)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDeadlineTimerFunc_setRemainingTime_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[1]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QDeadlineTimerFunc_setRemainingTime_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QDeadlineTimerFunc_setRemainingTime_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDeadlineTimerFunc_setRemainingTime_TypeError;
            }
        }
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::TimerType cppArg1 = Qt::CoarseTimer;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setRemainingTime(qint64,Qt::TimerType)
            cppSelf->setRemainingTime(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDeadlineTimerFunc_setRemainingTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDeadlineTimerFunc_setTimerType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.setTimerType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDeadlineTimer::setTimerType(Qt::TimerType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTimerType(Qt::TimerType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDeadlineTimerFunc_setTimerType_TypeError;

    // Call function/method
    {
        ::Qt::TimerType cppArg0{Qt::PreciseTimer};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTimerType(Qt::TimerType)
            cppSelf->setTimerType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDeadlineTimerFunc_setTimerType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDeadlineTimerFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDeadlineTimer::swap(QDeadlineTimer&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QDeadlineTimer&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDeadlineTimerFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDeadlineTimer cppArg0_local;
        ::QDeadlineTimer *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QDeadlineTimer&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDeadlineTimerFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDeadlineTimerFunc_timerType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.timerType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timerType()const
            Qt::TimerType cppResult = const_cast<const ::QDeadlineTimer *>(cppSelf)->timerType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDeadlineTimer___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDeadlineTimer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDeadlineTimer_methods[] = {
    {"_q_data", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc__q_data), METH_NOARGS},
    {"addNSecs", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_addNSecs), METH_VARARGS|METH_STATIC},
    {"current", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_current), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"deadline", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_deadline), METH_NOARGS},
    {"deadlineNSecs", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_deadlineNSecs), METH_NOARGS},
    {"hasExpired", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_hasExpired), METH_NOARGS},
    {"isForever", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_isForever), METH_NOARGS},
    {"remainingTime", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_remainingTime), METH_NOARGS},
    {"remainingTimeNSecs", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_remainingTimeNSecs), METH_NOARGS},
    {"setDeadline", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_setDeadline), METH_VARARGS|METH_KEYWORDS},
    {"setPreciseDeadline", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_setPreciseDeadline), METH_VARARGS|METH_KEYWORDS},
    {"setPreciseRemainingTime", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_setPreciseRemainingTime), METH_VARARGS|METH_KEYWORDS},
    {"setRemainingTime", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_setRemainingTime), METH_VARARGS|METH_KEYWORDS},
    {"setTimerType", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_setTimerType), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_swap), METH_O},
    {"timerType", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimerFunc_timerType), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDeadlineTimer___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QDeadlineTimerFunc___iadd__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.__iadd__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDeadlineTimer::operator+=(qint64)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // operator+=(qint64)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDeadlineTimerFunc___iadd___TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator+=(qint64)
            (*cppSelf) += cppArg0;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QDeadlineTimerFunc___iadd___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDeadlineTimerFunc___isub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDeadlineTimer.__isub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDeadlineTimer::operator-=(qint64)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // operator-=(qint64)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDeadlineTimerFunc___isub___TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // operator-=(qint64)
            (*cppSelf) -= cppArg0;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QDeadlineTimerFunc___isub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

} // extern "C"

static int Sbk_QDeadlineTimer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDeadlineTimer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDeadlineTimer_Type = nullptr;
static SbkObjectType *Sbk_QDeadlineTimer_TypeF(void)
{
    return _Sbk_QDeadlineTimer_Type;
}

static PyType_Slot Sbk_QDeadlineTimer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDeadlineTimer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDeadlineTimer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDeadlineTimer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDeadlineTimer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_inplace_add, (void *)Sbk_QDeadlineTimerFunc___iadd__},
    {Py_nb_inplace_subtract, (void *)Sbk_QDeadlineTimerFunc___isub__},
    {0, nullptr}
};
static PyType_Spec Sbk_QDeadlineTimer_spec = {
    "2:PySide2.QtCore.QDeadlineTimer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDeadlineTimer_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QDeadlineTimer_ForeverConstant_PythonToCpp_QDeadlineTimer_ForeverConstant(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDeadlineTimer::ForeverConstant *>(cppOut) =
        static_cast<::QDeadlineTimer::ForeverConstant>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDeadlineTimer_ForeverConstant_PythonToCpp_QDeadlineTimer_ForeverConstant_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_FOREVERCONSTANT_IDX]))
        return QDeadlineTimer_ForeverConstant_PythonToCpp_QDeadlineTimer_ForeverConstant;
    return {};
}
static PyObject *QDeadlineTimer_ForeverConstant_CppToPython_QDeadlineTimer_ForeverConstant(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDeadlineTimer::ForeverConstant *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_FOREVERCONSTANT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDeadlineTimer_PythonToCpp_QDeadlineTimer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDeadlineTimer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDeadlineTimer_PythonToCpp_QDeadlineTimer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDeadlineTimer_TypeF())))
        return QDeadlineTimer_PythonToCpp_QDeadlineTimer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDeadlineTimer_PTR_CppToPython_QDeadlineTimer(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDeadlineTimer *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDeadlineTimer_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDeadlineTimer_COPY_CppToPython_QDeadlineTimer(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDeadlineTimer_TypeF(), new ::QDeadlineTimer(*reinterpret_cast<const ::QDeadlineTimer *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDeadlineTimer_PythonToCpp_QDeadlineTimer_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDeadlineTimer *>(cppOut) = *reinterpret_cast< ::QDeadlineTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDeadlineTimer_PythonToCpp_QDeadlineTimer_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDeadlineTimer_TypeF())))
        return QDeadlineTimer_PythonToCpp_QDeadlineTimer_COPY;
    return {};
}

// Implicit conversions.
static void QDeadlineTimer_ForeverConstant_PythonToCpp_QDeadlineTimer(PyObject *pyIn, void *cppOut) {
    ::QDeadlineTimer::ForeverConstant cppIn{QDeadlineTimer::Forever};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_FOREVERCONSTANT_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QDeadlineTimer *>(cppOut) = ::QDeadlineTimer(cppIn);
}
static PythonToCppFunc is_QDeadlineTimer_ForeverConstant_PythonToCpp_QDeadlineTimer_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_FOREVERCONSTANT_IDX], pyIn))
        return QDeadlineTimer_ForeverConstant_PythonToCpp_QDeadlineTimer;
    return {};
}

static void Qt_TimerType_PythonToCpp_QDeadlineTimer(PyObject *pyIn, void *cppOut) {
    ::Qt::TimerType cppIn{Qt::PreciseTimer};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QDeadlineTimer *>(cppOut) = ::QDeadlineTimer(cppIn);
}
static PythonToCppFunc is_Qt_TimerType_PythonToCpp_QDeadlineTimer_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX], pyIn))
        return Qt_TimerType_PythonToCpp_QDeadlineTimer;
    return {};
}

static void qint64_PythonToCpp_QDeadlineTimer(PyObject *pyIn, void *cppOut) {
    qint64 cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyIn, &cppIn);
    *reinterpret_cast<::QDeadlineTimer *>(cppOut) = ::QDeadlineTimer(cppIn);
}
static PythonToCppFunc is_qint64_PythonToCpp_QDeadlineTimer_Convertible(PyObject *pyIn) {
    if (PyLong_Check(pyIn))
        return qint64_PythonToCpp_QDeadlineTimer;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDeadlineTimer_SignatureStrings[] = {
    "3:PySide2.QtCore.QDeadlineTimer(self,arg__1:PySide2.QtCore.QDeadlineTimer.ForeverConstant,type_:PySide2.QtCore.Qt.TimerType=Qt.CoarseTimer)",
    "2:PySide2.QtCore.QDeadlineTimer(self,type_:PySide2.QtCore.Qt.TimerType=Qt.CoarseTimer)",
    "1:PySide2.QtCore.QDeadlineTimer(self,QDeadlineTimer:PySide2.QtCore.QDeadlineTimer)",
    "0:PySide2.QtCore.QDeadlineTimer(self,msecs:qint64,type:PySide2.QtCore.Qt.TimerType=Qt.CoarseTimer)",
    "PySide2.QtCore.QDeadlineTimer._q_data(self)->QPair[qint64, unsigned int]",
    "PySide2.QtCore.QDeadlineTimer.addNSecs(dt:PySide2.QtCore.QDeadlineTimer,nsecs:qint64)->PySide2.QtCore.QDeadlineTimer",
    "PySide2.QtCore.QDeadlineTimer.current(timerType:PySide2.QtCore.Qt.TimerType=Qt.CoarseTimer)->PySide2.QtCore.QDeadlineTimer",
    "PySide2.QtCore.QDeadlineTimer.deadline(self)->qint64",
    "PySide2.QtCore.QDeadlineTimer.deadlineNSecs(self)->qint64",
    "PySide2.QtCore.QDeadlineTimer.hasExpired(self)->bool",
    "PySide2.QtCore.QDeadlineTimer.isForever(self)->bool",
    "PySide2.QtCore.QDeadlineTimer.remainingTime(self)->qint64",
    "PySide2.QtCore.QDeadlineTimer.remainingTimeNSecs(self)->qint64",
    "PySide2.QtCore.QDeadlineTimer.setDeadline(self,msecs:qint64,timerType:PySide2.QtCore.Qt.TimerType=Qt.CoarseTimer)",
    "PySide2.QtCore.QDeadlineTimer.setPreciseDeadline(self,secs:qint64,nsecs:qint64=0,type:PySide2.QtCore.Qt.TimerType=Qt.CoarseTimer)",
    "PySide2.QtCore.QDeadlineTimer.setPreciseRemainingTime(self,secs:qint64,nsecs:qint64=0,type:PySide2.QtCore.Qt.TimerType=Qt.CoarseTimer)",
    "PySide2.QtCore.QDeadlineTimer.setRemainingTime(self,msecs:qint64,type:PySide2.QtCore.Qt.TimerType=Qt.CoarseTimer)",
    "PySide2.QtCore.QDeadlineTimer.setTimerType(self,type:PySide2.QtCore.Qt.TimerType)",
    "PySide2.QtCore.QDeadlineTimer.swap(self,other:PySide2.QtCore.QDeadlineTimer)",
    "PySide2.QtCore.QDeadlineTimer.timerType(self)->PySide2.QtCore.Qt.TimerType",
    "PySide2.QtCore.QDeadlineTimer.__copy__()",
    "PySide2.QtCore.QDeadlineTimer.__iadd__(self,msecs:qint64)->PySide2.QtCore.QDeadlineTimer",
    "PySide2.QtCore.QDeadlineTimer.__isub__(self,msecs:qint64)->PySide2.QtCore.QDeadlineTimer",
    nullptr}; // Sentinel

void init_QDeadlineTimer(PyObject *module)
{
    _Sbk_QDeadlineTimer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDeadlineTimer",
        "QDeadlineTimer",
        &Sbk_QDeadlineTimer_spec,
        &Shiboken::callCppDestructor< ::QDeadlineTimer >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDeadlineTimer_Type);
    InitSignatureStrings(pyType, QDeadlineTimer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDeadlineTimer_Type), Sbk_QDeadlineTimer_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDeadlineTimer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDeadlineTimer_TypeF(),
        QDeadlineTimer_PythonToCpp_QDeadlineTimer_PTR,
        is_QDeadlineTimer_PythonToCpp_QDeadlineTimer_PTR_Convertible,
        QDeadlineTimer_PTR_CppToPython_QDeadlineTimer,
        QDeadlineTimer_COPY_CppToPython_QDeadlineTimer);

    Shiboken::Conversions::registerConverterName(converter, "QDeadlineTimer");
    Shiboken::Conversions::registerConverterName(converter, "QDeadlineTimer*");
    Shiboken::Conversions::registerConverterName(converter, "QDeadlineTimer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDeadlineTimer).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDeadlineTimer_PythonToCpp_QDeadlineTimer_COPY,
        is_QDeadlineTimer_PythonToCpp_QDeadlineTimer_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDeadlineTimer_ForeverConstant_PythonToCpp_QDeadlineTimer,
        is_QDeadlineTimer_ForeverConstant_PythonToCpp_QDeadlineTimer_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Qt_TimerType_PythonToCpp_QDeadlineTimer,
        is_Qt_TimerType_PythonToCpp_QDeadlineTimer_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        qint64_PythonToCpp_QDeadlineTimer,
        is_qint64_PythonToCpp_QDeadlineTimer_Convertible);

    // Initialization of enums.

    // Initialization of enum 'ForeverConstant'.
    SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_FOREVERCONSTANT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDeadlineTimer_TypeF(),
        "ForeverConstant",
        "2:PySide2.QtCore.QDeadlineTimer.ForeverConstant",
        "QDeadlineTimer::ForeverConstant");
    if (!SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_FOREVERCONSTANT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_FOREVERCONSTANT_IDX],
        Sbk_QDeadlineTimer_TypeF(), "Forever", (long) QDeadlineTimer::ForeverConstant::Forever))
        return;
    // Register converter for enum 'QDeadlineTimer::ForeverConstant'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_FOREVERCONSTANT_IDX],
            QDeadlineTimer_ForeverConstant_CppToPython_QDeadlineTimer_ForeverConstant);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDeadlineTimer_ForeverConstant_PythonToCpp_QDeadlineTimer_ForeverConstant,
            is_QDeadlineTimer_ForeverConstant_PythonToCpp_QDeadlineTimer_ForeverConstant_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_FOREVERCONSTANT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDeadlineTimer::ForeverConstant");
        Shiboken::Conversions::registerConverterName(converter, "ForeverConstant");
    }
    // End of 'ForeverConstant' enum.

    qRegisterMetaType< ::QDeadlineTimer::ForeverConstant >("QDeadlineTimer::ForeverConstant");
}
