/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcoreapplication_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// ========================================================================
// START of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-init)]
static void QCoreApplicationConstructor(PyObject *self, PyObject *pyargv, QCoreApplicationWrapper **cptr)
{
    static int argc;
    static char **argv;
    PyObject *stringlist = PyTuple_GET_ITEM(pyargv, 0);
    if (Shiboken::listToArgcArgv(stringlist, &argc, &argv, "PySideApp")) {
        *cptr = new QCoreApplicationWrapper(argc, argv);
        Shiboken::Object::releaseOwnership(reinterpret_cast<SbkObject *>(self));
        PySide::registerCleanupFunction(&PySide::destroyQCoreApplication);
    }
}
// END of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-init)]
// ========================================================================

// End of code injection


// Native ---------------------------------------------------------

void QCoreApplicationWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QCoreApplicationWrapper::QCoreApplicationWrapper(int & argc, char ** argv, int arg__3) : QCoreApplication(argc, argv, arg__3)
{
    resetPyMethodCache();
    // ... middle
}

void QCoreApplicationWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCoreApplicationWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QCoreApplicationWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCoreApplicationWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QCoreApplicationWrapper::event(::QEvent * arg__1)
{
    if (m_PyMethodCache[4])
        return this->::QCoreApplication::event(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QCoreApplication::event(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCoreApplication.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QCoreApplicationWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCoreApplication.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QCoreApplicationWrapper::notify(::QObject * arg__1, ::QEvent * arg__2)
{
    if (m_PyMethodCache[7])
        return this->::QCoreApplication::notify(arg__1, arg__2);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "notify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QCoreApplication::notify(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__2)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCoreApplication.notify", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QCoreApplicationWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QCoreApplicationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QCoreApplication::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QCoreApplicationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QCoreApplication::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QCoreApplicationWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QCoreApplicationWrapper *>(this));
        return QCoreApplication::qt_metacast(_clname);
}

QCoreApplicationWrapper::~QCoreApplicationWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCoreApplication_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCoreApplication >()))
        return -1;

    ::QCoreApplicationWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QCoreApplication", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QCoreApplication::QCoreApplication()
    // 1: QCoreApplication::QCoreApplication(QStringList)
    if (numArgs == 0) {
        overloadId = 0; // QCoreApplication()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[0])))) {
        overloadId = 1; // QCoreApplication(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplication_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCoreApplication()
        {

            if (!PyErr_Occurred()) {
                // QCoreApplication()
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-2)]
                PyObject *empty = PyTuple_New(2);
                if (!PyTuple_SetItem(empty, 0, PyList_New(0))) {
                    QCoreApplicationConstructor(self, empty, &cptr);
                }
                // END of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-2)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // QCoreApplication(QStringList arg__1)
        {
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // QCoreApplication(QStringList)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-1)]
                QCoreApplicationConstructor(self, args, &cptr);
                // END of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-1)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCoreApplication >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCoreApplication_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QCoreApplication_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QCoreApplication_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCoreApplicationFunc_addLibraryPath(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.addLibraryPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::addLibraryPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // addLibraryPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_addLibraryPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addLibraryPath(QString)
            ::QCoreApplication::addLibraryPath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_addLibraryPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_applicationDirPath(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.applicationDirPath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // applicationDirPath()
            QString cppResult = ::QCoreApplication::applicationDirPath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_applicationFilePath(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.applicationFilePath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // applicationFilePath()
            QString cppResult = ::QCoreApplication::applicationFilePath();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_applicationName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.applicationName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // applicationName()
            QString cppResult = ::QCoreApplication::applicationName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_applicationPid(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.applicationPid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // applicationPid()
            qint64 cppResult = ::QCoreApplication::applicationPid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_applicationVersion(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.applicationVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // applicationVersion()
            QString cppResult = ::QCoreApplication::applicationVersion();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_arguments(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.arguments";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // arguments()
            QStringList cppResult = ::QCoreApplication::arguments();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_closingDown(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.closingDown";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // closingDown()
            bool cppResult = ::QCoreApplication::closingDown();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCoreApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOREAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QCoreApplication::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCoreApplicationFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_eventDispatcher(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.eventDispatcher";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // eventDispatcher()
            QAbstractEventDispatcher * cppResult = ::QCoreApplication::eventDispatcher();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_exec_(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.exec_";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exec()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            int cppResult = ::QCoreApplication::exec();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_exit(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.exit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCoreApplicationFunc_exit_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:exit", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QCoreApplication::exit(int)
    if (numArgs == 0) {
        overloadId = 0; // exit(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // exit(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_exit_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_retcode = Shiboken::String::createStaticString("retcode");
            if (PyDict_Contains(kwds, key_retcode)) {
                value = PyDict_GetItem(kwds, key_retcode);
                if (value && pyArgs[0]) {
                    errInfo = key_retcode;
                    Py_INCREF(errInfo);
                    goto Sbk_QCoreApplicationFunc_exit_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QCoreApplicationFunc_exit_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_retcode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCoreApplicationFunc_exit_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // exit(int)
            ::QCoreApplication::exit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_exit_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_flush(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.flush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flush()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            ::QCoreApplication::flush();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCoreApplicationFunc_hasPendingEvents(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.hasPendingEvents";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasPendingEvents()
            bool cppResult = ::QCoreApplication::hasPendingEvents();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_installNativeEventFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCoreApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOREAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.installNativeEventFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCoreApplication::installNativeEventFilter(QAbstractNativeEventFilter*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTNATIVEEVENTFILTER_IDX]), (pyArg)))) {
        overloadId = 0; // installNativeEventFilter(QAbstractNativeEventFilter*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_installNativeEventFilter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractNativeEventFilter *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // installNativeEventFilter(QAbstractNativeEventFilter*)
            cppSelf->installNativeEventFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_installNativeEventFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_installTranslator(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.installTranslator";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::installTranslator(QTranslator*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTRANSLATOR_IDX]), (pyArg)))) {
        overloadId = 0; // installTranslator(QTranslator*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_installTranslator_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTranslator *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // installTranslator(QTranslator*)
            bool cppResult = ::QCoreApplication::installTranslator(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCoreApplicationFunc_installTranslator_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_instance(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.instance";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // instance()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-instance)]
            PyObject *pyApp = Py_None;
            if (qApp) {
                pyApp = reinterpret_cast<PyObject *>(
                    Shiboken::BindingManager::instance().retrieveWrapper(qApp));
                if (!pyApp)
                    pyApp = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOREAPPLICATION_IDX]), qApp);
                    // this will keep app live after python exit (extra ref)
            }
            // PYSIDE-571: make sure that we return the singleton "None"
            if (Py_TYPE(pyApp) == Py_TYPE(Py_None))
                Py_DECREF(MakeQAppWrapper(nullptr));
            pyResult = pyApp;
            Py_XINCREF(pyResult);
            // END of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-instance)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_isQuitLockEnabled(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.isQuitLockEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isQuitLockEnabled()
            bool cppResult = ::QCoreApplication::isQuitLockEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_isSetuidAllowed(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.isSetuidAllowed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSetuidAllowed()
            bool cppResult = ::QCoreApplication::isSetuidAllowed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_libraryPaths(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.libraryPaths";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // libraryPaths()
            QStringList cppResult = ::QCoreApplication::libraryPaths();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_notify(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCoreApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOREAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.notify";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "notify", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCoreApplication::notify(QObject*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // notify(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_notify_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // notify(QObject*,QEvent*)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QCoreApplication::notify(cppArg0, cppArg1)
                : cppSelf->notify(cppArg0, cppArg1);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCoreApplicationFunc_notify_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_organizationDomain(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.organizationDomain";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // organizationDomain()
            QString cppResult = ::QCoreApplication::organizationDomain();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_organizationName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.organizationName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // organizationName()
            QString cppResult = ::QCoreApplication::organizationName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_postEvent(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.postEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCoreApplicationFunc_postEvent_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCoreApplicationFunc_postEvent_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:postEvent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QCoreApplication::postEvent(QObject*,QEvent*,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // postEvent(QObject*,QEvent*,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // postEvent(QObject*,QEvent*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_postEvent_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_priority = Shiboken::String::createStaticString("priority");
            if (PyDict_Contains(kwds, key_priority)) {
                value = PyDict_GetItem(kwds, key_priority);
                if (value && pyArgs[2]) {
                    errInfo = key_priority;
                    Py_INCREF(errInfo);
                    goto Sbk_QCoreApplicationFunc_postEvent_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QCoreApplicationFunc_postEvent_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_priority);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCoreApplicationFunc_postEvent_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = Qt::NormalEventPriority;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // postEvent(QObject*,QEvent*,int)
            ::QCoreApplication::postEvent(cppArg0, cppArg1, cppArg2);

            // Ownership transferences.
            Shiboken::Object::releaseOwnership(pyArgs[1]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_postEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_processEvents(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.processEvents";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCoreApplicationFunc_processEvents_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:processEvents", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QCoreApplication::processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
    // 1: static QCoreApplication::processEvents(QFlags<QEventLoop::ProcessEventsFlag>,int)
    if (numArgs == 0) {
        overloadId = 0; // processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // processEvents(QFlags<QEventLoop::ProcessEventsFlag>,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_processEvents_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[0]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QCoreApplicationFunc_processEvents_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QCoreApplicationFunc_processEvents_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCoreApplicationFunc_processEvents_TypeError;
                }
            }
            ::QFlags<QEventLoop::ProcessEventsFlag> cppArg0 = QEventLoop::AllEvents;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                ::QCoreApplication::processEvents(cppArg0);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            }
            break;
        }
        case 1: // processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags, int maxtime)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCoreApplicationFunc_processEvents_TypeError;
            }
            ::QFlags<QEventLoop::ProcessEventsFlag> cppArg0 = QFlags<QEventLoop::ProcessEventsFlag>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // processEvents(QFlags<QEventLoop::ProcessEventsFlag>,int)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                ::QCoreApplication::processEvents(cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_processEvents_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_quit(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.quit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // quit()
            ::QCoreApplication::quit();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCoreApplicationFunc_removeLibraryPath(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.removeLibraryPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::removeLibraryPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // removeLibraryPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_removeLibraryPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeLibraryPath(QString)
            ::QCoreApplication::removeLibraryPath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_removeLibraryPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_removeNativeEventFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCoreApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOREAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.removeNativeEventFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCoreApplication::removeNativeEventFilter(QAbstractNativeEventFilter*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTNATIVEEVENTFILTER_IDX]), (pyArg)))) {
        overloadId = 0; // removeNativeEventFilter(QAbstractNativeEventFilter*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_removeNativeEventFilter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractNativeEventFilter *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeNativeEventFilter(QAbstractNativeEventFilter*)
            cppSelf->removeNativeEventFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_removeNativeEventFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_removePostedEvents(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.removePostedEvents";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCoreApplicationFunc_removePostedEvents_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCoreApplicationFunc_removePostedEvents_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:removePostedEvents", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QCoreApplication::removePostedEvents(QObject*,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // removePostedEvents(QObject*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // removePostedEvents(QObject*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_removePostedEvents_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_eventType = Shiboken::String::createStaticString("eventType");
            if (PyDict_Contains(kwds, key_eventType)) {
                value = PyDict_GetItem(kwds, key_eventType);
                if (value && pyArgs[1]) {
                    errInfo = key_eventType;
                    Py_INCREF(errInfo);
                    goto Sbk_QCoreApplicationFunc_removePostedEvents_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QCoreApplicationFunc_removePostedEvents_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_eventType);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCoreApplicationFunc_removePostedEvents_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // removePostedEvents(QObject*,int)
            ::QCoreApplication::removePostedEvents(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_removePostedEvents_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_removeTranslator(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.removeTranslator";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::removeTranslator(QTranslator*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTRANSLATOR_IDX]), (pyArg)))) {
        overloadId = 0; // removeTranslator(QTranslator*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_removeTranslator_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTranslator *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeTranslator(QTranslator*)
            bool cppResult = ::QCoreApplication::removeTranslator(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCoreApplicationFunc_removeTranslator_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_sendEvent(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.sendEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sendEvent", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QCoreApplication::sendEvent(QObject*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // sendEvent(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_sendEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // sendEvent(QObject*,QEvent*)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = ::QCoreApplication::sendEvent(cppArg0, cppArg1);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCoreApplicationFunc_sendEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_sendPostedEvents(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.sendPostedEvents";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCoreApplicationFunc_sendPostedEvents_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:sendPostedEvents", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QCoreApplication::sendPostedEvents(QObject*,int)
    if (numArgs == 0) {
        overloadId = 0; // sendPostedEvents(QObject*,int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // sendPostedEvents(QObject*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // sendPostedEvents(QObject*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_sendPostedEvents_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_receiver = Shiboken::String::createStaticString("receiver");
            if (PyDict_Contains(kwds, key_receiver)) {
                value = PyDict_GetItem(kwds, key_receiver);
                if (value && pyArgs[0]) {
                    errInfo = key_receiver;
                    Py_INCREF(errInfo);
                    goto Sbk_QCoreApplicationFunc_sendPostedEvents_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QCoreApplicationFunc_sendPostedEvents_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_receiver);
            }
            static PyObject *const key_event_type = Shiboken::String::createStaticString("event_type");
            if (PyDict_Contains(kwds, key_event_type)) {
                value = PyDict_GetItem(kwds, key_event_type);
                if (value && pyArgs[1]) {
                    errInfo = key_event_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QCoreApplicationFunc_sendPostedEvents_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QCoreApplicationFunc_sendPostedEvents_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_event_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCoreApplicationFunc_sendPostedEvents_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // sendPostedEvents(QObject*,int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            ::QCoreApplication::sendPostedEvents(cppArg0, cppArg1);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_sendPostedEvents_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_setApplicationName(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.setApplicationName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::setApplicationName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setApplicationName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_setApplicationName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setApplicationName(QString)
            ::QCoreApplication::setApplicationName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_setApplicationName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_setApplicationVersion(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.setApplicationVersion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::setApplicationVersion(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setApplicationVersion(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_setApplicationVersion_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setApplicationVersion(QString)
            ::QCoreApplication::setApplicationVersion(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_setApplicationVersion_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_setAttribute(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.setAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCoreApplicationFunc_setAttribute_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCoreApplicationFunc_setAttribute_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setAttribute", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QCoreApplication::setAttribute(Qt::ApplicationAttribute,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setAttribute(Qt::ApplicationAttribute,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setAttribute(Qt::ApplicationAttribute,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_setAttribute_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_on = Shiboken::String::createStaticString("on");
            if (PyDict_Contains(kwds, key_on)) {
                value = PyDict_GetItem(kwds, key_on);
                if (value && pyArgs[1]) {
                    errInfo = key_on;
                    Py_INCREF(errInfo);
                    goto Sbk_QCoreApplicationFunc_setAttribute_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QCoreApplicationFunc_setAttribute_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_on);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCoreApplicationFunc_setAttribute_TypeError;
            }
        }
        ::Qt::ApplicationAttribute cppArg0{Qt::AA_ImmediateWidgetCreation};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setAttribute(Qt::ApplicationAttribute,bool)
            ::QCoreApplication::setAttribute(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_setAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_setEventDispatcher(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.setEventDispatcher";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::setEventDispatcher(QAbstractEventDispatcher*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_IDX]), (pyArg)))) {
        overloadId = 0; // setEventDispatcher(QAbstractEventDispatcher*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_setEventDispatcher_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractEventDispatcher *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEventDispatcher(QAbstractEventDispatcher*)
            ::QCoreApplication::setEventDispatcher(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_setEventDispatcher_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_setLibraryPaths(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.setLibraryPaths";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::setLibraryPaths(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setLibraryPaths(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_setLibraryPaths_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLibraryPaths(QStringList)
            ::QCoreApplication::setLibraryPaths(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_setLibraryPaths_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_setOrganizationDomain(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.setOrganizationDomain";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::setOrganizationDomain(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setOrganizationDomain(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_setOrganizationDomain_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOrganizationDomain(QString)
            ::QCoreApplication::setOrganizationDomain(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_setOrganizationDomain_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_setOrganizationName(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.setOrganizationName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::setOrganizationName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setOrganizationName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_setOrganizationName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOrganizationName(QString)
            ::QCoreApplication::setOrganizationName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_setOrganizationName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_setQuitLockEnabled(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.setQuitLockEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::setQuitLockEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setQuitLockEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_setQuitLockEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setQuitLockEnabled(bool)
            ::QCoreApplication::setQuitLockEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_setQuitLockEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_setSetuidAllowed(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.setSetuidAllowed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::setSetuidAllowed(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSetuidAllowed(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_setSetuidAllowed_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSetuidAllowed(bool)
            ::QCoreApplication::setSetuidAllowed(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCoreApplicationFunc_setSetuidAllowed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_shutdown(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCoreApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOREAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.shutdown";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shutdown()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (moduleshutdown)]
            PySide::runCleanupFunctions();
            // END of custom code block [file: ../glue/qtcore.cpp (moduleshutdown)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCoreApplicationFunc_startingUp(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.startingUp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startingUp()
            bool cppResult = ::QCoreApplication::startingUp();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCoreApplicationFunc_testAttribute(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.testAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCoreApplication::testAttribute(Qt::ApplicationAttribute)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // testAttribute(Qt::ApplicationAttribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_testAttribute_TypeError;

    // Call function/method
    {
        ::Qt::ApplicationAttribute cppArg0{Qt::AA_ImmediateWidgetCreation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // testAttribute(Qt::ApplicationAttribute)
            bool cppResult = ::QCoreApplication::testAttribute(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCoreApplicationFunc_testAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCoreApplicationFunc_translate(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCoreApplication.translate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCoreApplicationFunc_translate_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCoreApplicationFunc_translate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:translate", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QCoreApplication::translate(const char*,const char*,const char*,int)
    if (numArgs >= 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // translate(const char*,const char*,const char*,int)
        } else if (numArgs >= 3
            && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // translate(const char*,const char*,const char*,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                overloadId = 0; // translate(const char*,const char*,const char*,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCoreApplicationFunc_translate_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_disambiguation = Shiboken::String::createStaticString("disambiguation");
            if (PyDict_Contains(kwds, key_disambiguation)) {
                value = PyDict_GetItem(kwds, key_disambiguation);
                if (value && pyArgs[2]) {
                    errInfo = key_disambiguation;
                    Py_INCREF(errInfo);
                    goto Sbk_QCoreApplicationFunc_translate_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2]))))
                        goto Sbk_QCoreApplicationFunc_translate_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_disambiguation);
            }
            static PyObject *const key_n = Shiboken::String::createStaticString("n");
            if (PyDict_Contains(kwds, key_n)) {
                value = PyDict_GetItem(kwds, key_n);
                if (value && pyArgs[3]) {
                    errInfo = key_n;
                    Py_INCREF(errInfo);
                    goto Sbk_QCoreApplicationFunc_translate_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QCoreApplicationFunc_translate_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_n);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCoreApplicationFunc_translate_TypeError;
            }
        }
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2 = nullptr;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = -1;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // translate(const char*,const char*,const char*,int)
            QString cppResult = ::QCoreApplication::translate(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCoreApplicationFunc_translate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QCoreApplication_PropertyStrings[] = {
    "applicationName::",
    "applicationVersion::",
    "organizationDomain::",
    "organizationName::",
    "quitLockEnabled:isQuitLockEnabled:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCoreApplication_methods[] = {
    {"addLibraryPath", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_addLibraryPath), METH_O|METH_STATIC},
    {"applicationDirPath", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_applicationDirPath), METH_NOARGS|METH_STATIC},
    {"applicationFilePath", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_applicationFilePath), METH_NOARGS|METH_STATIC},
    {"applicationName", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_applicationName), METH_NOARGS|METH_STATIC},
    {"applicationPid", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_applicationPid), METH_NOARGS|METH_STATIC},
    {"applicationVersion", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_applicationVersion), METH_NOARGS|METH_STATIC},
    {"arguments", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_arguments), METH_NOARGS|METH_STATIC},
    {"closingDown", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_closingDown), METH_NOARGS|METH_STATIC},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_event), METH_O},
    {"eventDispatcher", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_eventDispatcher), METH_NOARGS|METH_STATIC},
    {"exec_", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_exec_), METH_NOARGS|METH_STATIC},
    {"exit", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_exit), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"flush", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_flush), METH_NOARGS|METH_STATIC},
    {"hasPendingEvents", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_hasPendingEvents), METH_NOARGS|METH_STATIC},
    {"installNativeEventFilter", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_installNativeEventFilter), METH_O},
    {"installTranslator", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_installTranslator), METH_O|METH_STATIC},
    {"instance", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_instance), METH_NOARGS|METH_STATIC},
    {"isQuitLockEnabled", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_isQuitLockEnabled), METH_NOARGS|METH_STATIC},
    {"isSetuidAllowed", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_isSetuidAllowed), METH_NOARGS|METH_STATIC},
    {"libraryPaths", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_libraryPaths), METH_NOARGS|METH_STATIC},
    {"notify", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_notify), METH_VARARGS},
    {"organizationDomain", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_organizationDomain), METH_NOARGS|METH_STATIC},
    {"organizationName", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_organizationName), METH_NOARGS|METH_STATIC},
    {"postEvent", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_postEvent), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"processEvents", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_processEvents), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"quit", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_quit), METH_NOARGS|METH_STATIC},
    {"removeLibraryPath", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_removeLibraryPath), METH_O|METH_STATIC},
    {"removeNativeEventFilter", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_removeNativeEventFilter), METH_O},
    {"removePostedEvents", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_removePostedEvents), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"removeTranslator", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_removeTranslator), METH_O|METH_STATIC},
    {"sendEvent", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_sendEvent), METH_VARARGS|METH_STATIC},
    {"sendPostedEvents", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_sendPostedEvents), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"setApplicationName", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_setApplicationName), METH_O|METH_STATIC},
    {"setApplicationVersion", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_setApplicationVersion), METH_O|METH_STATIC},
    {"setAttribute", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_setAttribute), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"setEventDispatcher", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_setEventDispatcher), METH_O|METH_STATIC},
    {"setLibraryPaths", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_setLibraryPaths), METH_O|METH_STATIC},
    {"setOrganizationDomain", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_setOrganizationDomain), METH_O|METH_STATIC},
    {"setOrganizationName", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_setOrganizationName), METH_O|METH_STATIC},
    {"setQuitLockEnabled", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_setQuitLockEnabled), METH_O|METH_STATIC},
    {"setSetuidAllowed", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_setSetuidAllowed), METH_O|METH_STATIC},
    {"shutdown", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_shutdown), METH_NOARGS},
    {"startingUp", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_startingUp), METH_NOARGS|METH_STATIC},
    {"testAttribute", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_testAttribute), METH_O|METH_STATIC},
    {"translate", reinterpret_cast<PyCFunction>(Sbk_QCoreApplicationFunc_translate), METH_VARARGS|METH_KEYWORDS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCoreApplication_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QCoreApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOREAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QCoreApplicationWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QCoreApplication_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCoreApplication_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCoreApplication_Type = nullptr;
static SbkObjectType *Sbk_QCoreApplication_TypeF(void)
{
    return _Sbk_QCoreApplication_Type;
}

static PyType_Slot Sbk_QCoreApplication_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocQAppWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QCoreApplication_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCoreApplication_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCoreApplication_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCoreApplication_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCoreApplication_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkQAppTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCoreApplication_spec = {
    "2:PySide2.QtCore.QCoreApplication",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCoreApplication_slots
};

} //extern "C"

static void *Sbk_QCoreApplication_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QCoreApplication *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCoreApplication_PythonToCpp_QCoreApplication_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCoreApplication_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCoreApplication_PythonToCpp_QCoreApplication_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCoreApplication_TypeF())))
        return QCoreApplication_PythonToCpp_QCoreApplication_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCoreApplication_PTR_CppToPython_QCoreApplication(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QCoreApplication *>(const_cast<void *>(cppIn)), Sbk_QCoreApplication_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCoreApplication_SignatureStrings[] = {
    "1:PySide2.QtCore.QCoreApplication(self)",
    "0:PySide2.QtCore.QCoreApplication(self,arg__1:QStringList)",
    "PySide2.QtCore.QCoreApplication.addLibraryPath(arg__1:QString)",
    "PySide2.QtCore.QCoreApplication.applicationDirPath()->QString",
    "PySide2.QtCore.QCoreApplication.applicationFilePath()->QString",
    "PySide2.QtCore.QCoreApplication.applicationName()->QString",
    "PySide2.QtCore.QCoreApplication.applicationPid()->qint64",
    "PySide2.QtCore.QCoreApplication.applicationVersion()->QString",
    "PySide2.QtCore.QCoreApplication.arguments()->QStringList",
    "PySide2.QtCore.QCoreApplication.closingDown()->bool",
    "PySide2.QtCore.QCoreApplication.event(self,arg__1:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtCore.QCoreApplication.eventDispatcher()->PySide2.QtCore.QAbstractEventDispatcher",
    "PySide2.QtCore.QCoreApplication.exec_()->int",
    "PySide2.QtCore.QCoreApplication.exit(retcode:int=0)",
    "PySide2.QtCore.QCoreApplication.flush()",
    "PySide2.QtCore.QCoreApplication.hasPendingEvents()->bool",
    "PySide2.QtCore.QCoreApplication.installNativeEventFilter(self,filterObj:PySide2.QtCore.QAbstractNativeEventFilter)",
    "PySide2.QtCore.QCoreApplication.installTranslator(messageFile:PySide2.QtCore.QTranslator)->bool",
    "PySide2.QtCore.QCoreApplication.instance()->PySide2.QtCore.QCoreApplication",
    "PySide2.QtCore.QCoreApplication.isQuitLockEnabled()->bool",
    "PySide2.QtCore.QCoreApplication.isSetuidAllowed()->bool",
    "PySide2.QtCore.QCoreApplication.libraryPaths()->QStringList",
    "PySide2.QtCore.QCoreApplication.notify(self,arg__1:PySide2.QtCore.QObject,arg__2:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtCore.QCoreApplication.organizationDomain()->QString",
    "PySide2.QtCore.QCoreApplication.organizationName()->QString",
    "PySide2.QtCore.QCoreApplication.postEvent(receiver:PySide2.QtCore.QObject,event:PySide2.QtCore.QEvent,priority:int=Qt.NormalEventPriority)",
    "1:PySide2.QtCore.QCoreApplication.processEvents(flags:PySide2.QtCore.QEventLoop.ProcessEventsFlags=QEventLoop.AllEvents)",
    "0:PySide2.QtCore.QCoreApplication.processEvents(flags:PySide2.QtCore.QEventLoop.ProcessEventsFlags,maxtime:int)",
    "PySide2.QtCore.QCoreApplication.quit()",
    "PySide2.QtCore.QCoreApplication.removeLibraryPath(arg__1:QString)",
    "PySide2.QtCore.QCoreApplication.removeNativeEventFilter(self,filterObj:PySide2.QtCore.QAbstractNativeEventFilter)",
    "PySide2.QtCore.QCoreApplication.removePostedEvents(receiver:PySide2.QtCore.QObject,eventType:int=0)",
    "PySide2.QtCore.QCoreApplication.removeTranslator(messageFile:PySide2.QtCore.QTranslator)->bool",
    "PySide2.QtCore.QCoreApplication.sendEvent(receiver:PySide2.QtCore.QObject,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtCore.QCoreApplication.sendPostedEvents(receiver:PySide2.QtCore.QObject=nullptr,event_type:int=0)",
    "PySide2.QtCore.QCoreApplication.setApplicationName(application:QString)",
    "PySide2.QtCore.QCoreApplication.setApplicationVersion(version:QString)",
    "PySide2.QtCore.QCoreApplication.setAttribute(attribute:PySide2.QtCore.Qt.ApplicationAttribute,on:bool=true)",
    "PySide2.QtCore.QCoreApplication.setEventDispatcher(eventDispatcher:PySide2.QtCore.QAbstractEventDispatcher)",
    "PySide2.QtCore.QCoreApplication.setLibraryPaths(arg__1:QStringList)",
    "PySide2.QtCore.QCoreApplication.setOrganizationDomain(orgDomain:QString)",
    "PySide2.QtCore.QCoreApplication.setOrganizationName(orgName:QString)",
    "PySide2.QtCore.QCoreApplication.setQuitLockEnabled(enabled:bool)",
    "PySide2.QtCore.QCoreApplication.setSetuidAllowed(allow:bool)",
    "PySide2.QtCore.QCoreApplication.shutdown(self)",
    "PySide2.QtCore.QCoreApplication.startingUp()->bool",
    "PySide2.QtCore.QCoreApplication.testAttribute(attribute:PySide2.QtCore.Qt.ApplicationAttribute)->bool",
    "PySide2.QtCore.QCoreApplication.translate(context:char*,key:char*,disambiguation:char*=nullptr,n:int=-1)->QString",
    nullptr}; // Sentinel

void init_QCoreApplication(PyObject *module)
{
    _Sbk_QCoreApplication_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCoreApplication",
        "QCoreApplication*",
        &Sbk_QCoreApplication_spec,
        &Shiboken::callCppDestructor< ::QCoreApplication >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCoreApplication_Type);
    InitSignatureStrings(pyType, QCoreApplication_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCoreApplication_Type), Sbk_QCoreApplication_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCOREAPPLICATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCoreApplication_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCoreApplication_TypeF(),
        QCoreApplication_PythonToCpp_QCoreApplication_PTR,
        is_QCoreApplication_PythonToCpp_QCoreApplication_PTR_Convertible,
        QCoreApplication_PTR_CppToPython_QCoreApplication);

    Shiboken::Conversions::registerConverterName(converter, "QCoreApplication");
    Shiboken::Conversions::registerConverterName(converter, "QCoreApplication*");
    Shiboken::Conversions::registerConverterName(converter, "QCoreApplication&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCoreApplication).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCoreApplicationWrapper).name());



    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QCoreApplication_TypeF(), &Sbk_QCoreApplication_typeDiscovery);

    // Initialization of enums.

    // Initialization of anonymous enum identified by enum value 'ApplicationFlags'.
    {
        PyObject *anonEnumItem = PyInt_FromLong((long) QCoreApplication::ApplicationFlags);
        if (PyDict_SetItemString(reinterpret_cast<PyTypeObject *>(reinterpret_cast<SbkObjectType *>(Sbk_QCoreApplication_TypeF()))->tp_dict, "ApplicationFlags", anonEnumItem) < 0)
            return;
        Py_DECREF(anonEnumItem);
    }
    // End of 'ApplicationFlags' enum.

    PySide::Signal::registerSignals(Sbk_QCoreApplication_TypeF(), &::QCoreApplication::staticMetaObject);

    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QCoreApplication_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QCoreApplication_TypeF(), &::QCoreApplication::staticMetaObject, sizeof(QCoreApplicationWrapper));
}

