/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcborstreamwriter_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>
#include <qiodevice.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCborStreamWriter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCborStreamWriter >()))
        return -1;

    ::QCborStreamWriter *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QCborStreamWriter", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QCborStreamWriter::QCborStreamWriter(QByteArray*)
    // 1: QCborStreamWriter::QCborStreamWriter(QIODevice*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QCborStreamWriter(QIODevice*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QCborStreamWriter(QByteArray*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamWriter_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCborStreamWriter(QByteArray * data)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborStreamWriter(QByteArray*)
                cptr = new ::QCborStreamWriter(cppArg0);
            }
            break;
        }
        case 1: // QCborStreamWriter(QIODevice * device)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborStreamWriter(QIODevice*)
                cptr = new ::QCborStreamWriter(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCborStreamWriter >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCborStreamWriter_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCborStreamWriter_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCborStreamWriterFunc_append(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.append";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborStreamWriterFunc_append_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCborStreamWriterFunc_append_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:append", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCborStreamWriter::append(QCborKnownTags)
    // 1: QCborStreamWriter::append(QCborSimpleType)
    // 2: QCborStreamWriter::append(bool)
    // 3: QCborStreamWriter::append(QByteArray)
    // 4: QCborStreamWriter::append(const char*,long long)
    // 5: QCborStreamWriter::append(double)
    // 6: QCborStreamWriter::append(float)
    // 7: QCborStreamWriter::append(int)
    // 8: QCborStreamWriter::append(qint64)
    // 9: QCborStreamWriter::append(quint64)
    // 10: QCborStreamWriter::append(uint)
    if (numArgs == 1
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyArgs[0])))) {
        overloadId = 9; // append(quint64)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 3; // append(QByteArray)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // append(QCborSimpleType)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // append(QCborKnownTags)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 10; // append(uint)
    } else if (numArgs == 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))) {
        overloadId = 6; // append(float)
    } else if (numArgs == 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        overloadId = 5; // append(double)
    } else if (numArgs >= 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 4; // append(const char*,long long)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1])))) {
            overloadId = 4; // append(const char*,long long)
        }
    } else if (numArgs == 1
        && PyBool_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 2; // append(bool)
    } else if (numArgs == 1
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        overloadId = 8; // append(qint64)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 7; // append(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamWriterFunc_append_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // append(QCborKnownTags tag)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborStreamWriterFunc_append_TypeError;
            }
            ::QCborKnownTags cppArg0{QCborKnownTags::DateTimeString};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // append(QCborKnownTags)
                cppSelf->append(cppArg0);
            }
            break;
        }
        case 1: // append(QCborSimpleType st)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborStreamWriterFunc_append_TypeError;
            }
            ::QCborSimpleType cppArg0 = static_cast< ::QCborSimpleType>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // append(QCborSimpleType)
                cppSelf->append(cppArg0);
            }
            break;
        }
        case 2: // append(bool b)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborStreamWriterFunc_append_TypeError;
            }
            bool cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // append(bool)
                cppSelf->append(cppArg0);
            }
            break;
        }
        case 3: // append(const QByteArray & ba)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborStreamWriterFunc_append_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // append(QByteArray)
                cppSelf->append(*cppArg0);
            }
            break;
        }
        case 4: // append(const char * str, long long size)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_size = Shiboken::String::createStaticString("size");
                if (PyDict_Contains(kwds, key_size)) {
                    value = PyDict_GetItem(kwds, key_size);
                    if (value && pyArgs[1]) {
                        errInfo = key_size;
                        Py_INCREF(errInfo);
                        goto Sbk_QCborStreamWriterFunc_append_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1]))))
                            goto Sbk_QCborStreamWriterFunc_append_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_size);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCborStreamWriterFunc_append_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            long long cppArg1 = -1;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // append(const char*,long long)
                cppSelf->append(cppArg0, cppArg1);
            }
            break;
        }
        case 5: // append(double d)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborStreamWriterFunc_append_TypeError;
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // append(double)
                cppSelf->append(cppArg0);
            }
            break;
        }
        case 6: // append(float f)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborStreamWriterFunc_append_TypeError;
            }
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // append(float)
                cppSelf->append(cppArg0);
            }
            break;
        }
        case 7: // append(int i)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborStreamWriterFunc_append_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // append(int)
                cppSelf->append(cppArg0);
            }
            break;
        }
        case 8: // append(qint64 i)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborStreamWriterFunc_append_TypeError;
            }
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // append(qint64)
                cppSelf->append(cppArg0);
            }
            break;
        }
        case 9: // append(quint64 u)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborStreamWriterFunc_append_TypeError;
            }
            quint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // append(quint64)
                cppSelf->append(cppArg0);
            }
            break;
        }
        case 10: // append(uint u)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborStreamWriterFunc_append_TypeError;
            }
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // append(uint)
                cppSelf->append(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCborStreamWriterFunc_append_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborStreamWriterFunc_appendByteString(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.appendByteString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "appendByteString", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCborStreamWriter::appendByteString(const char*,long long)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1])))) {
        overloadId = 0; // appendByteString(const char*,long long)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamWriterFunc_appendByteString_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        long long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // appendByteString(const char*,long long)
            cppSelf->appendByteString(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCborStreamWriterFunc_appendByteString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborStreamWriterFunc_appendNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.appendNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // appendNull()
            cppSelf->appendNull();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCborStreamWriterFunc_appendTextString(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.appendTextString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "appendTextString", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCborStreamWriter::appendTextString(const char*,long long)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1])))) {
        overloadId = 0; // appendTextString(const char*,long long)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamWriterFunc_appendTextString_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        long long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // appendTextString(const char*,long long)
            cppSelf->appendTextString(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCborStreamWriterFunc_appendTextString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborStreamWriterFunc_appendUndefined(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.appendUndefined";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // appendUndefined()
            cppSelf->appendUndefined();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCborStreamWriterFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QIODevice * cppResult = const_cast<const ::QCborStreamWriter *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamWriterFunc_endArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.endArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // endArray()
            bool cppResult = cppSelf->endArray();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamWriterFunc_endMap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.endMap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // endMap()
            bool cppResult = cppSelf->endMap();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamWriterFunc_setDevice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.setDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCborStreamWriter::setDevice(QIODevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevice(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamWriterFunc_setDevice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevice(QIODevice*)
            cppSelf->setDevice(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCborStreamWriterFunc_setDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborStreamWriterFunc_startArray(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.startArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "startArray", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborStreamWriter::startArray()
    // 1: QCborStreamWriter::startArray(quint64)
    if (numArgs == 0) {
        overloadId = 0; // startArray()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyArgs[0])))) {
        overloadId = 1; // startArray(quint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamWriterFunc_startArray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // startArray()
        {

            if (!PyErr_Occurred()) {
                // startArray()
                cppSelf->startArray();
            }
            break;
        }
        case 1: // startArray(quint64 count)
        {
            quint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // startArray(quint64)
                cppSelf->startArray(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCborStreamWriterFunc_startArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborStreamWriterFunc_startMap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamWriter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamWriter.startMap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "startMap", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborStreamWriter::startMap()
    // 1: QCborStreamWriter::startMap(quint64)
    if (numArgs == 0) {
        overloadId = 0; // startMap()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyArgs[0])))) {
        overloadId = 1; // startMap(quint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamWriterFunc_startMap_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // startMap()
        {

            if (!PyErr_Occurred()) {
                // startMap()
                cppSelf->startMap();
            }
            break;
        }
        case 1: // startMap(quint64 count)
        {
            quint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // startMap(quint64)
                cppSelf->startMap(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCborStreamWriterFunc_startMap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QCborStreamWriter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCborStreamWriter_methods[] = {
    {"append", reinterpret_cast<PyCFunction>(Sbk_QCborStreamWriterFunc_append), METH_VARARGS|METH_KEYWORDS},
    {"appendByteString", reinterpret_cast<PyCFunction>(Sbk_QCborStreamWriterFunc_appendByteString), METH_VARARGS},
    {"appendNull", reinterpret_cast<PyCFunction>(Sbk_QCborStreamWriterFunc_appendNull), METH_NOARGS},
    {"appendTextString", reinterpret_cast<PyCFunction>(Sbk_QCborStreamWriterFunc_appendTextString), METH_VARARGS},
    {"appendUndefined", reinterpret_cast<PyCFunction>(Sbk_QCborStreamWriterFunc_appendUndefined), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QCborStreamWriterFunc_device), METH_NOARGS},
    {"endArray", reinterpret_cast<PyCFunction>(Sbk_QCborStreamWriterFunc_endArray), METH_NOARGS},
    {"endMap", reinterpret_cast<PyCFunction>(Sbk_QCborStreamWriterFunc_endMap), METH_NOARGS},
    {"setDevice", reinterpret_cast<PyCFunction>(Sbk_QCborStreamWriterFunc_setDevice), METH_O},
    {"startArray", reinterpret_cast<PyCFunction>(Sbk_QCborStreamWriterFunc_startArray), METH_VARARGS},
    {"startMap", reinterpret_cast<PyCFunction>(Sbk_QCborStreamWriterFunc_startMap), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QCborStreamWriter_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCborStreamWriter_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCborStreamWriter_Type = nullptr;
static SbkObjectType *Sbk_QCborStreamWriter_TypeF(void)
{
    return _Sbk_QCborStreamWriter_Type;
}

static PyType_Slot Sbk_QCborStreamWriter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCborStreamWriter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCborStreamWriter_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCborStreamWriter_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCborStreamWriter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCborStreamWriter_spec = {
    "2:PySide2.QtCore.QCborStreamWriter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCborStreamWriter_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCborStreamWriter_PythonToCpp_QCborStreamWriter_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCborStreamWriter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCborStreamWriter_PythonToCpp_QCborStreamWriter_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCborStreamWriter_TypeF())))
        return QCborStreamWriter_PythonToCpp_QCborStreamWriter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCborStreamWriter_PTR_CppToPython_QCborStreamWriter(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCborStreamWriter *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCborStreamWriter_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCborStreamWriter_SignatureStrings[] = {
    "1:PySide2.QtCore.QCborStreamWriter(self,data:PySide2.QtCore.QByteArray)",
    "0:PySide2.QtCore.QCborStreamWriter(self,device:PySide2.QtCore.QIODevice)",
    "10:PySide2.QtCore.QCborStreamWriter.append(self,tag:PySide2.QtCore.QCborKnownTags)",
    "9:PySide2.QtCore.QCborStreamWriter.append(self,st:PySide2.QtCore.QCborSimpleType)",
    "8:PySide2.QtCore.QCborStreamWriter.append(self,b:bool)",
    "7:PySide2.QtCore.QCborStreamWriter.append(self,ba:PySide2.QtCore.QByteArray)",
    "6:PySide2.QtCore.QCborStreamWriter.append(self,str:char*,size:long long=-1)",
    "5:PySide2.QtCore.QCborStreamWriter.append(self,d:double)",
    "4:PySide2.QtCore.QCborStreamWriter.append(self,f:float)",
    "3:PySide2.QtCore.QCborStreamWriter.append(self,i:int)",
    "2:PySide2.QtCore.QCborStreamWriter.append(self,i:qint64)",
    "1:PySide2.QtCore.QCborStreamWriter.append(self,u:quint64)",
    "0:PySide2.QtCore.QCborStreamWriter.append(self,u:uint)",
    "PySide2.QtCore.QCborStreamWriter.appendByteString(self,data:char*,len:long long)",
    "PySide2.QtCore.QCborStreamWriter.appendNull(self)",
    "PySide2.QtCore.QCborStreamWriter.appendTextString(self,utf8:char*,len:long long)",
    "PySide2.QtCore.QCborStreamWriter.appendUndefined(self)",
    "PySide2.QtCore.QCborStreamWriter.device(self)->PySide2.QtCore.QIODevice",
    "PySide2.QtCore.QCborStreamWriter.endArray(self)->bool",
    "PySide2.QtCore.QCborStreamWriter.endMap(self)->bool",
    "PySide2.QtCore.QCborStreamWriter.setDevice(self,device:PySide2.QtCore.QIODevice)",
    "1:PySide2.QtCore.QCborStreamWriter.startArray(self)",
    "0:PySide2.QtCore.QCborStreamWriter.startArray(self,count:quint64)",
    "1:PySide2.QtCore.QCborStreamWriter.startMap(self)",
    "0:PySide2.QtCore.QCborStreamWriter.startMap(self,count:quint64)",
    nullptr}; // Sentinel

void init_QCborStreamWriter(PyObject *module)
{
    _Sbk_QCborStreamWriter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCborStreamWriter",
        "QCborStreamWriter*",
        &Sbk_QCborStreamWriter_spec,
        &Shiboken::callCppDestructor< ::QCborStreamWriter >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCborStreamWriter_Type);
    InitSignatureStrings(pyType, QCborStreamWriter_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCborStreamWriter_Type), Sbk_QCborStreamWriter_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCborStreamWriter_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCborStreamWriter_TypeF(),
        QCborStreamWriter_PythonToCpp_QCborStreamWriter_PTR,
        is_QCborStreamWriter_PythonToCpp_QCborStreamWriter_PTR_Convertible,
        QCborStreamWriter_PTR_CppToPython_QCborStreamWriter);

    Shiboken::Conversions::registerConverterName(converter, "QCborStreamWriter");
    Shiboken::Conversions::registerConverterName(converter, "QCborStreamWriter*");
    Shiboken::Conversions::registerConverterName(converter, "QCborStreamWriter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCborStreamWriter).name());


}
