/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcalendar_yearmonthday_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCalendar_YearMonthDay_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCalendar::YearMonthDay >()))
        return -1;

    ::QCalendar::YearMonthDay *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.YearMonthDay.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCalendar_YearMonthDay_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:YearMonthDay", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: YearMonthDay::YearMonthDay()
    // 1: YearMonthDay::YearMonthDay(QCalendar::YearMonthDay)
    // 2: YearMonthDay::YearMonthDay(int,int,int)
    if (numArgs == 0) {
        overloadId = 0; // YearMonthDay()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // YearMonthDay(int,int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // YearMonthDay(int,int,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 2; // YearMonthDay(int,int,int)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // YearMonthDay(QCalendar::YearMonthDay)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCalendar_YearMonthDay_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // YearMonthDay()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCalendar_YearMonthDay_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // YearMonthDay()
                cptr = new ::QCalendar::YearMonthDay();
            }
            break;
        }
        case 1: // YearMonthDay(const QCalendar::YearMonthDay & YearMonthDay)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCalendar_YearMonthDay_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCalendar::YearMonthDay cppArg0_local;
            ::QCalendar::YearMonthDay *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // YearMonthDay(QCalendar::YearMonthDay)
                cptr = new ::QCalendar::YearMonthDay(*cppArg0);
            }
            break;
        }
        case 2: // YearMonthDay(int y, int m, int d)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_m = Shiboken::String::createStaticString("m");
                if (PyDict_Contains(kwds, key_m)) {
                    value = PyDict_GetItem(kwds, key_m);
                    if (value && pyArgs[1]) {
                        errInfo = key_m;
                        Py_INCREF(errInfo);
                        goto Sbk_QCalendar_YearMonthDay_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QCalendar_YearMonthDay_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_m);
                }
                static PyObject *const key_d = Shiboken::String::createStaticString("d");
                if (PyDict_Contains(kwds, key_d)) {
                    value = PyDict_GetItem(kwds, key_d);
                    if (value && pyArgs[2]) {
                        errInfo = key_d;
                        Py_INCREF(errInfo);
                        goto Sbk_QCalendar_YearMonthDay_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QCalendar_YearMonthDay_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_d);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCalendar_YearMonthDay_Init_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 1;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // YearMonthDay(int,int,int)
                cptr = new ::QCalendar::YearMonthDay(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCalendar::YearMonthDay >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCalendar_YearMonthDay_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCalendar_YearMonthDay_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCalendar_YearMonthDayFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCalendar::YearMonthDay *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCalendar.YearMonthDay.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QCalendar::YearMonthDay *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCalendar_YearMonthDay___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCalendar::YearMonthDay *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCalendar_YearMonthDay_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCalendar_YearMonthDay_methods[] = {
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QCalendar_YearMonthDayFunc_isValid), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QCalendar_YearMonthDay___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QCalendar_YearMonthDay_get_year(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QCalendar::YearMonthDay *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->year;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QCalendar_YearMonthDay_set_year(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QCalendar::YearMonthDay *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'year' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'year', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->year;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->year = cppOut_local;

    return 0;
}

static PyObject *Sbk_QCalendar_YearMonthDay_get_month(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QCalendar::YearMonthDay *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->month;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QCalendar_YearMonthDay_set_month(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QCalendar::YearMonthDay *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'month' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'month', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->month;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->month = cppOut_local;

    return 0;
}

static PyObject *Sbk_QCalendar_YearMonthDay_get_day(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QCalendar::YearMonthDay *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->day;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QCalendar_YearMonthDay_set_day(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QCalendar::YearMonthDay *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'day' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'day', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->day;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->day = cppOut_local;

    return 0;
}

// Getters and Setters for YearMonthDay
static PyGetSetDef Sbk_QCalendar_YearMonthDay_getsetlist[] = {
    {const_cast<char *>("year"), Sbk_QCalendar_YearMonthDay_get_year, Sbk_QCalendar_YearMonthDay_set_year},
    {const_cast<char *>("month"), Sbk_QCalendar_YearMonthDay_get_month, Sbk_QCalendar_YearMonthDay_set_month},
    {const_cast<char *>("day"), Sbk_QCalendar_YearMonthDay_get_day, Sbk_QCalendar_YearMonthDay_set_day},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QCalendar_YearMonthDay_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCalendar_YearMonthDay_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCalendar_YearMonthDay_Type = nullptr;
static SbkObjectType *Sbk_QCalendar_YearMonthDay_TypeF(void)
{
    return _Sbk_QCalendar_YearMonthDay_Type;
}

static PyType_Slot Sbk_QCalendar_YearMonthDay_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCalendar_YearMonthDay_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCalendar_YearMonthDay_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCalendar_YearMonthDay_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QCalendar_YearMonthDay_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCalendar_YearMonthDay_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCalendar_YearMonthDay_spec = {
    "2:PySide2.QtCore.QCalendar.YearMonthDay",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCalendar_YearMonthDay_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void YearMonthDay_PythonToCpp_YearMonthDay_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCalendar_YearMonthDay_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_YearMonthDay_PythonToCpp_YearMonthDay_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCalendar_YearMonthDay_TypeF())))
        return YearMonthDay_PythonToCpp_YearMonthDay_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *YearMonthDay_PTR_CppToPython_YearMonthDay(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCalendar::YearMonthDay *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCalendar_YearMonthDay_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *YearMonthDay_COPY_CppToPython_YearMonthDay(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QCalendar_YearMonthDay_TypeF(), new ::QCalendar::YearMonthDay(*reinterpret_cast<const ::QCalendar::YearMonthDay *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void YearMonthDay_PythonToCpp_YearMonthDay_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCalendar::YearMonthDay *>(cppOut) = *reinterpret_cast< ::QCalendar::YearMonthDay *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_YearMonthDay_PythonToCpp_YearMonthDay_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCalendar_YearMonthDay_TypeF())))
        return YearMonthDay_PythonToCpp_YearMonthDay_COPY;
    return {};
}

// Implicit conversions.
static void int_PythonToCpp_QCalendar_YearMonthDay(PyObject *pyIn, void *cppOut) {
    int cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn, &cppIn);
    *reinterpret_cast<::QCalendar::YearMonthDay *>(cppOut) = ::QCalendar::YearMonthDay(cppIn);
}
static PythonToCppFunc is_int_PythonToCpp_QCalendar_YearMonthDay_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return int_PythonToCpp_QCalendar_YearMonthDay;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCalendar_YearMonthDay_SignatureStrings[] = {
    "2:PySide2.QtCore.QCalendar.YearMonthDay(self)",
    "1:PySide2.QtCore.QCalendar.YearMonthDay(self,YearMonthDay:PySide2.QtCore.QCalendar.YearMonthDay)",
    "0:PySide2.QtCore.QCalendar.YearMonthDay(self,y:int,m:int=1,d:int=1)",
    "PySide2.QtCore.QCalendar.YearMonthDay.isValid(self)->bool",
    "PySide2.QtCore.QCalendar.YearMonthDay.__copy__()",
    nullptr}; // Sentinel

void init_QCalendar_YearMonthDay(PyObject *enclosingClass)
{
    _Sbk_QCalendar_YearMonthDay_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "YearMonthDay",
        "QCalendar::YearMonthDay",
        &Sbk_QCalendar_YearMonthDay_spec,
        &Shiboken::callCppDestructor< ::QCalendar::YearMonthDay >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCalendar_YearMonthDay_Type);
    InitSignatureStrings(pyType, QCalendar_YearMonthDay_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCalendar_YearMonthDay_Type), Sbk_QCalendar_YearMonthDay_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCALENDAR_YEARMONTHDAY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCalendar_YearMonthDay_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCalendar_YearMonthDay_TypeF(),
        YearMonthDay_PythonToCpp_YearMonthDay_PTR,
        is_YearMonthDay_PythonToCpp_YearMonthDay_PTR_Convertible,
        YearMonthDay_PTR_CppToPython_YearMonthDay,
        YearMonthDay_COPY_CppToPython_YearMonthDay);

    Shiboken::Conversions::registerConverterName(converter, "QCalendar::YearMonthDay");
    Shiboken::Conversions::registerConverterName(converter, "QCalendar::YearMonthDay*");
    Shiboken::Conversions::registerConverterName(converter, "QCalendar::YearMonthDay&");
    Shiboken::Conversions::registerConverterName(converter, "YearMonthDay");
    Shiboken::Conversions::registerConverterName(converter, "YearMonthDay*");
    Shiboken::Conversions::registerConverterName(converter, "YearMonthDay&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCalendar::YearMonthDay).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        YearMonthDay_PythonToCpp_YearMonthDay_COPY,
        is_YearMonthDay_PythonToCpp_YearMonthDay_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        int_PythonToCpp_QCalendar_YearMonthDay,
        is_int_PythonToCpp_QCalendar_YearMonthDay_Convertible);

    qRegisterMetaType< ::QCalendar::YearMonthDay >("YearMonthDay");
    qRegisterMetaType< ::QCalendar::YearMonthDay >("QCalendar::YearMonthDay");
}
