/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qbytearray_wrapper.h"

// inner classes
#include "qbytearray_frombase64result_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// ========================================================================
// START of custom code block [file: ../glue/qtcore.cpp (qbytearray-bufferprotocol)]
extern "C" {
// QByteArray buffer protocol functions
// see: http://www.python.org/dev/peps/pep-3118/

static int SbkQByteArray_getbufferproc(PyObject *obj, Py_buffer *view, int flags)
{
    if (!view || !Shiboken::Object::isValid(obj))
        return -1;

    ::QByteArray* cppSelf{nullptr};
    Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), obj, &(cppSelf));
    //XXX      /|\ omitting this space crashes shiboken!
 #ifdef Py_LIMITED_API
    view->obj = obj;
    view->buf = reinterpret_cast<void *>(cppSelf->data());
    view->len = cppSelf->size();
    view->readonly = 0;
    view->itemsize = 1;
    view->format = const_cast<char *>("c");
    view->ndim = 1;
    view->shape = (flags & PyBUF_ND) == PyBUF_ND ? &(view->len) : nullptr;
    view->strides = &view->itemsize;
    view->suboffsets = NULL;
    view->internal = NULL;

    Py_XINCREF(obj);
    return 0;
#else // Py_LIMITED_API
    const int result = PyBuffer_FillInfo(view, obj, reinterpret_cast<void *>(cppSelf->data()),
                                         cppSelf->size(), 0, flags);
    if (result == 0)
        Py_XINCREF(obj);
    return result;
#endif
}

#if PY_VERSION_HEX < 0x03000000
static Py_ssize_t SbkQByteArray_segcountproc(PyObject *self, Py_ssize_t *lenp)
{
    if (lenp)
        *lenp = Py_TYPE(self)->tp_as_sequence->sq_length(self);
    return 1;
}

static Py_ssize_t SbkQByteArray_readbufferproc(PyObject *self, Py_ssize_t segment, void **ptrptr)
{
    if (segment || !Shiboken::Object::isValid(self))
        return -1;

    ::QByteArray* cppSelf{nullptr};
    Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), self, &(cppSelf));
    //XXX      /|\ omitting this space crashes shiboken!
    *ptrptr = reinterpret_cast<void *>(cppSelf->data());
    return cppSelf->size();
}

PyBufferProcs SbkQByteArrayBufferProc = {
    /*bf_getreadbuffer*/  &SbkQByteArray_readbufferproc,
    /*bf_getwritebuffer*/ (writebufferproc) &SbkQByteArray_readbufferproc,
    /*bf_getsegcount*/    &SbkQByteArray_segcountproc,
    /*bf_getcharbuffer*/  (charbufferproc) &SbkQByteArray_readbufferproc,
    /*bf_getbuffer*/  (getbufferproc)SbkQByteArray_getbufferproc,
};
#else

static PyBufferProcs SbkQByteArrayBufferProc = {
    /*bf_getbuffer*/  (getbufferproc)SbkQByteArray_getbufferproc,
    /*bf_releasebuffer*/ (releasebufferproc)0,
};

#endif
}
// END of custom code block [file: ../glue/qtcore.cpp (qbytearray-bufferprotocol)]
// ========================================================================

// End of code injection



// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QByteArray_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QByteArray >()))
        return -1;

    ::QByteArray *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QByteArray", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QByteArray::QByteArray()
    // 1: QByteArray::QByteArray(PyByteArray)
    // 2: QByteArray::QByteArray(PyBytes)
    // 3: QByteArray::QByteArray(QByteArray)
    // 4: QByteArray::QByteArray(int,char)
    if (numArgs == 0) {
        overloadId = 0; // QByteArray()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
        overloadId = 4; // QByteArray(int,char)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QByteArray(QByteArray)
    } else if (numArgs == 1
        && PyBytes_Check(pyArgs[0])) {
        overloadId = 2; // QByteArray(PyBytes)
    } else if (numArgs == 1
        && PyByteArray_Check(pyArgs[0])) {
        overloadId = 1; // QByteArray(PyByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArray_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QByteArray()
        {

            if (!PyErr_Occurred()) {
                // QByteArray()
                cptr = new ::QByteArray();
            }
            break;
        }
        case 1: // QByteArray(PyByteArray arg__1)
        {

            if (!PyErr_Occurred()) {
                // QByteArray(PyByteArray)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-2)]
                cptr = new QByteArray(PyByteArray_AsString(pyArgs[1-1]), PyByteArray_Size(pyArgs[1-1]));
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-2)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 2: // QByteArray(PyBytes arg__1)
        {

            if (!PyErr_Occurred()) {
                // QByteArray(PyBytes)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-3)]
                cptr = new QByteArray(PyBytes_AS_STRING(pyArgs[1-1]), PyBytes_GET_SIZE(pyArgs[1-1]));
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-3)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 3: // QByteArray(const QByteArray & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QByteArray(QByteArray)
                cptr = new ::QByteArray(*cppArg0);
            }
            break;
        }
        case 4: // QByteArray(int size, char c)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QByteArray(int,char)
                cptr = new ::QByteArray(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QByteArray >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QByteArray_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QByteArray_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QByteArrayFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(N))", PyObject_Type(self), PyBytes_FromStringAndSize(cppSelf->constData(), cppSelf->size()));
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-repr)]
            PyObject *aux = PyBytes_FromStringAndSize(cppSelf->constData(), cppSelf->size());
            if (aux == nullptr) {
                return nullptr;
            }
            QByteArray b(Py_TYPE(self)->tp_name);
#ifdef IS_PY3K
                pyResult = PyUnicode_FromFormat("%s(%R)", b.constData(), aux);
#else
                aux = PyObject_Repr(aux);
                b += '(';
                b += QByteArray(PyBytes_AS_STRING(aux), PyBytes_GET_SIZE(aux));
                b += ')';
                pyResult = Shiboken::String::fromStringAndSize(b.constData(), b.size());
#endif
            Py_DECREF(aux);
            // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-repr)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc___str__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.__str__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __str__()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-str)]
            PyObject *aux = PyBytes_FromStringAndSize(cppSelf->constData(), cppSelf->size());
            if (aux == nullptr) {
                return nullptr;
            }
#ifdef IS_PY3K
                pyResult = PyObject_Repr(aux);
                Py_DECREF(aux);
#else
                pyResult = aux;
#endif
            // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-str)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_append(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.append";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "append", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::append(char)
    // 1: QByteArray::append(QByteArray)
    // 2: QByteArray::append(int,char)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
        overloadId = 2; // append(int,char)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // append(QByteArray)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[0])))) {
        overloadId = 0; // append(char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_append_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // append(char c)
        {
            char cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // append(char)
                QByteArray & cppResult = cppSelf->append(cppArg0);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // append(const QByteArray & a)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // append(QByteArray)
                QByteArray & cppResult = cppSelf->append(*cppArg0);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 2: // append(int count, char c)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // append(int,char)
                QByteArray & cppResult = cppSelf->append(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_append_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_at(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.at";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::at(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // at(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_at_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // at(int)const
            char cppResult = const_cast<const ::QByteArray *>(cppSelf)->at(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_at_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_back(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.back";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // back()const
            char cppResult = const_cast<const ::QByteArray *>(cppSelf)->back();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_capacity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.capacity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capacity()const
            int cppResult = const_cast<const ::QByteArray *>(cppSelf)->capacity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_cbegin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.cbegin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cbegin()const
            const char * cppResult = const_cast<const ::QByteArray *>(cppSelf)->cbegin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_cend(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.cend";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cend()const
            const char * cppResult = const_cast<const ::QByteArray *>(cppSelf)->cend();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_chop(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.chop";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::chop(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // chop(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_chop_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // chop(int)
            cppSelf->chop(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QByteArrayFunc_chop_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_chopped(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.chopped";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::chopped(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // chopped(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_chopped_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // chopped(int)const
            QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->chopped(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_chopped_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QByteArrayFunc_compare(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.compare";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_compare_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_compare_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:compare", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::compare(QByteArray,Qt::CaseSensitivity)const
    // 1: QByteArray::compare(const char*,Qt::CaseSensitivity)const
    if (numArgs >= 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // compare(const char*,Qt::CaseSensitivity)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // compare(const char*,Qt::CaseSensitivity)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // compare(QByteArray,Qt::CaseSensitivity)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // compare(QByteArray,Qt::CaseSensitivity)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_compare_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // compare(const QByteArray & a, Qt::CaseSensitivity cs) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_cs = Shiboken::String::createStaticString("cs");
                if (PyDict_Contains(kwds, key_cs)) {
                    value = PyDict_GetItem(kwds, key_cs);
                    if (value && pyArgs[1]) {
                        errInfo = key_cs;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayFunc_compare_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QByteArrayFunc_compare_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_cs);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QByteArrayFunc_compare_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::Qt::CaseSensitivity cppArg1 = Qt::CaseSensitive;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // compare(QByteArray,Qt::CaseSensitivity)const
                int cppResult = const_cast<const ::QByteArray *>(cppSelf)->compare(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // compare(const char * c, Qt::CaseSensitivity cs) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_cs = Shiboken::String::createStaticString("cs");
                if (PyDict_Contains(kwds, key_cs)) {
                    value = PyDict_GetItem(kwds, key_cs);
                    if (value && pyArgs[1]) {
                        errInfo = key_cs;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayFunc_compare_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QByteArrayFunc_compare_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_cs);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QByteArrayFunc_compare_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::CaseSensitivity cppArg1 = Qt::CaseSensitive;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // compare(const char*,Qt::CaseSensitivity)const
                int cppResult = const_cast<const ::QByteArray *>(cppSelf)->compare(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_compare_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::contains(char)const
    // 1: QByteArray::contains(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 1; // contains(QByteArray)const
    } else if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 0; // contains(char)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_contains_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // contains(char c) const
        {
            char cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // contains(char)const
                bool cppResult = const_cast<const ::QByteArray *>(cppSelf)->contains(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // contains(const QByteArray & a) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // contains(QByteArray)const
                bool cppResult = const_cast<const ::QByteArray *>(cppSelf)->contains(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_count(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.count";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "count", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::count()const
    // 1: QByteArray::count(char)const
    // 2: QByteArray::count(QByteArray)const
    if (numArgs == 0) {
        overloadId = 0; // count()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 2; // count(QByteArray)const
    } else if (numArgs == 1
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[0])))) {
        overloadId = 1; // count(char)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_count_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // count() const
        {

            if (!PyErr_Occurred()) {
                // count()const
                int cppResult = const_cast<const ::QByteArray *>(cppSelf)->count();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // count(char c) const
        {
            char cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // count(char)const
                int cppResult = const_cast<const ::QByteArray *>(cppSelf)->count(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 2: // count(const QByteArray & a) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // count(QByteArray)const
                int cppResult = const_cast<const ::QByteArray *>(cppSelf)->count(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_count_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-data)]
            pyResult = PyBytes_FromStringAndSize(cppSelf->data(), cppSelf->size());
            // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-data)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_endsWith(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.endsWith";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::endsWith(char)const
    // 1: QByteArray::endsWith(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 1; // endsWith(QByteArray)const
    } else if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 0; // endsWith(char)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_endsWith_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // endsWith(char c) const
        {
            char cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // endsWith(char)const
                bool cppResult = const_cast<const ::QByteArray *>(cppSelf)->endsWith(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // endsWith(const QByteArray & a) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // endsWith(QByteArray)const
                bool cppResult = const_cast<const ::QByteArray *>(cppSelf)->endsWith(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_endsWith_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_fill(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.fill";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_fill_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_fill_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fill", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::fill(char,int)
    if (numArgs >= 1
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fill(char,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // fill(char,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_fill_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_size = Shiboken::String::createStaticString("size");
            if (PyDict_Contains(kwds, key_size)) {
                value = PyDict_GetItem(kwds, key_size);
                if (value && pyArgs[1]) {
                    errInfo = key_size;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_fill_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QByteArrayFunc_fill_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_size);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_fill_TypeError;
            }
        }
        char cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fill(char,int)
            QByteArray & cppResult = cppSelf->fill(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_fill_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_fromBase64(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.fromBase64";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "fromBase64", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QByteArray::fromBase64(QByteArray)
    // 1: static QByteArray::fromBase64(QByteArray,QFlags<QByteArray::Base64Option>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromBase64(QByteArray)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // fromBase64(QByteArray,QFlags<QByteArray::Base64Option>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_fromBase64_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromBase64(const QByteArray & base64)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // fromBase64(QByteArray)
                QByteArray cppResult = ::QByteArray::fromBase64(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromBase64(const QByteArray & base64, QFlags<QByteArray::Base64Option> options)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QFlags<QByteArray::Base64Option> cppArg1 = QFlags<QByteArray::Base64Option>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fromBase64(QByteArray,QFlags<QByteArray::Base64Option>)
                QByteArray cppResult = ::QByteArray::fromBase64(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_fromBase64_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_fromBase64Encoding(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.fromBase64Encoding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_fromBase64Encoding_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_fromBase64Encoding_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromBase64Encoding", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QByteArray::fromBase64Encoding(QByteArray,QFlags<QByteArray::Base64Option>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromBase64Encoding(QByteArray,QFlags<QByteArray::Base64Option>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromBase64Encoding(QByteArray,QFlags<QByteArray::Base64Option>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_fromBase64Encoding_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[1]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_fromBase64Encoding_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QByteArrayFunc_fromBase64Encoding_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_fromBase64Encoding_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFlags<QByteArray::Base64Option> cppArg1 = QByteArray::Base64Encoding;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromBase64Encoding(QByteArray,QFlags<QByteArray::Base64Option>)
            QByteArray::FromBase64Result cppResult = ::QByteArray::fromBase64Encoding(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_FROMBASE64RESULT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_fromBase64Encoding_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_fromHex(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.fromHex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QByteArray::fromHex(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // fromHex(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_fromHex_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // fromHex(QByteArray)
            QByteArray cppResult = ::QByteArray::fromHex(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_fromHex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_fromPercentEncoding(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.fromPercentEncoding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_fromPercentEncoding_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_fromPercentEncoding_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromPercentEncoding", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QByteArray::fromPercentEncoding(QByteArray,char)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromPercentEncoding(QByteArray,char)
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            overloadId = 0; // fromPercentEncoding(QByteArray,char)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_fromPercentEncoding_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_percent = Shiboken::String::createStaticString("percent");
            if (PyDict_Contains(kwds, key_percent)) {
                value = PyDict_GetItem(kwds, key_percent);
                if (value && pyArgs[1]) {
                    errInfo = key_percent;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_fromPercentEncoding_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1]))))
                        goto Sbk_QByteArrayFunc_fromPercentEncoding_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_percent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_fromPercentEncoding_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        char cppArg1 = '%';
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromPercentEncoding(QByteArray,char)
            QByteArray cppResult = ::QByteArray::fromPercentEncoding(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_fromPercentEncoding_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_fromRawData(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.fromRawData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QByteArray::fromRawData(const char*,int)
    if (PyBytes_Check(pyArg)) {
        overloadId = 0; // fromRawData(const char*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_fromRawData_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fromRawData(const char*,int)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-fromrawdata)]
            ::QByteArray cppResult = QByteArray::fromRawData(PyBytes_AsString(pyArg), PyBytes_GET_SIZE(pyArg));
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-fromrawdata)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_fromRawData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_front(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.front";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // front()const
            char cppResult = const_cast<const ::QByteArray *>(cppSelf)->front();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_indexOf(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.indexOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_indexOf_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_indexOf_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:indexOf", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::indexOf(QByteArray,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // indexOf(QByteArray,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // indexOf(QByteArray,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_indexOf_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_from = Shiboken::String::createStaticString("from");
            if (PyDict_Contains(kwds, key_from)) {
                value = PyDict_GetItem(kwds, key_from);
                if (value && pyArgs[1]) {
                    errInfo = key_from;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_indexOf_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QByteArrayFunc_indexOf_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_from);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_indexOf_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // indexOf(QByteArray,int)const
            int cppResult = const_cast<const ::QByteArray *>(cppSelf)->indexOf(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_indexOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_insert(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.insert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insert", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::insert(int,QByteArray)
    // 1: QByteArray::insert(int,int,char)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
            && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[2])))) {
            overloadId = 1; // insert(int,int,char)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 0; // insert(int,QByteArray)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_insert_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // insert(int i, const QByteArray & a)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // insert(int,QByteArray)
                QByteArray & cppResult = cppSelf->insert(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // insert(int i, int count, char c)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            char cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // insert(int,int,char)
                QByteArray & cppResult = cppSelf->insert(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_insert_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QByteArray *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_isLower(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.isLower";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLower()const
            bool cppResult = const_cast<const ::QByteArray *>(cppSelf)->isLower();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QByteArray *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_isSharedWith(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.isSharedWith";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::isSharedWith(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // isSharedWith(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_isSharedWith_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isSharedWith(QByteArray)const
            bool cppResult = const_cast<const ::QByteArray *>(cppSelf)->isSharedWith(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_isSharedWith_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_isUpper(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.isUpper";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUpper()const
            bool cppResult = const_cast<const ::QByteArray *>(cppSelf)->isUpper();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_lastIndexOf(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.lastIndexOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_lastIndexOf_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_lastIndexOf_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:lastIndexOf", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::lastIndexOf(QByteArray,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // lastIndexOf(QByteArray,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // lastIndexOf(QByteArray,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_lastIndexOf_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_from = Shiboken::String::createStaticString("from");
            if (PyDict_Contains(kwds, key_from)) {
                value = PyDict_GetItem(kwds, key_from);
                if (value && pyArgs[1]) {
                    errInfo = key_from;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_lastIndexOf_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QByteArrayFunc_lastIndexOf_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_from);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_lastIndexOf_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // lastIndexOf(QByteArray,int)const
            int cppResult = const_cast<const ::QByteArray *>(cppSelf)->lastIndexOf(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_lastIndexOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_left(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.left";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::left(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // left(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_left_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // left(int)const
            QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->left(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_left_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_leftJustified(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.leftJustified";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_leftJustified_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_leftJustified_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:leftJustified", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::leftJustified(int,char,bool)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // leftJustified(int,char,bool)const
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // leftJustified(int,char,bool)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
                overloadId = 0; // leftJustified(int,char,bool)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_leftJustified_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_fill = Shiboken::String::createStaticString("fill");
            if (PyDict_Contains(kwds, key_fill)) {
                value = PyDict_GetItem(kwds, key_fill);
                if (value && pyArgs[1]) {
                    errInfo = key_fill;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_leftJustified_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1]))))
                        goto Sbk_QByteArrayFunc_leftJustified_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_fill);
            }
            static PyObject *const key_truncate = Shiboken::String::createStaticString("truncate");
            if (PyDict_Contains(kwds, key_truncate)) {
                value = PyDict_GetItem(kwds, key_truncate);
                if (value && pyArgs[2]) {
                    errInfo = key_truncate;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_leftJustified_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))
                        goto Sbk_QByteArrayFunc_leftJustified_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_truncate);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_leftJustified_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        char cppArg1 = ' ';
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = false;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // leftJustified(int,char,bool)const
            QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->leftJustified(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_leftJustified_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_length(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.length";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // length()const
            int cppResult = const_cast<const ::QByteArray *>(cppSelf)->length();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_mid(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.mid";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_mid_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_mid_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:mid", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::mid(int,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // mid(int,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // mid(int,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_mid_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_len = Shiboken::String::createStaticString("len");
            if (PyDict_Contains(kwds, key_len)) {
                value = PyDict_GetItem(kwds, key_len);
                if (value && pyArgs[1]) {
                    errInfo = key_len;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_mid_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QByteArrayFunc_mid_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_len);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_mid_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // mid(int,int)const
            QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->mid(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_mid_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_number(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.number";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_number_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_number_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:number", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QByteArray::number(double,char,int)
    // 1: static QByteArray::number(int,int)
    // 2: static QByteArray::number(qlonglong,int)
    if (numArgs >= 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // number(double,char,int)
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // number(double,char,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // number(double,char,int)
            }
        }
    } else if (numArgs >= 1
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qlonglong>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // number(qlonglong,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 2; // number(qlonglong,int)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // number(int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // number(int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_number_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // number(double arg__1, char f, int prec)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_f = Shiboken::String::createStaticString("f");
                if (PyDict_Contains(kwds, key_f)) {
                    value = PyDict_GetItem(kwds, key_f);
                    if (value && pyArgs[1]) {
                        errInfo = key_f;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayFunc_number_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1]))))
                            goto Sbk_QByteArrayFunc_number_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_f);
                }
                static PyObject *const key_prec = Shiboken::String::createStaticString("prec");
                if (PyDict_Contains(kwds, key_prec)) {
                    value = PyDict_GetItem(kwds, key_prec);
                    if (value && pyArgs[2]) {
                        errInfo = key_prec;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayFunc_number_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QByteArrayFunc_number_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_prec);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QByteArrayFunc_number_TypeError;
                }
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1 = 'g';
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 6;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // number(double,char,int)
                QByteArray cppResult = ::QByteArray::number(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // number(int arg__1, int base)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_base = Shiboken::String::createStaticString("base");
                if (PyDict_Contains(kwds, key_base)) {
                    value = PyDict_GetItem(kwds, key_base);
                    if (value && pyArgs[1]) {
                        errInfo = key_base;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayFunc_number_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QByteArrayFunc_number_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_base);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QByteArrayFunc_number_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 10;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // number(int,int)
                QByteArray cppResult = ::QByteArray::number(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 2: // number(qlonglong arg__1, int base)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_base = Shiboken::String::createStaticString("base");
                if (PyDict_Contains(kwds, key_base)) {
                    value = PyDict_GetItem(kwds, key_base);
                    if (value && pyArgs[1]) {
                        errInfo = key_base;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayFunc_number_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QByteArrayFunc_number_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_base);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QByteArrayFunc_number_TypeError;
                }
            }
            qlonglong cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 10;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // number(qlonglong,int)
                QByteArray cppResult = ::QByteArray::number(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_number_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_prepend(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.prepend";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "prepend", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::prepend(char)
    // 1: QByteArray::prepend(QByteArray)
    // 2: QByteArray::prepend(int,char)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
        overloadId = 2; // prepend(int,char)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // prepend(QByteArray)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[0])))) {
        overloadId = 0; // prepend(char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_prepend_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // prepend(char c)
        {
            char cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // prepend(char)
                QByteArray & cppResult = cppSelf->prepend(cppArg0);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // prepend(const QByteArray & a)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // prepend(QByteArray)
                QByteArray & cppResult = cppSelf->prepend(*cppArg0);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 2: // prepend(int count, char c)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // prepend(int,char)
                QByteArray & cppResult = cppSelf->prepend(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_prepend_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_remove(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.remove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "remove", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::remove(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // remove(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_remove_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // remove(int,int)
            QByteArray & cppResult = cppSelf->remove(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_remove_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_repeated(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.repeated";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::repeated(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // repeated(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_repeated_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // repeated(int)const
            QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->repeated(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_repeated_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_replace(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.replace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "replace", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::replace(char,char)
    // 1: QByteArray::replace(char,QByteArray)
    // 2: QByteArray::replace(QByteArray,QByteArray)
    // 3: QByteArray::replace(QString,QByteArray)
    // 4: QByteArray::replace(int,int,QByteArray)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[2])))) {
        overloadId = 4; // replace(int,int,QByteArray)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 3; // replace(QString,QByteArray)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 2; // replace(QByteArray,QByteArray)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 1; // replace(char,QByteArray)
        } else if (numArgs == 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            overloadId = 0; // replace(char,char)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_replace_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // replace(char before, char after)
        {
            char cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // replace(char,char)
                QByteArray & cppResult = cppSelf->replace(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // replace(char before, const QByteArray & after)
        {
            char cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // replace(char,QByteArray)
                QByteArray & cppResult = cppSelf->replace(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 2: // replace(const QByteArray & before, const QByteArray & after)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // replace(QByteArray,QByteArray)
                QByteArray & cppResult = cppSelf->replace(*cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 3: // replace(const QString & before, const QByteArray & after)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // replace(QString,QByteArray)
                QByteArray & cppResult = cppSelf->replace(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QByteArray.replace(const QString & before, const QByteArray & after) is deprecated", 1);
            break;
        }
        case 4: // replace(int index, int len, const QByteArray & s)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QByteArray cppArg2_local;
            ::QByteArray *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // replace(int,int,QByteArray)
                QByteArray & cppResult = cppSelf->replace(cppArg0, cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_replace_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_reserve(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.reserve";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::reserve(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // reserve(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_reserve_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // reserve(int)
            cppSelf->reserve(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QByteArrayFunc_reserve_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_resize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.resize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::resize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // resize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_resize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resize(int)
            cppSelf->resize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QByteArrayFunc_resize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_right(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.right";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::right(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // right(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_right_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // right(int)const
            QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->right(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_right_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_rightJustified(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.rightJustified";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_rightJustified_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_rightJustified_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:rightJustified", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::rightJustified(int,char,bool)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // rightJustified(int,char,bool)const
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // rightJustified(int,char,bool)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
                overloadId = 0; // rightJustified(int,char,bool)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_rightJustified_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_fill = Shiboken::String::createStaticString("fill");
            if (PyDict_Contains(kwds, key_fill)) {
                value = PyDict_GetItem(kwds, key_fill);
                if (value && pyArgs[1]) {
                    errInfo = key_fill;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_rightJustified_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1]))))
                        goto Sbk_QByteArrayFunc_rightJustified_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_fill);
            }
            static PyObject *const key_truncate = Shiboken::String::createStaticString("truncate");
            if (PyDict_Contains(kwds, key_truncate)) {
                value = PyDict_GetItem(kwds, key_truncate);
                if (value && pyArgs[2]) {
                    errInfo = key_truncate;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_rightJustified_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))
                        goto Sbk_QByteArrayFunc_rightJustified_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_truncate);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_rightJustified_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        char cppArg1 = ' ';
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = false;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // rightJustified(int,char,bool)const
            QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->rightJustified(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_rightJustified_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_setNum(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.setNum";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_setNum_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_setNum_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setNum", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::setNum(double,char,int)
    // 1: QByteArray::setNum(int,int)
    // 2: QByteArray::setNum(qlonglong,int)
    if (numArgs >= 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setNum(double,char,int)
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setNum(double,char,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // setNum(double,char,int)
            }
        }
    } else if (numArgs >= 1
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qlonglong>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // setNum(qlonglong,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 2; // setNum(qlonglong,int)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // setNum(int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // setNum(int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_setNum_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setNum(double arg__1, char f, int prec)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_f = Shiboken::String::createStaticString("f");
                if (PyDict_Contains(kwds, key_f)) {
                    value = PyDict_GetItem(kwds, key_f);
                    if (value && pyArgs[1]) {
                        errInfo = key_f;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayFunc_setNum_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1]))))
                            goto Sbk_QByteArrayFunc_setNum_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_f);
                }
                static PyObject *const key_prec = Shiboken::String::createStaticString("prec");
                if (PyDict_Contains(kwds, key_prec)) {
                    value = PyDict_GetItem(kwds, key_prec);
                    if (value && pyArgs[2]) {
                        errInfo = key_prec;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayFunc_setNum_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QByteArrayFunc_setNum_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_prec);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QByteArrayFunc_setNum_TypeError;
                }
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1 = 'g';
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 6;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setNum(double,char,int)
                QByteArray & cppResult = cppSelf->setNum(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // setNum(int arg__1, int base)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_base = Shiboken::String::createStaticString("base");
                if (PyDict_Contains(kwds, key_base)) {
                    value = PyDict_GetItem(kwds, key_base);
                    if (value && pyArgs[1]) {
                        errInfo = key_base;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayFunc_setNum_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QByteArrayFunc_setNum_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_base);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QByteArrayFunc_setNum_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 10;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setNum(int,int)
                QByteArray & cppResult = cppSelf->setNum(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 2: // setNum(qlonglong arg__1, int base)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_base = Shiboken::String::createStaticString("base");
                if (PyDict_Contains(kwds, key_base)) {
                    value = PyDict_GetItem(kwds, key_base);
                    if (value && pyArgs[1]) {
                        errInfo = key_base;
                        Py_INCREF(errInfo);
                        goto Sbk_QByteArrayFunc_setNum_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QByteArrayFunc_setNum_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_base);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QByteArrayFunc_setNum_TypeError;
                }
            }
            qlonglong cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 10;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setNum(qlonglong,int)
                QByteArray & cppResult = cppSelf->setNum(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_setNum_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_setRawData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.setRawData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setRawData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::setRawData(const char*,uint)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[1])))) {
        overloadId = 0; // setRawData(const char*,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_setRawData_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        uint cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setRawData(const char*,uint)
            QByteArray & cppResult = cppSelf->setRawData(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_setRawData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_shrink_to_fit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.shrink_to_fit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shrink_to_fit()
            cppSelf->shrink_to_fit();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QByteArrayFunc_simplified(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.simplified";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // simplified()
            QByteArray cppResult = cppSelf->simplified();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            int cppResult = const_cast<const ::QByteArray *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_split(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.split";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::split(char)const
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 0; // split(char)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_split_TypeError;

    // Call function/method
    {
        char cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // split(char)const
            QList<QByteArray > cppResult = const_cast<const ::QByteArray *>(cppSelf)->split(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_split_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_squeeze(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.squeeze";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // squeeze()
            cppSelf->squeeze();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QByteArrayFunc_startsWith(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.startsWith";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::startsWith(char)const
    // 1: QByteArray::startsWith(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 1; // startsWith(QByteArray)const
    } else if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 0; // startsWith(char)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_startsWith_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // startsWith(char c) const
        {
            char cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // startsWith(char)const
                bool cppResult = const_cast<const ::QByteArray *>(cppSelf)->startsWith(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // startsWith(const QByteArray & a) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // startsWith(QByteArray)const
                bool cppResult = const_cast<const ::QByteArray *>(cppSelf)->startsWith(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_startsWith_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::swap(QByteArray&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QByteArray&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QByteArray&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QByteArrayFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toBase64(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toBase64";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toBase64", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::toBase64()const
    // 1: QByteArray::toBase64(QFlags<QByteArray::Base64Option>)const
    if (numArgs == 0) {
        overloadId = 0; // toBase64()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // toBase64(QFlags<QByteArray::Base64Option>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_toBase64_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toBase64() const
        {

            if (!PyErr_Occurred()) {
                // toBase64()const
                QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->toBase64();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toBase64(QFlags<QByteArray::Base64Option> options) const
        {
            ::QFlags<QByteArray::Base64Option> cppArg0 = QFlags<QByteArray::Base64Option>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toBase64(QFlags<QByteArray::Base64Option>)const
                QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->toBase64(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_toBase64_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toDouble(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toDouble";
    SBK_UNUSED(fullName)

    // Call function/method
    {
        bool* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)

        if (!PyErr_Occurred()) {
            // toDouble(bool*)const
            // Begin code injection
            // TEMPLATE - fix_bool* - START
            bool ok_;
            double retval_ = cppSelf->toDouble(&ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_toFloat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toFloat";
    SBK_UNUSED(fullName)

    // Call function/method
    {
        bool* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)

        if (!PyErr_Occurred()) {
            // toFloat(bool*)const
            // Begin code injection
            // TEMPLATE - fix_bool* - START
            bool ok_;
            float retval_ = cppSelf->toFloat(&ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_toHex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toHex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toHex", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::toHex()const
    // 1: QByteArray::toHex(char)const
    if (numArgs == 0) {
        overloadId = 0; // toHex()const
    } else if (numArgs == 1
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[0])))) {
        overloadId = 1; // toHex(char)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_toHex_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toHex() const
        {

            if (!PyErr_Occurred()) {
                // toHex()const
                QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->toHex();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toHex(char separator) const
        {
            char cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toHex(char)const
                QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->toHex(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_toHex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toInt(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toInt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_toInt_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toInt", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::toInt(bool*,int)const
    if (numArgs == 0) {
        overloadId = 0; // toInt(bool*,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // toInt(bool*,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_toInt_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_base = Shiboken::String::createStaticString("base");
            if (PyDict_Contains(kwds, key_base)) {
                value = PyDict_GetItem(kwds, key_base);
                if (value && pyArgs[0]) {
                    errInfo = key_base;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_toInt_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QByteArrayFunc_toInt_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_base);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_toInt_TypeError;
            }
        }
        bool* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)
        int cppArg0 = 10;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toInt(bool*,int)const
            // Begin code injection
            // TEMPLATE - fix_bool*,arg - START
            bool ok_;
            int retval_ = cppSelf->toInt(&ok_, cppArg0);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_bool*,arg - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_toInt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toLong(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toLong";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_toLong_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toLong", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::toLong(bool*,int)const
    if (numArgs == 0) {
        overloadId = 0; // toLong(bool*,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // toLong(bool*,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_toLong_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_base = Shiboken::String::createStaticString("base");
            if (PyDict_Contains(kwds, key_base)) {
                value = PyDict_GetItem(kwds, key_base);
                if (value && pyArgs[0]) {
                    errInfo = key_base;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_toLong_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QByteArrayFunc_toLong_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_base);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_toLong_TypeError;
            }
        }
        bool* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)
        int cppArg0 = 10;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toLong(bool*,int)const
            // Begin code injection
            // TEMPLATE - fix_bool*,arg - START
            bool ok_;
            long retval_ = cppSelf->toLong(&ok_, cppArg0);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<long>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_bool*,arg - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_toLong_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toLongLong(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toLongLong";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_toLongLong_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toLongLong", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::toLongLong(bool*,int)const
    if (numArgs == 0) {
        overloadId = 0; // toLongLong(bool*,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // toLongLong(bool*,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_toLongLong_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_base = Shiboken::String::createStaticString("base");
            if (PyDict_Contains(kwds, key_base)) {
                value = PyDict_GetItem(kwds, key_base);
                if (value && pyArgs[0]) {
                    errInfo = key_base;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_toLongLong_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QByteArrayFunc_toLongLong_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_base);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_toLongLong_TypeError;
            }
        }
        bool* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)
        int cppArg0 = 10;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toLongLong(bool*,int)const
            // Begin code injection
            // TEMPLATE - fix_bool*,arg - START
            bool ok_;
            qlonglong retval_ = cppSelf->toLongLong(&ok_, cppArg0);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qlonglong>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_bool*,arg - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_toLongLong_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toLower(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toLower";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toLower()
            QByteArray cppResult = cppSelf->toLower();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_toPercentEncoding(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toPercentEncoding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_toPercentEncoding_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:toPercentEncoding", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::toPercentEncoding(QByteArray,QByteArray,char)const
    if (numArgs == 0) {
        overloadId = 0; // toPercentEncoding(QByteArray,QByteArray,char)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toPercentEncoding(QByteArray,QByteArray,char)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // toPercentEncoding(QByteArray,QByteArray,char)const
            } else if (numArgs >= 3
                && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[2])))) {
                overloadId = 0; // toPercentEncoding(QByteArray,QByteArray,char)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_toPercentEncoding_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_exclude = Shiboken::String::createStaticString("exclude");
            if (PyDict_Contains(kwds, key_exclude)) {
                value = PyDict_GetItem(kwds, key_exclude);
                if (value && pyArgs[0]) {
                    errInfo = key_exclude;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_toPercentEncoding_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0]))))
                        goto Sbk_QByteArrayFunc_toPercentEncoding_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_exclude);
            }
            static PyObject *const key_include = Shiboken::String::createStaticString("include");
            if (PyDict_Contains(kwds, key_include)) {
                value = PyDict_GetItem(kwds, key_include);
                if (value && pyArgs[1]) {
                    errInfo = key_include;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_toPercentEncoding_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1]))))
                        goto Sbk_QByteArrayFunc_toPercentEncoding_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_include);
            }
            static PyObject *const key_percent = Shiboken::String::createStaticString("percent");
            if (PyDict_Contains(kwds, key_percent)) {
                value = PyDict_GetItem(kwds, key_percent);
                if (value && pyArgs[2]) {
                    errInfo = key_percent;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_toPercentEncoding_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[2]))))
                        goto Sbk_QByteArrayFunc_toPercentEncoding_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_percent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_toPercentEncoding_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local = QByteArray();
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local = QByteArray();
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }
        char cppArg2 = '%';
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // toPercentEncoding(QByteArray,QByteArray,char)const
            QByteArray cppResult = const_cast<const ::QByteArray *>(cppSelf)->toPercentEncoding(*cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_toPercentEncoding_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toShort(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toShort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_toShort_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toShort", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::toShort(bool*,int)const
    if (numArgs == 0) {
        overloadId = 0; // toShort(bool*,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // toShort(bool*,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_toShort_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_base = Shiboken::String::createStaticString("base");
            if (PyDict_Contains(kwds, key_base)) {
                value = PyDict_GetItem(kwds, key_base);
                if (value && pyArgs[0]) {
                    errInfo = key_base;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_toShort_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QByteArrayFunc_toShort_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_base);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_toShort_TypeError;
            }
        }
        bool* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)
        int cppArg0 = 10;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toShort(bool*,int)const
            // Begin code injection
            // TEMPLATE - fix_bool*,arg - START
            bool ok_;
            short retval_ = cppSelf->toShort(&ok_, cppArg0);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<short>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_bool*,arg - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_toShort_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toUInt(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toUInt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_toUInt_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toUInt", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::toUInt(bool*,int)const
    if (numArgs == 0) {
        overloadId = 0; // toUInt(bool*,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // toUInt(bool*,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_toUInt_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_base = Shiboken::String::createStaticString("base");
            if (PyDict_Contains(kwds, key_base)) {
                value = PyDict_GetItem(kwds, key_base);
                if (value && pyArgs[0]) {
                    errInfo = key_base;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_toUInt_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QByteArrayFunc_toUInt_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_base);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_toUInt_TypeError;
            }
        }
        bool* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)
        int cppArg0 = 10;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toUInt(bool*,int)const
            // Begin code injection
            // TEMPLATE - fix_bool*,arg - START
            bool ok_;
            uint retval_ = cppSelf->toUInt(&ok_, cppArg0);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_bool*,arg - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_toUInt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toULong(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toULong";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_toULong_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toULong", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::toULong(bool*,int)const
    if (numArgs == 0) {
        overloadId = 0; // toULong(bool*,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // toULong(bool*,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_toULong_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_base = Shiboken::String::createStaticString("base");
            if (PyDict_Contains(kwds, key_base)) {
                value = PyDict_GetItem(kwds, key_base);
                if (value && pyArgs[0]) {
                    errInfo = key_base;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_toULong_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QByteArrayFunc_toULong_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_base);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_toULong_TypeError;
            }
        }
        bool* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)
        int cppArg0 = 10;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toULong(bool*,int)const
            // Begin code injection
            // TEMPLATE - fix_bool*,arg - START
            bool ok_;
            ulong retval_ = cppSelf->toULong(&ok_, cppArg0);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<ulong>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_bool*,arg - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_toULong_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toULongLong(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toULongLong";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_toULongLong_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toULongLong", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::toULongLong(bool*,int)const
    if (numArgs == 0) {
        overloadId = 0; // toULongLong(bool*,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // toULongLong(bool*,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_toULongLong_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_base = Shiboken::String::createStaticString("base");
            if (PyDict_Contains(kwds, key_base)) {
                value = PyDict_GetItem(kwds, key_base);
                if (value && pyArgs[0]) {
                    errInfo = key_base;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_toULongLong_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QByteArrayFunc_toULongLong_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_base);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_toULongLong_TypeError;
            }
        }
        bool* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)
        int cppArg0 = 10;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toULongLong(bool*,int)const
            // Begin code injection
            // TEMPLATE - fix_bool*,arg - START
            bool ok_;
            qulonglong retval_ = cppSelf->toULongLong(&ok_, cppArg0);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_bool*,arg - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_toULongLong_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toUShort(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toUShort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QByteArrayFunc_toUShort_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toUShort", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QByteArray::toUShort(bool*,int)const
    if (numArgs == 0) {
        overloadId = 0; // toUShort(bool*,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // toUShort(bool*,int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_toUShort_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_base = Shiboken::String::createStaticString("base");
            if (PyDict_Contains(kwds, key_base)) {
                value = PyDict_GetItem(kwds, key_base);
                if (value && pyArgs[0]) {
                    errInfo = key_base;
                    Py_INCREF(errInfo);
                    goto Sbk_QByteArrayFunc_toUShort_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QByteArrayFunc_toUShort_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_base);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QByteArrayFunc_toUShort_TypeError;
            }
        }
        bool* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)
        int cppArg0 = 10;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toUShort(bool*,int)const
            // Begin code injection
            // TEMPLATE - fix_bool*,arg - START
            bool ok_;
            ushort retval_ = cppSelf->toUShort(&ok_, cppArg0);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_bool*,arg - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc_toUShort_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc_toUpper(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.toUpper";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toUpper()
            QByteArray cppResult = cppSelf->toUpper();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_trimmed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.trimmed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // trimmed()
            QByteArray cppResult = cppSelf->trimmed();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QByteArrayFunc_truncate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.truncate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::truncate(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // truncate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc_truncate_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // truncate(int)
            cppSelf->truncate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QByteArrayFunc_truncate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArray___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QByteArray_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QByteArray_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc___reduce__), METH_NOARGS},
    {"append", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_append), METH_VARARGS},
    {"at", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_at), METH_O},
    {"back", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_back), METH_NOARGS},
    {"capacity", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_capacity), METH_NOARGS},
    {"cbegin", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_cbegin), METH_NOARGS},
    {"cend", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_cend), METH_NOARGS},
    {"chop", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_chop), METH_O},
    {"chopped", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_chopped), METH_O},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_clear), METH_NOARGS},
    {"compare", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_compare), METH_VARARGS|METH_KEYWORDS},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_contains), METH_O},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_count), METH_VARARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_data), METH_NOARGS},
    {"endsWith", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_endsWith), METH_O},
    {"fill", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_fill), METH_VARARGS|METH_KEYWORDS},
    {"fromBase64", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_fromBase64), METH_VARARGS|METH_STATIC},
    {"fromBase64Encoding", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_fromBase64Encoding), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromHex", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_fromHex), METH_O|METH_STATIC},
    {"fromPercentEncoding", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_fromPercentEncoding), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromRawData", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_fromRawData), METH_O|METH_STATIC},
    {"front", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_front), METH_NOARGS},
    {"indexOf", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_indexOf), METH_VARARGS|METH_KEYWORDS},
    {"insert", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_insert), METH_VARARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_isEmpty), METH_NOARGS},
    {"isLower", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_isLower), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_isNull), METH_NOARGS},
    {"isSharedWith", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_isSharedWith), METH_O},
    {"isUpper", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_isUpper), METH_NOARGS},
    {"lastIndexOf", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_lastIndexOf), METH_VARARGS|METH_KEYWORDS},
    {"left", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_left), METH_O},
    {"leftJustified", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_leftJustified), METH_VARARGS|METH_KEYWORDS},
    {"length", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_length), METH_NOARGS},
    {"mid", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_mid), METH_VARARGS|METH_KEYWORDS},
    {"number", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_number), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"prepend", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_prepend), METH_VARARGS},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_remove), METH_VARARGS},
    {"repeated", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_repeated), METH_O},
    {"replace", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_replace), METH_VARARGS},
    {"reserve", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_reserve), METH_O},
    {"resize", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_resize), METH_O},
    {"right", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_right), METH_O},
    {"rightJustified", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_rightJustified), METH_VARARGS|METH_KEYWORDS},
    {"setNum", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_setNum), METH_VARARGS|METH_KEYWORDS},
    {"setRawData", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_setRawData), METH_VARARGS},
    {"shrink_to_fit", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_shrink_to_fit), METH_NOARGS},
    {"simplified", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_simplified), METH_NOARGS},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_size), METH_NOARGS},
    {"split", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_split), METH_O},
    {"squeeze", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_squeeze), METH_NOARGS},
    {"startsWith", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_startsWith), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_swap), METH_O},
    {"toBase64", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toBase64), METH_VARARGS},
    {"toDouble", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toDouble), METH_NOARGS},
    {"toFloat", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toFloat), METH_NOARGS},
    {"toHex", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toHex), METH_VARARGS},
    {"toInt", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toInt), METH_VARARGS|METH_KEYWORDS},
    {"toLong", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toLong), METH_VARARGS|METH_KEYWORDS},
    {"toLongLong", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toLongLong), METH_VARARGS|METH_KEYWORDS},
    {"toLower", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toLower), METH_NOARGS},
    {"toPercentEncoding", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toPercentEncoding), METH_VARARGS|METH_KEYWORDS},
    {"toShort", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toShort), METH_VARARGS|METH_KEYWORDS},
    {"toUInt", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toUInt), METH_VARARGS|METH_KEYWORDS},
    {"toULong", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toULong), METH_VARARGS|METH_KEYWORDS},
    {"toULongLong", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toULongLong), METH_VARARGS|METH_KEYWORDS},
    {"toUShort", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toUShort), METH_VARARGS|METH_KEYWORDS},
    {"toUpper", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_toUpper), METH_NOARGS},
    {"trimmed", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_trimmed), METH_NOARGS},
    {"truncate", reinterpret_cast<PyCFunction>(Sbk_QByteArrayFunc_truncate), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QByteArray___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QByteArray___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

static PyObject *Sbk_QByteArrayFunc___add__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.__add__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::operator+(PyByteArray,QByteArray)
    // 1: QByteArray::operator+(PyByteArray)
    // 2: QByteArray::operator+(PyBytes,QByteArray)
    // 3: QByteArray::operator+(QByteArray,char)
    // 4: QByteArray::operator+(QByteArray,QByteArray)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 4; // operator+(QByteArray,QByteArray)
    } else if (!isReverse
        && SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 3; // operator+(QByteArray,char)
    } else if (isReverse
        && PyBytes_Check(pyArg)) {
        overloadId = 2; // operator+(PyBytes,QByteArray)
    } else if (!isReverse
        && PyByteArray_Check(pyArg)) {
        overloadId = 1; // operator+(PyByteArray)
    } else if (isReverse
        && PyByteArray_Check(pyArg)) {
        overloadId = 0; // operator+(PyByteArray,QByteArray)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc___add___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator+(PyByteArray , QByteArray )
        {

            if (!PyErr_Occurred()) {
                // operator+(PyByteArray,QByteArray) [reverse operator]
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorplus-2)]
                QByteArray ba = QByteArray(PyByteArray_AsString(pyArg), PyByteArray_Size(pyArg)) + *cppSelf;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &ba);
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorplus-2)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // operator+(PyByteArray arg__1)
        {

            if (!PyErr_Occurred()) {
                // operator+(PyByteArray)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorplus-3)]
                QByteArray ba = *cppSelf + QByteArray(PyByteArray_AsString(pyArg), PyByteArray_Size(pyArg));
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &ba);
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorplus-3)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 2: // operator+(PyBytes , QByteArray )
        {

            if (!PyErr_Occurred()) {
                // operator+(PyBytes,QByteArray) [reverse operator]
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorplus-1)]
                QByteArray ba = QByteArray(PyBytes_AS_STRING(pyArg), PyBytes_GET_SIZE(pyArg)) + *cppSelf;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &ba);
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorplus-1)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 3: // operator+(char a2)
        {
            char cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator+(QByteArray,char)
                const QByteArray cppResult = (*cppSelf) + cppArg0;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 4: // operator+(const QByteArray & a2)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator+(QByteArray,QByteArray)
                const QByteArray cppResult = (*cppSelf) + (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QByteArrayFunc___add___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QByteArrayFunc___iadd__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QByteArray.__iadd__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QByteArray::operator+=(PyByteArray)
    // 1: QByteArray::operator+=(char)
    // 2: QByteArray::operator+=(QByteArray)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 2; // operator+=(QByteArray)
    } else if (!isReverse
        && SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 1; // operator+=(char)
    } else if (!isReverse
        && PyByteArray_Check(pyArg)) {
        overloadId = 0; // operator+=(PyByteArray)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QByteArrayFunc___iadd___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator+=(PyByteArray arg__1)
        {

            if (!PyErr_Occurred()) {
                // operator+=(PyByteArray)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorplusequal)]
                *cppSelf += QByteArray(PyByteArray_AsString(pyArg), PyByteArray_Size(pyArg));
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorplusequal)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // operator+=(char c)
        {
            char cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator+=(char)
                (*cppSelf) += cppArg0;
            }
            break;
        }
        case 2: // operator+=(const QByteArray & a)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator+=(QByteArray)
                (*cppSelf) += (*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QByteArrayFunc___iadd___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

PyObject* Sbk_QByteArrayFunc___getitem__(PyObject *self, Py_ssize_t _i)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-getitem)]
    if (_i < 0 || _i >= cppSelf->size()) {
        PyErr_SetString(PyExc_IndexError, "index out of bounds");
        return 0;
    } else {
        char res[2];
        res[0] = cppSelf->at(_i);
        res[1] = 0;
        return PyBytes_FromStringAndSize(res, 1);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-getitem)]
    // ========================================================================

    // End of code injection

}

int Sbk_QByteArrayFunc___setitem__(PyObject *self, Py_ssize_t _i, PyObject *_value)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-setitem)]
    cppSelf->remove(_i, 1);
    PyObject *args = Py_BuildValue("(nO)", _i, _value);
    PyObject *result = Sbk_QByteArrayFunc_insert(self, args);
    Py_DECREF(args);
    Py_XDECREF(result);
    return !result ? -1 : 0;
    // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-setitem)]
    // ========================================================================

    // End of code injection

}

Py_ssize_t Sbk_QByteArrayFunc___len__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-len)]
    return cppSelf->count();
    // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-len)]
    // ========================================================================

    // End of code injection

}

PyObject* Sbk_QByteArrayFunc___mgetitem__(PyObject *self, PyObject *_key)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-mgetitem)]
    if (PyIndex_Check(_key)) {
        Py_ssize_t _i;
        _i = PyNumber_AsSsize_t(_key, PyExc_IndexError);
        if (_i < 0 || _i >= cppSelf->size()) {
            PyErr_SetString(PyExc_IndexError, "index out of bounds");
            return 0;
        } else {
            char res[2];
            res[0] = cppSelf->at(_i);
            res[1] = 0;
            return PyBytes_FromStringAndSize(res, 1);
        }
    } else if (PySlice_Check(_key)) {
        Py_ssize_t start, stop, step, slicelength, cur;

#ifdef IS_PY3K
        PyObject *key = _key;
#else
        PySliceObject *key = reinterpret_cast<PySliceObject *>(_key);
#endif
        if (PySlice_GetIndicesEx(key, cppSelf->count(), &start, &stop, &step, &slicelength) < 0) {
            return nullptr;
        }

        QByteArray ba;
        if (slicelength <= 0) {
            return Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &ba);
        } else if (step == 1) {
            Py_ssize_t max = cppSelf->count();
            start = qBound(Py_ssize_t(0), start, max);
            stop = qBound(Py_ssize_t(0), stop, max);
            QByteArray ba;
            if (start < stop)
                ba = cppSelf->mid(start, stop - start);
            return Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &ba);
        } else {
            QByteArray ba;
            for (cur = start; slicelength > 0; cur += static_cast<size_t>(step), slicelength--) {
                ba.append(cppSelf->at(cur));
            }
            return Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &ba);
        }
    } else {
        PyErr_Format(PyExc_TypeError,
                     "list indices must be integers or slices, not %.200s",
                     Py_TYPE(_key)->tp_name);
        return nullptr;
    }
    // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-mgetitem)]
    // ========================================================================

    // End of code injection

}

int Sbk_QByteArrayFunc___msetitem__(PyObject *self, PyObject *_key, PyObject *_value)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-msetitem)]
    if (PyIndex_Check(_key)) {
        Py_ssize_t _i = PyNumber_AsSsize_t(_key, PyExc_IndexError);
        if (_i == -1 && PyErr_Occurred())
            return -1;

        if (_i < 0)
            _i += cppSelf->count();

        if (_i < 0 || _i >= cppSelf->size()) {
            PyErr_SetString(PyExc_IndexError, "QByteArray index out of range");
            return -1;
        }

        // Provide more specific error message for bytes/str, bytearray, QByteArray respectively
#ifdef IS_PY3K
        if (PyBytes_Check(_value)) {
            if (Py_SIZE(_value) != 1) {
                PyErr_SetString(PyExc_ValueError, "bytes must be of size 1");
#else
        if (PyString_CheckExact(_value)) {
            if (Py_SIZE(_value) != 1) {
                PyErr_SetString(PyExc_ValueError, "str must be of size 1");
#endif
                return -1;
            }
        } else if (PyByteArray_Check(_value)) {
            if (Py_SIZE(_value) != 1) {
                PyErr_SetString(PyExc_ValueError, "bytearray must be of size 1");
                return -1;
            }
        } else if (reinterpret_cast<PyTypeObject *>(Py_TYPE(_value)) == reinterpret_cast<PyTypeObject *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])) {
            if (PyObject_Length(_value) != 1) {
                PyErr_SetString(PyExc_ValueError, "QByteArray must be of size 1");
                return -1;
            }
        } else {
#ifdef IS_PY3K
            PyErr_SetString(PyExc_ValueError, "a bytes, bytearray, QByteArray of size 1 is required");
#else
            PyErr_SetString(PyExc_ValueError, "a str, bytearray, QByteArray of size 1 is required");
#endif
            return -1;
        }

        // Not support int or long.
        cppSelf->remove(_i, 1);
        PyObject *args = Py_BuildValue("(nO)", _i, _value);
        PyObject *result = Sbk_QByteArrayFunc_insert(self, args);
        Py_DECREF(args);
        Py_XDECREF(result);
        return !result ? -1 : 0;
    } else if (PySlice_Check(_key)) {
        Py_ssize_t start, stop, step, slicelength, value_length;

#ifdef IS_PY3K
        PyObject *key = _key;
#else
        PySliceObject *key = reinterpret_cast<PySliceObject *>(_key);
#endif
        if (PySlice_GetIndicesEx(key, cppSelf->count(), &start, &stop, &step, &slicelength) < 0) {
            return -1;
        }
        // The parameter candidates are: bytes/str, bytearray, QByteArray itself.
        // Not support iterable which contains ints between 0~255

        // case 1: value is nullpre, means delete the items within the range
        // case 2: step is 1, means shrink or expanse
        // case 3: step is not 1, then the number of slots have to equal the number of items in _value
        QByteArray ba;
        if (_value == nullptr || _value == Py_None) {
            ba = QByteArray();
            value_length = 0;
        } else if (!(PyBytes_Check(_value) || PyByteArray_Check(_value) || reinterpret_cast<PyTypeObject *>(Py_TYPE(_value)) == reinterpret_cast<PyTypeObject *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]))) {
            PyErr_Format(PyExc_TypeError, "bytes, bytearray or QByteArray is required, not %.200s", Py_TYPE(_value)->tp_name);
            return -1;
        } else {
            value_length = PyObject_Length(_value);
        }

        if (step != 1 && value_length != slicelength) {
            PyErr_Format(PyExc_ValueError, "attempt to assign %s of size %d to extended slice of size %d",
                         Py_TYPE(_value)->tp_name, int(value_length), int(slicelength));
            return -1;
        }

        if (step != 1) {
            int i = start;
            for (int j = 0; j < slicelength; j++) {
                PyObject *item = PyObject_GetItem(_value, PyLong_FromLong(j));
                QByteArray temp;
#ifdef IS_PY3K
                if (PyLong_Check(item)) {
#else
                if (PyLong_Check(item) || PyInt_Check(item)) {
#endif
                    int overflow;
                    const long ival = PyLong_AsLongAndOverflow(item, &overflow);
                    // Not supposed to be bigger than 255 because only bytes,
                    // bytearray, QByteArray were accepted
                    temp.append(char(ival));
                } else {
                    Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), item, &(temp));
                }

                cppSelf->replace(i, 1, temp);
                i += step;
            }
            return 0;
        } else {
            Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), _value, &(ba));
            cppSelf->replace(start, slicelength, ba);
            return 0;
        }
    } else {
        PyErr_Format(PyExc_TypeError, "QBytearray indices must be integers or slices, not %.200s",
                      Py_TYPE(_key)->tp_name);
        return -1;
    }
    // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-msetitem)]
    // ========================================================================

    // End of code injection

}

// Rich comparison
static PyObject * Sbk_QByteArray_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator!=(const QStringRef & rhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator!=(const QStringRef & lhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
                // operator!=(const QByteArray & a2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QByteArray cppArg0_local;
                ::QByteArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if (PyUnicode_Check(pyArg)) {
                // operator!=(PyUnicode arg__1)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatornotequal)]
                if (PyUnicode_CheckExact(pyArg)) {
                    Shiboken::AutoDecRef data(PyUnicode_AsASCIIString(pyArg));
                    QByteArray ba = QByteArray(PyBytes_AsString(data.object()), PyBytes_GET_SIZE(data.object()));
                    bool cppResult = cppSelf != ba;
                    pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
                }
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatornotequal)]
                // ========================================================================

                // End of code injection

            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
                // operator<(const char * a2)
                const char* cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf <(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator<(const QStringRef & rhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf <(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator<(const QStringRef & lhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf <(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
                // operator<(const QByteArray & a2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QByteArray cppArg0_local;
                ::QByteArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if (PyUnicode_Check(pyArg)) {
                // operator<(PyUnicode arg__1)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorlower)]
                if (PyUnicode_CheckExact(pyArg)) {
                    Shiboken::AutoDecRef data(PyUnicode_AsASCIIString(pyArg));
                    QByteArray ba = QByteArray(PyBytes_AsString(data.object()), PyBytes_GET_SIZE(data.object()));
                    bool cppResult = cppSelf < ba;
                    pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
                }
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorlower)]
                // ========================================================================

                // End of code injection

            } else {
                goto Sbk_QByteArray_RichComparison_TypeError;
            }

            break;
        case Py_LE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator<=(const QStringRef & rhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf <=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator<=(const QStringRef & lhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf <=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
                // operator<=(const QByteArray & a2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QByteArray cppArg0_local;
                ::QByteArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if (PyUnicode_Check(pyArg)) {
                // operator<=(PyUnicode arg__1)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorlowerequal)]
                if (PyUnicode_CheckExact(pyArg)) {
                    Shiboken::AutoDecRef data(PyUnicode_AsASCIIString(pyArg));
                    QByteArray ba = QByteArray(PyBytes_AsString(data.object()), PyBytes_GET_SIZE(data.object()));
                    bool cppResult = cppSelf <= ba;
                    pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
                }
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorlowerequal)]
                // ========================================================================

                // End of code injection

            } else {
                goto Sbk_QByteArray_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator==(const QStringRef & rhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator==(const QStringRef & lhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
                // operator==(const QByteArray & a2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QByteArray cppArg0_local;
                ::QByteArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if (PyUnicode_Check(pyArg)) {
                // operator==(PyUnicode arg__1)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorequalequal)]
                if (PyUnicode_CheckExact(pyArg)) {
                    Shiboken::AutoDecRef data(PyUnicode_AsASCIIString(pyArg));
                    QByteArray ba = QByteArray(PyBytes_AsString(data.object()), PyBytes_GET_SIZE(data.object()));
                    bool cppResult = cppSelf == ba;
                    pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
                }
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorequalequal)]
                // ========================================================================

                // End of code injection

            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        case Py_GT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator>(const QStringRef & rhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf >(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator>(const QStringRef & lhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf >(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
                // operator>(const QByteArray & a2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QByteArray cppArg0_local;
                ::QByteArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if (PyUnicode_Check(pyArg)) {
                // operator>(PyUnicode arg__1)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorgreater)]
                if (PyUnicode_CheckExact(pyArg)) {
                    Shiboken::AutoDecRef data(PyUnicode_AsASCIIString(pyArg));
                    QByteArray ba = QByteArray(PyBytes_AsString(data.object()), PyBytes_GET_SIZE(data.object()));
                    bool cppResult = cppSelf > ba;
                    pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
                }
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorgreater)]
                // ========================================================================

                // End of code injection

            } else {
                goto Sbk_QByteArray_RichComparison_TypeError;
            }

            break;
        case Py_GE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator>=(const QStringRef & rhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf >=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGREF_IDX], (pyArg)))) {
                // operator>=(const QStringRef & lhs)
                ::QStringRef cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf >=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
                // operator>=(const QByteArray & a2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QByteArray cppArg0_local;
                ::QByteArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if (PyUnicode_Check(pyArg)) {
                // operator>=(PyUnicode arg__1)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorgreaterequal)]
                if (PyUnicode_CheckExact(pyArg)) {
                    Shiboken::AutoDecRef data(PyUnicode_AsASCIIString(pyArg));
                    QByteArray ba = QByteArray(PyBytes_AsString(data.object()), PyBytes_GET_SIZE(data.object()));
                    bool cppResult = cppSelf >= ba;
                    pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
                }
                // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-operatorgreaterequal)]
                // ========================================================================

                // End of code injection

            } else {
                goto Sbk_QByteArray_RichComparison_TypeError;
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QByteArray_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QByteArray_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static Py_hash_t Sbk_QByteArray_HashFunc(PyObject *self) {
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Py_hash_t(qHash(*cppSelf));
}

static int Sbk_QByteArray_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QByteArray_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QByteArray_Type = nullptr;
static SbkObjectType *Sbk_QByteArray_TypeF(void)
{
    return _Sbk_QByteArray_Type;
}

static PyType_Slot Sbk_QByteArray_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QByteArrayFunc___repr__)},
    {Py_tp_hash,        reinterpret_cast<void *>(&Sbk_QByteArray_HashFunc)},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         reinterpret_cast<void *>(Sbk_QByteArrayFunc___str__)},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QByteArray_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QByteArray_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QByteArray_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QByteArray_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QByteArray_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports sequence protocol
    {Py_sq_item, (void *)&Sbk_QByteArrayFunc___getitem__},
    {Py_sq_ass_item, (void *)&Sbk_QByteArrayFunc___setitem__},
    {Py_sq_length, (void *)&Sbk_QByteArrayFunc___len__},
    // type supports mapping protocol
    {Py_mp_subscript, (void *)&Sbk_QByteArrayFunc___mgetitem__},
    {Py_mp_ass_subscript, (void *)&Sbk_QByteArrayFunc___msetitem__},
    {Py_mp_length, (void *)0},
    // type supports number protocol
    {Py_nb_inplace_add, (void *)Sbk_QByteArrayFunc___iadd__},
    {Py_nb_add, (void *)Sbk_QByteArrayFunc___add__},
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QByteArray___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QByteArray___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QByteArray_spec = {
    "2:PySide2.QtCore.QByteArray",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QByteArray_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QByteArray_Base64Option___and__(PyObject *self, PyObject *pyArg)
{
    ::QByteArray::Base64Options cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QByteArray::Base64Options>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QByteArray::Base64Options>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QByteArray::Base64Options>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QByteArray::Base64Options>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QByteArray_Base64Option___or__(PyObject *self, PyObject *pyArg)
{
    ::QByteArray::Base64Options cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QByteArray::Base64Options>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QByteArray::Base64Options>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QByteArray::Base64Options>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QByteArray::Base64Options>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QByteArray_Base64Option___xor__(PyObject *self, PyObject *pyArg)
{
    ::QByteArray::Base64Options cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QByteArray::Base64Options>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QByteArray::Base64Options>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QByteArray::Base64Options>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QByteArray::Base64Options>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QByteArray_Base64Option___invert__(PyObject *self, PyObject *pyArg)
{
    ::QByteArray::Base64Options cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX])->converter, self, &cppSelf);
    ::QByteArray::Base64Options cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QByteArray_Base64Option_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QByteArray_Base64Option__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QByteArray_Base64Option_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QByteArray_Base64Option__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QByteArray_Base64Option__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QByteArray_Base64Option_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QByteArray_Base64Option___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QByteArray_Base64Option___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QByteArray_Base64Option___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QByteArray_Base64Option___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QByteArray_Base64Option_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QByteArray_Base64Option_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QByteArray_Base64Option_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QByteArray_Base64Option_PythonToCpp_QByteArray_Base64Option(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QByteArray::Base64Option *>(cppOut) =
        static_cast<::QByteArray::Base64Option>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QByteArray_Base64Option_PythonToCpp_QByteArray_Base64Option_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX]))
        return QByteArray_Base64Option_PythonToCpp_QByteArray_Base64Option;
    return {};
}
static PyObject *QByteArray_Base64Option_CppToPython_QByteArray_Base64Option(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QByteArray::Base64Option *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX], castCppIn);

}

static void QFlags_QByteArray_Base64Option__PythonToCpp_QFlags_QByteArray_Base64Option_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QByteArray::Base64Option> *>(cppOut) =
        ::QFlags<QByteArray::Base64Option>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QByteArray_Base64Option__PythonToCpp_QFlags_QByteArray_Base64Option__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX]))
        return QFlags_QByteArray_Base64Option__PythonToCpp_QFlags_QByteArray_Base64Option_;
    return {};
}
static PyObject *QFlags_QByteArray_Base64Option__CppToPython_QFlags_QByteArray_Base64Option_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QByteArray::Base64Option> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX]));

}

static void QByteArray_Base64Option_PythonToCpp_QFlags_QByteArray_Base64Option_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QByteArray::Base64Option> *>(cppOut) =
        ::QFlags<QByteArray::Base64Option>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QByteArray_Base64Option_PythonToCpp_QFlags_QByteArray_Base64Option__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX]))
        return QByteArray_Base64Option_PythonToCpp_QFlags_QByteArray_Base64Option_;
    return {};
}
static void number_PythonToCpp_QFlags_QByteArray_Base64Option_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QByteArray::Base64Option> *>(cppOut) =
        ::QFlags<QByteArray::Base64Option>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QByteArray_Base64Option__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX]))
        return number_PythonToCpp_QFlags_QByteArray_Base64Option_;
    return {};
}
static void QByteArray_Base64DecodingStatus_PythonToCpp_QByteArray_Base64DecodingStatus(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QByteArray::Base64DecodingStatus *>(cppOut) =
        static_cast<::QByteArray::Base64DecodingStatus>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QByteArray_Base64DecodingStatus_PythonToCpp_QByteArray_Base64DecodingStatus_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX]))
        return QByteArray_Base64DecodingStatus_PythonToCpp_QByteArray_Base64DecodingStatus;
    return {};
}
static PyObject *QByteArray_Base64DecodingStatus_CppToPython_QByteArray_Base64DecodingStatus(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QByteArray::Base64DecodingStatus *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QByteArray_PythonToCpp_QByteArray_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QByteArray_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QByteArray_PythonToCpp_QByteArray_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QByteArray_TypeF())))
        return QByteArray_PythonToCpp_QByteArray_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QByteArray_PTR_CppToPython_QByteArray(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QByteArray *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QByteArray_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QByteArray_COPY_CppToPython_QByteArray(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QByteArray_TypeF(), new ::QByteArray(*reinterpret_cast<const ::QByteArray *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QByteArray_PythonToCpp_QByteArray_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QByteArray *>(cppOut) = *reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QByteArray_PythonToCpp_QByteArray_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QByteArray_TypeF())))
        return QByteArray_PythonToCpp_QByteArray_COPY;
    return {};
}

// Python to C++ conversions for type 'QByteArray'.
static void Py_None_PythonToCpp_QByteArray(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    *reinterpret_cast<::QByteArray *>(cppOut) = QByteArray();
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    // ========================================================================

}
static PythonToCppFunc is_Py_None_PythonToCpp_QByteArray_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Py_None_PythonToCpp_QByteArray;
    return {};
}
static void PyBytes_PythonToCpp_QByteArray(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qbytearray-pybytes)]
#ifdef IS_PY3K
    *reinterpret_cast<::QByteArray *>(cppOut) = QByteArray(PyBytes_AS_STRING(pyIn), PyBytes_GET_SIZE(pyIn));
#else
    *reinterpret_cast<::QByteArray *>(cppOut) = QByteArray(Shiboken::String::toCString(pyIn), Shiboken::String::len(pyIn));
#endif
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qbytearray-pybytes)]
    // ========================================================================

}
static PythonToCppFunc is_PyBytes_PythonToCpp_QByteArray_Convertible(PyObject *pyIn) {
    if (PyBytes_Check(pyIn))
        return PyBytes_PythonToCpp_QByteArray;
    return {};
}
static void PyByteArray_PythonToCpp_QByteArray(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qbytearray-pybytearray)]
    *reinterpret_cast<::QByteArray *>(cppOut) = QByteArray(PyByteArray_AsString(pyIn), PyByteArray_Size(pyIn));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qbytearray-pybytearray)]
    // ========================================================================

}
static PythonToCppFunc is_PyByteArray_PythonToCpp_QByteArray_Convertible(PyObject *pyIn) {
    if (PyByteArray_Check(pyIn))
        return PyByteArray_PythonToCpp_QByteArray;
    return {};
}
static void PyString_PythonToCpp_QByteArray(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qbytearray-pystring)]
    *reinterpret_cast<::QByteArray *>(cppOut) = QByteArray(Shiboken::String::toCString(pyIn), Shiboken::String::len(pyIn));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qbytearray-pystring)]
    // ========================================================================

}
static PythonToCppFunc is_PyString_PythonToCpp_QByteArray_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn) && !PyUnicode_Check(pyIn))
        return PyString_PythonToCpp_QByteArray;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QByteArray_SignatureStrings[] = {
    "4:PySide2.QtCore.QByteArray(self)",
    "3:PySide2.QtCore.QByteArray(self,arg__1:PyByteArray)",
    "2:PySide2.QtCore.QByteArray(self,arg__1:PyBytes)",
    "1:PySide2.QtCore.QByteArray(self,arg__1:PySide2.QtCore.QByteArray)",
    "0:PySide2.QtCore.QByteArray(self,size:int,c:char)",
    "PySide2.QtCore.QByteArray.__reduce__(self)->PyObject",
    "PySide2.QtCore.QByteArray.__repr__(self)->PyObject",
    "PySide2.QtCore.QByteArray.__str__(self)->PyObject",
    "2:PySide2.QtCore.QByteArray.append(self,c:char)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QByteArray.append(self,a:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.append(self,count:int,c:char)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.at(self,i:int)->char",
    "PySide2.QtCore.QByteArray.back(self)->char",
    "PySide2.QtCore.QByteArray.capacity(self)->int",
    "PySide2.QtCore.QByteArray.cbegin(self)->char*",
    "PySide2.QtCore.QByteArray.cend(self)->char*",
    "PySide2.QtCore.QByteArray.chop(self,n:int)",
    "PySide2.QtCore.QByteArray.chopped(self,len:int)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.clear(self)",
    "1:PySide2.QtCore.QByteArray.compare(self,a:PySide2.QtCore.QByteArray,cs:PySide2.QtCore.Qt.CaseSensitivity=Qt.CaseSensitive)->int",
    "0:PySide2.QtCore.QByteArray.compare(self,c:char*,cs:PySide2.QtCore.Qt.CaseSensitivity=Qt.CaseSensitive)->int",
    "1:PySide2.QtCore.QByteArray.contains(self,c:char)->bool",
    "0:PySide2.QtCore.QByteArray.contains(self,a:PySide2.QtCore.QByteArray)->bool",
    "2:PySide2.QtCore.QByteArray.count(self)->int",
    "1:PySide2.QtCore.QByteArray.count(self,c:char)->int",
    "0:PySide2.QtCore.QByteArray.count(self,a:PySide2.QtCore.QByteArray)->int",
    "1:PySide2.QtCore.QByteArray.data(self)->char*",
    "0:PySide2.QtCore.QByteArray.data(self)->char*",
    "1:PySide2.QtCore.QByteArray.endsWith(self,c:char)->bool",
    "0:PySide2.QtCore.QByteArray.endsWith(self,a:PySide2.QtCore.QByteArray)->bool",
    "PySide2.QtCore.QByteArray.fill(self,c:char,size:int=-1)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QByteArray.fromBase64(base64:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.fromBase64(base64:PySide2.QtCore.QByteArray,options:PySide2.QtCore.QByteArray.Base64Options)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.fromBase64Encoding(base64:PySide2.QtCore.QByteArray,options:PySide2.QtCore.QByteArray.Base64Options=QByteArray.Base64Encoding)->PySide2.QtCore.QByteArray.FromBase64Result",
    "PySide2.QtCore.QByteArray.fromHex(hexEncoded:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.fromPercentEncoding(pctEncoded:PySide2.QtCore.QByteArray,percent:char='%')->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.fromRawData(arg__1:char*,size:int)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.front(self)->char",
    "PySide2.QtCore.QByteArray.indexOf(self,a:PySide2.QtCore.QByteArray,from:int=0)->int",
    "1:PySide2.QtCore.QByteArray.insert(self,i:int,a:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.insert(self,i:int,count:int,c:char)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.isEmpty(self)->bool",
    "PySide2.QtCore.QByteArray.isLower(self)->bool",
    "PySide2.QtCore.QByteArray.isNull(self)->bool",
    "PySide2.QtCore.QByteArray.isSharedWith(self,other:PySide2.QtCore.QByteArray)->bool",
    "PySide2.QtCore.QByteArray.isUpper(self)->bool",
    "PySide2.QtCore.QByteArray.lastIndexOf(self,a:PySide2.QtCore.QByteArray,from:int=-1)->int",
    "PySide2.QtCore.QByteArray.left(self,len:int)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.leftJustified(self,width:int,fill:char=' ',truncate:bool=false)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.length(self)->int",
    "PySide2.QtCore.QByteArray.mid(self,index:int,len:int=-1)->PySide2.QtCore.QByteArray",
    "2:PySide2.QtCore.QByteArray.number(arg__1:double,f:char='g',prec:int=6)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QByteArray.number(arg__1:int,base:int=10)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.number(arg__1:qlonglong,base:int=10)->PySide2.QtCore.QByteArray",
    "2:PySide2.QtCore.QByteArray.prepend(self,c:char)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QByteArray.prepend(self,a:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.prepend(self,count:int,c:char)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.remove(self,index:int,len:int)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.repeated(self,times:int)->PySide2.QtCore.QByteArray",
    "4:PySide2.QtCore.QByteArray.replace(self,before:char,after:char)->PySide2.QtCore.QByteArray",
    "3:PySide2.QtCore.QByteArray.replace(self,before:char,after:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "2:PySide2.QtCore.QByteArray.replace(self,before:PySide2.QtCore.QByteArray,after:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QByteArray.replace(self,before:QString,after:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.replace(self,index:int,len:int,s:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.reserve(self,size:int)",
    "PySide2.QtCore.QByteArray.resize(self,size:int)",
    "PySide2.QtCore.QByteArray.right(self,len:int)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.rightJustified(self,width:int,fill:char=' ',truncate:bool=false)->PySide2.QtCore.QByteArray",
    "2:PySide2.QtCore.QByteArray.setNum(self,arg__1:double,f:char='g',prec:int=6)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QByteArray.setNum(self,arg__1:int,base:int=10)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.setNum(self,arg__1:qlonglong,base:int=10)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.setRawData(self,a:char*,n:uint)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.shrink_to_fit(self)",
    "1:PySide2.QtCore.QByteArray.simplified(self)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.simplified(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.size(self)->int",
    "PySide2.QtCore.QByteArray.split(self,sep:char)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtCore.QByteArray.squeeze(self)",
    "1:PySide2.QtCore.QByteArray.startsWith(self,c:char)->bool",
    "0:PySide2.QtCore.QByteArray.startsWith(self,a:PySide2.QtCore.QByteArray)->bool",
    "PySide2.QtCore.QByteArray.swap(self,other:PySide2.QtCore.QByteArray)",
    "1:PySide2.QtCore.QByteArray.toBase64(self)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.toBase64(self,options:PySide2.QtCore.QByteArray.Base64Options)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.toDouble(self,ok:bool*=nullptr)->double",
    "PySide2.QtCore.QByteArray.toFloat(self,ok:bool*=nullptr)->float",
    "1:PySide2.QtCore.QByteArray.toHex(self)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.toHex(self,separator:char)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.toInt(self,ok:bool*=nullptr,base:int=10)->int",
    "PySide2.QtCore.QByteArray.toLong(self,ok:bool*=nullptr,base:int=10)->long",
    "PySide2.QtCore.QByteArray.toLongLong(self,ok:bool*=nullptr,base:int=10)->qlonglong",
    "1:PySide2.QtCore.QByteArray.toLower(self)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.toLower(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.toPercentEncoding(self,exclude:PySide2.QtCore.QByteArray=QByteArray(),include:PySide2.QtCore.QByteArray=QByteArray(),percent:char='%')->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.toShort(self,ok:bool*=nullptr,base:int=10)->short",
    "PySide2.QtCore.QByteArray.toUInt(self,ok:bool*=nullptr,base:int=10)->uint",
    "PySide2.QtCore.QByteArray.toULong(self,ok:bool*=nullptr,base:int=10)->ulong",
    "PySide2.QtCore.QByteArray.toULongLong(self,ok:bool*=nullptr,base:int=10)->qulonglong",
    "PySide2.QtCore.QByteArray.toUShort(self,ok:bool*=nullptr,base:int=10)->ushort",
    "1:PySide2.QtCore.QByteArray.toUpper(self)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.toUpper(self)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QByteArray.trimmed(self)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.trimmed(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QByteArray.truncate(self,pos:int)",
    "PySide2.QtCore.QByteArray.__copy__()",
    "4:PySide2.QtCore.QByteArray.__add__(self,arg__1:PyByteArray)->PySide2.QtCore.QByteArray",
    "3:PySide2.QtCore.QByteArray.__add__(self,arg__1:PyByteArray)->PySide2.QtCore.QByteArray",
    "2:PySide2.QtCore.QByteArray.__add__(self,arg__1:PyBytes)",
    "1:PySide2.QtCore.QByteArray.__add__(self,a2:char)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.__add__(self,a2:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "2:PySide2.QtCore.QByteArray.__iadd__(self,arg__1:PyByteArray)->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QByteArray.__iadd__(self,c:char)->PySide2.QtCore.QByteArray",
    "0:PySide2.QtCore.QByteArray.__iadd__(self,a:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    nullptr}; // Sentinel

void init_QByteArray(PyObject *module)
{
    _Sbk_QByteArray_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QByteArray",
        "QByteArray",
        &Sbk_QByteArray_spec,
        &Shiboken::callCppDestructor< ::QByteArray >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QByteArray_Type);
    InitSignatureStrings(pyType, QByteArray_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QByteArray_Type), Sbk_QByteArray_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QByteArray_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QByteArray_TypeF(),
        QByteArray_PythonToCpp_QByteArray_PTR,
        is_QByteArray_PythonToCpp_QByteArray_PTR_Convertible,
        QByteArray_PTR_CppToPython_QByteArray,
        QByteArray_COPY_CppToPython_QByteArray);

    Shiboken::Conversions::registerConverterName(converter, "QByteArray");
    Shiboken::Conversions::registerConverterName(converter, "QByteArray*");
    Shiboken::Conversions::registerConverterName(converter, "QByteArray&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QByteArray).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QByteArray_PythonToCpp_QByteArray_COPY,
        is_QByteArray_PythonToCpp_QByteArray_COPY_Convertible);
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Py_None_PythonToCpp_QByteArray,
        is_Py_None_PythonToCpp_QByteArray_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PyBytes_PythonToCpp_QByteArray,
        is_PyBytes_PythonToCpp_QByteArray_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PyByteArray_PythonToCpp_QByteArray,
        is_PyByteArray_PythonToCpp_QByteArray_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PyString_PythonToCpp_QByteArray,
        is_PyString_PythonToCpp_QByteArray_Convertible);


    // Initialization of enums.

    // Initialization of enum 'Base64Option'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QByteArray.Base64Options", SbkPySide2_QtCore_QByteArray_Base64Option_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QByteArray_TypeF(),
        "Base64Option",
        "2:PySide2.QtCore.QByteArray.Base64Option",
        "QByteArray::Base64Option",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX],
        Sbk_QByteArray_TypeF(), "Base64Encoding", (long) QByteArray::Base64Option::Base64Encoding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX],
        Sbk_QByteArray_TypeF(), "Base64UrlEncoding", (long) QByteArray::Base64Option::Base64UrlEncoding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX],
        Sbk_QByteArray_TypeF(), "KeepTrailingEquals", (long) QByteArray::Base64Option::KeepTrailingEquals))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX],
        Sbk_QByteArray_TypeF(), "OmitTrailingEquals", (long) QByteArray::Base64Option::OmitTrailingEquals))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX],
        Sbk_QByteArray_TypeF(), "IgnoreBase64DecodingErrors", (long) QByteArray::Base64Option::IgnoreBase64DecodingErrors))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX],
        Sbk_QByteArray_TypeF(), "AbortOnBase64DecodingErrors", (long) QByteArray::Base64Option::AbortOnBase64DecodingErrors))
        return;
    // Register converter for enum 'QByteArray::Base64Option'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX],
            QByteArray_Base64Option_CppToPython_QByteArray_Base64Option);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QByteArray_Base64Option_PythonToCpp_QByteArray_Base64Option,
            is_QByteArray_Base64Option_PythonToCpp_QByteArray_Base64Option_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64OPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QByteArray::Base64Option");
        Shiboken::Conversions::registerConverterName(converter, "Base64Option");
    }
    // Register converter for flag 'QFlags<QByteArray::Base64Option>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX],
            QFlags_QByteArray_Base64Option__CppToPython_QFlags_QByteArray_Base64Option_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QByteArray_Base64Option_PythonToCpp_QFlags_QByteArray_Base64Option_,
            is_QByteArray_Base64Option_PythonToCpp_QFlags_QByteArray_Base64Option__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QByteArray_Base64Option__PythonToCpp_QFlags_QByteArray_Base64Option_,
            is_QFlags_QByteArray_Base64Option__PythonToCpp_QFlags_QByteArray_Base64Option__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QByteArray_Base64Option_,
            is_number_PythonToCpp_QFlags_QByteArray_Base64Option__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QBYTEARRAY_BASE64OPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QByteArray::Base64Options");
        Shiboken::Conversions::registerConverterName(converter, "Base64Options");
    }
    // End of 'Base64Option' enum/flags.

    // Initialization of enum 'Base64DecodingStatus'.
    SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QByteArray_TypeF(),
        "Base64DecodingStatus",
        "2:PySide2.QtCore.QByteArray.Base64DecodingStatus",
        "QByteArray::Base64DecodingStatus");
    if (!SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX], "Ok", (long) QByteArray::Base64DecodingStatus::Ok))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX], "IllegalInputLength", (long) QByteArray::Base64DecodingStatus::IllegalInputLength))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX], "IllegalCharacter", (long) QByteArray::Base64DecodingStatus::IllegalCharacter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX],
        SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX], "IllegalPadding", (long) QByteArray::Base64DecodingStatus::IllegalPadding))
        return;
    // Register converter for enum 'QByteArray::Base64DecodingStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX],
            QByteArray_Base64DecodingStatus_CppToPython_QByteArray_Base64DecodingStatus);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QByteArray_Base64DecodingStatus_PythonToCpp_QByteArray_Base64DecodingStatus,
            is_QByteArray_Base64DecodingStatus_PythonToCpp_QByteArray_Base64DecodingStatus_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_BASE64DECODINGSTATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QByteArray::Base64DecodingStatus");
        Shiboken::Conversions::registerConverterName(converter, "Base64DecodingStatus");
    }
    // End of 'Base64DecodingStatus' enum.


    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (qbytearray-py3)]
#if PY_VERSION_HEX < 0x03000000
    Shiboken::SbkType<QByteArray>()->tp_as_buffer = &SbkQByteArrayBufferProc;
    Shiboken::SbkType<QByteArray>()->tp_flags |= Py_TPFLAGS_HAVE_NEWBUFFER;
#else
    PepType_AS_BUFFER(Shiboken::SbkType<QByteArray>()) = &SbkQByteArrayBufferProc;
#endif
    // END of custom code block [file: ../glue/qtcore.cpp (qbytearray-py3)]
    // ========================================================================

    // End of code injection

    qRegisterMetaType< ::QByteArray >("QByteArray");
    qRegisterMetaType< ::QByteArray::Base64Option >("QByteArray::Base64Option");
    qRegisterMetaType< ::QByteArray::Base64Options >("QByteArray::Base64Options");
    qRegisterMetaType< ::QByteArray::Base64DecodingStatus >("QByteArray::Base64DecodingStatus");
}

