/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtconcurrent_python.h"

// main header
#include "qfutureqstring_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtCore/qfuture.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFutureQString_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFutureQString >()))
        return -1;

    ::QFutureQString *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QFutureQString", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QFutureQString::QFutureQString()
    // 1: QFutureQString::QFutureQString(QFutureQString)
    if (numArgs == 0) {
        overloadId = 0; // QFutureQString()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QFutureQString(QFutureQString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureQString_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFutureQString()
        {

            if (!PyErr_Occurred()) {
                // QFutureQString()
                cptr = new ::QFutureQString();
            }
            break;
        }
        case 1: // QFutureQString(const QFutureQString & QFutureQString)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFutureQString cppArg0_local;
            ::QFutureQString *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFutureQString(QFutureQString)
                cptr = new ::QFutureQString(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFutureQString >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFutureQString_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QFutureQString_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFutureQStringFunc_cancel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.cancel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cancel()
            cppSelf->cancel();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureQStringFunc_isCanceled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.isCanceled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCanceled()const
            bool cppResult = const_cast<const ::QFutureQString *>(cppSelf)->isCanceled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_isFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.isFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFinished()const
            bool cppResult = const_cast<const ::QFutureQString *>(cppSelf)->isFinished();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_isPaused(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.isPaused";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPaused()const
            bool cppResult = const_cast<const ::QFutureQString *>(cppSelf)->isPaused();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_isResultReadyAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.isResultReadyAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureQString::isResultReadyAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // isResultReadyAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureQStringFunc_isResultReadyAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isResultReadyAt(int)const
            bool cppResult = const_cast<const ::QFutureQString *>(cppSelf)->isResultReadyAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFutureQStringFunc_isResultReadyAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureQStringFunc_isRunning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.isRunning";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRunning()const
            bool cppResult = const_cast<const ::QFutureQString *>(cppSelf)->isRunning();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_isStarted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.isStarted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isStarted()const
            bool cppResult = const_cast<const ::QFutureQString *>(cppSelf)->isStarted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_pause(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.pause";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pause()
            cppSelf->pause();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureQStringFunc_progressMaximum(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.progressMaximum";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressMaximum()const
            int cppResult = const_cast<const ::QFutureQString *>(cppSelf)->progressMaximum();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_progressMinimum(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.progressMinimum";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressMinimum()const
            int cppResult = const_cast<const ::QFutureQString *>(cppSelf)->progressMinimum();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_progressText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.progressText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressText()const
            QString cppResult = const_cast<const ::QFutureQString *>(cppSelf)->progressText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_progressValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.progressValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressValue()const
            int cppResult = const_cast<const ::QFutureQString *>(cppSelf)->progressValue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_result(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.result";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // result()const
            QString cppResult = const_cast<const ::QFutureQString *>(cppSelf)->result();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_resultAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.resultAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureQString::resultAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // resultAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureQStringFunc_resultAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resultAt(int)const
            QString cppResult = const_cast<const ::QFutureQString *>(cppSelf)->resultAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFutureQStringFunc_resultAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureQStringFunc_resultCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.resultCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resultCount()const
            int cppResult = const_cast<const ::QFutureQString *>(cppSelf)->resultCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_results(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.results";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // results()const
            QList<QString > cppResult = const_cast<const ::QFutureQString *>(cppSelf)->results();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtConcurrentTypeConverters[SBK_QTCONCURRENT_QLIST_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureQStringFunc_resume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.resume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resume()
            cppSelf->resume();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureQStringFunc_setPaused(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.setPaused";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureQString::setPaused(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPaused(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureQStringFunc_setPaused_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPaused(bool)
            cppSelf->setPaused(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureQStringFunc_setPaused_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureQStringFunc_togglePaused(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.togglePaused";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // togglePaused()
            cppSelf->togglePaused();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureQStringFunc_waitForFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureQString.waitForFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // waitForFinished()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->waitForFinished();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureQString___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QFutureQString_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFutureQString_methods[] = {
    {"cancel", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_cancel), METH_NOARGS},
    {"isCanceled", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_isCanceled), METH_NOARGS},
    {"isFinished", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_isFinished), METH_NOARGS},
    {"isPaused", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_isPaused), METH_NOARGS},
    {"isResultReadyAt", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_isResultReadyAt), METH_O},
    {"isRunning", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_isRunning), METH_NOARGS},
    {"isStarted", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_isStarted), METH_NOARGS},
    {"pause", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_pause), METH_NOARGS},
    {"progressMaximum", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_progressMaximum), METH_NOARGS},
    {"progressMinimum", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_progressMinimum), METH_NOARGS},
    {"progressText", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_progressText), METH_NOARGS},
    {"progressValue", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_progressValue), METH_NOARGS},
    {"result", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_result), METH_NOARGS},
    {"resultAt", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_resultAt), METH_O},
    {"resultCount", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_resultCount), METH_NOARGS},
    {"results", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_results), METH_NOARGS},
    {"resume", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_resume), METH_NOARGS},
    {"setPaused", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_setPaused), METH_O},
    {"togglePaused", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_togglePaused), METH_NOARGS},
    {"waitForFinished", reinterpret_cast<PyCFunction>(Sbk_QFutureQStringFunc_waitForFinished), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QFutureQString___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QFutureQString_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFUTURE_QSTRING_IDX]), (pyArg)))) {
                // operator!=(const QFuture<QString > & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFuture<QString > cppArg0_local;
                ::QFuture<QString > *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFUTURE_QSTRING_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFUTURE_QSTRING_IDX]), (pyArg)))) {
                // operator==(const QFuture<QString > & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QFuture<QString > cppArg0_local;
                ::QFuture<QString > *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QFUTURE_QSTRING_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QFutureQString_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QFutureQString_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QFutureQString_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFutureQString_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFutureQString_Type = nullptr;
static SbkObjectType *Sbk_QFutureQString_TypeF(void)
{
    return _Sbk_QFutureQString_Type;
}

static PyType_Slot Sbk_QFutureQString_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFutureQString_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFutureQString_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QFutureQString_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFutureQString_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFutureQString_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFutureQString_spec = {
    "2:PySide2.QtConcurrent.QFutureQString",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFutureQString_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFutureQString_PythonToCpp_QFutureQString_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFutureQString_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFutureQString_PythonToCpp_QFutureQString_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFutureQString_TypeF())))
        return QFutureQString_PythonToCpp_QFutureQString_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFutureQString_PTR_CppToPython_QFutureQString(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QFutureQString *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QFutureQString_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QFutureQString_COPY_CppToPython_QFutureQString(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QFutureQString_TypeF(), new ::QFutureQString(*reinterpret_cast<const ::QFutureQString *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QFutureQString_PythonToCpp_QFutureQString_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFutureQString *>(cppOut) = *reinterpret_cast< ::QFutureQString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QFutureQString_PythonToCpp_QFutureQString_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFutureQString_TypeF())))
        return QFutureQString_PythonToCpp_QFutureQString_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFutureQString_SignatureStrings[] = {
    "1:PySide2.QtConcurrent.QFutureQString(self)",
    "0:PySide2.QtConcurrent.QFutureQString(self,QFutureQString:PySide2.QtConcurrent.QFutureQString)",
    "PySide2.QtConcurrent.QFutureQString.cancel(self)",
    "PySide2.QtConcurrent.QFutureQString.isCanceled(self)->bool",
    "PySide2.QtConcurrent.QFutureQString.isFinished(self)->bool",
    "PySide2.QtConcurrent.QFutureQString.isPaused(self)->bool",
    "PySide2.QtConcurrent.QFutureQString.isResultReadyAt(self,resultIndex:int)->bool",
    "PySide2.QtConcurrent.QFutureQString.isRunning(self)->bool",
    "PySide2.QtConcurrent.QFutureQString.isStarted(self)->bool",
    "PySide2.QtConcurrent.QFutureQString.pause(self)",
    "PySide2.QtConcurrent.QFutureQString.progressMaximum(self)->int",
    "PySide2.QtConcurrent.QFutureQString.progressMinimum(self)->int",
    "PySide2.QtConcurrent.QFutureQString.progressText(self)->QString",
    "PySide2.QtConcurrent.QFutureQString.progressValue(self)->int",
    "PySide2.QtConcurrent.QFutureQString.result(self)->QString",
    "PySide2.QtConcurrent.QFutureQString.resultAt(self,index:int)->QString",
    "PySide2.QtConcurrent.QFutureQString.resultCount(self)->int",
    "PySide2.QtConcurrent.QFutureQString.results(self)->QList[QString]",
    "PySide2.QtConcurrent.QFutureQString.resume(self)",
    "PySide2.QtConcurrent.QFutureQString.setPaused(self,paused:bool)",
    "PySide2.QtConcurrent.QFutureQString.togglePaused(self)",
    "PySide2.QtConcurrent.QFutureQString.waitForFinished(self)",
    "PySide2.QtConcurrent.QFutureQString.__copy__()",
    nullptr}; // Sentinel

void init_QFutureQString(PyObject *module)
{
    _Sbk_QFutureQString_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFutureQString",
        "QFutureQString",
        &Sbk_QFutureQString_spec,
        &Shiboken::callCppDestructor< ::QFutureQString >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFutureQString_Type);
    InitSignatureStrings(pyType, QFutureQString_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFutureQString_Type), Sbk_QFutureQString_PropertyStrings);
    SbkPySide2_QtConcurrentTypes[SBK_QFUTUREQSTRING_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFutureQString_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFutureQString_TypeF(),
        QFutureQString_PythonToCpp_QFutureQString_PTR,
        is_QFutureQString_PythonToCpp_QFutureQString_PTR_Convertible,
        QFutureQString_PTR_CppToPython_QFutureQString,
        QFutureQString_COPY_CppToPython_QFutureQString);

    Shiboken::Conversions::registerConverterName(converter, "QFutureQString");
    Shiboken::Conversions::registerConverterName(converter, "QFutureQString*");
    Shiboken::Conversions::registerConverterName(converter, "QFutureQString&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFutureQString).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QFutureQString_PythonToCpp_QFutureQString_COPY,
        is_QFutureQString_PythonToCpp_QFutureQString_COPY_Convertible);

    qRegisterMetaType< ::QFutureQString >("QFutureQString");
}
