/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QPOLARCHARTWRAPPER_H
#define SBK_QPOLARCHARTWRAPPER_H

#define protected public

#include <QtCharts/qpolarchart.h>


// Extra includes
#include <qobject.h>
#include <QtWidgets/qgraphicsitem.h>
#include <QtCharts/qabstractaxis.h>
#include <QtGui/qbrush.h>
#include <QtGui/qpen.h>
#include <QtGui/qevent.h>
#include <QtGui/qpainterpath.h>
#include <qpoint.h>
#include <QtCharts/qabstractseries.h>
#include <qeasingcurve.h>
#include <QtWidgets/qgraphicssceneevent.h>
#include <qrect.h>
#include <qcoreevent.h>
#include <QtGui/qpainter.h>
#include <QtWidgets/qstyleoption.h>
#include <QtWidgets/qwidget.h>
#include <QtGui/qfont.h>
#include <QtCharts/qlegend.h>
#include <qmetaobject.h>
#include <qmargins.h>
#include <qsize.h>
#include <QList>
#include <qlocale.h>
#include <qobjectdefs.h>
namespace PySide { class DynamicQMetaObject; }

class QPolarChartWrapper : public QtCharts::QPolarChart
{
public:
    QPolarChartWrapper(::QGraphicsItem * parent = nullptr, ::QFlags<Qt::WindowType> wFlags = Qt::WindowFlags());
    void advance(int phase) override;
    ::QRectF boundingRect() const override;
    void changeEvent(::QEvent * event) override;
    void childEvent(::QChildEvent * event) override;
    void closeEvent(::QCloseEvent * event) override;
    bool collidesWithItem(const ::QGraphicsItem * other, ::Qt::ItemSelectionMode mode = Qt::IntersectsItemShape) const override;
    bool collidesWithPath(const ::QPainterPath & path, ::Qt::ItemSelectionMode mode = Qt::IntersectsItemShape) const override;
    void connectNotify(const ::QMetaMethod & signal) override;
    bool contains(const ::QPointF & point) const override;
    void contextMenuEvent(::QGraphicsSceneContextMenuEvent * event) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QGraphicsSceneDragDropEvent * event) override;
    void dragLeaveEvent(::QGraphicsSceneDragDropEvent * event) override;
    void dragMoveEvent(::QGraphicsSceneDragDropEvent * event) override;
    void dropEvent(::QGraphicsSceneDragDropEvent * event) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    ::QVariant extension(const ::QVariant & variant) const override;
    void focusInEvent(::QFocusEvent * event) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * event) override;
    void getContentsMargins(qreal * left, qreal * top, qreal * right, qreal * bottom) const override;
    void grabKeyboardEvent(::QEvent * event) override;
    void grabMouseEvent(::QEvent * event) override;
    void hideEvent(::QHideEvent * event) override;
    void hoverEnterEvent(::QGraphicsSceneHoverEvent * event) override;
    void hoverLeaveEvent(::QGraphicsSceneHoverEvent * event) override;
    void hoverMoveEvent(::QGraphicsSceneHoverEvent * event) override;
    void initStyleOption(::QStyleOption * option) const override;
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery query) const override;
    bool isObscuredBy(const ::QGraphicsItem * item) const override;
    ::QVariant itemChange(::QGraphicsItem::GraphicsItemChange change, const ::QVariant & value) override;
    void keyPressEvent(::QKeyEvent * event) override;
    void keyReleaseEvent(::QKeyEvent * event) override;
    const ::QMetaObject * metaObject() const override;
    void mouseDoubleClickEvent(::QGraphicsSceneMouseEvent * event) override;
    void mouseMoveEvent(::QGraphicsSceneMouseEvent * event) override;
    void mousePressEvent(::QGraphicsSceneMouseEvent * event) override;
    void mouseReleaseEvent(::QGraphicsSceneMouseEvent * event) override;
    void moveEvent(::QGraphicsSceneMoveEvent * event) override;
    ::QPainterPath opaqueArea() const override;
    void paint(::QPainter * painter, const ::QStyleOptionGraphicsItem * option, ::QWidget * widget = nullptr) override;
    void paintWindowFrame(::QPainter * painter, const ::QStyleOptionGraphicsItem * option, ::QWidget * widget = nullptr) override;
    void polishEvent() override;
    ::QVariant propertyChange(const ::QString & propertyName, const ::QVariant & value) override;
    void resizeEvent(::QGraphicsSceneResizeEvent * event) override;
    bool sceneEvent(::QEvent * event) override;
    bool sceneEventFilter(::QGraphicsItem * watched, ::QEvent * event) override;
    void setGeometry(const ::QRectF & rect) override;
    ::QPainterPath shape() const override;
    void showEvent(::QShowEvent * event) override;
    ::QSizeF sizeHint(::Qt::SizeHint which, const ::QSizeF & constraint = QSizeF()) const override;
    void timerEvent(::QTimerEvent * event) override;
    int type() const override;
    void ungrabKeyboardEvent(::QEvent * event) override;
    void ungrabMouseEvent(::QEvent * event) override;
    void updateGeometry() override;
    void wheelEvent(::QGraphicsSceneWheelEvent * event) override;
    bool windowFrameEvent(::QEvent * e) override;
    ::Qt::WindowFrameSection windowFrameSectionAt(const ::QPointF & pos) const override;
    ~QPolarChartWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[62];
};

#endif // SBK_QPOLARCHARTWRAPPER_H

