/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcharts_python.h"

// main header
#include "qtcharts_qhcandlestickmodelmapper_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtCharts;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QHCandlestickModelMapperWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QHCandlestickModelMapperWrapper::QHCandlestickModelMapperWrapper(::QObject * parent) : QtCharts::QHCandlestickModelMapper(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QHCandlestickModelMapperWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QHCandlestickModelMapperWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QHCandlestickModelMapperWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QHCandlestickModelMapperWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QHCandlestickModelMapperWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QHCandlestickModelMapper.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QHCandlestickModelMapperWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QHCandlestickModelMapper.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::Qt::Orientation QHCandlestickModelMapperWrapper::orientation() const
{
    if (m_PyMethodCache[7])
        return this->::QtCharts::QHCandlestickModelMapper::orientation();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return static_cast< ::Qt::Orientation>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "orientation";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QtCharts::QHCandlestickModelMapper::orientation();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return static_cast< ::Qt::Orientation>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QHCandlestickModelMapper.orientation", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< Qt::Orientation >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return static_cast< ::Qt::Orientation>(0);
    }
    ::Qt::Orientation cppResult = static_cast< ::Qt::Orientation>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QHCandlestickModelMapperWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QHCandlestickModelMapperWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtCharts::QHCandlestickModelMapper::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QHCandlestickModelMapperWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtCharts::QHCandlestickModelMapper::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QHCandlestickModelMapperWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QHCandlestickModelMapperWrapper *>(this));
        return QtCharts::QHCandlestickModelMapper::qt_metacast(_clname);
}

QHCandlestickModelMapperWrapper::~QHCandlestickModelMapperWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtCharts_QHCandlestickModelMapper_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtCharts::QHCandlestickModelMapper >()))
        return -1;

    ::QHCandlestickModelMapperWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QHCandlestickModelMapper", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QHCandlestickModelMapper::QHCandlestickModelMapper(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QHCandlestickModelMapper(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QHCandlestickModelMapper(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QHCandlestickModelMapper_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QHCandlestickModelMapper_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QtCharts_QHCandlestickModelMapper_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QHCandlestickModelMapper(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QHCandlestickModelMapperWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QHCandlestickModelMapperWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtCharts::QHCandlestickModelMapper >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtCharts_QHCandlestickModelMapper_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QtCharts_QHCandlestickModelMapper_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QtCharts_QHCandlestickModelMapper_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_closeColumn(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.closeColumn";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // closeColumn()const
            int cppResult = const_cast<const ::QtCharts::QHCandlestickModelMapper *>(cppSelf)->closeColumn();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_firstSetRow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.firstSetRow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // firstSetRow()const
            int cppResult = const_cast<const ::QtCharts::QHCandlestickModelMapper *>(cppSelf)->firstSetRow();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_highColumn(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.highColumn";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // highColumn()const
            int cppResult = const_cast<const ::QtCharts::QHCandlestickModelMapper *>(cppSelf)->highColumn();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_lastSetRow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.lastSetRow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastSetRow()const
            int cppResult = const_cast<const ::QtCharts::QHCandlestickModelMapper *>(cppSelf)->lastSetRow();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_lowColumn(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.lowColumn";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lowColumn()const
            int cppResult = const_cast<const ::QtCharts::QHCandlestickModelMapper *>(cppSelf)->lowColumn();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_openColumn(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.openColumn";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // openColumn()const
            int cppResult = const_cast<const ::QtCharts::QHCandlestickModelMapper *>(cppSelf)->openColumn();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_orientation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.orientation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // orientation()const
            Qt::Orientation cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QtCharts::QHCandlestickModelMapper *>(cppSelf)->::QtCharts::QHCandlestickModelMapper::orientation()
                : const_cast<const ::QtCharts::QHCandlestickModelMapper *>(cppSelf)->orientation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_setCloseColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setCloseColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHCandlestickModelMapper::setCloseColumn(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCloseColumn(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QHCandlestickModelMapperFunc_setCloseColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCloseColumn(int)
            cppSelf->setCloseColumn(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QHCandlestickModelMapperFunc_setCloseColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_setFirstSetRow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setFirstSetRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHCandlestickModelMapper::setFirstSetRow(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setFirstSetRow(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QHCandlestickModelMapperFunc_setFirstSetRow_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFirstSetRow(int)
            cppSelf->setFirstSetRow(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QHCandlestickModelMapperFunc_setFirstSetRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_setHighColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setHighColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHCandlestickModelMapper::setHighColumn(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setHighColumn(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QHCandlestickModelMapperFunc_setHighColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHighColumn(int)
            cppSelf->setHighColumn(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QHCandlestickModelMapperFunc_setHighColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_setLastSetRow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setLastSetRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHCandlestickModelMapper::setLastSetRow(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLastSetRow(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QHCandlestickModelMapperFunc_setLastSetRow_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLastSetRow(int)
            cppSelf->setLastSetRow(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QHCandlestickModelMapperFunc_setLastSetRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_setLowColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setLowColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHCandlestickModelMapper::setLowColumn(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLowColumn(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QHCandlestickModelMapperFunc_setLowColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLowColumn(int)
            cppSelf->setLowColumn(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QHCandlestickModelMapperFunc_setLowColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_setOpenColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setOpenColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHCandlestickModelMapper::setOpenColumn(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setOpenColumn(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QHCandlestickModelMapperFunc_setOpenColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOpenColumn(int)
            cppSelf->setOpenColumn(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QHCandlestickModelMapperFunc_setOpenColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_setTimestampColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setTimestampColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHCandlestickModelMapper::setTimestampColumn(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTimestampColumn(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QHCandlestickModelMapperFunc_setTimestampColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTimestampColumn(int)
            cppSelf->setTimestampColumn(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QHCandlestickModelMapperFunc_setTimestampColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QHCandlestickModelMapperFunc_timestampColumn(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.timestampColumn";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timestampColumn()const
            int cppResult = const_cast<const ::QtCharts::QHCandlestickModelMapper *>(cppSelf)->timestampColumn();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtCharts_QHCandlestickModelMapper_PropertyStrings[] = {
    "closeColumn::",
    "firstSetRow::",
    "highColumn::",
    "lastSetRow::",
    "lowColumn::",
    "openColumn::",
    "timestampColumn::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtCharts_QHCandlestickModelMapper_methods[] = {
    {"closeColumn", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_closeColumn), METH_NOARGS},
    {"firstSetRow", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_firstSetRow), METH_NOARGS},
    {"highColumn", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_highColumn), METH_NOARGS},
    {"lastSetRow", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_lastSetRow), METH_NOARGS},
    {"lowColumn", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_lowColumn), METH_NOARGS},
    {"openColumn", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_openColumn), METH_NOARGS},
    {"orientation", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_orientation), METH_NOARGS},
    {"setCloseColumn", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_setCloseColumn), METH_O},
    {"setFirstSetRow", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_setFirstSetRow), METH_O},
    {"setHighColumn", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_setHighColumn), METH_O},
    {"setLastSetRow", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_setLastSetRow), METH_O},
    {"setLowColumn", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_setLowColumn), METH_O},
    {"setOpenColumn", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_setOpenColumn), METH_O},
    {"setTimestampColumn", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_setTimestampColumn), METH_O},
    {"timestampColumn", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QHCandlestickModelMapperFunc_timestampColumn), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtCharts_QHCandlestickModelMapper_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtCharts::QHCandlestickModelMapper *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QHCandlestickModelMapperWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtCharts_QHCandlestickModelMapper_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtCharts_QHCandlestickModelMapper_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtCharts_QHCandlestickModelMapper_Type = nullptr;
static SbkObjectType *Sbk_QtCharts_QHCandlestickModelMapper_TypeF(void)
{
    return _Sbk_QtCharts_QHCandlestickModelMapper_Type;
}

static PyType_Slot Sbk_QtCharts_QHCandlestickModelMapper_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtCharts_QHCandlestickModelMapper_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtCharts_QHCandlestickModelMapper_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtCharts_QHCandlestickModelMapper_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtCharts_QHCandlestickModelMapper_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtCharts_QHCandlestickModelMapper_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtCharts_QHCandlestickModelMapper_spec = {
    "2:PySide2.QtCharts.QtCharts.QHCandlestickModelMapper",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtCharts_QHCandlestickModelMapper_slots
};

} //extern "C"

static void *Sbk_QtCharts_QHCandlestickModelMapper_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtCharts::QHCandlestickModelMapper *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QHCandlestickModelMapper_PythonToCpp_QHCandlestickModelMapper_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtCharts_QHCandlestickModelMapper_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QHCandlestickModelMapper_PythonToCpp_QHCandlestickModelMapper_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QHCandlestickModelMapper_TypeF())))
        return QHCandlestickModelMapper_PythonToCpp_QHCandlestickModelMapper_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QHCandlestickModelMapper_PTR_CppToPython_QHCandlestickModelMapper(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtCharts::QHCandlestickModelMapper *>(const_cast<void *>(cppIn)), Sbk_QtCharts_QHCandlestickModelMapper_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtCharts_QHCandlestickModelMapper_SignatureStrings[] = {
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.closeColumn(self)->int",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.firstSetRow(self)->int",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.highColumn(self)->int",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.lastSetRow(self)->int",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.lowColumn(self)->int",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.openColumn(self)->int",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.orientation(self)->PySide2.QtCore.Qt.Orientation",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setCloseColumn(self,closeColumn:int)",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setFirstSetRow(self,firstSetRow:int)",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setHighColumn(self,highColumn:int)",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setLastSetRow(self,lastSetRow:int)",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setLowColumn(self,lowColumn:int)",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setOpenColumn(self,openColumn:int)",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.setTimestampColumn(self,timestampColumn:int)",
    "PySide2.QtCharts.QtCharts.QHCandlestickModelMapper.timestampColumn(self)->int",
    nullptr}; // Sentinel

void init_QtCharts_QHCandlestickModelMapper(PyObject *enclosingClass)
{
    _Sbk_QtCharts_QHCandlestickModelMapper_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QHCandlestickModelMapper",
        "QtCharts::QHCandlestickModelMapper*",
        &Sbk_QtCharts_QHCandlestickModelMapper_spec,
        &Shiboken::callCppDestructor< ::QtCharts::QHCandlestickModelMapper >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QCANDLESTICKMODELMAPPER_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QHCandlestickModelMapper_Type);
    InitSignatureStrings(pyType, QtCharts_QHCandlestickModelMapper_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QHCandlestickModelMapper_Type), Sbk_QtCharts_QHCandlestickModelMapper_PropertyStrings);
    SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QHCANDLESTICKMODELMAPPER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QHCandlestickModelMapper_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtCharts_QHCandlestickModelMapper_TypeF(),
        QHCandlestickModelMapper_PythonToCpp_QHCandlestickModelMapper_PTR,
        is_QHCandlestickModelMapper_PythonToCpp_QHCandlestickModelMapper_PTR_Convertible,
        QHCandlestickModelMapper_PTR_CppToPython_QHCandlestickModelMapper);

    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QHCandlestickModelMapper");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QHCandlestickModelMapper*");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QHCandlestickModelMapper&");
    Shiboken::Conversions::registerConverterName(converter, "QHCandlestickModelMapper");
    Shiboken::Conversions::registerConverterName(converter, "QHCandlestickModelMapper*");
    Shiboken::Conversions::registerConverterName(converter, "QHCandlestickModelMapper&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtCharts::QHCandlestickModelMapper).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QHCandlestickModelMapperWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtCharts_QHCandlestickModelMapper_TypeF(), &Sbk_QtCharts_QHCandlestickModelMapper_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QtCharts_QHCandlestickModelMapper_TypeF(), &::QtCharts::QHCandlestickModelMapper::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtCharts_QHCandlestickModelMapper_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtCharts_QHCandlestickModelMapper_TypeF(), &::QtCharts::QHCandlestickModelMapper::staticMetaObject, sizeof(QHCandlestickModelMapperWrapper));
}
