/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_wrapper.h"

// inner classes
#include "qt3drender_qtexturedata_wrapper.h"
#include "qt3drender_qtexturewrapmode_wrapper.h"
#include "qt3drender_qtechnique_wrapper.h"
#include "qt3drender_qstenciltestarguments_wrapper.h"
#include "qt3drender_qstenciloperationarguments_wrapper.h"
#include "qt3drender_qshaderprogrambuilder_wrapper.h"
#include "qt3drender_qshaderimage_wrapper.h"
#include "qt3drender_qshaderdata_wrapper.h"
#include "qt3drender_propertyreaderinterface_wrapper.h"
#include "qt3drender_qsceneloader_wrapper.h"
#include "qt3drender_qrendertarget_wrapper.h"
#include "qt3drender_qrendersettings_wrapper.h"
#include "qt3drender_qrenderpass_wrapper.h"
#include "qt3drender_qshaderprogram_wrapper.h"
#include "qt3drender_qrendercapturereply_wrapper.h"
#include "qt3drender_qrendercapabilities_wrapper.h"
#include "qt3drender_qrenderaspect_wrapper.h"
#include "qt3drender_qpickingsettings_wrapper.h"
#include "qt3drender_qpickevent_wrapper.h"
#include "qt3drender_qpicktriangleevent_wrapper.h"
#include "qt3drender_qpickpointevent_wrapper.h"
#include "qt3drender_qpicklineevent_wrapper.h"
#include "qt3drender_qparameter_wrapper.h"
#include "qt3drender_qobjectpicker_wrapper.h"
#include "qt3drender_qmaterial_wrapper.h"
#include "qt3drender_qlevelofdetail_wrapper.h"
#include "qt3drender_qlevelofdetailswitch_wrapper.h"
#include "qt3drender_qlevelofdetailboundingsphere_wrapper.h"
#include "qt3drender_qlayer_wrapper.h"
#include "qt3drender_qgraphicsapifilter_wrapper.h"
#include "qt3drender_qgeometryrenderer_wrapper.h"
#include "qt3drender_qmesh_wrapper.h"
#include "qt3drender_qgeometry_wrapper.h"
#include "qt3drender_qframegraphnodecreatedchangebase_wrapper.h"
#include "qt3drender_qfilterkey_wrapper.h"
#include "qt3drender_qenvironmentlight_wrapper.h"
#include "qt3drender_qeffect_wrapper.h"
#include "qt3drender_qcomputecommand_wrapper.h"
#include "qt3drender_qcamera_wrapper.h"
#include "qt3drender_qcameralens_wrapper.h"
#include "qt3drender_qbuffer_wrapper.h"
#include "qt3drender_qrendertargetoutput_wrapper.h"
#include "qt3drender_qframegraphnode_wrapper.h"
#include "qt3drender_qrendercapture_wrapper.h"
#include "qt3drender_qdispatchcompute_wrapper.h"
#include "qt3drender_qproximityfilter_wrapper.h"
#include "qt3drender_qtechniquefilter_wrapper.h"
#include "qt3drender_qclearbuffers_wrapper.h"
#include "qt3drender_qcameraselector_wrapper.h"
#include "qt3drender_qbuffercapture_wrapper.h"
#include "qt3drender_qnopicking_wrapper.h"
#include "qt3drender_qblitframebuffer_wrapper.h"
#include "qt3drender_qnodraw_wrapper.h"
#include "qt3drender_qsortpolicy_wrapper.h"
#include "qt3drender_qmemorybarrier_wrapper.h"
#include "qt3drender_qsetfence_wrapper.h"
#include "qt3drender_qlayerfilter_wrapper.h"
#include "qt3drender_qwaitfence_wrapper.h"
#include "qt3drender_qrendertargetselector_wrapper.h"
#include "qt3drender_qviewport_wrapper.h"
#include "qt3drender_qrendersurfaceselector_wrapper.h"
#include "qt3drender_qrenderstateset_wrapper.h"
#include "qt3drender_qrenderpassfilter_wrapper.h"
#include "qt3drender_qfrustumculling_wrapper.h"
#include "qt3drender_qattribute_wrapper.h"
#include "qt3drender_qrenderstate_wrapper.h"
#include "qt3drender_qfrontface_wrapper.h"
#include "qt3drender_qdithering_wrapper.h"
#include "qt3drender_qpolygonoffset_wrapper.h"
#include "qt3drender_qdepthtest_wrapper.h"
#include "qt3drender_qpointsize_wrapper.h"
#include "qt3drender_qcullface_wrapper.h"
#include "qt3drender_qcolormask_wrapper.h"
#include "qt3drender_qclipplane_wrapper.h"
#include "qt3drender_qstenciltest_wrapper.h"
#include "qt3drender_qstenciloperation_wrapper.h"
#include "qt3drender_qstencilmask_wrapper.h"
#include "qt3drender_qnodepthmask_wrapper.h"
#include "qt3drender_qmultisampleantialiasing_wrapper.h"
#include "qt3drender_qblendequationarguments_wrapper.h"
#include "qt3drender_qblendequation_wrapper.h"
#include "qt3drender_qlinewidth_wrapper.h"
#include "qt3drender_qalphatest_wrapper.h"
#include "qt3drender_qseamlesscubemap_wrapper.h"
#include "qt3drender_qalphacoverage_wrapper.h"
#include "qt3drender_qscissortest_wrapper.h"
#include "qt3drender_qabstracttextureimage_wrapper.h"
#include "qt3drender_qtextureimage_wrapper.h"
#include "qt3drender_qpaintedtextureimage_wrapper.h"
#include "qt3drender_qabstracttexture_wrapper.h"
#include "qt3drender_qtexture1darray_wrapper.h"
#include "qt3drender_qtexture1d_wrapper.h"
#include "qt3drender_qsharedgltexture_wrapper.h"
#include "qt3drender_qtextureloader_wrapper.h"
#include "qt3drender_qtexturebuffer_wrapper.h"
#include "qt3drender_qtexturerectangle_wrapper.h"
#include "qt3drender_qtexture2dmultisamplearray_wrapper.h"
#include "qt3drender_qtexture2dmultisample_wrapper.h"
#include "qt3drender_qtexturecubemaparray_wrapper.h"
#include "qt3drender_qtexturecubemap_wrapper.h"
#include "qt3drender_qtexture3d_wrapper.h"
#include "qt3drender_qtexture2darray_wrapper.h"
#include "qt3drender_qtexture2d_wrapper.h"
#include "qt3drender_qtextureimagedata_wrapper.h"
#include "qt3drender_qabstractraycaster_wrapper.h"
#include "qt3drender_qraycaster_wrapper.h"
#include "qt3drender_qscreenraycaster_wrapper.h"
#include "qt3drender_qraycasterhit_wrapper.h"
#include "qt3drender_qabstractlight_wrapper.h"
#include "qt3drender_qpointlight_wrapper.h"
#include "qt3drender_qdirectionallight_wrapper.h"
#include "qt3drender_qspotlight_wrapper.h"
#include "qt3drender_qabstractfunctor_wrapper.h"
#include "qt3drender_qtexturegenerator_wrapper.h"
#include "qt3drender_qtextureimagedatagenerator_wrapper.h"
#include "qt3drender_qgeometryfactory_wrapper.h"
#include "qt3drender_qbufferdatagenerator_wrapper.h"

// Extra includes
#include <Qt3DRender/qgraphicsapifilter.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {

static const char *Sbk_Qt3DRender_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_methods[] = {

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Qt3DRender_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_TypeF(void)
{
    return _Sbk_Qt3DRender_Type;
}

static PyType_Slot Sbk_Qt3DRender_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_API_PythonToCpp_Qt3DRender_API(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::API *>(cppOut) =
        static_cast<::Qt3DRender::API>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_API_PythonToCpp_Qt3DRender_API_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX]))
        return Qt3DRender_API_PythonToCpp_Qt3DRender_API;
    return {};
}
static PyObject *Qt3DRender_API_CppToPython_Qt3DRender_API(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::API *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX], castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRenderQt3DRender_SignatureStrings[] = {
    nullptr}; // Sentinel

void init_Qt3DRenderQt3DRender(PyObject *module)
{
    _Sbk_Qt3DRender_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "Qt3DRender",
        "Qt3DRender",
        &Sbk_Qt3DRender_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_Type);
    InitSignatureStrings(pyType, Qt3DRenderQt3DRender_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_Type), Sbk_Qt3DRender_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_Qt3DRenderQT3DRENDER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_TypeF());


    // Initialization of enums.

    // Initialization of enum 'API'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_TypeF(),
        "API",
        "2:PySide2.Qt3DRender.Qt3DRender.API",
        "Qt3DRender::API");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX],
        SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX], "OpenGL", (long) Qt3DRender::API::OpenGL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX],
        SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX], "Vulkan", (long) Qt3DRender::API::Vulkan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX],
        SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX], "DirectX", (long) Qt3DRender::API::DirectX))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX],
        SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX], "Metal", (long) Qt3DRender::API::Metal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX],
        SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX], "Null", (long) Qt3DRender::API::Null))
        return;
    // Register converter for enum 'Qt3DRender::API'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX],
            Qt3DRender_API_CppToPython_Qt3DRender_API);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_API_PythonToCpp_Qt3DRender_API,
            is_Qt3DRender_API_PythonToCpp_Qt3DRender_API_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::API");
        Shiboken::Conversions::registerConverterName(converter, "API");
    }
    // End of 'API' enum.

    qRegisterMetaType< ::Qt3DRender::API >("Qt3DRender::API");
}
