/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qstenciltestarguments_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QStencilTestArgumentsWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QStencilTestArgumentsWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStencilTestArgumentsWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStencilTestArgumentsWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStencilTestArgumentsWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QStencilTestArgumentsWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStencilTestArguments.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QStencilTestArgumentsWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStencilTestArguments.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QStencilTestArgumentsWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QStencilTestArgumentsWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QStencilTestArguments::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QStencilTestArgumentsWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QStencilTestArguments::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QStencilTestArgumentsWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QStencilTestArgumentsWrapper *>(this));
        return Qt3DRender::QStencilTestArguments::qt_metacast(_clname);
}

QStencilTestArgumentsWrapper::~QStencilTestArgumentsWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_Qt3DRender_QStencilTestArgumentsFunc_comparisonMask(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilTestArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.comparisonMask";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // comparisonMask()const
            uint cppResult = const_cast<const ::Qt3DRender::QStencilTestArguments *>(cppSelf)->comparisonMask();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QStencilTestArgumentsFunc_faceMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilTestArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.faceMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // faceMode()const
            Qt3DRender::QStencilTestArguments::StencilFaceMode cppResult = const_cast<const ::Qt3DRender::QStencilTestArguments *>(cppSelf)->faceMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFACEMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QStencilTestArgumentsFunc_referenceValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilTestArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.referenceValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // referenceValue()const
            int cppResult = const_cast<const ::Qt3DRender::QStencilTestArguments *>(cppSelf)->referenceValue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QStencilTestArgumentsFunc_setComparisonMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilTestArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.setComparisonMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStencilTestArguments::setComparisonMask(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // setComparisonMask(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QStencilTestArgumentsFunc_setComparisonMask_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setComparisonMask(uint)
            cppSelf->setComparisonMask(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QStencilTestArgumentsFunc_setComparisonMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QStencilTestArgumentsFunc_setReferenceValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilTestArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.setReferenceValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStencilTestArguments::setReferenceValue(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setReferenceValue(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QStencilTestArgumentsFunc_setReferenceValue_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setReferenceValue(int)
            cppSelf->setReferenceValue(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QStencilTestArgumentsFunc_setReferenceValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QStencilTestArgumentsFunc_setStencilFunction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilTestArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.setStencilFunction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStencilTestArguments::setStencilFunction(Qt3DRender::QStencilTestArguments::StencilFunction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStencilFunction(Qt3DRender::QStencilTestArguments::StencilFunction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QStencilTestArgumentsFunc_setStencilFunction_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QStencilTestArguments::StencilFunction cppArg0 = static_cast< ::Qt3DRender::QStencilTestArguments::StencilFunction>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStencilFunction(Qt3DRender::QStencilTestArguments::StencilFunction)
            cppSelf->setStencilFunction(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QStencilTestArgumentsFunc_setStencilFunction_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QStencilTestArgumentsFunc_stencilFunction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QStencilTestArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.stencilFunction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stencilFunction()const
            Qt3DRender::QStencilTestArguments::StencilFunction cppResult = const_cast<const ::Qt3DRender::QStencilTestArguments *>(cppSelf)->stencilFunction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QStencilTestArguments_PropertyStrings[] = {
    "comparisonMask::",
    "faceMode:",
    "referenceValue::",
    "stencilFunction::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QStencilTestArguments_methods[] = {
    {"comparisonMask", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilTestArgumentsFunc_comparisonMask), METH_NOARGS},
    {"faceMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilTestArgumentsFunc_faceMode), METH_NOARGS},
    {"referenceValue", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilTestArgumentsFunc_referenceValue), METH_NOARGS},
    {"setComparisonMask", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilTestArgumentsFunc_setComparisonMask), METH_O},
    {"setReferenceValue", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilTestArgumentsFunc_setReferenceValue), METH_O},
    {"setStencilFunction", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilTestArgumentsFunc_setStencilFunction), METH_O},
    {"stencilFunction", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QStencilTestArgumentsFunc_stencilFunction), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QStencilTestArguments_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QStencilTestArguments *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QStencilTestArgumentsWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QStencilTestArguments_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QStencilTestArguments_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QStencilTestArguments_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QStencilTestArguments_TypeF(void)
{
    return _Sbk_Qt3DRender_QStencilTestArguments_Type;
}

static PyType_Slot Sbk_Qt3DRender_QStencilTestArguments_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QStencilTestArguments_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QStencilTestArguments_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QStencilTestArguments_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QStencilTestArguments_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QStencilTestArguments_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QStencilTestArguments_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QStencilTestArguments_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QStencilTestArguments *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QStencilTestArguments_StencilFaceMode_PythonToCpp_Qt3DRender_QStencilTestArguments_StencilFaceMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QStencilTestArguments::StencilFaceMode *>(cppOut) =
        static_cast<::Qt3DRender::QStencilTestArguments::StencilFaceMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QStencilTestArguments_StencilFaceMode_PythonToCpp_Qt3DRender_QStencilTestArguments_StencilFaceMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFACEMODE_IDX]))
        return Qt3DRender_QStencilTestArguments_StencilFaceMode_PythonToCpp_Qt3DRender_QStencilTestArguments_StencilFaceMode;
    return {};
}
static PyObject *Qt3DRender_QStencilTestArguments_StencilFaceMode_CppToPython_Qt3DRender_QStencilTestArguments_StencilFaceMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QStencilTestArguments::StencilFaceMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFACEMODE_IDX], castCppIn);

}

static void Qt3DRender_QStencilTestArguments_StencilFunction_PythonToCpp_Qt3DRender_QStencilTestArguments_StencilFunction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QStencilTestArguments::StencilFunction *>(cppOut) =
        static_cast<::Qt3DRender::QStencilTestArguments::StencilFunction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QStencilTestArguments_StencilFunction_PythonToCpp_Qt3DRender_QStencilTestArguments_StencilFunction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX]))
        return Qt3DRender_QStencilTestArguments_StencilFunction_PythonToCpp_Qt3DRender_QStencilTestArguments_StencilFunction;
    return {};
}
static PyObject *Qt3DRender_QStencilTestArguments_StencilFunction_CppToPython_Qt3DRender_QStencilTestArguments_StencilFunction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QStencilTestArguments::StencilFunction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStencilTestArguments_PythonToCpp_QStencilTestArguments_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QStencilTestArguments_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStencilTestArguments_PythonToCpp_QStencilTestArguments_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QStencilTestArguments_TypeF())))
        return QStencilTestArguments_PythonToCpp_QStencilTestArguments_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStencilTestArguments_PTR_CppToPython_QStencilTestArguments(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QStencilTestArguments *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QStencilTestArguments_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QStencilTestArguments_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.comparisonMask(self)->uint",
    "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.faceMode(self)->PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFaceMode",
    "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.referenceValue(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.setComparisonMask(self,comparisonMask:uint)",
    "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.setReferenceValue(self,referenceValue:int)",
    "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.setStencilFunction(self,stencilFunction:PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFunction)",
    "PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.stencilFunction(self)->PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFunction",
    nullptr}; // Sentinel

void init_Qt3DRender_QStencilTestArguments(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QStencilTestArguments_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QStencilTestArguments",
        "Qt3DRender::QStencilTestArguments*",
        &Sbk_Qt3DRender_QStencilTestArguments_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QStencilTestArguments >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QStencilTestArguments_Type);
    InitSignatureStrings(pyType, Qt3DRender_QStencilTestArguments_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QStencilTestArguments_Type), Sbk_Qt3DRender_QStencilTestArguments_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QStencilTestArguments_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QStencilTestArguments_TypeF(),
        QStencilTestArguments_PythonToCpp_QStencilTestArguments_PTR,
        is_QStencilTestArguments_PythonToCpp_QStencilTestArguments_PTR_Convertible,
        QStencilTestArguments_PTR_CppToPython_QStencilTestArguments);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QStencilTestArguments");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QStencilTestArguments*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QStencilTestArguments&");
    Shiboken::Conversions::registerConverterName(converter, "QStencilTestArguments");
    Shiboken::Conversions::registerConverterName(converter, "QStencilTestArguments*");
    Shiboken::Conversions::registerConverterName(converter, "QStencilTestArguments&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QStencilTestArguments).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStencilTestArgumentsWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QStencilTestArguments_TypeF(), &Sbk_Qt3DRender_QStencilTestArguments_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'StencilFaceMode'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFACEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QStencilTestArguments_TypeF(),
        "StencilFaceMode",
        "2:PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFaceMode",
        "Qt3DRender::QStencilTestArguments::StencilFaceMode");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFACEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFACEMODE_IDX],
        Sbk_Qt3DRender_QStencilTestArguments_TypeF(), "Front", (long) Qt3DRender::QStencilTestArguments::StencilFaceMode::Front))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFACEMODE_IDX],
        Sbk_Qt3DRender_QStencilTestArguments_TypeF(), "Back", (long) Qt3DRender::QStencilTestArguments::StencilFaceMode::Back))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFACEMODE_IDX],
        Sbk_Qt3DRender_QStencilTestArguments_TypeF(), "FrontAndBack", (long) Qt3DRender::QStencilTestArguments::StencilFaceMode::FrontAndBack))
        return;
    // Register converter for enum 'Qt3DRender::QStencilTestArguments::StencilFaceMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFACEMODE_IDX],
            Qt3DRender_QStencilTestArguments_StencilFaceMode_CppToPython_Qt3DRender_QStencilTestArguments_StencilFaceMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QStencilTestArguments_StencilFaceMode_PythonToCpp_Qt3DRender_QStencilTestArguments_StencilFaceMode,
            is_Qt3DRender_QStencilTestArguments_StencilFaceMode_PythonToCpp_Qt3DRender_QStencilTestArguments_StencilFaceMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFACEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QStencilTestArguments::StencilFaceMode");
        Shiboken::Conversions::registerConverterName(converter, "QStencilTestArguments::StencilFaceMode");
        Shiboken::Conversions::registerConverterName(converter, "StencilFaceMode");
    }
    // End of 'StencilFaceMode' enum.

    // Initialization of enum 'StencilFunction'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QStencilTestArguments_TypeF(),
        "StencilFunction",
        "2:PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFunction",
        "Qt3DRender::QStencilTestArguments::StencilFunction");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX],
        Sbk_Qt3DRender_QStencilTestArguments_TypeF(), "Never", (long) Qt3DRender::QStencilTestArguments::StencilFunction::Never))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX],
        Sbk_Qt3DRender_QStencilTestArguments_TypeF(), "Always", (long) Qt3DRender::QStencilTestArguments::StencilFunction::Always))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX],
        Sbk_Qt3DRender_QStencilTestArguments_TypeF(), "Less", (long) Qt3DRender::QStencilTestArguments::StencilFunction::Less))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX],
        Sbk_Qt3DRender_QStencilTestArguments_TypeF(), "LessOrEqual", (long) Qt3DRender::QStencilTestArguments::StencilFunction::LessOrEqual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX],
        Sbk_Qt3DRender_QStencilTestArguments_TypeF(), "Equal", (long) Qt3DRender::QStencilTestArguments::StencilFunction::Equal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX],
        Sbk_Qt3DRender_QStencilTestArguments_TypeF(), "GreaterOrEqual", (long) Qt3DRender::QStencilTestArguments::StencilFunction::GreaterOrEqual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX],
        Sbk_Qt3DRender_QStencilTestArguments_TypeF(), "Greater", (long) Qt3DRender::QStencilTestArguments::StencilFunction::Greater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX],
        Sbk_Qt3DRender_QStencilTestArguments_TypeF(), "NotEqual", (long) Qt3DRender::QStencilTestArguments::StencilFunction::NotEqual))
        return;
    // Register converter for enum 'Qt3DRender::QStencilTestArguments::StencilFunction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX],
            Qt3DRender_QStencilTestArguments_StencilFunction_CppToPython_Qt3DRender_QStencilTestArguments_StencilFunction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QStencilTestArguments_StencilFunction_PythonToCpp_Qt3DRender_QStencilTestArguments_StencilFunction,
            is_Qt3DRender_QStencilTestArguments_StencilFunction_PythonToCpp_Qt3DRender_QStencilTestArguments_StencilFunction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSTENCILTESTARGUMENTS_STENCILFUNCTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QStencilTestArguments::StencilFunction");
        Shiboken::Conversions::registerConverterName(converter, "QStencilTestArguments::StencilFunction");
        Shiboken::Conversions::registerConverterName(converter, "StencilFunction");
    }
    // End of 'StencilFunction' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QStencilTestArguments_TypeF(), &::Qt3DRender::QStencilTestArguments::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QStencilTestArguments::StencilFaceMode >("QStencilTestArguments::StencilFaceMode");
    qRegisterMetaType< ::Qt3DRender::QStencilTestArguments::StencilFaceMode >("Qt3DRender::QStencilTestArguments::StencilFaceMode");
    qRegisterMetaType< ::Qt3DRender::QStencilTestArguments::StencilFunction >("QStencilTestArguments::StencilFunction");
    qRegisterMetaType< ::Qt3DRender::QStencilTestArguments::StencilFunction >("Qt3DRender::QStencilTestArguments::StencilFunction");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QStencilTestArguments_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QStencilTestArguments_TypeF(), &::Qt3DRender::QStencilTestArguments::staticMetaObject, sizeof(QStencilTestArgumentsWrapper));
}
