/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qmemorybarrier_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QMemoryBarrierWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QMemoryBarrierWrapper::QMemoryBarrierWrapper(::Qt3DCore::QNode * parent) : Qt3DRender::QMemoryBarrier(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QMemoryBarrierWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMemoryBarrierWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QMemoryBarrierWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMemoryBarrierWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QMemoryBarrierWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMemoryBarrier.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QMemoryBarrierWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMemoryBarrier.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QMemoryBarrierWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QMemoryBarrierWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QMemoryBarrier::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QMemoryBarrierWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QMemoryBarrier::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QMemoryBarrierWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QMemoryBarrierWrapper *>(this));
        return Qt3DRender::QMemoryBarrier::qt_metacast(_clname);
}

QMemoryBarrierWrapper::~QMemoryBarrierWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QMemoryBarrier_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QMemoryBarrier >()))
        return -1;

    ::QMemoryBarrierWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QMemoryBarrier", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QMemoryBarrier::QMemoryBarrier(Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QMemoryBarrier(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QMemoryBarrier(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QMemoryBarrier_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QMemoryBarrier_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DRender_QMemoryBarrier_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNode *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QMemoryBarrier(Qt3DCore::QNode*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QMemoryBarrierWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QMemoryBarrierWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QMemoryBarrier >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QMemoryBarrier_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QMemoryBarrier_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QMemoryBarrier_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QMemoryBarrierFunc_setWaitOperations(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QMemoryBarrier *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.setWaitOperations";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMemoryBarrier::setWaitOperations(QFlags<Qt3DRender::QMemoryBarrier::Operation>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setWaitOperations(QFlags<Qt3DRender::QMemoryBarrier::Operation>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QMemoryBarrierFunc_setWaitOperations_TypeError;

    // Call function/method
    {
        ::QFlags<Qt3DRender::QMemoryBarrier::Operation> cppArg0 = QFlags<Qt3DRender::QMemoryBarrier::Operation>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWaitOperations(QFlags<Qt3DRender::QMemoryBarrier::Operation>)
            cppSelf->setWaitOperations(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QMemoryBarrierFunc_setWaitOperations_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QMemoryBarrierFunc_waitOperations(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QMemoryBarrier *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.waitOperations";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // waitOperations()const
            QFlags<Qt3DRender::QMemoryBarrier::Operation> cppResult = const_cast<const ::Qt3DRender::QMemoryBarrier *>(cppSelf)->waitOperations();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QMemoryBarrier_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QMemoryBarrier_methods[] = {
    {"setWaitOperations", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QMemoryBarrierFunc_setWaitOperations), METH_O},
    {"waitOperations", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QMemoryBarrierFunc_waitOperations), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QMemoryBarrier_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QMemoryBarrier *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QMemoryBarrierWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QMemoryBarrier_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QMemoryBarrier_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QMemoryBarrier_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QMemoryBarrier_TypeF(void)
{
    return _Sbk_Qt3DRender_QMemoryBarrier_Type;
}

static PyType_Slot Sbk_Qt3DRender_QMemoryBarrier_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QMemoryBarrier_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QMemoryBarrier_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QMemoryBarrier_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QMemoryBarrier_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QMemoryBarrier_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QMemoryBarrier_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QMemoryBarrier_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QMemoryBarrier_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QMemoryBarrier *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DRender::QMemoryBarrier::Operations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DRender::QMemoryBarrier::Operations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QMemoryBarrier::Operations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DRender::QMemoryBarrier::Operations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QMemoryBarrier::Operations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DRender::QMemoryBarrier::Operations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DRender::QMemoryBarrier::Operations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QMemoryBarrier::Operations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DRender::QMemoryBarrier::Operations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QMemoryBarrier::Operations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DRender::QMemoryBarrier::Operations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DRender::QMemoryBarrier::Operations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QMemoryBarrier::Operations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DRender::QMemoryBarrier::Operations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DRender::QMemoryBarrier::Operations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DRender::QMemoryBarrier::Operations cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX])->converter, self, &cppSelf);
    ::Qt3DRender::QMemoryBarrier::Operations cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QMemoryBarrier_Operation_PythonToCpp_Qt3DRender_QMemoryBarrier_Operation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QMemoryBarrier::Operation *>(cppOut) =
        static_cast<::Qt3DRender::QMemoryBarrier::Operation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QMemoryBarrier_Operation_PythonToCpp_Qt3DRender_QMemoryBarrier_Operation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX]))
        return Qt3DRender_QMemoryBarrier_Operation_PythonToCpp_Qt3DRender_QMemoryBarrier_Operation;
    return {};
}
static PyObject *Qt3DRender_QMemoryBarrier_Operation_CppToPython_Qt3DRender_QMemoryBarrier_Operation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QMemoryBarrier::Operation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX], castCppIn);

}

static void QFlags_Qt3DRender_QMemoryBarrier_Operation__PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt3DRender::QMemoryBarrier::Operation> *>(cppOut) =
        ::QFlags<Qt3DRender::QMemoryBarrier::Operation>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt3DRender_QMemoryBarrier_Operation__PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX]))
        return QFlags_Qt3DRender_QMemoryBarrier_Operation__PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation_;
    return {};
}
static PyObject *QFlags_Qt3DRender_QMemoryBarrier_Operation__CppToPython_QFlags_Qt3DRender_QMemoryBarrier_Operation_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt3DRender::QMemoryBarrier::Operation> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX]));

}

static void Qt3DRender_QMemoryBarrier_Operation_PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt3DRender::QMemoryBarrier::Operation> *>(cppOut) =
        ::QFlags<Qt3DRender::QMemoryBarrier::Operation>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt3DRender_QMemoryBarrier_Operation_PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX]))
        return Qt3DRender_QMemoryBarrier_Operation_PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt3DRender::QMemoryBarrier::Operation> *>(cppOut) =
        ::QFlags<Qt3DRender::QMemoryBarrier::Operation>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX]))
        return number_PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMemoryBarrier_PythonToCpp_QMemoryBarrier_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QMemoryBarrier_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMemoryBarrier_PythonToCpp_QMemoryBarrier_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QMemoryBarrier_TypeF())))
        return QMemoryBarrier_PythonToCpp_QMemoryBarrier_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMemoryBarrier_PTR_CppToPython_QMemoryBarrier(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QMemoryBarrier *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QMemoryBarrier_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QMemoryBarrier_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.setWaitOperations(self,operations:PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.Operations)",
    "PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.waitOperations(self)->PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.Operations",
    nullptr}; // Sentinel

void init_Qt3DRender_QMemoryBarrier(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QMemoryBarrier_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QMemoryBarrier",
        "Qt3DRender::QMemoryBarrier*",
        &Sbk_Qt3DRender_QMemoryBarrier_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QMemoryBarrier >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QFRAMEGRAPHNODE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QMemoryBarrier_Type);
    InitSignatureStrings(pyType, Qt3DRender_QMemoryBarrier_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QMemoryBarrier_Type), Sbk_Qt3DRender_QMemoryBarrier_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QMemoryBarrier_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QMemoryBarrier_TypeF(),
        QMemoryBarrier_PythonToCpp_QMemoryBarrier_PTR,
        is_QMemoryBarrier_PythonToCpp_QMemoryBarrier_PTR_Convertible,
        QMemoryBarrier_PTR_CppToPython_QMemoryBarrier);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QMemoryBarrier");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QMemoryBarrier*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QMemoryBarrier&");
    Shiboken::Conversions::registerConverterName(converter, "QMemoryBarrier");
    Shiboken::Conversions::registerConverterName(converter, "QMemoryBarrier*");
    Shiboken::Conversions::registerConverterName(converter, "QMemoryBarrier&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QMemoryBarrier).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMemoryBarrierWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QMemoryBarrier_TypeF(), &Sbk_Qt3DRender_QMemoryBarrier_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Operation'.
    SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX] = PySide::QFlags::create("2:PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.Operations", SbkPySide2_Qt3DRender_Qt3DRender_QMemoryBarrier_Operation_number_slots);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QMemoryBarrier_TypeF(),
        "Operation",
        "2:PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.Operation",
        "Qt3DRender::QMemoryBarrier::Operation",
        SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX]);
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "None_", (long) Qt3DRender::QMemoryBarrier::Operation::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "VertexAttributeArray", (long) Qt3DRender::QMemoryBarrier::Operation::VertexAttributeArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "ElementArray", (long) Qt3DRender::QMemoryBarrier::Operation::ElementArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "Uniform", (long) Qt3DRender::QMemoryBarrier::Operation::Uniform))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "TextureFetch", (long) Qt3DRender::QMemoryBarrier::Operation::TextureFetch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "ShaderImageAccess", (long) Qt3DRender::QMemoryBarrier::Operation::ShaderImageAccess))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "Command", (long) Qt3DRender::QMemoryBarrier::Operation::Command))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "PixelBuffer", (long) Qt3DRender::QMemoryBarrier::Operation::PixelBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "TextureUpdate", (long) Qt3DRender::QMemoryBarrier::Operation::TextureUpdate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "BufferUpdate", (long) Qt3DRender::QMemoryBarrier::Operation::BufferUpdate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "FrameBuffer", (long) Qt3DRender::QMemoryBarrier::Operation::FrameBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "TransformFeedback", (long) Qt3DRender::QMemoryBarrier::Operation::TransformFeedback))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "AtomicCounter", (long) Qt3DRender::QMemoryBarrier::Operation::AtomicCounter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "ShaderStorage", (long) Qt3DRender::QMemoryBarrier::Operation::ShaderStorage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "QueryBuffer", (long) Qt3DRender::QMemoryBarrier::Operation::QueryBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
        Sbk_Qt3DRender_QMemoryBarrier_TypeF(), "All", (long) Qt3DRender::QMemoryBarrier::Operation::All))
        return;
    // Register converter for enum 'Qt3DRender::QMemoryBarrier::Operation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
            Qt3DRender_QMemoryBarrier_Operation_CppToPython_Qt3DRender_QMemoryBarrier_Operation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QMemoryBarrier_Operation_PythonToCpp_Qt3DRender_QMemoryBarrier_Operation,
            is_Qt3DRender_QMemoryBarrier_Operation_PythonToCpp_Qt3DRender_QMemoryBarrier_Operation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QMemoryBarrier::Operation");
        Shiboken::Conversions::registerConverterName(converter, "QMemoryBarrier::Operation");
        Shiboken::Conversions::registerConverterName(converter, "Operation");
    }
    // Register converter for flag 'QFlags<Qt3DRender::QMemoryBarrier::Operation>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX],
            QFlags_Qt3DRender_QMemoryBarrier_Operation__CppToPython_QFlags_Qt3DRender_QMemoryBarrier_Operation_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QMemoryBarrier_Operation_PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation_,
            is_Qt3DRender_QMemoryBarrier_Operation_PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt3DRender_QMemoryBarrier_Operation__PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation_,
            is_QFlags_Qt3DRender_QMemoryBarrier_Operation__PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation_,
            is_number_PythonToCpp_QFlags_Qt3DRender_QMemoryBarrier_Operation__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QFLAGS_QT3DRENDER_QMEMORYBARRIER_OPERATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QMemoryBarrier::Operations");
        Shiboken::Conversions::registerConverterName(converter, "QMemoryBarrier::Operations");
        Shiboken::Conversions::registerConverterName(converter, "Operations");
    }
    // End of 'Operation' enum/flags.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QMemoryBarrier_TypeF(), &::Qt3DRender::QMemoryBarrier::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QMemoryBarrier::Operation >("QMemoryBarrier::Operation");
    qRegisterMetaType< ::Qt3DRender::QMemoryBarrier::Operation >("Qt3DRender::QMemoryBarrier::Operation");
    qRegisterMetaType< ::Qt3DRender::QMemoryBarrier::Operations >("Qt3DRender::QMemoryBarrier::Operations");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QMemoryBarrier_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QMemoryBarrier_TypeF(), &::Qt3DRender::QMemoryBarrier::staticMetaObject, sizeof(QMemoryBarrierWrapper));
}
