/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3dextras_python.h"

// main header
#include "qt3dextras_qphongalphamaterial_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DExtras;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QPhongAlphaMaterialWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QPhongAlphaMaterialWrapper::QPhongAlphaMaterialWrapper(::Qt3DCore::QNode * parent) : Qt3DExtras::QPhongAlphaMaterial(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QPhongAlphaMaterialWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPhongAlphaMaterialWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPhongAlphaMaterialWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPhongAlphaMaterialWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QPhongAlphaMaterialWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPhongAlphaMaterial.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QPhongAlphaMaterialWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPhongAlphaMaterial.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QPhongAlphaMaterialWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QPhongAlphaMaterialWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DExtras::QPhongAlphaMaterial::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QPhongAlphaMaterialWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DExtras::QPhongAlphaMaterial::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QPhongAlphaMaterialWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QPhongAlphaMaterialWrapper *>(this));
        return Qt3DExtras::QPhongAlphaMaterial::qt_metacast(_clname);
}

QPhongAlphaMaterialWrapper::~QPhongAlphaMaterialWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DExtras_QPhongAlphaMaterial_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DExtras::QPhongAlphaMaterial >()))
        return -1;

    ::QPhongAlphaMaterialWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QPhongAlphaMaterial", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPhongAlphaMaterial::QPhongAlphaMaterial(Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QPhongAlphaMaterial(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QPhongAlphaMaterial(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QPhongAlphaMaterial_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DExtras_QPhongAlphaMaterial_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DExtras_QPhongAlphaMaterial_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNode *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QPhongAlphaMaterial(Qt3DCore::QNode*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QPhongAlphaMaterialWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QPhongAlphaMaterialWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DExtras::QPhongAlphaMaterial >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DExtras_QPhongAlphaMaterial_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DExtras_QPhongAlphaMaterial_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DExtras_QPhongAlphaMaterial_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_alpha(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.alpha";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alpha()const
            float cppResult = const_cast<const ::Qt3DExtras::QPhongAlphaMaterial *>(cppSelf)->alpha();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_ambient(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.ambient";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ambient()const
            QColor cppResult = const_cast<const ::Qt3DExtras::QPhongAlphaMaterial *>(cppSelf)->ambient();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_blendFunctionArg(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.blendFunctionArg";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blendFunctionArg()const
            Qt3DRender::QBlendEquation::BlendFunction cppResult = const_cast<const ::Qt3DExtras::QPhongAlphaMaterial *>(cppSelf)->blendFunctionArg();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATION_BLENDFUNCTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_destinationAlphaArg(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.destinationAlphaArg";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destinationAlphaArg()const
            Qt3DRender::QBlendEquationArguments::Blending cppResult = const_cast<const ::Qt3DExtras::QPhongAlphaMaterial *>(cppSelf)->destinationAlphaArg();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_destinationRgbArg(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.destinationRgbArg";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destinationRgbArg()const
            Qt3DRender::QBlendEquationArguments::Blending cppResult = const_cast<const ::Qt3DExtras::QPhongAlphaMaterial *>(cppSelf)->destinationRgbArg();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_diffuse(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.diffuse";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // diffuse()const
            QColor cppResult = const_cast<const ::Qt3DExtras::QPhongAlphaMaterial *>(cppSelf)->diffuse();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setAlpha(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setAlpha";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPhongAlphaMaterial::setAlpha(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setAlpha(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setAlpha_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlpha(float)
            cppSelf->setAlpha(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setAlpha_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setAmbient(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setAmbient";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPhongAlphaMaterial::setAmbient(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setAmbient(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setAmbient_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setAmbient(QColor)
            cppSelf->setAmbient(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setAmbient_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setBlendFunctionArg(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setBlendFunctionArg";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPhongAlphaMaterial::setBlendFunctionArg(Qt3DRender::QBlendEquation::BlendFunction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATION_BLENDFUNCTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setBlendFunctionArg(Qt3DRender::QBlendEquation::BlendFunction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setBlendFunctionArg_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlendEquation::BlendFunction cppArg0 = static_cast< ::Qt3DRender::QBlendEquation::BlendFunction>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBlendFunctionArg(Qt3DRender::QBlendEquation::BlendFunction)
            cppSelf->setBlendFunctionArg(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setBlendFunctionArg_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDestinationAlphaArg(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setDestinationAlphaArg";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPhongAlphaMaterial::setDestinationAlphaArg(Qt3DRender::QBlendEquationArguments::Blending)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDestinationAlphaArg(Qt3DRender::QBlendEquationArguments::Blending)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDestinationAlphaArg_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlendEquationArguments::Blending cppArg0{Qt3DRender::QBlendEquationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDestinationAlphaArg(Qt3DRender::QBlendEquationArguments::Blending)
            cppSelf->setDestinationAlphaArg(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDestinationAlphaArg_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDestinationRgbArg(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setDestinationRgbArg";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPhongAlphaMaterial::setDestinationRgbArg(Qt3DRender::QBlendEquationArguments::Blending)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDestinationRgbArg(Qt3DRender::QBlendEquationArguments::Blending)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDestinationRgbArg_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlendEquationArguments::Blending cppArg0{Qt3DRender::QBlendEquationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDestinationRgbArg(Qt3DRender::QBlendEquationArguments::Blending)
            cppSelf->setDestinationRgbArg(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDestinationRgbArg_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDiffuse(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setDiffuse";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPhongAlphaMaterial::setDiffuse(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setDiffuse(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDiffuse_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDiffuse(QColor)
            cppSelf->setDiffuse(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDiffuse_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setShininess(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setShininess";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPhongAlphaMaterial::setShininess(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setShininess(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setShininess_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setShininess(float)
            cppSelf->setShininess(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setShininess_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSourceAlphaArg(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setSourceAlphaArg";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPhongAlphaMaterial::setSourceAlphaArg(Qt3DRender::QBlendEquationArguments::Blending)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSourceAlphaArg(Qt3DRender::QBlendEquationArguments::Blending)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSourceAlphaArg_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlendEquationArguments::Blending cppArg0{Qt3DRender::QBlendEquationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSourceAlphaArg(Qt3DRender::QBlendEquationArguments::Blending)
            cppSelf->setSourceAlphaArg(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSourceAlphaArg_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSourceRgbArg(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setSourceRgbArg";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPhongAlphaMaterial::setSourceRgbArg(Qt3DRender::QBlendEquationArguments::Blending)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSourceRgbArg(Qt3DRender::QBlendEquationArguments::Blending)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSourceRgbArg_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlendEquationArguments::Blending cppArg0{Qt3DRender::QBlendEquationArguments::Zero};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSourceRgbArg(Qt3DRender::QBlendEquationArguments::Blending)
            cppSelf->setSourceRgbArg(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSourceRgbArg_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSpecular(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setSpecular";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPhongAlphaMaterial::setSpecular(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setSpecular(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSpecular_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSpecular(QColor)
            cppSelf->setSpecular(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSpecular_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_shininess(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.shininess";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shininess()const
            float cppResult = const_cast<const ::Qt3DExtras::QPhongAlphaMaterial *>(cppSelf)->shininess();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_sourceAlphaArg(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.sourceAlphaArg";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceAlphaArg()const
            Qt3DRender::QBlendEquationArguments::Blending cppResult = const_cast<const ::Qt3DExtras::QPhongAlphaMaterial *>(cppSelf)->sourceAlphaArg();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_sourceRgbArg(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.sourceRgbArg";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceRgbArg()const
            Qt3DRender::QBlendEquationArguments::Blending cppResult = const_cast<const ::Qt3DExtras::QPhongAlphaMaterial *>(cppSelf)->sourceRgbArg();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLENDEQUATIONARGUMENTS_BLENDING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_specular(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.specular";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // specular()const
            QColor cppResult = const_cast<const ::Qt3DExtras::QPhongAlphaMaterial *>(cppSelf)->specular();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DExtras_QPhongAlphaMaterial_PropertyStrings[] = {
    "alpha::",
    "ambient::",
    "blendFunctionArg::",
    "destinationAlphaArg::",
    "destinationRgbArg::",
    "diffuse::",
    "shininess::",
    "sourceAlphaArg::",
    "sourceRgbArg::",
    "specular::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DExtras_QPhongAlphaMaterial_methods[] = {
    {"alpha", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_alpha), METH_NOARGS},
    {"ambient", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_ambient), METH_NOARGS},
    {"blendFunctionArg", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_blendFunctionArg), METH_NOARGS},
    {"destinationAlphaArg", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_destinationAlphaArg), METH_NOARGS},
    {"destinationRgbArg", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_destinationRgbArg), METH_NOARGS},
    {"diffuse", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_diffuse), METH_NOARGS},
    {"setAlpha", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setAlpha), METH_O},
    {"setAmbient", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setAmbient), METH_O},
    {"setBlendFunctionArg", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setBlendFunctionArg), METH_O},
    {"setDestinationAlphaArg", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDestinationAlphaArg), METH_O},
    {"setDestinationRgbArg", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDestinationRgbArg), METH_O},
    {"setDiffuse", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setDiffuse), METH_O},
    {"setShininess", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setShininess), METH_O},
    {"setSourceAlphaArg", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSourceAlphaArg), METH_O},
    {"setSourceRgbArg", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSourceRgbArg), METH_O},
    {"setSpecular", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_setSpecular), METH_O},
    {"shininess", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_shininess), METH_NOARGS},
    {"sourceAlphaArg", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_sourceAlphaArg), METH_NOARGS},
    {"sourceRgbArg", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_sourceRgbArg), METH_NOARGS},
    {"specular", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QPhongAlphaMaterialFunc_specular), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DExtras_QPhongAlphaMaterial_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QPhongAlphaMaterialWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DExtras_QPhongAlphaMaterial_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DExtras_QPhongAlphaMaterial_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DExtras_QPhongAlphaMaterial_Type = nullptr;
static SbkObjectType *Sbk_Qt3DExtras_QPhongAlphaMaterial_TypeF(void)
{
    return _Sbk_Qt3DExtras_QPhongAlphaMaterial_Type;
}

static PyType_Slot Sbk_Qt3DExtras_QPhongAlphaMaterial_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DExtras_QPhongAlphaMaterial_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DExtras_QPhongAlphaMaterial_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DExtras_QPhongAlphaMaterial_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DExtras_QPhongAlphaMaterial_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DExtras_QPhongAlphaMaterial_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DExtras_QPhongAlphaMaterial_spec = {
    "2:PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DExtras_QPhongAlphaMaterial_slots
};

} //extern "C"

static void *Sbk_Qt3DExtras_QPhongAlphaMaterial_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DExtras::QPhongAlphaMaterial *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPhongAlphaMaterial_PythonToCpp_QPhongAlphaMaterial_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DExtras_QPhongAlphaMaterial_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPhongAlphaMaterial_PythonToCpp_QPhongAlphaMaterial_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DExtras_QPhongAlphaMaterial_TypeF())))
        return QPhongAlphaMaterial_PythonToCpp_QPhongAlphaMaterial_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPhongAlphaMaterial_PTR_CppToPython_QPhongAlphaMaterial(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DExtras::QPhongAlphaMaterial *>(const_cast<void *>(cppIn)), Sbk_Qt3DExtras_QPhongAlphaMaterial_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DExtras_QPhongAlphaMaterial_SignatureStrings[] = {
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.alpha(self)->float",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.ambient(self)->PySide2.QtGui.QColor",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.blendFunctionArg(self)->PySide2.Qt3DRender.Qt3DRender.QBlendEquation.BlendFunction",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.destinationAlphaArg(self)->PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.destinationRgbArg(self)->PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.diffuse(self)->PySide2.QtGui.QColor",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setAlpha(self,alpha:float)",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setAmbient(self,ambient:PySide2.QtGui.QColor)",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setBlendFunctionArg(self,blendFunctionArg:PySide2.Qt3DRender.Qt3DRender.QBlendEquation.BlendFunction)",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setDestinationAlphaArg(self,destinationAlphaArg:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending)",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setDestinationRgbArg(self,destinationRgbArg:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending)",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setDiffuse(self,diffuse:PySide2.QtGui.QColor)",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setShininess(self,shininess:float)",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setSourceAlphaArg(self,sourceAlphaArg:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending)",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setSourceRgbArg(self,sourceRgbArg:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending)",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.setSpecular(self,specular:PySide2.QtGui.QColor)",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.shininess(self)->float",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.sourceAlphaArg(self)->PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.sourceRgbArg(self)->PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending",
    "PySide2.Qt3DExtras.Qt3DExtras.QPhongAlphaMaterial.specular(self)->PySide2.QtGui.QColor",
    nullptr}; // Sentinel

void init_Qt3DExtras_QPhongAlphaMaterial(PyObject *enclosingClass)
{
    _Sbk_Qt3DExtras_QPhongAlphaMaterial_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QPhongAlphaMaterial",
        "Qt3DExtras::QPhongAlphaMaterial*",
        &Sbk_Qt3DExtras_QPhongAlphaMaterial_spec,
        &Shiboken::callCppDestructor< ::Qt3DExtras::QPhongAlphaMaterial >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QMATERIAL_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DExtras_QPhongAlphaMaterial_Type);
    InitSignatureStrings(pyType, Qt3DExtras_QPhongAlphaMaterial_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DExtras_QPhongAlphaMaterial_Type), Sbk_Qt3DExtras_QPhongAlphaMaterial_PropertyStrings);
    SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QPHONGALPHAMATERIAL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DExtras_QPhongAlphaMaterial_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DExtras_QPhongAlphaMaterial_TypeF(),
        QPhongAlphaMaterial_PythonToCpp_QPhongAlphaMaterial_PTR,
        is_QPhongAlphaMaterial_PythonToCpp_QPhongAlphaMaterial_PTR_Convertible,
        QPhongAlphaMaterial_PTR_CppToPython_QPhongAlphaMaterial);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QPhongAlphaMaterial");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QPhongAlphaMaterial*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QPhongAlphaMaterial&");
    Shiboken::Conversions::registerConverterName(converter, "QPhongAlphaMaterial");
    Shiboken::Conversions::registerConverterName(converter, "QPhongAlphaMaterial*");
    Shiboken::Conversions::registerConverterName(converter, "QPhongAlphaMaterial&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DExtras::QPhongAlphaMaterial).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPhongAlphaMaterialWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DExtras_QPhongAlphaMaterial_TypeF(), &Sbk_Qt3DExtras_QPhongAlphaMaterial_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_Qt3DExtras_QPhongAlphaMaterial_TypeF(), &::Qt3DExtras::QPhongAlphaMaterial::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DExtras_QPhongAlphaMaterial_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DExtras_QPhongAlphaMaterial_TypeF(), &::Qt3DExtras::QPhongAlphaMaterial::staticMetaObject, sizeof(QPhongAlphaMaterialWrapper));
}
