/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3dcore_python.h"

// main header
#include "qt3dcore_wrapper.h"

// inner classes
#include "qt3dcore_qbackendnode_wrapper.h"
#include "qt3dcore_qaspectjob_wrapper.h"
#include "qt3dcore_qaspectengine_wrapper.h"
#include "qt3dcore_qnode_wrapper.h"
#include "qt3dcore_qcomponent_wrapper.h"
#include "qt3dcore_qtransform_wrapper.h"
#include "qt3dcore_qarmature_wrapper.h"
#include "qt3dcore_qabstractskeleton_wrapper.h"
#include "qt3dcore_qskeletonloader_wrapper.h"
#include "qt3dcore_qskeleton_wrapper.h"
#include "qt3dcore_qjoint_wrapper.h"
#include "qt3dcore_qentity_wrapper.h"
#include "qt3dcore_qabstractaspect_wrapper.h"
#include "qt3dcore_qscenechange_wrapper.h"
#include "qt3dcore_qpropertyupdatedchangebase_wrapper.h"
#include "qt3dcore_qdynamicpropertyupdatedchange_wrapper.h"
#include "qt3dcore_qstaticpropertyupdatedchangebase_wrapper.h"
#include "qt3dcore_qpropertyupdatedchange_wrapper.h"
#include "qt3dcore_qcomponentremovedchange_wrapper.h"
#include "qt3dcore_qcomponentaddedchange_wrapper.h"
#include "qt3dcore_qpropertyvalueremovedchangebase_wrapper.h"
#include "qt3dcore_qstaticpropertyvalueremovedchangebase_wrapper.h"
#include "qt3dcore_qpropertyvalueremovedchange_wrapper.h"
#include "qt3dcore_qpropertynoderemovedchange_wrapper.h"
#include "qt3dcore_qnodecommand_wrapper.h"
#include "qt3dcore_qpropertyvalueaddedchangebase_wrapper.h"
#include "qt3dcore_qstaticpropertyvalueaddedchangebase_wrapper.h"
#include "qt3dcore_qpropertyvalueaddedchange_wrapper.h"
#include "qt3dcore_qpropertynodeaddedchange_wrapper.h"
#include "qt3dcore_qnodecreatedchangebase_wrapper.h"
#include "qt3dcore_qnodedestroyedchange_wrapper.h"
#include "qt3dcore_qnodeid_wrapper.h"
#include "qt3dcore_qnodeidtypepair_wrapper.h"

// Extra includes
#include <Qt3DCore/qnode.h>
#include <Qt3DCore/qnodeid.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_Qt3DCoreFunc_qHash(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.qHash";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DCoreFunc_qHash_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DCoreFunc_qHash_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:qHash", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static Qt3DCore::qHash(Qt3DCore::QNodeId,uint)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // qHash(Qt3DCore::QNodeId,uint)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[1])))) {
            overloadId = 0; // qHash(Qt3DCore::QNodeId,uint)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCoreFunc_qHash_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_seed = Shiboken::String::createStaticString("seed");
            if (PyDict_Contains(kwds, key_seed)) {
                value = PyDict_GetItem(kwds, key_seed);
                if (value && pyArgs[1]) {
                    errInfo = key_seed;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DCoreFunc_qHash_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[1]))))
                        goto Sbk_Qt3DCoreFunc_qHash_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_seed);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_Qt3DCoreFunc_qHash_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::Qt3DCore::QNodeId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        uint cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // qHash(Qt3DCore::QNodeId,uint)
            uint cppResult = ::Qt3DCore::qHash(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_Qt3DCoreFunc_qHash_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCoreFunc_qIdForNode(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.qIdForNode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Qt3DCore::qIdForNode(Qt3DCore::QNode*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArg)))) {
        overloadId = 0; // qIdForNode(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCoreFunc_qIdForNode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DCore::QNode *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qIdForNode(Qt3DCore::QNode*)
            Qt3DCore::QNodeId cppResult = ::Qt3DCore::qIdForNode(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_Qt3DCoreFunc_qIdForNode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_Qt3DCore_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DCore_methods[] = {
    {"qHash", reinterpret_cast<PyCFunction>(Sbk_Qt3DCoreFunc_qHash), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"qIdForNode", reinterpret_cast<PyCFunction>(Sbk_Qt3DCoreFunc_qIdForNode), METH_O|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Qt3DCore_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DCore_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DCore_Type = nullptr;
static SbkObjectType *Sbk_Qt3DCore_TypeF(void)
{
    return _Sbk_Qt3DCore_Type;
}

static PyType_Slot Sbk_Qt3DCore_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DCore_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DCore_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DCore_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DCore_spec = {
    "2:PySide2.Qt3DCore.Qt3DCore",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DCore_slots
};

} //extern "C"

PyObject *SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DCore::ChangeFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DCore::ChangeFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DCore::ChangeFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DCore::ChangeFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DCore::ChangeFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DCore::ChangeFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DCore::ChangeFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DCore::ChangeFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DCore::ChangeFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DCore::ChangeFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DCore::ChangeFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DCore::ChangeFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DCore::ChangeFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DCore::ChangeFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DCore::ChangeFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DCore::ChangeFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX])->converter, self, &cppSelf);
    ::Qt3DCore::ChangeFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DCore_ChangeFlag_PythonToCpp_Qt3DCore_ChangeFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DCore::ChangeFlag *>(cppOut) =
        static_cast<::Qt3DCore::ChangeFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DCore_ChangeFlag_PythonToCpp_Qt3DCore_ChangeFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX]))
        return Qt3DCore_ChangeFlag_PythonToCpp_Qt3DCore_ChangeFlag;
    return {};
}
static PyObject *Qt3DCore_ChangeFlag_CppToPython_Qt3DCore_ChangeFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DCore::ChangeFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX], castCppIn);

}

static void QFlags_Qt3DCore_ChangeFlag__PythonToCpp_QFlags_Qt3DCore_ChangeFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt3DCore::ChangeFlag> *>(cppOut) =
        ::QFlags<Qt3DCore::ChangeFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt3DCore_ChangeFlag__PythonToCpp_QFlags_Qt3DCore_ChangeFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX]))
        return QFlags_Qt3DCore_ChangeFlag__PythonToCpp_QFlags_Qt3DCore_ChangeFlag_;
    return {};
}
static PyObject *QFlags_Qt3DCore_ChangeFlag__CppToPython_QFlags_Qt3DCore_ChangeFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt3DCore::ChangeFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX]));

}

static void Qt3DCore_ChangeFlag_PythonToCpp_QFlags_Qt3DCore_ChangeFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt3DCore::ChangeFlag> *>(cppOut) =
        ::QFlags<Qt3DCore::ChangeFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt3DCore_ChangeFlag_PythonToCpp_QFlags_Qt3DCore_ChangeFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX]))
        return Qt3DCore_ChangeFlag_PythonToCpp_QFlags_Qt3DCore_ChangeFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt3DCore_ChangeFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt3DCore::ChangeFlag> *>(cppOut) =
        ::QFlags<Qt3DCore::ChangeFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt3DCore_ChangeFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX]))
        return number_PythonToCpp_QFlags_Qt3DCore_ChangeFlag_;
    return {};
}
// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DCoreQt3DCore_SignatureStrings[] = {
    "PySide2.Qt3DCore.Qt3DCore.qHash(id:PySide2.Qt3DCore.Qt3DCore.QNodeId,seed:uint=0)->uint",
    "PySide2.Qt3DCore.Qt3DCore.qIdForNode(node:PySide2.Qt3DCore.Qt3DCore.QNode)->PySide2.Qt3DCore.Qt3DCore.QNodeId",
    nullptr}; // Sentinel

void init_Qt3DCoreQt3DCore(PyObject *module)
{
    _Sbk_Qt3DCore_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "Qt3DCore",
        "Qt3DCore",
        &Sbk_Qt3DCore_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_Type);
    InitSignatureStrings(pyType, Qt3DCoreQt3DCore_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_Type), Sbk_Qt3DCore_PropertyStrings);
    SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_TypeF());


    // Initialization of enums.

    // Initialization of enum 'ChangeFlag'.
    SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX] = PySide::QFlags::create("2:PySide2.Qt3DCore.Qt3DCore.ChangeFlags", SbkPySide2_Qt3DCore_Qt3DCore_ChangeFlag_number_slots);
    SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DCore_TypeF(),
        "ChangeFlag",
        "2:PySide2.Qt3DCore.Qt3DCore.ChangeFlag",
        "Qt3DCore::ChangeFlag",
        SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX]);
    if (!SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX],
        Sbk_Qt3DCore_TypeF(), "NodeCreated", (long) Qt3DCore::ChangeFlag::NodeCreated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX],
        Sbk_Qt3DCore_TypeF(), "NodeDeleted", (long) Qt3DCore::ChangeFlag::NodeDeleted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX],
        Sbk_Qt3DCore_TypeF(), "PropertyUpdated", (long) Qt3DCore::ChangeFlag::PropertyUpdated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX],
        Sbk_Qt3DCore_TypeF(), "PropertyValueAdded", (long) Qt3DCore::ChangeFlag::PropertyValueAdded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX],
        Sbk_Qt3DCore_TypeF(), "PropertyValueRemoved", (long) Qt3DCore::ChangeFlag::PropertyValueRemoved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX],
        Sbk_Qt3DCore_TypeF(), "ComponentAdded", (long) Qt3DCore::ChangeFlag::ComponentAdded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX],
        Sbk_Qt3DCore_TypeF(), "ComponentRemoved", (long) Qt3DCore::ChangeFlag::ComponentRemoved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX],
        Sbk_Qt3DCore_TypeF(), "CommandRequested", (long) Qt3DCore::ChangeFlag::CommandRequested))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX],
        Sbk_Qt3DCore_TypeF(), "CallbackTriggered", (long) Qt3DCore::ChangeFlag::CallbackTriggered))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX],
        Sbk_Qt3DCore_TypeF(), "AllChanges", (long) Qt3DCore::ChangeFlag::AllChanges))
        return;
    // Register converter for enum 'Qt3DCore::ChangeFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX],
            Qt3DCore_ChangeFlag_CppToPython_Qt3DCore_ChangeFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DCore_ChangeFlag_PythonToCpp_Qt3DCore_ChangeFlag,
            is_Qt3DCore_ChangeFlag_PythonToCpp_Qt3DCore_ChangeFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::ChangeFlag");
        Shiboken::Conversions::registerConverterName(converter, "ChangeFlag");
    }
    // Register converter for flag 'QFlags<Qt3DCore::ChangeFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX],
            QFlags_Qt3DCore_ChangeFlag__CppToPython_QFlags_Qt3DCore_ChangeFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DCore_ChangeFlag_PythonToCpp_QFlags_Qt3DCore_ChangeFlag_,
            is_Qt3DCore_ChangeFlag_PythonToCpp_QFlags_Qt3DCore_ChangeFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt3DCore_ChangeFlag__PythonToCpp_QFlags_Qt3DCore_ChangeFlag_,
            is_QFlags_Qt3DCore_ChangeFlag__PythonToCpp_QFlags_Qt3DCore_ChangeFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt3DCore_ChangeFlag_,
            is_number_PythonToCpp_QFlags_Qt3DCore_ChangeFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_CHANGEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::ChangeFlags");
        Shiboken::Conversions::registerConverterName(converter, "ChangeFlags");
    }
    // End of 'ChangeFlag' enum/flags.

    qRegisterMetaType< ::Qt3DCore::ChangeFlag >("Qt3DCore::ChangeFlag");
    qRegisterMetaType< ::Qt3DCore::ChangeFlags >("Qt3DCore::ChangeFlags");
}
