/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3dcore_python.h"

// main header
#include "qt3dcore_qnode_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QNodeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QNodeWrapper::QNodeWrapper(::Qt3DCore::QNode * parent) : Qt3DCore::QNode(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QNodeWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QNodeWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QNodeWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QNodeWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QNodeWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNode.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QNodeWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNode.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QNodeWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QNodeWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DCore::QNode::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QNodeWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DCore::QNode::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QNodeWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QNodeWrapper *>(this));
        return Qt3DCore::QNode::qt_metacast(_clname);
}

QNodeWrapper::~QNodeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DCore_QNode_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DCore::QNode >()))
        return -1;

    ::QNodeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QNode", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QNode::QNode(Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QNode(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QNode(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QNode_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DCore_QNode_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DCore_QNode_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNode *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QNode(Qt3DCore::QNode*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QNodeWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QNodeWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DCore::QNode >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DCore_QNode_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DCore_QNode_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DCore_QNode_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_blockNotifications(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.blockNotifications";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNode::blockNotifications(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // blockNotifications(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QNodeFunc_blockNotifications_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // blockNotifications(bool)
            bool cppResult = cppSelf->blockNotifications(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_Qt3DCore_QNodeFunc_blockNotifications_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_childNodes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.childNodes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // childNodes()const
            QVector<Qt3DCore::QNode* > cppResult = const_cast<const ::Qt3DCore::QNode *>(cppSelf)->childNodes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QNODEPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_clearPropertyTracking(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.clearPropertyTracking";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNode::clearPropertyTracking(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // clearPropertyTracking(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QNodeFunc_clearPropertyTracking_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // clearPropertyTracking(QString)
            cppSelf->clearPropertyTracking(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DCore_QNodeFunc_clearPropertyTracking_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_clearPropertyTrackings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.clearPropertyTrackings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearPropertyTrackings()
            cppSelf->clearPropertyTrackings();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_defaultPropertyTrackingMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.defaultPropertyTrackingMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultPropertyTrackingMode()const
            Qt3DCore::QNode::PropertyTrackingMode cppResult = const_cast<const ::Qt3DCore::QNode *>(cppSelf)->defaultPropertyTrackingMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.id";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // id()const
            Qt3DCore::QNodeId cppResult = const_cast<const ::Qt3DCore::QNode *>(cppSelf)->id();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_isEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.isEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEnabled()const
            bool cppResult = const_cast<const ::Qt3DCore::QNode *>(cppSelf)->isEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_notificationsBlocked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.notificationsBlocked";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // notificationsBlocked()const
            bool cppResult = const_cast<const ::Qt3DCore::QNode *>(cppSelf)->notificationsBlocked();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_parentNode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.parentNode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parentNode()const
            Qt3DCore::QNode * cppResult = const_cast<const ::Qt3DCore::QNode *>(cppSelf)->parentNode();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_propertyTracking(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.propertyTracking";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNode::propertyTracking(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // propertyTracking(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QNodeFunc_propertyTracking_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // propertyTracking(QString)const
            Qt3DCore::QNode::PropertyTrackingMode cppResult = const_cast<const ::Qt3DCore::QNode *>(cppSelf)->propertyTracking(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_Qt3DCore_QNodeFunc_propertyTracking_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_sendCommand(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.sendCommand";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DCore_QNodeFunc_sendCommand_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DCore_QNodeFunc_sendCommand_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:sendCommand", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QNode::sendCommand(QString,QVariant,unsigned long long)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // sendCommand(QString,QVariant,unsigned long long)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // sendCommand(QString,QVariant,unsigned long long)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[2])))) {
                overloadId = 0; // sendCommand(QString,QVariant,unsigned long long)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QNodeFunc_sendCommand_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_data = Shiboken::String::createStaticString("data");
            if (PyDict_Contains(kwds, key_data)) {
                value = PyDict_GetItem(kwds, key_data);
                if (value && pyArgs[1]) {
                    errInfo = key_data;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DCore_QNodeFunc_sendCommand_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1]))))
                        goto Sbk_Qt3DCore_QNodeFunc_sendCommand_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_data);
            }
            static PyObject *const key_replyTo = Shiboken::String::createStaticString("replyTo");
            if (PyDict_Contains(kwds, key_replyTo)) {
                value = PyDict_GetItem(kwds, key_replyTo);
                if (value && pyArgs[2]) {
                    errInfo = key_replyTo;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DCore_QNodeFunc_sendCommand_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[2]))))
                        goto Sbk_Qt3DCore_QNodeFunc_sendCommand_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_replyTo);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_Qt3DCore_QNodeFunc_sendCommand_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1 = QVariant();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned long long cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // sendCommand(QString,QVariant,unsigned long long)
            unsigned long long cppResult = cppSelf->sendCommand(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_Qt3DCore_QNodeFunc_sendCommand_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_setDefaultPropertyTrackingMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.setDefaultPropertyTrackingMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNode::setDefaultPropertyTrackingMode(Qt3DCore::QNode::PropertyTrackingMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDefaultPropertyTrackingMode(Qt3DCore::QNode::PropertyTrackingMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QNodeFunc_setDefaultPropertyTrackingMode_TypeError;

    // Call function/method
    {
        ::Qt3DCore::QNode::PropertyTrackingMode cppArg0{Qt3DCore::QNode::TrackFinalValues};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultPropertyTrackingMode(Qt3DCore::QNode::PropertyTrackingMode)
            cppSelf->setDefaultPropertyTrackingMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DCore_QNodeFunc_setDefaultPropertyTrackingMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_setEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.setEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNode::setEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QNodeFunc_setEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEnabled(bool)
            cppSelf->setEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DCore_QNodeFunc_setEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_setParent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.setParent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNode::setParent(Qt3DCore::QNode*)
    // 1: QObject::setParent(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArg)))) {
        overloadId = 0; // setParent(Qt3DCore::QNode*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 1; // setParent(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QNodeFunc_setParent_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setParent(Qt3DCore::QNode * parent)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::Qt3DCore::QNode *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setParent(Qt3DCore::QNode*)
                cppSelf->setParent(cppArg0);
            }
            break;
        }
        case 1: // setParent(QObject * parent)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QObject *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setParent(QObject*)
                reinterpret_cast<QObject *>(cppSelf)->setParent(cppArg0);
                Shiboken::Object::setParent(pyArg, self);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DCore_QNodeFunc_setParent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCore_QNodeFunc_setPropertyTracking(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNode.setPropertyTracking";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPropertyTracking", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNode::setPropertyTracking(QString,Qt3DCore::QNode::PropertyTrackingMode)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // setPropertyTracking(QString,Qt3DCore::QNode::PropertyTrackingMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QNodeFunc_setPropertyTracking_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt3DCore::QNode::PropertyTrackingMode cppArg1{Qt3DCore::QNode::TrackFinalValues};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setPropertyTracking(QString,Qt3DCore::QNode::PropertyTrackingMode)
            cppSelf->setPropertyTracking(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DCore_QNodeFunc_setPropertyTracking_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_Qt3DCore_QNode_PropertyStrings[] = {
    "defaultPropertyTrackingMode::",
    "enabled:isEnabled:",
    "parent:parentNode:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DCore_QNode_methods[] = {
    {"blockNotifications", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_blockNotifications), METH_O},
    {"childNodes", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_childNodes), METH_NOARGS},
    {"clearPropertyTracking", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_clearPropertyTracking), METH_O},
    {"clearPropertyTrackings", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_clearPropertyTrackings), METH_NOARGS},
    {"defaultPropertyTrackingMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_defaultPropertyTrackingMode), METH_NOARGS},
    {"id", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_id), METH_NOARGS},
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_isEnabled), METH_NOARGS},
    {"notificationsBlocked", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_notificationsBlocked), METH_NOARGS},
    {"parentNode", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_parentNode), METH_NOARGS},
    {"propertyTracking", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_propertyTracking), METH_O},
    {"sendCommand", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_sendCommand), METH_VARARGS|METH_KEYWORDS},
    {"setDefaultPropertyTrackingMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_setDefaultPropertyTrackingMode), METH_O},
    {"setEnabled", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_setEnabled), METH_O},
    {"setParent", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_setParent), METH_O},
    {"setPropertyTracking", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeFunc_setPropertyTracking), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DCore_QNode_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DCore::QNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QNodeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DCore_QNode_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DCore_QNode_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DCore_QNode_Type = nullptr;
static SbkObjectType *Sbk_Qt3DCore_QNode_TypeF(void)
{
    return _Sbk_Qt3DCore_QNode_Type;
}

static PyType_Slot Sbk_Qt3DCore_QNode_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DCore_QNode_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DCore_QNode_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DCore_QNode_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DCore_QNode_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DCore_QNode_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DCore_QNode_spec = {
    "2:PySide2.Qt3DCore.Qt3DCore.QNode",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DCore_QNode_slots
};

} //extern "C"

static void *Sbk_Qt3DCore_QNode_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DCore::QNode *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DCore_QNode_PropertyTrackingMode_PythonToCpp_Qt3DCore_QNode_PropertyTrackingMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DCore::QNode::PropertyTrackingMode *>(cppOut) =
        static_cast<::Qt3DCore::QNode::PropertyTrackingMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DCore_QNode_PropertyTrackingMode_PythonToCpp_Qt3DCore_QNode_PropertyTrackingMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX]))
        return Qt3DCore_QNode_PropertyTrackingMode_PythonToCpp_Qt3DCore_QNode_PropertyTrackingMode;
    return {};
}
static PyObject *Qt3DCore_QNode_PropertyTrackingMode_CppToPython_Qt3DCore_QNode_PropertyTrackingMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DCore::QNode::PropertyTrackingMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNode_PythonToCpp_QNode_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DCore_QNode_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNode_PythonToCpp_QNode_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QNode_TypeF())))
        return QNode_PythonToCpp_QNode_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNode_PTR_CppToPython_QNode(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DCore::QNode *>(const_cast<void *>(cppIn)), Sbk_Qt3DCore_QNode_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DCore_QNode_SignatureStrings[] = {
    "PySide2.Qt3DCore.Qt3DCore.QNode(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DCore.Qt3DCore.QNode.blockNotifications(self,block:bool)->bool",
    "PySide2.Qt3DCore.Qt3DCore.QNode.childNodes(self)->QVector[PySide2.Qt3DCore.Qt3DCore.QNode]",
    "PySide2.Qt3DCore.Qt3DCore.QNode.clearPropertyTracking(self,propertyName:QString)",
    "PySide2.Qt3DCore.Qt3DCore.QNode.clearPropertyTrackings(self)",
    "PySide2.Qt3DCore.Qt3DCore.QNode.defaultPropertyTrackingMode(self)->PySide2.Qt3DCore.Qt3DCore.QNode.PropertyTrackingMode",
    "PySide2.Qt3DCore.Qt3DCore.QNode.id(self)->PySide2.Qt3DCore.Qt3DCore.QNodeId",
    "PySide2.Qt3DCore.Qt3DCore.QNode.isEnabled(self)->bool",
    "PySide2.Qt3DCore.Qt3DCore.QNode.notificationsBlocked(self)->bool",
    "PySide2.Qt3DCore.Qt3DCore.QNode.parentNode(self)->PySide2.Qt3DCore.Qt3DCore.QNode",
    "PySide2.Qt3DCore.Qt3DCore.QNode.propertyTracking(self,propertyName:QString)->PySide2.Qt3DCore.Qt3DCore.QNode.PropertyTrackingMode",
    "PySide2.Qt3DCore.Qt3DCore.QNode.sendCommand(self,name:QString,data:QVariant=QVariant(),replyTo:unsigned long long=0)->unsigned long long",
    "PySide2.Qt3DCore.Qt3DCore.QNode.setDefaultPropertyTrackingMode(self,mode:PySide2.Qt3DCore.Qt3DCore.QNode.PropertyTrackingMode)",
    "PySide2.Qt3DCore.Qt3DCore.QNode.setEnabled(self,isEnabled:bool)",
    "1:PySide2.Qt3DCore.Qt3DCore.QNode.setParent(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode)",
    "0:PySide2.Qt3DCore.Qt3DCore.QNode.setParent(self,parent:PySide2.QtCore.QObject)",
    "PySide2.Qt3DCore.Qt3DCore.QNode.setPropertyTracking(self,propertyName:QString,trackMode:PySide2.Qt3DCore.Qt3DCore.QNode.PropertyTrackingMode)",
    nullptr}; // Sentinel

void init_Qt3DCore_QNode(PyObject *enclosingClass)
{
    _Sbk_Qt3DCore_QNode_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QNode",
        "Qt3DCore::QNode*",
        &Sbk_Qt3DCore_QNode_spec,
        &Shiboken::callCppDestructor< ::Qt3DCore::QNode >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QNode_Type);
    InitSignatureStrings(pyType, Qt3DCore_QNode_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QNode_Type), Sbk_Qt3DCore_QNode_PropertyStrings);
    SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QNode_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DCore_QNode_TypeF(),
        QNode_PythonToCpp_QNode_PTR,
        is_QNode_PythonToCpp_QNode_PTR_Convertible,
        QNode_PTR_CppToPython_QNode);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QNode");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QNode*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QNode&");
    Shiboken::Conversions::registerConverterName(converter, "QNode");
    Shiboken::Conversions::registerConverterName(converter, "QNode*");
    Shiboken::Conversions::registerConverterName(converter, "QNode&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DCore::QNode).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNodeWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DCore_QNode_TypeF(), &Sbk_Qt3DCore_QNode_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'PropertyTrackingMode'.
    SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DCore_QNode_TypeF(),
        "PropertyTrackingMode",
        "2:PySide2.Qt3DCore.Qt3DCore.QNode.PropertyTrackingMode",
        "Qt3DCore::QNode::PropertyTrackingMode");
    if (!SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX],
        Sbk_Qt3DCore_QNode_TypeF(), "TrackFinalValues", (long) Qt3DCore::QNode::PropertyTrackingMode::TrackFinalValues))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX],
        Sbk_Qt3DCore_QNode_TypeF(), "DontTrackValues", (long) Qt3DCore::QNode::PropertyTrackingMode::DontTrackValues))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX],
        Sbk_Qt3DCore_QNode_TypeF(), "TrackAllValues", (long) Qt3DCore::QNode::PropertyTrackingMode::TrackAllValues))
        return;
    // Register converter for enum 'Qt3DCore::QNode::PropertyTrackingMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX],
            Qt3DCore_QNode_PropertyTrackingMode_CppToPython_Qt3DCore_QNode_PropertyTrackingMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DCore_QNode_PropertyTrackingMode_PythonToCpp_Qt3DCore_QNode_PropertyTrackingMode,
            is_Qt3DCore_QNode_PropertyTrackingMode_PythonToCpp_Qt3DCore_QNode_PropertyTrackingMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_PROPERTYTRACKINGMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QNode::PropertyTrackingMode");
        Shiboken::Conversions::registerConverterName(converter, "QNode::PropertyTrackingMode");
        Shiboken::Conversions::registerConverterName(converter, "PropertyTrackingMode");
    }
    // End of 'PropertyTrackingMode' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DCore_QNode_TypeF(), &::Qt3DCore::QNode::staticMetaObject);
    qRegisterMetaType< ::Qt3DCore::QNode::PropertyTrackingMode >("QNode::PropertyTrackingMode");
    qRegisterMetaType< ::Qt3DCore::QNode::PropertyTrackingMode >("Qt3DCore::QNode::PropertyTrackingMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DCore_QNode_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DCore_QNode_TypeF(), &::Qt3DCore::QNode::staticMetaObject, sizeof(QNodeWrapper));
}
