/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3dcore_python.h"

// main header
#include "qt3dcore_qcomponentaddedchange_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QComponentAddedChangeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QComponentAddedChangeWrapper::QComponentAddedChangeWrapper(const ::Qt3DCore::QComponent * component, const ::Qt3DCore::QEntity * entity) : Qt3DCore::QComponentAddedChange(component, entity)
{
    resetPyMethodCache();
    // ... middle
}

QComponentAddedChangeWrapper::QComponentAddedChangeWrapper(const ::Qt3DCore::QEntity * entity, const ::Qt3DCore::QComponent * component) : Qt3DCore::QComponentAddedChange(entity, component)
{
    resetPyMethodCache();
    // ... middle
}

QComponentAddedChangeWrapper::~QComponentAddedChangeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DCore_QComponentAddedChange_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DCore::QComponentAddedChange >()))
        return -1;

    ::QComponentAddedChangeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QComponentAddedChange.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QComponentAddedChange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QComponentAddedChange::QComponentAddedChange(const Qt3DCore::QComponent*,const Qt3DCore::QEntity*)
    // 1: QComponentAddedChange::QComponentAddedChange(const Qt3DCore::QEntity*,const Qt3DCore::QComponent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX]), (pyArgs[1])))) {
        overloadId = 1; // QComponentAddedChange(const Qt3DCore::QEntity*,const Qt3DCore::QComponent*)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), (pyArgs[1])))) {
        overloadId = 0; // QComponentAddedChange(const Qt3DCore::QComponent*,const Qt3DCore::QEntity*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QComponentAddedChange_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QComponentAddedChange(const Qt3DCore::QComponent * component, const Qt3DCore::QEntity * entity)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DCore::QComponent *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::Qt3DCore::QEntity *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QComponentAddedChange(const Qt3DCore::QComponent*,const Qt3DCore::QEntity*)
                cptr = new ::QComponentAddedChangeWrapper(cppArg0, cppArg1);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QComponentAddedChange.QComponentAddedChange(const Qt3DCore::QComponent * component, const Qt3DCore::QEntity * entity) is deprecated", 1);
            break;
        }
        case 1: // QComponentAddedChange(const Qt3DCore::QEntity * entity, const Qt3DCore::QComponent * component)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DCore::QEntity *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::Qt3DCore::QComponent *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QComponentAddedChange(const Qt3DCore::QEntity*,const Qt3DCore::QComponent*)
                cptr = new ::QComponentAddedChangeWrapper(cppArg0, cppArg1);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QComponentAddedChange.QComponentAddedChange(const Qt3DCore::QEntity * entity, const Qt3DCore::QComponent * component) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DCore::QComponentAddedChange >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DCore_QComponentAddedChange_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_Qt3DCore_QComponentAddedChange_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DCore_QComponentAddedChangeFunc_componentId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QComponentAddedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENTADDEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QComponentAddedChange.componentId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // componentId()const
            Qt3DCore::QNodeId cppResult = const_cast<const ::Qt3DCore::QComponentAddedChange *>(cppSelf)->componentId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QComponentAddedChangeFunc_componentMetaObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QComponentAddedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENTADDEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QComponentAddedChange.componentMetaObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // componentMetaObject()const
            const QMetaObject * cppResult = const_cast<const ::Qt3DCore::QComponentAddedChange *>(cppSelf)->componentMetaObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QComponentAddedChangeFunc_entityId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QComponentAddedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENTADDEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QComponentAddedChange.entityId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // entityId()const
            Qt3DCore::QNodeId cppResult = const_cast<const ::Qt3DCore::QComponentAddedChange *>(cppSelf)->entityId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DCore_QComponentAddedChange_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DCore_QComponentAddedChange_methods[] = {
    {"componentId", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QComponentAddedChangeFunc_componentId), METH_NOARGS},
    {"componentMetaObject", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QComponentAddedChangeFunc_componentMetaObject), METH_NOARGS},
    {"entityId", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QComponentAddedChangeFunc_entityId), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DCore_QComponentAddedChange_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DCore::QComponentAddedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENTADDEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QComponentAddedChangeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DCore_QComponentAddedChange_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DCore_QComponentAddedChange_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DCore_QComponentAddedChange_Type = nullptr;
static SbkObjectType *Sbk_Qt3DCore_QComponentAddedChange_TypeF(void)
{
    return _Sbk_Qt3DCore_QComponentAddedChange_Type;
}

static PyType_Slot Sbk_Qt3DCore_QComponentAddedChange_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DCore_QComponentAddedChange_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DCore_QComponentAddedChange_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DCore_QComponentAddedChange_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DCore_QComponentAddedChange_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DCore_QComponentAddedChange_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DCore_QComponentAddedChange_spec = {
    "2:PySide2.Qt3DCore.Qt3DCore.QComponentAddedChange",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DCore_QComponentAddedChange_slots
};

} //extern "C"

static void *Sbk_Qt3DCore_QComponentAddedChange_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::Qt3DCore::QSceneChange >()))
        return dynamic_cast< ::Qt3DCore::QComponentAddedChange *>(reinterpret_cast< ::Qt3DCore::QSceneChange *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QComponentAddedChange_PythonToCpp_QComponentAddedChange_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DCore_QComponentAddedChange_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QComponentAddedChange_PythonToCpp_QComponentAddedChange_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QComponentAddedChange_TypeF())))
        return QComponentAddedChange_PythonToCpp_QComponentAddedChange_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QComponentAddedChange_PTR_CppToPython_QComponentAddedChange(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DCore::QComponentAddedChange *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DCore_QComponentAddedChange_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DCore_QComponentAddedChange_SignatureStrings[] = {
    "1:PySide2.Qt3DCore.Qt3DCore.QComponentAddedChange(self,component:PySide2.Qt3DCore.Qt3DCore.QComponent,entity:PySide2.Qt3DCore.Qt3DCore.QEntity)",
    "0:PySide2.Qt3DCore.Qt3DCore.QComponentAddedChange(self,entity:PySide2.Qt3DCore.Qt3DCore.QEntity,component:PySide2.Qt3DCore.Qt3DCore.QComponent)",
    "PySide2.Qt3DCore.Qt3DCore.QComponentAddedChange.componentId(self)->PySide2.Qt3DCore.Qt3DCore.QNodeId",
    "PySide2.Qt3DCore.Qt3DCore.QComponentAddedChange.componentMetaObject(self)->PySide2.QtCore.QMetaObject",
    "PySide2.Qt3DCore.Qt3DCore.QComponentAddedChange.entityId(self)->PySide2.Qt3DCore.Qt3DCore.QNodeId",
    nullptr}; // Sentinel

void init_Qt3DCore_QComponentAddedChange(PyObject *enclosingClass)
{
    _Sbk_Qt3DCore_QComponentAddedChange_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QComponentAddedChange",
        "Qt3DCore::QComponentAddedChange*",
        &Sbk_Qt3DCore_QComponentAddedChange_spec,
        &Shiboken::callCppDestructor< ::Qt3DCore::QComponentAddedChange >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QComponentAddedChange_Type);
    InitSignatureStrings(pyType, Qt3DCore_QComponentAddedChange_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QComponentAddedChange_Type), Sbk_Qt3DCore_QComponentAddedChange_PropertyStrings);
    SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENTADDEDCHANGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QComponentAddedChange_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DCore_QComponentAddedChange_TypeF(),
        QComponentAddedChange_PythonToCpp_QComponentAddedChange_PTR,
        is_QComponentAddedChange_PythonToCpp_QComponentAddedChange_PTR_Convertible,
        QComponentAddedChange_PTR_CppToPython_QComponentAddedChange);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QComponentAddedChange");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QComponentAddedChange*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QComponentAddedChange&");
    Shiboken::Conversions::registerConverterName(converter, "QComponentAddedChange");
    Shiboken::Conversions::registerConverterName(converter, "QComponentAddedChange*");
    Shiboken::Conversions::registerConverterName(converter, "QComponentAddedChange&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DCore::QComponentAddedChange).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QComponentAddedChangeWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DCore_QComponentAddedChange_TypeF(), &Sbk_Qt3DCore_QComponentAddedChange_typeDiscovery);

}
