/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3danimation_python.h"

// main header
#include "qt3danimation_qmorphinganimation_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DAnimation;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QMorphingAnimationWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QMorphingAnimationWrapper::QMorphingAnimationWrapper(::QObject * parent) : Qt3DAnimation::QMorphingAnimation(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QMorphingAnimationWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMorphingAnimationWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QMorphingAnimationWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMorphingAnimationWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QMorphingAnimationWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMorphingAnimation.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QMorphingAnimationWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMorphingAnimation.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QMorphingAnimationWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QMorphingAnimationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DAnimation::QMorphingAnimation::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QMorphingAnimationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DAnimation::QMorphingAnimation::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QMorphingAnimationWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QMorphingAnimationWrapper *>(this));
        return Qt3DAnimation::QMorphingAnimation::qt_metacast(_clname);
}

QMorphingAnimationWrapper::~QMorphingAnimationWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DAnimation_QMorphingAnimation_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DAnimation::QMorphingAnimation >()))
        return -1;

    ::QMorphingAnimationWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QMorphingAnimation", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QMorphingAnimation::QMorphingAnimation(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QMorphingAnimation(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QMorphingAnimation(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QMorphingAnimation_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DAnimation_QMorphingAnimation_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DAnimation_QMorphingAnimation_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QMorphingAnimation(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QMorphingAnimationWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QMorphingAnimationWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DAnimation::QMorphingAnimation >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DAnimation_QMorphingAnimation_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DAnimation_QMorphingAnimation_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DAnimation_QMorphingAnimation_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_addMorphTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.addMorphTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMorphingAnimation::addMorphTarget(Qt3DAnimation::QMorphTarget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHTARGET_IDX]), (pyArg)))) {
        overloadId = 0; // addMorphTarget(Qt3DAnimation::QMorphTarget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QMorphingAnimationFunc_addMorphTarget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DAnimation::QMorphTarget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addMorphTarget(Qt3DAnimation::QMorphTarget*)
            cppSelf->addMorphTarget(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QMorphingAnimationFunc_addMorphTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_easing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.easing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // easing()const
            QEasingCurve cppResult = const_cast<const ::Qt3DAnimation::QMorphingAnimation *>(cppSelf)->easing();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_getWeights(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.getWeights";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMorphingAnimation::getWeights(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // getWeights(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QMorphingAnimationFunc_getWeights_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // getWeights(int)
            QVector<float > cppResult = cppSelf->getWeights(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_FLOAT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_Qt3DAnimation_QMorphingAnimationFunc_getWeights_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_interpolator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.interpolator";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // interpolator()const
            float cppResult = const_cast<const ::Qt3DAnimation::QMorphingAnimation *>(cppSelf)->interpolator();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_method(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.method";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // method()const
            Qt3DAnimation::QMorphingAnimation::Method cppResult = const_cast<const ::Qt3DAnimation::QMorphingAnimation *>(cppSelf)->method();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_METHOD_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_morphTargetList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.morphTargetList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // morphTargetList()
            QVector<Qt3DAnimation::QMorphTarget* > cppResult = cppSelf->morphTargetList();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DANIMATION_QMORPHTARGETPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_removeMorphTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.removeMorphTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMorphingAnimation::removeMorphTarget(Qt3DAnimation::QMorphTarget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHTARGET_IDX]), (pyArg)))) {
        overloadId = 0; // removeMorphTarget(Qt3DAnimation::QMorphTarget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QMorphingAnimationFunc_removeMorphTarget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DAnimation::QMorphTarget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeMorphTarget(Qt3DAnimation::QMorphTarget*)
            cppSelf->removeMorphTarget(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QMorphingAnimationFunc_removeMorphTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_setEasing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setEasing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMorphingAnimation::setEasing(QEasingCurve)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), (pyArg)))) {
        overloadId = 0; // setEasing(QEasingCurve)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QMorphingAnimationFunc_setEasing_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEasingCurve cppArg0_local;
        ::QEasingCurve *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setEasing(QEasingCurve)
            cppSelf->setEasing(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QMorphingAnimationFunc_setEasing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_setMethod(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setMethod";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMorphingAnimation::setMethod(Qt3DAnimation::QMorphingAnimation::Method)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_METHOD_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMethod(Qt3DAnimation::QMorphingAnimation::Method)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QMorphingAnimationFunc_setMethod_TypeError;

    // Call function/method
    {
        ::Qt3DAnimation::QMorphingAnimation::Method cppArg0{Qt3DAnimation::QMorphingAnimation::Normalized};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMethod(Qt3DAnimation::QMorphingAnimation::Method)
            cppSelf->setMethod(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QMorphingAnimationFunc_setMethod_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_setMorphTargets(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setMorphTargets";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMorphingAnimation::setMorphTargets(QVector<Qt3DAnimation::QMorphTarget*>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DANIMATION_QMORPHTARGETPTR_IDX], (pyArg)))) {
        overloadId = 0; // setMorphTargets(QVector<Qt3DAnimation::QMorphTarget*>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QMorphingAnimationFunc_setMorphTargets_TypeError;

    // Call function/method
    {
        ::QVector<Qt3DAnimation::QMorphTarget* > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMorphTargets(QVector<Qt3DAnimation::QMorphTarget*>)
            cppSelf->setMorphTargets(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QMorphingAnimationFunc_setMorphTargets_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMorphingAnimation::setTarget(Qt3DRender::QGeometryRenderer*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGEOMETRYRENDERER_IDX]), (pyArg)))) {
        overloadId = 0; // setTarget(Qt3DRender::QGeometryRenderer*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTarget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DRender::QGeometryRenderer *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTarget(Qt3DRender::QGeometryRenderer*)
            cppSelf->setTarget(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTargetName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setTargetName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMorphingAnimation::setTargetName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setTargetName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTargetName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTargetName(QString)
            cppSelf->setTargetName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTargetName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTargetPositions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setTargetPositions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMorphingAnimation::setTargetPositions(QVector<float>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_FLOAT_IDX], (pyArg)))) {
        overloadId = 0; // setTargetPositions(QVector<float>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTargetPositions_TypeError;

    // Call function/method
    {
        ::QVector<float > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTargetPositions(QVector<float>)
            cppSelf->setTargetPositions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTargetPositions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_setWeights(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setWeights";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setWeights", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMorphingAnimation::setWeights(int,QVector<float>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_FLOAT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setWeights(int,QVector<float>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QMorphingAnimationFunc_setWeights_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVector<float > cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setWeights(int,QVector<float>)
            cppSelf->setWeights(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QMorphingAnimationFunc_setWeights_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_target(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.target";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // target()const
            Qt3DRender::QGeometryRenderer * cppResult = const_cast<const ::Qt3DAnimation::QMorphingAnimation *>(cppSelf)->target();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGEOMETRYRENDERER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_targetName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.targetName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // targetName()const
            QString cppResult = const_cast<const ::Qt3DAnimation::QMorphingAnimation *>(cppSelf)->targetName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QMorphingAnimationFunc_targetPositions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.targetPositions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // targetPositions()const
            QVector<float > cppResult = const_cast<const ::Qt3DAnimation::QMorphingAnimation *>(cppSelf)->targetPositions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_FLOAT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DAnimation_QMorphingAnimation_PropertyStrings[] = {
    "easing::",
    "interpolator:",
    "method::",
    "target::",
    "targetName::",
    "targetPositions::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DAnimation_QMorphingAnimation_methods[] = {
    {"addMorphTarget", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_addMorphTarget), METH_O},
    {"easing", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_easing), METH_NOARGS},
    {"getWeights", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_getWeights), METH_O},
    {"interpolator", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_interpolator), METH_NOARGS},
    {"method", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_method), METH_NOARGS},
    {"morphTargetList", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_morphTargetList), METH_NOARGS},
    {"removeMorphTarget", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_removeMorphTarget), METH_O},
    {"setEasing", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_setEasing), METH_O},
    {"setMethod", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_setMethod), METH_O},
    {"setMorphTargets", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_setMorphTargets), METH_O},
    {"setTarget", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTarget), METH_O},
    {"setTargetName", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTargetName), METH_O},
    {"setTargetPositions", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_setTargetPositions), METH_O},
    {"setWeights", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_setWeights), METH_VARARGS},
    {"target", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_target), METH_NOARGS},
    {"targetName", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_targetName), METH_NOARGS},
    {"targetPositions", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QMorphingAnimationFunc_targetPositions), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DAnimation_QMorphingAnimation_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DAnimation::QMorphingAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QMorphingAnimationWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DAnimation_QMorphingAnimation_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DAnimation_QMorphingAnimation_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DAnimation_QMorphingAnimation_Type = nullptr;
static SbkObjectType *Sbk_Qt3DAnimation_QMorphingAnimation_TypeF(void)
{
    return _Sbk_Qt3DAnimation_QMorphingAnimation_Type;
}

static PyType_Slot Sbk_Qt3DAnimation_QMorphingAnimation_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DAnimation_QMorphingAnimation_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DAnimation_QMorphingAnimation_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DAnimation_QMorphingAnimation_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DAnimation_QMorphingAnimation_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DAnimation_QMorphingAnimation_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DAnimation_QMorphingAnimation_spec = {
    "2:PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DAnimation_QMorphingAnimation_slots
};

} //extern "C"

static void *Sbk_Qt3DAnimation_QMorphingAnimation_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DAnimation::QMorphingAnimation *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DAnimation_QMorphingAnimation_Method_PythonToCpp_Qt3DAnimation_QMorphingAnimation_Method(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DAnimation::QMorphingAnimation::Method *>(cppOut) =
        static_cast<::Qt3DAnimation::QMorphingAnimation::Method>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DAnimation_QMorphingAnimation_Method_PythonToCpp_Qt3DAnimation_QMorphingAnimation_Method_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_METHOD_IDX]))
        return Qt3DAnimation_QMorphingAnimation_Method_PythonToCpp_Qt3DAnimation_QMorphingAnimation_Method;
    return {};
}
static PyObject *Qt3DAnimation_QMorphingAnimation_Method_CppToPython_Qt3DAnimation_QMorphingAnimation_Method(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DAnimation::QMorphingAnimation::Method *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_METHOD_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMorphingAnimation_PythonToCpp_QMorphingAnimation_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DAnimation_QMorphingAnimation_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMorphingAnimation_PythonToCpp_QMorphingAnimation_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DAnimation_QMorphingAnimation_TypeF())))
        return QMorphingAnimation_PythonToCpp_QMorphingAnimation_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMorphingAnimation_PTR_CppToPython_QMorphingAnimation(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DAnimation::QMorphingAnimation *>(const_cast<void *>(cppIn)), Sbk_Qt3DAnimation_QMorphingAnimation_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DAnimation_QMorphingAnimation_SignatureStrings[] = {
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.addMorphTarget(self,target:PySide2.Qt3DAnimation.Qt3DAnimation.QMorphTarget)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.easing(self)->PySide2.QtCore.QEasingCurve",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.getWeights(self,positionIndex:int)->QVector[float]",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.interpolator(self)->float",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.method(self)->PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.Method",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.morphTargetList(self)->QVector[PySide2.Qt3DAnimation.Qt3DAnimation.QMorphTarget]",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.removeMorphTarget(self,target:PySide2.Qt3DAnimation.Qt3DAnimation.QMorphTarget)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setEasing(self,easing:PySide2.QtCore.QEasingCurve)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setMethod(self,method:PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.Method)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setMorphTargets(self,targets:QVector[PySide2.Qt3DAnimation.Qt3DAnimation.QMorphTarget])",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setTarget(self,target:PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setTargetName(self,name:QString)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setTargetPositions(self,targetPositions:QVector[float])",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.setWeights(self,positionIndex:int,weights:QVector[float])",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.target(self)->PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.targetName(self)->QString",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.targetPositions(self)->QVector[float]",
    nullptr}; // Sentinel

void init_Qt3DAnimation_QMorphingAnimation(PyObject *enclosingClass)
{
    _Sbk_Qt3DAnimation_QMorphingAnimation_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QMorphingAnimation",
        "Qt3DAnimation::QMorphingAnimation*",
        &Sbk_Qt3DAnimation_QMorphingAnimation_spec,
        &Shiboken::callCppDestructor< ::Qt3DAnimation::QMorphingAnimation >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QABSTRACTANIMATION_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DAnimation_QMorphingAnimation_Type);
    InitSignatureStrings(pyType, Qt3DAnimation_QMorphingAnimation_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DAnimation_QMorphingAnimation_Type), Sbk_Qt3DAnimation_QMorphingAnimation_PropertyStrings);
    SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DAnimation_QMorphingAnimation_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DAnimation_QMorphingAnimation_TypeF(),
        QMorphingAnimation_PythonToCpp_QMorphingAnimation_PTR,
        is_QMorphingAnimation_PythonToCpp_QMorphingAnimation_PTR_Convertible,
        QMorphingAnimation_PTR_CppToPython_QMorphingAnimation);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QMorphingAnimation");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QMorphingAnimation*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QMorphingAnimation&");
    Shiboken::Conversions::registerConverterName(converter, "QMorphingAnimation");
    Shiboken::Conversions::registerConverterName(converter, "QMorphingAnimation*");
    Shiboken::Conversions::registerConverterName(converter, "QMorphingAnimation&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DAnimation::QMorphingAnimation).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMorphingAnimationWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DAnimation_QMorphingAnimation_TypeF(), &Sbk_Qt3DAnimation_QMorphingAnimation_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Method'.
    SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_METHOD_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DAnimation_QMorphingAnimation_TypeF(),
        "Method",
        "2:PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.Method",
        "Qt3DAnimation::QMorphingAnimation::Method");
    if (!SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_METHOD_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_METHOD_IDX],
        Sbk_Qt3DAnimation_QMorphingAnimation_TypeF(), "Normalized", (long) Qt3DAnimation::QMorphingAnimation::Method::Normalized))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_METHOD_IDX],
        Sbk_Qt3DAnimation_QMorphingAnimation_TypeF(), "Relative", (long) Qt3DAnimation::QMorphingAnimation::Method::Relative))
        return;
    // Register converter for enum 'Qt3DAnimation::QMorphingAnimation::Method'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_METHOD_IDX],
            Qt3DAnimation_QMorphingAnimation_Method_CppToPython_Qt3DAnimation_QMorphingAnimation_Method);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DAnimation_QMorphingAnimation_Method_PythonToCpp_Qt3DAnimation_QMorphingAnimation_Method,
            is_Qt3DAnimation_QMorphingAnimation_Method_PythonToCpp_Qt3DAnimation_QMorphingAnimation_Method_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHINGANIMATION_METHOD_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QMorphingAnimation::Method");
        Shiboken::Conversions::registerConverterName(converter, "QMorphingAnimation::Method");
        Shiboken::Conversions::registerConverterName(converter, "Method");
    }
    // End of 'Method' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DAnimation_QMorphingAnimation_TypeF(), &::Qt3DAnimation::QMorphingAnimation::staticMetaObject);
    qRegisterMetaType< ::Qt3DAnimation::QMorphingAnimation::Method >("QMorphingAnimation::Method");
    qRegisterMetaType< ::Qt3DAnimation::QMorphingAnimation::Method >("Qt3DAnimation::QMorphingAnimation::Method");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DAnimation_QMorphingAnimation_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DAnimation_QMorphingAnimation_TypeF(), &::Qt3DAnimation::QMorphingAnimation::staticMetaObject, sizeof(QMorphingAnimationWrapper));
}
